/***********************************************************************
 *
 * This file is part of the OnBoard C package.  For more information on 
 * using OnBoard C, see http://groups.yahoo.com/group/onboardc.  For 
 * more information on developing OnBoard C (including submission of 
 * bug reports), see http://sourceforge.net/projects/onboardc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ***********************************************************************/

/*
proc LMUL(a.l, b.l)
beginproc
move.l a(a6),d0
move.l b(a6),d1
movem.l	d2-d3,-(sp)
move.l	d0,d2
swap	d2
mulu.w	d1,d2
move.l	d1,d3
swap	d3
mulu.w	d0,d3
add.w	d3,d2
swap	d2
clr.w	d2
mulu	d1,d0
add.l	d2,d0
movem.l	(sp)+,d2-d3
endproc
*/
unsigned char LMUL_tokenStream [] = {

Token_Proc, Asm_Identifier, 4, 'L', 'M', 'U', 'L', Asm_LeftParen,
		Asm_Identifier, 1, 'a', LongSpec, Asm_Comma,
		Asm_Identifier, 1, 'b', LongSpec, Asm_RightParen,
Token_BeginProc,
Token_Move, LongSpec, Asm_Identifier, 1, 'a', Asm_LeftParen, Token_a6, Asm_RightParen, Asm_Comma, Token_d0,
Token_Move, LongSpec, Asm_Identifier, 1, 'b', Asm_LeftParen, Token_a6, Asm_RightParen, Asm_Comma, Token_d1,
Token_Movem, LongSpec, Token_d2, Asm_Minus, Token_d3, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Move, LongSpec, Token_d0, Asm_Comma, Token_d2,
Token_Swap, Token_d2,
Token_Mulu, WordSpec, Token_d1, Asm_Comma, Token_d2,
Token_Move, LongSpec, Token_d1, Asm_Comma, Token_d3,
Token_Swap, Token_d3,
Token_Mulu, WordSpec, Token_d0, Asm_Comma, Token_d3,
Token_Add, WordSpec, Token_d3, Asm_Comma, Token_d2,
Token_Swap, Token_d2,
Token_Clr, Token_d2,
Token_Mulu, WordSpec, Token_d1, Asm_Comma, Token_d0,
Token_Add, LongSpec, Token_d2, Asm_Comma, Token_d0,
Token_Movem, LongSpec, Asm_LeftParen, Token_a7, Asm_RightParen, Asm_Plus, Asm_Comma, Token_d2, Asm_Minus, Token_d3,
Token_EndProc

};

/*
proc LUDIV(a.l,b.l)
beginproc
move.l a(a6),d0
move.l b(a6),d1
movem.l	d2-d3,-(sp)

move.l	d1,d2

clr.w	d2

swap	d2

bne	L1
move.w	d0,d3
clr.w	d0
swap	d0
beq	L0

divu.w	d1,d0

move.w	d0,d2

swap	d2

L0
move.w	d3,d0
divu.w	d1,d0
move.w	d0,d2
move.l	d2,d0
bra L4

L1
move.w	d0,d2
clr.w	d0
swap	d0
swap	d2
move.l	d1,d3

moveq	#15,d1
L2
add.l	d2,d2
addx.l	d0,d0
cmp.l	d3,d0
bcs	L3
sub.l	d3,d0
addq.b	#1,d2
L3
dbra	d1,L2
move.l	d2,d0
L4
movem.l	(sp)+,d2-d3
endproc
*/

unsigned char LUDIV_tokenStream [] = {

Token_Proc, Asm_Identifier, 5, 'L', 'U', 'D', 'I', 'V', Asm_LeftParen,
		Asm_Identifier, 1, 'a', LongSpec, Asm_Comma,
		Asm_Identifier, 1, 'b', LongSpec, Asm_RightParen,
Token_BeginProc,
Token_Move, LongSpec, Asm_Identifier, 1, 'a', Asm_LeftParen, Token_a6, Asm_RightParen, Asm_Comma, Token_d0,
Token_Move, LongSpec, Asm_Identifier, 1, 'b', Asm_LeftParen, Token_a6, Asm_RightParen, Asm_Comma, Token_d1,
Token_Movem, LongSpec, Token_d2, Asm_Minus, Token_d3, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Move, LongSpec, Token_d1, Asm_Comma, Token_d2,
Token_Clr, WordSpec, Token_d2,
Token_Swap, Token_d2,
Token_Bne,	Asm_Identifier, 2, 'L', '1',
Token_Move, WordSpec, Token_d0, Asm_Comma, Token_d3,
Token_Clr, WordSpec, Token_d0,
Token_Swap, Token_d0,
Token_Beq,	Asm_Identifier, 2, 'L', '0',
Token_Divu,	WordSpec, Token_d1, Asm_Comma, Token_d0,
Token_Move, WordSpec, Token_d0, Asm_Comma, Token_d2,
Token_Swap, Token_d2,
Asm_Identifier, 2, 'L', '0',
Token_Move, WordSpec, Token_d3, Asm_Comma, Token_d0,
Token_Divu,	WordSpec, Token_d1, Asm_Comma, Token_d0,
Token_Move, WordSpec, Token_d0, Asm_Comma, Token_d2,
Token_Move, LongSpec, Token_d2, Asm_Comma, Token_d0,
Token_Bra, 	Asm_Identifier, 2, 'L', '4',
Asm_Identifier, 2, 'L', '1',
Token_Move, WordSpec, Token_d0, Asm_Comma, Token_d2,
Token_Clr, WordSpec, Token_d0,
Token_Swap, Token_d0,
Token_Swap, Token_d2,
Token_Move, LongSpec, Token_d1, Asm_Comma, Token_d3,
Token_Moveq, Asm_Number, Asm_Digit, 0, 0, 0, 15, Asm_Comma, Token_d1,
Asm_Identifier, 2, 'L', '2',
Token_Add, LongSpec, Token_d2, Asm_Comma, Token_d2,
Token_Addx, LongSpec, Token_d0, Asm_Comma, Token_d0,
Token_Cmp, LongSpec, Token_d3, Asm_Comma, Token_d0,
Token_Bcs, Asm_Identifier, 2, 'L', '3',
Token_Sub, LongSpec, Token_d3, Asm_Comma, Token_d0,
Token_Addq, ByteSpec, Asm_Number, Asm_Digit, 0, 0, 0, 1, Asm_Comma, Token_d2,
Asm_Identifier, 2, 'L', '3',
Token_Dbra,	Token_d1, Asm_Comma, Asm_Identifier, 2, 'L', '2',
Token_Move, LongSpec, Token_d2, Asm_Comma, Token_d0,
Asm_Identifier, 2, 'L', '4',
Token_Movem, LongSpec, Asm_LeftParen, Token_a7, Asm_RightParen, Asm_Plus, Asm_Comma, Token_d2, Asm_Minus, Token_d3,
Token_EndProc

};

/*
proc LDIV(a.l, b.l)
beginproc
move.l a(a6),d0
move.l b(a6),d1
tst.l	d0
bge	L1
neg.l	d0
tst.l	d1
bge	L2
neg.l	d1
move.l d1,-(a7)
move.l d0,-(a7)
jsr	LUDIV(pc)
addq #8,a7
bra L3 

L1
tst.l	d1
blt L4
move.l d1,-(a7)
move.l d0,-(a7)
jsr	LUDIV(pc)
addq #8,a7
bra L3
L4
neg.l	d1

L2
move.l d1,-(a7)
move.l d0,-(a7)
jsr	LUDIV(pc)
addq #8,a7
neg.l	d0

L3
endproc
*/
unsigned char LDIV_tokenStream [] = {

Token_Proc, Asm_Identifier, 4, 'L', 'D', 'I', 'V', Asm_LeftParen,
		Asm_Identifier, 1, 'a', LongSpec, Asm_Comma,
		Asm_Identifier, 1, 'b', LongSpec, Asm_RightParen,
Token_BeginProc,
Token_Move, LongSpec, Asm_Identifier, 1, 'a', Asm_LeftParen, Token_a6, Asm_RightParen, Asm_Comma, Token_d0,
Token_Move, LongSpec, Asm_Identifier, 1, 'b', Asm_LeftParen, Token_a6, Asm_RightParen, Asm_Comma, Token_d1,
Token_Tst, LongSpec, Token_d0,
Token_Bge, Asm_Identifier, 2, 'L', '1',
Token_Neg, LongSpec, Token_d0,
Token_Tst, LongSpec, Token_d1,
Token_Bge, Asm_Identifier, 2, 'L', '2',
Token_Neg, LongSpec, Token_d1,
Token_Move, LongSpec, Token_d1, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Move, LongSpec, Token_d0, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Jsr, Asm_Identifier, 5, 'L', 'U', 'D', 'I', 'V', Asm_LeftParen, Token_PC, Asm_RightParen,
Token_Addq, Asm_Number, Asm_Digit, 0, 0, 0, 8, Asm_Comma, Token_a7,
Token_Bra, Asm_Identifier, 2, 'L', '3',
Asm_Identifier, 2, 'L', '1',
Token_Tst, LongSpec, Token_d1,
Token_Blt, Asm_Identifier, 2, 'L', '4',
Token_Move, LongSpec, Token_d1, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Move, LongSpec, Token_d0, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Jsr, Asm_Identifier, 5, 'L', 'U', 'D', 'I', 'V', Asm_LeftParen, Token_PC, Asm_RightParen,
Token_Addq, Asm_Number, Asm_Digit, 0, 0, 0, 8, Asm_Comma, Token_a7,
Token_Bra, Asm_Identifier, 2, 'L', '3',
Asm_Identifier, 2, 'L', '4',
Token_Neg, LongSpec, Token_d1,
Asm_Identifier, 2, 'L', '2',
Token_Move, LongSpec, Token_d1, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Move, LongSpec, Token_d0, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Jsr, Asm_Identifier, 5, 'L', 'U', 'D', 'I', 'V', Asm_LeftParen, Token_PC, Asm_RightParen,
Token_Addq, Asm_Number, Asm_Digit, 0, 0, 0, 8, Asm_Comma, Token_a7,
Token_Neg, LongSpec, Token_d0,
Asm_Identifier, 2, 'L', '3',
Token_EndProc

};

/*
proc LREM(a.l,b.l)
beginproc
move.l	a(a6),d0
move.l	b(a6),d1
tst.l	d1
bge		L1
neg.l	d1
L1
tst.l	d0
blt		L2
move.l d1,-(a7)
move.l d0,-(a7)
jsr		LUREM(pc)
addq #8,a7
bra		L3
L2
neg.l	d0
move.l d1, -(a7)
move.l d0,-(a7)
jsr		LUREM(pc)
addq #8, a7
neg.l	d0
L3
endproc
*/

unsigned char LREM_tokenStream [] = {

Token_Proc, Asm_Identifier, 4, 'L', 'R', 'E', 'M', Asm_LeftParen,
		Asm_Identifier, 1, 'a', LongSpec, Asm_Comma,
		Asm_Identifier, 1, 'b', LongSpec, Asm_RightParen,
Token_BeginProc,
Token_Move, LongSpec, Asm_Identifier, 1, 'a', Asm_LeftParen, Token_a6, Asm_RightParen, Asm_Comma, Token_d0,
Token_Move, LongSpec, Asm_Identifier, 1, 'b', Asm_LeftParen, Token_a6, Asm_RightParen, Asm_Comma, Token_d1,
Token_Tst, LongSpec, Token_d1,
Token_Bge, Asm_Identifier, 2, 'L', '1',
Token_Neg, LongSpec, Token_d1,
Asm_Identifier, 2, 'L', '1',
Token_Tst, LongSpec, Token_d0,
Token_Blt, Asm_Identifier, 2, 'L', '2',
Token_Move, LongSpec, Token_d1, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Move, LongSpec, Token_d0, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Jsr, Asm_Identifier, 5, 'L', 'U', 'R', 'E', 'M', Asm_LeftParen, Token_PC, Asm_RightParen,
Token_Addq, Asm_Number, Asm_Digit, 0, 0, 0, 8, Asm_Comma, Token_a7,
Token_Bra, Asm_Identifier, 2, 'L', '3',
Asm_Identifier, 2, 'L', '2',
Token_Neg, LongSpec, Token_d0,
Token_Move, LongSpec, Token_d1, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Move, LongSpec, Token_d0, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Jsr, Asm_Identifier, 5, 'L', 'U', 'R', 'E', 'M', Asm_LeftParen, Token_PC, Asm_RightParen,
Token_Addq, Asm_Number, Asm_Digit, 0, 0, 0, 8, Asm_Comma, Token_a7,
Token_Neg, LongSpec, Token_d0,
Asm_Identifier, 2, 'L', '3',
Token_EndProc

};

/*
proc LUREM(a.l,b.l)
beginproc
move.l	a(a6),d0
move.l	b(a6),d1
movem.l	d2-d3,-(sp)
move.l	d1,d2
clr.w	d2
swap	d2
bne		L1
move.w	d0,d3
clr.w	d0
swap	d0
beq		L2
divu.w	d1,d0
move.w	d0,d2
swap	d2
L2
move.w	d3,d0
divu.w	d1,d0
clr.w	d0
swap	d0
bra		L5
L1
move.w	d0,d2
clr.w	d0
swap	d0
swap	d2
move.l	d1,d3
moveq	#15,d1
L3
add.l	d2,d2
addx.l	d0,d0
cmp.l	d3,d0
bcs		L4
sub.l	d3,d0
L4
dbra	d1,L3
L5
movem.l	(sp)+,d2-d3
endproc
*/

unsigned char LUREM_tokenStream [] = {

Token_Proc, Asm_Identifier, 5, 'L', 'U', 'R', 'E', 'M', Asm_LeftParen,
		Asm_Identifier, 1, 'a', LongSpec, Asm_Comma,
		Asm_Identifier, 1, 'b', LongSpec, Asm_RightParen,
Token_BeginProc,
Token_Move, LongSpec, Asm_Identifier, 1, 'a', Asm_LeftParen, Token_a6, Asm_RightParen, Asm_Comma, Token_d0,
Token_Move, LongSpec, Asm_Identifier, 1, 'b', Asm_LeftParen, Token_a6, Asm_RightParen, Asm_Comma, Token_d1,
Token_Movem, LongSpec, Token_d2, Asm_Minus, Token_d3, Asm_Comma, Asm_Minus, Asm_LeftParen, Token_a7, Asm_RightParen,
Token_Move, LongSpec, Token_d1, Asm_Comma, Token_d2,
Token_Clr, WordSpec, Token_d2,
Token_Swap, Token_d2,
Token_Bne,	Asm_Identifier, 2, 'L', '1',
Token_Move, WordSpec, Token_d0, Asm_Comma, Token_d3,
Token_Clr, WordSpec, Token_d0,
Token_Swap, Token_d0,
Token_Beq,	Asm_Identifier, 2, 'L', '2',
Token_Divu,	WordSpec, Token_d1, Asm_Comma, Token_d0,
Token_Move, WordSpec, Token_d0, Asm_Comma, Token_d2,
Token_Swap, Token_d2,
Asm_Identifier, 2, 'L', '2',
Token_Move, WordSpec, Token_d3, Asm_Comma, Token_d0,
Token_Divu,	WordSpec, Token_d1, Asm_Comma, Token_d0,
Token_Clr, WordSpec, Token_d0,
Token_Swap, Token_d0,
Token_Bra, 	Asm_Identifier, 2, 'L', '5',
Asm_Identifier, 2, 'L', '1',
Token_Move, WordSpec, Token_d0, Asm_Comma, Token_d2,
Token_Clr, WordSpec, Token_d0,
Token_Swap, Token_d0,
Token_Swap, Token_d2,
Token_Move, LongSpec, Token_d1, Asm_Comma, Token_d3,
Token_Moveq, Asm_Number, Asm_Digit, 0, 0, 0, 15, Asm_Comma, Token_d1,
Asm_Identifier, 2, 'L', '3',
Token_Add, LongSpec, Token_d2, Asm_Comma, Token_d2,
Token_Addx, LongSpec, Token_d0, Asm_Comma, Token_d0,
Token_Cmp, LongSpec, Token_d3, Asm_Comma, Token_d0,
Token_Bcs, Asm_Identifier, 2, 'L', '4',
Token_Sub, LongSpec, Token_d3, Asm_Comma, Token_d0,
Asm_Identifier, 2, 'L', '4',
Token_Dbra,	Token_d1, Asm_Comma, Asm_Identifier, 2, 'L', '3',
Asm_Identifier, 2, 'L', '5',
Token_Movem, LongSpec, Asm_LeftParen, Token_a7, Asm_RightParen, Asm_Plus, Asm_Comma, Token_d2, Asm_Minus, Token_d3,
Token_EndProc

};


