
/*****************************************************************************
**.doc+
**	File:		args.h
**	Author:		Wade Guthrie
**	Created:
**
**	Description:	
**
**	Used by:
**			hmon
**
**.doc-
**		COPYRIGHT 1992-1995 ROCKWELL INTERNATIONAL CORPORATION
**			ALL RIGHTS RESERVED
*****************************************************************************/

#ifndef ARGS_H
#define ARGS_H

#include	"general.h"	// For Yes

typedef enum ArgStatus
{
	ARG_STAT_OKAY,
	ARG_STAT_INTERNAL_ERROR,	/* some pointer got hosed */
	ARG_STAT_GENERAL_ERROR,		/* the 'doit' func returned error */
	ARG_STAT_NEED_PARAM,		/* an arg needs a parameter */
	ARG_STAT_UNKNOWN_ARG,		/* args contain unknown arg */
	ARG_STAT_NEEDS_ARG,		/* there was a hypen without an arg */
	ARG_STAT_MALFORMED_TYPES,	/* arg TYPE list is messed up */
	ARG_STAT_MALFORMED_ARGS		/* arg list is messed up */
} ArgStatus;

typedef enum OptUsage
{
	ARG_NONE, 
	ARG_STRING_OPT, 
	ARG_INT_OPT, 
	ARG_LONG_OPT,
	ARG_SET_FLAG,
	ARG_PRINT_HELP
} OptUsage;

typedef struct ArgumentType {
	char const * const	longname;	/* "--xxxxx" opts, NULL ok */
	char			shortname;	/* "-x" options, may be '\0' */
	OptUsage		optinfo;	/* what to do with parameter */
	void			*opt;		/* fill based on optinfo */
	YesNo			(*func)(void *);	
						/* call if != 0  -- NULL ok 
						 * returns Yes on success, No
						 * on failure */
	char const * const	documentation;	/* what opt means -- NULL ok */
} ArgumentType ;

/*
 * For those who like it done AUTOMATICALLY
 */

ArgStatus	ArgsParse	(ArgumentType	*argType,
				 int		argCount,
				 char		**argVector);

void		ArgsPrintHelp	(ArgumentType	*argType);
void		ArgsPrintError	(ArgStatus	status);

/*
 * For those who like to DO IT THEMSELVES
 */

void		ArgsReset	(void);

char		*ArgsGetArg	(int		ArgCount, 
				 char		**ArgVector, 
				 ArgStatus	*ErrorFlag);

char		*ArgsGetParam	(int		ArgCount, 
				 char		**ArgVector);

ArgStatus	ArgsHandleType	(char const	*arg,
				 ArgumentType	*argType,
				 ArgumentType	*typeList,
				 int		argc,
				 char		**argv);


#endif /* ARGS_H */
