#ifndef WDG_DEBUG_H
#define WDG_DEBUG_H

//#define FULL_ERROR_CHECKING	1

/*
 *	File:		debug.h
 *	Author:		Wade Guthrie
 *	Date:		22-November-95
 *
 *	Description:	These definitions are needed for programs that need to 
 *			be debugged
 *
 *			COPYRIGHT 1995 ROCKWELL INTERNATIONAL CORPORATION
 *			ALL RIGHTS RESERVED
 */

#define	DEBUG_ALWAYS		0
#define	DEBUG_DRYRUN		4
#define	DEBUG_TRIVIAL		9
#define	DEBUG_MODERATE		19
#define	DEBUG_EXTENSIVE		29
#define DEBUG_INTENSE		39
#define	DEBUG_RIDICULOUS	49
#define	DEBUG_ALL_CALLS		59
#define	DEBUG_INSANE		69	/* for library functions */

#define	logPrintf(x)	debug_printf x	// this doesn't get NDEBUGged-away

#ifdef NDEBUG
#	define	debugPrintf(x)
#	define	DEBUG_IN(level)	
#	define	DEBUG_CMD_IN(level)
#	define	DEBUG_CTOR_IN(level)	
#	define	DEBUG_DTOR_IN(level)	
#	define	DEBUG_INIT_IN(level)	
#	define	DEBUG_DEINIT_IN(level)	
#	define	DEBUG_OUT(level)

#	define	ignore(x)
#else
#	define	debugPrintf(x)		debug_printf x
#	define	DEBUG_IN(level)		debug_printf ((level),	\
		"\n>> Entering %s\n",FUNCTION);
					/* reset_time(FUNCTION, level); */
#	define	DEBUG_CMD_IN(level)		debug_printf ((level),	\
		"\n+------------------------"				\
		"\n| Entering %s\n",FUNCTION);
					/* reset_time(FUNCTION, level); */
#	define	DEBUG_CTOR_IN(level)	debug_printf ((level),	\
		"\n==>> Constructing %s (%p)\n",FUNCTION, _this);
					/* reset_time(FUNCTION, level); */
#	define	DEBUG_DTOR_IN(level)	debug_printf ((level),	\
		"\n<<== Destructing %s (%p)\n",FUNCTION, _this);
					/* reset_time(FUNCTION, level); */
#	define	DEBUG_INIT_IN(level)	debug_printf ((level),	\
		"\n-->> Initializing %s (%p)\n",FUNCTION, _this);
					/* reset_time(FUNCTION, level); */
#	define	DEBUG_DEINIT_IN(level)	debug_printf ((level),	\
		"\n<<-- De-Initializing %s (%p)\n",FUNCTION, _this);
					/* reset_time(FUNCTION, level); */
#	define	DEBUG_OUT(level)	debug_printf ((level),	\
		"<< Leaving %s\n\n",FUNCTION);

#	define	ignore(x)	doIgnore((const int)(x));
#endif

#ifdef USING_CPP
	extern "C" {
#endif

void	initializeDebug (	char	*name, 
				char	*debugMode,	// "w" or "a"
				int	newDebugLevel,
				int	newWarningLevel);

int	getErrorCount (void);
int	getWarningCount (void);
void	printDebugTally (void);

void	finishDebug (void);

int	getDebugLevel (void);
void	setDebugLevel (		int	newDebugLevel);

int	getWarningLevel (void);
void	setWarningLevel (	int	newLevel);

void	debug_printf (		int	debugThreshold, 
				char	*format, ...);

char	*buildError (		char	*format, ...);
void	errorPrintf (		char	*format, ...);

char	*buildWarning (		int	warningThreshold,
				char	*format, ...);
void	warningPrintf (		int	warningThreshold,
				char	*format, ...);
void	doIgnore		(const int x);
FILE	*openNewFile		(char	*filename, 
				 char	*mode);

#ifdef USING_CPP
	};
#endif

#endif	/* WDG_DEBUG_H */
