#!/usr/bin/perl -w
#
# Quick script to extract the actual data part of a Palm PDB file.
# Takes input from a specified file and outputs to stdout by default
#
# Really a very dirty way to do this. Use other tools instead. Please.
# For the sake of the children...
#
# Really annoying problem with line-ends under cygwin. Works fine in GNU/Linux
# Problem is with perl/print adding \x0d in front of \x0a sequences. 
# Seems to occur during the final print, and I can't seem to stop it!
# Even switching the output handle to binmode doesn't solve it.
# If you find a way to fixe it, let me know!!
#
# S. Little (boz_x@sourceforge.net)
# 29/07/03
#

use strict;

my @aRecordIDs; # contains the offsets of all the records in the DB

if(@ARGV < 1){
    print STDERR "Usage:\n\textract_pdb.pl (> <filename>)\n\n";
    exit;
}
sub read_header($)
{
    my ($sHeader)=@_;

    my $sFilename = unpack ("a[32]",$sHeader);
# 0x20
    my ($sAttr,$sVer) = unpack("x[32] n n",$sHeader);
# 0x24
    my ($sCreationDate, $sModificationDate) = unpack("x[36] N N",$sHeader);
# 0x2C
    my ($sLastBackupDate, $sModificationNum)= unpack("x[44] N N",$sHeader);
# 0x34
    my ($sAppInfoID, $sSortInfoID) = unpack("x[52] N N", $sHeader);
# 0x3C
    my ($sType, $sCreator) = unpack("x[60] a4 a4", $sHeader);
# 0x44
    my ($sUIDseed) = unpack("x[68] N",$sHeader);
    
    print STDERR "filename         = '$sFilename'\n";
    print STDERR "attributes       = '$sAttr'\n";
    print STDERR "version          = '$sVer'\n";
    print STDERR "creationDate     = '$sCreationDate'\n";
    print STDERR "modificationDate = '$sModificationDate'\n";
    print STDERR "lastBackupDate   = '$sLastBackupDate'\n";
    print STDERR "modificationNum  = '$sModificationNum'\n";
    print STDERR "appInfoID        = '$sAppInfoID'\n";
    print STDERR "sortInfoID       = '$sSortInfoID'\n";
    print STDERR "type             = '$sType'\n";
    print STDERR "creator          = '$sCreator'\n";
    print STDERR "UIDseed          = '$sUIDseed'\n";
}

sub read_record_lists($$)
{
    my ($sOffset, $sData) = @_;
    my ($sNextList,$sNumRecs) = unpack("x[$sOffset] N n",$sData);

    print STDERR "$sNumRecs records found!\n";

    for(my $i=0;$i<$sNumRecs;$i++){
	my $sIDOffset = $sOffset+6+($i*8); # a record entry struct is 8 bytes
	                                   # with 32bit ID
	my $sID = unpack("x[$sIDOffset] N",$sData);
	push @aRecordIDs, $sID; # stick the offset into our array
    }

    if($sNextList != 0){
	die ("Not supporting multiple record lists!");
    }
}

sub read_app_info_block()
{

}

sub read_sort_info_block()
{

}

sub read_data($$$)
{
    my ($sStartOffset, $sEndOffset, $sData) = @_;
    my $sLen = $sEndOffset - $sStartOffset;
    print STDERR "start:  $sStartOffset\n";
    print STDERR "end:    $sEndOffset\n";
    print STDERR "length: $sLen\n";

    my $sRecord = unpack ("x[$sStartOffset] a[$sLen]",$sData);

    return $sRecord;
}

sub read_remaining_data($$)
{
    my ($sStartOffset, $sData) = @_;
    print STDERR "start: $sStartOffset\n";
    
    my $sRecord = unpack ("x[$sStartOffset] a*",$sData);

    return $sRecord;
}

my $sPDBData;

my $sPDBFile = shift;

open INPUT, "<$sPDBFile" or die "Couldn't open PDB '$sPDBFile': $!";

binmode STDOUT;
binmode INPUT;

undef $/;
while(<INPUT>){
    $sPDBData .= $_;
}

my $sHeader = unpack ("a72",$sPDBData);
read_header($sHeader);

# 0x48
my ($sNextRecordList, $sNumRecs) = unpack("x[72] N n", $sPDBData);

print STDERR "'$sNextRecordList', '$sNumRecs'\n";
read_record_lists(72,$sPDBData);

for (my $i=0; $i<(scalar @aRecordIDs); $i++){
    my $sID = $aRecordIDs[$i];
    print STDERR "\n*****************\nRecord $i:\n*****************\n";
    if($i<((scalar @aRecordIDs)-1)){
	print read_data($sID,$aRecordIDs[$i+1],$sPDBData);
    } else {
	print read_remaining_data($sID,$sPDBData);
    }
}

close INPUT or die "closing input: $!";
