#ifndef GENERAL_H
#define GENERAL_H

/*
 *	File:		general.h
 *	Author:		Wade Guthrie
 *	Date:		22-November-95
 *
 *	Description:	These are definitions that every program needs
 *
 *			COPYRIGHT 1995 ROCKWELL INTERNATIONAL CORPORATION
 *			ALL RIGHTS RESERVED
 */

#include <stdlib.h>	// for rand

typedef unsigned char		YesNo;
typedef	char			tInt8;
typedef	unsigned char		tIntU8;
typedef	unsigned short		tIntU16;
typedef	unsigned long		tIntU32;
typedef unsigned char		tBool;

#ifndef FALSE
#	define	FALSE		((YesNo) 0)
#endif
#ifndef No
#	define	No		((YesNo) 0)
#endif

#ifndef TRUE
#	define	TRUE		((YesNo) 1)
#endif
#ifndef Yes
#	define	Yes		((YesNo) 1)
#endif

#define	ON			((YesNo) 1)
#define	OFF			((YesNo) 0)

#define	ESC			0x1b
#define	SPACE			0x20
#define NULLchar		'\0'

#define	SafeChar(c)		(((c)==0) ? "Null" : (c))
#define ArrayLen(a)		(sizeof(a)/sizeof((a)[0]))
#define max(a,b)		((a>b) ? a : b)

// actually, the following is from 0 to (x-1)
#define RandomFrom0to(x)	(((float) (x) * rand ()) / (RAND_MAX+1.0))

#define FILE_NAME_SIZE		32

/*
 * stuff for sherpa
 */

FILE	*openNewFile (char *filename, char *mode);

typedef enum FlagIndex			// Sherpa's command-line flags
{
	FlagGotHelp,
	FlagDryRun,
	FlagBuildMakefile,
	FlagOverwriteFile,
	FlagFixInclude,
	FlagIndexCount
} FlagIndex;

YesNo		isTrue		(FlagIndex	aIndex);

#endif	/* GENERAL_H */
