/***********************************************************************
 *
 *   LED/SrcEdit is free software as specified in the GNU General public License
 *   listed in the file COPYING or http://www.gnu.org/licenses/gpl.txt
 *
 ***********************************************************************/

#ifndef __OBC__
#include <PalmOS.h>
#include <PalmCompatibility.h>
#endif

#include "LedGlobals.h"

#ifdef INCLUDE_UNUSED
typedef struct LedAppInfoType {
    Byte replaceme;
} LedAppInfoType;
#endif

/******************************************************************************
 * Module (static) Variables
 ******************************************************************************/
static Boolean gFirstStart = true;
static Boolean gKillNextKeyDownEvent = false;

ButtonDispatch functionList[FunctionCount] = {
    nullButton,
    doCut,
    doCopy,
    doPaste,
    doUndo,
//  doSearch,
    doFindReplace,
    doSearchAgain,
    doLaunchOnBoardC,
    doBlockShiftLeft,
    doBlockShiftRight,
//  doTabSize,   **new interface 4/22/2002: these items have been moved to menus or the popup menu**
//  doToggleForward,
//  doToggleBackward,
//  doAutoParen,
    doKeywordCompletion,
    doFunctionList,
    doFindFunctionHeader,
    doToolsPopup,
    doMRUPopup
};


/******************************************************************************
 * Function Prototypes
 ******************************************************************************/
Boolean adjustXOrigin();
void checkScreenXState(void); // #895637 grey out Left/Right arrows
void clearBlinkingCursor();
Boolean doCopy();
Boolean doCut();
Boolean doPaste();
Boolean isBlinkOnScreen();
static void loadSystraps();
void redrawPage();
void refillBuffer();
void resetBufferToSelection();
void scrollLeft(SelectionRange *currentSelection, Word offset);
void scrollRight(SelectionRange *currentSelection, int offset);
void scrollScreen(UInt8 screenScrollDirection);
void setBlinkCharacter();
IndexedColorType(*SetTextColor)(IndexedColorType);
IndexedColorType __SetTextColor30__(IndexedColorType col);
IndexedColorType __SetTextColor35__(IndexedColorType col);



void checkScreenXState(void)
{
        // #895637 grey out Left/Right arrows
        /* This function checks the state of the screenX value
        and greys out the appropraiate arrow if needed */

        FormPtr frmP = FrmGetActiveForm();
        ControlPtr ctlLeftP = (ControlPtr)getObjectPtr(frmP, MainScrollLeftRepeating);
        ControlPtr ctlRightP = (ControlPtr)getObjectPtr(frmP, MainScrollRightRepeating);
        CharPtr label;

        if (gRomVersion < version32) // No Changes for OS pre 3.2
            return;

        if(screenXOrigin > 0){
            // Normal left arrow
            label = (char*)CtlGetLabel(ctlLeftP);
            label[0] = symbol11LeftArrow;
            CtlSetUsable(ctlLeftP, true); // usable has to go first
            CtlSetLabel(ctlLeftP, label);
        }
        if (screenXOrigin < (UInt16)((DocumentWidth - PageWidth) - 5)){
            label = (char*)CtlGetLabel(ctlRightP);
            // Normal right arrow
            label[0] = symbol11RightArrow;
            CtlSetUsable(ctlRightP, true); // usable has to go first
            CtlSetLabel(ctlRightP, label);
       }
        if(screenXOrigin < 1){
            // Grey out left arrow
            // Works only with PalmOS>=3.2
            label = (char*)CtlGetLabel(ctlLeftP);
            label[0] = symbol11LeftArrowDisabled;
            CtlSetLabel(ctlLeftP, label);
            CtlSetUsable(ctlLeftP, false);
            return;
        }
        else if (screenXOrigin > (UInt16)((DocumentWidth - PageWidth) - 5)){
            // Grey out Right arrow
            // Works only with PalmOS>=3.2
            label = (char*)CtlGetLabel(ctlRightP);
            label[0] = symbol11RightArrowDisabled;
            CtlSetLabel(ctlRightP, label);
            CtlSetUsable(ctlRightP, false);
            return;
        }
}

Boolean adjustXOrigin()
{
    if (gCurrentSelection.startOffset < screenXOrigin) {
        if (gCurrentSelection.startOffset > 10) {
            screenXOrigin = gCurrentSelection.startOffset - 10;
        }
        else {
            screenXOrigin = 0;
        }
        if (screenXOrigin > (UInt16)(DocumentWidth - PageWidth)) {
            screenXOrigin = 0;
        }
        checkScreenXState();    // #895637 grey out Left/Right arrows
        return true;
    }
    else {
        if (gCurrentSelection.startOffset >= (screenXOrigin + PageWidth)) {
            if (gCurrentSelection.startOffset > (UInt16)(PageWidth - 10)) {
                screenXOrigin = gCurrentSelection.startOffset - (PageWidth - 10);
            }
            else {
                screenXOrigin = DocumentWidth - PageWidth;
            }
            if (screenXOrigin > (UInt16)(DocumentWidth - PageWidth)) {
                screenXOrigin = (DocumentWidth - PageWidth);
                // screenXOrigin = 0;
            }
            checkScreenXState();    // #895637 grey out Left/Right arrows
            return true;
        }
        // X>160 Dana Screen BUG?
    }
    return false;
}

/***********************************************************************
 *
 * FUNCTION:     AppStart
 *
 * DESCRIPTION:  Get the current application's preferences.
 *
 * PARAMETERS:   nothing
 *
 * RETURNED:     Err value 0 if nothing went wrong
 *
 * REVISION HISTORY: ...
 *                   #624273 (S033) Restoring GrfState when quiting SrcEdit: John Wilund, Dec 16, 2003
 *                   #846293 (S046) pick highlight mode based on file extension: John Wilund, Jan 11, 2004
 *                   #870770 prevent Tungsten T3 from starting in b/w mode: John Wilund, Feb 12, 2004
                     #   Alphasmart Dana Screen
                     #846728 (S016) External Keyboard Support: John Wilund, Apr 25, 2004
                     #   HiRes Support Lite; John Wilund, Apr 26, 2004
 ***********************************************************************/

static Err AppStart(void)
{
    Word length = NULL;
    UInt32 nd = NULL; //new code 03/25/02

    UInt32 danaversion = NULL;

    UInt32 width = 160;  // Assigned a value to avoid read and writes to low memory at the Alphasmart Dana
    UInt32 height = 160; // Assigned a value to avoid read and writes to low memory at the Alphasmart Dana

	RctSetRectangle (&gClipRect, PageXOrigin, PageYOrigin, PageWidth, PageHeight);
	RctSetRectangle (&gFullScreen, 0, 0, 160, 160);

    #ifdef HIRES_SUPPORT
        UInt32 winVersion = NULL;  // HiRes support
        UInt32 screenAttr = NULL;  // HiRes support
    #endif

    if (!initText()) {
        error("InitText failed");
        return (Err)-1;
    }

    // Store GrfState
    Boolean capsLock = NULL;
    Boolean numLock = NULL;
    UInt16 tempShift = NULL;
    Boolean autoShifted = NULL;
    GrfGetState(&capsLock, &numLock, &tempShift, &autoShifted);
    gGrfComprStoredState = (capsLock * 0x04) + (numLock * 0x02) + autoShifted;
    // Reset GrfState
    GrfSetState(false, false, false);

    LedPreferenceType prefs;
    Word prefsSize;

    // Read the saved preferences / saved-state information.
    prefsSize = sizeof(LedPreferenceType);
    if ((PrefGetAppPreferences(appFileCreator, appPrefID, &prefs, &prefsSize, true) !=  noPreferenceFound)
            && (prefsSize == sizeof(LedPreferenceType))) {
        MemMove(gFileList, prefs.fileList, MAX_FILES * dmDBNameLength);
        gFileListCount = prefs.fileListCount;

        StrCopy(gCurrentFile, prefs.dbName);
        for (int i = 0; i < ToolbarEntries; i++) {
        //  StrCopy(gToolbar[i].key, prefs.toolbarSetting[i].key);
        //  gToolbar[i].font = prefs.toolbarSetting[i].font;
            gToolbar[i].handlerIndex = prefs.toolbarSetting[i].handlerIndex;
        }
        for (int i = 0; i < MAX_SAVED_DB; i++) {
            g_dbSaveData[i] = prefs.dbSaveData[i];
        }
        gCurFile = prefs.curFile;
        gCurrentFont = (FontID)prefs.currentFont; // 04/24/2002
        gColorMode = prefs.colorMode; // 04/28/2002
        ictCommentsSaved = prefs.commentsSaved;  // 04/29/2002
        ictKeywordsSaved = prefs.keywordsSaved;
        // gHTMLmode = prefs.HTMLmode; // 04/29/2002
        gHighlightMode = prefs.HighlightMode;  // 01/09/2003
        gKbSup_SupportedKeyboard = prefs.SupportedKeyboard; // #846728 (S016) External Keyboard Support
        setHardKeysScrollingValues(prefs.hardKeysScrollValues); // #846292 (S051) Use hard buttons to scroll
        gUseTabForTab = prefs.useTabForTab;    // #847961 (S061) Add Tab/Spaces option
        gTabWidth = prefs.tabWidth;
        gTabSpaces = prefs.tabSpaces;          // #847961 (S061) Add Tab/Spaces option
        gAutoParen = prefs.autoParen;
        gCommentLines = prefs.commentLines;
    }
    else {
        gCurFile = -1;

        // #870770 SrcEdit (Tungsten T3): enable color if color is present on All devices
        WinScreenMode(winScreenModeGet,NULL,NULL,&nd,NULL);
        if(nd>=8){
            gColorMode = prefs.colorMode = true;
            ictCommentsSaved = prefs.comments = 0x77;  // red
            ictKeywordsSaved = prefs.keywords = ictKeywords;  // blue
        }
    }
    /*********************************************/
/*
    WinScreenMode (winScreenModeGet, &width, &height, NULL, NULL);
    if (width == 560)
        gIsWideDana = true;
    PageWidth = width - WIDTH_OFFSET;
    DocumentWidth = PageWidth;
    PageHeight = height - HIGHT_OFFSET;
*/
    // new code 04/23/02
    // changed 04/26/04: Hi Res
    MemHandle fontH = NULL;
    if (gCurrentFont ==(int)129) {

    #ifdef HIRES_SUPPORT
        if (FtrGet(sysFtrCreator, sysFtrNumWinVersion, &winVersion) ==0){
            if (winVersion>=4){ // HiRes feature is available...
                WinScreenGetAttribute(winScreenDensity, &screenAttr);
                if (screenAttr == kDensityDouble) { //the screen is double density
                    fontH = DmGetResource('nfnt', 1001);
                }
            }
        }
        if (fontH == NULL)
      #endif
            fontH = DmGetResource('NFNT', 1000);
        FontType *fontP;
        fontP = (FontType*)MemHandleLock(fontH);
        fntAppCustomBase = (FontID)129; // next, set = gCurrentFont for other fonts
        FntDefineFont(fntAppCustomBase, fontP);
        MemHandleUnlock(fontH);
        FntSetFont ( fntAppCustomBase );
        FontHeight = FntCharHeight(); //7; was 11;
        FontDescender = FntDescenderHeight(); // 1; was 2;
        LinesPerPage = 143/FontHeight; // 20; was 13;
        BlinkingCursorHeight = FontHeight -1; //6; was 9;
        BlinkingCursorTopOffset = 0; // was 1
        PageHeight = FontHeight*LinesPerPage; // was 140;
        gClipRect.extent.y = PageHeight;
    } else {    // Just in case we switch back the the former font (compatibility with OS 3.1)
        FntSetFont (stdFont);
        FontHeight = FntCharHeight();// was 11;
        FontDescender = FntDescenderHeight(); //was 2;
        LinesPerPage = 143/FontHeight;// was 13;
        BlinkingCursorHeight = FontHeight-2; // was 9;
        BlinkingCursorTopOffset = 1;
        PageHeight = FontHeight*LinesPerPage;// was 143;
        gClipRect.extent.y = PageHeight;
    }
/*
    RctSetRectangle (&gClipRect, PageXOrigin, PageYOrigin, PageWidth, PageHeight);
    RctSetRectangle (&gFullScreen, 0, 0, width, height);
*/
    unsigned short err;
    /*if (gRomVersion < version35) { //changed this to give screen depth support for pre-3.5 monochrome Palms 05/16/02 // does not work for < v3.5 because no BmpCreate
        //gOffscreenPage = WinCreateOffscreenWindow(DocumentWidth, FontHeight * LinesPerPage, screenFormat, &err);
        ScrDisplayMode(scrDisplayModeGetSupportedDepths,NULL,NULL,&nd,NULL);
    }
    else { // {*/
        //new code 03/25/02
        WinScreenMode(winScreenModeGetSupportedDepths,NULL,NULL,&nd,NULL);
    //}
    if(gColorMode) {
        ictComments=prefs.comments;
        ictKeywords=prefs.keywords;
        if(nd==0x0B) {
            ictText=0xF;
            nd=4;
        } else {
            ictText=0xFF;
            nd=8;
        }
    } else {
        ictComments=0x1;
        ictText=0x1;
        nd=1;
    }

    // Add Alphasmart Dana support
    if (FtrGet (AlphaSmartSysFtrID, ScrnFtrNum, &danaversion) == 0) {
        gKbSup_SupportedKeyboard = KbSup_AlphasmartDanaKeyboard; // Auto set the keyboard support!
        if (sysGetROMVerMajor(danaversion) >= 1) {
            WinScreenMode (winScreenModeGet, &width, &height, NULL, NULL);
            if (width == 560) {
                gIsWideDana = true;
                PageWidth = width - WIDTH_OFFSET;
                DocumentWidth = width + 10;
                RctSetRectangle (&gClipRect, PageXOrigin, PageYOrigin,
                    PageWidth, PageHeight);
                RctSetRectangle (&gFullScreen, 0, 0, width, 160);
            }
        }
    }

    WinScreenMode(winScreenModeSet,NULL,NULL,&nd,NULL);

    #ifdef HIRES_SUPPORT
    // HiRes Support Lite goes here:
    if(FtrGet(sysFtrCreator, sysFtrNumWinVersion, &winVersion)==0){
        if (winVersion>=4){ // HiRes feature is available...
            WinScreenGetAttribute(winScreenDensity, &screenAttr);
            if (screenAttr == kDensityDouble) { //the screen is double density
                BitmapType* bmpL = (BitmapType*)BmpCreate(DocumentWidth *2, (FontHeight * LinesPerPage) *2, 8, NULL, &err); // create a lo-res bitmap
                BitmapType* bmpHi = (BitmapType*)BmpCreateBitmapV3(bmpL, kDensityDouble, BmpGetBits(bmpL), NULL); // create a bitmap with indirect flag set and a pointer-to-bits instead of bits
                // kDensityDouble => HiRes font, kDensityOneAndAHalf => Crach, kDensityLow => LowRes edgy font
                gOffscreenPage = WinCreateBitmapWindow(bmpHi, &err); // create a window from bmpHi
            }
        }
    }
    if (winVersion <4 || screenAttr != kDensityDouble)
    #endif
        gOffscreenPage = WinCreateOffscreenWindow(DocumentWidth, FontHeight * LinesPerPage, screenFormat, &err);

    // #846728 (S016) External Keyboard Support
    if(gKbSup_SupportedKeyboard != KbSup_NoKeyboard){
        AllocateTheKeyboardTable();
    }

    if(gRomVersion<version35)
        SetTextColor = __SetTextColor30__;
    else
        SetTextColor = __SetTextColor35__;

    if (gOffscreenPage == NULL || err!=0) {
        char buf[64];
        StrPrintF(buf, "Null offscreen winhandle %d", err);
        error(buf);
    }
//}
    if (err != 0) {
        error("Failed to create offscreen");
        return err;
    }

    TEXT_ASSERT((FntCharHeight() == FontHeight), "Bad font height");
    TEXT_ASSERT((FntDescenderHeight() == FontDescender), "Bad font Descender");

//Read saved prefs code was here, now moved earlier in AppStart()-- before the custom font code

    bufferedLineContents = (BufferedText *)MemPtrNew(sizeof(BufferedText) * LinesPerPage);
    for (int i = 0; i < LinesPerPage; i++) {
        bufferedLineContents[i].text = (char *)MemPtrNew(MAX_CHARS_PER_LINE);
    }

    gFontH = (Handle)DmGetResource('NFNT', 1000);
    if (gFontH != NULL) {
        gFont = (FontType *)MemHandleLock(gFontH);
        gLED_ClosureFont = (FontID)130;
        FntDefineFont(gLED_ClosureFont, gFont);
        FontID curFont = FntSetFont(gLED_ClosureFont);
        gClosureCharWidth = FntCharWidth(CLOSURE_CHAR);
        FntSetFont(curFont);
    }

    Handle clipH = (Handle)ClipboardGetItem(clipboardText, &length);
    if (clipH) {
        setClipboard((char *)MemHandleLock(clipH), length);
        MemHandleUnlock(clipH);
    }
    loadSystraps();

    // #846293 (S046) pick highlight mode based on file extension
    if (gCurFile != -1 && gHighlightMode != NOMODE){
        loadKeywords();
    }

    return 0;
}

void autoInsertParen(char ch)
{
  switch (gHighlightMode){
  case HTMLMODE:
        switch (ch) {
            case '<' :   // New code 04/29/2002
          //                if(gHTMLmode) {
                    insertCharacters("></>", 4, false);
            //                }
                break;
        }
  case CMODE:
  case ASMMODE:
  default:
    //    if(!gHTMLmode) {
        switch (ch) {
            case '[' :
                insertCharacters("]", 1, false);
                break;
            case '(' :
                insertCharacters(")", 1, false);
                break;
            case '{' :
                insertCharacters("}", 1, false);
                break;
            case '"' : // #899043 quote auto complete
                insertCharacters("\"", 1, false);
                break;
            case 0x27 : // #899043 quote auto complete
                insertCharacters("\'", 1, false);
                break;
        }
    //    } else {
    break;
  }
}

void clearBlinkingCursor()
{
    if (gBlinkDrawn) {
        eraseBlinkingCursor();
    }
//    gBlinkDrawn = false;
}

void convertScreenXYToDocumentXY(int *x, int *y)
{
    *x -= PageXOrigin;         // adjust to location within page
    *x += screenXOrigin;       // then to within document

    *y -= PageYOrigin;
    *y += screenYOrigin;
}

static void convertDocumentXYToScreenXY(int *x, int *y)
{
    *x -= screenXOrigin;
    *x += PageXOrigin;

    *y -= screenYOrigin;
    *y += PageYOrigin;
}

/***********************************************************************
 *
 * FUNCTION:    disjointSelection
 *
 * DESCRIPTION: this routine
 *
 * PARAMETERS:  aSelection     -
 *
 *              otherSelection -
 *
 *
 * RETURNED:    Boolean -
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
Boolean disjointSelection(SelectionRange *aSelection,
	SelectionRange *otherSelection)
{
    return ((aSelection->endLine < otherSelection->startLine)
                || ((aSelection->endLine == otherSelection->startLine)
                    && (aSelection->endOffset <= otherSelection->startOffset)))
            ||
                ((otherSelection->endLine < aSelection->startLine)
                || ((otherSelection->endLine == aSelection->startLine)
                    && (otherSelection->endOffset <= aSelection->startOffset)));
}

static Boolean doAutoParen()
{
    gAutoParen = !gAutoParen;
    return true;
}

Boolean doCopy()
{
    if (hasSelection() && !isEmptySelection()) {
//      resetBufferToSelection();               don't need it here
        copySelection();
    }
    return true;
}

Boolean doCut()
{
    if (hasSelection() && !isEmptySelection()) {
        resetBufferToSelection();
        cutSelection();
        redrawPage();
    }
    return true;
}

Boolean doPaste()
{
    if (hasSelection()) {
    // since there can be an empty selection here, we make sure the blink is off
        if (isEmptySelection() && isBlinkOnScreen()) {
            clearBlinkingCursor();
        }
        resetBufferToSelection();
        pasteSelection();
        redrawPage();
    }
    return true;
}

static Boolean doTabsSpaces()
{
    // changed for adding the #847961 (S061) Add Tab/Spaces option
    FormPtr frmP = FrmInitForm(TabsSpacesForm);
    ControlPtr tCtlP = (ControlPtr)getObjectPtr(frmP, TabsSpacesUseTabsCheckbox);
    ControlPtr sCtlP = (ControlPtr)getObjectPtr(frmP, TabsSpacesUseSpacesCheckbox);
    CtlSetValue(tCtlP, gUseTabForTab);
    if (gUseTabForTab == false)
      CtlSetValue(sCtlP, 1);
/*
    FieldType *tFldP = (FieldType *)getObjectPtr(frmP, TabsSpacesTabSizeField);
    FieldAttrType attr;
    FldGetAttributes(tFldP, &attr);
    if (attr.underlined ==solidUnderline) {
        attr.underlined = grayUnderline;
        FldSetAttributes(tFldP, &attr);
        FldDrawField(tFldP);
    }
    //  if (tFldP->attr.underlined == solidUnderline)
        // tFldP->attr.underlined = grayUnderline;
*/
    setHandleFromInt(frmP, TabsSpacesTabSizeField, gTabWidth, true,true);
    setHandleFromInt(frmP, TabsSpacesNumSpacesField, gTabSpaces, true,true);

    if (FrmDoDialog(frmP) == TabsSpacesOKButton) {
        setIntFromHandle(frmP, TabsSpacesTabSizeField, (char *)(&gTabWidth), 0, false);
        setIntFromHandle(frmP, TabsSpacesNumSpacesField, (char *)(&gTabSpaces), 0, false);
        gUseTabForTab = CtlGetValue(tCtlP);
        redrawPage();
    }
    FrmDeleteForm(frmP);
    return true;
}

Boolean extractSelectionWord(int *startChP, int *endChP, char *curLine)
{
    if ((hasSelection()) && (isEmptySelection()) ||
        (gCurrentSelection.startLine == gCurrentSelection.endLine)) {
        unsigned int lineLength;
        loadLine(gCurrentSelection.startLine, curLine, &lineLength);

        int startCh = gCurrentSelection.startCharacter;
        Word endCh = gCurrentSelection.endCharacter;
        if (isEmptySelection()) {
            while ((startCh > 0) && ((curLine[startCh - 1] >= 'A') && (curLine[startCh - 1] <= 'z'))) {
                --startCh;
            }
            while ((endCh < lineLength) && ((curLine[endCh] >= 'A') && (curLine[endCh] <= 'z'))) {
                ++endCh;
            }
        }
        *startChP = startCh;
        *endChP = endCh;
        return true;
    }
    return false;
}

// assumes there's enough space in the 'text' for any length line
// number of characters returned in 'textLength'
// 'line' is document relative
/***********************************************************************
 *
 * FUNCTION:    fillLineBuffer
 *
 * DESCRIPTION: this routine fills the line buffer starting with the
 *              given line up through a page full or the end of document.
 *
 * PARAMETERS:  startLine      -
 *
 *
 *
 * RETURNED:    none
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
void fillLineBuffer(unsigned int startLine)
{
    TEXT_ASSERT((startLine < gMaxLines), "fill from beyond end");

    for (int i = 0; i < LinesPerPage; i++) {
        if ((startLine + i) >= gMaxLines) {
            break;
        }
        loadLineIntoBuffer(startLine + i, i);
    }
}

// given a pixel offset on a line, get it's character offset
// and adjust the pixel offset to the start of that character
// (The line in question must be currently displayed on the page.)
// The Line can be anywhere in the Document!!!
unsigned int getCharacterForX(unsigned int line, int *x)
{
    // TEXT_ASSERT((line >= screenTopLine), "Line beyond page");
    // TEXT_ASSERT((line < (screenTopLine + LinesPerPage)), "Line beyond page");

    int j = 0;
    int currentLength = 0;
    int width = 0;
    char *cp;
    char buf[MAX_CHARS_PER_LINE];

    if ((line >= screenTopLine) && (line < (screenTopLine + LinesPerPage))) {
        cp = bufferedLineContents[line - screenTopLine].text;
    }
    else {
        unsigned int lineLength;
        loadLine(line, buf, &lineLength);
        cp = buf;
    }

    while ((currentLength < *x) && (cp[j] != 0)) {
        int charWidth;
        if (cp[j] == tabChr) {
            charWidth = ((1 + currentLength/gTabWidth) * gTabWidth) - currentLength;
        }
        else {
            if ((unsigned char)(cp[j]) == CLOSURE_CHAR) {
                charWidth = gClosureCharWidth;
            }
            else {
                charWidth = FntCharWidth(cp[j]);
            }
        }
        width += charWidth;
        if ((currentLength + charWidth) >= *x) {
            if ((*x - currentLength) < (charWidth >> 1)) {
                *x = currentLength;
                return j;
            }
            else {
                *x = currentLength + charWidth;
                return j + 1;
            }
        }
        currentLength += charWidth;
        j++;
    }
    if (*x <= 0) {
        *x = 0;
        return 0;
    }
    else {
        *x = width;
        return j;
    }
}

/***********************************************************************
 *
 * FUNCTION:    getLineIntoBuffer
 *
 * DESCRIPTION: this routine isused to refresh a line in the buffer.
 *
 * PARAMETERS:  line            - line to refresh.
 *
 * RETURNED:   none
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
void getLineIntoBuffer(Word line)
{
    TEXT_ASSERT((line >= screenTopLine), "line not in buffer");
    TEXT_ASSERT((line < (screenTopLine + LinesPerPage)), "line not in buffer");

    loadLineIntoBuffer(line, line - screenTopLine);
}

VoidPtr getObjectPtr(FormPtr frmP, Word objectID)
{
    return (FrmGetObjectPtr(frmP, FrmGetObjectIndex(frmP, objectID)));
}

// Get the pixel offset for the indexed character, the line
// can be anywhere in the document
int getXForCharacter(unsigned int line, int index, Boolean forceLoad)
{
    char *cp;
    char buf[MAX_CHARS_PER_LINE];

    if (!forceLoad && ((line >= screenTopLine) && (line < (screenTopLine + LinesPerPage)))) {
        cp = bufferedLineContents[line - screenTopLine].text;
    }
    else {
        unsigned int lineLength;
        loadLine(line, buf, &lineLength);
        cp = buf;
    }

    int currentLength = 0;
    int j = 0;

    while ((cp[j] != 0) && (j < index)) {
        if (cp[j] == tabChr) {
            currentLength = ((1 + currentLength/gTabWidth) * gTabWidth);
        }
        else {
            if ((unsigned char)(cp[j]) == CLOSURE_CHAR) {
                currentLength += gClosureCharWidth;
            }
            else {
                currentLength += FntCharWidth(cp[j]);
            }
        }
        j++;
    }
//          char errBuf[64];
//          StrPrintF(errBuf, "X = %d for %d", currentLength, index);
//          error(errBuf);

    return currentLength;
}

// given a pixel offset on a line, get it's character offset
// and adjust the pixel offset to the start of that character
// Can be anywhere in the document!
UInt16 getCharacterForXWithForceload(unsigned int line, int *x, Boolean forceLoad)
{

    int j = 0;
    int currentLength = 0;
    char *cp;
    char buf[MAX_CHARS_PER_LINE];

    if (!forceLoad && ((line >= screenTopLine) && (line < (screenTopLine + LinesPerPage)))) {
        cp = bufferedLineContents[line - screenTopLine].text;
    }
    else {
        unsigned int lineLength;
        loadLine(line, buf, &lineLength);
        cp = buf;
    }

    int width = 0;

    while ((currentLength < *x) && (cp[j] != 0)) {
        int charWidth;
        if (cp[j] == tabChr) {
            charWidth = ((1 + currentLength/gTabWidth) * gTabWidth) - currentLength;
        }
        else {
            if ((unsigned char)(cp[j]) == CLOSURE_CHAR) {
                charWidth = gClosureCharWidth;
            }
            else {
                charWidth = FntCharWidth(cp[j]);
            }
        }
        width += charWidth;
        if ((currentLength + charWidth) >= *x) {
            if ((*x - currentLength) < (charWidth >> 1)) {
                *x = currentLength;
                return j;
            }
            else {
                *x = currentLength + charWidth;
                return j + 1;
            }
        }
        currentLength += charWidth;
        j++;
    }
    if (*x <= 0) {
        *x = 0;
        return 0;
    }
    else {
        *x = width;
        return j;
    }
}

Boolean handleDoubleTap(short x, short y, Boolean wholeLine)
{
    SelectionRange currentSelection;

    buildSelection(x, y, &currentSelection);

    if ((currentSelection.startLine == gCurrentSelection.startLine)
            && (currentSelection.endLine == gCurrentSelection.endLine)
            && (
                (currentSelection.startCharacter == gCurrentSelection.startCharacter)
                || (wholeLine
                        && (currentSelection.startCharacter >= gCurrentSelection.startCharacter)
                            && (currentSelection.endCharacter < gCurrentSelection.endCharacter)  )
                ) ) {
        if (hasSelection()) {   // clear away any existing selection
            if (isEmptySelection()) {
                if (isBlinkOnScreen()) {
                    clearBlinkingCursor();
                }
            } else {
                invertSelectionOnPage(&gCurrentSelection, false);
            }
        }
        char *curLine = bufferedLineContents[gCurrentSelection.startLine - screenTopLine].text;
        int startCh;
        int endCh;
        if (wholeLine) {
            startCh = 0;
            if (gCurrentSelection.startLine == (gMaxLines - 1)) {
                endCh = StrLen(curLine);
            } else {
                gCurrentSelection.endLine = gCurrentSelection.startLine + 1;
                endCh = 0;
            }
        } else {
            Word line1, line2, offset1, offset2;

            startCh = currentSelection.startCharacter;
            endCh = currentSelection.startCharacter;

            if ( (curLine[startCh] == '{') || (curLine[startCh] == '}')
                    || (curLine[startCh] == '(') || (curLine[startCh] == ')') ) {

                switch (curLine[startCh]) {
                case '{':   // '}'
                    if (findMatchingParen(gCurrentSelection.startLine, startCh + 1, '{', '}')) {
                        getSelection(&line1, &offset1, &line2, &offset2);
                        gCurrentSelection.endLine = line2;
                        endCh = offset2;
                    }
                    break;
                case '(':   // ')'
                    if (findMatchingParen(gCurrentSelection.startLine, startCh + 1, '(', ')')) {
                        getSelection(&line1, &offset1, &line2, &offset2);
                        gCurrentSelection.endLine = line2;
                        endCh = offset2;
                    }
                    break;
                    // '{'
                case '}':
                    if (findMatchingParenBackwards(gCurrentSelection.startLine, startCh - 1, '{', '}')) {
                        getSelection(&line1, &offset1, &line2, &offset2);
                        gCurrentSelection.startLine = line1;
                        startCh = offset1;
                        endCh++;
                    }
                    break;
                    // '('
                case ')':
                    if (findMatchingParenBackwards(gCurrentSelection.startLine, startCh - 1, '(', ')')) {
                        getSelection(&line1, &offset1, &line2, &offset2);
                        gCurrentSelection.startLine = line1;
                        startCh = offset1;
                        endCh++;
                    }
                    break;
                }
            }
            else {
                while ((startCh > 0) && isWordLetter(curLine[startCh - 1])) {
                    startCh--;
                }
                while ((curLine[endCh] != '\0') && isWordLetter(curLine[endCh])) {
                    endCh++;
                }
            }
        }
        gCurrentSelection.startCharacter = startCh;
        gCurrentSelection.endCharacter = endCh;
        gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, startCh, false);
        gCurrentSelection.endOffset = getXForCharacter(gCurrentSelection.endLine, endCh, false);
        markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                        gCurrentSelection.endLine, gCurrentSelection.endCharacter);

        if ((startCh == endCh) && (gCurrentSelection.startLine == gCurrentSelection.endLine)) {
            setBlinkCharacter();
            drawBlinkingCursor();
            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
            //gBlinkDrawn = true;                                 // if it was empty at the end, it was drawn already
        } else {
            invertSelectionOnPage(&gCurrentSelection, false);
        }
        return true;
    } else {
        return false;
    }
}

Boolean ScrollPageUp(void){
    // error("Page_Up");
    Int16 difference = screenTopLine;
    if (screenTopLine > LinesPerPage) {
        screenTopLine -= LinesPerPage;
    }
    else {
        screenTopLine = 0;
    }
    if (gKbSup_SupportedKeyboard !=KbSup_NoKeyboard){
        // Move along the cursor
        if (hasSelection() && isEmptySelection() && isBlinkOnScreen()){
            clearBlinkingCursor();
            difference = screenTopLine - difference;
            gCurrentSelection.startLine += difference;
            gCurrentSelection.endLine = gCurrentSelection.startLine;
            unsigned int len = 0;
            MemHandle h = MemHandleNew(MAX_CHARS_PER_LINE);
            char *p = (char*)MemHandleLock(h);
            loadLine(gCurrentSelection.startLine, p, &len);
            MemHandleFree(h);
            if (gCurrentSelection.startCharacter> len){
                gCurrentSelection.startCharacter = len;
            }
            gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;

            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                        gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            drawBlinkingCursor();
        }
    }
    screenYOrigin = screenTopLine * FontHeight;
    fillLineBuffer(screenTopLine);
    drawPage();
    if (hasSelection() && isEmptySelection() && isBlinkOnScreen())
        if (adjustXOrigin())
            refreshPageContents();
    FormPtr frmP = FrmGetActiveForm();
    ScrollBarPtr bar = (ScrollBarPtr)getObjectPtr(frmP, MainDocumentScrollBar);
    int sclMax = (gMaxLines > LinesPerPage) ? gMaxLines - LinesPerPage : 0;
    SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
    return true;
}

Boolean ScrollPageDown(void){
    // error("Page_Down");
    Int16 difference = screenTopLine;
    if (gMaxLines > LinesPerPage) {
       if (screenTopLine + (2*LinesPerPage) < gMaxLines ){
            screenTopLine += LinesPerPage;
        }
        else {
          screenTopLine = (gMaxLines - LinesPerPage);
        }
        if (gKbSup_SupportedKeyboard !=KbSup_NoKeyboard){
            // move along the cursor
            if (hasSelection() && isEmptySelection() && isBlinkOnScreen()){
                clearBlinkingCursor();
                difference = screenTopLine - difference;
                gCurrentSelection.startLine += difference;
                gCurrentSelection.endLine = gCurrentSelection.startLine;
                unsigned int len = 0;
                MemHandle h = MemHandleNew(MAX_CHARS_PER_LINE);
                char *p = (char*)MemHandleLock(h);
                loadLine(gCurrentSelection.endLine, p, &len);
                MemHandleFree(h);
                if (gCurrentSelection.startCharacter> len){
                    gCurrentSelection.startCharacter = len;
                    }
                gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
                gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);
                gCurrentSelection.endOffset = gCurrentSelection.startOffset;

                markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                            gCurrentSelection.endLine, gCurrentSelection.endCharacter);
                drawBlinkingCursor();
            }
        }
        screenYOrigin = screenTopLine * FontHeight;
        fillLineBuffer(screenTopLine);
        drawPage();
        if (hasSelection() && isEmptySelection() && isBlinkOnScreen())
            if (adjustXOrigin())
                refreshPageContents();
        FormPtr frmP = FrmGetActiveForm();
        ScrollBarPtr bar = (ScrollBarPtr)getObjectPtr(frmP, MainDocumentScrollBar);
        int sclMax = (gMaxLines > LinesPerPage) ? gMaxLines - LinesPerPage : 0;
        SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
        return true;
    }
    return true;    // We have to retun true...
}

Boolean handleJogDial(struct _KeyDownEventType key){
    // #910455 Support the Sony Jog-Dial for Scrolling.
    Boolean handled = false;
    switch(key.chr){
        case vchrJogUp:     // 0x1700
            scrollUp(NULL);
            handled = true;
            break;
        case vchrJogDown:   // 0x1701
            scrollDown(NULL);
            handled = true;
            break;
        case vchrJogLeft:   // 0x1708
            scrollScreen(screenScrollDirectionLeft);
            handled = true;
            break;
        case vchrJogRight:  // 0x1709
            scrollScreen(screenScrollDirectionRight);
            handled = true;
            break;
        default:
            break;
    }
    return handled;
}


Boolean makeBlinkVisible(Boolean checkX){
    FormPtr frmP = FrmGetActiveForm();
    ScrollBarPtr bar = (ScrollBarPtr)getObjectPtr(frmP, MainDocumentScrollBar);
    int sclMax = (gMaxLines > LinesPerPage) ? gMaxLines - LinesPerPage : 0;
    Boolean handled = false;

    if (hasSelection() /*&& isEmptySelection()*/){
        if ((screenTopLine < gCurrentSelection.startLine) && ((gCurrentSelection.startLine - screenTopLine) > (UInt16)LinesPerPage-1)){
            screenTopLine = gCurrentSelection.startLine - (LinesPerPage-1);
            screenYOrigin = screenTopLine * FontHeight;
            fillLineBuffer(screenTopLine);
            clearBlinkingCursor();
            drawPage();
            drawBlinkingCursor();

            SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
            handled = true;
        }

        if (screenTopLine > gCurrentSelection.startLine){
            screenTopLine = gCurrentSelection.startLine;
            screenYOrigin = screenTopLine * FontHeight;
            fillLineBuffer(screenTopLine);
            clearBlinkingCursor();
            drawPage();
            drawBlinkingCursor();

            SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
            handled = true;
        }


        if(adjustXOrigin() && checkX){
            refreshPageContents();
        handled = true;
        }
        SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
    }
    SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
    return handled;
}

Boolean doKeyboardKey(KbSupAsKey action){
    // #846728 (S016) External Keyboard Support

/*
    KbSup_ShiftCtrlUp,
    KbSup_ShiftCtrlDown,
    KbSup_ShiftCtrlLeft,
    KbSup_ShiftCtrlRight,
    KbSup_ShiftCmdUp,
    KbSup_ShiftCmdDown,
    KbSup_ShiftCmdLeft,
    KbSup_ShiftCmdRight
*/

    Boolean handled = false;
    char curLine[MAX_CHARS_PER_LINE];
    unsigned int len;
    unsigned int startCh;
    int line;
    FormPtr frmP = FrmGetActiveForm();
    ScrollBarPtr bar = (ScrollBarPtr)getObjectPtr(frmP, MainDocumentScrollBar);
    int sclMax = (gMaxLines > LinesPerPage) ? gMaxLines - LinesPerPage : 0;
    unsigned int ch;
    EventType newEvent;


    switch(action){
        // No Action is implemented for this key!
        case KbSup_None:
            handled = false; // Leave this event for more checking...
            break;
        // [Up][Down][Left][Right]*****************************************************
        case KbSup_Up:
            if (hasSelection()){
                if (isEmptySelection()) // Clear the Cursor
                    clearBlinkingCursor();
                else{
                    invertSelectionOnPage(&gCurrentSelection, false);
                    unmarkSelection();
                }
            }
            if (gCurrentSelection.startLine > 0)
                gCurrentSelection.startLine--;

            if (gCurrentSelection.startLine < screenTopLine)
                scrollUp(NULL);

            gCurrentSelection.startCharacter = getCharacterForX(gCurrentSelection.startLine, (int *)&gCurrentSelection.startOffset);
            gCurrentSelection.endLine = gCurrentSelection.startLine;
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;
            gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);

            drawBlinkingCursor();
            makeBlinkVisible(true);
            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay

            gSelectionMadeWith = key_Up;

            handled = true;
            break;

        case KbSup_Down:
            if (hasSelection()){
                if (isEmptySelection()) // Clear the Cursor
                    clearBlinkingCursor();
                else{
                    invertSelectionOnPage(&gCurrentSelection, false);
                    gCurrentSelection.startCharacter = gCurrentSelection.endCharacter;
                    gCurrentSelection.startLine = gCurrentSelection.endLine;
                    gCurrentSelection.startOffset = gCurrentSelection.endOffset;
                    unmarkSelection();
                }
            }

            if (gCurrentSelection.startLine < (gMaxLines - 1))
                gCurrentSelection.startLine++;

            if (gCurrentSelection.startLine >= (screenTopLine + LinesPerPage))
                scrollDown(NULL);

            gCurrentSelection.startCharacter = getCharacterForX(gCurrentSelection.startLine, (int*)&gCurrentSelection.startOffset);
            gCurrentSelection.endLine = gCurrentSelection.startLine;
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;
            gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            drawBlinkingCursor();
            makeBlinkVisible(true);
            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay

            gSelectionMadeWith = key_Down;

            handled = true;
            break;

        case KbSup_Left:
            if (hasSelection()){
                if (!isEmptySelection()) {
                    invertSelectionOnPage(&gCurrentSelection, false);
                    unmarkSelection();
                    gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
                    gCurrentSelection.endLine= gCurrentSelection.startLine;
                }

                else{
                    clearBlinkingCursor();  // Clear the cursor
                    if (gCurrentSelection.startCharacter > 0)
                        gCurrentSelection.startCharacter--;
                    else{
                        if (gCurrentSelection.startLine > 0) {
                            gCurrentSelection.startLine--;
                            if (gCurrentSelection.startLine < screenTopLine) {
                                scrollUp(NULL);
                            }
                            gCurrentSelection.startCharacter = bufferedLineContents[gCurrentSelection.startLine - screenTopLine].length;
                        }
                    }
                }

            }
            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true); // false?
            gCurrentSelection.endLine = gCurrentSelection.startLine;
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;
            gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            drawBlinkingCursor();
            makeBlinkVisible(true);
            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay

            gSelectionMadeWith = key_Left;

            handled = true;
            break;

        case KbSup_Right:
            if (hasSelection()){
                if (!isEmptySelection()){ // Clear any selection and make the cursors new pos at the end of the previous selection
                    invertSelectionOnPage(&gCurrentSelection, false);
                    unmarkSelection();
                    gCurrentSelection.startCharacter = gCurrentSelection.endCharacter;
                    gCurrentSelection.startLine = gCurrentSelection.endLine;
                }
                else{
                    clearBlinkingCursor(); // Clear the Cursor
                    if (gCurrentSelection.startCharacter < bufferedLineContents[gCurrentSelection.startLine - screenTopLine].length) {
                        gCurrentSelection.startCharacter++;
                    }
                    else{
                        if (gCurrentSelection.startLine < (gMaxLines - 1)) {
                            gCurrentSelection.startLine++;
                            if (gCurrentSelection.startLine >= (screenTopLine + LinesPerPage)) {
                                scrollDown(NULL);
                            }
                        gCurrentSelection.startCharacter = 0;
                        }
                    }
                }
            }
            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true); // false?
            gCurrentSelection.endLine = gCurrentSelection.startLine;
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;
            gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            drawBlinkingCursor();
            makeBlinkVisible(true);
            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay

            gSelectionMadeWith = key_Right;

            handled = true;
            break;

        case KbSup_PageUp:
            // Check for MenuEvent!
            handled = ScrollPageUp();
            break;
        case KbSup_PageDown:
            // Check for MenuEvent!
            handled = ScrollPageDown();
            break;

        // [Shift][Up][Down][Left][Right]*****************************************************
        case KbSup_ShiftUp:
            // error("ShiftUp");

            if (isEmptySelection() || (gSelectionMadeWith == key_ShiftUp || gSelectionMadeWith == key_ShiftLeft)){
                gSelectionMadeWith = key_ShiftUp;
                line = gCurrentSelection.startLine;
            }
            else
                line = gCurrentSelection.endLine;

            if (line>0){
                line -=1;
                loadLine(line, curLine, &len);
            }
            else{
                handled = true;
                break;
            }

            if (hasSelection() && isEmptySelection() && isBlinkOnScreen()){   // clear away cursor
                clearBlinkingCursor();
            }
            if (gSelectionMadeWith == key_ShiftUp || gSelectionMadeWith == key_ShiftLeft ){
                gCurrentSelection.startLine = line;
                if (gCurrentSelection.endOffset > (UInt16)getXForCharacter(gCurrentSelection.startLine, len, true)){
                    gCurrentSelection.startCharacter = len;
                    gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);

                }
            }
            else{
                gCurrentSelection.endLine = line;
                if (gCurrentSelection.startOffset > (UInt16)getXForCharacter(gCurrentSelection.endLine, len, true)){
                    gCurrentSelection.endCharacter = len;
                    gCurrentSelection.endOffset = getXForCharacter(gCurrentSelection.endLine, gCurrentSelection.endCharacter, true);
                }
            }

            if (gCurrentSelection.startLine >= gCurrentSelection.endLine){
                unmarkSelection();
                gCurrentSelection.startLine = gCurrentSelection.endLine;
                gCurrentSelection.startCharacter = gCurrentSelection.endCharacter;
                gCurrentSelection.startOffset = gCurrentSelection.endOffset;
            }


            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                                  gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            if (line < (int)screenTopLine)
                scrollUp(NULL);

            if (adjustXOrigin())
                refreshPageContents();
            drawPage();


            handled = true;
            break;

        case KbSup_ShiftDown:
            // Let's fake a PenStroke

            if (gCurrentSelection.endLine != gMaxLines-1){
            if (isEmptySelection() || (gSelectionMadeWith == key_ShiftDown || gSelectionMadeWith == key_ShiftRight)){
                gSelectionMadeWith = key_ShiftDown;
                line = gCurrentSelection.endLine;
            }
            else
                line = gCurrentSelection.startLine;

            if ((UInt16)line<gMaxLines -1){
                line +=1;
                loadLine(line, curLine, &len);
            }
            else{
                handled = true;
                break;
            }

            if (hasSelection() && isEmptySelection() && isBlinkOnScreen()){   // clear away cursor
                clearBlinkingCursor();
            }
            if (gSelectionMadeWith == key_ShiftDown || gSelectionMadeWith == key_ShiftRight){
                gCurrentSelection.endLine = line;
                if (gCurrentSelection.startOffset > (UInt16)getXForCharacter(gCurrentSelection.endLine, len, true)){
                    gCurrentSelection.endCharacter = len;
                    gCurrentSelection.endOffset = getXForCharacter(gCurrentSelection.endLine, gCurrentSelection.endCharacter, true);
                }
            }
            else{
            gCurrentSelection.startLine = line;
                if (gCurrentSelection.endOffset > (UInt16)getXForCharacter(gCurrentSelection.startLine, len, true)){
                    gCurrentSelection.startCharacter = len;
                    gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);

                }
            }

            if (gCurrentSelection.startLine >= gCurrentSelection.endLine){
                unmarkSelection();
                gCurrentSelection.startLine = gCurrentSelection.endLine;
                gCurrentSelection.startCharacter = gCurrentSelection.endCharacter;
                gCurrentSelection.startOffset = gCurrentSelection.endOffset;
            }

            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                                  gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            if (line>= (int)(screenTopLine + LinesPerPage))
                scrollDown(NULL);

            if (adjustXOrigin())
                refreshPageContents();
            drawPage();
            }
            handled = true;
            break;

        case KbSup_ShiftLeft:
            // error("Shift Left");

            if (gCurrentSelection.startLine + gCurrentSelection.startOffset !=0){

            if (isEmptySelection() || (gSelectionMadeWith == key_ShiftLeft  || gSelectionMadeWith == key_ShiftUp)){
                gSelectionMadeWith = key_ShiftLeft;
                ch = gCurrentSelection.startCharacter;
                line = gCurrentSelection.startLine;
            }

            else{
                ch = gCurrentSelection.endCharacter;
                line = gCurrentSelection.endLine;
            }


            if (ch > 0)
                ch -=1;
            else if (line>0){
                line -=1;
                loadLine(line, curLine, &len);
                ch = len;
            }
            else{
                handled = true;
                break;
            }

            if (hasSelection() && isEmptySelection() && isBlinkOnScreen()){   // clear away cursor
                clearBlinkingCursor();
            }
            if (gSelectionMadeWith == key_ShiftLeft || gSelectionMadeWith == key_ShiftUp){
                gCurrentSelection.startLine = line;
                gCurrentSelection.startCharacter = ch;
                gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);
            }
            else{
                gCurrentSelection.endLine = line;
                gCurrentSelection.endCharacter = ch;
                gCurrentSelection.endOffset = getXForCharacter(gCurrentSelection.endLine, gCurrentSelection.endCharacter, true);
            }

            if ((gCurrentSelection.startLine >gCurrentSelection.endLine) ||
                (gCurrentSelection.startLine == gCurrentSelection.endLine && gCurrentSelection.startCharacter >gCurrentSelection.endCharacter)){
                unmarkSelection();
                gCurrentSelection.startLine = gCurrentSelection.endLine;
                gCurrentSelection.startCharacter = gCurrentSelection.endCharacter;
                gCurrentSelection.startOffset = gCurrentSelection.endOffset;
            }


            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                                  gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            if (line < (int)screenTopLine)
                scrollDown(NULL);

            if (adjustXOrigin())
                refreshPageContents();
            drawPage();

            }
            handled = true;
            break;

        case KbSup_ShiftRight:
            // error("Shift Right");

            if (isEmptySelection() || (gSelectionMadeWith == key_ShiftRight || gSelectionMadeWith == key_ShiftDown)){
                gSelectionMadeWith = key_ShiftRight;
                ch = gCurrentSelection.endCharacter;
                line = gCurrentSelection.endLine;
            }

            else{
                ch = gCurrentSelection.startCharacter;
                line = gCurrentSelection.startLine;
            }

            loadLine(line, curLine, &len);
            if (ch < len)
                ch +=1;
            else if ((UInt16)line<gMaxLines-1){
                line +=1;
                ch = 0;
            }
            else{
                handled = true;
                break;
            }

            if (hasSelection() && isEmptySelection() && isBlinkOnScreen()){   // clear away cursor
                clearBlinkingCursor();
            }
            if (gSelectionMadeWith == key_ShiftRight || gSelectionMadeWith == key_ShiftDown){
                gCurrentSelection.endLine = line;
                gCurrentSelection.endCharacter = ch;
                gCurrentSelection.endOffset = getXForCharacter(gCurrentSelection.endLine, gCurrentSelection.endCharacter, true);
            }
            else{
                gCurrentSelection.startLine = line;
                gCurrentSelection.startCharacter = ch;
                gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);
            }

            if ((gCurrentSelection.startLine >gCurrentSelection.endLine) ||
                (gCurrentSelection.startLine == gCurrentSelection.endLine && gCurrentSelection.startCharacter >gCurrentSelection.endCharacter)){
                unmarkSelection();
                gCurrentSelection.startLine = gCurrentSelection.endLine;
                gCurrentSelection.startCharacter = gCurrentSelection.endCharacter;
                gCurrentSelection.startOffset = gCurrentSelection.endOffset;
            }


            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                                  gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            if (line >= (int)(screenTopLine + LinesPerPage))
                scrollDown(NULL);

            if (adjustXOrigin())
                refreshPageContents();
            drawPage();

            handled = true;
            break;

        // [Ctrl][Up][Down][Left][Right]*****************************************************
        case KbSup_CtrlUp:  // [Ctrl][Up]
            // error("Ctrl Up");
            if (screenTopLine == 0){
                // We don't have to do anything
                handled = true;
                break;
            }
            else{
                if (gCurrentSelection.startLine != screenTopLine+(LinesPerPage-1)){
                    // We need to scroll down one line (keeping the selection selected) untill that line is at the bottom line of the Page
                    clearBlinkingCursor();
                    screenTopLine -=1;
                    screenYOrigin = screenTopLine * FontHeight;
                    fillLineBuffer(screenTopLine);
                    drawPage();
                    if (adjustXOrigin())
                            refreshPageContents();
                    drawBlinkingCursor();
                    makeBlinkVisible(true);
                    SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
                    handled = true;
                    break;
                }
                else{ // if (gCurrentSelection.endLine != gMaxLines-1){
                    // We need to scroll down one line (unselecting any Selections, moving the cursor to the next line) untill that line is at the bottom line of the Page
                    clearBlinkingCursor();
                    if (hasSelection() && !isEmptySelection()){
                        invertSelectionOnPage(&gCurrentSelection, false);
                        // gCurrentSelection.startCharacter = gCurrentSelection.endCharacter;
                        // gCurrentSelection.startLine = gCurrentSelection.endLine;
                        unmarkSelection();
                    }

                    screenTopLine -=1;
                    gCurrentSelection.startLine -=1;

                    screenYOrigin = screenTopLine * FontHeight;
                    fillLineBuffer(screenTopLine);
                    // The current line length
                    loadLine(gCurrentSelection.startLine, curLine, &len);
                    if (gCurrentSelection.startCharacter > len)
                        gCurrentSelection.startCharacter = len;
                    gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
                    gCurrentSelection.endLine = gCurrentSelection.startLine;
                    gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true); //false
                    gCurrentSelection.endOffset = gCurrentSelection.startOffset;

                    markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                                  gCurrentSelection.endLine, gCurrentSelection.endCharacter);

                    drawPage();
                    SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
                    drawBlinkingCursor();
                    makeBlinkVisible(true);
                    handled = true;
                    break;
                }
            }
            break;
        case KbSup_CtrlDown: // [Ctrl][Down]
            // error("Ctrl Down");

            if ((Int16)screenTopLine >= (Int16)gMaxLines-LinesPerPage){
                // We don't have to do anything
                handled = true;
                break;
            }
            else if (screenTopLine < gMaxLines-LinesPerPage){
                if (gCurrentSelection.startLine != screenTopLine){
                    // We need to scroll up one line (keeping the selection selected) untill that line is at the top line of the Page
                    clearBlinkingCursor();
                    screenTopLine +=1;
                    screenYOrigin = screenTopLine * FontHeight;
                    fillLineBuffer(screenTopLine);
                    drawPage();
                    if (adjustXOrigin())
                            refreshPageContents();
                    drawBlinkingCursor();
                    makeBlinkVisible(true);
                    SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
                    handled = true;
                    break;
                }
                else if (gCurrentSelection.startLine == screenTopLine){
                    // We need to scroll down one line (unselecting any Selections, moving the cursor to the next line) untill that line is at the top line of the Page
                    clearBlinkingCursor();
                    if (hasSelection() && !isEmptySelection()){
                        invertSelectionOnPage(&gCurrentSelection, false);
                        unmarkSelection();
                    }

                    screenTopLine +=1;
                    gCurrentSelection.startLine +=1;

                    screenYOrigin = screenTopLine * FontHeight;
                    fillLineBuffer(screenTopLine);
                    // The current line length
                    loadLine(gCurrentSelection.startLine, curLine, &len);
                    if (gCurrentSelection.startCharacter > len)
                        gCurrentSelection.startCharacter = len;
                    gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
                    gCurrentSelection.endLine = gCurrentSelection.startLine;
                    gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true); // false
                    gCurrentSelection.endOffset = gCurrentSelection.startOffset;

                    markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                                  gCurrentSelection.endLine, gCurrentSelection.endCharacter);

                    drawPage();
                    SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
                    drawBlinkingCursor();
                    makeBlinkVisible(true);
                    handled = true;
                    break;
                }
            }
            break;
        case KbSup_CtrlLeft:
            // [Ctrl] <-
            if (hasSelection()) {
                if (isEmptySelection()) {
                    clearBlinkingCursor();
                }
                invertSelectionOnPage(&gCurrentSelection, false);
                unmarkSelection();
            }
            // The current line length

            loadLine(gCurrentSelection.startLine, curLine, &len);

            // The cursor posistion to seach from...
            startCh = gCurrentSelection.startCharacter;

            // previousLine:
            if(!(startCh == 0 && gCurrentSelection.startLine ==0)){ // stop at top-left pos...
                if (startCh == 0){ // If we are at the very beginning: goto previous line end.
                    if (gCurrentSelection.startLine > 0){
                        gCurrentSelection.startLine -= 1;
                        loadLine(gCurrentSelection.startLine, curLine, &len);
                        startCh = len;
                        goto noFurtherTestsNeeded; // If we want the cursor NOT to treat newline as a word; comment this line!
                    }
                }
                else
                    startCh -=1;

                if (isWhitespace(curLine[startCh-1]) && startCh != len){
                    // we are Not in a word
                    // 1. search for next WordLetter
                    while ((startCh != 0) && isWhitespace(curLine[startCh-1]))
                        startCh--;
                    // 2. search for next nonWordLetter
                    while ((startCh != 0) && (!isWhitespace(curLine[startCh-1])))
                        startCh--;
                }
                else if (!isWhitespace(curLine[startCh-1])){
                    // we are in a word
                    // 1. search for next nonWordLetter
                    while ((startCh != 0) && (!isWhitespace(curLine[startCh-1])))
                        startCh--;
                }
            }
            noFurtherTestsNeeded:

            gCurrentSelection.startCharacter = startCh;
            gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
            gCurrentSelection.endLine = gCurrentSelection.startLine;
            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, startCh, true); // false?
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;

            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            drawBlinkingCursor();
            makeBlinkVisible(true);

            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
            gSelectionMadeWith = key_CtrlLeft;
            handled = true;
            break;

        case KbSup_CtrlRight:
            // [Ctrl]->
            if (hasSelection()){
                if (isEmptySelection()){
                    clearBlinkingCursor();
                }
                else if (!isEmptySelection()){
                    invertSelectionOnPage(&gCurrentSelection, false);
                    gCurrentSelection.startCharacter = gCurrentSelection.endCharacter;
                    gCurrentSelection.startLine = gCurrentSelection.endLine;
                    unmarkSelection();
                }
            }

            // The current line length
            len = 0;
            loadLine(gCurrentSelection.startLine, curLine, &len);
            // The cursor posistion to seach from...
            startCh = gCurrentSelection.startCharacter;

            if (startCh>=len){
                // if we are at the line end goto start of next next line
                if (gCurrentSelection.startLine <(gMaxLines-1)){
                    gCurrentSelection.startLine += 1;
                    loadLine(gCurrentSelection.startLine, curLine, &len);
                    startCh = 0;
                }
            }
            else
                startCh +=1;

            if (isWhitespace(curLine[startCh])&& startCh !=0){
                // we are Not in a word
                // 1. search for next WordLetter
                while ((curLine[startCh] !='\0') && isWhitespace(curLine[startCh]))
                    startCh++;
            }
            else if (!isWhitespace(curLine[startCh]) && startCh !=0){
                // we are in a word
                // 1. search for next nonWordLetter
                while ((curLine[startCh] !='\0') && (!isWhitespace(curLine[startCh])))
                    startCh++;
                // 2. search for next WordLetter
                while ((curLine[startCh] !='\0') && isWhitespace(curLine[startCh]))
                    startCh++;
            }

            if (gCurrentSelection.startLine ==(gMaxLines-1) && startCh>len)
                startCh = len;

            gCurrentSelection.startCharacter = startCh;
            gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
            gCurrentSelection.endLine = gCurrentSelection.startLine;
            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, startCh, true);
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;

            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            drawBlinkingCursor();
            makeBlinkVisible(true);

            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
            gSelectionMadeWith = key_CtrlRight;
            handled = true;
            break;

        // [Cmd][Up][Down][Left][Right]*****************************************************
        case KbSup_CmdUp:
            // [Cmd][Up]
            if (hasSelection()) {
                if (isEmptySelection() && isBlinkOnScreen()) {
                    clearBlinkingCursor();
                }
                if (!isEmptySelection()){
                    invertSelectionOnPage(&gCurrentSelection, false);
                    unmarkSelection();
                }
            }

            gCurrentSelection.startLine = 0;
            gCurrentSelection.endLine = gCurrentSelection.startLine;
            gCurrentSelection.startCharacter = 0;
            gCurrentSelection.endCharacter = 0;
            gCurrentSelection.startOffset = 0;
            gCurrentSelection.endOffset = 0;
            // Need to set these to get the window to follow the cursor....
            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;

            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            drawBlinkingCursor();
            makeBlinkVisible(true);

            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
            gSelectionMadeWith = key_CmdUp;
            handled = true;
            break;

        case KbSup_CmdDown:
            // [Cmd][Down]
            if (hasSelection()){
                if (isEmptySelection() && isBlinkOnScreen()) {
                    clearBlinkingCursor();
                }
                if(!isEmptySelection()){
                    invertSelectionOnPage(&gCurrentSelection, false);
                    unmarkSelection();
                }
            }
            len = 0;
            loadLine(gMaxLines -1, curLine, &len);

            gCurrentSelection.startLine = gMaxLines -1;
            gCurrentSelection.endLine = gCurrentSelection.startLine;
            gCurrentSelection.startCharacter = len;
            gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
            // Need to set these to get the window to follow the cursor....
            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;

            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            drawBlinkingCursor();
            makeBlinkVisible(true);

            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
            gSelectionMadeWith = key_CmdDown;
            handled = true;
            break;

          case KbSup_CmdLeft:
            // [Cmd]<- (Home)
            if (hasSelection()) {
                if (isEmptySelection() && isBlinkOnScreen()) {
                    clearBlinkingCursor();
                }
                if (!isEmptySelection()){
                    invertSelectionOnPage(&gCurrentSelection, false);
                    unmarkSelection();
                }
            }

            gCurrentSelection.endLine = gCurrentSelection.startLine;
            gCurrentSelection.startCharacter = 0;
            gCurrentSelection.endCharacter = 0;
            gCurrentSelection.startOffset = 0;
            gCurrentSelection.endOffset = 0;
            // Need to set these to get the window to follow the cursor....
            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;

            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            drawBlinkingCursor();
            makeBlinkVisible(true);


            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
            gSelectionMadeWith = key_CmdLeft;
            handled = true;
            break;

        case KbSup_CmdRight:
            //  [Cmd]-> (End)
            if (hasSelection()){
                if (isEmptySelection() && isBlinkOnScreen()) {
                    clearBlinkingCursor();
                }
                if (!isEmptySelection()){
                    invertSelectionOnPage(&gCurrentSelection, false);
                    unmarkSelection();
                }
            }

            len = 0;
            loadLine(gCurrentSelection.startLine, curLine, &len);

            gCurrentSelection.endLine = gCurrentSelection.startLine;

            gCurrentSelection.startCharacter = len;
            gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
            // Need to set these to get the window to follow the cursor....
            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;

            markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            drawBlinkingCursor();
            makeBlinkVisible(true);

            gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
            gSelectionMadeWith = key_CmdRight;
            handled = true;
            break;

        // [Del] ***************************************************************************
        case KbSup_Del:
            // #846728 (S016) External Keyboard Support [Del]
            if (hasSelection() && isEmptySelection()) {
                if (isBlinkOnScreen()) {
                    clearBlinkingCursor();
                }

                len = 0;
                loadLine(gCurrentSelection.endLine, curLine, &len);

                if (gCurrentSelection.endCharacter< len)
                    gCurrentSelection.endCharacter += 1;
                else if (gCurrentSelection.endLine<gMaxLines-1){
                    gCurrentSelection.endLine += 1;
                    gCurrentSelection.endCharacter = 0;
                }
                gCurrentSelection.endOffset = getXForCharacter(gCurrentSelection.endLine, gCurrentSelection.endCharacter, true);

                markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                          gCurrentSelection.endLine, gCurrentSelection.endCharacter);
            }
            if (hasSelection() && !isEmptySelection()){
                deleteSelection();
                redrawPage();
                drawBlinkingCursor();
                makeBlinkVisible(true);
                gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
                gSelectionMadeWith = key_Del;
            }
            handled = true;
            break;

        // [Tab] ***************************************************************************
        case KbSup_Tab:
            // [Tab]
            MemSet(&newEvent, sizeof(EventType), 0);
            newEvent.eType = keyDownEvent;
            newEvent.data.keyDown.chr = 0x0009;
            newEvent.data.keyDown.keyCode = 0x0000;
            newEvent.data.keyDown.modifiers = 0x0000;
            EvtAddEventToQueue(&newEvent);
            gSelectionMadeWith = key_Tab;
            handled = true;
            break;

        // [Shift][Tab] *********************************************************************
        case KbSup_ShiftTab:
            //[Shift][Tab]
            if (isEmptySelection()){
                // moves the cursor towards the beginning of the Line in 'tab' sized steps
                if (gCurrentSelection.startOffset != 0){ // Check if we have to do this cursor move.
                    char c = tabChr;
                    UInt8 offset = gTabWidth;
                    int x;
                    if (gUseTabForTab == false){
                      offset = 0;
                      c = spaceChr;
                      for (int i = 0; i < gTabSpaces; i++)
                        offset += FntCharWidth(spaceChr);
                    }
                    if (gCurrentSelection.startOffset >= offset){ // Check if there is room to do this cursor move.
                        clearBlinkingCursor();
                        x = gCurrentSelection.startOffset - offset;
                        gCurrentSelection.startCharacter = getCharacterForX(gCurrentSelection.startLine, &x);
                        gCurrentSelection.startOffset = x;
                        gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
                        gCurrentSelection.endOffset = gCurrentSelection.startOffset;
                        markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter, gCurrentSelection.endLine, gCurrentSelection.endCharacter);
                        makeBlinkVisible(true);
                    }
                }
            }
            else{
                // Block Shift Left
                doBlockShiftLeft();
            }
            gSelectionMadeWith = key_ShiftTab;
            handled = true;
            break;

        case KbSup_PageLeft:
            scrollScreen(screenScrollDirectionLeft);
            gSelectionMadeWith = key_PageLeft;
            handled = true;
            break;

        case KbSup_PageRight:
            scrollScreen(screenScrollDirectionRight);
            gSelectionMadeWith = key_PageRight;
            handled = true;
            break;

        default:
            gSelectionMadeWith = key_None;
            handled = false;
            break;
        }
    return handled;
}

Boolean handleKeyboardKey(struct _KeyDownEventType key){
   // #846728 (S016) External Keyboard Support

   UInt16 chr = (UInt16)key.chr;
   UInt16 keyCode = (UInt16)key.keyCode;
   UInt16 modifiers = (UInt16)key.modifiers;
   int i = 0;

   if (modifiers & autoRepeatKeyMask) // 0x0040 (PPK, PWK, UTK, BWK, ADK)
    modifiers -= autoRepeatKeyMask;
/*
   char str[40];
   StrPrintF(str, "0x%x 0x%x 0x%x", chr, keyCode, modifiers);
   error(str);
*/

   do{
    if (chr == gKbSup_KeyboardTable[i].KbSup_chr)
        if (keyCode == gKbSup_KeyboardTable[i].KbSup_keyCode)
            if (modifiers == gKbSup_KeyboardTable[i].KbSup_modifiers){
                //error("Keyboard Key detected");
                return doKeyboardKey(gKbSup_KeyboardTable[i].KbSup_AsKey);
                }
    i++;
   }while (gKbSup_KeyboardTable[i].KbSup_chr != 0 && gKbSup_KeyboardTable[i].KbSup_AsKey != KbSup_None);
   return false;
}

Boolean handleKeyDown(struct _KeyDownEventType key)
{
    Boolean handled = true;

    if (hasSelection() && gKbSup_SupportedKeyboard !=KbSup_NoKeyboard){
        if (handleKeyboardKey(key)){
            return true;
        }
    }

    //  #848891 Treo keyboard support, #792166 SrcEdit: Alt key w. Treo BUG, #769745 ListType key w. Treo BUG
    if(key.modifiers & commandKeyMask)
        return false;

    char ch=key.chr;

    if (hasSelection()) {
        if (isEmptySelection() && isBlinkOnScreen()) {
            clearBlinkingCursor();
        }

        // #863546 Screen redraw bug
        // Redraw Screen if Cursor Line is NOT visible
        if ((gCurrentSelection.startLine > screenTopLine + LinesPerPage) || (screenTopLine - LinesPerPage >gCurrentSelection.startLine)){
            resetBufferToSelection();
            drawPage();
            }

        switch (ch) {
            case upArrowChr:
                doKeyboardKey(KbSup_Up);
                break;
            case downArrowChr:
                doKeyboardKey(KbSup_Down);
                break;
            case leftArrowChr:
                doKeyboardKey(KbSup_Left);
                break;
            case rightArrowChr:
                doKeyboardKey(KbSup_Right);
                break;
        }
        if (isEmptySelection()) {
            switch (ch) {
                case backspaceChr :
                    backspace();
                    // if we were at the start of a line, rebuild everything,
                    // otherwise just re-draw the line we were on.
                    if (gCurrentSelection.startCharacter == 0) {
                        redrawPage();
                        drawBlinkingCursor();
                        gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
                    }
                    else {
                        TEXT_ASSERT((gCurrentSelection.startLine >= screenTopLine), "Buffer out of sync");
                        TEXT_ASSERT((gCurrentSelection.startLine < (screenTopLine + LinesPerPage)), "Buffer out of sync");
                        gCurrentSelection.startCharacter--;
                        char deletedCh = bufferedLineContents[gCurrentSelection.startLine - screenTopLine].text[gCurrentSelection.startCharacter];
                        if (deletedCh == tabChr) {
                            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, false);
                        }
                        else {
                            if ((unsigned char)deletedCh == CLOSURE_CHAR) { // XXX URK - is this legal ????
                                gCurrentSelection.startOffset -= gClosureCharWidth;
                            }
                            else {
                                gCurrentSelection.startOffset -= FntCharWidth(deletedCh);
                            }
                        }
                        getLineIntoBuffer(gCurrentSelection.startLine);
                        drawLine(gCurrentSelection.startLine, true);
                        drawBlinkingCursor();
                        gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
                    }
                    break;
                case linefeedChr :
                case crChr : {
                        int leadingSpaceCount = 0;
                        char *curLine = NULL;
                        // don't insert spaces for autoIndent if the newline is being inserted at the start of a line
                        if (gAutoIndent && (gCurrentSelection.startCharacter > 0)) {
                            curLine = bufferedLineContents[gCurrentSelection.startLine - screenTopLine].text;
                            while (curLine[leadingSpaceCount]) {
                                if ((curLine[leadingSpaceCount] != tabChr) && (curLine[leadingSpaceCount] != spaceChr)) {
                                    break;
                                }
                                else {
                                    leadingSpaceCount++;
                                }
                            }
                        }
                        insertNewLine();
                        if (leadingSpaceCount > 0) {
                            insertCharacters(curLine, leadingSpaceCount, true);
                        }
                        redrawPage();
                        drawBlinkingCursor();
                        gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
                    }
                    break;
                default :
                    // #846827 (S043) Long Line Hang
                    if ((gCurrentSelection.startCharacter +1 >= MAX_CHARS_PER_LINE -1))
                    {
                        insertNewLine();
                        redrawPage();
                    }
                    if ((ch == tabChr) || ((unsigned char)ch >= spaceChr) || ch==23 /*(add suport for the shortcut char)*/) {
                        // #847961 (S061) Add Tab/Spaces option
                        UInt8 numChars = 1;
                        if (gUseTabForTab == false && ch == tabChr){
                          ch = spaceChr;
                          for (int x = 0; x<gTabSpaces; x++)
                            insertCharacters(&ch, 1, true);
                          numChars = gTabSpaces;
                        }
                        else{
                            insertCharacters(&ch, 1, true);
                        }

                        if (gAutoParen)  autoInsertParen(ch);

                        getLineIntoBuffer(gCurrentSelection.startLine);
                        drawLine(gCurrentSelection.startLine, true);
                        gCurrentSelection.startCharacter++;
                        if (ch == tabChr) {
                            gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, false);
                        } else if ((unsigned char)ch == CLOSURE_CHAR) {    // XXX URK - is this legal ????
                            gCurrentSelection.startOffset += gClosureCharWidth; // can't ever happen
                        } else {
                            gCurrentSelection.startOffset += FntCharWidth(ch) * numChars;  // #847961 (S061) Add Tab/Spaces option
                        }
                        drawBlinkingCursor();
                        gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay
                    }
                    else
                    {
                        handled = false;
                    }
                    break;
            }
            gCurrentSelection.endLine = gCurrentSelection.startLine;
            gCurrentSelection.endOffset = gCurrentSelection.startOffset;
            gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
            // if selection start has now shifted offscreen, scroll it back into view

            // we know the selection is empty, so pass NULL as
            // the selection for all the scroll calls
            if (gCurrentSelection.startLine < screenTopLine) {
                while (gCurrentSelection.startLine < screenTopLine) {
                    scrollUp(NULL);
                }
                //drawPage();
            }
            else if (gCurrentSelection.startLine >= (screenTopLine + LinesPerPage)) {
                while (gCurrentSelection.startLine >= (screenTopLine + LinesPerPage)) {
                    scrollDown(NULL);
                }
                //drawPage();
            }
            if (gCurrentSelection.startOffset < (screenXOrigin + 5)) {
                while (gCurrentSelection.startOffset < (screenXOrigin + 5)) {
                    if (screenXOrigin == 0) {
                        break;
                    }
                    scrollLeft(NULL, 10);
                    //drawPage();
                }
            }
            else if (gCurrentSelection.startOffset >= (screenXOrigin + PageWidth)) {
                while ((gCurrentSelection.startOffset + 5) >= (screenXOrigin + PageWidth)) {
                    if (screenXOrigin > (UInt16)((DocumentWidth - PageWidth) - 10)) {
                        break;
                    }
                    scrollRight(NULL, 10);
                    //drawPage();
                }
            }
        }
        else {  // assume worst case and re-build the current page
            if (ch == tabChr){  // #846728 (S016) External Keyboard Support
                doBlockShiftRight();
                }
            if (ch == backspaceChr)  {
                backspace();
            }
            else {
                if (ch == '\n') {
                    insertNewLine();
                } else {
                    if (ch >= spaceChr) {
                        insertCharacters(&ch, 1, true);
                        if (gAutoParen) {
                            autoInsertParen(ch);
                        }
                    } else {
                        handled = false;
                    }
                }
            }
            if (handled) {
                redrawPage();
            }
        }
        if (handled) {
            setBlinkCharacter();
        }
    }
    return handled;
}

void handlePenDownInPage(short x, short y, Boolean selectionWasEmpty)
{
    // error("Led.cpp/handlePenDownInPage()");

    Boolean penIsDown;
    //RectangleType r = { {0, 0}, {PageWidth, PageHeight} };
    EvtGetPen(&x, &y, &penIsDown);

    SelectionRange currentSelection = gCurrentSelection;    // modify a local in the loop so that the blink location is constant

    while (penIsDown) {
        if ((x < PageXOrigin) && (screenXOrigin > 0)) {
            scrollLeft(selectionWasEmpty ? NULL : &currentSelection, 5);
            x = PageXOrigin;
        } else {
            if ((x >= (PageXOrigin + PageWidth)) && ((screenXOrigin + PageWidth) < (UInt16)DocumentWidth)) {
                scrollRight(selectionWasEmpty ? NULL : &currentSelection, 5);
                x = PageXOrigin + PageWidth - 1;
            } else {
                if ((y < PageYOrigin) && (screenYOrigin > 0)) {
                    if (selectionWasEmpty) {
                        scrollUp(NULL);
                    } else {
                        scrollUp(&currentSelection);
                    }
                    y = PageYOrigin;
                } else {
                    if ((y >= (PageYOrigin + PageHeight)) && ((screenYOrigin + PageHeight) < (gMaxLines * FontHeight))) {
                        if (selectionWasEmpty) {
                            scrollDown(NULL);
                        } else {
                            scrollDown(&currentSelection);
                        }
                        y = PageYOrigin + PageHeight - 1;
                    }
                }
            }
        }
        int actualPageHeight = PageHeight;
        if ((screenTopLine + LinesPerPage) > gMaxLines) {
            actualPageHeight = (gMaxLines - screenTopLine) * FontHeight;
        }

        if ((x >= PageXOrigin) && (x < (PageXOrigin + PageWidth))
                && (y >= PageYOrigin) && (y < PageYOrigin + actualPageHeight)) {
            SelectionRange newSelection;
            SelectionRange difference;
            Boolean selectionIsEmpty = buildSelection(x, y, &newSelection);
            if (selectionWasEmpty) {
                if (!selectionIsEmpty) {    // just need to remove the blink and invert the selection
                    eraseBlinkingCursor();
                    invertSelectionOnPage(&newSelection, false);
                    selectionWasEmpty = false;
                }
                // else, still empty, just leave be
                // #892131 doubble cursors
                else
                {
                    eraseBlinkingCursor();
                }

            } else {
                if (selectionIsEmpty) { // blow off the previous selection (and draw the blink)
                    invertSelectionOnPage(&currentSelection, false);
                    // drawBlinkingCursor(); // #892131 doubble cursors
                    selectionWasEmpty = true;
                } else { // have to find the difference and invert that
                    if (disjointSelection(&currentSelection, &newSelection)) {  // flipped to opposite side
                        invertSelectionOnPage(&currentSelection, false);
                        invertSelectionOnPage(&newSelection, false);
                    } else {
                        calculateSelectionDifference(&currentSelection, &newSelection, &difference);
                        invertSelectionOnPage(&difference, false);
                    }
                }
            }
            currentSelection = newSelection;
        }
        EvtGetPen(&x, &y, &penIsDown);
    }
    // if(hasSelection() && isEmptySelection())
    // #892131 doubble cursors
    clearBlinkingCursor();

    gCurrentSelection = currentSelection;

    markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                    gCurrentSelection.endLine, gCurrentSelection.endCharacter);

    // gBlinkTime = TimGetTicks() + BlinkDelay;            // reset the blink delay

    //gBlinkDrawn = true;                                 // if it was empty at the end, it was drawn already
}

//
//  the supplied lines are page-relative, both start and end line are included in the inversion
//
/***********************************************************************
 *
 * FUNCTION:    invertLinesOnPage
 *
 * DESCRIPTION: this routine
 *
 * PARAMETERS:  startOffset   -
 *
 *              endLine       -
 *
 *              offscreen     -
 *
 *
 * RETURNED:    none
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
void invertLinesOnPage(unsigned int startLine, unsigned int endLine,
	Boolean offscreen)
{
    TEXT_ASSERT((startLine < LinesPerPage), "page line out of range");
    TEXT_ASSERT((endLine < LinesPerPage), "page line out of range");

    if (endLine >= startLine) {
        if (!offscreen) {   // clip to Page
            RectangleType r = { {PageXOrigin, PageYOrigin + (startLine * FontHeight)} ,
                                {PageWidth, (endLine - startLine + 1) * FontHeight} };
            WinInvertRectangle(&r, 0);
        }
        else {
            RectangleType r = { {0, (startLine * FontHeight) },
                                { DocumentWidth, (endLine - startLine + 1) * FontHeight} };
            WinInvertRectangle(&r, 0);
        }
    }
}

/***********************************************************************
 *
 * FUNCTION:    invertPartialLineOnPage
 *
 * DESCRIPTION: this routine
 *
 * PARAMETERS:  line          -
 *
 *              startOffset   -
 *
 *              endOffset     -
 *
 *              offscreen     -
 *
 *
 * RETURNED:    none
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
void invertPartialLineOnPage(unsigned int line,
	unsigned int startOffset, unsigned int endOffset, Boolean offscreen)
{
    TEXT_ASSERT((endOffset >= startOffset), "backwards partial line");
    TEXT_ASSERT((line < LinesPerPage), "page line out of range");

    if (!offscreen) {   // clip to Page
        if (startOffset >= (screenXOrigin + PageWidth)) {
            return;
        }
        if (endOffset < screenXOrigin) {
            return;
        }
        if (startOffset < screenXOrigin) {
            startOffset = screenXOrigin;
        }
        if (endOffset >= (screenXOrigin + PageWidth)) {
            endOffset = screenXOrigin + PageWidth;
        }

        RectangleType r = { {PageXOrigin + (startOffset - screenXOrigin), PageYOrigin + (line * FontHeight)},
                            {(endOffset - startOffset), FontHeight} };
        WinInvertRectangle(&r, 0);
    }
    else {
        RectangleType r = { {startOffset, (line * FontHeight)},
                            {(endOffset - startOffset), FontHeight} };
        WinInvertRectangle(&r, 0);
    }

}

/***********************************************************************
 *
 * FUNCTION:    invertSelectionOnPage
 *
 * DESCRIPTION: this routine
 *
 * PARAMETERS:  Selection      -
 *
 *              offscreen      - new selection
 *
 *
 * RETURNED:    none
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
void invertSelectionOnPage(SelectionRange *selection, Boolean offscreen)
{
    WinHandle onscreen=0;

    unsigned int screenBottomLine = screenTopLine + LinesPerPage;
    if (offscreen) {
        onscreen = WinSetDrawWindow(gOffscreenPage);
    }
    else {
        WinSetClip(&gClipRect);
    }

    if ((selection->startLine < screenBottomLine)
            && (selection->endLine >= screenTopLine)) {

        if (selection->startLine < screenTopLine) { // selection begins before the displayed page
            if (selection->endLine >= screenBottomLine) {   // and ends after
                // just the complete lines in between
                invertLinesOnPage(0, LinesPerPage - 1, offscreen);
            }
            else {
                unsigned int lastLine = selection->endLine - screenTopLine;
                if (lastLine > 0) {
                    invertLinesOnPage(0, lastLine - 1, offscreen);
                }
                invertPartialLineOnPage(lastLine, 0, selection->endOffset, offscreen);
            }
        }
        else {
            if (selection->startLine == selection->endLine) {
                invertPartialLineOnPage(selection->startLine - screenTopLine, selection->startOffset, selection->endOffset, offscreen);
            }
            else {
                invertPartialLineOnPage(selection->startLine - screenTopLine, selection->startOffset, DocumentWidth, offscreen);
                if (selection->startLine < (screenBottomLine - 1)) {
                    if (selection->endLine >= screenBottomLine) {
                        invertLinesOnPage((selection->startLine - screenTopLine) + 1, LinesPerPage - 1, offscreen);
                    }
                    else {
                        unsigned int lastLine = selection->endLine - screenTopLine;
                        if (lastLine > 0) {
                            invertLinesOnPage((selection->startLine - screenTopLine) + 1, lastLine - 1, offscreen);
                        }
                        invertPartialLineOnPage(lastLine, 0, selection->endOffset, offscreen);
                    }
                }
            }
        }
    }

    if (offscreen)
        WinSetDrawWindow(onscreen);
    else
        WinResetClip();

}

void loadLine(int line, char *text, unsigned int *textLength)
{
    SegmentData *sdp = getLineContents(line);
    int length = 0;
/*
    for (int j = 0; j < sdp->count; j++) {
        if (sdp->segment[j].kind == PlainText)
            length += sdp->segment[j].length;
        else {  // treat contiguous collapsed text chunks as a single occurrence
            length++;
            while ((j < sdp->count) && (sdp->segment[j].kind != PlainText)) j++;
        }
        TEXT_ASSERT((length < MAX_CHARS_PER_LINE), "Too many characters per line");
    }
*/
    char *tp = text;

    int index = 0;
    unsigned int j = 0;
    while (j < sdp->count) {
        if (index == (MAX_CHARS_PER_LINE - 1)) {
            break;
        }
        if (sdp->segment[j].kind == PlainText) {
            int len = sdp->segment[j].length;
            length += len;
            char *cp = sdp->segment[j].text;
            for (int k = 0; k < len; k++) {
                tp[index++] = cp[k];
                if (index == (MAX_CHARS_PER_LINE - 1)) {
                    break;
                }
            }
            j++;
        }
        else {  // treat contiguous collapsed text chunks as a single occurrence
            length++;
            tp[index++] = CLOSURE_CHAR;
            while ((j < sdp->count) && (sdp->segment[j].kind != PlainText)) j++;
        }
    }
    tp[index] = '\0';
    *textLength = length;
//  TEXT_ASSERT((length < MAX_CHARS_PER_LINE), "Too many characters per line");
}

/***********************************************************************
 *
 * FUNCTION:    loadLineIntoBuffer
 *
 * DESCRIPTION: this routine
 *
 * PARAMETERS:  line      -
 *
 *              bufIndex  -
 *
 *
 *
 * RETURNED:    none
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
void loadLineIntoBuffer(int line, int bufIndex)
{
    loadLine(line, bufferedLineContents[bufIndex].text, &bufferedLineContents[bufIndex].length);
}

/***********************************************************************
 *
 * FUNCTION:    MainFormInit
 *
 * DESCRIPTION: this routine initializes the MainForm form.
 *
 * PARAMETERS:  frm - pointer to the MainForm form.
 *
 * RETURNED:    nothing
 *
 * REVISION HISTORY:
 *
 *
 ***********************************************************************/

void MainFormInit(FormPtr frmP)
{
    ScrollBarPtr bar = (ScrollBarPtr)getObjectPtr(frmP, MainDocumentScrollBar);
    int sclMax = (gMaxLines > LinesPerPage) ? gMaxLines - LinesPerPage /*+1*/ : 0;
    SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
    if (hasSelection()) {
        resetBufferToSelection();
        if (hasSelection())
            setBlinkCharacter();
    }
    drawPage();
//  for (int i = gToolbarStart; i < (gToolbarStart + VisibleToolbarEntries); i++) {
//      ControlPtr ctlP = (ControlPtr)getObjectPtr(frmP, MainButton0Button + (i - gToolbarStart));
//      ctlP->font = gToolbar[i].font;
//      CtlSetLabel(ctlP, gToolbar[i].key);   05/12/2002
//  }
    if(gFirstStart){
        getKeyRates();
        gFirstStart = false;
    }
}

/******************************************************************************
 *
 ******************************************************************************/
Boolean nullButton() { return true; }



void redrawPage()
{
    if ((screenTopLine + LinesPerPage) > gMaxLines) {
        if (gMaxLines > LinesPerPage) {
            screenTopLine = gMaxLines - LinesPerPage;
        }
        else {
            screenTopLine = 0;
        }
        screenYOrigin = screenTopLine * FontHeight;
    }
    if ( (gCurrentSelection.startOffset < screenXOrigin + 5) || (gCurrentSelection.startOffset >= screenXOrigin + PageWidth))
        screenXOrigin = gCurrentSelection.startOffset;
    if ( screenXOrigin > (UInt16)(DocumentWidth - PageWidth) ) {
        screenXOrigin = DocumentWidth - PageWidth;
    }
    while(screenXOrigin%10)
        screenXOrigin--;

    fillLineBuffer(screenTopLine);

    setGUISelection(false);
    if (isEmptySelection()) {
        setBlinkCharacter();
    }

    FormPtr frmP = FrmGetActiveForm();
    ScrollBarPtr bar = (ScrollBarPtr)getObjectPtr(frmP, MainDocumentScrollBar);
    int sclMax = (gMaxLines > LinesPerPage) ? gMaxLines - LinesPerPage /*+1*/ : 0;
    SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
    drawPage();
}

void refillBuffer()
{
    // reset the screen to show the selection point half way down
    // unless we're not far enough in to allow that, or too far
    if (gMaxLines > LinesPerPage) {
        if (gCurrentSelection.startLine < ((Word)LinesPerPage >> 1)) {
            screenTopLine = 0;
        }
        else {
            if ((gCurrentSelection.startLine + (LinesPerPage >> 1)) > gMaxLines) {
                screenTopLine = (gMaxLines - LinesPerPage);
            }
            else {
                screenTopLine = (gCurrentSelection.startLine - (LinesPerPage >> 1));
            }
        }
    }
    else {
        screenTopLine = 0;
    }

    screenYOrigin = screenTopLine  * FontHeight;

    if ((screenTopLine + LinesPerPage) > gMaxLines) {
        if (gMaxLines < LinesPerPage) {
            fillLineBuffer(screenTopLine);
        }
        else {
            fillLineBuffer(gMaxLines - LinesPerPage);
        }
    }
    else {
        fillLineBuffer(screenTopLine);
    }
}

void refreshPageContents()
{
    TEXT_ASSERT((screenXOrigin <= (UInt16)(DocumentWidth - PageWidth)), "X origin out of place");

    RectangleType r = { {screenXOrigin, 0}, {PageWidth, PageHeight} };
    WinCopyRectangle(gOffscreenPage, 0, &r, PageXOrigin, PageYOrigin, scrCopy);

    // checkScreenXState(); // #895637 grey out Left/Right arrows
    gBlinkDrawn = 0;
}

void resetBufferToSelection()
{
    // need to make sure the selection line is in the buffer
    if ((gCurrentSelection.startLine < screenTopLine)
            || (gCurrentSelection.startLine >= (screenTopLine + LinesPerPage))) {
        refillBuffer();
        FormPtr frmP = FrmGetActiveForm();
        ScrollBarPtr bar = (ScrollBarPtr)getObjectPtr(frmP, MainDocumentScrollBar);
        int sclMax = (gMaxLines > LinesPerPage) ? gMaxLines - LinesPerPage /*+1*/ : 0;
        SclSetScrollBar(bar, screenTopLine, 0, sclMax, LinesPerPage);
        adjustXOrigin();
    //  drawPage();
    }
}

/***********************************************************************
 *
 * FUNCTION:    RomVersionCompatible
 *
 * DESCRIPTION: this routine checks that a ROM version is meet your
 *              minimum requirement.
 *
 * PARAMETERS:  requiredVersion - minimum rom version required
 *                                (see sysFtrNumROMVersion in SystemMgr.h
 *                                for format)
 *              launchFlags     - flags that indicate if the application
 *                                UI is initialized.
 *
 * RETURNED:    error code or zero if rom is compatible
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
static Err RomVersionCompatible(DWord requiredVersion, Word launchFlags, DWord &romVersion)
{
    // See if we're on in minimum required version of the ROM or later.
    FtrGet(sysFtrCreator, sysFtrNumROMVersion, &romVersion);
    if (romVersion < requiredVersion) {
        if ((launchFlags & (sysAppLaunchFlagNewGlobals | sysAppLaunchFlagUIApp)) ==
            (sysAppLaunchFlagNewGlobals | sysAppLaunchFlagUIApp)) {
            FrmAlert (RomIncompatibleAlert);
#ifdef ROM10
            // Pilot 1.0 will continuously relaunch this app unless we switch to
            // another safe one.
            if (romVersion < version20) {
                Err err;

                AppLaunchWithCommand(sysFileCDefaultApp, sysAppLaunchCmdNormalLaunch, NULL);
            }
#endif
        }
        return ((Err) -1);
    }

    return (0);
}

void setBlinkCharacter()
{
    if ((gCurrentSelection.startLine < screenTopLine) ||
        (gCurrentSelection.startLine >= (screenTopLine + LinesPerPage))) {
        return;
    }
    gBlinkCharacter = bufferedLineContents[gCurrentSelection.startLine - screenTopLine].text[gCurrentSelection.startCharacter];
}

void setGUISelection(Boolean forceLoad)
{
    //  reconstruct the GUI side of the selection by getting
    //  the document selection and calculating the pixel offset
    if (hasSelection()) {
        Word fromLine, toLine, fromOffset, toOffset;
        getSelection(&fromLine, &fromOffset, &toLine, &toOffset);
        gCurrentSelection.startLine = fromLine;
        gCurrentSelection.startCharacter = fromOffset;
        gCurrentSelection.startOffset = getXForCharacter(fromLine, fromOffset, forceLoad);
        gCurrentSelection.endLine = toLine;
        gCurrentSelection.endCharacter = toOffset;
        gCurrentSelection.endOffset = getXForCharacter(toLine, toOffset, forceLoad);
    }
}

static void setHandle(FormPtr frmP, int fieldID, Handle newH, Boolean editable,Boolean redraw)
{
    FieldAttrType attr;
    FieldPtr fld = (FieldPtr)getObjectPtr(frmP, fieldID);
    Handle oldH = (Handle)FldGetTextHandle(fld);

    MemHandleUnlock(newH);
    FldSetText(fld, newH, 0, MemHandleSize(newH));

    FldGetAttributes(fld, &attr);
    attr.editable = editable;
    FldSetAttributes(fld, &attr);

    if (redraw && frmP == FrmGetActiveForm()) {
        FldDrawField(fld);
    }
    if (oldH != NULL) {
        MemHandleFree(oldH);
    }
}

void setHandleFromInt(FormPtr frmP, int fieldID, int value, Boolean editable,Boolean redraw)
{
    Handle h = (Handle)MemHandleNew(16);
    CharPtr p = (CharPtr)MemHandleLock(h);
    StrPrintF(p, "%d", value);

    setHandle(frmP, fieldID, h, editable,redraw);
}

void setIntFromHandle(FormPtr frmP, int fieldID, char *base, int offset, Boolean check)
{
    FieldPtr fld = (FieldPtr)getObjectPtr(frmP, fieldID);
    Handle h = FldGetTextHandle(fld);
    if (h != NULL) {
        CharPtr p = (CharPtr)MemHandleLock(h);
        int value = StrAToI(p);
        if (check) {
            DmWrite(base, offset, &value, 2);
        }
        else {
            *((short *)(base + offset)) = value;
        }
        MemHandleUnlock(h);
    }
    else {
        int value = 0;
        if (check) {
            DmWrite(base, offset, &value, 2);
        }
        else {
            *((short *)(base + offset)) = value;
        }
    }
}

// set the 'start' selection details from a pen location
/***********************************************************************
 *
 * FUNCTION:    setStartPosition
 *
 * DESCRIPTION: this routine sets the 'start' selection details from
 *              a pen location.
 *
 * PARAMETERS:  x  -
 *
 *              y  -
 *
 *
 *
 * RETURNED:    none
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
void setStartPosition(int x, int y)
{
    convertScreenXYToDocumentXY(&x, &y);
    startLine = y / FontHeight;
    startCharacter = getCharacterForX(startLine, &x);
    startOffset = x;
}

/******************************************************************************
 *
 ******************************************************************************/
// The OS 3.0 version of WinSetText color. It also sets the UI color, so we have to change
// back the color (i.e. SetTextColor(0xF);) after the text is drawn.
IndexedColorType __SetTextColor30__(IndexedColorType col) {
    if(!gColorMode)
        return 0;
    RGBColorType source = {0,0,0,0};
    RGBColorType dest;

    source.index=0;
    source.r=(0xF-col)*0x11;
    source.g=source.r;
    source.b=source.r;

    WinSetColors(&source,&dest,0,0);
    return dest.index;
}

/******************************************************************************
 *
 ******************************************************************************/
// OS 3.5 version of WinSetTextColor. Have to use it since WinSetColors is officially unsupported
// and unavailable on DirectColor systems.
IndexedColorType __SetTextColor35__(IndexedColorType col)
{
    if(!gColorMode)
        return 0;
    return WinSetTextColor(col);
}


short sortFn(void *A, void *B, long other)
{
    char *a = *((char **)A);
    char *b = *((char **)B);
    return StrCompare(a, b);
}

/*

// Not used for now... Uncomment before using this !
static void setTextFromHandle(FormPtr frmP, int fieldID, char *value)
{
    FieldPtr fld = (FieldPtr)getObjectPtr(frmP, fieldID);
    Handle h = FldGetTextHandle(fld);
    if (h != NULL) {
        CharPtr p = (CharPtr)MemHandleLock(h);
        StrCopy(value, p);
        MemHandleUnlock(h);
    }
    else
        *value = '\0';
}
*/

/*
    Total reconstruction of lineBuffer, selection, scrollbars etc, plus update to screen
*/

/*
static Boolean doCollapse()
{
//  collapseText('{', '}');
//  redrawPage();
    return true;
}

static Boolean doUncollapse()
{
//  uncollapseText(gCurrentSelection.startLine, gCurrentSelection.startCharacter);
//  setGUISelection(false);
//  redrawPage();
    return true;
}

static Boolean doCollapseAll()
{
//  collapseAll('{', '}');
//  setGUISelection(false);
//  redrawPage();
    return true;
}
*/

/*
static Boolean doToggleForward()
{
    if (gFileListCount > 1) {
        gCurFile = (gCurFile + 1);
        if (gCurFile == gFileListCount) gCurFile = 0;
        saveDocFile(gCurrentFile, false);
        setSelectionForDB();
        StrCopy(gCurrentFile, gFileList[gCurFile]);
        loadDocFile(gCurrentFile);
        getSelectionForDB();
        fillLineBuffer(0);
        screenYOrigin = 0;
        screenTopLine = 0;
        MainFormInit(FrmGetActiveForm());
    }
    else
        FrmGotoForm(OpenForm);
    return true;
}

static Boolean doToggleBackward()
{
    if (gFileListCount > 1) {
        gCurFile = (gCurFile - 1);
        if (gCurFile < 0) gCurFile = gFileListCount - 1;
        saveDocFile(gCurrentFile, false);
        setSelectionForDB();
        StrCopy(gCurrentFile, gFileList[gCurFile]);
        loadDocFile(gCurrentFile);
        getSelectionForDB();
        fillLineBuffer(0);
        screenYOrigin = 0;
        screenTopLine = 0;
        MainFormInit(FrmGetActiveForm());
    }
    else
        FrmGotoForm(OpenForm);
    return true;
}
*/
/*
static Boolean doSearch()
{
    FormPtr frmP = FrmInitForm(SearchForm);
    FieldPtr fldP = (FieldPtr)getObjectPtr(frmP, SearchSearchTextField);
    Word length;

    //If the clipboard has data, paste it in to the search field
    CharPtr clipP = getClipboard(&length);
    if (clipP) {
        ClipboardAddItem(clipboardText, clipP, length);
        MemPtrFree(clipP);
    }

    //if the user has highlighted a bit of text, that is less than one line, put that data into the search box
    if ((hasSelection()) && (!isEmptySelection()) &&
        (gCurrentSelection.startLine == gCurrentSelection.endLine)) {
        char curLine[MAX_CHARS_PER_LINE];
        unsigned int lineLength;
        loadLine(gCurrentSelection.startLine, curLine, &lineLength);
        int searchTextLength = gCurrentSelection.endCharacter - gCurrentSelection.startCharacter;
        Handle h = (Handle)FldGetTextHandle(fldP);
        Handle textH = (Handle)MemHandleNew(searchTextLength + 1);
        char *p = (char *)MemHandleLock(textH);
        for (Word x = gCurrentSelection.startCharacter; x < gCurrentSelection.endCharacter; x++) {
            *p++ = curLine[x]; //loop through the selection and dump it into the search string
        }
        *p = '\0'; //add a terminator to the search string
        MemHandleUnlock(textH);
        FldSetTextHandle(fldP, textH);
        FldSetSelection(fldP, 0, searchTextLength);
        if (h) {
            MemHandleFree(h);
        }
    }

    else // shouldn't there also be an else at the previous if?!
        if (gSearchTextH != NULL) { //what is this for?
            Handle h = (Handle)FldGetTextHandle(fldP);
            char *searchText = (char *)MemHandleLock(gSearchTextH); //grab the text...
            int searchTextLength = StrLen(searchText);
            Handle textH = MemHandleNew(searchTextLength + 1);
            char *p = (char *)MemHandleLock(textH);
            StrCopy(p, searchText);
            MemHandleUnlock(textH);
            MemHandleUnlock(gSearchTextH);
            FldSetTextHandle(fldP, textH);
            FldSetSelection(fldP, 0, searchTextLength);
            if (h) {
                MemHandleFree(h);
            }
        }

    ControlPtr ctlP = (ControlPtr)getObjectPtr(frmP, SearchIgnoreCaseCheckbox);
    CtlSetValue(ctlP, gIgnoreCase);
    ControlPtr ctlFrTopP = (ControlPtr)getObjectPtr(frmP, SearchFromTopCheckbox);
    CtlSetValue(ctlFrTopP, gSearchFromTop);

    FrmSetFocus(frmP, FrmGetObjectIndex(frmP, SearchSearchTextField));

    if (FrmDoDialog(frmP) == SearchOKButton) {
        gIgnoreCase = CtlGetValue(ctlP);
        gSearchFromTop = CtlGetValue(ctlFrTopP);
        if (gSearchTextH != NULL) {
            MemHandleFree(gSearchTextH);
        }
        gSearchTextH = NULL;
        Handle h = (Handle)FldGetTextHandle(fldP);
        if (h) {
            char *p = (char *)MemHandleLock(h);

            gSearchTextH = (Handle)MemHandleNew(StrLen(p) + 1);
            char *searchText = (char *)MemHandleLock(gSearchTextH);
            StrCopy(searchText, p);
            MemHandleUnlock(h);

            // S039 Search From Top
            UInt16 searchStartLine = gCurrentSelection.endLine;
            UInt16 searchStartCharacter = gCurrentSelection.endCharacter;
            if (gSearchFromTop){
                searchStartLine = 0;
                searchStartCharacter = 0;
                }

            if (search(searchStartLine, searchStartCharacter, searchText, gIgnoreCase, true)){
                setGUISelection(false);
                resetBufferToSelection();
                redrawPage();
                }
            MemHandleUnlock(gSearchTextH);
        }
    }
    FrmDeleteForm(frmP);
    return true;
}
*/


/*
Not used for now... Uncomment before using this !
static Boolean doFindObjectName()  // from doFindFunctionHeader
{
//  char *nameInsert;
//  char curLine[MAX_CHARS_PER_LINE];
//  int startCh, endCh;

//  find the form handler you are in -- from doFunctionList

//  extract the form name

//  load the resource header (this file's name with .h instead of .c as the extension)
    saveDocFile(gCurrentFile, false);
    setSelectionForDB();
    loadDocFile("this file's name.h");

//  build a list of objects whose names begin with the form name -- see doFunctionList

    return true;
}
*/

/*
static Boolean doToolsForSelectionPopup() {
    // #
    FormPtr frmP = FrmGetActiveForm();
    char popToolsItem0[19];
    char popToolsItem1[19];
    char popToolsItem2[19];
    char popToolsItem3[19];
    char popToolsItem4[19];
    char popToolsItem5[19];
    StrCopy(popToolsItem0,"Cut");
    StrCopy(popToolsItem1,"Copy");
    StrCopy(popToolsItem2,"Paste");
    StrCopy(popToolsItem3,"Find/Replace");
    StrCopy(popToolsItem4,"Comment");
    StrCopy(popToolsItem5,"Uncomment");
    char *popToolsList[6] = {popToolsItem0,popToolsItem1,popToolsItem2,popToolsItem3,popToolsItem4,popToolsItem5};
    ListPtr lstP = (ListPtr)getObjectPtr(frmP, MainPopToolsForSelectionList );
    LstSetListChoices(lstP,(char **)popToolsList,6);
    UInt16 index = LstPopupList(lstP);
    switch (index)  {
        case 0: //Cut Selection
            doCut();
            break;
        case 1: //Copy Selection
            doCopy();
            break;
        case 2: //Paste (over Selection)
            doPaste();
            break;
        case 3: //Replace Selection
            doFindReplace();
            break;
        case 4: //Comment Selection
            doComment();
            break;
        case 5: // Uncomment Selection
            doUncomment();
            break;
    }
    return true;
}
*/

/***********************************************************************
 *
 * FUNCTION:    MainFormDoCommand
 *
 * DESCRIPTION: this routine performs the menu command specified.
 *
 * PARAMETERS:  command  - menu item id
 *
 * RETURNED:    nothing
 *
 * REVISION HISTORY:  -
 *                    24 dec 2003, added (S055) MainOptionsFileInfo
 *
 ***********************************************************************/


Boolean MainFormDoCommand(Word command)
{
    Boolean handled = false;

    switch (command) {

        case EditCut :
            doCut();
            handled = true;
            break;

        case EditCopy :
            doCopy();
            handled = true;
            break;

        case EditPaste :
            doPaste();
            handled = true;
            break;

        case EditUndo :
            doUndo();
            handled = true;
            break;

        case EditFindReplace :
            doFindReplace();
            handled = true;
            break;

        case EditSelectAll :    // #891109 Select All
            doSelectAll();
            handled = true;
            break;

        case EditCommentSelection : // (S053)
            doCommentSelection();
            handled = true;
            break;

        case EditUnCommentSelection : // (S053)
            doUncommentSelection();
            handled = true;
            break;

        case EditKeyboard :     // (S040)
            doPreKeyboard();
            SysKeyboardDialog(kbdDefault);
            handled = true;
            break;

        case MainOptionsConfigureToolbar :
            //FrmGotoForm(ConfigureForm);
            FrmPopupForm(ConfigureForm);
            handled = true;
            break;

        case MainOptionsPreferences :
            //FrmGotoForm(PreferencesForm);
            FrmPopupForm(PreferencesForm);
            handled = true;
            break;

        case MainOptionsOpen:
            FrmGotoForm(OpenForm);
            handled = true;
            break;

        case MainOptionsNew: {
                NewFile();
            handled = true;
            }
            break;

        case MainOptionsSaveas: {
            SaveAs();
            handled = true;
            }
            break;

        case MainOptionsDelete:  // (S056)
            FrmPopupForm(DeleteForm);
            handled = true;
            break;

        case MainOptionsTabsSpaces:
            doTabsSpaces();
            handled = true;
            break;

        case MainOptionsKeyboardSupport:
            FrmPopupForm(KeyboardSupportForm);
            handled = true;
            break;

        case MainOptionsToggleAutoParen:
            doAutoParen();
            handled = true;
            break;

        case MainOptionsFileInfo:  // (S055)
            FrmPopupForm(FileInfoAttributesForm);
            handled = true;
            break;

        case MainOptionsAboutSrcEdit:
            //FrmGotoForm(AboutForm);
            FrmPopupForm(AboutForm);
            handled = true;
            break;

        case EditKeywdComplete:
            doKeywordCompletion();
            handled = true;
            break;

        case EditHeaderParams:
            doFindFunctionHeader();
            handled = true;
            break;

        case NavigateGotoLine:
            FrmPopupForm(GotoLineForm);
            handled = true;
            break;

        case NavigateLaunchOBC:
            doLaunchOnBoardC();
            handled = true;
            break;

/*      case NavigateToggleFwd:
            //doToggleForward();
            handled = true;
            break;

        case NavigateToggleBkwd:
            //doToggleBackward();
            handled = true;
            break;
*/
        case NavigateFunctionBookmk:
            doFunctionList();
            handled = true;
            break;
/*
        case NavigateFind:
            doSearch();
            handled = true;
            break;
*/
        case NavigateFindAgain:
            doSearchAgain();
            handled = true;
            break;

    }
    return handled;
}

void eraseBlinkingCursor()
{
    if(!gBlinkDrawn)
        return;
    WinSetClip(&gClipRect);
    int blinkY = gCurrentSelection.startLine * FontHeight;
    int blinkX = gCurrentSelection.startOffset;
    convertDocumentXYToScreenXY(&blinkX, &blinkY);

    gBlinkDrawn = false;

    // handle blink at the edge by shifting the blink to the right, rather
    // than putting up with a half-width cursor
    int disp = -1;
    if (blinkX == PageXOrigin) {
        disp = 1;
    }

    WinInvertLine(blinkX, blinkY + BlinkingCursorTopOffset, blinkX, blinkY + BlinkingCursorTopOffset + BlinkingCursorHeight);
    WinInvertLine(blinkX + disp, blinkY + BlinkingCursorTopOffset, blinkX + disp, blinkY + BlinkingCursorTopOffset + BlinkingCursorHeight);
    /*if (gBlinkCharacter != '\0') {
        if ((unsigned char)gBlinkCharacter == CLOSURE_CHAR) {
            FontID curFont=(FontID)0;
            if (gLED_ClosureFont) {
                curFont = FntSetFont(gLED_ClosureFont);
            }
            WinDrawChars(&gBlinkCharacter, 1, blinkX, blinkY);
            if (gLED_ClosureFont) {
                FntSetFont(curFont);
            }
        }
        else {
            WinDrawChars(&gBlinkCharacter, 1, blinkX, blinkY);
        }
    }*/
    WinResetClip();
}

void drawBlinkingCursor()
{
    if(gBlinkDrawn)
        return;

    WinSetClip(&gClipRect);
    int blinkY = gCurrentSelection.startLine * FontHeight;
    int blinkX = gCurrentSelection.startOffset;
    convertDocumentXYToScreenXY(&blinkX, &blinkY);

    int disp = -1;
    if (blinkX == PageXOrigin) {
        disp = 1;
    }

    gBlinkDrawn = true;

    WinInvertLine(blinkX, blinkY + BlinkingCursorTopOffset, blinkX, blinkY + BlinkingCursorTopOffset + BlinkingCursorHeight);
    WinInvertLine(blinkX + disp, blinkY + BlinkingCursorTopOffset, blinkX + disp, blinkY + BlinkingCursorTopOffset + BlinkingCursorHeight);
    WinResetClip();
}

Boolean isDocumentXYVisible(int offset, int line)
{
    line *= FontHeight;
    convertDocumentXYToScreenXY(&offset, &line);    // returns a x value that is not correct!
                                                    // However since there is much code that calculates
                                                    // with this bug.. it lookes like here is the right
                                                    // spot to correct this BUG.

    if (offset +1 == PageWidth)
        offset -=1;

    return ((offset >= 0) && (offset <= PageWidth)
                && (line >= 0) && (line <= PageHeight));
}

Boolean isBlinkOnScreen()
{
    int blinkY = gCurrentSelection.startLine * FontHeight;
    int blinkX = gCurrentSelection.startOffset;
    convertDocumentXYToScreenXY(&blinkX, &blinkY);  // returns a x value that is not correct!
                                                    // However since there is much code that calculates
                                                    // with this bug.. it lookes like here is the right
                                                    // spot to correct this BUG.

    if (blinkX +2 >= PageWidth)
        blinkX -=2;

    return ((blinkX >= 0) && (blinkX <= PageWidth)
                && (blinkY >= 0) && (blinkY <= PageHeight));  /// Was PageWidth!!!
}

void resetFieldUnderline(FormPtr frmP)
{
    for (Word i = 0; i < FrmGetNumberOfObjects(frmP); i++) {
        if (FrmGetObjectType(frmP, i) == frmFieldObj) {
            FieldType *fldP = (FieldType *)FrmGetObjectPtr(frmP, i);
            FieldAttrType attr;
            FldGetAttributes(fldP, &attr);
            if (attr.underlined == solidUnderline) {
                attr.underlined = grayUnderline;
                FldSetAttributes(fldP, &attr);
            }
        }
    }
}


static Boolean PreprocessEvent(EventPtr event){
    // Return true if event was processed and false otherwise

    UInt16 period = gOldPeriod/2; // twice as fast
    UInt16 repeatDelay = gOldRepeatDelay/2; // twice as fast
    UInt16 doubleTapDelay = 0x00; // Fast
    Boolean queueAhead = true;
    UInt16 err;
    if (event->eType == keyDownEvent){
        if (FrmGetActiveFormID() == MainForm){
            KeyRates(true, &repeatDelay, &period, &doubleTapDelay, &queueAhead);

            // Task: (S040) On Screen Keyboard
            // Test if "abc" or "123" was tapped before the System does.
            // If so: run doPreKeyboard(): to enable the KeybordDialog.
            if (event->data.keyDown.chr == vchrKeyboardAlpha || event->data.keyDown.chr == vchrKeyboardNumeric || event->data.keyDown.chr == vchrKeyboard){
                if(WinGetActiveWindow() !=(WinHandle)FrmGetActiveForm()){
                    EventPtr oldEvent = (EventPtr)MemPtrNew(sizeof(EventType));
                    EvtCopyEvent(event, oldEvent);
                    WinSetActiveWindow((WinHandle)FrmGetActiveForm());
                    EvtAddEventToQueue(oldEvent);
                    MemPtrFree(oldEvent);
                    return true;
                }
                if (hasSelection())
                    doPreKeyboard();
                return false;
            }


            if ((event->data.keyDown.chr == hardRightKey)&&(gUseHardKeysForScrolling == true)){
                // #846292 (S051) Use hard buttons to scroll
                if(!MenuHandleEvent(0, event, &err)) // We have to check for MenuEvents before we process this key event...
                    scrollScreen(screenScrollDirectionRight);
                return true;  // always return true
            }

            else if ((event->data.keyDown.chr == hardLeftKey)&&(gUseHardKeysForScrolling == true)){
                // #846292 (S051) Use hard buttons to scroll
                if(!MenuHandleEvent(0, event, &err)) // We have to check for MenuEvents before we process this key event...
                    scrollScreen(screenScrollDirectionLeft);
                return true;  // always return true
            }

            UInt32 keyState = KeyCurrentState();

            if (PAGE_UP(event, keyState) && gKbSup_SupportedKeyboard != KbSup_Treo90InternalKeyboard){
                //error("Led.cpp/PreprocessEvent()/Page_Up");
                if(!MenuHandleEvent(0, event, &err)) // We have to check for MenuEvents before we process this key event...
                    doKeyboardKey(KbSup_PageUp);
                return true; // Always return true!!!
            }
            if (PAGE_DOWN(event, keyState) && gKbSup_SupportedKeyboard != KbSup_Treo90InternalKeyboard){
                // error("Led.cpp/PreprocessEvent()/Page_Down");
                if(!MenuHandleEvent(0, event, &err)) // We have to check for MenuEvents before we process this key event...
                    doKeyboardKey(KbSup_PageDown);
                return true; // Always return true!!!
            }
            if (T_PAGERIGHT(event, keyState)){
                // error("Led.cpp/PreprocessEvent()/T_PageRight");
                if(!MenuHandleEvent(0, event, &err)) // We have to check for MenuEvents before we process this key event...
                    scrollScreen(screenScrollDirectionRight);
                return true; // Always return true!!!
            }
            if (T_PAGELEFT(event, keyState)){
                // error("Led.cpp/PreprocessEvent()/T_PageLeft");
                if(!MenuHandleEvent(0, event, &err)) // We have to check for MenuEvents before we process this key event...
                    scrollScreen(screenScrollDirectionLeft);
                return true; // Always return true!!!
            }

            if (event->eType == keyDownEvent && gKillNextKeyDownEvent == true){
                gKillNextKeyDownEvent = false;
                return true;
            }

            if (event->data.keyDown.chr == 0x1720 && hasSelection() && (gKbSup_SupportedKeyboard == KbSup_SonyNxInternalKeyboard || gKbSup_SupportedKeyboard == KbSup_SonyUxInternalKeyboard)){
                gKillNextKeyDownEvent = false;
                if(!MenuHandleEvent(0, event, &err)){ // We have to check for MenuEvents before we process this key event...
                    if (handleKeyboardKey(event->data.keyDown)){
                        // if (event->data.keyDown.keyCode != 0x0009) // special case fore chrTab since we're adding a keyDownEvent in DoKeyboardKey
                        gKillNextKeyDownEvent = true;
                        return true;
                    }
                    else{
                        return false;
                    }
                }
                else{
                    return true;
                }
            }

            if ((gKbSup_SupportedKeyboard == KbSup_Treo90InternalKeyboard && event->data.keyDown.modifiers & 0x0010) && ((event->data.keyDown.chr ==  0x001c && keyState == 0x00000002) || (event->data.keyDown.chr == 0x001d && keyState == 0x00000004))){
                return MenuHandleEvent(0, event, &err); // We have to check for MenuEvents before we process these key events..
            }

            return false;
        }
        // restore old Key state here!
        return false;
    }
    return false;
}

/***********************************************************************
 *
 * FUNCTION:    AppEventLoop
 *
 * DESCRIPTION: this routine is the event loop for the application.
 *
 * PARAMETERS:  nothing
 *
 * RETURNED:    nothing
 *
 * REVISION HISTORY:
 *
 *
 ***********************************************************************/
static void AppEventLoop(void)
{
    Word err;
    EventType event;
    Int32 timeout = 5; /* change timeout if you need periodic nilEvents */
    do {
        EvtGetEvent(&event, timeout);

        if (!PreprocessEvent(&event))
            if (! SysHandleEvent(&event))
                if (! MenuHandleEvent(0, &event, &err))
                    if (! AppHandleEvent(&event))
                        FrmDispatchEvent(&event);
    } while (event.eType != appStopEvent);
}

static void loadSystraps()
{
/*
    DmSearchStateType searchState;
    UInt cardNo;
    LocalID dbID;

    gCompletion = false;
    Err err = DmGetNextDatabaseByTypeCreator(true, &searchState, 'appl', 'OnBA', true, &cardNo, &dbID);
    if (err != 0) {
        error("Can't find OnBoard Assembler");
        return;
    }
    gAssemblerDB = DmOpenDatabase(cardNo, dbID, dmModeReadOnly);
*/
    gSysTrapH = DmGetResource('tSTR', SysTrapString);
    if (gSysTrapH == NULL) {
        error("Can't find systraps data");
//      DmCloseDatabase(gAssemblerDB);
        return;
    }
    gSysTrapSource = (char *)MemHandleLock(gSysTrapH);
    gSysTrapLength = MemHandleSize(gSysTrapH);

    gCompletion = true;
}

/*
static void globalFind(FindParamsPtr params){
    // #657825: Support for Global Find
    // 1. Open a DOC
    // 2. Draw a string in the Find Box
    // 3. Search the DOC using FindStrInStr
    // 4. Upon match: call FindSaveMatch, and retrieve screen location....
    // 5. Close the DOC
    // Err err;
    DmSearchStateType state;
    LocalID dbID;
    DmOpenRef dbRef = NULL;
    char* dbName = NULL;
    UInt16 recordNum = NULL;
    // int strLength;
    UInt16 cardNo = 0;
    // UInt16 fileCount = 0;

    // find DOCs
    if(DmGetNextDatabaseByTypeCreator(true,&state,'TEXt','REAd',false,&cardNo,&dbID)==errNone) {
        while(DmGetNextDatabaseByTypeCreator(false,&state,'TEXt','REAd',false,&cardNo,&dbID)==errNone) {
            DmDatabaseInfo(cardNo, dbID, dbName, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            dbRef = DmOpenDatabase(cardNo, dbID, params->dbAccesMode);  // 1.
            // Return upon fault
            if (!dbRef){
                params->more = false;
                return;
            }
            if(FindDrawHeader(params, dbName)) // 2.
                goto exit;
            recordNum = params->recordNum;
            while(true){
                if ((recordNum & 0x000f) == 0 && EvtSysEventAvail(true)){
                    // stop the global find process
                    params->more = true;
                    return;
                }
            }


        }
    }
    // return upon a No find
    else{
        params->more = false;
        return;
    }
    exit:
    DmCloseDatabase(dbRef);


}
*/

/***********************************************************************
 *
 * FUNCTION:    LedPilotMain
 *
 * DESCRIPTION: this is the main entry point for the application.
 * PARAMETERS:  cmd - word value specifying the launch code.
 *              cmdPB - pointer to a structure that is associated with the launch code.
 *              launchFlags -  word value providing extra information about the launch.
 *
 * RETURNED:    Result of launch
 *
 * REVISION HISTORY:
 *
 *
 ***********************************************************************/
static DWord LedPilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
    Err err;
    DWord romVersion;

    err = RomVersionCompatible (version30, launchFlags, romVersion);
    if (err) {
        return (err);
    }

    switch (cmd) {
        case sysAppLaunchCmdNormalLaunch:
            gRomVersion = romVersion;
            err = AppStart(); // highlight mode based on file extension is set here!!
            if (err) {
                error("AppStart failed");
                return err;
            }
            if (gCurFile == -1) {
                FrmGotoForm(OpenForm);
            } else {
                if (!loadDocFile(gCurrentFile)) {
                    gCurFile = -1;
                    FrmGotoForm(OpenForm);
                }
                else {
                    fillLineBuffer(0);
                    screenYOrigin = 0;
                    screenTopLine = 0;
                    getSelectionForDB();
                    FrmGotoForm(MainForm);
                }
            }
            // AppEventLoop();
            // AppStop();
            break;

        case sysAppLaunchCmdGoTo:{
                char targetFile[dmDBNameLength];
                GoToParamsType *pBlock = (GoToParamsType *)cmdPBP;
                gRomVersion = romVersion;//new code 03/25/02
                AppStart();  // on a sysAppLaunchCmdGoTo AppStart will set the highlight mode to Pref (last file mode)
                LocalID dbID = ((GoToParamsType *)cmdPBP)->dbID;
                DmDatabaseInfo(0, dbID, targetFile, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
                gCurFile = -1;
                for (int i = 0; i < gFileListCount; i++) {
                    if (StrCompare(targetFile, gFileList[i]) == 0) {
                        gCurFile = i;
                    }
                }
                if (gCurFile == -1) {
                    if (gFileListCount == MAX_FILES) {
                        gCurFile = (gCurFile - 1);
                        if (gCurFile < 0) {
                            gCurFile = gFileListCount - 1;
                        }
                    }
                    else {
                        gFileListCount++;
                        gCurFile = gCurFile + 1;
                    }
                    StrCopy(gFileList[gCurFile], targetFile);
                }
                StrCopy(gCurrentFile, targetFile);
                if (!loadDocFile(gCurrentFile)){
                    gSetHighlightMode = true;   // force set of highligh mode
                    setHighlightMode(gCurrentFile); // highlight mode based on file extension is set here!!
                    FrmGotoForm(OpenForm);
                    }
                else {
                    if (pBlock->searchStrLen >= 0) {
                        gSetHighlightMode = true;   // force set of highligh mode
                        setHighlightMode(gCurrentFile); // highlight mode based on file extension is set here!!
                        setSelectionFromCharacterOffsetRange(pBlock->matchPos, pBlock->searchStrLen);
                        setGUISelection(true);      // forceLoad the lines since the buffer is empty
                        //Line below added as a quick fix to the blank screen problem on a Goto launch from OBC--05/06/2002
                        //FrmCloseAllForms();
                        //AppLaunchWithCommand( (LocalID)'LedX', sysAppLaunchCmdNormalLaunch, NULL );
                        // This bug was caused by the non-launching of the main form. Lines above are now unneeded.
                        refillBuffer();
                        adjustXOrigin();
                        FrmGotoForm(MainForm);
                    }
                    else {
                        gSetHighlightMode = true; // force set of highligh mode
                        setHighlightMode(gCurrentFile); // highlight mode based on file extension is set here!!
                        getSelectionForDB();
                        refillBuffer();
                        adjustXOrigin();
                        FrmGotoForm(MainForm);
                    }
                }
        }

            // AppEventLoop();
            // AppStop();
            break;
/*
        case sysAppLaunchCmdSaveData: // #657825: Support for Global Find
            // Send a frmSaveEvent to all open forms.
            // FrmSaveAllForms();
            AppStop();
            return 0;
            // ToDo: add a frmSaveEvent to all forms with important data
            break;
        case sysAppLaunchCmdFind: // #657825: Support for Global Find
            globalFind((FindParamsType*) cmdPBP);
            return 0;
            break;
*/
        default:
            return 0;
            break;
    }
    AppEventLoop();
    AppStop();
    return 0;
}

/***********************************************************************
 *
 * FUNCTION:    PilotMain
 *
 * DESCRIPTION: this is the main entry point for the application.
 *
 * PARAMETERS:  cmd - word value specifying the launch code.
 *              cmdPB - pointer to a structure that is associated with the launch code.
 *              launchFlags -  word value providing extra information about the launch.
 * RETURNED:    Result of launch
 *
 * REVISION HISTORY:
 *
 *
 ***********************************************************************/
DWord PilotMain( Word cmd, Ptr cmdPBP, Word launchFlags)
{
    return LedPilotMain(cmd, cmdPBP, launchFlags);
}