/* **********************************************************************
 *
 *   LED/SrcEdit is free software as specified in the GNU General public License
 *   listed in the file COPYING or http://www.gnu.org/licenses/gpl.txt
 *
 ********************************************************************** */

#ifndef __OBC__
#include <PalmOS.h>
#include <PalmCompatibility.h>
#endif

#include "LedGlobals.h"

/******************************************************************************
 * Function Prototypes for Exported Functions
 ******************************************************************************/
Boolean AboutFormHandleEvent(EventPtr eventP) INCODE3; // Moved to get space for S055...
void AddCurrentFileToMRU()INCODE3;
Boolean AppHandleEvent(EventPtr eventP) INCODE3;
void AppStop(void)INCODE3; // Moved to get space for #846292 (S051) Use hard buttons to scroll
void DrawAsKeyword(char *cp, int count,int pos,int y) INCODE3;

Boolean IsKeyword(char *token, unsigned int len, char hash) INCODE3;
Boolean MainFormHandleEvent(EventPtr eventP) INCODE3;
Boolean NewFile()INCODE3;
Boolean OpenFormHandleEvent(EventPtr eventP) INCODE3; // Moved to get space for S041....
void SaveAs() INCODE3;

/******************************************************************************
 * Function Prototypes for static Functions
 ******************************************************************************/
Boolean doBlockShiftLeft() INCODE3;  // Moved to get space for: #847961 (S061) Add Tab/Spaces option
Boolean doBlockShiftRight()INCODE3;  // Moved to get space for:  #847961 (S061) Add Tab/Spaces option
Boolean doFindFunctionHeader() INCODE3;
Boolean doFunctionList() INCODE3;
Boolean doKeywordCompletion() INCODE3;
Boolean doLaunchOnBoardC()INCODE3;
Boolean doMRUPopup()INCODE3; //     05/16/2002
Boolean doSearchAgain()INCODE3;
Boolean doToolsPopup()INCODE3; //   05/16/2002
Boolean doUndo() INCODE3; // Moved to get space for #846293(S046)
static void drawColoredLine(char *line, int y, int*isComment) INCODE3;
void drawLine(Word line, Boolean copyToOnscreen) INCODE3;
static void drawLineAtY(char *line, int y, int *isComment) INCODE3;
void drawPage() INCODE3;
static void drawUncoloredLine(char *line, int y) INCODE3;
static int findCommentEnd(char  *line, int *count, int commentType) INCODE3;
static int findCommentStart(char *line, int *count) INCODE3;
void getSelectionForDB() INCODE3;
void loadKeywords() INCODE3;
static Keyword *loadWordsFromStr(DmResID resID, int *numOfWords) INCODE3;
void setSelectionForDB() INCODE3;
static void unLoadKeywords() INCODE3;
Boolean makeBlinkVisible(void) INCODE3;

/***********************************************************************
 *
 * FUNCTION:    AboutFormHandleEvent
 *
 * DESCRIPTION: this routine is the event handler for about box.
 *
 * PARAMETERS:  eventP  - event to handle.
 *
 *
 * RETURNED:    Boolean - whether or not the event is handled.
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
Boolean AboutFormHandleEvent(EventPtr eventP)
{
    Boolean handled = false;

    switch (eventP->eType) {
        case frmOpenEvent: {
                FormPtr frmP = FrmGetActiveForm();
                FrmDrawForm(frmP);
                handled=true;
            }
            break;
        case ctlSelectEvent:
            //FrmGotoForm( MainForm );
            FrmReturnToForm(0);
            handled=true;
            break;
        default:
            break;
    }
    return handled;
}

void AddCurrentFileToMRU()
{
    char tempFileList[MAX_FILES+1][dmDBNameLength];  // 05/09/2002
    if (gFileListCount == MAX_FILES) {
        gCurFile = (gCurFile - 1);
        if (gCurFile < 0) {
            gCurFile = gFileListCount - 1;
        }
    }
    else {
        gFileListCount++;
        gCurFile = gCurFile + 1;
    }
    //  StrCopy( gFileList[gCurFile], gCurrentFile );
    StrCopy( tempFileList[0], gCurrentFile );
    //check to see if the file is already in the MRU list --05/09/2002
    int counter = MAX_FILES;
    for (int i = 0; i < MAX_FILES; i++) {
        if ( StrCompare(gFileList[i],"") == 0 ) {
            StrCopy( tempFileList[i+1],"");
        } else {
            //compare to other file names in the list
            if ( StrCompare( gFileList[i], gCurrentFile) != 0 ) {
                StrCopy( tempFileList[i+1], gFileList[i] );
            } else {
                counter=i+1;
                break;
            }
        }
    //  FrmCustomAlert(YikesAlert,gFileList[i],"","");
    }
    for (int j = 0; j < counter; j++) {
        StrCopy( gFileList[j], tempFileList[j] );
    }
    //  StrCopy(gFileList[gCurFile], gCurrentFile);
}

/***********************************************************************
 *
 * FUNCTION:    AppHandleEvent
 *
 * DESCRIPTION: this routine loads form resources and set the event
 *              handler for the form loaded.
 *
 * PARAMETERS:  event  - a pointer to an EventType structure
 *
 * RETURNED:    true if the event has handle and should not be passed
 *              to a higher level handler.
 *
 * REVISION HISTORY:  ...
 *                    dec 14, 2003, added (S041) GotoLineFormHandleEvent
 *                    dec 24, 2003, added (S055) FileInfoFormHandleEvent
 *
 ***********************************************************************/
Boolean AppHandleEvent( EventPtr eventP)
{
    Word formId;
    FormPtr frmP;


    if (eventP->eType == frmLoadEvent) {
        // Load the form resource.
        formId = eventP->data.frmLoad.formID;
        frmP = FrmInitForm(formId);
        FrmSetActiveForm(frmP);
        resetFieldUnderline(frmP);

        // Set the event handler for the form.  The handler of the currently
        // active form is called by FrmHandleEvent each time is receives an
        // event.
        switch (formId) {
            case MainForm:
                FrmSetEventHandler(frmP, MainFormHandleEvent);
                break;

            case ConfigureForm:
                FrmSetEventHandler(frmP, ConfigureFormHandleEvent);
                break;

            case OpenForm:
                FrmSetEventHandler(frmP, OpenFormHandleEvent);
                break;

            case PreferencesForm:
                FrmSetEventHandler(frmP, PreferencesFormHandleEvent);
                break;

            case AboutForm:
                FrmSetEventHandler(frmP, AboutFormHandleEvent);
                break;

            case FileInfoAttributesForm:
                FrmSetEventHandler(frmP, FileInfoFormHandleEvent);
                break;

            case GotoLineForm:
                FrmSetEventHandler(frmP, GotoLineFormHandleEvent);
                break;

            case DeleteForm:
                FrmSetEventHandler(frmP, DeleteFormHandleEvent);
                break;

            case KeyboardSupportForm:
                FrmSetEventHandler(frmP, KeyboardSupportFormHandleEvent);
                break;

            default:
//              ErrFatalDisplay("Invalid Form Load Event");
                break;

        }
        return true;
    }

    return false;
}

/***********************************************************************
 *
 * FUNCTION:    AppStop
 *
 * DESCRIPTION: Save the current state of the application.
 *
 * PARAMETERS:  nothing
 *
 * RETURNED:    nothing
 *
 * REVISION HISTORY: ...
 *                   #624273 (S033) Restoring GrfState when quiting SrcEdit: John Wilund, Dec 16, 2003
 *
 *
 ***********************************************************************/
void AppStop(void)
{
    LedPreferenceType prefs;
    Word length;

    if (gKbSup_KeyboardTableH) {
        MemHandleUnlock(gKbSup_KeyboardTableH);
        MemHandleFree(gKbSup_KeyboardTableH);
        gKbSup_KeyboardTable = NULL;
    }

    if (gCurFile != -1) {
        saveDocFile(gCurrentFile, false);
        setSelectionForDB();
    }

    // Write the saved preferences / saved-state information.  This data
    // will be backed up during a HotSync.

    StrCopy(prefs.dbName, gCurrentFile);
    MemMove(prefs.fileList, gFileList, MAX_FILES * dmDBNameLength);
    prefs.fileListCount = gFileListCount;
    for (int i = 0; i < ToolbarEntries; i++) {
    //  StrCopy(prefs.toolbarSetting[i].key, gToolbar[i].key);
        prefs.toolbarSetting[i].handlerIndex = gToolbar[i].handlerIndex;
    //  prefs.toolbarSetting[i].font = gToolbar[i].font;
    }
    for (int i = 0; i < MAX_SAVED_DB; i++) {
        prefs.dbSaveData[i] = g_dbSaveData[i];
    }
    prefs.curFile = gCurFile;
    prefs.currentFont = gCurrentFont; //new code 04/24/2002
    prefs.colorMode = gColorMode; //new code 04/28/2002
    prefs.comments = ictComments;  //new code 04/29/2002
    prefs.commentsSaved = ictCommentsSaved;  //new code 04/29/2002
    prefs.keywords = ictKeywords;
    prefs.keywordsSaved = ictKeywordsSaved;
    // prefs.HTMLmode = gHTMLmode; //new code 04/29/2002
    prefs.HighlightMode = gHighlightMode; // 09/01/2003
    prefs.autoParen = gAutoParen;
    prefs.SupportedKeyboard = gKbSup_SupportedKeyboard; // #846728 (S016) External Keyboard Support
    prefs.hardKeysScrollValues = compressHardKeysScrollValues(); // #846292 (S051) Use hard buttons to scroll
    prefs.useTabForTab = gUseTabForTab;    // #847961 (S061) Add Tab/Spaces option
    prefs.tabWidth = gTabWidth;
    prefs.tabSpaces = gTabSpaces;         // #847961 (S061) Add Tab/Spaces option
    prefs.commentLines = gCommentLines;

    PrefSetAppPreferences (appFileCreator, appPrefID, appPrefVersionNum,
        &prefs, sizeof (prefs), true);

    CharPtr clipP = getClipboard(&length);
    if (clipP) {
        ClipboardAddItem(clipboardText, clipP, length);
        MemPtrFree(clipP);
    }

    unLoadKeywords();

    FrmCloseAllForms();

    if (gSearchTextH != NULL) {
        MemHandleFree(gSearchTextH);
    }

    if (gFontH != NULL) {
        MemHandleUnlock(gFontH);
        DmReleaseResource(gFontH);
    }

    if (bufferedLineContents) {
        for (int i = 0; i < LinesPerPage; i++) {
            MemPtrFree(bufferedLineContents[i].text);
        }
        MemPtrFree(bufferedLineContents);
     }

    WinDeleteWindow(gOffscreenPage, false);

    termText();

    // Restore KeyRates
    KeyRates(true, &gOldRepeatDelay, &gOldPeriod, &gDoubleTapDelay, &gQueueAhead);

    if (gCompletion) {
        MemHandleUnlock(gSysTrapH);
        DmReleaseResource(gSysTrapH);
//      DmCloseDatabase(gAssemblerDB);
    }

    if (gFilenameList != NULL) {
       for (int i = 0; i < gFilenameCount; i++) {
          MemPtrFree(gFilenameList[i]);
       }

       MemPtrFree(gFilenameList);
    }

    // Restore GrfState
    Boolean capsLock = gGrfComprStoredState>>2;
    Boolean numLock = gGrfComprStoredState>>1;
    Boolean autoShifted = gGrfComprStoredState;
    GrfSetState(capsLock, numLock, autoShifted);
}

Boolean doBlockShiftLeft()
{
    if (hasSelection() && !isEmptySelection()) {
        resetBufferToSelection();

        if (gCurrentSelection.endCharacter > 0) {
            gCurrentSelection.endLine++;
            gCurrentSelection.endCharacter = 0;
            gCurrentSelection.endOffset = 0;
        }

        for (Word i = gCurrentSelection.startLine; i < gCurrentSelection.endLine; i++) {
            char buf[MAX_CHARS_PER_LINE];
            unsigned int lineLength;
            loadLine(i, buf, &lineLength);
            if (gUseTabForTab){  // #847961 (S061) Add Tab/Spaces option
                if ((lineLength > 0) && (buf[0] == '\t')) {
                    markSelection(i, 1, i, 1);
                    backspace();
                }
            }
            else{
                 for (UInt8 x = 0; x<gTabSpaces; x++){
                     if ((lineLength > 0) && (buf[x] == spaceChr)) { // Only remove Spaces
                        markSelection(i, 1, i, 1);
                        backspace();
                    }
                }
            }
        }
        gCurrentSelection.startCharacter = 0;
        gCurrentSelection.startOffset  = 0;

        markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                                gCurrentSelection.endLine, gCurrentSelection.endCharacter);
        redrawPage();
    }
    return true;
}

Boolean doBlockShiftRight()
{
    if (hasSelection() && !isEmptySelection()) {
        resetBufferToSelection();

        if (gCurrentSelection.endCharacter > 0) {
            gCurrentSelection.endLine++;
            gCurrentSelection.endCharacter = 0;
            gCurrentSelection.endOffset = 0;
        }
        if (gUseTabForTab){  // #847961 (S061) Add Tab/Spaces option
            for (Word i = gCurrentSelection.startLine; i < gCurrentSelection.endLine; i++) {
                markSelection(i, 0, i, 0);
                insertCharacters("\t", 1, true);
            }
        }
        else{
             for (Word i = gCurrentSelection.startLine; i < gCurrentSelection.endLine; i++) {
                markSelection(i, 0, i, 0);
                for (UInt8 x = 0; x < gTabSpaces; x++){
                    insertCharacters(" ", 1, true);
                }
            }
        }

        gCurrentSelection.startCharacter = 0;
        gCurrentSelection.startOffset  = 0;

        markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                                gCurrentSelection.endLine, gCurrentSelection.endCharacter);
        redrawPage();
    }
    return true;
}

Boolean doFindFunctionHeader()
{
    char *headerInsert = NULL;
    char curLine[MAX_CHARS_PER_LINE];
    int startCh, endCh;
    if (extractSelectionWord(&startCh, &endCh, curLine)) {
        saveDocFile(gCurrentFile, false);
        setSelectionForDB();
        if (!loadDocFile("OnBoardHeader.h")) {
            error("Could not load header file. Have you installed OnBoardHeader.h?");
            redrawPage();
            return true;
        }
        char *searchText = (char *)MemPtrNew(endCh - startCh + 1 + 1);
        StrNCopy(searchText, &curLine[startCh], endCh - startCh);
        searchText[endCh - startCh] = '(';
        searchText[endCh - startCh + 1] = '\0';
        Word headerLength = 0;
        if (search(0, 0, searchText, false, true)) {
            Word line1 = 0;
            Word line2 = 0;
            Word offset1 = 0;
            Word offset2 = 0;
            getSelection(&line1, &offset1, &line2, &offset2);

            if (findMatchingParen(line2, offset2, '(', ')')) {
                getSelection(&line2, &offset2, &line2, &offset2);
                markSelection(line1, offset1 + (endCh - startCh), line2, offset2);
                copySelection();
                headerInsert = getClipboard(&headerLength);
            }
        }
        MemPtrFree(searchText);
        loadDocFile(gCurrentFile);  // cannot possibly fail
        getSelectionForDB();
        if (headerLength) {
            insertCharacters(headerInsert, headerLength, true);
            redrawPage();
            MemPtrFree(headerInsert);
        }
    }
    return true;
}

Boolean doFunctionList()
{
    // ToDo: #837757 Mistakes comment for function

    Word saveFromLine, saveToLine, saveFromOffset, saveToOffset;
    Boolean bHasSelection = hasSelection();

    getSelection(&saveFromLine, &saveFromOffset, &saveToLine, &saveToOffset);

    Word line1 = 0;
    Word line2 = 0;
    Word offset1 = 0;
    Word offset2 = 0;

    int matchSize = 32;
    char **matchList = (char **)MemPtrNew(matchSize * sizeof(char *));
    int matchCount = 0;
    Word *functionLine = (Word *)MemPtrNew(matchSize * sizeof(Word));
    Word *functionOffset = (Word *)MemPtrNew(matchSize * sizeof(Word));

    while (findChar(line1, offset1, '{' /*}*/ )) {
        Word bodyLine, bodyOffset;
        getSelection(&line1, &offset1, &bodyLine, &bodyOffset);
        // #837757 Mistakes comment for function
        /* if a block comment end indicator was found: continue search before the comment start indicator */

        /* if a line comment start indicator was found on the same line: ignore this finding and continue serach */
        if (findCharBackwards(line1, offset1, /*(*/ ')', 16)) {

            getSelection(&line1, &offset1, &line2, &offset2);
            if (findMatchingParenBackwards(line1, offset1, '(', ')')) {
                getSelection(&line1, &offset1, &line2, &offset2);
                if (findPreviousWord(line1, offset1)) {

                    Word wordFromLine, wordToLine, wordFromOffset, wordToOffset;
                    getSelection(&wordFromLine, &wordFromOffset, &wordToLine, &wordToOffset);

                    if (wordFromLine == wordToLine) {
                        char buf[MAX_CHARS_PER_LINE];
                        unsigned int lineLength;
                        loadLine(wordFromLine, buf, &lineLength);

                        if (matchCount == matchSize) {
                            matchSize += matchSize;
                            char **newList = (char **)MemPtrNew(matchSize * sizeof(char *));
                            MemMove(newList, matchList, matchCount * sizeof(char *));
                            MemPtrFree(matchList);
                            matchList = newList;

                            Word *newLineList = (Word *)MemPtrNew(matchSize * sizeof(Word));
                            MemMove(newLineList, functionLine, matchCount * sizeof(Word));
                            MemPtrFree(functionLine);
                            functionLine = newLineList;

                            Word *newOffsetList = (Word *)MemPtrNew(matchSize * sizeof(Word));
                            MemMove(newOffsetList, functionOffset, matchCount * sizeof(Word));
                            MemPtrFree(functionOffset);
                            functionOffset = newOffsetList;
                        }

                        matchList[matchCount] = (char *)MemPtrNew((wordToOffset - wordFromOffset) + 2);
                        Word x;
                        for (x = wordFromOffset; x <= wordToOffset; x++) {
                            matchList[matchCount][x - wordFromOffset] = buf[x];
                        }
                        matchList[matchCount][x - wordFromOffset] = '\0';

                        functionLine[matchCount] = wordFromLine;
                        functionOffset[matchCount] = wordFromOffset;
                        matchCount++;
                    }
                }
            }
        }

        if (findMatchingParen(bodyLine, bodyOffset, '{', '}')) {
            getSelection(&line2, &offset2, &line1, &offset1);
        }
        else {
            break;
        }
    }

    if (matchCount > 0) {
        FormPtr frmP = FrmGetActiveForm();
        ListPtr lstP = (ListPtr)getObjectPtr(frmP, MainAPIListList);

        LstSetListChoices(lstP, matchList, matchCount);
        //new code 05/29/2002
        RectangleType rect;
        FrmGetObjectBounds(frmP,FrmGetObjectIndex(frmP, MainAPIListList),&rect);
    //  if (matchCount < lstP->bounds.extent.y / FntLineHeight())
        if (matchCount < rect.extent.y / FntLineHeight()) { //new code 05/29/2002
            LstSetHeight(lstP, matchCount);
        }

        int index = LstPopupList(lstP);
        if (index != -1) {
            saveFromLine = saveToLine = functionLine[index];
            saveFromOffset = saveToOffset = functionOffset[index];
        }

        LstSetHeight(lstP,rect.extent.y / FntLineHeight());

        for (int i = 0; i < matchCount; i++) {
            MemPtrFree(matchList[i]);
        }
    }
    MemPtrFree(matchList);
    MemPtrFree(functionOffset);
    MemPtrFree(functionLine);


    if(bHasSelection)
        markSelection(saveFromLine, saveFromOffset, saveToLine, saveToOffset);
    else
    {
        markSelection(saveFromLine, 0, saveToLine, 0);
        unmarkSelection();
    }

    setGUISelection(false);
    resetBufferToSelection();
    redrawPage();
    return true;
}

Boolean doKeywordCompletion()
{
    char curLine[MAX_CHARS_PER_LINE];
    int startCh, endCh;
    if (extractSelectionWord(&startCh, &endCh, curLine)) {
        char *p = gSysTrapSource;
        char **matchList = (char **)MemPtrNew(32 * sizeof(char *));
        int matchCount = 0;
        int matchSize = 32;
        while (p < (gSysTrapSource + gSysTrapLength)) {
            char *startP = p;
            int i;
            for (i = startCh; i < endCh; i++) {
                if (*p != curLine[i]) {
                    break;
                }
                else {
                    ++p;
                }
            }
            if (i == endCh) {
                if (matchCount == matchSize) {
                    matchSize += matchSize;
                    char **newList = (char **)MemPtrNew(matchSize * sizeof(char *));
                    MemMove(newList, matchList, matchCount * sizeof(char *));
                    MemPtrFree(matchList);
                    matchList = newList;
                }
                while ((*p != 0x0A) && (*p != 0x0D) && (p < (gSysTrapSource + gSysTrapLength))) {
                    ++p;
                }
                matchList[matchCount] = (char *)MemPtrNew(p - startP + 1);
                MemMove(matchList[matchCount], startP, p - startP);
                matchList[matchCount][p - startP] = 0;
                matchCount++;
            }
            else {
                while ((*p != 0x0A) && (*p != 0x0D) && (p < (gSysTrapSource + gSysTrapLength))) {
                    ++p;
                }
            }
            while (((*p == 0x0A)||(*p == 0x0D)) && (p < (gSysTrapSource + gSysTrapLength))) ++p;
        }
        if (matchCount > 0) {
            FormPtr frmP = FrmGetActiveForm();
            ListPtr lstP = (ListPtr)getObjectPtr(frmP, MainAPIListList);
            LstSetListChoices(lstP, matchList, matchCount);
            int index = LstPopupList(lstP);
            if (index != -1) {
                if (isEmptySelection()) {
                    markSelection(gCurrentSelection.startLine, startCh,
                                                    gCurrentSelection.endLine, endCh);
                }
                insertCharacters(matchList[index], StrLen(matchList[index]), true);
                redrawPage();
            }
            for (int i = 0; i < matchCount; i++) {
                MemPtrFree(matchList[i]);
            }
        }
        MemPtrFree(matchList);
    }
    return true;
}

Boolean doLaunchOnBoardC()
{
    UInt cardNo;
    LocalID dbID;
    DmSearchStateType searchState;
    Err err;

    DmGetNextDatabaseByTypeCreator(true, &searchState, 'appl', 'OnBC', true, &cardNo, &dbID);
    ErrNonFatalDisplayIf(!dbID, "Could not find OnBoardC");
    if (dbID) {
        err = SysUIAppSwitch(cardNo, dbID, sysAppLaunchCmdNormalLaunch, NULL);
        ErrNonFatalDisplayIf(err, "Could not launch OnBoardC");
    }
    return true;
}

Boolean doMRUPopup() {
    //build array to populate the popup MRU file list --5/09/2002
    FormPtr frmP = FrmGetActiveForm();
    char tempFileList[MAX_FILES+1][dmDBNameLength];
    char popMRUItemOther[dmDBNameLength];
    char popMRUItem0[dmDBNameLength];
    char popMRUItem1[dmDBNameLength];
    char popMRUItem2[dmDBNameLength];
    char popMRUItem3[dmDBNameLength];
    char popMRUItem4[dmDBNameLength];
    char popMRUItem5[dmDBNameLength];
    char popMRUItem6[dmDBNameLength];
    char popMRUItem7[dmDBNameLength];
    StrCopy( popMRUItemOther, "--Other Docs--" );
    StrCopy( popMRUItem0, gFileList[0] );
    StrCopy( popMRUItem1, gFileList[1] );
    StrCopy( popMRUItem2, gFileList[2] );
    StrCopy( popMRUItem3, gFileList[3] );
    StrCopy( popMRUItem4, gFileList[4] );
    StrCopy( popMRUItem5, gFileList[5] );
    StrCopy( popMRUItem6, gFileList[6] );
    StrCopy( popMRUItem7, gFileList[7] );
    char *popMRUList[MAX_FILES+1] = {popMRUItemOther, popMRUItem0, popMRUItem1, popMRUItem2, popMRUItem3, popMRUItem4, popMRUItem5, popMRUItem6, popMRUItem7 };
    ListPtr lstP = (ListPtr)getObjectPtr(frmP, MainPopMRUList );

    LstSetListChoices(lstP,(char **)popMRUList,(MAX_FILES+1));
    Int16 index = LstPopupList(lstP);
    if (index != -1) {
        if (index == 0) {  // they selected "Other Docs" from the list
            FrmGotoForm(OpenForm);
        } else {
            if (gCurFile != -1) {
                saveDocFile(gCurrentFile, false);
                setSelectionForDB();
            }
            if (gFileListCount == MAX_FILES) {
                gCurFile = (gCurFile - 1);
                if (gCurFile < 0) gCurFile = gFileListCount - 1;
            }
            else {
                gFileListCount++;
                gCurFile = gCurFile + 1;
            }
            if ( StrCompare(gFileList[index-1],"") == 0 ) {
                return true;
            }
            StrCopy(gCurrentFile, gFileList[index-1]);
            StrCopy( tempFileList[0], gCurrentFile );
            //check to see if the file is already in the MRU list --05/09/2002
            int counter = MAX_FILES;
            for (int i = 0; i < MAX_FILES; i++) {
                if ( StrCompare(gFileList[i],"") == 0 ) {
                    StrCopy( tempFileList[i],"");
                } else {
                    //compare to other file names in the list
                    if ( StrCompare( gFileList[i], gCurrentFile) != 0 ) {
                        StrCopy( tempFileList[i+1], gFileList[i] );
                    } else {
                        counter=i+1;
                        break;
                    }
                }
            }
            for (int j = 0; j < counter; j++) {
                StrCopy( gFileList[j], tempFileList[j] );
            }

            if(loadDocFile(gCurrentFile)) {
                // #846293 (S046) pick highlight mode based on file extension
                gSetHighlightMode = true;
                setHighlightMode(gCurrentFile);

                fillLineBuffer(0);
                screenYOrigin = 0;
                screenTopLine = 0;
                getSelectionForDB();
                FrmGotoForm(MainForm);  // reloads the file
            } else {
                gCurFile=-1;
                FrmGotoForm(OpenForm);
            }
        }
    }
    return true;
}

Boolean doSearchAgain()
{
    if (gSearchTextH != NULL) {
        char *searchText = (char *)MemHandleLock(gSearchTextH);
        if (search(gCurrentSelection.endLine, gCurrentSelection.endCharacter, searchText, gSearchIgnoreCase, true)) {
            setGUISelection(false);
            resetBufferToSelection();
            redrawPage();
        }
        MemHandleUnlock(gSearchTextH);
    }
    return true;
}

Boolean doToolsPopup() {
    FormPtr frmP = FrmGetActiveForm();

    char popToolsItem0[19];
    char popToolsItem1[19];
    char popToolsItem2[19];
    ListPtr lstP;
    UInt16 index;

    if (isEmptySelection()){
        // build array to populate the popup tool list--04/22/2002;
        StrCopy(popToolsItem0,"Keyword Completion");
        StrCopy(popToolsItem1,"Header Parameters");
        StrCopy(popToolsItem2,"Function Bookmarks");
        char *popToolsList[3] = {popToolsItem0,popToolsItem1,popToolsItem2};
        lstP = (ListPtr)getObjectPtr(frmP, MainPopToolsList );
        LstSetListChoices(lstP,(char **)popToolsList,3);
        index = LstPopupList(lstP);
        switch (index)  {
            case 0: //Keyword Completion
                doKeywordCompletion();
                break;
            case 1: //Header parameters
                doFindFunctionHeader();
                break;
            case 2: //Function bookmarks
                doFunctionList();
                break;
        }
    }
    else if (!isEmptySelection()){
        // #846288 (S058) Popup Tools Menu
        char popToolsItem3[19];
        char popToolsItem4[19];
        char popToolsItem5[19];
        char popToolsItem6[19];
        char popToolsItem7[19];
        char popToolsItem8[19];
        char popToolsItem9[19];
        char popToolsItem10[19];
        char popToolsItem11[19];

        StrCopy(popToolsItem0,"Cut");
        StrCopy(popToolsItem1,"Copy");
        StrCopy(popToolsItem2,"Paste");
        StrCopy(popToolsItem3,"Find/Replace");
        StrCopy(popToolsItem4,"Comment");
        StrCopy(popToolsItem5,"Uncomment");
        StrCopy(popToolsItem6,"Indent");
        StrCopy(popToolsItem7,"Outdent");
        StrCopy(popToolsItem8,"To Lower Case");
        StrCopy(popToolsItem9,"To Upper Case");
        StrCopy(popToolsItem10,"Shift Case");
        StrCopy(popToolsItem11,"In Reverse");
        char *popToolsSelectionList[12] = {popToolsItem0,popToolsItem1,popToolsItem2,popToolsItem3,popToolsItem4,popToolsItem5,
            popToolsItem6,popToolsItem7,popToolsItem8,popToolsItem9,popToolsItem10,popToolsItem11};
        lstP = (ListPtr)getObjectPtr(frmP, MainPopToolsList );
        LstSetListChoices(lstP,(char **)popToolsSelectionList,12);
        index = LstPopupList(lstP);
        switch (index)  {
            case 0: // Cut
                doCut();
                break;
            case 1: // Copy
                doCopy();
                break;
            case 2: // Paste
                doPaste();
                break;
            case 3: // Find/Replace
                doFindReplace();
                break;
            case 4: // Comment
                doCommentSelection();
                break;
            case 5: // Uncomment
                doUncommentSelection();
                break;
            case 6: // Indent
                doBlockShiftRight();
                break;
            case 7: // Outdent
                doBlockShiftLeft();
                break;
            case 8: // Lower Case
                doCaseShifts(doToLower);
                break;
            case 9: // Upper Case
                doCaseShifts(doToUpper);
                break;
            case 10: // Shift Case
                doCaseShifts(doShiftCase);
                break;
            case 11: // Revert
                doCaseShifts(doRevers);
                break;
        }
    }
    return true;
}

Boolean doUndo()
{
    if (hasSelection() && isEmptySelection() && isBlinkOnScreen()) {
        clearBlinkingCursor();
    }
    resetBufferToSelection();
    undo();
    redrawPage();
    return true;
}

/*
    Draws a part of the line that is not commented and sets the color the the keywords.
    if keyword coloring is disabled, it just calls WinDrawChars.
*/
void DrawAsKeyword(char *cp, int count,int pos,int y)
{
    register int nPos =0;
    register int tokenLength;
    register int xPos = pos;
    Boolean tokenComplete;
    char tokenHash=0;

    SetTextColor(ictText);

    if(ictKeywords==255) {
        WinDrawChars(cp,count,pos,y);
    } else {
        while(nPos<count) {
            tokenComplete = 0;
            tokenLength = 0;
            tokenHash=0;

            while(!tokenComplete) {
                switch(cp[nPos+tokenLength]) {
                case ',':case ';':case ':':case ' ':case '-':
                case '*':case '+':case '^':case '%'://case '"':
                case '(':case ')':case '[':case ']':case '{':
                case '}':case '&':case '|':case '!':case '?':
                case 0x27:case tabChr:case 0xA:case 0:case '.':
                  tokenComplete = 1;  // A separator ends the token
                  break;
                case '"':  // #846120 (S057) Disable keyword highlighting in strings
                  tokenComplete =1;
/*
                  if (cp[nPos+tokenLength -1] != chrReverseSolidus)
                    gIsString = gIsString?false:true;
*/
                  break;
                case '>':
                  // A special separator ;)
                  if(gHighlightMode==HTMLMODE){
                    tokenHash^=cp[nPos+tokenLength];
                    tokenLength++;
                    tokenComplete = 2;
                  } else {
                    tokenComplete = 1;
                  }
                  break;
                case '<':case '/':case '=':
                  // These are separators in C but not in HTML
                  if(gHighlightMode==HTMLMODE){
                    // Treat them as default characters for HTML !
                    tokenHash^=cp[nPos+tokenLength];
                    tokenLength++;
                  } else {
                    tokenComplete = 1;
                  }
                  break;
                default:
                  tokenHash^=cp[nPos+tokenLength];
                  tokenLength++;
                  break;
                }
            }

            if(IsKeyword(cp+nPos,tokenLength,tokenHash)) {
                SetTextColor(ictKeywords);
            }
/*
            if(gIsString){
                SetTextColor(ictString);
            }
*/
            WinDrawChars(cp+nPos,tokenLength,xPos,y);
            xPos += FntCharsWidth(cp+nPos,tokenLength);

            SetTextColor(ictText);
            if(cp[nPos+tokenLength]<0x20)
                break;

            if(tokenComplete==1) {
/*
                if(gIsString || (!gIsString && (cp[nPos+tokenLength]=='"')))
                    SetTextColor(ictString);
*/
                WinDrawChars(cp+nPos+tokenLength,1,xPos,y);
                xPos += FntCharWidth(cp[nPos+tokenLength]);

                nPos+=tokenLength+1;
                tokenLength=0;
            } else {        // The < character must be kept for HTML mode
                nPos+=tokenLength;
                tokenLength=0;
            }
        }
    }
}

/*
void WinDrawSmallChars(Char* str, Coord x, Coord y){
	BitmapPtr bmp;
	RectangleType r;
	WinHandle lineWin;
	Err err;
	BitmapPtrV3 bmp2;
    UInt16 strLen = StrLen(str);

	// Note: Assuming (DocumentWidth*2) x 11; should make this screen width x FntLineHeight() of
	// largest font we are going to draw this way. Also, these should be globals
	// that are allocated/deallocated once, rather than every time we draw. And,
	// there should be some check to make sure the High Density Display Feature
	// Set is present on the device before allowing this to happen...

	bmp = BmpCreate(DocumentWidth*2, 11, 8, NULL, &err);  // 8 bits makes color
	bmp2 = BmpCreateBitmapV3(bmp, kDensityDouble, BmpGetBits(bmp), NULL);
	lineWin = WinCreateBitmapWindow(bmp, &err);

	WinSetDrawWindow(lineWin);

	r.topLeft.x = 0;
	r.topLeft.y = 0;
	r.extent.x = DocumentWidth *2;
	r.extent.y = 11;
	WinEraseRectangle(&r, 0);

	WinPaintChars(str, strLen, 0, 0);

	WinSetDrawWindow(WinGetDisplayWindow());
	WinDrawBitmap((BitmapPtr)bmp2, x, 8+y);

    // Deleting everything :)
	WinDeleteWindow(lineWin, false);
	BmpDelete((BitmapPtr)bmp2);
	BmpDelete(bmp);
}
*/

// comment stores the type of comment we're currently in, language dependant:
// 0 always means 'no comment open'
// for C, 1 means 'a // comment has started'
// for C, 2 means 'a /* comment has started'
// for asm, 1 means 'a ; comment has started'
// etc.
static void drawColoredLine(char *line, int y, int *isComment)
{
  // we're in color mode. This is where the fun begins...
  int x=0; // x position from left of screen, in pixels
  int textPos=0; // position within the array of characters

  while(line[textPos]!='\0'){ // go through the whole line, and draw either comment or normal
    int count=0;

    if(line[textPos]==tabChr){ // special case for tab characters,
      x=(1+x/gTabWidth)*gTabWidth; // move on x the right amount
      textPos++; // and skip to the next char
    }

    if(*isComment){
      // we're inside a comment, so find the end of the comment or end of line, then print
      // highlighted up till that point, and go round again.

      *isComment = findCommentEnd(line+textPos, &count, *isComment);
      SetTextColor(ictComments);
      WinDrawChars(line+textPos,count,x,y);
      // gIsString = false;
    }

    else{
      // we're not inside a comment, so find the beginning of one or end of line, then print
      // normally up till that point, and go round again.
      // if (gIsString == false)
        *isComment = findCommentStart(line+textPos,&count);
      DrawAsKeyword(line+textPos,count,x,y); // draw normally up to comment start
    }

    // always do the same thing after printing a chunk...
    x+=FntCharsWidth(line+textPos,count); // move x on the right number of pixels
    textPos+=count; // move textPos on the right number of characters
  }
}

/***********************************************************************
 *
 * FUNCTION:    drawLine
 *
 * DESCRIPTION: this routine draws into offscreen buffer first, then
 *              copies the appropriate portion to screen if parameter
 *              is set.
 *
 * PARAMETERS:  line            - line to draw.
 *
 *              copyToOnscreen  - Whether or not to also display on the
 *                                screen
 *
 *
 * RETURNED:    none
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
void drawLine(Word line, Boolean copyToOnscreen)
{
// draw into offscreen first, then just copy the appropriate portion
    WinHandle onscreen = WinSetDrawWindow(gOffscreenPage);
    int comment = 0;

    TEXT_ASSERT((line >= screenTopLine), "line off buffer");
    TEXT_ASSERT((line < (screenTopLine + LinesPerPage)), "line off buffer");

    int y = ((line - screenTopLine) * FontHeight);// - FontDescender;
    char *cp = bufferedLineContents[line - screenTopLine].text;

    RectangleType r = { {0, y}, {DocumentWidth, FontHeight} };
    WinEraseRectangle(&r, 0);

    int com=0;
    int i;
    int lin = line-gCommentLines;
    if (lin<0) lin=0;
    unsigned int length;

    char pLine[MAX_CHARS_PER_LINE];

    /*
    if(gColorMode){
      for(i=line-1;i>=lin;i--) {
    loadLine(i,pLine,&length);
    register unsigned int j = 0;
    while(j<length){
      int count=0;
      if(pLine[j]==tabChr)
        j++;

      if(comment==0)
        comment=findCommentStart(pLine+j,&count);
      else
        comment=findCommentEnd(pLine+j,&count,comment);

      j+=count;
    }
    if(comment) // if we reach the end of a line and a comment is unclosed
      break; // bail out.
      }
    }
    */

    if((gColorMode)&&(gHighlightMode==CMODE)){
    // if(((gColorMode)&&(gHighlightMode==CMODE))&&(gIsString == false)){
      for(i=line-1;i>=lin;i--) {
        loadLine(i,pLine,&length);
        register int j = length;
        while((--j)>0) {
          if(com >=0 && pLine[j]=='/' && (pLine[j-1]=='*')) // Block comment end
            com--;

          // the Two Comment BUG
          // if(pLine[j]=='*' && (pLine[j-1]=='/')) {
          if((pLine[j-2] !='/') && (pLine[j]=='*' && (pLine[j-1]=='/'))) {
            if(com>=0) {
              comment = 1;
              break;
            }
            com++;
          }
          // the Two Comment BUG
          if((pLine[j-2] =='/') && (pLine[j]=='*' && (pLine[j-1]=='/')))
            comment = 0;
        }
      }
    } else {
      comment = 0;
    }

    drawLineAtY(cp,y,&comment);

    WinSetDrawWindow(onscreen);

    if (copyToOnscreen) {
        r.topLeft.x = screenXOrigin;
        r.extent.x = PageWidth;
        WinCopyRectangle(gOffscreenPage, 0, &r, PageXOrigin, PageYOrigin + (line - screenTopLine) * FontHeight, scrCopy);

        checkScreenXState(); // #895637 grey out Left/Right arrows
    }
    SetTextColor(ictText);
}

/*
    Draws a line at y

    isComment is true if a C comment is open. It must also be changed by this function
    when closed.
*/
static void drawLineAtY(char *line, int y, int *isComment)
{
  // char buff[50];
  // StrPrintF(buff,"isComment==%d",*isComment);
  //  error(buff);
  if(!gColorMode){
    drawUncoloredLine(line,y);
  } else {
    drawColoredLine(line,y,isComment);
  }
  SetTextColor(ictText);
}

/***********************************************************************
 *
 * FUNCTION:    drawPage
 *
 * DESCRIPTION: this routine re-builds the offscreen contents and copies
 *              onscreen.  Assumes that the buffered contents has been
 *              loaded.
 *
 * PARAMETERS:  none
 *
 *
 * RETURNED:    none
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/

void drawPage()
{
    WinHandle onscreen = WinSetDrawWindow(gOffscreenPage);
    RectangleType r = { {0, 0}, {DocumentWidth, LinesPerPage * FontHeight} };
    int com=0;
    int comment = 0;
    int i;


    if (gRomVersion >= version35) {
        WinSetBackColor(0);
    }

    WinEraseRectangle(&r, 0);

    gBlinkDrawn = 0;            // We erased the blinking cursor

    //    int com=0;
    char pLine[MAX_CHARS_PER_LINE];
    int line = screenTopLine-gCommentLines;
    if (line<0) line=0;
    unsigned int length;

    if((gColorMode)&&(gHighlightMode==CMODE)){
    // if(((gColorMode)&&(gHighlightMode==CMODE)) && (gIsString == false)){
        for(i=screenTopLine-1;i>=line;i--) {
            loadLine(i,pLine,&length);
            register int j = length;
            while((--j)>0) {
                if(com >=0 && pLine[j]=='/' && (pLine[j-1]=='*'))
                    com--;
                // The Two comment BUG
                // if(pLine[j]=='*' && (pLine[j-1]=='/')) {
                if((pLine[j-2] != '/') && (pLine[j]=='*' && (pLine[j-1]=='/'))) {
                    if(com>=0) {
                        comment = 1;
                        break;
                    }
                    com++;
                }
                // The Two Comment BUG
                if((pLine[j-2] == '/') && (pLine[j]=='*' && (pLine[j-1]=='/')))
                    comment = 0;
            }
        }
    }

    /*
    //    if(gColorMode){ // skip this if we're not highlighting anyway...
      for(i=screenTopLine-1;i>=line;i--) {
    loadLine(i,pLine,&length);
    register unsigned int j = 0;
    while(j<length){
      int count=0;
      if(pLine[j]==tabChr)
        j++;

      if(comment==0)
        comment=findCommentStart(pLine+j,&count);
      else
        comment=findCommentEnd(pLine+j,&count,comment);

      j+=count;
    }
    if(comment) // if we reach the end of a line and a comment is unclosed
      break; // bail out.
      }
    } else {
      comment=0;
    }
    */

    for (i = 0; i < LinesPerPage; i++) {
        if ((screenTopLine + i) >= gMaxLines) {
            break;
        }
        int y = (i * FontHeight);// - FontDescender;
        char *cp = bufferedLineContents[i].text;
        TEXT_ASSERT((cp != NULL), "null text pointer");

        drawLineAtY(cp,y,&comment);
    }
    WinSetDrawWindow(onscreen);
    refreshPageContents();
    // #895637 grey out Left/Right arrows
    checkScreenXState();

    if (hasSelection() && !isEmptySelection()) {
        invertSelectionOnPage(&gCurrentSelection, false);
    }
    SetTextColor(ictText);  // for compatibilty with OS 3.1 : (the text color is the foreground
                            // color and overrides everything including the UI)

}

static void drawUncoloredLine(char *line, int y){
// We're not in color mode, just draw and be done with it
  int pos=0;
  int count=0;
  int x=0;
  while(line[pos+count]!='\0'){// iterate through the whole line until we find a null
    if(line[pos+count]==tabChr){ // special handling for tab characters
      WinDrawChars(line+pos,count,x,y); // draw chars up to here
      x+=FntCharsWidth(line+pos,count);
      x=(1+x/gTabWidth)*gTabWidth; // move on x the right amount
      pos+=count+1; // move to just after the tab
      count=0;
    } else
      count++;
  }
  WinDrawChars(line+pos, count, x, y);
}

// findCommentEnd searches for a comment end matching the currently open one
// and returns the relevant value for what comment mode we're in now
// eg, 0 if it's found an end of comment
// or 1 if it's not found an end of comment
//
// Also sets count to the number of chars it processed
static int findCommentEnd(char  *line, int *count, int commentType)
{
  int pos=0;
  CommentInfo *cInfo=NULL;
  int numComments=0;
  *count = 0;

  switch(gHighlightMode){
  case HTMLMODE:
    cInfo = gHTMLComments;
    numComments = gNumHTMLComments;
    break;
  case ASMMODE:
    cInfo = gASMComments;
    numComments = gNumASMComments;
    break;
  case CMODE:
  default:
    cInfo = gCComments;
    numComments = gNumCComments;
    break;

  }
  while((line[pos]!='\0')&&(line[pos]!=tabChr)){
    // if first char matches
    if(line[pos]==cInfo[commentType-1].end[0]){
      unsigned int pos2=0;
      // check there's enough chars left on the line, and that they match
      while((line[pos+pos2]!='\0')&&(pos2<cInfo[commentType-1].endLen)&&(line[pos+pos2]==cInfo[commentType-1].end[pos2])){
        pos2++;
      }
      if(pos2==cInfo[commentType-1].endLen){ // if all chars matched...
        // set count to current pos, plus length of comment delimiter
        *count+=(pos+pos2);
        return 0; // return that we've finished the comment
      }

    } // end 'if first char matches'
    pos++;
  }
  // position is end of line
  *count+=pos;

  // special case for single line comments (ie, comments terminated by end of line)
  if((line[pos]=='\0')&&(cInfo[commentType-1].end[0]=='\0'))
    return 0;

  // didn't find anything, so comment continues
  return commentType;
}

// findCommentStart searches for a comment start, and returns the type of
// comment that's been started
// eg, 0 is it's not found a comment start before end of line
// or 1 if a // comment has started.
//
// Also sets count to the number of chars it processed
static int findCommentStart(char *line, int *count)
{
  int pos=0;
  CommentInfo *cInfo=NULL;
  int numComments=0;
  *count=0;

  switch(gHighlightMode){
  case HTMLMODE:
    cInfo = gHTMLComments;
    numComments = gNumHTMLComments;
    break;
  case ASMMODE:
    cInfo = gASMComments;
    numComments = gNumASMComments;
    break;
  case CMODE:
  default:
    cInfo = gCComments;
    numComments = gNumCComments;
    break;

  }
  while((line[pos]!='\0')&&(line[pos]!=tabChr)){
    int i;
    // for(i=0;i<numComments;i++){
    // the Two comment start BUG
    for(i=numComments-1; i>-1; i--){

      // if the first char matches
      if(line[pos]==cInfo[i].start[0]){
    unsigned int pos2=0;
    // check there's enough chars left on the line, and that they match
    while((line[pos+pos2]!='\0')&&(pos2<cInfo[i].startLen)&&(line[pos+pos2]==cInfo[i].start[pos2])){
      pos2++;
    }
    if(pos2==cInfo[i].startLen){ // if all chars matched...
      *count+=pos; // set count to start of comment
      //      error("found comment start");
/*
      if (gIsString == true)    // No Comment starts in Strings!!!
        continue;
*/
      return i+1; // return the comment type encountered
    }
      } // end 'if first char matches'
    } // end for
    pos++;
  } // end while

  *count+=pos;
  return 0;
}

void getSelectionForDB()
{
    for (int i = 0; i < MAX_SAVED_DB; i++) {
        if (StrCompare(gCurrentFile, g_dbSaveData[i].dbName) == 0) {
            gCurrentSelection = g_dbSaveData[i].selection;
                    /* the current selection might not be valid if another editor
                        has been used on this file */
            if ((gCurrentSelection.startLine < gMaxLines)
                            && (gCurrentSelection.endLine < gMaxLines)) {
                markSelection(gCurrentSelection.startLine,
                                gCurrentSelection.startCharacter,
                                    gCurrentSelection.endLine,
                                        gCurrentSelection.endCharacter);
            }
            else {
                unmarkSelection();
            }
            return;
        }
    }
    unmarkSelection();
}

/*
    StrCompare is too slow so let's make our own function.
*/
Boolean IsKeyword(char *token, unsigned int len, char hash)
{
  int i;
  int numKeywords;
  Keyword *keywords;

  switch(gHighlightMode){
  case HTMLMODE:
    numKeywords = gNumHTMLKeywords;
    keywords = gHTMLKeywords;
    break;
  case ASMMODE:
    numKeywords = gNumASMKeywords;
    keywords = gASMKeywords;
    break;
  case CMODE:
  default:
    numKeywords = gNumCKeywords;
    keywords = gCKeywords;
  }
/*
   // #846120 (S057) Disable keyword highlighting in strings
  if (gIsString)
    return false;
*/
  for(i=0;i<numKeywords;i++){
    // first compare hash, then length (&& operator will short circuit if first test fails)
    if((hash == keywords[i].hash)&&(len == keywords[i].len)){
      // if they match, do a full string compare
      if(StrNCompare(keywords[i].name,token,len)==0)
    return true;
    }
  }

  return false; // nothing matched.
}

void loadKeywords()
{
    if (gSetHighlightMode == false)  // #846293 (S046) pick highlight mode based on file extension
        return;
    switch(gHighlightMode){
    case HTMLMODE:
      gHTMLKeywords = loadWordsFromStr(HTMLKeywordsString,&gNumHTMLKeywords);
      if(!gHTMLKeywords){
        error("Couldn't load keywords");
        return;
      }
      gNumHTMLComments=1;
      gHTMLComments = (CommentInfo *)MemPtrNew (sizeof(CommentInfo)*gNumHTMLComments);
      gHTMLComments[0].start="<!--";
      gHTMLComments[0].startLen=4;
      gHTMLComments[0].startHash='<'^'!'^'-'^'-';
      gHTMLComments[0].end="-->";
      gHTMLComments[0].endLen=3;
      gHTMLComments[0].endHash='-'^'-'^'>';
      break;
    case ASMMODE:
      gASMKeywords = loadWordsFromStr(ASMKeywordsString,&gNumASMKeywords);
      if(!gASMKeywords){
        error("Couldn't load keywords");
        return;
      }
      gNumASMComments=1;
      gASMComments = (CommentInfo *)MemPtrNew (sizeof(CommentInfo)*gNumASMComments);
      gASMComments[0].start=";";
      gASMComments[0].startLen=1;
      gASMComments[0].startHash=';';
      gASMComments[0].end="\0";
      gASMComments[0].endLen=1;
      gASMComments[0].endHash='\0';
      break;
    case CMODE:
    default:
      gHighlightMode = CMODE;
      gCKeywords = loadWordsFromStr(CKeywordsString,&gNumCKeywords);
      if(!gCKeywords){
        error("Couldn't load keywords");
        return;
      }
      gNumCComments=2;
      gCComments = (CommentInfo *)MemPtrNew (sizeof(CommentInfo)*gNumCComments);;
      gCComments[0].start="/*";
      gCComments[0].startLen=2;
      gCComments[0].startHash='/'^'*';
      gCComments[0].end="*/";
      gCComments[0].endLen=2;
      gCComments[0].endHash='*'^'/';
      gCComments[1].start="//";
      gCComments[1].startLen=2;
      gCComments[1].startHash='/'^'/';
      gCComments[1].end="\0";
      gCComments[1].endLen=1;
      gCComments[1].endHash='\0';
      break;
    }
    gSetHighlightMode = false;  // #846293 (S046) pick highlight mode based on file extension
}

static Keyword* loadWordsFromStr(DmResID resID, int *numOfWords)
{
  int i;
  register int j;
  Handle hKeywordsStr;
  char *pKeywordsStr;
  char tmp[256];
  Keyword *tmpWords;
  char tmpHash;

  hKeywordsStr = DmGetResource('tSTR', resID);
  if (hKeywordsStr == NULL) {
    error("Can't find keywords data");
    return NULL;
  }
  pKeywordsStr = (char*)MemHandleLock(hKeywordsStr);

  j=0;
  while((*pKeywordsStr!=0xA)&&(*pKeywordsStr!=NULL))
    tmp[j++] = *(pKeywordsStr++);

  tmp[j]=0;
  pKeywordsStr++;

  *numOfWords = StrAToI(tmp);

  tmpWords = (Keyword *)MemPtrNew(sizeof(Keyword) * (*numOfWords));
  if(!tmpWords) {
    error("Not enough memory to contain all the HTML keywords !");
    tmpWords = NULL;
    return NULL;
  }

  for(i=0;i<*numOfWords;i++) {
    j=0; tmpHash=0;
    while((*pKeywordsStr!=0xA)&&(*pKeywordsStr!=NULL)){
      tmp[j++] = *pKeywordsStr;
      tmpHash ^= *pKeywordsStr;
      pKeywordsStr++;
    }

    tmp[j] = 0;
    tmpWords[i].name = (char*)MemPtrNew(j+1);
    if(!tmpWords[i].name) {
      // Maybe we'll have to add a better management for this case...
      error("Not enough memory to contain all the HTML keywords !");
      tmpWords = NULL;
      return NULL;
    }
    StrCopy(tmpWords[i].name,tmp);
    tmpWords[i].hash=tmpHash;
    tmpWords[i].len=j;
    pKeywordsStr++;
  }

  MemHandleUnlock(hKeywordsStr);
  DmReleaseResource(hKeywordsStr);
  return tmpWords;
}



/***********************************************************************
 *
 * FUNCTION:    MainFormHandleEvent
 *
 * DESCRIPTION: this routine is the event handler for the
 *              "MainForm" of this application.
 *
 * PARAMETERS:  eventP  - a pointer to an EventType structure
 *
 * RETURNED:    true if the event has handle and should not be passed
 *              to a higher level handler.
 *
 * REVISION HISTORY:
 *
 *
 ***********************************************************************/
Boolean MainFormHandleEvent(EventPtr eventP)
{
    Boolean handled = false;
    FormPtr frmP = FrmGetActiveForm();
    UInt32 keyState = 0x00000000;
    // unsigned int originalStartCharacter = 0;
    //char tempFileList[MAX_FILES+1][dmDBNameLength];

    switch (eventP->eType) {
        case frmLoadEvent:
            //
            gSelectionMadeWith = key_None;
            break;

        case menuEvent:
            return MainFormDoCommand(eventP->data.menu.itemID);

        case winExitEvent:
            if (eventP->data.winExit.exitWindow == (WinHandle) FrmGetFormPtr(MainForm)) {
                gBlinkAllowed = false;
            }
            break;

        case winEnterEvent:
            if (eventP->data.winEnter.enterWindow == (WinHandle) FrmGetFormPtr(MainForm)) {
                gBlinkAllowed = true;
            }
            break;

        case fldChangedEvent:  // S040
            if(eventP->data.fldChanged.fieldID == MainDummyField){
                handled = doPostKeyboard(eventP->data.fldChanged.pField);
            }
            break;

        case nilEvent :
            if (gBlinkAllowed && hasSelection() && isEmptySelection() && isBlinkOnScreen()) {
                unsigned long curTime = TimGetTicks();
                if (curTime > gBlinkTime) {
                    if (gBlinkDrawn) {
                        eraseBlinkingCursor();
                    }
                    else {
                        drawBlinkingCursor();
                    }
                    //gBlinkDrawn = !gBlinkDrawn;
                    gBlinkTime = curTime + BlinkDelay;
                }
            }
            if (stitchBlocks()) {
                //FrmCustomAlert(1000,"Debug alert ! (it's to find all the drawPage calls :)","Stitch blocks",0);
                redrawPage();
            }
            break;

        case ctlSelectEvent :
            if ((eventP->data.ctlSelect.controlID - MainButton0Button) < VisibleToolbarEntries )  {
                int index = (eventP->data.ctlSelect.controlID - MainButton0Button) + gToolbarStart;
                handled = (functionList[gToolbar[index].handlerIndex])();
                break;
            }
            //else the button selected is one of the popup list triggers
        //  if (eventP->data.ctlSelect.controlID == MainToolsButton ) {
                //new code 04/22/2002--populate the Tools list and assign actions to the list items
                //this code was moved to the doToolsPopup function
        //  }

        //  if (eventP->data.ctlSelect.controlID == MainMRUButton ) {
                //new code 05/09/2002--populate the MRU list
                //this code was moved to the doMRUPopup function
        //  }

        case ctlRepeatEvent :
            switch (eventP->data.ctlRepeat.controlID) {
                case MainScrollRightRepeating :
                    scrollScreen(screenScrollDirectionRight);
                    eventP->data.ctlRepeat.time = 0;    // force fast repeat
                    handled = false;
                    break;
                case MainScrollLeftRepeating :
                    scrollScreen(screenScrollDirectionLeft);
                    eventP->data.ctlRepeat.time = 0;    // force fast repeat
                    handled = false;
                    break;
            }
            break;
        case sclRepeatEvent :
            if (eventP->data.sclRepeat.newValue == (eventP->data.sclRepeat.value + 1)) {
                    scrollDown(&gCurrentSelection);
            } else {
                if (eventP->data.sclRepeat.newValue == (eventP->data.sclRepeat.value - 1)) {
                    scrollUp(&gCurrentSelection);
                } else {

                    screenTopLine = eventP->data.sclRepeat.newValue;
                    screenYOrigin = screenTopLine * FontHeight;
                    fillLineBuffer(screenTopLine);
                    drawPage();
//                  if (hasSelection() && !isEmptySelection())
//                      invertSelectionOnPage(&gCurrentSelection, false);
                }
            }
            break;
        case keyDownEvent :
            // error("Led3/keyDownEvent");

            handled = handleKeyDown(eventP->data.keyDown);
            //  handled = handleKeyDown(eventP->data.keyDown.chr);

            keyState = KeyCurrentState();
            if (SonyKeyIsJog(eventP, keyState))
                return handleJogDial(eventP->data.keyDown);

            break;
        case penDownEvent : {
            // error("Led3.cpp/penDownEvent");
                int actualPageHeight = PageHeight;
                int actualPageWidth = PageXOrigin + PageWidth;
                if ((screenTopLine + LinesPerPage) > gMaxLines) {
                    actualPageHeight = (gMaxLines - screenTopLine) * FontHeight;
                }
/*
                if (gMaxLines <= LinesPerPage) {
                    actualPageWidth = 160;
                }
*/
            if (gMaxLines <= LinesPerPage)
            {
                actualPageHeight = (gMaxLines - screenTopLine) * FontHeight;
            }




                if ((eventP->screenX >= 0) && (eventP->screenX < actualPageWidth)
                        && (eventP->screenY >= PageYOrigin) && (eventP->screenY < (PageYOrigin + actualPageHeight))) {
                    if ((gLastDoubleTap + DOUBLE_TAP_TIME) > TimGetTicks()) {
                        if (handleDoubleTap(eventP->screenX, eventP->screenY, true)) {
/*
                            int startY = gCurrentSelection.startLine * FontHeight;
                            int startX = gCurrentSelection.startOffset;
                            convertDocumentXYToScreenXY(&startX, &startY);

                            setStartPosition(startX, startY);
                            handlePenDownInPage(startX, startY, false);
*/
                            gSelectionMadeWith = key_None;
                            break;
                        }
                    }
                    else {
                        if ((gLastPenDown + DOUBLE_TAP_TIME) > TimGetTicks()) {
                            if (handleDoubleTap(eventP->screenX, eventP->screenY, false)) {
                                gLastDoubleTap = TimGetTicks();
/*
                                handlePenDownInPage(eventP->screenX, eventP->screenY, false);
*/
                                gSelectionMadeWith = key_None;
                                break;
                            }
                        }
                    }
                    gLastPenDown = TimGetTicks();
                    Boolean capsLock = NULL;
                    Boolean numLock = NULL;
                    UInt16 tempShift = NULL;
                    Boolean autoShifted = NULL;
                    GrfGetState(&capsLock, &numLock, &tempShift, &autoShifted);
                    if ((tempShift == grfTempShiftUpper) && hasSelection()) {
                        if (isEmptySelection()) {
                            if (isBlinkOnScreen()) {
                                clearBlinkingCursor();
                            }
                        }
                        else {
                            invertSelectionOnPage(&gCurrentSelection, false);
                        }
                        int x = eventP->screenX;
                        int y = eventP->screenY;
                        convertScreenXYToDocumentXY(&x, &y);
                        Word line = y / FontHeight;
                        Word chr = getCharacterForX(line, &x);

                        if (line < gCurrentSelection.startLine) {
                            gCurrentSelection.startLine = line;
                            gCurrentSelection.startCharacter = chr;
                            gCurrentSelection.startOffset = x;
                        }
                        else {
                            if (line == gCurrentSelection.startLine) {
                                if (chr < gCurrentSelection.endCharacter) {
                                    gCurrentSelection.startCharacter = chr;
                                    gCurrentSelection.startOffset = x;
                                }
                                else {
                                    gCurrentSelection.endCharacter = chr;
                                    gCurrentSelection.endOffset = x;
                                }
                            }
                            else {
                                gCurrentSelection.endLine = line;
                                gCurrentSelection.endCharacter = chr;
                                gCurrentSelection.endOffset = x;
                            }
                        }
                        //
                        markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                                        gCurrentSelection.endLine, gCurrentSelection.endCharacter);
                        if (isEmptySelection()) {
                            setBlinkCharacter();
                        }
                        else {
                            invertSelectionOnPage(&gCurrentSelection, false);
                        }
                        GrfSetState(false, false, false);
                    }
                    else {
//error("!");
                        if (hasSelection()) {   // clear away any existing selection
                            if (isEmptySelection()) {
                                if (isBlinkOnScreen()) {
                                    clearBlinkingCursor();
                                }
                            }
                            else {
                                invertSelectionOnPage(&gCurrentSelection, false);
                            }
                        }
                        setStartPosition(eventP->screenX, eventP->screenY);
                        // force an empty selection at the penDown to provide immediate feedback
                        buildSelection(eventP->screenX, eventP->screenY, &gCurrentSelection);
                        if (adjustXOrigin()) refreshPageContents();
                        //
                        setBlinkCharacter();
                        drawBlinkingCursor();
                        handlePenDownInPage(eventP->screenX, eventP->screenY, true);
                        gSelectionMadeWith = key_None;
                    }

                    handled = true;
                    }
            }
            break;

        case frmUpdateEvent:
            drawPage();
            break;

        case frmOpenEvent: {
                // Add Alphasmart Dana support
                if (gIsWideDana) {
                    resizeMainForm (frmP);
                }
                FrmDrawForm(frmP);
                if (gRomVersion >= version35) {
                    WinSetBackColor(0);
                }
                WinEraseRectangle(&gFullScreen, 0);
                FrmDrawForm(frmP);
                MainFormInit(frmP);
                handled = true;
            }
            break;

        default:
            break;
        }

    return handled;
}

Boolean NewFile()
{
    FormPtr dlg = FrmInitForm(NewForm);
    Boolean retval = false;

    // Give the NewNewNameField the Focus
      UInt16 objIndex = FrmGetObjectIndex(dlg, NewNewNameField);
      FrmSetFocus(dlg, objIndex);

        newtry:
    if (FrmDoDialog(dlg) == NewOKButton) {
        FieldPtr fld = (FieldPtr)getObjectPtr(dlg, NewNewNameField);
        Handle h = FldGetTextHandle(fld);
        if (h != NULL) {
            if (gCurFile != -1) {
                saveDocFile(gCurrentFile, false);
                setSelectionForDB();
            }
            CharPtr p = (CharPtr)MemHandleLock(h);
            if (!newDocFile(p)){
               MemHandleUnlock(h);
               goto newtry;
            }
            StrCopy(gCurrentFile, p);
            MemHandleUnlock(h);
            AddCurrentFileToMRU();
            fillLineBuffer(0);
            screenYOrigin = 0;
            screenXOrigin = 0;
            screenTopLine = 0;
            setGUISelection(true);
            refillBuffer();
            adjustXOrigin();
            saveDocFile(gCurrentFile, false);
            gSetHighlightMode = true;  // #846293 (S046) pick highlight mode based on file extension
            setHighlightMode(gCurrentFile);  // #846293(S046) pick highlight mode based on file extension
            setSelectionForDB();
            FrmGotoForm(MainForm);      // we're already in the MainForm, but want to restart it
            retval = true;
        }
        else{
            error("Need a file name");
            goto newtry;
        }
    }
    FrmDeleteForm(dlg);
    return retval;
}

Boolean OpenFormHandleEvent(EventPtr eventP)
{
    Boolean handled = false;
    FormPtr frmP = FrmGetActiveForm();
    ListPtr lst = (ListPtr)getObjectPtr(frmP, OpenFileList);

    switch (eventP->eType) {
        case frmOpenEvent: {
                FrmDrawForm(frmP);
                char dbName[dmDBNameLength];
                if (gFilenameList != NULL) {
                    for (int i = 0; i < gFilenameCount; i++) {
                        MemPtrFree(gFilenameList[i]);
                    }
                    MemPtrFree(gFilenameList);
                }
                UInt count = DmNumDatabases(0);
                gFilenameList = (char **)MemPtrNew(sizeof(char *) * count);
                gFilenameCount = 0;
                /*for (Word i = 0; i < count; i++) {
                    ULong type;
                    ULong creator;
                    LocalID dbID = DmGetDatabase(0, i);
                    DmDatabaseInfo(0, dbID, dbName, 0, 0, 0, 0, 0, 0, 0, 0, &type, &creator);
                    if ((type == 'TEXt')  && (creator == 'REAd')) {
                        int strLength = StrLen(dbName);
                        gFilenameList[gFilenameCount] = (char *)MemPtrNew(strLength + 1);;
                        StrCopy(gFilenameList[gFilenameCount], dbName);
                        gFilenameCount++;
                    }
                }*/
                DmSearchStateType state;
                LocalID dbID;
                int strLength;
                UInt16 card = 0;
                if(DmGetNextDatabaseByTypeCreator(true,&state,'TEXt','REAd',false,&card,&dbID)==errNone) {
                    DmDatabaseInfo(0, dbID, dbName, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
                    strLength = StrLen(dbName);
                    gFilenameList[gFilenameCount] = (char *)MemPtrNew(strLength + 1);
                    StrCopy(gFilenameList[gFilenameCount], dbName);
                    gFilenameCount++;

                    while(DmGetNextDatabaseByTypeCreator(false,&state,'TEXt','REAd',false,&card,&dbID)==errNone) {
                        DmDatabaseInfo(0, dbID, dbName, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
                        strLength = StrLen(dbName);
                        gFilenameList[gFilenameCount] = (char *)MemPtrNew(strLength + 1);
                        StrCopy(gFilenameList[gFilenameCount], dbName);
                        gFilenameCount++;
                    }
                }

                if(gFilenameCount==0) {
                    if(!NewFile()) {    // cancelled the creation of the new file. We quit the app,
                        EventType evt;                      // as we have nothing else to do
                        MemSet(&evt,sizeof(evt),0);
                        evt.eType = appStopEvent;
                        EvtAddEventToQueue(&evt);
                    }
                } else {
                    Int16 i;
                    SysQSort(gFilenameList, gFilenameCount, sizeof(char *), sortFn, 0);
                    LstSetListChoices(lst, gFilenameList, gFilenameCount);
                    if(gCurFile!=-1)
                        for(i=0;i<gFilenameCount;i++) {
                            if(!StrCompare(gFilenameList[i],gCurrentFile))
                            {
                                LstSetSelection(lst,i);
                                LstMakeItemVisible(lst,i);  // For PalmOS <3.5
                                i=gFilenameCount;
                            }
                    }
                    LstDrawList(lst);
                }
                handled = true;
            }
            break;
        case keyDownEvent:
            handled = scrollList(frmP, lst, eventP->data.keyDown.chr, gFilenameList, gFilenameCount);
            break;
        case ctlSelectEvent :
            switch (eventP->data.ctlSelect.controlID) {
                case OpenOKButton : {
                        Word x = LstGetSelection(lst);
                        if (x != (Word)-1) {
                            if (gCurFile != -1) {
                                saveDocFile(gCurrentFile, false);
                                setSelectionForDB();
                            }
                            StrCopy( gCurrentFile, gFilenameList[x] );
                            AddCurrentFileToMRU();
                            if(loadDocFile(gCurrentFile)) {
                                fillLineBuffer(0);
                                screenYOrigin = 0;
                                screenTopLine = 0;
                                getSelectionForDB();
                                // #846293 (S046) pick highlight mode based on file extension
                                gSetHighlightMode = true;
                                setHighlightMode(gCurrentFile);

                                if (gFilenameList != NULL) {
                                    for (int i = 0; i < gFilenameCount; i++)
                                        MemPtrFree(gFilenameList[i]);
                                    MemPtrFree(gFilenameList);
                                    gFilenameList = NULL;
                                }

                                FrmGotoForm(MainForm);
                            }
                        }
                    }
                    break;
                case OpenCancelButton :
                    if (gCurFile != -1) {
                        if (gFilenameList != NULL) {
                            for (int i = 0; i < gFilenameCount; i++) {
                                MemPtrFree(gFilenameList[i]);
                            }
                            MemPtrFree(gFilenameList);
                            gFilenameList = NULL;
                        }
                        FrmGotoForm(MainForm);
                    } else { // No existing open file so stop this app.
                        if (gFilenameList != NULL) {
                            for (int i = 0; i < gFilenameCount; i++) {
                                MemPtrFree(gFilenameList[i]);
                            }
                            MemPtrFree(gFilenameList);
                            gFilenameList = NULL;
                        }
                        EventType newEvent;
                        MemSet(&newEvent, sizeof(EventType), 0);
                        newEvent.eType = appStopEvent;
                        EvtAddEventToQueue(&newEvent);
                    }
                    break;
                case OpenNewButton: // #874196 'New' button on open form
                    if (gFilenameList != NULL) {
                        for (int i = 0; i < gFilenameCount; i++) {
                            MemPtrFree(gFilenameList[i]);
                        }
                        MemPtrFree(gFilenameList);
                        gFilenameList = NULL;
                    }
                    NewFile();
                    break;
            }
            handled = true;
            break;
        default:
            break;
    }
    return handled;
}

void SaveAs()
{
    FormPtr dlg = FrmInitForm(NewForm);
    char title[8] = "Save As";

    if(gCurFile==-1)
        return;

    FrmSetTitle(dlg,title);

    // Give the NewNewNameField the Focus
    UInt16 objIndex = FrmGetObjectIndex(dlg, NewNewNameField);
    FrmSetFocus(dlg, objIndex);

    secondtry:                                          // #861914 "save as" crash
    if (FrmDoDialog(dlg) == NewOKButton) {
        FieldPtr fld = (FieldPtr)getObjectPtr(dlg, NewNewNameField);
        Handle h = FldGetTextHandle(fld);
        if (h != NULL) {

            saveDocFile(gCurrentFile, false);
            setSelectionForDB();

            CharPtr p = (CharPtr)MemHandleLock(h);

            if(!newDocFile(p)) {
                MemHandleUnlock(h);             // #861914 "save as" crash
                goto secondtry;                 // #861914 "save as" crash
            }

            loadDocFile(gCurrentFile);  // cannot fail
            fillLineBuffer(0);
            screenYOrigin = 0;
            screenXOrigin = 0;
            screenTopLine = 0;
            setGUISelection(true);
            refillBuffer();
            adjustXOrigin();

            saveDocFile(p,false);
            setSelectionForDB();

            StrCopy(gCurrentFile, p);

            // #846293 (S046) pick highlight mode based on file extension
            gSetHighlightMode = true;
            setHighlightMode(gCurrentFile);

            MemHandleUnlock(h);

            AddCurrentFileToMRU();
            redrawPage();               // #847959 (S062) saveAs screen bug

            // FrmGotoForm(MainForm);   // we're already in the MainForm, but want to restart it
        }
    }
    FrmDeleteForm(dlg);
}

void setSelectionForDB()
{
    UInt32 curTime      = TimGetSeconds();
    UInt32 earliestTime = curTime;
    int earliestIndex   = -1;

    for (int i = 0; i < MAX_SAVED_DB; i++) {
        if (StrCompare(gCurrentFile, g_dbSaveData[i].dbName) == 0) {
            g_dbSaveData[i].selection = gCurrentSelection;
            g_dbSaveData[i].lastReference = curTime;
            return;
        }
    }

    // didn't find it
    // find an empty slot...
    for (int i = 0; i < MAX_SAVED_DB; i++) {
        if (g_dbSaveData[i].dbName[0] == '\0') {
            StrCopy(g_dbSaveData[i].dbName, gCurrentFile);
            g_dbSaveData[i].selection = gCurrentSelection;
            g_dbSaveData[i].lastReference = curTime;
            return;
        }
        if (g_dbSaveData[i].lastReference < earliestTime) {
            earliestTime = g_dbSaveData[i].lastReference;
            earliestIndex = i;
        }
    }

    // no empties, blow off the least recently used
    if (earliestIndex != -1) {
        StrCopy(g_dbSaveData[earliestIndex].dbName, gCurrentFile);
        g_dbSaveData[earliestIndex].selection = gCurrentSelection;
        g_dbSaveData[earliestIndex].lastReference = curTime;
    }
}

static void unLoadKeywords()
{
    int i;
    if(gCKeywords) {

        for(i=0;i<gNumCKeywords;i++) {
            MemPtrFree(gCKeywords[i].name);
        }
        MemPtrFree(gCKeywords);
    }
    if(gHTMLKeywords) {

        for(i=0;i<gNumHTMLKeywords;i++) {
            MemPtrFree(gHTMLKeywords[i].name);
        }
        MemPtrFree(gHTMLKeywords);
    }
    if(gASMKeywords) {
      for(i=0;i<gNumASMKeywords;i++){
    MemPtrFree(gASMKeywords[i].name);
      }
      MemPtrFree(gASMKeywords);
    }

    if(gCComments)
      MemPtrFree(gCComments);

    if(gASMComments)
      MemPtrFree(gASMComments);

    if(gHTMLComments)
      MemPtrFree(gHTMLComments);
}

