#ifndef __LEDGLOBALS_H__
#define __LEDGLOBALS_H__

#include "Led_res.h"
// #include "TextContents.h"
#include "Screen.h"         // Also includes "WideTallApp.h"

#define appFileCreator   'LedX'
#define appVersionNum     0x01
#define appPrefID         0x00
#define appPrefVersionNum 0x01

#ifdef SONY_SUPPORT
#include <SonyCLIE.h>
#endif

#define DEBUG
#ifdef DEBUG
#define TEXT_ASSERT(cond, mess) if (!(cond)) error(mess)
#else
#define TEXT_ASSERT(cond, mess)
#endif

#define BEEP_PITCH 95       //pitch==high treble g
#define BEEP_DURATION 250  // was 500 ticks

#define NOMODE 0
#define CMODE 1
#define HTMLMODE 2
#define ASMMODE 3

#define MAX_FILES 8
#define MAX_SAVED_DB 8
#define ToolbarEntries 11 //9 //18  **new interface 4/22/2002**

#define vchrRockerUp            0x0132  // 5-way rocker up (Treo)
#define vchrRockerDown          0x0133  // 5-way rocker down (Treo)
#define vchrRockerLeft          0x0134  // 5-way rocker left (Treo)
#define vchrRockerRight         0x0135  // 5-way rocker right (Treo)
#define vchrRockerCenter        0x0136  // 5-way rocker center/press (Treo)
/*
#define keyBitRockerUp          0x00010000
#define keyBitRockerDown        0x00020000
#define keyBitRockerLeft        0x00040000
#define keyBitRockerRight       0x00080000
#define keyBitRockerCenter      0x00100000
*/
#define keyBit5wayUp            0x0001
#define keyBit5wayDown          0x0002
#define keyBit5wayLeft          0x0004
#define keyBit5wayRight         0x0008

// #define chrReverseSolidus       0x005C

// #864525 Scrolling is buggy with 5-way key + #846728 (S016) External Keyboard Support (and Internal Hardware Keyboards)
#define T_PAGEUP(eventP, keyState)            (keyState == 0x00000002L && eventP->data.keyDown.chr == pageUpChr   && ((eventP->data.keyDown.keyCode == 0x0101 && eventP->data.keyDown.modifiers == commandKeyMask) || (eventP->data.keyDown.keyCode == keyBit5wayUp    && eventP->data.keyDown.modifiers == (autoRepeatKeyMask | commandKeyMask))))
#define T_PAGEDOWN(eventP, keyState)          (keyState == 0x00000004L && eventP->data.keyDown.chr == pageDownChr && ((eventP->data.keyDown.keyCode == 0x0202 && eventP->data.keyDown.modifiers == commandKeyMask) || (eventP->data.keyDown.keyCode == keyBit5wayDown  && eventP->data.keyDown.modifiers == (autoRepeatKeyMask | commandKeyMask))))
#define T_PAGELEFT(eventP, keyState)          (keyState == 0x01000000L && eventP->data.keyDown.chr == 0x0503      && ((eventP->data.keyDown.keyCode == 0x0404 && eventP->data.keyDown.modifiers == commandKeyMask) || (eventP->data.keyDown.keyCode == keyBit5wayLeft  && eventP->data.keyDown.modifiers == (autoRepeatKeyMask | commandKeyMask))))
#define T_PAGERIGHT(eventP, keyState)         (keyState == 0x02000000L && eventP->data.keyDown.chr == 0x0503      && ((eventP->data.keyDown.keyCode == 0x0808 && eventP->data.keyDown.modifiers == commandKeyMask) || (eventP->data.keyDown.keyCode == keyBit5wayRight && eventP->data.keyDown.modifiers == (autoRepeatKeyMask | commandKeyMask))))

// #846728 (S016) External Keyboard Support
#define PAGE_UP(eventP, keyState)             (eventP->eType == keyDownEvent && (((eventP->data.keyDown.chr == pageUpChr)   && (eventP->data.keyDown.keyCode == 0x0000)  && keyState && (eventP->data.keyDown.modifiers == commandKeyMask || eventP->data.keyDown.modifiers == (autoRepeatKeyMask | commandKeyMask))) || T_PAGEUP(eventP, keyState)))
#define PAGE_DOWN(eventP, keyState)           (eventP->eType == keyDownEvent && (((eventP->data.keyDown.chr == pageDownChr) && (eventP->data.keyDown.keyCode == 0x0000)  && keyState && (eventP->data.keyDown.modifiers == commandKeyMask || eventP->data.keyDown.modifiers == (autoRepeatKeyMask | commandKeyMask))) || T_PAGEDOWN(eventP, keyState)))


typedef enum{
    // The order of these enums has to equal the order of list items in SrcEdit.rcp/FORM ID 1200
    KbSup_NoKeyboard = 0,
    KbSup_PalmPortableKeyboard,
    KbSup_PalmWirelessKeyboard,
    KbSup_UltraThinKeyboard,
    KbSup_BelkinWirelessKeyboard,
    // KbSup_Stowaway
    KbSup_SonyNxInternalKeyboard,
    KbSup_SonyUxInternalKeyboard,
    KbSup_ClieNR70InternalKeyboard,
    KbSup_Treo90InternalKeyboard,
    KbSup_Treo600InternalKeyboard,
    KbSup_AlphasmartDanaKeyboard
    // Add more supported keyboards here
}KbSup_SupportedKeyboardType;

typedef enum{
    KbSup_None,
    KbSup_Up,
    KbSup_Down,
    KbSup_Left,
    KbSup_Right,
    KbSup_ShiftUp,
    KbSup_ShiftDown,
    KbSup_ShiftLeft,
    KbSup_ShiftRight,
    KbSup_CtrlUp,
    KbSup_CtrlDown,
    KbSup_CtrlLeft,
    KbSup_CtrlRight,
    KbSup_CmdUp,
    KbSup_CmdDown,
    KbSup_CmdLeft,  // Home
    KbSup_CmdRight, // End
    KbSup_PageUp,
    KbSup_PageDown,
    KbSup_PageLeft,
    KbSup_PageRight,
    KbSup_Del,
    KbSup_Tab,
    KbSup_ShiftTab,
    KbSup_ShiftCtrlUp,
    KbSup_ShiftCtrlDown,
    KbSup_ShiftCtrlLeft,
    KbSup_ShiftCtrlRight,
    KbSup_ShiftCmdUp,
    KbSup_ShiftCmdDown,
    KbSup_ShiftCmdLeft,
    KbSup_ShiftCmdRight
}KbSupAsKey;

typedef struct{
    UInt16 KbSup_chr;
    UInt16 KbSup_keyCode;
    UInt16 KbSup_modifiers;
    // UInt32 KbSup_keyState;
    KbSupAsKey KbSup_AsKey;
}KbSup_Type;

typedef enum{
    key_None,
    key_Up,
    key_Down,
    key_Left,
    key_Right,
    key_ShiftUp,
    key_ShiftDown,
    key_ShiftLeft,
    key_ShiftRight,
    key_CtrlUp,
    key_CtrlDown,
    key_CtrlLeft,
    key_CtrlRight,
    key_CmdUp,
    key_CmdDown,
    key_CmdLeft,
    key_CmdRight,
    key_Del,
    key_Tab,
    key_ShiftTab,
    key_PageUp,
    key_PageDown,
    key_PageLeft,
    key_PageRight
}selectionMadeWithKey;

// #910455 Support the Sony Jog-Dial for Scrolling *******************************************
/* From the Sony SDK */

#define vchrJogUp				(0x1700)
#define vchrJogDown				(0x1701)
#define vchrJogPushRepeat		(0x1702)
#define vchrJogPushedUp			(0x1703)
#define vchrJogPushedDown		(0x1704)
#define vchrJogPush				(0x1705)
#define vchrJogRelease			(0x1706)
#define vchrJogBack				(0x1707) 		/* added @ 2001 */
#define vchrJogLeft				(0x1708) 		/* added @ 2003 */
#define vchrJogRight			(0x1709) 		/* added @ 2003 */

/* Macro for checking if it is the Jog-Dial that created the event */
#define SonyKeyIsJog(eventP, keyState)	\
	((((eventP->data.keyDown.chr >= vchrJogUp)	\
		 && (eventP->data.keyDown.chr <= vchrJogRight)) \
		    && keyState == 0x00000000L)? true: false)

// *****************************************************************************************

#define screenScrollDirectionRight 0
#define screenScrollDirectionLeft 1

// Used with doCaseShifts(choice)
#define doToLower 0
#define doToUpper 1
#define doShiftCase 3
#define doRevers 4

// the page is the visible portion of the document
#define PageXOrigin 2 //was 2   fixes difficulty inserting cursor at beginning of a line
#define PageYOrigin 2
#define WIDTH_OFFSET 9
#define HIGHT_OFFSET 17

#define version20 0x02000000
#define version30 0x03000000
#define version32 0x03200000
#define version33 0x03300000
#define version35 0x03500000
#define version50 0x05000000

#define MAX_CHARS_PER_LINE 200

// this is for debugging
#define YikesAlert 1100

#define BlinkDelay 70

#define CLOSURE_CHAR (0xFF)

#define DOUBLE_TAP_TIME 45

#define SysTrapString 1000

#define FunctionCount 15 //10 //17 **new interface 4/22/2002**

#define VisibleToolbarEntries 11//9

#ifdef __GNUC__
// Declares functions in the second code section
#define INTEXTCODE __attribute__ ((section ("textcont")))
#define INCODE3    __attribute__ ((section ("code3")))
#define INCODE4    __attribute__ ((section ("code4")))
#else
// To keep compatibility with other compilers.
#define INTEXTCODE
#define INCODE3
#define INCODE4
#endif

#define MAX_SEGMENT 64

typedef enum {PlainText, CollapsedText } SegmentKind;

typedef struct {
	SegmentKind kind;
	CharPtr text;			// only valid for PlainText
	Word length;
} Segment;

typedef struct {
	Word count;						// number of segments in the line
	Segment segment[MAX_SEGMENT];	// the segments
} SegmentData;

typedef struct{
  char *start;
  char *end;
  unsigned int startLen;
  unsigned int endLen;
  char startHash;
  char endHash;
} CommentInfo;

typedef Boolean (*ButtonDispatch)();

typedef struct {
    unsigned int length;        // number of characters on line
    char *text;
} BufferedText;

typedef struct {
    unsigned int startLine;
    unsigned int endLine;
    unsigned int startCharacter;        // these are per line
    unsigned int endCharacter;
    unsigned int startOffset;           // pixel offsets on the line (within the document, not the page)
    unsigned int endOffset;
} SelectionRange;

// map from DB name to selection data, since we don't
// want to invent some new DB internal data that another
// editor may clobber.
typedef struct DBSaveData {
    char             dbName[dmDBNameLength];
    SelectionRange   selection;
    UInt32           lastReference;            // last time this DB was saved to (for MRU)
} DBSaveData;

typedef struct {
    int handlerIndex;
	// char key[4];
	// FontID font;
} ToolbarEntry;

typedef struct LedPreferenceType {
    char             dbName[dmDBNameLength];
    char             fileList[MAX_FILES][dmDBNameLength];
    int              fileListCount;
    ToolbarEntry     toolbarSetting[ToolbarEntries]; //this array has changed in size with the new toolbar-->OBC problems on a Goto launch of SourcEdit
    DBSaveData       dbSaveData[MAX_SAVED_DB];
    int              curFile;
    int              currentFont; //new code... it's possible that these additions to the struct are part of the Goto launch problem, although they come after dbSaveData
    Boolean          colorMode; //new code
    IndexedColorType comments; //new code
    IndexedColorType commentsSaved; //new code
    IndexedColorType keywords;
    IndexedColorType keywordsSaved;
    // Boolean          HTMLmode; //new code
    UInt8            HighlightMode; // #846293 (S046) pick highlight mode based on file extension
    KbSup_SupportedKeyboardType SupportedKeyboard; // #846728 (S016) External Keyboard Support
    UInt8            hardKeysScrollValues;  // #846292 (S051) Use hard buttons to scroll
    Boolean          useTabForTab;  // #847961 (S061) Add Tab/Spaces option
    UInt8            tabWidth;
    UInt8            tabSpaces;     // #847961 (S061) Add Tab/Spaces option
    Boolean          autoParen;
    int              commentLines;
    Boolean          keywordsBold;
} LedPreferenceType;

typedef struct{
  char *name;
  unsigned int len;
  char hash;
} Keyword;
/*
extern const unsigned long  appFileCreator;
extern const unsigned short appVersionNum;
extern const unsigned short appPrefID;
extern const unsigned short appPrefVersionNum;
*/
extern char gCurrentFile[dmDBNameLength];
extern char gFileList[MAX_FILES][dmDBNameLength];
extern int gFileListCount;
extern int gCurFile;
extern ToolbarEntry gToolbar[ToolbarEntries];
extern DBSaveData g_dbSaveData[MAX_SAVED_DB];
extern FontID gCurrentFont;
extern Boolean gColorMode;
extern IndexedColorType ictComments;
extern IndexedColorType ictKeywords;
extern IndexedColorType ictCommentsSaved;
extern IndexedColorType ictKeywordsSaved;
extern IndexedColorType ictText;
extern IndexedColorType ictString;
extern Boolean gAutoParen;
extern int gTabWidth;
extern int gTabSpaces;
extern Boolean gUseTabForTab;
extern int gCommentLines;
extern int gNumCKeywords;
extern int gNumHTMLKeywords;
extern int gNumASMKeywords;
extern int gNumCComments;
extern int gNumASMComments;
extern int gNumHTMLComments;
extern Keyword *gCKeywords;
extern Keyword *gHTMLKeywords;
extern Keyword *gASMKeywords;
extern CommentInfo *gCComments;
extern CommentInfo *gASMComments;
extern CommentInfo *gHTMLComments;
extern Coord PageWidth;
extern Coord PageHeight;
extern RectangleType gClipRect;
extern RectangleType gFullScreen;
extern Boolean gIsWideDana;
extern DWord gRomVersion;
extern UInt8 FontHeight;
extern UInt8 FontDescender;
extern UInt8 LinesPerPage;
extern UInt8 BlinkingCursorHeight;
extern UInt8 BlinkingCursorTopOffset;
extern FontID oldFont;
extern UInt8 gHighlightMode;
extern Boolean gSetHighlightMode;
extern Boolean gUseHardKeysForScrolling;
extern UInt16 hardLeftKey;
extern UInt16 hardRightKey;
extern UInt16 gOldRepeatDelay;
extern UInt16 gOldPeriod;
extern UInt16 gDoubleTapDelay;
extern Boolean gQueueAhead;
extern FontID fntAppCustomBase;
extern Coord DocumentWidth;
extern unsigned int screenXOrigin;
extern unsigned int screenYOrigin;
extern unsigned int screenTopLine;
extern Handle gSearchTextH;
extern Boolean gSearchIgnoreCase;
extern Boolean gSearchFromTop;
extern char gBlinkCharacter;
extern Boolean gBlinkDrawn;
extern Boolean gBlinkAllowed;
extern unsigned long gBlinkTime;
extern FontID gLED_ClosureFont;
extern int gClosureCharWidth;
extern unsigned int startLine;
extern unsigned int startOffset;
extern unsigned int startCharacter;
extern Boolean gCompletion;
extern Boolean gAutoIndent;
extern unsigned long gLastPenDown;
extern unsigned long gLastDoubleTap;
extern Handle gSysTrapH;
extern long gSysTrapLength;
extern char *gSysTrapSource;
extern SelectionRange gCurrentSelection;
extern BufferedText *bufferedLineContents;
extern Handle gFontH;
extern FontType *gFont;
extern int gToolbarStart;
extern UInt8 gGrfComprStoredState;
extern ButtonDispatch functionList[FunctionCount];
extern WinHandle gOffscreenPage;
extern char **gFilenameList;
extern int gFilenameCount;
extern ToolbarEntry gSavedToolbar[ToolbarEntries];
extern int gSelectedButton;
extern unsigned int gPreKeyboardTxtLen;
extern Word gMaxLines;
extern KbSup_SupportedKeyboardType gKbSup_SupportedKeyboard;
extern MemHandle gKbSup_KeyboardTableH;
extern KbSup_Type *gKbSup_KeyboardTable;
extern int gSelectionMadeWith;

	/* From Led.cpp */
extern Boolean adjustXOrigin();
extern void autoInsertParen(char ch);
extern void clearBlinkingCursor();
extern void checkScreenXState();
extern void convertScreenXYToDocumentXY(int *x, int *y);
extern Boolean disjointSelection(SelectionRange *aSelection, SelectionRange *otherSelection);
extern Boolean doCopy();
extern Boolean doCut();
extern Boolean doPaste();
extern void drawBlinkingCursor();
extern void eraseBlinkingCursor();
extern Boolean extractSelectionWord(int *startChP, int *endChP, char *curLine);
extern void fillLineBuffer(unsigned int startLine);
extern unsigned int getCharacterForX(unsigned int line, int *x);
extern void getLineIntoBuffer(Word line);
extern VoidPtr getObjectPtr(FormPtr frmP, Word objectID);
extern int getXForCharacter(unsigned int line, int index, Boolean forceLoad);
extern Boolean handleJogDial(struct _KeyDownEventType key);
extern Boolean handleDoubleTap(short x, short y, Boolean wholeLine);
extern Boolean handleKeyDown(struct _KeyDownEventType key);
void handlePenDownInPage(short x, short y, Boolean selectionWasEmpty);
extern void invertLinesOnPage(unsigned int startLine, unsigned int endLine, Boolean offscreen);
extern void invertPartialLineOnPage(unsigned int line, unsigned int startOffset, unsigned int endOffset, Boolean offscreen);
extern void invertSelectionOnPage(SelectionRange *selection, Boolean offscreen);
extern Boolean isDocumentXYVisible(int offset, int line);
extern Boolean isBlinkOnScreen();
extern void loadLine(int line, char *text, unsigned int *textLength);
extern void loadLineIntoBuffer(int line, int bufIndex);
extern Boolean MainFormDoCommand(Word command);
extern void MainFormInit(FormPtr frmP);
extern Boolean nullButton();
extern void redrawPage();
extern void refillBuffer();
extern void refreshPageContents();
extern void resetBufferToSelection();
extern void resetFieldUnderline(FormPtr frmP);
extern void setBlinkCharacter();
extern void setGUISelection(Boolean forceLoad);
extern void setHandleFromInt(FormPtr frmP, int fieldID, int value, Boolean editable,Boolean redraw);
extern void setIntFromHandle(FormPtr frmP, int fieldID, char *base, int offset, Boolean check);
extern void setStartPosition(int x, int y);
extern IndexedColorType (*SetTextColor)(IndexedColorType);
extern short sortFn(void *A, void *B, long other);

	/* From Led3.cpp */
extern Boolean AboutFormHandleEvent(EventPtr eventP) INCODE3;
extern void AddCurrentFileToMRU()INCODE3;
extern Boolean AppHandleEvent(EventPtr eventP) INCODE3;
extern void AppStop(void)INCODE3;
extern Boolean doBlockShiftLeft() INCODE3;
extern Boolean doBlockShiftRight()INCODE3;
extern Boolean doFindFunctionHeader() INCODE3;
extern Boolean doFunctionList() INCODE3;
extern Boolean doKeywordCompletion() INCODE3;
extern Boolean doLaunchOnBoardC()INCODE3;
extern Boolean doMRUPopup()INCODE3;
extern Boolean doSearchAgain()INCODE3;
extern Boolean doToolsPopup()INCODE3;
extern Boolean doUndo() INCODE3;
extern void DrawAsKeyword(char *cp, int count,int pos,int y) INCODE3;
extern void drawLine(Word line, Boolean copyToOnscreen) INCODE3;
extern void drawPage() INCODE3;
extern void getSelectionForDB() INCODE3;
extern Boolean IsKeyword(char *token, unsigned int len, char hash) INCODE3;
extern void loadKeywords() INCODE3;
extern Boolean MainFormHandleEvent(EventPtr eventP) INCODE3;
extern Boolean NewFile()INCODE3;
extern Boolean OpenFormHandleEvent(EventPtr eventP) INCODE3;
extern void SaveAs() INCODE3;
extern void setSelectionForDB() INCODE3;

	/* From Led4.cpp */
extern Boolean buildSelection(Word x, Word y, SelectionRange *newSelection) INCODE4;
extern void calculateSelectionDifference(SelectionRange *aSelection,
	SelectionRange *otherSelection, SelectionRange *result) INCODE4;
extern UInt8 compressHardKeysScrollValues(void) INCODE4;
extern Boolean ConfigureFormHandleEvent(EventPtr eventP) INCODE4;
extern void AllocateTheKeyboardTable(void) INCODE4;
extern Boolean KeyboardSupportFormHandleEvent(EventPtr eventP) INCODE4;
extern void DeleteFileFromMRU(char* dbName) INCODE4;
extern Boolean DeleteFormHandleEvent(EventPtr eventP) INCODE4;
extern Boolean doCommentSelection() INCODE4;
extern Boolean doFindReplace(void) INCODE4;
extern void doPreKeyboard() INCODE4;
extern Boolean doPostKeyboard(FieldPtr fldP) INCODE4;
extern void doSelectAll(void) INCODE4;
extern Boolean doUncommentSelection() INCODE4;
extern Boolean FileInfoFormHandleEvent(EventPtr eventP) INCODE4;
extern void getKeyRates(void)INCODE4;
extern Boolean GotoLineFormHandleEvent(EventPtr eventP) INCODE4;
extern Boolean PreferencesFormHandleEvent(EventPtr eventP) INCODE4;
extern void resizeMainForm (FormPtr frmP) INCODE4;
extern void scrollDown(SelectionRange *currentSelection) INCODE4;
extern void scrollLeft(SelectionRange *currentSelection, Word offset) INCODE4;
extern Boolean scrollList(FormPtr frmP, ListPtr lst, char c, char **listContents, int count) INCODE4;
extern void scrollRight(SelectionRange *currentSelection, int offset) INCODE4;
extern void scrollScreen(UInt8 screenScrollDirection) INCODE4;
extern void scrollUp(SelectionRange *currentSelection) INCODE4;
extern void setHardKeysScrollingValues(UInt8 compressedValue) INCODE4;
extern void setHighlightMode(char* dbName) INCODE4;
extern Boolean doCaseShifts(UInt8 choice) INCODE4;

	/* From TextContents.cpp */
extern Boolean backspace() INTEXTCODE;
extern Boolean commentSelection() INTEXTCODE;
extern Boolean copySelection() INTEXTCODE;
extern Boolean cutSelection() INTEXTCODE;
extern Boolean deleteSelection() INTEXTCODE;
extern void error (CharPtr message) INTEXTCODE;
extern Boolean findChar(Word searchStartLine, Word searchStartOffset,
	char t) INTEXTCODE;
extern Boolean findCharBackwards(Word searchStartLine, Word searchStartOffset,
	char t, Word maxDistance) INTEXTCODE;
extern Boolean findMatchingParen(Word searchStartLine, Word searchStartOffset,
	char open_paren, char close_paren) INTEXTCODE;
extern Boolean findMatchingParenBackwards(Word searchStartLine,
	Word searchStartOffset, char open_paren, char close_paren) INTEXTCODE;
extern Boolean findPreviousWord(Word searchStartLine,
	Word searchStartOffset) INTEXTCODE;
extern CharPtr getClipboard(Word *length) INTEXTCODE;
extern SegmentData* getLineContents(Word lineNumber) INTEXTCODE;
extern void getSelection(Word *fromLine, Word *fromOffset, Word *toLine,
	Word *toOffset) INTEXTCODE;
extern Boolean hasSelection() INTEXTCODE;
extern Boolean initText() INTEXTCODE;
extern Boolean insertChars(CharPtr cp, Word length, Word *startChunkP, Word *newOffsetP) INTEXTCODE;
extern Boolean insertCharacters(CharPtr cp, Word length,
	Boolean updateSelection) INTEXTCODE;
extern Boolean insertNewLine() INTEXTCODE;
extern Boolean isEmptySelection() INTEXTCODE;
extern Boolean isWhitespace(char ch) INTEXTCODE;
extern Boolean isWordLetter(char ch) INTEXTCODE;
extern Boolean loadDocFile(CharPtr dbName) INTEXTCODE;
extern void markSelection(Word fromLine, Word fromOffset, Word toLine,
	Word toOffset) INTEXTCODE;
extern unsigned char* mem_find (unsigned char*t, int t_len, unsigned char *m,
	int m_len ) INTEXTCODE;
extern Boolean newDocFile(CharPtr dbName) INTEXTCODE;
extern Boolean pasteSelection() INTEXTCODE;
extern Boolean saveDocFile(CharPtr dbName, Boolean compressFlag) INTEXTCODE;
extern Boolean search(Word searchStartLine, Word searchStartOffset,
	char *searchText, Boolean ignoreCase, Boolean beep) INTEXTCODE;
extern Boolean setClipboard(CharPtr text, Word length) INTEXTCODE;
extern void setSelectionFromCharacterOffsetRange(Word offset,
	Word length) INTEXTCODE;
extern Boolean stitchBlocks() INTEXTCODE;
extern void termText() INTEXTCODE;
extern Boolean uncommentSelectionEnd(UInt8 commentType) INTEXTCODE;
extern Boolean uncommentSelectionStart() INTEXTCODE;
extern Boolean undo() INTEXTCODE;
extern void unmarkSelection() INTEXTCODE;

#endif