
//-----------------------------------------------------------------------
/*
	Externally exposed data types & constants

*/

/*
	rather than building dynamically sized packages to describe line
	contents, we assume that any given line can't have any more than
	a certain number of segments - plain or 'marked' text.
*/

extern CommentInfo *gCComments;
extern CommentInfo *gASMComments;
extern CommentInfo *gHTMLComments;
//-----------------------------------------------------------------------
/*
	Externally exposed data
*/

/*
	number of lines in document. All line numbers must be
	from 0...(gMaxLines - 1).
*/
extern Word gMaxLines;

//-----------------------------------------------------------------------
/*
	Call once per application run to initialize. A false return
	indicates Very Bad Things have happened.
*/
extern Boolean initText() INTEXTCODE;

//-----------------------------------------------------------------------
/*
	Call once per AppStopEvent to release stuff.
*/
void termText() INTEXTCODE;
//-----------------------------------------------------------------------

extern int gNumCComments;       // Comment-out Selection
extern int gNumASMComments;     // Comment-out Selection
extern int gNumHTMLComments;    // Comment-out Selection

// extern UInt8 gHighlightMode;  // #846293 (S046) pick highlight mode based on file extension
// extern Boolean gSetHighlightMode; // #846293 (S046) pick highlight mode based on file extension
// extern void setHighlightMode(char* dbName) INCODE4; // #846293(S046) pick highlight mode based on file extension

//-----------------------------------------------------------------------
/*
    #846291 (S053) Comment-out selected region

    There has to be a Selected region: (check before calling).
    calling 'commentSelection()' will insert comment indicators according to the current Highlightmode, (Available Modes are C, ASM, and HTML).

    Return true upon success.
*/

Boolean findCharsForwards(Word searchStartLine, Word searchStartOffset, char* t, Word maxDistance) INTEXTCODE;
Boolean findCharsBackwards(Word searchStartLine, Word searchStartOffset, char* t, Word maxDistance) INTEXTCODE;
extern Boolean commentSelection() INTEXTCODE;
extern Boolean uncommentSelectionStart() INTEXTCODE;
extern Boolean uncommentSelectionEnd(UInt8 commentType) INTEXTCODE;

//-----------------------------------------------------------------------
/*
	Open the DOC file of the given name. return true if everything
	opened OK, otherwise false. After a succesful open, all internal
	data structures have been initialized.
*/
extern Boolean loadDocFile(CharPtr dbName) INTEXTCODE;

extern Boolean newDocFile(CharPtr dbName) INTEXTCODE;

extern Boolean saveDocFile(CharPtr dbName, Boolean compressFlag) INTEXTCODE;
//-----------------------------------------------------------------------
/*
	Get the contents of a given line, described in terms of segments
	- a segment has a kind that specifies its contents as either :
	PlainText - straightforward, there's a char * and length to extract the
				actual characters from.
	CollapsedText - assumed to represent a single character that
					indicates a collapsed portion of text.

	There may be several segments per line. The <cr> at the line end
	is not included.

	The returned pointer belongs to the TextContents package. Don't
	delete it or assume it's live beyond the next call to the package.

*/
extern SegmentData* getLineContents(Word lineNumber) INTEXTCODE;


//-----------------------------------------------------------------------
/*
	'mark' a selection from and including 'fromOffset' on 'fromLine'
	up to and excluding 'toOffset' on 'toLine'.
	An insertion point has (toLine == fromLine) && (toOfset == fromOffset)
*/
extern void markSelection(Word fromLine, Word fromOffset,
							Word toLine, Word toOffset) INTEXTCODE;

// removes any selection
extern void unmarkSelection() INTEXTCODE;

// retrieves the current selection
extern void getSelection(Word *fromLine, Word *fromOffset,
							Word *toLine, Word *toOffset) INTEXTCODE;

extern void setSelectionFromCharacterOffsetRange(Word offset, Word length) INTEXTCODE;
/*
	Returns true if the current selection is empty (is an insertion point)

*/
extern Boolean isEmptySelection() INTEXTCODE;

/*
	Returns true if there is a current selection

*/
extern Boolean hasSelection() INTEXTCODE;


//-----------------------------------------------------------------------
/*
	insert the specified characters, MAY NOT include '\n'.
	The currect selection (if non-zero in length) is deleted and
	replaced.

	Returns false if (memory) errors occured

	if 'updateSelection' is true the selection is set to a zero width
	at the end of the inserted characters.
*/
extern Boolean insertCharacters(CharPtr cp, Word length, Boolean updateSelection) INTEXTCODE;


/*
	backspace from the current selection - if non-empty, will delete the
	selection, otherwise will erase the character before the insertion
	point. Handles '\n' deletions.
*/

extern Boolean backspace() INTEXTCODE;

/*
	Begin a new line at the current selection (which is deleted
	if non-zero in length).

*/
extern Boolean insertNewLine() INTEXTCODE;



/*
	Clipboard operations :
*/
extern Boolean copySelection() INTEXTCODE;
extern Boolean cutSelection() INTEXTCODE;
extern Boolean pasteSelection() INTEXTCODE;
extern Boolean deleteSelection() INTEXTCODE;
extern Boolean undo() INTEXTCODE;

Boolean setClipboard(CharPtr text, Word length) INTEXTCODE;
CharPtr getClipboard(Word *length) INTEXTCODE;

/*
		idle time
*/
extern Boolean stitchBlocks() INTEXTCODE;

#if 0
/*
		Collapsing
*/
Boolean collapseText(char openDelimiter, char closeDelimiter) INTEXTCODE;
Boolean collapseAll(char openDelimiter, char closeDelimiter) INTEXTCODE;
void uncollapseText(Word line, Word offset) INTEXTCODE;
#endif

Boolean isWordLetter(char ch) INTEXTCODE;
Boolean isWhitespace(char ch) INTEXTCODE;

/*
		Searching, returns true if found and currentSelection updated
		otherwise false
*/
#define BEEP_PITCH 95       //pitch==high treble g
#define BEEP_DURATION 250  // was 500 ticks

Boolean search(Word searchStartLine, Word searchStartOffset, char *searchText, Boolean ignoreCase, Boolean beep) INTEXTCODE;

Boolean findMatchingParen(Word searchStartLine, Word searchStartOffset, char open_paren, char close_paren) INTEXTCODE;
Boolean findMatchingParenBackwards(Word searchStartLine, Word searchStartOffset, char open_paren, char close_paren) INTEXTCODE;
Boolean findChar(Word searchStartLine, Word searchStartOffset, char t) INTEXTCODE;
Boolean findCharBackwards(Word searchStartLine, Word searchStartOffset, char t, Word maxDistance) INTEXTCODE;
Boolean findPreviousWord(Word searchStartLine, Word searchStartOffset) INTEXTCODE;

#define DEBUG

#ifdef DEBUG
#define TEXT_ASSERT(cond, mess) if (!(cond)) error(mess)
#else
#define TEXT_ASSERT(cond, mess)
#endif

extern void error(CharPtr message) INTEXTCODE;


//-----------------------------------------------------------------------

// DEBUG only
extern void buildLineStartsList(ListPtr lst) INTEXTCODE;


