unit disptest1;

(*********************************************************
 * Sharp M078CKA-A3QKLA0057 LC-Display-Testprogramm      *
 * fr Sharp LH155 LCD-Controller                        *
 * copyright (c) Pollin Electronic http://www.pollin.de  *
 * Tassilo Heeg http://www.theeg.de                      *
 * 23.12.2005 fr Windows 95/98/98SE/ME/NT/2000/XP       *
 * Sourcecode fr Borland Delphi 5                       *
 *********************************************************)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, Buttons, ExtCtrls, ComCtrls, Menus,inifiles;

type
  TDispChar = array[0..6] OF BYTE;
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    GroupBox2: TGroupBox;
    Panel1: TPanel;
    Image1: TImage;
    BitBtn1: TBitBtn;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    Label3: TLabel;
    Label4: TLabel;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn6: TBitBtn;
    MainMenu1: TMainMenu;
    Konfiguration1: TMenuItem;
    Beenden1: TMenuItem;
    OpenDialog1: TOpenDialog;
    GroupBox3: TGroupBox;
    Memo1: TMemo;
    Label5: TLabel;
    BitBtn7: TBitBtn;
    Label6: TLabel;
    GroupBox4: TGroupBox;
    BitBtn5: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Konfiguration1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure Beenden1Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private-Deklarationen }
    printerport: word;
    bmp: TBitmap; // Bitmap zum Laden/Speichern
    DispFont: Array[32..127] OF TDispChar; // Speicher fr den 5x7 Display-Font
    LastMouseX,LastMouseY: integer; // Letzte Koordianten bei Mouse-Down-Ereignis
    procedure LPTWriteData(data: byte);
    procedure LPTWriteCtrl(data: byte);
    procedure WriteLHControl(data: byte);
    procedure WriteLHData(data: byte);
    procedure WriteLHBitmap;
    procedure InitLH;
    procedure WriteChar(x,y: integer; c: char);
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses disptest2,zlportio;

{$R *.DFM}

// Konstanten fr die einzelnen Display-Signale
const
  cRESB = 4; // /RESET == Init
  cCSB = 8; // /CSB == SelectIn
  cRS = 2;   // RS == AutoFeed
  cWRB = 1;   // WRB == Strobe
  cWidth = 240;
  cHeight = 64;

procedure TForm1.LPTWriteData;
// ein Byte ins Datenregister des gewhlten Druckerports schreiben
begin
  PortWriteB(printerport,data);
end;

procedure TForm1.LPTWriteCtrl;
// ein Byte ins Steuerregister des gewhlten Druckerports schreiben
// Bits so invertieren, da die richtigen Pegel rauskommen, entsprechend
// der Druckerschnittstellenspezifikation
begin
  PortWriteB(printerport+2,data xor $0B);
end;

procedure TForm1.WriteLHControl;
// ein Byte ins Steuerregister des LH155 schreiben
BEGIN
  LPTWriteData(data);
  LPTWriteCtrl(cRESB+cWRB+cRS);
  LPTWriteCtrl(cRESB+cRS);
  LPTWriteCtrl(cRESB+cWRB+cRS);
  LPTWriteCtrl(cRESB+cWRB+cRS+cCSB);
END;

procedure TForm1.WriteLHData;
// ein Byte ins Datenregister des LH155 schreiben
BEGIN
  LPTWriteData(data);
  LPTWriteCtrl(cRESB+cWRB);
  LPTWriteCtrl(cRESB);
  LPTWriteCtrl(cRESB+cWRB);
  LPTWriteCtrl(cRESB+cWRB+cCSB);
END;

procedure TForm1.WriteLHBitmap;
// Das angezeigte Bild bertragen
var page,column,x: integer;
    y: byte;
    b: byte;
begin
  for y:=0 to cHeight do begin
    // Zeilenadresse whlen
    WriteLHControl($20 or (y and $0F));
    WriteLHControl($30 or (y SHR 4));
    // Spalte = 0
    WriteLHControl($00);
    WriteLHControl($10);
    // Daten einr Zeile ausgeben
    for column:=0 to (cWidth div 8)-1 do begin
      b:=0;
      for x:=0 to 7 do begin
        if image1.Picture.Bitmap.canvas.Pixels[column*8+x,y]=clBlack then begin
          //Pixel setzen
          b:=b or (128 SHR x);
        end;
      end;
      WriteLHData(b);
    end;
  end;
end;

procedure TForm1.InitLH;
// LH155 initalisieren
begin
  LPTWriteCtrl(cWRB+cCSB); // RESET aktiv
  sleep(1);
  LPTWriteCtrl(cRESB+cWRB+cCSB); // RESET inaktiv
  sleep(10);
  WriteLHControl($F0); // RE = 0
  WriteLHControl($40); // Start Display Line =0
  WriteLHControl($50); // Start Display Line =0
  WriteLHControl($61);
  WriteLHControl($70); // n-line Alternating =2
  WriteLHControl($F0); // RE = 0
  WriteLHControl($81); // Display on
  WriteLHControl($92); // Control Register 2
  WriteLHControl($A1); // x auto increment
  WriteLHControl($B2); // Power on
  WriteLHControl($DE); // Electronic Volume = off ( nicht verfgbar hier)
  WriteLHControl($E0); //
  WriteLHControl($F1); // RE = 1
  WriteLHControl($E0); // 1/64 Duty
  WriteLHControl($F0); // RE = 0
  // noch die Einstellungen aus dem Hauptfenster bernehmen
  CheckBox1click(self);
  CheckBox2click(self);
  // Bild bertragen
  WriteLHBitmap;
end;

procedure TForm1.FormCreate(Sender: TObject);
var myini: TIniFile;
begin
// Konfiguration (Printerport)
  myini:=TInifile.create(IncludeTrailingBackslash(ExtractFilePath(Application.exename))+'DISPTEST.INI');
  printerport:=myini.readinteger('LH155','LPTADDRESS',$378);
  myini.free;
  bmp:=TBitmap.create;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var myini: TIniFile;
begin
  // Konfiguration (Printerport)
  myini:=TInifile.create(IncludeTrailingBackslash(ExtractFilePath(Application.exename))+'DISPTEST.INI');
  myini.writeinteger('LH155','LPTADDRESS',printerport);
  myini.free;
  // Display reset
  LPTWriteCtrl(cWRB+cCSB); // RESET aktiv
end;

procedure TForm1.Konfiguration1Click(Sender: TObject);
begin
  case printerport of
    $378: form2.combobox1.itemindex:=0;
    $278: form2.combobox1.itemindex:=1;
    else form2.combobox1.itemindex:=2;
  end;
  form2.edit1.text:='$'+IntToHex(printerport,4);
  if form2.combobox1.itemindex<2 then begin
    form2.edit1.enabled:=FALSE;
    form2.edit1.color:=clBtnFace;
  end else begin
    form2.edit1.enabled:=true;
    form2.edit1.color:=clWhite;
  end;
  if form2.showmodal<>idOK then exit;
  case form2.combobox1.itemindex of
    0: printerport:=$378;
    1: printerport:=$278;
    else printerport:=StrToInt(form2.edit1.text);
  end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
var v: byte;
begin
  WriteLHControl($F0); // R=0
  v:=$80;
  if CheckBox1.checked then v:=v or 1;
  if CheckBox3.checked then v:=v or 2;
  WriteLHControl(v);
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  if CheckBox2.checked then
    WriteLHControl($92+8)
  else
    WriteLHControl($92);
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
  CheckBox1Click(sender);
end;

procedure TForm1.Beenden1Click(Sender: TObject);
begin
  close;
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
begin
  close;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  Image1.Canvas.pixels[SpinEdit1.value,SpinEdit2.value]:=clBlack;
  WriteLHBitmap;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  Image1.Canvas.pixels[SpinEdit1.value,SpinEdit2.value]:=clWhite;
  WriteLHBitmap;
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
  InitLH;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
  image1.Picture.Bitmap.width:=cWidth;
  image1.Picture.Bitmap.height:=cHeight;
  with image1.Picture.Bitmap.canvas do begin
    pen.color:=clWhite;
    brush.color:=clWhite;
    rectangle(0,0,image1.Picture.Bitmap.width,image1.Picture.Bitmap.height);
  end;
  WriteLHBitmap;
end;

procedure TForm1.FormShow(Sender: TObject);
var fn: string;
    fntfile: file of byte;
begin
  image1.Picture.Bitmap.width:=cWidth;
  image1.Picture.Bitmap.height:=cHeight;
  InitLH;
  // Schrift laden
  fn:=IncludeTrailingBackslash(ExtractFilePath(Application.exename))+'DISPTEST.FON';
  if not fileexists(fn) then begin
    ShowMessage('Die bentigte Schriftartdatei '+fn+' mit dem 5x7-Display-Font wurde nicht gefunden!');
    exit;
  end;
  FileMOde:=0;
  AssignFile(fntfile,fn);
  Reset(fntfile);
  BlockRead(fntfile,DispFont,sizeof(DispFont));
  CloseFile(fntfile);
  // Pollin Logo laden
  bmp.Loadfromfile(IncludeTrailingBackslash(ExtractFilePath(Application.exename))+'LOGOSW.BMP');
  (* Image lschen *)
  image1.Picture.Bitmap.width:=cWidth;
  image1.Picture.Bitmap.height:=cHeight;
  with image1.Picture.Bitmap.canvas do begin
    pen.color:=clWhite;
    brush.color:=clWhite;
    rectangle(0,0,image1.Picture.Bitmap.width,image1.Picture.Bitmap.height);
  end;
  image1.Picture.Bitmap.canvas.Draw(0,0,bmp);
  WriteLHBitmap;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var r: Trect;
    z1,z2: single;
begin
  if not OpenDialog1.execute then exit;
  bmp.Loadfromfile(opendialog1.filename);
  z1:=image1.height/bmp.height;
  z2:=image1.width/bmp.width;
  (* Image lschen *)
  image1.Picture.Bitmap.width:=cWidth;
  image1.Picture.Bitmap.height:=cHeight;
  with image1.Picture.Bitmap.canvas do begin
    pen.color:=clWhite;
    brush.color:=clWhite;
    rectangle(0,0,image1.Picture.Bitmap.width,image1.Picture.Bitmap.height);
  end;
  if z1>z2 then begin
    (* Geladenes bild begrenzt durch breite *)
    with r do begin
      left:=0;
      top:=0;
      right:=image1.Picture.Bitmap.width;
      bottom:=round(bmp.height*z2);
    end;
  end else begin
    with r do begin
      left:=0;
      top:=0;
      right:=round(bmp.width*z1);
      bottom:=image1.Picture.Bitmap.height;
    end;
  end;
  image1.Picture.Bitmap.canvas.StretchDraw(r,bmp);
  WriteLHBitmap;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  bmp.free;
end;

procedure TForm1.WriteChar;
// Ein Zeichen in das Bitmap am Bildschirm schreiben, nicht ans Display senden
var xz,yz: integer;
    i: byte;
begin
  if (c<#32) or (c>#127) then c:='?';
  i:=ord(c);
  for yz:=0 to 7 do begin
    if yz<7 then
      for xz:=0 to 5 do begin
        if (DispFont[i][yz] AND (16 SHR xz))<>0 then
          Image1.Canvas.pixels[x+xz,y+yz]:=clBlack
        else
          Image1.Canvas.pixels[x+xz,y+yz]:=clWhite;
      end
    else
      for xz:=0 to 5 do
        Image1.Canvas.pixels[x+xz,y+yz]:=clWhite;
  end;
end;

procedure TForm1.BitBtn7Click(Sender: TObject);
var col,row: byte;
    s: string;
begin
  for row:=0 to 7 do begin
    if Memo1.lines.count>row then s:=Memo1.lines[row] else s:='';
    while length(s)<40 do s:=s+' ';
    for col:=0 to 39 do
      WriteChar(col*6,row*8,s[col+1]);
  end;
  WriteLHBitmap;
end;

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  case Button of
    mbLeft: BEGIN
              Image1.canvas.pixels[x,y]:=clBlack;
              LastMouseX:=x;
              LastMouseY:=y;
            END;
    mbRight:BEGIN
              Image1.canvas.pixels[x,y]:=clWhite;
              LastMouseX:=x;
              LastMouseY:=y;
            END;
  end;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if ssLeft in Shift then begin
    // Linker Masuknopf gedrckt
    Image1.canvas.pen.color:=clBlack;
    Image1.canvas.MoveTo(LastMouseX,LastMouseY);
    Image1.canvas.LineTo(x,y);
    Image1.canvas.pixels[x,y]:=clBlack;
    LastMouseX:=x;
    LastMouseY:=y;
  end else if ssRight in Shift then begin
    // Linker Masuknopf gedrckt
    Image1.canvas.pen.color:=clWhite;
    Image1.canvas.MoveTo(LastMouseX,LastMouseY);
    Image1.canvas.LineTo(x,y);
    Image1.canvas.pixels[x,y]:=clWhite;
    Image1.canvas.pen.color:=clWhite;
    LastMouseX:=x;
    LastMouseY:=y;
  end;

end;

procedure TForm1.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  WriteLHBitmap;
end;

end.
