// This file is generated using the spec version 0.11, firmware template version 1.39and DVR_Parser_0.46
#ifndef _DC_REG_H_INCLUDED_
#define _DC_REG_H_INCLUDED_

//#define  _DC_USE_STRUCT
#ifdef _DC_USE_STRUCT

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    pict_set_num:6;
    unsigned int    pict_width_scale:5;
    unsigned int    pict_init_page:13;
}dc_PICT_SET;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    pict_set_offset_y:10;
    unsigned int    pict_set_num:6;
    unsigned int    pict_set_offset_x:10;
}dc_PICT_SET_OFFSET;

typedef struct
{
    unsigned int    reserved_0:13;
    unsigned int    pict_offset_en:1;
    unsigned int    page_size:2;
    unsigned int    pre_arb_rd_cnt:8;
    unsigned int    pre_arb_wr_cnt:8;
}dc_SYS_MISC;

typedef struct
{
    unsigned int    reserved_0:7;
    unsigned int    sb1_pri:5;
    unsigned int    aio_pri:5;
    unsigned int    vi_pri:5;
    unsigned int    tvd_pri:5;
    unsigned int    vo_pri:5;
}dc_HI_PRIORITY_CTRL_0;

typedef struct
{
    unsigned int    vde_pri:8;
    unsigned int    ade_pri:8;
    unsigned int    aee_pri:8;
    unsigned int    sb2_pri:8;
}dc_LO_PRIORITY_CTRL_0;

typedef struct
{
    unsigned int    meblk_pri:8;
    unsigned int    veblk_pri:8;
    unsigned int    meseq_pri:8;
    unsigned int    veseq_pri:8;
}dc_LO_PRIORITY_CTRL_1;

typedef struct
{
    unsigned int    reserved_0:20;
    unsigned int    req_pending:1;
    unsigned int    req_id:11;
}dc_REQ_STATUS_CHK;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    pc_go:1;
    unsigned int    pc_set0_sel:4;
    unsigned int    pc_sel1_sel:4;
}dc_PC_CTRL;

typedef struct
{
    unsigned int    pc_total_cycl:32;
}dc_PC_TOTAL_CYCL;

typedef struct
{
    unsigned int    pc_data_ack_num:32;
}dc_PC_DATA_ACK_NUM;

typedef struct
{
    unsigned int    pc_dbus_idle:32;
}dc_PC_DBUS_IDLE;

typedef struct
{
    unsigned int    pc_set0_acc_latency:32;
}dc_PC_SET0_ACC;

typedef struct
{
    unsigned int    pc_set0_max_latency:16;
    unsigned int    pc_set0_req_number:16;
}dc_PC_SET0_MAX_REQ;

typedef struct
{
    unsigned int    pc_set1_acc_latency:32;
}dc_PC_SET1_ACC;

typedef struct
{
    unsigned int    pc_set1_max_latency:16;
    unsigned int    pc_set1_req_number:16;
}dc_PC_SET1_MAX_REQ;

typedef struct
{
    unsigned int    tmrfc:5;
    unsigned int    refcycle:4;
    unsigned int    tmmrd:2;
    unsigned int    tmcl:3;
    unsigned int    tmrap:3;
    unsigned int    tmrc:4;
    unsigned int    tmrcd:2;
    unsigned int    tmrp:2;
    unsigned int    tmrrd:2;
    unsigned int    tmwr:2;
    unsigned int    tmwtr:2;
    unsigned int    ddr16:1;
}dc_TMCTRL1;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    reserved_1:1;
    unsigned int    clk_dlyn:6;
    unsigned int    fw_set:1;
    unsigned int    dly_sel:1;
    unsigned int    reserved_2:7;
    unsigned int    auto_cal:1;
    unsigned int    cal_rang:6;
    unsigned int    cal_per:8;
}dc_TMCTRL2;

typedef struct
{
    unsigned int    exmode_reg:16;
    unsigned int    mode_reg:16;
}dc_MREG;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    exe_cal:1;
    unsigned int    init:1;
    unsigned int    sren:1;
    unsigned int    srex:1;
    unsigned int    exe_emr:1;
    unsigned int    exe_mr:1;
}dc_FCTRL;

typedef struct
{
    unsigned int    reserved_0:7;
    unsigned int    cal_adr_bank:2;
    unsigned int    cal_adr_row:13;
    unsigned int    cal_adr_col:10;
}dc_CAL_ADDR;

typedef struct
{
    unsigned int    reserved_0:2;
    unsigned int    cal_res3:6;
    unsigned int    reserved_1:2;
    unsigned int    cal_res2:6;
    unsigned int    reserved_2:2;
    unsigned int    cal_res1:6;
    unsigned int    reserved_3:2;
    unsigned int    cal_res0:6;
}dc_CAL_RES;

typedef struct
{
    unsigned int    reserved_0:5;
    unsigned int    dbg_mod:3;
    unsigned int    reserved_1:5;
    unsigned int    rcd_not_eq:1;
    unsigned int    tmrcdwr:2;
    unsigned int    reserved_2:2;
    unsigned int    ap_wo_min_dly:1;
    unsigned int    add_ht:1;
    unsigned int    tmcl_rd:4;
    unsigned int    reserved_3:1;
    unsigned int    en_sel:1;
    unsigned int    dqsen_dlyn:6;
}dc_MISC;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    sk4dq_dl:2;
    unsigned int    dqs_dly_dis:1;
    unsigned int    dll_startb:1;
    unsigned int    dll_pd:1;
    unsigned int    dll_dll_pfd:2;
    unsigned int    dll_dll_cp:6;
    unsigned int    dll_dll_lf:3;
    unsigned int    dll_dl:2;
    unsigned int    dll_md:3;
    unsigned int    dll_vr:4;
    unsigned int    dq_dly_en:1;
}dc_DLL_CTRL;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    reserved_1:1;
    unsigned int    fw_dlyn3:6;
    unsigned int    reserved_2:2;
    unsigned int    fw_dlyn2:6;
    unsigned int    reserved_3:2;
    unsigned int    fw_dlyn1:6;
    unsigned int    reserved_4:2;
    unsigned int    fw_dlyn0:6;
}dc_FW_DLY;
#endif

#define DC_PICT_SET                                                   0x18008000
#define DC_PICT_SET_reg_addr                                          "0xB8008000"
#define DC_PICT_SET_reg                                               0xB8008000
#define DC_PICT_SET_inst_addr                                         "0x0000"
#define DC_PICT_SET_inst                                              0x0000
#define DC_PICT_SET_pict_set_num_shift                                (18)
#define DC_PICT_SET_pict_width_scale_shift                            (13)
#define DC_PICT_SET_pict_init_page_shift                              (0)
#define DC_PICT_SET_pict_set_num_mask                                 (0x00FC0000)
#define DC_PICT_SET_pict_width_scale_mask                             (0x0003E000)
#define DC_PICT_SET_pict_init_page_mask                               (0x00001FFF)
#define DC_PICT_SET_pict_set_num(data)                                (0x00FC0000&((data)<<18))
#define DC_PICT_SET_pict_width_scale(data)                            (0x0003E000&((data)<<13))
#define DC_PICT_SET_pict_init_page(data)                              (0x00001FFF&(data))
#define DC_PICT_SET_get_pict_set_num(data)                            ((0x00FC0000&(data))>>18)
#define DC_PICT_SET_get_pict_width_scale(data)                        ((0x0003E000&(data))>>13)
#define DC_PICT_SET_get_pict_init_page(data)                          (0x00001FFF&(data))

#define DC_PICT_SET_OFFSET                                            0x18008034
#define DC_PICT_SET_OFFSET_reg_addr                                   "0xB8008034"
#define DC_PICT_SET_OFFSET_reg                                        0xB8008034
#define DC_PICT_SET_OFFSET_inst_addr                                  "0x000D"
#define DC_PICT_SET_OFFSET_inst                                       0x000D
#define DC_PICT_SET_OFFSET_pict_set_offset_y_shift                    (16)
#define DC_PICT_SET_OFFSET_pict_set_num_shift                         (10)
#define DC_PICT_SET_OFFSET_pict_set_offset_x_shift                    (0)
#define DC_PICT_SET_OFFSET_pict_set_offset_y_mask                     (0x03FF0000)
#define DC_PICT_SET_OFFSET_pict_set_num_mask                          (0x0000FC00)
#define DC_PICT_SET_OFFSET_pict_set_offset_x_mask                     (0x000003FF)
#define DC_PICT_SET_OFFSET_pict_set_offset_y(data)                    (0x03FF0000&((data)<<16))
#define DC_PICT_SET_OFFSET_pict_set_num(data)                         (0x0000FC00&((data)<<10))
#define DC_PICT_SET_OFFSET_pict_set_offset_x(data)                    (0x000003FF&(data))
#define DC_PICT_SET_OFFSET_get_pict_set_offset_y(data)                ((0x03FF0000&(data))>>16)
#define DC_PICT_SET_OFFSET_get_pict_set_num(data)                     ((0x0000FC00&(data))>>10)
#define DC_PICT_SET_OFFSET_get_pict_set_offset_x(data)                (0x000003FF&(data))

#define DC_SYS_MISC                                                   0x18008004
#define DC_SYS_MISC_reg_addr                                          "0xB8008004"
#define DC_SYS_MISC_reg                                               0xB8008004
#define DC_SYS_MISC_inst_addr                                         "0x0001"
#define DC_SYS_MISC_inst                                              0x0001
#define DC_SYS_MISC_pict_offset_en_shift                              (18)
#define DC_SYS_MISC_page_size_shift                                   (16)
#define DC_SYS_MISC_pre_arb_rd_cnt_shift                              (8)
#define DC_SYS_MISC_pre_arb_wr_cnt_shift                              (0)
#define DC_SYS_MISC_pict_offset_en_mask                               (0x00040000)
#define DC_SYS_MISC_page_size_mask                                    (0x00030000)
#define DC_SYS_MISC_pre_arb_rd_cnt_mask                               (0x0000FF00)
#define DC_SYS_MISC_pre_arb_wr_cnt_mask                               (0x000000FF)
#define DC_SYS_MISC_pict_offset_en(data)                              (0x00040000&((data)<<18))
#define DC_SYS_MISC_page_size(data)                                   (0x00030000&((data)<<16))
#define DC_SYS_MISC_pre_arb_rd_cnt(data)                              (0x0000FF00&((data)<<8))
#define DC_SYS_MISC_pre_arb_wr_cnt(data)                              (0x000000FF&(data))
#define DC_SYS_MISC_get_pict_offset_en(data)                          ((0x00040000&(data))>>18)
#define DC_SYS_MISC_get_page_size(data)                               ((0x00030000&(data))>>16)
#define DC_SYS_MISC_get_pre_arb_rd_cnt(data)                          ((0x0000FF00&(data))>>8)
#define DC_SYS_MISC_get_pre_arb_wr_cnt(data)                          (0x000000FF&(data))

#define DC_HI_PRIORITY_CTRL_0                                         0x18008008
#define DC_HI_PRIORITY_CTRL_0_reg_addr                                "0xB8008008"
#define DC_HI_PRIORITY_CTRL_0_reg                                     0xB8008008
#define DC_HI_PRIORITY_CTRL_0_inst_addr                               "0x0002"
#define DC_HI_PRIORITY_CTRL_0_inst                                    0x0002
#define DC_HI_PRIORITY_CTRL_0_sb1_pri_shift                           (20)
#define DC_HI_PRIORITY_CTRL_0_aio_pri_shift                           (15)
#define DC_HI_PRIORITY_CTRL_0_vi_pri_shift                            (10)
#define DC_HI_PRIORITY_CTRL_0_tvd_pri_shift                           (5)
#define DC_HI_PRIORITY_CTRL_0_vo_pri_shift                            (0)
#define DC_HI_PRIORITY_CTRL_0_sb1_pri_mask                            (0x01F00000)
#define DC_HI_PRIORITY_CTRL_0_aio_pri_mask                            (0x000F8000)
#define DC_HI_PRIORITY_CTRL_0_vi_pri_mask                             (0x00007C00)
#define DC_HI_PRIORITY_CTRL_0_tvd_pri_mask                            (0x000003E0)
#define DC_HI_PRIORITY_CTRL_0_vo_pri_mask                             (0x0000001F)
#define DC_HI_PRIORITY_CTRL_0_sb1_pri(data)                           (0x01F00000&((data)<<20))
#define DC_HI_PRIORITY_CTRL_0_aio_pri(data)                           (0x000F8000&((data)<<15))
#define DC_HI_PRIORITY_CTRL_0_vi_pri(data)                            (0x00007C00&((data)<<10))
#define DC_HI_PRIORITY_CTRL_0_tvd_pri(data)                           (0x000003E0&((data)<<5))
#define DC_HI_PRIORITY_CTRL_0_vo_pri(data)                            (0x0000001F&(data))
#define DC_HI_PRIORITY_CTRL_0_get_sb1_pri(data)                       ((0x01F00000&(data))>>20)
#define DC_HI_PRIORITY_CTRL_0_get_aio_pri(data)                       ((0x000F8000&(data))>>15)
#define DC_HI_PRIORITY_CTRL_0_get_vi_pri(data)                        ((0x00007C00&(data))>>10)
#define DC_HI_PRIORITY_CTRL_0_get_tvd_pri(data)                       ((0x000003E0&(data))>>5)
#define DC_HI_PRIORITY_CTRL_0_get_vo_pri(data)                        (0x0000001F&(data))

#define DC_LO_PRIORITY_CTRL_0                                         0x1800800C
#define DC_LO_PRIORITY_CTRL_0_reg_addr                                "0xB800800C"
#define DC_LO_PRIORITY_CTRL_0_reg                                     0xB800800C
#define DC_LO_PRIORITY_CTRL_0_inst_addr                               "0x0003"
#define DC_LO_PRIORITY_CTRL_0_inst                                    0x0003
#define DC_LO_PRIORITY_CTRL_0_vde_pri_shift                           (24)
#define DC_LO_PRIORITY_CTRL_0_ade_pri_shift                           (16)
#define DC_LO_PRIORITY_CTRL_0_aee_pri_shift                           (8)
#define DC_LO_PRIORITY_CTRL_0_sb2_pri_shift                           (0)
#define DC_LO_PRIORITY_CTRL_0_vde_pri_mask                            (0xFF000000)
#define DC_LO_PRIORITY_CTRL_0_ade_pri_mask                            (0x00FF0000)
#define DC_LO_PRIORITY_CTRL_0_aee_pri_mask                            (0x0000FF00)
#define DC_LO_PRIORITY_CTRL_0_sb2_pri_mask                            (0x000000FF)
#define DC_LO_PRIORITY_CTRL_0_vde_pri(data)                           (0xFF000000&((data)<<24))
#define DC_LO_PRIORITY_CTRL_0_ade_pri(data)                           (0x00FF0000&((data)<<16))
#define DC_LO_PRIORITY_CTRL_0_aee_pri(data)                           (0x0000FF00&((data)<<8))
#define DC_LO_PRIORITY_CTRL_0_sb2_pri(data)                           (0x000000FF&(data))
#define DC_LO_PRIORITY_CTRL_0_get_vde_pri(data)                       ((0xFF000000&(data))>>24)
#define DC_LO_PRIORITY_CTRL_0_get_ade_pri(data)                       ((0x00FF0000&(data))>>16)
#define DC_LO_PRIORITY_CTRL_0_get_aee_pri(data)                       ((0x0000FF00&(data))>>8)
#define DC_LO_PRIORITY_CTRL_0_get_sb2_pri(data)                       (0x000000FF&(data))

#define DC_LO_PRIORITY_CTRL_1                                         0x18008010
#define DC_LO_PRIORITY_CTRL_1_reg_addr                                "0xB8008010"
#define DC_LO_PRIORITY_CTRL_1_reg                                     0xB8008010
#define DC_LO_PRIORITY_CTRL_1_inst_addr                               "0x0004"
#define DC_LO_PRIORITY_CTRL_1_inst                                    0x0004
#define DC_LO_PRIORITY_CTRL_1_meblk_pri_shift                         (24)
#define DC_LO_PRIORITY_CTRL_1_veblk_pri_shift                         (16)
#define DC_LO_PRIORITY_CTRL_1_meseq_pri_shift                         (8)
#define DC_LO_PRIORITY_CTRL_1_veseq_pri_shift                         (0)
#define DC_LO_PRIORITY_CTRL_1_meblk_pri_mask                          (0xFF000000)
#define DC_LO_PRIORITY_CTRL_1_veblk_pri_mask                          (0x00FF0000)
#define DC_LO_PRIORITY_CTRL_1_meseq_pri_mask                          (0x0000FF00)
#define DC_LO_PRIORITY_CTRL_1_veseq_pri_mask                          (0x000000FF)
#define DC_LO_PRIORITY_CTRL_1_meblk_pri(data)                         (0xFF000000&((data)<<24))
#define DC_LO_PRIORITY_CTRL_1_veblk_pri(data)                         (0x00FF0000&((data)<<16))
#define DC_LO_PRIORITY_CTRL_1_meseq_pri(data)                         (0x0000FF00&((data)<<8))
#define DC_LO_PRIORITY_CTRL_1_veseq_pri(data)                         (0x000000FF&(data))
#define DC_LO_PRIORITY_CTRL_1_get_meblk_pri(data)                     ((0xFF000000&(data))>>24)
#define DC_LO_PRIORITY_CTRL_1_get_veblk_pri(data)                     ((0x00FF0000&(data))>>16)
#define DC_LO_PRIORITY_CTRL_1_get_meseq_pri(data)                     ((0x0000FF00&(data))>>8)
#define DC_LO_PRIORITY_CTRL_1_get_veseq_pri(data)                     (0x000000FF&(data))

#define DC_REQ_STATUS_CHK                                             0x18008038
#define DC_REQ_STATUS_CHK_reg_addr                                    "0xB8008038"
#define DC_REQ_STATUS_CHK_reg                                         0xB8008038
#define DC_REQ_STATUS_CHK_inst_addr                                   "0x000E"
#define DC_REQ_STATUS_CHK_inst                                        0x000E
#define DC_REQ_STATUS_CHK_req_pending_shift                           (11)
#define DC_REQ_STATUS_CHK_req_id_shift                                (0)
#define DC_REQ_STATUS_CHK_req_pending_mask                            (0x00000800)
#define DC_REQ_STATUS_CHK_req_id_mask                                 (0x000007FF)
#define DC_REQ_STATUS_CHK_req_pending(data)                           (0x00000800&((data)<<11))
#define DC_REQ_STATUS_CHK_req_id(data)                                (0x000007FF&(data))
#define DC_REQ_STATUS_CHK_get_req_pending(data)                       ((0x00000800&(data))>>11)
#define DC_REQ_STATUS_CHK_get_req_id(data)                            (0x000007FF&(data))

#define DC_PC_CTRL                                                    0x18008014
#define DC_PC_CTRL_reg_addr                                           "0xB8008014"
#define DC_PC_CTRL_reg                                                0xB8008014
#define DC_PC_CTRL_inst_addr                                          "0x0005"
#define DC_PC_CTRL_inst                                               0x0005
#define DC_PC_CTRL_pc_go_shift                                        (8)
#define DC_PC_CTRL_pc_set0_sel_shift                                  (4)
#define DC_PC_CTRL_pc_sel1_sel_shift                                  (0)
#define DC_PC_CTRL_pc_go_mask                                         (0x00000100)
#define DC_PC_CTRL_pc_set0_sel_mask                                   (0x000000F0)
#define DC_PC_CTRL_pc_sel1_sel_mask                                   (0x0000000F)
#define DC_PC_CTRL_pc_go(data)                                        (0x00000100&((data)<<8))
#define DC_PC_CTRL_pc_set0_sel(data)                                  (0x000000F0&((data)<<4))
#define DC_PC_CTRL_pc_sel1_sel(data)                                  (0x0000000F&(data))
#define DC_PC_CTRL_get_pc_go(data)                                    ((0x00000100&(data))>>8)
#define DC_PC_CTRL_get_pc_set0_sel(data)                              ((0x000000F0&(data))>>4)
#define DC_PC_CTRL_get_pc_sel1_sel(data)                              (0x0000000F&(data))

#define DC_PC_TOTAL_CYCL                                              0x18008018
#define DC_PC_TOTAL_CYCL_reg_addr                                     "0xB8008018"
#define DC_PC_TOTAL_CYCL_reg                                          0xB8008018
#define DC_PC_TOTAL_CYCL_inst_addr                                    "0x0006"
#define DC_PC_TOTAL_CYCL_inst                                         0x0006
#define DC_PC_TOTAL_CYCL_pc_total_cycl_shift                          (0)
#define DC_PC_TOTAL_CYCL_pc_total_cycl_mask                           (0xFFFFFFFF)
#define DC_PC_TOTAL_CYCL_pc_total_cycl(data)                          (0xFFFFFFFF&(data))
#define DC_PC_TOTAL_CYCL_get_pc_total_cycl(data)                      (0xFFFFFFFF&(data))

#define DC_PC_DATA_ACK_NUM                                            0x1800801C
#define DC_PC_DATA_ACK_NUM_reg_addr                                   "0xB800801C"
#define DC_PC_DATA_ACK_NUM_reg                                        0xB800801C
#define DC_PC_DATA_ACK_NUM_inst_addr                                  "0x0007"
#define DC_PC_DATA_ACK_NUM_inst                                       0x0007
#define DC_PC_DATA_ACK_NUM_pc_data_ack_num_shift                      (0)
#define DC_PC_DATA_ACK_NUM_pc_data_ack_num_mask                       (0xFFFFFFFF)
#define DC_PC_DATA_ACK_NUM_pc_data_ack_num(data)                      (0xFFFFFFFF&(data))
#define DC_PC_DATA_ACK_NUM_get_pc_data_ack_num(data)                  (0xFFFFFFFF&(data))

#define DC_PC_DBUS_IDLE                                               0x18008020
#define DC_PC_DBUS_IDLE_reg_addr                                      "0xB8008020"
#define DC_PC_DBUS_IDLE_reg                                           0xB8008020
#define DC_PC_DBUS_IDLE_inst_addr                                     "0x0008"
#define DC_PC_DBUS_IDLE_inst                                          0x0008
#define DC_PC_DBUS_IDLE_pc_dbus_idle_shift                            (0)
#define DC_PC_DBUS_IDLE_pc_dbus_idle_mask                             (0xFFFFFFFF)
#define DC_PC_DBUS_IDLE_pc_dbus_idle(data)                            (0xFFFFFFFF&(data))
#define DC_PC_DBUS_IDLE_get_pc_dbus_idle(data)                        (0xFFFFFFFF&(data))

#define DC_PC_SET0_ACC                                                0x18008024
#define DC_PC_SET0_ACC_reg_addr                                       "0xB8008024"
#define DC_PC_SET0_ACC_reg                                            0xB8008024
#define DC_PC_SET0_ACC_inst_addr                                      "0x0009"
#define DC_PC_SET0_ACC_inst                                           0x0009
#define DC_PC_SET0_ACC_pc_set0_acc_latency_shift                      (0)
#define DC_PC_SET0_ACC_pc_set0_acc_latency_mask                       (0xFFFFFFFF)
#define DC_PC_SET0_ACC_pc_set0_acc_latency(data)                      (0xFFFFFFFF&(data))
#define DC_PC_SET0_ACC_get_pc_set0_acc_latency(data)                  (0xFFFFFFFF&(data))

#define DC_PC_SET0_MAX_REQ                                            0x18008028
#define DC_PC_SET0_MAX_REQ_reg_addr                                   "0xB8008028"
#define DC_PC_SET0_MAX_REQ_reg                                        0xB8008028
#define DC_PC_SET0_MAX_REQ_inst_addr                                  "0x000A"
#define DC_PC_SET0_MAX_REQ_inst                                       0x000A
#define DC_PC_SET0_MAX_REQ_pc_set0_max_latency_shift                  (16)
#define DC_PC_SET0_MAX_REQ_pc_set0_req_number_shift                   (0)
#define DC_PC_SET0_MAX_REQ_pc_set0_max_latency_mask                   (0xFFFF0000)
#define DC_PC_SET0_MAX_REQ_pc_set0_req_number_mask                    (0x0000FFFF)
#define DC_PC_SET0_MAX_REQ_pc_set0_max_latency(data)                  (0xFFFF0000&((data)<<16))
#define DC_PC_SET0_MAX_REQ_pc_set0_req_number(data)                   (0x0000FFFF&(data))
#define DC_PC_SET0_MAX_REQ_get_pc_set0_max_latency(data)              ((0xFFFF0000&(data))>>16)
#define DC_PC_SET0_MAX_REQ_get_pc_set0_req_number(data)               (0x0000FFFF&(data))

#define DC_PC_SET1_ACC                                                0x1800802C
#define DC_PC_SET1_ACC_reg_addr                                       "0xB800802C"
#define DC_PC_SET1_ACC_reg                                            0xB800802C
#define DC_PC_SET1_ACC_inst_addr                                      "0x000B"
#define DC_PC_SET1_ACC_inst                                           0x000B
#define DC_PC_SET1_ACC_pc_set1_acc_latency_shift                      (0)
#define DC_PC_SET1_ACC_pc_set1_acc_latency_mask                       (0xFFFFFFFF)
#define DC_PC_SET1_ACC_pc_set1_acc_latency(data)                      (0xFFFFFFFF&(data))
#define DC_PC_SET1_ACC_get_pc_set1_acc_latency(data)                  (0xFFFFFFFF&(data))

#define DC_PC_SET1_MAX_REQ                                            0x18008030
#define DC_PC_SET1_MAX_REQ_reg_addr                                   "0xB8008030"
#define DC_PC_SET1_MAX_REQ_reg                                        0xB8008030
#define DC_PC_SET1_MAX_REQ_inst_addr                                  "0x000C"
#define DC_PC_SET1_MAX_REQ_inst                                       0x000C
#define DC_PC_SET1_MAX_REQ_pc_set1_max_latency_shift                  (16)
#define DC_PC_SET1_MAX_REQ_pc_set1_req_number_shift                   (0)
#define DC_PC_SET1_MAX_REQ_pc_set1_max_latency_mask                   (0xFFFF0000)
#define DC_PC_SET1_MAX_REQ_pc_set1_req_number_mask                    (0x0000FFFF)
#define DC_PC_SET1_MAX_REQ_pc_set1_max_latency(data)                  (0xFFFF0000&((data)<<16))
#define DC_PC_SET1_MAX_REQ_pc_set1_req_number(data)                   (0x0000FFFF&(data))
#define DC_PC_SET1_MAX_REQ_get_pc_set1_max_latency(data)              ((0xFFFF0000&(data))>>16)
#define DC_PC_SET1_MAX_REQ_get_pc_set1_req_number(data)               (0x0000FFFF&(data))

#define DC_TMCTRL1                                                    0x18008800
#define DC_TMCTRL1_reg_addr                                           "0xB8008800"
#define DC_TMCTRL1_reg                                                0xB8008800
#define DC_TMCTRL1_inst_addr                                          "0x0200"
#define DC_TMCTRL1_inst                                               0x0200
#define DC_TMCTRL1_tmrfc_shift                                        (27)
#define DC_TMCTRL1_refcycle_shift                                     (23)
#define DC_TMCTRL1_tmmrd_shift                                        (21)
#define DC_TMCTRL1_tmcl_shift                                         (18)
#define DC_TMCTRL1_tmrap_shift                                        (15)
#define DC_TMCTRL1_tmrc_shift                                         (11)
#define DC_TMCTRL1_tmrcd_shift                                        (9)
#define DC_TMCTRL1_tmrp_shift                                         (7)
#define DC_TMCTRL1_tmrrd_shift                                        (5)
#define DC_TMCTRL1_tmwr_shift                                         (3)
#define DC_TMCTRL1_tmwtr_shift                                        (1)
#define DC_TMCTRL1_ddr16_shift                                        (0)
#define DC_TMCTRL1_tmrfc_mask                                         (0xF8000000)
#define DC_TMCTRL1_refcycle_mask                                      (0x07800000)
#define DC_TMCTRL1_tmmrd_mask                                         (0x00600000)
#define DC_TMCTRL1_tmcl_mask                                          (0x001C0000)
#define DC_TMCTRL1_tmrap_mask                                         (0x00038000)
#define DC_TMCTRL1_tmrc_mask                                          (0x00007800)
#define DC_TMCTRL1_tmrcd_mask                                         (0x00000600)
#define DC_TMCTRL1_tmrp_mask                                          (0x00000180)
#define DC_TMCTRL1_tmrrd_mask                                         (0x00000060)
#define DC_TMCTRL1_tmwr_mask                                          (0x00000018)
#define DC_TMCTRL1_tmwtr_mask                                         (0x00000006)
#define DC_TMCTRL1_ddr16_mask                                         (0x00000001)
#define DC_TMCTRL1_tmrfc(data)                                        (0xF8000000&((data)<<27))
#define DC_TMCTRL1_refcycle(data)                                     (0x07800000&((data)<<23))
#define DC_TMCTRL1_tmmrd(data)                                        (0x00600000&((data)<<21))
#define DC_TMCTRL1_tmcl(data)                                         (0x001C0000&((data)<<18))
#define DC_TMCTRL1_tmrap(data)                                        (0x00038000&((data)<<15))
#define DC_TMCTRL1_tmrc(data)                                         (0x00007800&((data)<<11))
#define DC_TMCTRL1_tmrcd(data)                                        (0x00000600&((data)<<9))
#define DC_TMCTRL1_tmrp(data)                                         (0x00000180&((data)<<7))
#define DC_TMCTRL1_tmrrd(data)                                        (0x00000060&((data)<<5))
#define DC_TMCTRL1_tmwr(data)                                         (0x00000018&((data)<<3))
#define DC_TMCTRL1_tmwtr(data)                                        (0x00000006&((data)<<1))
#define DC_TMCTRL1_ddr16(data)                                        (0x00000001&(data))
#define DC_TMCTRL1_get_tmrfc(data)                                    ((0xF8000000&(data))>>27)
#define DC_TMCTRL1_get_refcycle(data)                                 ((0x07800000&(data))>>23)
#define DC_TMCTRL1_get_tmmrd(data)                                    ((0x00600000&(data))>>21)
#define DC_TMCTRL1_get_tmcl(data)                                     ((0x001C0000&(data))>>18)
#define DC_TMCTRL1_get_tmrap(data)                                    ((0x00038000&(data))>>15)
#define DC_TMCTRL1_get_tmrc(data)                                     ((0x00007800&(data))>>11)
#define DC_TMCTRL1_get_tmrcd(data)                                    ((0x00000600&(data))>>9)
#define DC_TMCTRL1_get_tmrp(data)                                     ((0x00000180&(data))>>7)
#define DC_TMCTRL1_get_tmrrd(data)                                    ((0x00000060&(data))>>5)
#define DC_TMCTRL1_get_tmwr(data)                                     ((0x00000018&(data))>>3)
#define DC_TMCTRL1_get_tmwtr(data)                                    ((0x00000006&(data))>>1)
#define DC_TMCTRL1_get_ddr16(data)                                    (0x00000001&(data))

#define DC_TMCTRL2                                                    0x18008804
#define DC_TMCTRL2_reg_addr                                           "0xB8008804"
#define DC_TMCTRL2_reg                                                0xB8008804
#define DC_TMCTRL2_inst_addr                                          "0x0201"
#define DC_TMCTRL2_inst                                               0x0201
#define DC_TMCTRL2_clk_dlyn_shift                                     (24)
#define DC_TMCTRL2_fw_set_shift                                       (23)
#define DC_TMCTRL2_dly_sel_shift                                      (22)
#define DC_TMCTRL2_auto_cal_shift                                     (14)
#define DC_TMCTRL2_cal_rang_shift                                     (8)
#define DC_TMCTRL2_cal_per_shift                                      (0)
#define DC_TMCTRL2_clk_dlyn_mask                                      (0x3F000000)
#define DC_TMCTRL2_fw_set_mask                                        (0x00800000)
#define DC_TMCTRL2_dly_sel_mask                                       (0x00400000)
#define DC_TMCTRL2_auto_cal_mask                                      (0x00004000)
#define DC_TMCTRL2_cal_rang_mask                                      (0x00003F00)
#define DC_TMCTRL2_cal_per_mask                                       (0x000000FF)
#define DC_TMCTRL2_clk_dlyn(data)                                     (0x3F000000&((data)<<24))
#define DC_TMCTRL2_fw_set(data)                                       (0x00800000&((data)<<23))
#define DC_TMCTRL2_dly_sel(data)                                      (0x00400000&((data)<<22))
#define DC_TMCTRL2_auto_cal(data)                                     (0x00004000&((data)<<14))
#define DC_TMCTRL2_cal_rang(data)                                     (0x00003F00&((data)<<8))
#define DC_TMCTRL2_cal_per(data)                                      (0x000000FF&(data))
#define DC_TMCTRL2_get_clk_dlyn(data)                                 ((0x3F000000&(data))>>24)
#define DC_TMCTRL2_get_fw_set(data)                                   ((0x00800000&(data))>>23)
#define DC_TMCTRL2_get_dly_sel(data)                                  ((0x00400000&(data))>>22)
#define DC_TMCTRL2_get_auto_cal(data)                                 ((0x00004000&(data))>>14)
#define DC_TMCTRL2_get_cal_rang(data)                                 ((0x00003F00&(data))>>8)
#define DC_TMCTRL2_get_cal_per(data)                                  (0x000000FF&(data))

#define DC_MREG                                                       0x18008808
#define DC_MREG_reg_addr                                              "0xB8008808"
#define DC_MREG_reg                                                   0xB8008808
#define DC_MREG_inst_addr                                             "0x0202"
#define DC_MREG_inst                                                  0x0202
#define DC_MREG_exmode_reg_shift                                      (16)
#define DC_MREG_mode_reg_shift                                        (0)
#define DC_MREG_exmode_reg_mask                                       (0xFFFF0000)
#define DC_MREG_mode_reg_mask                                         (0x0000FFFF)
#define DC_MREG_exmode_reg(data)                                      (0xFFFF0000&((data)<<16))
#define DC_MREG_mode_reg(data)                                        (0x0000FFFF&(data))
#define DC_MREG_get_exmode_reg(data)                                  ((0xFFFF0000&(data))>>16)
#define DC_MREG_get_mode_reg(data)                                    (0x0000FFFF&(data))

#define DC_FCTRL                                                      0x1800880C
#define DC_FCTRL_reg_addr                                             "0xB800880C"
#define DC_FCTRL_reg                                                  0xB800880C
#define DC_FCTRL_inst_addr                                            "0x0203"
#define DC_FCTRL_inst                                                 0x0203
#define DC_FCTRL_exe_cal_shift                                        (5)
#define DC_FCTRL_init_shift                                           (4)
#define DC_FCTRL_sren_shift                                           (3)
#define DC_FCTRL_srex_shift                                           (2)
#define DC_FCTRL_exe_emr_shift                                        (1)
#define DC_FCTRL_exe_mr_shift                                         (0)
#define DC_FCTRL_exe_cal_mask                                         (0x00000020)
#define DC_FCTRL_init_mask                                            (0x00000010)
#define DC_FCTRL_sren_mask                                            (0x00000008)
#define DC_FCTRL_srex_mask                                            (0x00000004)
#define DC_FCTRL_exe_emr_mask                                         (0x00000002)
#define DC_FCTRL_exe_mr_mask                                          (0x00000001)
#define DC_FCTRL_exe_cal(data)                                        (0x00000020&((data)<<5))
#define DC_FCTRL_init(data)                                           (0x00000010&((data)<<4))
#define DC_FCTRL_sren(data)                                           (0x00000008&((data)<<3))
#define DC_FCTRL_srex(data)                                           (0x00000004&((data)<<2))
#define DC_FCTRL_exe_emr(data)                                        (0x00000002&((data)<<1))
#define DC_FCTRL_exe_mr(data)                                         (0x00000001&(data))
#define DC_FCTRL_get_exe_cal(data)                                    ((0x00000020&(data))>>5)
#define DC_FCTRL_get_init(data)                                       ((0x00000010&(data))>>4)
#define DC_FCTRL_get_sren(data)                                       ((0x00000008&(data))>>3)
#define DC_FCTRL_get_srex(data)                                       ((0x00000004&(data))>>2)
#define DC_FCTRL_get_exe_emr(data)                                    ((0x00000002&(data))>>1)
#define DC_FCTRL_get_exe_mr(data)                                     (0x00000001&(data))

#define DC_CAL_ADDR                                                   0x18008810
#define DC_CAL_ADDR_reg_addr                                          "0xB8008810"
#define DC_CAL_ADDR_reg                                               0xB8008810
#define DC_CAL_ADDR_inst_addr                                         "0x0204"
#define DC_CAL_ADDR_inst                                              0x0204
#define DC_CAL_ADDR_cal_adr_bank_shift                                (23)
#define DC_CAL_ADDR_cal_adr_row_shift                                 (10)
#define DC_CAL_ADDR_cal_adr_col_shift                                 (0)
#define DC_CAL_ADDR_cal_adr_bank_mask                                 (0x01800000)
#define DC_CAL_ADDR_cal_adr_row_mask                                  (0x007FFC00)
#define DC_CAL_ADDR_cal_adr_col_mask                                  (0x000003FF)
#define DC_CAL_ADDR_cal_adr_bank(data)                                (0x01800000&((data)<<23))
#define DC_CAL_ADDR_cal_adr_row(data)                                 (0x007FFC00&((data)<<10))
#define DC_CAL_ADDR_cal_adr_col(data)                                 (0x000003FF&(data))
#define DC_CAL_ADDR_get_cal_adr_bank(data)                            ((0x01800000&(data))>>23)
#define DC_CAL_ADDR_get_cal_adr_row(data)                             ((0x007FFC00&(data))>>10)
#define DC_CAL_ADDR_get_cal_adr_col(data)                             (0x000003FF&(data))

#define DC_CAL_RES                                                    0x18008814
#define DC_CAL_RES_reg_addr                                           "0xB8008814"
#define DC_CAL_RES_reg                                                0xB8008814
#define DC_CAL_RES_inst_addr                                          "0x0205"
#define DC_CAL_RES_inst                                               0x0205
#define DC_CAL_RES_cal_res3_shift                                     (24)
#define DC_CAL_RES_cal_res2_shift                                     (16)
#define DC_CAL_RES_cal_res1_shift                                     (8)
#define DC_CAL_RES_cal_res0_shift                                     (0)
#define DC_CAL_RES_cal_res3_mask                                      (0x3F000000)
#define DC_CAL_RES_cal_res2_mask                                      (0x003F0000)
#define DC_CAL_RES_cal_res1_mask                                      (0x00003F00)
#define DC_CAL_RES_cal_res0_mask                                      (0x0000003F)
#define DC_CAL_RES_cal_res3(data)                                     (0x3F000000&((data)<<24))
#define DC_CAL_RES_cal_res2(data)                                     (0x003F0000&((data)<<16))
#define DC_CAL_RES_cal_res1(data)                                     (0x00003F00&((data)<<8))
#define DC_CAL_RES_cal_res0(data)                                     (0x0000003F&(data))
#define DC_CAL_RES_get_cal_res3(data)                                 ((0x3F000000&(data))>>24)
#define DC_CAL_RES_get_cal_res2(data)                                 ((0x003F0000&(data))>>16)
#define DC_CAL_RES_get_cal_res1(data)                                 ((0x00003F00&(data))>>8)
#define DC_CAL_RES_get_cal_res0(data)                                 (0x0000003F&(data))

#define DC_MISC                                                       0x18008818
#define DC_MISC_reg_addr                                              "0xB8008818"
#define DC_MISC_reg                                                   0xB8008818
#define DC_MISC_inst_addr                                             "0x0206"
#define DC_MISC_inst                                                  0x0206
#define DC_MISC_dbg_mod_shift                                         (24)
#define DC_MISC_rcd_not_eq_shift                                      (18)
#define DC_MISC_tmrcdwr_shift                                         (16)
#define DC_MISC_ap_wo_min_dly_shift                                   (13)
#define DC_MISC_add_ht_shift                                          (12)
#define DC_MISC_tmcl_rd_shift                                         (8)
#define DC_MISC_en_sel_shift                                          (6)
#define DC_MISC_dqsen_dlyn_shift                                      (0)
#define DC_MISC_dbg_mod_mask                                          (0x07000000)
#define DC_MISC_rcd_not_eq_mask                                       (0x00040000)
#define DC_MISC_tmrcdwr_mask                                          (0x00030000)
#define DC_MISC_ap_wo_min_dly_mask                                    (0x00002000)
#define DC_MISC_add_ht_mask                                           (0x00001000)
#define DC_MISC_tmcl_rd_mask                                          (0x00000F00)
#define DC_MISC_en_sel_mask                                           (0x00000040)
#define DC_MISC_dqsen_dlyn_mask                                       (0x0000003F)
#define DC_MISC_dbg_mod(data)                                         (0x07000000&((data)<<24))
#define DC_MISC_rcd_not_eq(data)                                      (0x00040000&((data)<<18))
#define DC_MISC_tmrcdwr(data)                                         (0x00030000&((data)<<16))
#define DC_MISC_ap_wo_min_dly(data)                                   (0x00002000&((data)<<13))
#define DC_MISC_add_ht(data)                                          (0x00001000&((data)<<12))
#define DC_MISC_tmcl_rd(data)                                         (0x00000F00&((data)<<8))
#define DC_MISC_en_sel(data)                                          (0x00000040&((data)<<6))
#define DC_MISC_dqsen_dlyn(data)                                      (0x0000003F&(data))
#define DC_MISC_get_dbg_mod(data)                                     ((0x07000000&(data))>>24)
#define DC_MISC_get_rcd_not_eq(data)                                  ((0x00040000&(data))>>18)
#define DC_MISC_get_tmrcdwr(data)                                     ((0x00030000&(data))>>16)
#define DC_MISC_get_ap_wo_min_dly(data)                               ((0x00002000&(data))>>13)
#define DC_MISC_get_add_ht(data)                                      ((0x00001000&(data))>>12)
#define DC_MISC_get_tmcl_rd(data)                                     ((0x00000F00&(data))>>8)
#define DC_MISC_get_en_sel(data)                                      ((0x00000040&(data))>>6)
#define DC_MISC_get_dqsen_dlyn(data)                                  (0x0000003F&(data))

#define DC_DLL_CTRL                                                   0x1800881C
#define DC_DLL_CTRL_reg_addr                                          "0xB800881C"
#define DC_DLL_CTRL_reg                                               0xB800881C
#define DC_DLL_CTRL_inst_addr                                         "0x0207"
#define DC_DLL_CTRL_inst                                              0x0207
#define DC_DLL_CTRL_sk4dq_dl_shift                                    (24)
#define DC_DLL_CTRL_dqs_dly_dis_shift                                 (23)
#define DC_DLL_CTRL_dll_startb_shift                                  (22)
#define DC_DLL_CTRL_dll_pd_shift                                      (21)
#define DC_DLL_CTRL_dll_dll_pfd_shift                                 (19)
#define DC_DLL_CTRL_dll_dll_cp_shift                                  (13)
#define DC_DLL_CTRL_dll_dll_lf_shift                                  (10)
#define DC_DLL_CTRL_dll_dl_shift                                      (8)
#define DC_DLL_CTRL_dll_md_shift                                      (5)
#define DC_DLL_CTRL_dll_vr_shift                                      (1)
#define DC_DLL_CTRL_dq_dly_en_shift                                   (0)
#define DC_DLL_CTRL_sk4dq_dl_mask                                     (0x03000000)
#define DC_DLL_CTRL_dqs_dly_dis_mask                                  (0x00800000)
#define DC_DLL_CTRL_dll_startb_mask                                   (0x00400000)
#define DC_DLL_CTRL_dll_pd_mask                                       (0x00200000)
#define DC_DLL_CTRL_dll_dll_pfd_mask                                  (0x00180000)
#define DC_DLL_CTRL_dll_dll_cp_mask                                   (0x0007E000)
#define DC_DLL_CTRL_dll_dll_lf_mask                                   (0x00001C00)
#define DC_DLL_CTRL_dll_dl_mask                                       (0x00000300)
#define DC_DLL_CTRL_dll_md_mask                                       (0x000000E0)
#define DC_DLL_CTRL_dll_vr_mask                                       (0x0000001E)
#define DC_DLL_CTRL_dq_dly_en_mask                                    (0x00000001)
#define DC_DLL_CTRL_sk4dq_dl(data)                                    (0x03000000&((data)<<24))
#define DC_DLL_CTRL_dqs_dly_dis(data)                                 (0x00800000&((data)<<23))
#define DC_DLL_CTRL_dll_startb(data)                                  (0x00400000&((data)<<22))
#define DC_DLL_CTRL_dll_pd(data)                                      (0x00200000&((data)<<21))
#define DC_DLL_CTRL_dll_dll_pfd(data)                                 (0x00180000&((data)<<19))
#define DC_DLL_CTRL_dll_dll_cp(data)                                  (0x0007E000&((data)<<13))
#define DC_DLL_CTRL_dll_dll_lf(data)                                  (0x00001C00&((data)<<10))
#define DC_DLL_CTRL_dll_dl(data)                                      (0x00000300&((data)<<8))
#define DC_DLL_CTRL_dll_md(data)                                      (0x000000E0&((data)<<5))
#define DC_DLL_CTRL_dll_vr(data)                                      (0x0000001E&((data)<<1))
#define DC_DLL_CTRL_dq_dly_en(data)                                   (0x00000001&(data))
#define DC_DLL_CTRL_get_sk4dq_dl(data)                                ((0x03000000&(data))>>24)
#define DC_DLL_CTRL_get_dqs_dly_dis(data)                             ((0x00800000&(data))>>23)
#define DC_DLL_CTRL_get_dll_startb(data)                              ((0x00400000&(data))>>22)
#define DC_DLL_CTRL_get_dll_pd(data)                                  ((0x00200000&(data))>>21)
#define DC_DLL_CTRL_get_dll_dll_pfd(data)                             ((0x00180000&(data))>>19)
#define DC_DLL_CTRL_get_dll_dll_cp(data)                              ((0x0007E000&(data))>>13)
#define DC_DLL_CTRL_get_dll_dll_lf(data)                              ((0x00001C00&(data))>>10)
#define DC_DLL_CTRL_get_dll_dl(data)                                  ((0x00000300&(data))>>8)
#define DC_DLL_CTRL_get_dll_md(data)                                  ((0x000000E0&(data))>>5)
#define DC_DLL_CTRL_get_dll_vr(data)                                  ((0x0000001E&(data))>>1)
#define DC_DLL_CTRL_get_dq_dly_en(data)                               (0x00000001&(data))

#define DC_FW_DLY                                                     0x18008820
#define DC_FW_DLY_reg_addr                                            "0xB8008820"
#define DC_FW_DLY_reg                                                 0xB8008820
#define DC_FW_DLY_inst_addr                                           "0x0208"
#define DC_FW_DLY_inst                                                0x0208
#define DC_FW_DLY_fw_dlyn3_shift                                      (24)
#define DC_FW_DLY_fw_dlyn2_shift                                      (16)
#define DC_FW_DLY_fw_dlyn1_shift                                      (8)
#define DC_FW_DLY_fw_dlyn0_shift                                      (0)
#define DC_FW_DLY_fw_dlyn3_mask                                       (0x3F000000)
#define DC_FW_DLY_fw_dlyn2_mask                                       (0x003F0000)
#define DC_FW_DLY_fw_dlyn1_mask                                       (0x00003F00)
#define DC_FW_DLY_fw_dlyn0_mask                                       (0x0000003F)
#define DC_FW_DLY_fw_dlyn3(data)                                      (0x3F000000&((data)<<24))
#define DC_FW_DLY_fw_dlyn2(data)                                      (0x003F0000&((data)<<16))
#define DC_FW_DLY_fw_dlyn1(data)                                      (0x00003F00&((data)<<8))
#define DC_FW_DLY_fw_dlyn0(data)                                      (0x0000003F&(data))
#define DC_FW_DLY_get_fw_dlyn3(data)                                  ((0x3F000000&(data))>>24)
#define DC_FW_DLY_get_fw_dlyn2(data)                                  ((0x003F0000&(data))>>16)
#define DC_FW_DLY_get_fw_dlyn1(data)                                  ((0x00003F00&(data))>>8)
#define DC_FW_DLY_get_fw_dlyn0(data)                                  (0x0000003F&(data))
#endif
