// This file is generated using the spec version 0.3.4, firmware template version 1.39and DVR_Parser_0.46
#ifndef _ME_REG_H_INCLUDED_
#define _ME_REG_H_INCLUDED_

//#define  _ME_USE_STRUCT
#ifdef _ME_USE_STRUCT

typedef struct
{
    unsigned int    reserved_0:22;
    unsigned int    mbl:2;
    unsigned int    ints:1;
    unsigned int    inte:1;
    unsigned int    reserved_1:1;
    unsigned int    tw:1;
    unsigned int    tms:1;
    unsigned int    tbs:1;
    unsigned int    go:1;
    unsigned int    write_data:1;
}me_CTRL;

typedef struct
{
    unsigned int    reserved_0:20;
    unsigned int    rdy:1;
    unsigned int    adr:7;
    unsigned int    sel:4;
}me_WSRAM;

typedef struct
{
    unsigned int    m32b:32;
}me_MSB32;

typedef struct
{
    unsigned int    l32b:32;
}me_LSB32;

typedef struct
{
    unsigned int    reserved_0:5;
    unsigned int    addr:27;
}me_CMDADDR;

typedef struct
{
    unsigned int    reserved_0:5;
    unsigned int    addr:27;
}me_RLTADDR;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    fld:1;
    unsigned int    reserved_1:2;
    unsigned int    ti:6;
    unsigned int    reserved_2:2;
    unsigned int    bi:6;
}me_TSETA;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    y:10;
    unsigned int    xinc:4;
    unsigned int    reserved_1:2;
    unsigned int    x:10;
}me_TSETB;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    fld:1;
    unsigned int    reserved_1:2;
    unsigned int    ti:6;
    unsigned int    reserved_2:2;
    unsigned int    bi:6;
}me_RSETA;

typedef struct
{
    unsigned int    mvys:2;
    unsigned int    reserved_0:6;
    unsigned int    mvxs:2;
    unsigned int    reserved_1:6;
    unsigned int    mvx:8;
    unsigned int    mvy:8;
}me_RSETB;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    y:10;
    unsigned int    xinc:4;
    unsigned int    reserved_1:2;
    unsigned int    x:10;
}me_RSETC;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    rh:10;
    unsigned int    reserved_1:6;
    unsigned int    rw:10;
}me_RSETD;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    tsy:10;
    unsigned int    reserved_1:6;
    unsigned int    tsx:10;
}me_RSETE;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    tey:10;
    unsigned int    reserved_1:6;
    unsigned int    tex:10;
}me_RSETF;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    bsy:10;
    unsigned int    reserved_1:6;
    unsigned int    bsx:10;
}me_RSETG;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    bey:10;
    unsigned int    reserved_1:6;
    unsigned int    bex:10;
}me_RSETH;

typedef struct
{
    unsigned int    stage:1;
    unsigned int    half:2;
    unsigned int    mvce:1;
    unsigned int    reserved_0:1;
    unsigned int    mvcfp:3;
    unsigned int    mvcf:8;
    unsigned int    zmvp:1;
    unsigned int    can:3;
    unsigned int    reserved_1:1;
    unsigned int    bscale:3;
    unsigned int    zmvb:8;
}me_MSETA;

typedef struct
{
    unsigned int    mvcb:8;
    unsigned int    mvct:8;
    unsigned int    reserved_0:1;
    unsigned int    ryadj:1;
    unsigned int    ry:6;
    unsigned int    reserved_1:1;
    unsigned int    rxadj:1;
    unsigned int    rx:6;
}me_MSETB;
#endif

#define ME_CTRL                                                       0x18009000
#define ME_CTRL_reg_addr                                              "0xB8009000"
#define ME_CTRL_reg                                                   0xB8009000
#define ME_CTRL_reg_hi                                                0xB800
#define ME_CTRL_reg_lo                                                0x9000
#define ME_CTRL_inst_addr                                             "0x0000"
#define ME_CTRL_inst                                                  0x0000
#define ME_CTRL_mbl_shift                                             (8)
#define ME_CTRL_ints_shift                                            (7)
#define ME_CTRL_inte_shift                                            (6)
#define ME_CTRL_tw_shift                                              (4)
#define ME_CTRL_tms_shift                                             (3)
#define ME_CTRL_tbs_shift                                             (2)
#define ME_CTRL_go_shift                                              (1)
#define ME_CTRL_write_data_shift                                      (0)
#define ME_CTRL_mbl_mask                                              (0x00000300)
#define ME_CTRL_ints_mask                                             (0x00000080)
#define ME_CTRL_inte_mask                                             (0x00000040)
#define ME_CTRL_tw_mask                                               (0x00000010)
#define ME_CTRL_tms_mask                                              (0x00000008)
#define ME_CTRL_tbs_mask                                              (0x00000004)
#define ME_CTRL_go_mask                                               (0x00000002)
#define ME_CTRL_write_data_mask                                       (0x00000001)
#define ME_CTRL_mbl(data)                                             (0x00000300&((data)<<8))
#define ME_CTRL_ints(data)                                            (0x00000080&((data)<<7))
#define ME_CTRL_inte(data)                                            (0x00000040&((data)<<6))
#define ME_CTRL_tw(data)                                              (0x00000010&((data)<<4))
#define ME_CTRL_tms(data)                                             (0x00000008&((data)<<3))
#define ME_CTRL_tbs(data)                                             (0x00000004&((data)<<2))
#define ME_CTRL_go(data)                                              (0x00000002&((data)<<1))
#define ME_CTRL_write_data(data)                                      (0x00000001&(data))
#define ME_CTRL_get_mbl(data)                                         ((0x00000300&(data))>>8)
#define ME_CTRL_get_ints(data)                                        ((0x00000080&(data))>>7)
#define ME_CTRL_get_inte(data)                                        ((0x00000040&(data))>>6)
#define ME_CTRL_get_tw(data)                                          ((0x00000010&(data))>>4)
#define ME_CTRL_get_tms(data)                                         ((0x00000008&(data))>>3)
#define ME_CTRL_get_tbs(data)                                         ((0x00000004&(data))>>2)
#define ME_CTRL_get_go(data)                                          ((0x00000002&(data))>>1)
#define ME_CTRL_get_write_data(data)                                  (0x00000001&(data))

#define ME_WSRAM                                                      0x18009004
#define ME_WSRAM_reg_addr                                             "0xB8009004"
#define ME_WSRAM_reg                                                  0xB8009004
#define ME_WSRAM_reg_hi                                               0xB800
#define ME_WSRAM_reg_lo                                               0x9004
#define ME_WSRAM_inst_addr                                            "0x0001"
#define ME_WSRAM_inst                                                 0x0001
#define ME_WSRAM_rdy_shift                                            (11)
#define ME_WSRAM_adr_shift                                            (4)
#define ME_WSRAM_sel_shift                                            (0)
#define ME_WSRAM_rdy_mask                                             (0x00000800)
#define ME_WSRAM_adr_mask                                             (0x000007F0)
#define ME_WSRAM_sel_mask                                             (0x0000000F)
#define ME_WSRAM_rdy(data)                                            (0x00000800&((data)<<11))
#define ME_WSRAM_adr(data)                                            (0x000007F0&((data)<<4))
#define ME_WSRAM_sel(data)                                            (0x0000000F&(data))
#define ME_WSRAM_get_rdy(data)                                        ((0x00000800&(data))>>11)
#define ME_WSRAM_get_adr(data)                                        ((0x000007F0&(data))>>4)
#define ME_WSRAM_get_sel(data)                                        (0x0000000F&(data))

#define ME_MSB32                                                      0x18009008
#define ME_MSB32_reg_addr                                             "0xB8009008"
#define ME_MSB32_reg                                                  0xB8009008
#define ME_MSB32_reg_hi                                               0xB800
#define ME_MSB32_reg_lo                                               0x9008
#define ME_MSB32_inst_addr                                            "0x0002"
#define ME_MSB32_inst                                                 0x0002
#define ME_MSB32_m32b_shift                                           (0)
#define ME_MSB32_m32b_mask                                            (0xFFFFFFFF)
#define ME_MSB32_m32b(data)                                           (0xFFFFFFFF&(data))
#define ME_MSB32_get_m32b(data)                                       (0xFFFFFFFF&(data))

#define ME_LSB32                                                      0x1800900C
#define ME_LSB32_reg_addr                                             "0xB800900C"
#define ME_LSB32_reg                                                  0xB800900C
#define ME_LSB32_reg_hi                                               0xB800
#define ME_LSB32_reg_lo                                               0x900C
#define ME_LSB32_inst_addr                                            "0x0003"
#define ME_LSB32_inst                                                 0x0003
#define ME_LSB32_l32b_shift                                           (0)
#define ME_LSB32_l32b_mask                                            (0xFFFFFFFF)
#define ME_LSB32_l32b(data)                                           (0xFFFFFFFF&(data))
#define ME_LSB32_get_l32b(data)                                       (0xFFFFFFFF&(data))

#define ME_CMDADDR                                                    0x18009010
#define ME_CMDADDR_reg_addr                                           "0xB8009010"
#define ME_CMDADDR_reg                                                0xB8009010
#define ME_CMDADDR_reg_hi                                             0xB800
#define ME_CMDADDR_reg_lo                                             0x9010
#define ME_CMDADDR_inst_addr                                          "0x0004"
#define ME_CMDADDR_inst                                               0x0004
#define ME_CMDADDR_addr_shift                                         (0)
#define ME_CMDADDR_addr_mask                                          (0x07FFFFFF)
#define ME_CMDADDR_addr(data)                                         (0x07FFFFFF&(data))
#define ME_CMDADDR_get_addr(data)                                     (0x07FFFFFF&(data))

#define ME_RLTADDR                                                    0x18009014
#define ME_RLTADDR_reg_addr                                           "0xB8009014"
#define ME_RLTADDR_reg                                                0xB8009014
#define ME_RLTADDR_reg_hi                                             0xB800
#define ME_RLTADDR_reg_lo                                             0x9014
#define ME_RLTADDR_inst_addr                                          "0x0005"
#define ME_RLTADDR_inst                                               0x0005
#define ME_RLTADDR_addr_shift                                         (0)
#define ME_RLTADDR_addr_mask                                          (0x07FFFFFF)
#define ME_RLTADDR_addr(data)                                         (0x07FFFFFF&(data))
#define ME_RLTADDR_get_addr(data)                                     (0x07FFFFFF&(data))

#define ME_TSETA_0                                                    0x18009018
#define ME_TSETA_1                                                    0x1800901C
#define ME_TSETA_0_reg_addr                                           "0xB8009018"
#define ME_TSETA_1_reg_addr                                           "0xB800901C"
#define ME_TSETA_0_reg                                                0xB8009018
#define ME_TSETA_0_reg_hi                                             0xB800
#define ME_TSETA_0_reg_lo                                             0x9018
#define ME_TSETA_1_reg                                                0xB800901C
#define ME_TSETA_1_reg_hi                                             0xB800
#define ME_TSETA_1_reg_lo                                             0x901C
#define ME_TSETA_0_inst_addr                                          "0x0006"
#define ME_TSETA_0_inst                                               0x0006
#define ME_TSETA_1_inst_addr                                          "0x0007"
#define ME_TSETA_1_inst                                               0x0007
#define ME_TSETA_fld_shift                                            (16)
#define ME_TSETA_ti_shift                                             (8)
#define ME_TSETA_bi_shift                                             (0)
#define ME_TSETA_fld_mask                                             (0x00010000)
#define ME_TSETA_ti_mask                                              (0x00003F00)
#define ME_TSETA_bi_mask                                              (0x0000003F)
#define ME_TSETA_fld(data)                                            (0x00010000&((data)<<16))
#define ME_TSETA_ti(data)                                             (0x00003F00&((data)<<8))
#define ME_TSETA_bi(data)                                             (0x0000003F&(data))
#define ME_TSETA_get_fld(data)                                        ((0x00010000&(data))>>16)
#define ME_TSETA_get_ti(data)                                         ((0x00003F00&(data))>>8)
#define ME_TSETA_get_bi(data)                                         (0x0000003F&(data))

#define ME_TSETB_0                                                    0x18009020
#define ME_TSETB_1                                                    0x18009024
#define ME_TSETB_0_reg_addr                                           "0xB8009020"
#define ME_TSETB_1_reg_addr                                           "0xB8009024"
#define ME_TSETB_0_reg                                                0xB8009020
#define ME_TSETB_0_reg_hi                                             0xB800
#define ME_TSETB_0_reg_lo                                             0x9020
#define ME_TSETB_1_reg                                                0xB8009024
#define ME_TSETB_1_reg_hi                                             0xB800
#define ME_TSETB_1_reg_lo                                             0x9024
#define ME_TSETB_0_inst_addr                                          "0x0008"
#define ME_TSETB_0_inst                                               0x0008
#define ME_TSETB_1_inst_addr                                          "0x0009"
#define ME_TSETB_1_inst                                               0x0009
#define ME_TSETB_y_shift                                              (16)
#define ME_TSETB_xinc_shift                                           (12)
#define ME_TSETB_x_shift                                              (0)
#define ME_TSETB_y_mask                                               (0x03FF0000)
#define ME_TSETB_xinc_mask                                            (0x0000F000)
#define ME_TSETB_x_mask                                               (0x000003FF)
#define ME_TSETB_y(data)                                              (0x03FF0000&((data)<<16))
#define ME_TSETB_xinc(data)                                           (0x0000F000&((data)<<12))
#define ME_TSETB_x(data)                                              (0x000003FF&(data))
#define ME_TSETB_get_y(data)                                          ((0x03FF0000&(data))>>16)
#define ME_TSETB_get_xinc(data)                                       ((0x0000F000&(data))>>12)
#define ME_TSETB_get_x(data)                                          (0x000003FF&(data))

#define ME_RSETA_0                                                    0x18009028
#define ME_RSETA_1                                                    0x1800902C
#define ME_RSETA_0_reg_addr                                           "0xB8009028"
#define ME_RSETA_1_reg_addr                                           "0xB800902C"
#define ME_RSETA_0_reg                                                0xB8009028
#define ME_RSETA_0_reg_hi                                             0xB800
#define ME_RSETA_0_reg_lo                                             0x9028
#define ME_RSETA_1_reg                                                0xB800902C
#define ME_RSETA_1_reg_hi                                             0xB800
#define ME_RSETA_1_reg_lo                                             0x902C
#define ME_RSETA_0_inst_addr                                          "0x000A"
#define ME_RSETA_0_inst                                               0x000A
#define ME_RSETA_1_inst_addr                                          "0x000B"
#define ME_RSETA_1_inst                                               0x000B
#define ME_RSETA_fld_shift                                            (16)
#define ME_RSETA_ti_shift                                             (8)
#define ME_RSETA_bi_shift                                             (0)
#define ME_RSETA_fld_mask                                             (0x00010000)
#define ME_RSETA_ti_mask                                              (0x00003F00)
#define ME_RSETA_bi_mask                                              (0x0000003F)
#define ME_RSETA_fld(data)                                            (0x00010000&((data)<<16))
#define ME_RSETA_ti(data)                                             (0x00003F00&((data)<<8))
#define ME_RSETA_bi(data)                                             (0x0000003F&(data))
#define ME_RSETA_get_fld(data)                                        ((0x00010000&(data))>>16)
#define ME_RSETA_get_ti(data)                                         ((0x00003F00&(data))>>8)
#define ME_RSETA_get_bi(data)                                         (0x0000003F&(data))

#define ME_RSETB_0                                                    0x18009030
#define ME_RSETB_1                                                    0x18009034
#define ME_RSETB_0_reg_addr                                           "0xB8009030"
#define ME_RSETB_1_reg_addr                                           "0xB8009034"
#define ME_RSETB_0_reg                                                0xB8009030
#define ME_RSETB_0_reg_hi                                             0xB800
#define ME_RSETB_0_reg_lo                                             0x9030
#define ME_RSETB_1_reg                                                0xB8009034
#define ME_RSETB_1_reg_hi                                             0xB800
#define ME_RSETB_1_reg_lo                                             0x9034
#define ME_RSETB_0_inst_addr                                          "0x000C"
#define ME_RSETB_0_inst                                               0x000C
#define ME_RSETB_1_inst_addr                                          "0x000D"
#define ME_RSETB_1_inst                                               0x000D
#define ME_RSETB_mvys_shift                                           (30)
#define ME_RSETB_mvxs_shift                                           (22)
#define ME_RSETB_mvx_shift                                            (8)
#define ME_RSETB_mvy_shift                                            (0)
#define ME_RSETB_mvys_mask                                            (0xC0000000)
#define ME_RSETB_mvxs_mask                                            (0x00C00000)
#define ME_RSETB_mvx_mask                                             (0x0000FF00)
#define ME_RSETB_mvy_mask                                             (0x000000FF)
#define ME_RSETB_mvys(data)                                           (0xC0000000&((data)<<30))
#define ME_RSETB_mvxs(data)                                           (0x00C00000&((data)<<22))
#define ME_RSETB_mvx(data)                                            (0x0000FF00&((data)<<8))
#define ME_RSETB_mvy(data)                                            (0x000000FF&(data))
#define ME_RSETB_get_mvys(data)                                       ((0xC0000000&(data))>>30)
#define ME_RSETB_get_mvxs(data)                                       ((0x00C00000&(data))>>22)
#define ME_RSETB_get_mvx(data)                                        ((0x0000FF00&(data))>>8)
#define ME_RSETB_get_mvy(data)                                        (0x000000FF&(data))

#define ME_RSETC_0                                                    0x18009038
#define ME_RSETC_1                                                    0x1800903C
#define ME_RSETC_0_reg_addr                                           "0xB8009038"
#define ME_RSETC_1_reg_addr                                           "0xB800903C"
#define ME_RSETC_0_reg                                                0xB8009038
#define ME_RSETC_0_reg_hi                                             0xB800
#define ME_RSETC_0_reg_lo                                             0x9038
#define ME_RSETC_1_reg                                                0xB800903C
#define ME_RSETC_1_reg_hi                                             0xB800
#define ME_RSETC_1_reg_lo                                             0x903C
#define ME_RSETC_0_inst_addr                                          "0x000E"
#define ME_RSETC_0_inst                                               0x000E
#define ME_RSETC_1_inst_addr                                          "0x000F"
#define ME_RSETC_1_inst                                               0x000F
#define ME_RSETC_y_shift                                              (16)
#define ME_RSETC_xinc_shift                                           (12)
#define ME_RSETC_x_shift                                              (0)
#define ME_RSETC_y_mask                                               (0x03FF0000)
#define ME_RSETC_xinc_mask                                            (0x0000F000)
#define ME_RSETC_x_mask                                               (0x000003FF)
#define ME_RSETC_y(data)                                              (0x03FF0000&((data)<<16))
#define ME_RSETC_xinc(data)                                           (0x0000F000&((data)<<12))
#define ME_RSETC_x(data)                                              (0x000003FF&(data))
#define ME_RSETC_get_y(data)                                          ((0x03FF0000&(data))>>16)
#define ME_RSETC_get_xinc(data)                                       ((0x0000F000&(data))>>12)
#define ME_RSETC_get_x(data)                                          (0x000003FF&(data))

#define ME_RSETD_0                                                    0x18009040
#define ME_RSETD_1                                                    0x18009044
#define ME_RSETD_0_reg_addr                                           "0xB8009040"
#define ME_RSETD_1_reg_addr                                           "0xB8009044"
#define ME_RSETD_0_reg                                                0xB8009040
#define ME_RSETD_0_reg_hi                                             0xB800
#define ME_RSETD_0_reg_lo                                             0x9040
#define ME_RSETD_1_reg                                                0xB8009044
#define ME_RSETD_1_reg_hi                                             0xB800
#define ME_RSETD_1_reg_lo                                             0x9044
#define ME_RSETD_0_inst_addr                                          "0x0010"
#define ME_RSETD_0_inst                                               0x0010
#define ME_RSETD_1_inst_addr                                          "0x0011"
#define ME_RSETD_1_inst                                               0x0011
#define ME_RSETD_rh_shift                                             (16)
#define ME_RSETD_rw_shift                                             (0)
#define ME_RSETD_rh_mask                                              (0x03FF0000)
#define ME_RSETD_rw_mask                                              (0x000003FF)
#define ME_RSETD_rh(data)                                             (0x03FF0000&((data)<<16))
#define ME_RSETD_rw(data)                                             (0x000003FF&(data))
#define ME_RSETD_get_rh(data)                                         ((0x03FF0000&(data))>>16)
#define ME_RSETD_get_rw(data)                                         (0x000003FF&(data))

#define ME_RSETE_0                                                    0x18009048
#define ME_RSETE_1                                                    0x1800904C
#define ME_RSETE_0_reg_addr                                           "0xB8009048"
#define ME_RSETE_1_reg_addr                                           "0xB800904C"
#define ME_RSETE_0_reg                                                0xB8009048
#define ME_RSETE_0_reg_hi                                             0xB800
#define ME_RSETE_0_reg_lo                                             0x9048
#define ME_RSETE_1_reg                                                0xB800904C
#define ME_RSETE_1_reg_hi                                             0xB800
#define ME_RSETE_1_reg_lo                                             0x904C
#define ME_RSETE_0_inst_addr                                          "0x0012"
#define ME_RSETE_0_inst                                               0x0012
#define ME_RSETE_1_inst_addr                                          "0x0013"
#define ME_RSETE_1_inst                                               0x0013
#define ME_RSETE_tsy_shift                                            (16)
#define ME_RSETE_tsx_shift                                            (0)
#define ME_RSETE_tsy_mask                                             (0x03FF0000)
#define ME_RSETE_tsx_mask                                             (0x000003FF)
#define ME_RSETE_tsy(data)                                            (0x03FF0000&((data)<<16))
#define ME_RSETE_tsx(data)                                            (0x000003FF&(data))
#define ME_RSETE_get_tsy(data)                                        ((0x03FF0000&(data))>>16)
#define ME_RSETE_get_tsx(data)                                        (0x000003FF&(data))

#define ME_RSETF_0                                                    0x18009050
#define ME_RSETF_1                                                    0x18009054
#define ME_RSETF_0_reg_addr                                           "0xB8009050"
#define ME_RSETF_1_reg_addr                                           "0xB8009054"
#define ME_RSETF_0_reg                                                0xB8009050
#define ME_RSETF_0_reg_hi                                             0xB800
#define ME_RSETF_0_reg_lo                                             0x9050
#define ME_RSETF_1_reg                                                0xB8009054
#define ME_RSETF_1_reg_hi                                             0xB800
#define ME_RSETF_1_reg_lo                                             0x9054
#define ME_RSETF_0_inst_addr                                          "0x0014"
#define ME_RSETF_0_inst                                               0x0014
#define ME_RSETF_1_inst_addr                                          "0x0015"
#define ME_RSETF_1_inst                                               0x0015
#define ME_RSETF_tey_shift                                            (16)
#define ME_RSETF_tex_shift                                            (0)
#define ME_RSETF_tey_mask                                             (0x03FF0000)
#define ME_RSETF_tex_mask                                             (0x000003FF)
#define ME_RSETF_tey(data)                                            (0x03FF0000&((data)<<16))
#define ME_RSETF_tex(data)                                            (0x000003FF&(data))
#define ME_RSETF_get_tey(data)                                        ((0x03FF0000&(data))>>16)
#define ME_RSETF_get_tex(data)                                        (0x000003FF&(data))

#define ME_RSETG_0                                                    0x18009058
#define ME_RSETG_1                                                    0x1800905C
#define ME_RSETG_0_reg_addr                                           "0xB8009058"
#define ME_RSETG_1_reg_addr                                           "0xB800905C"
#define ME_RSETG_0_reg                                                0xB8009058
#define ME_RSETG_0_reg_hi                                             0xB800
#define ME_RSETG_0_reg_lo                                             0x9058
#define ME_RSETG_1_reg                                                0xB800905C
#define ME_RSETG_1_reg_hi                                             0xB800
#define ME_RSETG_1_reg_lo                                             0x905C
#define ME_RSETG_0_inst_addr                                          "0x0016"
#define ME_RSETG_0_inst                                               0x0016
#define ME_RSETG_1_inst_addr                                          "0x0017"
#define ME_RSETG_1_inst                                               0x0017
#define ME_RSETG_bsy_shift                                            (16)
#define ME_RSETG_bsx_shift                                            (0)
#define ME_RSETG_bsy_mask                                             (0x03FF0000)
#define ME_RSETG_bsx_mask                                             (0x000003FF)
#define ME_RSETG_bsy(data)                                            (0x03FF0000&((data)<<16))
#define ME_RSETG_bsx(data)                                            (0x000003FF&(data))
#define ME_RSETG_get_bsy(data)                                        ((0x03FF0000&(data))>>16)
#define ME_RSETG_get_bsx(data)                                        (0x000003FF&(data))

#define ME_RSETH_0                                                    0x18009060
#define ME_RSETH_1                                                    0x18009064
#define ME_RSETH_0_reg_addr                                           "0xB8009060"
#define ME_RSETH_1_reg_addr                                           "0xB8009064"
#define ME_RSETH_0_reg                                                0xB8009060
#define ME_RSETH_0_reg_hi                                             0xB800
#define ME_RSETH_0_reg_lo                                             0x9060
#define ME_RSETH_1_reg                                                0xB8009064
#define ME_RSETH_1_reg_hi                                             0xB800
#define ME_RSETH_1_reg_lo                                             0x9064
#define ME_RSETH_0_inst_addr                                          "0x0018"
#define ME_RSETH_0_inst                                               0x0018
#define ME_RSETH_1_inst_addr                                          "0x0019"
#define ME_RSETH_1_inst                                               0x0019
#define ME_RSETH_bey_shift                                            (16)
#define ME_RSETH_bex_shift                                            (0)
#define ME_RSETH_bey_mask                                             (0x03FF0000)
#define ME_RSETH_bex_mask                                             (0x000003FF)
#define ME_RSETH_bey(data)                                            (0x03FF0000&((data)<<16))
#define ME_RSETH_bex(data)                                            (0x000003FF&(data))
#define ME_RSETH_get_bey(data)                                        ((0x03FF0000&(data))>>16)
#define ME_RSETH_get_bex(data)                                        (0x000003FF&(data))

#define ME_MSETA_0                                                    0x18009068
#define ME_MSETA_1                                                    0x1800906C
#define ME_MSETA_2                                                    0x18009070
#define ME_MSETA_3                                                    0x18009074
#define ME_MSETA_0_reg_addr                                           "0xB8009068"
#define ME_MSETA_1_reg_addr                                           "0xB800906C"
#define ME_MSETA_2_reg_addr                                           "0xB8009070"
#define ME_MSETA_3_reg_addr                                           "0xB8009074"
#define ME_MSETA_0_reg                                                0xB8009068
#define ME_MSETA_0_reg_hi                                             0xB800
#define ME_MSETA_0_reg_lo                                             0x9068
#define ME_MSETA_1_reg                                                0xB800906C
#define ME_MSETA_1_reg_hi                                             0xB800
#define ME_MSETA_1_reg_lo                                             0x906C
#define ME_MSETA_2_reg                                                0xB8009070
#define ME_MSETA_2_reg_hi                                             0xB800
#define ME_MSETA_2_reg_lo                                             0x9070
#define ME_MSETA_3_reg                                                0xB8009074
#define ME_MSETA_3_reg_hi                                             0xB800
#define ME_MSETA_3_reg_lo                                             0x9074
#define ME_MSETA_0_inst_addr                                          "0x001A"
#define ME_MSETA_0_inst                                               0x001A
#define ME_MSETA_1_inst_addr                                          "0x001B"
#define ME_MSETA_1_inst                                               0x001B
#define ME_MSETA_2_inst_addr                                          "0x001C"
#define ME_MSETA_2_inst                                               0x001C
#define ME_MSETA_3_inst_addr                                          "0x001D"
#define ME_MSETA_3_inst                                               0x001D
#define ME_MSETA_stage_shift                                          (31)
#define ME_MSETA_half_shift                                           (29)
#define ME_MSETA_mvce_shift                                           (28)
#define ME_MSETA_mvcfp_shift                                          (24)
#define ME_MSETA_mvcf_shift                                           (16)
#define ME_MSETA_zmvp_shift                                           (15)
#define ME_MSETA_can_shift                                            (12)
#define ME_MSETA_bscale_shift                                         (8)
#define ME_MSETA_zmvb_shift                                           (0)
#define ME_MSETA_stage_mask                                           (0x80000000)
#define ME_MSETA_half_mask                                            (0x60000000)
#define ME_MSETA_mvce_mask                                            (0x10000000)
#define ME_MSETA_mvcfp_mask                                           (0x07000000)
#define ME_MSETA_mvcf_mask                                            (0x00FF0000)
#define ME_MSETA_zmvp_mask                                            (0x00008000)
#define ME_MSETA_can_mask                                             (0x00007000)
#define ME_MSETA_bscale_mask                                          (0x00000700)
#define ME_MSETA_zmvb_mask                                            (0x000000FF)
#define ME_MSETA_stage(data)                                          (0x80000000&((data)<<31))
#define ME_MSETA_half(data)                                           (0x60000000&((data)<<29))
#define ME_MSETA_mvce(data)                                           (0x10000000&((data)<<28))
#define ME_MSETA_mvcfp(data)                                          (0x07000000&((data)<<24))
#define ME_MSETA_mvcf(data)                                           (0x00FF0000&((data)<<16))
#define ME_MSETA_zmvp(data)                                           (0x00008000&((data)<<15))
#define ME_MSETA_can(data)                                            (0x00007000&((data)<<12))
#define ME_MSETA_bscale(data)                                         (0x00000700&((data)<<8))
#define ME_MSETA_zmvb(data)                                           (0x000000FF&(data))
#define ME_MSETA_get_stage(data)                                      ((0x80000000&(data))>>31)
#define ME_MSETA_get_half(data)                                       ((0x60000000&(data))>>29)
#define ME_MSETA_get_mvce(data)                                       ((0x10000000&(data))>>28)
#define ME_MSETA_get_mvcfp(data)                                      ((0x07000000&(data))>>24)
#define ME_MSETA_get_mvcf(data)                                       ((0x00FF0000&(data))>>16)
#define ME_MSETA_get_zmvp(data)                                       ((0x00008000&(data))>>15)
#define ME_MSETA_get_can(data)                                        ((0x00007000&(data))>>12)
#define ME_MSETA_get_bscale(data)                                     ((0x00000700&(data))>>8)
#define ME_MSETA_get_zmvb(data)                                       (0x000000FF&(data))

#define ME_MSETB_0                                                    0x18009078
#define ME_MSETB_1                                                    0x1800907C
#define ME_MSETB_2                                                    0x18009080
#define ME_MSETB_3                                                    0x18009084
#define ME_MSETB_0_reg_addr                                           "0xB8009078"
#define ME_MSETB_1_reg_addr                                           "0xB800907C"
#define ME_MSETB_2_reg_addr                                           "0xB8009080"
#define ME_MSETB_3_reg_addr                                           "0xB8009084"
#define ME_MSETB_0_reg                                                0xB8009078
#define ME_MSETB_0_reg_hi                                             0xB800
#define ME_MSETB_0_reg_lo                                             0x9078
#define ME_MSETB_1_reg                                                0xB800907C
#define ME_MSETB_1_reg_hi                                             0xB800
#define ME_MSETB_1_reg_lo                                             0x907C
#define ME_MSETB_2_reg                                                0xB8009080
#define ME_MSETB_2_reg_hi                                             0xB800
#define ME_MSETB_2_reg_lo                                             0x9080
#define ME_MSETB_3_reg                                                0xB8009084
#define ME_MSETB_3_reg_hi                                             0xB800
#define ME_MSETB_3_reg_lo                                             0x9084
#define ME_MSETB_0_inst_addr                                          "0x001E"
#define ME_MSETB_0_inst                                               0x001E
#define ME_MSETB_1_inst_addr                                          "0x001F"
#define ME_MSETB_1_inst                                               0x001F
#define ME_MSETB_2_inst_addr                                          "0x0020"
#define ME_MSETB_2_inst                                               0x0020
#define ME_MSETB_3_inst_addr                                          "0x0021"
#define ME_MSETB_3_inst                                               0x0021
#define ME_MSETB_mvcb_shift                                           (24)
#define ME_MSETB_mvct_shift                                           (16)
#define ME_MSETB_ryadj_shift                                          (14)
#define ME_MSETB_ry_shift                                             (8)
#define ME_MSETB_rxadj_shift                                          (6)
#define ME_MSETB_rx_shift                                             (0)
#define ME_MSETB_mvcb_mask                                            (0xFF000000)
#define ME_MSETB_mvct_mask                                            (0x00FF0000)
#define ME_MSETB_ryadj_mask                                           (0x00004000)
#define ME_MSETB_ry_mask                                              (0x00003F00)
#define ME_MSETB_rxadj_mask                                           (0x00000040)
#define ME_MSETB_rx_mask                                              (0x0000003F)
#define ME_MSETB_mvcb(data)                                           (0xFF000000&((data)<<24))
#define ME_MSETB_mvct(data)                                           (0x00FF0000&((data)<<16))
#define ME_MSETB_ryadj(data)                                          (0x00004000&((data)<<14))
#define ME_MSETB_ry(data)                                             (0x00003F00&((data)<<8))
#define ME_MSETB_rxadj(data)                                          (0x00000040&((data)<<6))
#define ME_MSETB_rx(data)                                             (0x0000003F&(data))
#define ME_MSETB_get_mvcb(data)                                       ((0xFF000000&(data))>>24)
#define ME_MSETB_get_mvct(data)                                       ((0x00FF0000&(data))>>16)
#define ME_MSETB_get_ryadj(data)                                      ((0x00004000&(data))>>14)
#define ME_MSETB_get_ry(data)                                         ((0x00003F00&(data))>>8)
#define ME_MSETB_get_rxadj(data)                                      ((0x00000040&(data))>>6)
#define ME_MSETB_get_rx(data)                                         (0x0000003F&(data))
#endif
