// This file is generated using the spec version 0.1.5, firmware template version 1.39and DVR_Parser_0.45
#ifndef _MIS_REG_H_INCLUDED_
#define _MIS_REG_H_INCLUDED_

//#define  _MIS_USE_STRUCT
#ifdef _MIS_USE_STRUCT

typedef struct
{
    unsigned int    reserved_0:2;
    unsigned int    psel30:2;
    unsigned int    psel29:2;
    unsigned int    psel28:2;
    unsigned int    psel27:2;
    unsigned int    psel26:2;
    unsigned int    psel25:2;
    unsigned int    psel24:2;
    unsigned int    psel23:2;
    unsigned int    psel22:2;
    unsigned int    psel21:2;
    unsigned int    psel20:2;
    unsigned int    psel19:2;
    unsigned int    psel18:2;
    unsigned int    psel17:2;
    unsigned int    psel16:2;
}mis_PSELH;

typedef struct
{
    unsigned int    psel15:2;
    unsigned int    psel14:2;
    unsigned int    psel13:2;
    unsigned int    reserved_0:8;
    unsigned int    psel8:2;
    unsigned int    psel7:2;
    unsigned int    psel6:2;
    unsigned int    psel5:2;
    unsigned int    psel4:2;
    unsigned int    psel3:2;
    unsigned int    psel2:2;
    unsigned int    psel1:2;
    unsigned int    psel0:2;
}mis_PSELL;

typedef struct
{
    unsigned int    reserved_0:11;
    unsigned int    gpioda_int:1;
    unsigned int    gpioa_int:1;
    unsigned int    vfd_ardswda_int:1;
    unsigned int    vfd_ardswa_int:1;
    unsigned int    vfd_ardkpadda_int:1;
    unsigned int    vfd_ardkpada_int:1;
    unsigned int    vfd_wdone_int:1;
    unsigned int    rtc_alarm_int:1;
    unsigned int    rtc_date_int:1;
    unsigned int    rtc_hour_int:1;
    unsigned int    rtc_min_int:1;
    unsigned int    rtc_hsec_int:1;
    unsigned int    tc2_int:1;
    unsigned int    tc1_int:1;
    unsigned int    tc0_int:1;
    unsigned int    reserved_1:5;
    unsigned int    write_data:1;
}mis_UMSK_ISR;

typedef struct
{
    unsigned int    reserved_0:11;
    unsigned int    gpioda_int:1;
    unsigned int    gpioa_int:1;
    unsigned int    vfd_ardswda_int:1;
    unsigned int    vfd_ardswa_int:1;
    unsigned int    vfd_ardkpadda_int:1;
    unsigned int    vfd_ardkpada_int:1;
    unsigned int    vfd_wdone_int:1;
    unsigned int    rtc_alarm_int:1;
    unsigned int    rtc_date_int:1;
    unsigned int    rtc_hour_int:1;
    unsigned int    rtc_min_int:1;
    unsigned int    rtc_hsec_int:1;
    unsigned int    tc2_int:1;
    unsigned int    tc1_int:1;
    unsigned int    tc0_int:1;
    unsigned int    irda_int:1;
    unsigned int    i2c_int:1;
    unsigned int    ur1_int:1;
    unsigned int    ur0_int:1;
    unsigned int    reserved_1:1;
    unsigned int    write_data:1;
}mis_ISR;

typedef struct
{
    unsigned int    int30:1;
    unsigned int    int29:1;
    unsigned int    int28:1;
    unsigned int    int27:1;
    unsigned int    int26:1;
    unsigned int    int25:1;
    unsigned int    int24:1;
    unsigned int    int23:1;
    unsigned int    int22:1;
    unsigned int    int21:1;
    unsigned int    int20:1;
    unsigned int    int19:1;
    unsigned int    int18:1;
    unsigned int    int17:1;
    unsigned int    int16:1;
    unsigned int    int15:1;
    unsigned int    int14:1;
    unsigned int    int13:1;
    unsigned int    int12:1;
    unsigned int    int11:1;
    unsigned int    int10:1;
    unsigned int    int9:1;
    unsigned int    int8:1;
    unsigned int    int7:1;
    unsigned int    int6:1;
    unsigned int    int5:1;
    unsigned int    int4:1;
    unsigned int    int3:1;
    unsigned int    int2:1;
    unsigned int    int1:1;
    unsigned int    int0:1;
    unsigned int    write_data:1;
}mis_UMSK_ISR_GPA;

typedef struct
{
    unsigned int    int30:1;
    unsigned int    int29:1;
    unsigned int    int28:1;
    unsigned int    int27:1;
    unsigned int    int26:1;
    unsigned int    int25:1;
    unsigned int    int24:1;
    unsigned int    int23:1;
    unsigned int    int22:1;
    unsigned int    int21:1;
    unsigned int    int20:1;
    unsigned int    int19:1;
    unsigned int    int18:1;
    unsigned int    int17:1;
    unsigned int    int16:1;
    unsigned int    int15:1;
    unsigned int    int14:1;
    unsigned int    int13:1;
    unsigned int    int12:1;
    unsigned int    int11:1;
    unsigned int    int10:1;
    unsigned int    int9:1;
    unsigned int    int8:1;
    unsigned int    int7:1;
    unsigned int    int6:1;
    unsigned int    int5:1;
    unsigned int    int4:1;
    unsigned int    int3:1;
    unsigned int    int2:1;
    unsigned int    int1:1;
    unsigned int    int0:1;
    unsigned int    write_data:1;
}mis_UMSK_ISR_GPDA;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    int47:1;
    unsigned int    int46:1;
    unsigned int    int45:1;
    unsigned int    int44:1;
    unsigned int    int43:1;
    unsigned int    int42:1;
    unsigned int    int41:1;
    unsigned int    int40:1;
    unsigned int    int39:1;
    unsigned int    int38:1;
    unsigned int    int37:1;
    unsigned int    int36:1;
    unsigned int    int35:1;
    unsigned int    int34:1;
    unsigned int    int33:1;
    unsigned int    int32:1;
    unsigned int    int31:1;
    unsigned int    int30:1;
    unsigned int    int29:1;
    unsigned int    int28:1;
    unsigned int    reserved_1:3;
    unsigned int    write_data:1;
}mis_UMSK_ISR_KPADAH;

typedef struct
{
    unsigned int    int27:1;
    unsigned int    int26:1;
    unsigned int    int25:1;
    unsigned int    int24:1;
    unsigned int    int23:1;
    unsigned int    int22:1;
    unsigned int    int21:1;
    unsigned int    int20:1;
    unsigned int    int19:1;
    unsigned int    int18:1;
    unsigned int    int17:1;
    unsigned int    int16:1;
    unsigned int    int15:1;
    unsigned int    int14:1;
    unsigned int    int13:1;
    unsigned int    int12:1;
    unsigned int    int11:1;
    unsigned int    int10:1;
    unsigned int    int9:1;
    unsigned int    int8:1;
    unsigned int    int7:1;
    unsigned int    int6:1;
    unsigned int    int5:1;
    unsigned int    int4:1;
    unsigned int    int3:1;
    unsigned int    int2:1;
    unsigned int    int1:1;
    unsigned int    int0:1;
    unsigned int    reserved_0:3;
    unsigned int    write_data:1;
}mis_UMSK_ISR_KPADAL;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    int47:1;
    unsigned int    int46:1;
    unsigned int    int45:1;
    unsigned int    int44:1;
    unsigned int    int43:1;
    unsigned int    int42:1;
    unsigned int    int41:1;
    unsigned int    int40:1;
    unsigned int    int39:1;
    unsigned int    int38:1;
    unsigned int    int37:1;
    unsigned int    int36:1;
    unsigned int    int35:1;
    unsigned int    int34:1;
    unsigned int    int33:1;
    unsigned int    int32:1;
    unsigned int    int31:1;
    unsigned int    int30:1;
    unsigned int    int29:1;
    unsigned int    int28:1;
    unsigned int    reserved_1:3;
    unsigned int    write_data:1;
}mis_UMSK_ISR_KPADDAH;

typedef struct
{
    unsigned int    int27:1;
    unsigned int    int26:1;
    unsigned int    int25:1;
    unsigned int    int24:1;
    unsigned int    int23:1;
    unsigned int    int22:1;
    unsigned int    int21:1;
    unsigned int    int20:1;
    unsigned int    int19:1;
    unsigned int    int18:1;
    unsigned int    int17:1;
    unsigned int    int16:1;
    unsigned int    int15:1;
    unsigned int    int14:1;
    unsigned int    int13:1;
    unsigned int    int12:1;
    unsigned int    int11:1;
    unsigned int    int10:1;
    unsigned int    int9:1;
    unsigned int    int8:1;
    unsigned int    int7:1;
    unsigned int    int6:1;
    unsigned int    int5:1;
    unsigned int    int4:1;
    unsigned int    int3:1;
    unsigned int    int2:1;
    unsigned int    int1:1;
    unsigned int    int0:1;
    unsigned int    reserved_0:3;
    unsigned int    write_data:1;
}mis_UMSK_ISR_KPADDAL;

typedef struct
{
    unsigned int    reserved_0:20;
    unsigned int    da_int3:1;
    unsigned int    da_int2:1;
    unsigned int    da_int1:1;
    unsigned int    da_int0:1;
    unsigned int    a_int3:1;
    unsigned int    a_int2:1;
    unsigned int    a_int1:1;
    unsigned int    a_int0:1;
    unsigned int    reserved_1:3;
    unsigned int    write_data:1;
}mis_UMSK_ISR_SW;

typedef struct
{
    unsigned int    reserved_0:20;
    unsigned int    write_enable3:1;
    unsigned int    sel1:4;
    unsigned int    write_enable2:1;
    unsigned int    sel0:4;
    unsigned int    write_enable1:1;
    unsigned int    enable:1;
}mis_DBG;

typedef struct
{
    unsigned int    write_enable4:1;
    unsigned int    reserved4:7;
    unsigned int    write_enable3:1;
    unsigned int    reserved3:7;
    unsigned int    write_enable2:1;
    unsigned int    reserved2:7;
    unsigned int    write_enable1:1;
    unsigned int    reserved1:7;
}mis_DUMMY;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    gpdir:31;
}mis_GPDIR;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    gpdato:31;
}mis_GPDATO;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    gpdati:31;
}mis_GPDATI;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    gp:31;
}mis_GPIE;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    gpha:31;
}mis_GPDP;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    write_enable4:1;
    unsigned int    clk4:3;
    unsigned int    write_enable3:1;
    unsigned int    clk3:3;
    unsigned int    write_enable2:1;
    unsigned int    clk2:3;
    unsigned int    write_enable1:1;
    unsigned int    clk1:3;
}mis_GPDEB;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    dll:8;
}mis_U0RBR_THR_DLL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    dlh:8;
}mis_U0IER_DLH;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    fifo16:2;
    unsigned int    reserved_1:2;
    unsigned int    iid:3;
    unsigned int    ipnd:1;
}mis_U0IIR_FCR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    dlab:1;
    unsigned int    brk:1;
    unsigned int    eps:2;
    unsigned int    pen:1;
    unsigned int    stb:1;
    unsigned int    wls:2;
}mis_U0LCR;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    loop:1;
    unsigned int    reserved_1:2;
    unsigned int    rts:1;
    unsigned int    dtr:1;
}mis_U0MCR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    rfe:1;
    unsigned int    temt:1;
    unsigned int    thre:1;
    unsigned int    bi:1;
    unsigned int    fe:1;
    unsigned int    pe:1;
    unsigned int    oe:1;
    unsigned int    dr:1;
}mis_U0LSR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    dcd:1;
    unsigned int    ri:1;
    unsigned int    dsr:1;
    unsigned int    cts:1;
    unsigned int    reserved_1:3;
    unsigned int    dcts:1;
}mis_U0MSR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    scr:8;
}mis_U0SCR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    dll:8;
}mis_U1RBR_THR_DLL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    dlh:8;
}mis_U1IER_DLH;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    fifo16:2;
    unsigned int    reserved_1:2;
    unsigned int    iid:3;
    unsigned int    ipnd:1;
}mis_U1IIR_FCR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    dlab:1;
    unsigned int    brk:1;
    unsigned int    eps:2;
    unsigned int    pen:1;
    unsigned int    stb:1;
    unsigned int    wls:2;
}mis_U1LCR;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    loop:1;
    unsigned int    reserved_1:2;
    unsigned int    rts:1;
    unsigned int    dtr:1;
}mis_U1MCR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    rfe:1;
    unsigned int    temt:1;
    unsigned int    thre:1;
    unsigned int    bi:1;
    unsigned int    fe:1;
    unsigned int    pe:1;
    unsigned int    oe:1;
    unsigned int    dr:1;
}mis_U1LSR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    dcd:1;
    unsigned int    ri:1;
    unsigned int    dsr:1;
    unsigned int    cts:1;
    unsigned int    reserved_1:3;
    unsigned int    dcts:1;
}mis_U1MSR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    scr:8;
}mis_U1SCR;

typedef struct
{
    unsigned int    reserved_0:9;
    unsigned int    ic_slave_disable:1;
    unsigned int    ic_restart_en:1;
    unsigned int    ic_10bitaddr_master:1;
    unsigned int    ic_10bitaddr_slave:1;
    unsigned int    speed:2;
    unsigned int    master_mode:1;
}mis_IC_CON;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    special:1;
    unsigned int    gc_or_start:1;
    unsigned int    ic_tar:10;
}mis_IC_TAR;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    ic_sar:10;
}mis_IC_SAR;

typedef struct
{
    unsigned int    reserved_0:13;
    unsigned int    ic_hs_mar:3;
}mis_IC_HS_MADDR;

typedef struct
{
    unsigned int    reserved_0:7;
    unsigned int    cmd:1;
    unsigned int    dat:8;
}mis_IC_DATA_CMD;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    ic_ss_scl_hcnt:16;
}mis_IC_SS_SCL_HCNT;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    ic_ss_scl_lcnt:16;
}mis_IC_SS_SCL_LCNT;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    ic_fs_scl_hcnt:16;
}mis_IC_FS_SCL_HCNT;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    ic_fs_scl_lcnt:16;
}mis_IC_FS_SCL_LCNT;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    gen_call:1;
    unsigned int    start_det:1;
    unsigned int    stop_det:1;
    unsigned int    activity:1;
    unsigned int    rx_done:1;
    unsigned int    tx_abrt:1;
    unsigned int    rd_req:1;
    unsigned int    tx_empty:1;
    unsigned int    tx_over:1;
    unsigned int    rx_full:1;
    unsigned int    rx_over:1;
    unsigned int    rx_under:1;
}mis_IC_RAW_INTR_STAT;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    m_gen_call:1;
    unsigned int    m_start_det:1;
    unsigned int    m_stop_det:1;
    unsigned int    m_activity:1;
    unsigned int    m_rx_done:1;
    unsigned int    m_tx_abrt:1;
    unsigned int    m_rd_req:1;
    unsigned int    m_tx_empty:1;
    unsigned int    m_tx_over:1;
    unsigned int    m_rx_full:1;
    unsigned int    m_rx_over:1;
    unsigned int    m_rx_under:1;
}mis_IC_INTR_MASK;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    r_gen_call:1;
    unsigned int    r_start_det:1;
    unsigned int    r_stop_det:1;
    unsigned int    r_activity:1;
    unsigned int    r_rx_done:1;
    unsigned int    r_tx_abrt:1;
    unsigned int    r_rd_req:1;
    unsigned int    r_tx_empty:1;
    unsigned int    r_tx_over:1;
    unsigned int    r_rx_full:1;
    unsigned int    r_rx_over:1;
    unsigned int    r_rx_under:1;
}mis_IC_INTR_STAT;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    rx_tl:8;
}mis_IC_RX_TL;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    tx_tl:8;
}mis_IC_TX_TL;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_intr:1;
}mis_IC_CLR_INTR;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_rx_under:1;
}mis_IC_CLR_RX_UNDER;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_rx_over:1;
}mis_IC_CLR_RX_OVER;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_tx_over:1;
}mis_IC_CLR_TX_OVER;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_rd_req:1;
}mis_IC_CLR_RD_REQ;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_tx_abrt:1;
}mis_IC_CLR_TX_ABRT;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_rx_done:1;
}mis_IC_CLR_RX_DONE;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_activity:1;
}mis_IC_CLR_ACTIVITY;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_stop_det:1;
}mis_IC_CLR_STOP_DET;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_start_det:1;
}mis_IC_CLR_START_DET;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    clr_gen_call:1;
}mis_IC_CLR_GEN_CALL;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    enable:1;
}mis_IC_ENABLE;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    rff:1;
    unsigned int    rfne:1;
    unsigned int    tfe:1;
    unsigned int    tfnf:1;
    unsigned int    activity:1;
}mis_IC_STATUS;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    txflr:1;
}mis_IC_TXFLR;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    rxflr:1;
}mis_IC_RXFLR;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    abrt_slvrd_intx:1;
    unsigned int    abrt_slv_arblost:1;
    unsigned int    abrt_slvflush_txfifo:1;
    unsigned int    arb_lost:1;
    unsigned int    arb_master_dis:1;
    unsigned int    abrt_10b_rd_norstrt:1;
    unsigned int    abrt_sbyte_norstrt:1;
    unsigned int    abrt_hs_norstrt:1;
    unsigned int    abrt_sbyte_ackdet:1;
    unsigned int    abrt_hs_ackdet:1;
    unsigned int    abrt_gcall_read:1;
    unsigned int    abrt_gcall_noack:1;
    unsigned int    abrt_txdata_noack:1;
    unsigned int    abrt_10addr2_noack:1;
    unsigned int    abrt_10addr1_noack:1;
    unsigned int    abrt_7b_addr_noack:1;
}mis_IC_TX_ABRT_SOURCE;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    tdmae:1;
    unsigned int    rdmae:1;
}mis_IC_DMA_CR;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    dmatdl:2;
}mis_IC_DMA_TDLR;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    dmardl:2;
}mis_IC_DMA_RDLR;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    tx_buffer_depth:8;
    unsigned int    rx_buffer_depth:8;
    unsigned int    add_encoded_params:1;
    unsigned int    has_dma:1;
    unsigned int    intr_io:1;
    unsigned int    hc_count_values:1;
    unsigned int    max_speed_mode:2;
    unsigned int    apb_data_width:2;
}mis_IC_COMP_PARAM_1;

typedef struct
{
    unsigned int    ic_comp_version:32;
}mis_IC_COMP_VERSION;

typedef struct
{
    unsigned int    ic_comp_type:32;
}mis_IC_COMP_TYPE;

typedef struct
{
    unsigned int    irrbl:8;
    unsigned int    irrml:8;
    unsigned int    irrdzl:8;
    unsigned int    irrdol:8;
}mis_IR_PSR;

typedef struct
{
    unsigned int    reserved_0:11;
    unsigned int    irrdl:5;
    unsigned int    irrrl:8;
    unsigned int    irrsl:8;
}mis_IR_PER;

typedef struct
{
    unsigned int    reserved_0:19;
    unsigned int    irfd:13;
}mis_IR_SF;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    iriotcdp:16;
}mis_IR_DPIR;

typedef struct
{
    unsigned int    irsr:1;
    unsigned int    reserved_0:19;
    unsigned int    mlae:1;
    unsigned int    irdvie:1;
    unsigned int    irres:1;
    unsigned int    irue:1;
    unsigned int    ircm:1;
    unsigned int    irbme:1;
    unsigned int    irdpm:1;
    unsigned int    irdn:5;
}mis_IR_CR;

typedef struct
{
    unsigned int    irrp:32;
}mis_IR_RP;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    irrf:1;
    unsigned int    irdvf:1;
}mis_IR_SR;

typedef struct
{
    unsigned int    tc0tvr:32;
}mis_TC0TVR;

typedef struct
{
    unsigned int    tc1tvr:32;
}mis_TC1TVR;

typedef struct
{
    unsigned int    tc2tvr:32;
}mis_TC2TVR;

typedef struct
{
    unsigned int    tc0cvr:32;
}mis_TC0CVR;

typedef struct
{
    unsigned int    tc1cvr:32;
}mis_TC1CVR;

typedef struct
{
    unsigned int    tc2vr:32;
}mis_TC2CVR;

typedef struct
{
    unsigned int    tc0en:1;
    unsigned int    tc0mode:1;
    unsigned int    reserveda:6;
    unsigned int    reserved_0:24;
}mis_TC0CR;

typedef struct
{
    unsigned int    tc1en:1;
    unsigned int    tc1mode:1;
    unsigned int    reserveda:6;
    unsigned int    reserved_0:24;
}mis_TC1CR;

typedef struct
{
    unsigned int    tc2en:1;
    unsigned int    tc2mode:1;
    unsigned int    reserveda:6;
    unsigned int    reserved_0:24;
}mis_TC2CR;

typedef struct
{
    unsigned int    tc0ie:1;
    unsigned int    reserved_0:31;
}mis_TC0ICR;

typedef struct
{
    unsigned int    tc1ie:1;
    unsigned int    reserved_0:31;
}mis_TC1ICR;

typedef struct
{
    unsigned int    tc2ie:1;
    unsigned int    reserved_0:31;
}mis_TC2ICR;

typedef struct
{
    unsigned int    ovsel:3;
    unsigned int    wdc:4;
    unsigned int    reserved_0:17;
    unsigned int    wden:8;
}mis_TCWCR;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    wdclr:1;
}mis_TCWTR;

typedef struct
{
    unsigned int    reserved_0:22;
    unsigned int    en:1;
    unsigned int    cnt:9;
}mis_CLK27M_CLK90K;

typedef struct
{
    unsigned int    cur_val:32;
}mis_CLK90K_TM_LO;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    cur_val:16;
}mis_CLK90K_TM_HI;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    rtcsec:7;
}mis_RTCSEC;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    rtcmin:6;
}mis_RTCMIN;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    rtchr:5;
}mis_RTCHR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    rtcdate1:8;
}mis_RTCDATE1;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    rtcdate2:6;
}mis_RTCDATE2;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    almmin:6;
}mis_ALMMIN;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    almhr:5;
}mis_ALMHR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    almdate1:8;
}mis_ALMDATE1;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    almdate2:6;
}mis_ALMDATE2;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    rtcstop:1;
}mis_RTCSTOP;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    bc:2;
}mis_RTCOSC;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    rtcrst:1;
    unsigned int    nrtcen:1;
    unsigned int    almen:1;
    unsigned int    dainte:1;
    unsigned int    huinte:1;
    unsigned int    muinte:1;
    unsigned int    hsuinte:1;
}mis_RTCCR;

typedef struct
{
    unsigned int    reserved_0:29;
    unsigned int    swen:1;
    unsigned int    clksel:1;
    unsigned int    envfd:1;
}mis_VFD_CTL;

typedef struct
{
    unsigned int    reserved_0:19;
    unsigned int    nact_csn:1;
    unsigned int    b3c:1;
    unsigned int    b2c:1;
    unsigned int    b1c:1;
    unsigned int    b0c:1;
    unsigned int    enb3:1;
    unsigned int    enb2:1;
    unsigned int    enb1:1;
    unsigned int    enb0:1;
    unsigned int    reserved_1:2;
    unsigned int    wd:1;
    unsigned int    wdie:1;
}mis_VFD_WRCTL;

typedef struct
{
    unsigned int    byte3:8;
    unsigned int    byte2:8;
    unsigned int    byte1:8;
    unsigned int    byte0:8;
}mis_VFDO;

typedef struct
{
    unsigned int    reserved_0:21;
    unsigned int    kpadbn:3;
    unsigned int    reserved_1:2;
    unsigned int    swha:1;
    unsigned int    kpadha:1;
    unsigned int    reserved_2:2;
    unsigned int    ardp:2;
}mis_VFD_ARDCTL;

typedef struct
{
    unsigned int    kpadie:32;
}mis_VFD_KPADLIE;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    kpadie:16;
}mis_VFD_KPADHIE;

typedef struct
{
    unsigned int    reserved_0:28;
    unsigned int    swie:4;
}mis_VFD_SWIE;

typedef struct
{
    unsigned int    st:32;
}mis_VFD_ARDKPADL;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    st:16;
}mis_VFD_ARDKPADH;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    reserveda:12;
    unsigned int    st:4;
}mis_VFD_ARDSW;
#endif

#define MIS_PSELH                                                     0x1801B000
#define MIS_PSELH_reg_addr                                            "0xB801B000"
#define MIS_PSELH_reg                                                 0xB801B000
#define MIS_PSELH_inst_addr                                           "0x0000"
#define MIS_PSELH_inst                                                0x0000
#define MIS_PSELH_psel30_shift                                        (28)
#define MIS_PSELH_psel29_shift                                        (26)
#define MIS_PSELH_psel28_shift                                        (24)
#define MIS_PSELH_psel27_shift                                        (22)
#define MIS_PSELH_psel26_shift                                        (20)
#define MIS_PSELH_psel25_shift                                        (18)
#define MIS_PSELH_psel24_shift                                        (16)
#define MIS_PSELH_psel23_shift                                        (14)
#define MIS_PSELH_psel22_shift                                        (12)
#define MIS_PSELH_psel21_shift                                        (10)
#define MIS_PSELH_psel20_shift                                        (8)
#define MIS_PSELH_psel19_shift                                        (6)
#define MIS_PSELH_psel18_shift                                        (4)
#define MIS_PSELH_psel17_shift                                        (2)
#define MIS_PSELH_psel16_shift                                        (0)
#define MIS_PSELH_psel30_mask                                         (0x30000000)
#define MIS_PSELH_psel29_mask                                         (0x0C000000)
#define MIS_PSELH_psel28_mask                                         (0x03000000)
#define MIS_PSELH_psel27_mask                                         (0x00C00000)
#define MIS_PSELH_psel26_mask                                         (0x00300000)
#define MIS_PSELH_psel25_mask                                         (0x000C0000)
#define MIS_PSELH_psel24_mask                                         (0x00030000)
#define MIS_PSELH_psel23_mask                                         (0x0000C000)
#define MIS_PSELH_psel22_mask                                         (0x00003000)
#define MIS_PSELH_psel21_mask                                         (0x00000C00)
#define MIS_PSELH_psel20_mask                                         (0x00000300)
#define MIS_PSELH_psel19_mask                                         (0x000000C0)
#define MIS_PSELH_psel18_mask                                         (0x00000030)
#define MIS_PSELH_psel17_mask                                         (0x0000000C)
#define MIS_PSELH_psel16_mask                                         (0x00000003)
#define MIS_PSELH_psel30(data)                                        (0x30000000&((data)<<28))
#define MIS_PSELH_psel29(data)                                        (0x0C000000&((data)<<26))
#define MIS_PSELH_psel28(data)                                        (0x03000000&((data)<<24))
#define MIS_PSELH_psel27(data)                                        (0x00C00000&((data)<<22))
#define MIS_PSELH_psel26(data)                                        (0x00300000&((data)<<20))
#define MIS_PSELH_psel25(data)                                        (0x000C0000&((data)<<18))
#define MIS_PSELH_psel24(data)                                        (0x00030000&((data)<<16))
#define MIS_PSELH_psel23(data)                                        (0x0000C000&((data)<<14))
#define MIS_PSELH_psel22(data)                                        (0x00003000&((data)<<12))
#define MIS_PSELH_psel21(data)                                        (0x00000C00&((data)<<10))
#define MIS_PSELH_psel20(data)                                        (0x00000300&((data)<<8))
#define MIS_PSELH_psel19(data)                                        (0x000000C0&((data)<<6))
#define MIS_PSELH_psel18(data)                                        (0x00000030&((data)<<4))
#define MIS_PSELH_psel17(data)                                        (0x0000000C&((data)<<2))
#define MIS_PSELH_psel16(data)                                        (0x00000003&(data))
#define MIS_PSELH_get_psel30(data)                                    ((0x30000000&(data))>>28)
#define MIS_PSELH_get_psel29(data)                                    ((0x0C000000&(data))>>26)
#define MIS_PSELH_get_psel28(data)                                    ((0x03000000&(data))>>24)
#define MIS_PSELH_get_psel27(data)                                    ((0x00C00000&(data))>>22)
#define MIS_PSELH_get_psel26(data)                                    ((0x00300000&(data))>>20)
#define MIS_PSELH_get_psel25(data)                                    ((0x000C0000&(data))>>18)
#define MIS_PSELH_get_psel24(data)                                    ((0x00030000&(data))>>16)
#define MIS_PSELH_get_psel23(data)                                    ((0x0000C000&(data))>>14)
#define MIS_PSELH_get_psel22(data)                                    ((0x00003000&(data))>>12)
#define MIS_PSELH_get_psel21(data)                                    ((0x00000C00&(data))>>10)
#define MIS_PSELH_get_psel20(data)                                    ((0x00000300&(data))>>8)
#define MIS_PSELH_get_psel19(data)                                    ((0x000000C0&(data))>>6)
#define MIS_PSELH_get_psel18(data)                                    ((0x00000030&(data))>>4)
#define MIS_PSELH_get_psel17(data)                                    ((0x0000000C&(data))>>2)
#define MIS_PSELH_get_psel16(data)                                    (0x00000003&(data))

#define MIS_PSELL                                                     0x1801B004
#define MIS_PSELL_reg_addr                                            "0xB801B004"
#define MIS_PSELL_reg                                                 0xB801B004
#define MIS_PSELL_inst_addr                                           "0x0001"
#define MIS_PSELL_inst                                                0x0001
#define MIS_PSELL_psel15_shift                                        (30)
#define MIS_PSELL_psel14_shift                                        (28)
#define MIS_PSELL_psel13_shift                                        (26)
#define MIS_PSELL_psel8_shift                                         (16)
#define MIS_PSELL_psel7_shift                                         (14)
#define MIS_PSELL_psel6_shift                                         (12)
#define MIS_PSELL_psel5_shift                                         (10)
#define MIS_PSELL_psel4_shift                                         (8)
#define MIS_PSELL_psel3_shift                                         (6)
#define MIS_PSELL_psel2_shift                                         (4)
#define MIS_PSELL_psel1_shift                                         (2)
#define MIS_PSELL_psel0_shift                                         (0)
#define MIS_PSELL_psel15_mask                                         (0xC0000000)
#define MIS_PSELL_psel14_mask                                         (0x30000000)
#define MIS_PSELL_psel13_mask                                         (0x0C000000)
#define MIS_PSELL_psel8_mask                                          (0x00030000)
#define MIS_PSELL_psel7_mask                                          (0x0000C000)
#define MIS_PSELL_psel6_mask                                          (0x00003000)
#define MIS_PSELL_psel5_mask                                          (0x00000C00)
#define MIS_PSELL_psel4_mask                                          (0x00000300)
#define MIS_PSELL_psel3_mask                                          (0x000000C0)
#define MIS_PSELL_psel2_mask                                          (0x00000030)
#define MIS_PSELL_psel1_mask                                          (0x0000000C)
#define MIS_PSELL_psel0_mask                                          (0x00000003)
#define MIS_PSELL_psel15(data)                                        (0xC0000000&((data)<<30))
#define MIS_PSELL_psel14(data)                                        (0x30000000&((data)<<28))
#define MIS_PSELL_psel13(data)                                        (0x0C000000&((data)<<26))
#define MIS_PSELL_psel8(data)                                         (0x00030000&((data)<<16))
#define MIS_PSELL_psel7(data)                                         (0x0000C000&((data)<<14))
#define MIS_PSELL_psel6(data)                                         (0x00003000&((data)<<12))
#define MIS_PSELL_psel5(data)                                         (0x00000C00&((data)<<10))
#define MIS_PSELL_psel4(data)                                         (0x00000300&((data)<<8))
#define MIS_PSELL_psel3(data)                                         (0x000000C0&((data)<<6))
#define MIS_PSELL_psel2(data)                                         (0x00000030&((data)<<4))
#define MIS_PSELL_psel1(data)                                         (0x0000000C&((data)<<2))
#define MIS_PSELL_psel0(data)                                         (0x00000003&(data))
#define MIS_PSELL_get_psel15(data)                                    ((0xC0000000&(data))>>30)
#define MIS_PSELL_get_psel14(data)                                    ((0x30000000&(data))>>28)
#define MIS_PSELL_get_psel13(data)                                    ((0x0C000000&(data))>>26)
#define MIS_PSELL_get_psel8(data)                                     ((0x00030000&(data))>>16)
#define MIS_PSELL_get_psel7(data)                                     ((0x0000C000&(data))>>14)
#define MIS_PSELL_get_psel6(data)                                     ((0x00003000&(data))>>12)
#define MIS_PSELL_get_psel5(data)                                     ((0x00000C00&(data))>>10)
#define MIS_PSELL_get_psel4(data)                                     ((0x00000300&(data))>>8)
#define MIS_PSELL_get_psel3(data)                                     ((0x000000C0&(data))>>6)
#define MIS_PSELL_get_psel2(data)                                     ((0x00000030&(data))>>4)
#define MIS_PSELL_get_psel1(data)                                     ((0x0000000C&(data))>>2)
#define MIS_PSELL_get_psel0(data)                                     (0x00000003&(data))

#define MIS_UMSK_ISR                                                  0x1801B008
#define MIS_UMSK_ISR_reg_addr                                         "0xB801B008"
#define MIS_UMSK_ISR_reg                                              0xB801B008
#define MIS_UMSK_ISR_inst_addr                                        "0x0002"
#define MIS_UMSK_ISR_inst                                             0x0002
#define MIS_UMSK_ISR_gpioda_int_shift                                 (20)
#define MIS_UMSK_ISR_gpioa_int_shift                                  (19)
#define MIS_UMSK_ISR_vfd_ardswda_int_shift                            (18)
#define MIS_UMSK_ISR_vfd_ardswa_int_shift                             (17)
#define MIS_UMSK_ISR_vfd_ardkpadda_int_shift                          (16)
#define MIS_UMSK_ISR_vfd_ardkpada_int_shift                           (15)
#define MIS_UMSK_ISR_vfd_wdone_int_shift                              (14)
#define MIS_UMSK_ISR_rtc_alarm_int_shift                              (13)
#define MIS_UMSK_ISR_rtc_date_int_shift                               (12)
#define MIS_UMSK_ISR_rtc_hour_int_shift                               (11)
#define MIS_UMSK_ISR_rtc_min_int_shift                                (10)
#define MIS_UMSK_ISR_rtc_hsec_int_shift                               (9)
#define MIS_UMSK_ISR_tc2_int_shift                                    (8)
#define MIS_UMSK_ISR_tc1_int_shift                                    (7)
#define MIS_UMSK_ISR_tc0_int_shift                                    (6)
#define MIS_UMSK_ISR_write_data_shift                                 (0)
#define MIS_UMSK_ISR_gpioda_int_mask                                  (0x00100000)
#define MIS_UMSK_ISR_gpioa_int_mask                                   (0x00080000)
#define MIS_UMSK_ISR_vfd_ardswda_int_mask                             (0x00040000)
#define MIS_UMSK_ISR_vfd_ardswa_int_mask                              (0x00020000)
#define MIS_UMSK_ISR_vfd_ardkpadda_int_mask                           (0x00010000)
#define MIS_UMSK_ISR_vfd_ardkpada_int_mask                            (0x00008000)
#define MIS_UMSK_ISR_vfd_wdone_int_mask                               (0x00004000)
#define MIS_UMSK_ISR_rtc_alarm_int_mask                               (0x00002000)
#define MIS_UMSK_ISR_rtc_date_int_mask                                (0x00001000)
#define MIS_UMSK_ISR_rtc_hour_int_mask                                (0x00000800)
#define MIS_UMSK_ISR_rtc_min_int_mask                                 (0x00000400)
#define MIS_UMSK_ISR_rtc_hsec_int_mask                                (0x00000200)
#define MIS_UMSK_ISR_tc2_int_mask                                     (0x00000100)
#define MIS_UMSK_ISR_tc1_int_mask                                     (0x00000080)
#define MIS_UMSK_ISR_tc0_int_mask                                     (0x00000040)
#define MIS_UMSK_ISR_write_data_mask                                  (0x00000001)
#define MIS_UMSK_ISR_gpioda_int(data)                                 (0x00100000&((data)<<20))
#define MIS_UMSK_ISR_gpioa_int(data)                                  (0x00080000&((data)<<19))
#define MIS_UMSK_ISR_vfd_ardswda_int(data)                            (0x00040000&((data)<<18))
#define MIS_UMSK_ISR_vfd_ardswa_int(data)                             (0x00020000&((data)<<17))
#define MIS_UMSK_ISR_vfd_ardkpadda_int(data)                          (0x00010000&((data)<<16))
#define MIS_UMSK_ISR_vfd_ardkpada_int(data)                           (0x00008000&((data)<<15))
#define MIS_UMSK_ISR_vfd_wdone_int(data)                              (0x00004000&((data)<<14))
#define MIS_UMSK_ISR_rtc_alarm_int(data)                              (0x00002000&((data)<<13))
#define MIS_UMSK_ISR_rtc_date_int(data)                               (0x00001000&((data)<<12))
#define MIS_UMSK_ISR_rtc_hour_int(data)                               (0x00000800&((data)<<11))
#define MIS_UMSK_ISR_rtc_min_int(data)                                (0x00000400&((data)<<10))
#define MIS_UMSK_ISR_rtc_hsec_int(data)                               (0x00000200&((data)<<9))
#define MIS_UMSK_ISR_tc2_int(data)                                    (0x00000100&((data)<<8))
#define MIS_UMSK_ISR_tc1_int(data)                                    (0x00000080&((data)<<7))
#define MIS_UMSK_ISR_tc0_int(data)                                    (0x00000040&((data)<<6))
#define MIS_UMSK_ISR_write_data(data)                                 (0x00000001&(data))
#define MIS_UMSK_ISR_get_gpioda_int(data)                             ((0x00100000&(data))>>20)
#define MIS_UMSK_ISR_get_gpioa_int(data)                              ((0x00080000&(data))>>19)
#define MIS_UMSK_ISR_get_vfd_ardswda_int(data)                        ((0x00040000&(data))>>18)
#define MIS_UMSK_ISR_get_vfd_ardswa_int(data)                         ((0x00020000&(data))>>17)
#define MIS_UMSK_ISR_get_vfd_ardkpadda_int(data)                      ((0x00010000&(data))>>16)
#define MIS_UMSK_ISR_get_vfd_ardkpada_int(data)                       ((0x00008000&(data))>>15)
#define MIS_UMSK_ISR_get_vfd_wdone_int(data)                          ((0x00004000&(data))>>14)
#define MIS_UMSK_ISR_get_rtc_alarm_int(data)                          ((0x00002000&(data))>>13)
#define MIS_UMSK_ISR_get_rtc_date_int(data)                           ((0x00001000&(data))>>12)
#define MIS_UMSK_ISR_get_rtc_hour_int(data)                           ((0x00000800&(data))>>11)
#define MIS_UMSK_ISR_get_rtc_min_int(data)                            ((0x00000400&(data))>>10)
#define MIS_UMSK_ISR_get_rtc_hsec_int(data)                           ((0x00000200&(data))>>9)
#define MIS_UMSK_ISR_get_tc2_int(data)                                ((0x00000100&(data))>>8)
#define MIS_UMSK_ISR_get_tc1_int(data)                                ((0x00000080&(data))>>7)
#define MIS_UMSK_ISR_get_tc0_int(data)                                ((0x00000040&(data))>>6)
#define MIS_UMSK_ISR_get_write_data(data)                             (0x00000001&(data))

#define MIS_ISR                                                       0x1801B00C
#define MIS_ISR_reg_addr                                              "0xB801B00C"
#define MIS_ISR_reg                                                   0xB801B00C
#define MIS_ISR_inst_addr                                             "0x0003"
#define MIS_ISR_inst                                                  0x0003
#define MIS_ISR_gpioda_int_shift                                      (20)
#define MIS_ISR_gpioa_int_shift                                       (19)
#define MIS_ISR_vfd_ardswda_int_shift                                 (18)
#define MIS_ISR_vfd_ardswa_int_shift                                  (17)
#define MIS_ISR_vfd_ardkpadda_int_shift                               (16)
#define MIS_ISR_vfd_ardkpada_int_shift                                (15)
#define MIS_ISR_vfd_wdone_int_shift                                   (14)
#define MIS_ISR_rtc_alarm_int_shift                                   (13)
#define MIS_ISR_rtc_date_int_shift                                    (12)
#define MIS_ISR_rtc_hour_int_shift                                    (11)
#define MIS_ISR_rtc_min_int_shift                                     (10)
#define MIS_ISR_rtc_hsec_int_shift                                    (9)
#define MIS_ISR_tc2_int_shift                                         (8)
#define MIS_ISR_tc1_int_shift                                         (7)
#define MIS_ISR_tc0_int_shift                                         (6)
#define MIS_ISR_irda_int_shift                                        (5)
#define MIS_ISR_i2c_int_shift                                         (4)
#define MIS_ISR_ur1_int_shift                                         (3)
#define MIS_ISR_ur0_int_shift                                         (2)
#define MIS_ISR_write_data_shift                                      (0)
#define MIS_ISR_gpioda_int_mask                                       (0x00100000)
#define MIS_ISR_gpioa_int_mask                                        (0x00080000)
#define MIS_ISR_vfd_ardswda_int_mask                                  (0x00040000)
#define MIS_ISR_vfd_ardswa_int_mask                                   (0x00020000)
#define MIS_ISR_vfd_ardkpadda_int_mask                                (0x00010000)
#define MIS_ISR_vfd_ardkpada_int_mask                                 (0x00008000)
#define MIS_ISR_vfd_wdone_int_mask                                    (0x00004000)
#define MIS_ISR_rtc_alarm_int_mask                                    (0x00002000)
#define MIS_ISR_rtc_date_int_mask                                     (0x00001000)
#define MIS_ISR_rtc_hour_int_mask                                     (0x00000800)
#define MIS_ISR_rtc_min_int_mask                                      (0x00000400)
#define MIS_ISR_rtc_hsec_int_mask                                     (0x00000200)
#define MIS_ISR_tc2_int_mask                                          (0x00000100)
#define MIS_ISR_tc1_int_mask                                          (0x00000080)
#define MIS_ISR_tc0_int_mask                                          (0x00000040)
#define MIS_ISR_irda_int_mask                                         (0x00000020)
#define MIS_ISR_i2c_int_mask                                          (0x00000010)
#define MIS_ISR_ur1_int_mask                                          (0x00000008)
#define MIS_ISR_ur0_int_mask                                          (0x00000004)
#define MIS_ISR_write_data_mask                                       (0x00000001)
#define MIS_ISR_gpioda_int(data)                                      (0x00100000&((data)<<20))
#define MIS_ISR_gpioa_int(data)                                       (0x00080000&((data)<<19))
#define MIS_ISR_vfd_ardswda_int(data)                                 (0x00040000&((data)<<18))
#define MIS_ISR_vfd_ardswa_int(data)                                  (0x00020000&((data)<<17))
#define MIS_ISR_vfd_ardkpadda_int(data)                               (0x00010000&((data)<<16))
#define MIS_ISR_vfd_ardkpada_int(data)                                (0x00008000&((data)<<15))
#define MIS_ISR_vfd_wdone_int(data)                                   (0x00004000&((data)<<14))
#define MIS_ISR_rtc_alarm_int(data)                                   (0x00002000&((data)<<13))
#define MIS_ISR_rtc_date_int(data)                                    (0x00001000&((data)<<12))
#define MIS_ISR_rtc_hour_int(data)                                    (0x00000800&((data)<<11))
#define MIS_ISR_rtc_min_int(data)                                     (0x00000400&((data)<<10))
#define MIS_ISR_rtc_hsec_int(data)                                    (0x00000200&((data)<<9))
#define MIS_ISR_tc2_int(data)                                         (0x00000100&((data)<<8))
#define MIS_ISR_tc1_int(data)                                         (0x00000080&((data)<<7))
#define MIS_ISR_tc0_int(data)                                         (0x00000040&((data)<<6))
#define MIS_ISR_irda_int(data)                                        (0x00000020&((data)<<5))
#define MIS_ISR_i2c_int(data)                                         (0x00000010&((data)<<4))
#define MIS_ISR_ur1_int(data)                                         (0x00000008&((data)<<3))
#define MIS_ISR_ur0_int(data)                                         (0x00000004&((data)<<2))
#define MIS_ISR_write_data(data)                                      (0x00000001&(data))
#define MIS_ISR_get_gpioda_int(data)                                  ((0x00100000&(data))>>20)
#define MIS_ISR_get_gpioa_int(data)                                   ((0x00080000&(data))>>19)
#define MIS_ISR_get_vfd_ardswda_int(data)                             ((0x00040000&(data))>>18)
#define MIS_ISR_get_vfd_ardswa_int(data)                              ((0x00020000&(data))>>17)
#define MIS_ISR_get_vfd_ardkpadda_int(data)                           ((0x00010000&(data))>>16)
#define MIS_ISR_get_vfd_ardkpada_int(data)                            ((0x00008000&(data))>>15)
#define MIS_ISR_get_vfd_wdone_int(data)                               ((0x00004000&(data))>>14)
#define MIS_ISR_get_rtc_alarm_int(data)                               ((0x00002000&(data))>>13)
#define MIS_ISR_get_rtc_date_int(data)                                ((0x00001000&(data))>>12)
#define MIS_ISR_get_rtc_hour_int(data)                                ((0x00000800&(data))>>11)
#define MIS_ISR_get_rtc_min_int(data)                                 ((0x00000400&(data))>>10)
#define MIS_ISR_get_rtc_hsec_int(data)                                ((0x00000200&(data))>>9)
#define MIS_ISR_get_tc2_int(data)                                     ((0x00000100&(data))>>8)
#define MIS_ISR_get_tc1_int(data)                                     ((0x00000080&(data))>>7)
#define MIS_ISR_get_tc0_int(data)                                     ((0x00000040&(data))>>6)
#define MIS_ISR_get_irda_int(data)                                    ((0x00000020&(data))>>5)
#define MIS_ISR_get_i2c_int(data)                                     ((0x00000010&(data))>>4)
#define MIS_ISR_get_ur1_int(data)                                     ((0x00000008&(data))>>3)
#define MIS_ISR_get_ur0_int(data)                                     ((0x00000004&(data))>>2)
#define MIS_ISR_get_write_data(data)                                  (0x00000001&(data))

#define MIS_UMSK_ISR_GPA                                              0x1801B010
#define MIS_UMSK_ISR_GPA_reg_addr                                     "0xB801B010"
#define MIS_UMSK_ISR_GPA_reg                                          0xB801B010
#define MIS_UMSK_ISR_GPA_inst_addr                                    "0x0004"
#define MIS_UMSK_ISR_GPA_inst                                         0x0004
#define MIS_UMSK_ISR_GPA_int30_shift                                  (31)
#define MIS_UMSK_ISR_GPA_int29_shift                                  (30)
#define MIS_UMSK_ISR_GPA_int28_shift                                  (29)
#define MIS_UMSK_ISR_GPA_int27_shift                                  (28)
#define MIS_UMSK_ISR_GPA_int26_shift                                  (27)
#define MIS_UMSK_ISR_GPA_int25_shift                                  (26)
#define MIS_UMSK_ISR_GPA_int24_shift                                  (25)
#define MIS_UMSK_ISR_GPA_int23_shift                                  (24)
#define MIS_UMSK_ISR_GPA_int22_shift                                  (23)
#define MIS_UMSK_ISR_GPA_int21_shift                                  (22)
#define MIS_UMSK_ISR_GPA_int20_shift                                  (21)
#define MIS_UMSK_ISR_GPA_int19_shift                                  (20)
#define MIS_UMSK_ISR_GPA_int18_shift                                  (19)
#define MIS_UMSK_ISR_GPA_int17_shift                                  (18)
#define MIS_UMSK_ISR_GPA_int16_shift                                  (17)
#define MIS_UMSK_ISR_GPA_int15_shift                                  (16)
#define MIS_UMSK_ISR_GPA_int14_shift                                  (15)
#define MIS_UMSK_ISR_GPA_int13_shift                                  (14)
#define MIS_UMSK_ISR_GPA_int12_shift                                  (13)
#define MIS_UMSK_ISR_GPA_int11_shift                                  (12)
#define MIS_UMSK_ISR_GPA_int10_shift                                  (11)
#define MIS_UMSK_ISR_GPA_int9_shift                                   (10)
#define MIS_UMSK_ISR_GPA_int8_shift                                   (9)
#define MIS_UMSK_ISR_GPA_int7_shift                                   (8)
#define MIS_UMSK_ISR_GPA_int6_shift                                   (7)
#define MIS_UMSK_ISR_GPA_int5_shift                                   (6)
#define MIS_UMSK_ISR_GPA_int4_shift                                   (5)
#define MIS_UMSK_ISR_GPA_int3_shift                                   (4)
#define MIS_UMSK_ISR_GPA_int2_shift                                   (3)
#define MIS_UMSK_ISR_GPA_int1_shift                                   (2)
#define MIS_UMSK_ISR_GPA_int0_shift                                   (1)
#define MIS_UMSK_ISR_GPA_write_data_shift                             (0)
#define MIS_UMSK_ISR_GPA_int30_mask                                   (0x80000000)
#define MIS_UMSK_ISR_GPA_int29_mask                                   (0x40000000)
#define MIS_UMSK_ISR_GPA_int28_mask                                   (0x20000000)
#define MIS_UMSK_ISR_GPA_int27_mask                                   (0x10000000)
#define MIS_UMSK_ISR_GPA_int26_mask                                   (0x08000000)
#define MIS_UMSK_ISR_GPA_int25_mask                                   (0x04000000)
#define MIS_UMSK_ISR_GPA_int24_mask                                   (0x02000000)
#define MIS_UMSK_ISR_GPA_int23_mask                                   (0x01000000)
#define MIS_UMSK_ISR_GPA_int22_mask                                   (0x00800000)
#define MIS_UMSK_ISR_GPA_int21_mask                                   (0x00400000)
#define MIS_UMSK_ISR_GPA_int20_mask                                   (0x00200000)
#define MIS_UMSK_ISR_GPA_int19_mask                                   (0x00100000)
#define MIS_UMSK_ISR_GPA_int18_mask                                   (0x00080000)
#define MIS_UMSK_ISR_GPA_int17_mask                                   (0x00040000)
#define MIS_UMSK_ISR_GPA_int16_mask                                   (0x00020000)
#define MIS_UMSK_ISR_GPA_int15_mask                                   (0x00010000)
#define MIS_UMSK_ISR_GPA_int14_mask                                   (0x00008000)
#define MIS_UMSK_ISR_GPA_int13_mask                                   (0x00004000)
#define MIS_UMSK_ISR_GPA_int12_mask                                   (0x00002000)
#define MIS_UMSK_ISR_GPA_int11_mask                                   (0x00001000)
#define MIS_UMSK_ISR_GPA_int10_mask                                   (0x00000800)
#define MIS_UMSK_ISR_GPA_int9_mask                                    (0x00000400)
#define MIS_UMSK_ISR_GPA_int8_mask                                    (0x00000200)
#define MIS_UMSK_ISR_GPA_int7_mask                                    (0x00000100)
#define MIS_UMSK_ISR_GPA_int6_mask                                    (0x00000080)
#define MIS_UMSK_ISR_GPA_int5_mask                                    (0x00000040)
#define MIS_UMSK_ISR_GPA_int4_mask                                    (0x00000020)
#define MIS_UMSK_ISR_GPA_int3_mask                                    (0x00000010)
#define MIS_UMSK_ISR_GPA_int2_mask                                    (0x00000008)
#define MIS_UMSK_ISR_GPA_int1_mask                                    (0x00000004)
#define MIS_UMSK_ISR_GPA_int0_mask                                    (0x00000002)
#define MIS_UMSK_ISR_GPA_write_data_mask                              (0x00000001)
#define MIS_UMSK_ISR_GPA_int30(data)                                  (0x80000000&((data)<<31))
#define MIS_UMSK_ISR_GPA_int29(data)                                  (0x40000000&((data)<<30))
#define MIS_UMSK_ISR_GPA_int28(data)                                  (0x20000000&((data)<<29))
#define MIS_UMSK_ISR_GPA_int27(data)                                  (0x10000000&((data)<<28))
#define MIS_UMSK_ISR_GPA_int26(data)                                  (0x08000000&((data)<<27))
#define MIS_UMSK_ISR_GPA_int25(data)                                  (0x04000000&((data)<<26))
#define MIS_UMSK_ISR_GPA_int24(data)                                  (0x02000000&((data)<<25))
#define MIS_UMSK_ISR_GPA_int23(data)                                  (0x01000000&((data)<<24))
#define MIS_UMSK_ISR_GPA_int22(data)                                  (0x00800000&((data)<<23))
#define MIS_UMSK_ISR_GPA_int21(data)                                  (0x00400000&((data)<<22))
#define MIS_UMSK_ISR_GPA_int20(data)                                  (0x00200000&((data)<<21))
#define MIS_UMSK_ISR_GPA_int19(data)                                  (0x00100000&((data)<<20))
#define MIS_UMSK_ISR_GPA_int18(data)                                  (0x00080000&((data)<<19))
#define MIS_UMSK_ISR_GPA_int17(data)                                  (0x00040000&((data)<<18))
#define MIS_UMSK_ISR_GPA_int16(data)                                  (0x00020000&((data)<<17))
#define MIS_UMSK_ISR_GPA_int15(data)                                  (0x00010000&((data)<<16))
#define MIS_UMSK_ISR_GPA_int14(data)                                  (0x00008000&((data)<<15))
#define MIS_UMSK_ISR_GPA_int13(data)                                  (0x00004000&((data)<<14))
#define MIS_UMSK_ISR_GPA_int12(data)                                  (0x00002000&((data)<<13))
#define MIS_UMSK_ISR_GPA_int11(data)                                  (0x00001000&((data)<<12))
#define MIS_UMSK_ISR_GPA_int10(data)                                  (0x00000800&((data)<<11))
#define MIS_UMSK_ISR_GPA_int9(data)                                   (0x00000400&((data)<<10))
#define MIS_UMSK_ISR_GPA_int8(data)                                   (0x00000200&((data)<<9))
#define MIS_UMSK_ISR_GPA_int7(data)                                   (0x00000100&((data)<<8))
#define MIS_UMSK_ISR_GPA_int6(data)                                   (0x00000080&((data)<<7))
#define MIS_UMSK_ISR_GPA_int5(data)                                   (0x00000040&((data)<<6))
#define MIS_UMSK_ISR_GPA_int4(data)                                   (0x00000020&((data)<<5))
#define MIS_UMSK_ISR_GPA_int3(data)                                   (0x00000010&((data)<<4))
#define MIS_UMSK_ISR_GPA_int2(data)                                   (0x00000008&((data)<<3))
#define MIS_UMSK_ISR_GPA_int1(data)                                   (0x00000004&((data)<<2))
#define MIS_UMSK_ISR_GPA_int0(data)                                   (0x00000002&((data)<<1))
#define MIS_UMSK_ISR_GPA_write_data(data)                             (0x00000001&(data))
#define MIS_UMSK_ISR_GPA_get_int30(data)                              ((0x80000000&(data))>>31)
#define MIS_UMSK_ISR_GPA_get_int29(data)                              ((0x40000000&(data))>>30)
#define MIS_UMSK_ISR_GPA_get_int28(data)                              ((0x20000000&(data))>>29)
#define MIS_UMSK_ISR_GPA_get_int27(data)                              ((0x10000000&(data))>>28)
#define MIS_UMSK_ISR_GPA_get_int26(data)                              ((0x08000000&(data))>>27)
#define MIS_UMSK_ISR_GPA_get_int25(data)                              ((0x04000000&(data))>>26)
#define MIS_UMSK_ISR_GPA_get_int24(data)                              ((0x02000000&(data))>>25)
#define MIS_UMSK_ISR_GPA_get_int23(data)                              ((0x01000000&(data))>>24)
#define MIS_UMSK_ISR_GPA_get_int22(data)                              ((0x00800000&(data))>>23)
#define MIS_UMSK_ISR_GPA_get_int21(data)                              ((0x00400000&(data))>>22)
#define MIS_UMSK_ISR_GPA_get_int20(data)                              ((0x00200000&(data))>>21)
#define MIS_UMSK_ISR_GPA_get_int19(data)                              ((0x00100000&(data))>>20)
#define MIS_UMSK_ISR_GPA_get_int18(data)                              ((0x00080000&(data))>>19)
#define MIS_UMSK_ISR_GPA_get_int17(data)                              ((0x00040000&(data))>>18)
#define MIS_UMSK_ISR_GPA_get_int16(data)                              ((0x00020000&(data))>>17)
#define MIS_UMSK_ISR_GPA_get_int15(data)                              ((0x00010000&(data))>>16)
#define MIS_UMSK_ISR_GPA_get_int14(data)                              ((0x00008000&(data))>>15)
#define MIS_UMSK_ISR_GPA_get_int13(data)                              ((0x00004000&(data))>>14)
#define MIS_UMSK_ISR_GPA_get_int12(data)                              ((0x00002000&(data))>>13)
#define MIS_UMSK_ISR_GPA_get_int11(data)                              ((0x00001000&(data))>>12)
#define MIS_UMSK_ISR_GPA_get_int10(data)                              ((0x00000800&(data))>>11)
#define MIS_UMSK_ISR_GPA_get_int9(data)                               ((0x00000400&(data))>>10)
#define MIS_UMSK_ISR_GPA_get_int8(data)                               ((0x00000200&(data))>>9)
#define MIS_UMSK_ISR_GPA_get_int7(data)                               ((0x00000100&(data))>>8)
#define MIS_UMSK_ISR_GPA_get_int6(data)                               ((0x00000080&(data))>>7)
#define MIS_UMSK_ISR_GPA_get_int5(data)                               ((0x00000040&(data))>>6)
#define MIS_UMSK_ISR_GPA_get_int4(data)                               ((0x00000020&(data))>>5)
#define MIS_UMSK_ISR_GPA_get_int3(data)                               ((0x00000010&(data))>>4)
#define MIS_UMSK_ISR_GPA_get_int2(data)                               ((0x00000008&(data))>>3)
#define MIS_UMSK_ISR_GPA_get_int1(data)                               ((0x00000004&(data))>>2)
#define MIS_UMSK_ISR_GPA_get_int0(data)                               ((0x00000002&(data))>>1)
#define MIS_UMSK_ISR_GPA_get_write_data(data)                         (0x00000001&(data))

#define MIS_UMSK_ISR_GPDA                                             0x1801B014
#define MIS_UMSK_ISR_GPDA_reg_addr                                    "0xB801B014"
#define MIS_UMSK_ISR_GPDA_reg                                         0xB801B014
#define MIS_UMSK_ISR_GPDA_inst_addr                                   "0x0005"
#define MIS_UMSK_ISR_GPDA_inst                                        0x0005
#define MIS_UMSK_ISR_GPDA_int30_shift                                 (31)
#define MIS_UMSK_ISR_GPDA_int29_shift                                 (30)
#define MIS_UMSK_ISR_GPDA_int28_shift                                 (29)
#define MIS_UMSK_ISR_GPDA_int27_shift                                 (28)
#define MIS_UMSK_ISR_GPDA_int26_shift                                 (27)
#define MIS_UMSK_ISR_GPDA_int25_shift                                 (26)
#define MIS_UMSK_ISR_GPDA_int24_shift                                 (25)
#define MIS_UMSK_ISR_GPDA_int23_shift                                 (24)
#define MIS_UMSK_ISR_GPDA_int22_shift                                 (23)
#define MIS_UMSK_ISR_GPDA_int21_shift                                 (22)
#define MIS_UMSK_ISR_GPDA_int20_shift                                 (21)
#define MIS_UMSK_ISR_GPDA_int19_shift                                 (20)
#define MIS_UMSK_ISR_GPDA_int18_shift                                 (19)
#define MIS_UMSK_ISR_GPDA_int17_shift                                 (18)
#define MIS_UMSK_ISR_GPDA_int16_shift                                 (17)
#define MIS_UMSK_ISR_GPDA_int15_shift                                 (16)
#define MIS_UMSK_ISR_GPDA_int14_shift                                 (15)
#define MIS_UMSK_ISR_GPDA_int13_shift                                 (14)
#define MIS_UMSK_ISR_GPDA_int12_shift                                 (13)
#define MIS_UMSK_ISR_GPDA_int11_shift                                 (12)
#define MIS_UMSK_ISR_GPDA_int10_shift                                 (11)
#define MIS_UMSK_ISR_GPDA_int9_shift                                  (10)
#define MIS_UMSK_ISR_GPDA_int8_shift                                  (9)
#define MIS_UMSK_ISR_GPDA_int7_shift                                  (8)
#define MIS_UMSK_ISR_GPDA_int6_shift                                  (7)
#define MIS_UMSK_ISR_GPDA_int5_shift                                  (6)
#define MIS_UMSK_ISR_GPDA_int4_shift                                  (5)
#define MIS_UMSK_ISR_GPDA_int3_shift                                  (4)
#define MIS_UMSK_ISR_GPDA_int2_shift                                  (3)
#define MIS_UMSK_ISR_GPDA_int1_shift                                  (2)
#define MIS_UMSK_ISR_GPDA_int0_shift                                  (1)
#define MIS_UMSK_ISR_GPDA_write_data_shift                            (0)
#define MIS_UMSK_ISR_GPDA_int30_mask                                  (0x80000000)
#define MIS_UMSK_ISR_GPDA_int29_mask                                  (0x40000000)
#define MIS_UMSK_ISR_GPDA_int28_mask                                  (0x20000000)
#define MIS_UMSK_ISR_GPDA_int27_mask                                  (0x10000000)
#define MIS_UMSK_ISR_GPDA_int26_mask                                  (0x08000000)
#define MIS_UMSK_ISR_GPDA_int25_mask                                  (0x04000000)
#define MIS_UMSK_ISR_GPDA_int24_mask                                  (0x02000000)
#define MIS_UMSK_ISR_GPDA_int23_mask                                  (0x01000000)
#define MIS_UMSK_ISR_GPDA_int22_mask                                  (0x00800000)
#define MIS_UMSK_ISR_GPDA_int21_mask                                  (0x00400000)
#define MIS_UMSK_ISR_GPDA_int20_mask                                  (0x00200000)
#define MIS_UMSK_ISR_GPDA_int19_mask                                  (0x00100000)
#define MIS_UMSK_ISR_GPDA_int18_mask                                  (0x00080000)
#define MIS_UMSK_ISR_GPDA_int17_mask                                  (0x00040000)
#define MIS_UMSK_ISR_GPDA_int16_mask                                  (0x00020000)
#define MIS_UMSK_ISR_GPDA_int15_mask                                  (0x00010000)
#define MIS_UMSK_ISR_GPDA_int14_mask                                  (0x00008000)
#define MIS_UMSK_ISR_GPDA_int13_mask                                  (0x00004000)
#define MIS_UMSK_ISR_GPDA_int12_mask                                  (0x00002000)
#define MIS_UMSK_ISR_GPDA_int11_mask                                  (0x00001000)
#define MIS_UMSK_ISR_GPDA_int10_mask                                  (0x00000800)
#define MIS_UMSK_ISR_GPDA_int9_mask                                   (0x00000400)
#define MIS_UMSK_ISR_GPDA_int8_mask                                   (0x00000200)
#define MIS_UMSK_ISR_GPDA_int7_mask                                   (0x00000100)
#define MIS_UMSK_ISR_GPDA_int6_mask                                   (0x00000080)
#define MIS_UMSK_ISR_GPDA_int5_mask                                   (0x00000040)
#define MIS_UMSK_ISR_GPDA_int4_mask                                   (0x00000020)
#define MIS_UMSK_ISR_GPDA_int3_mask                                   (0x00000010)
#define MIS_UMSK_ISR_GPDA_int2_mask                                   (0x00000008)
#define MIS_UMSK_ISR_GPDA_int1_mask                                   (0x00000004)
#define MIS_UMSK_ISR_GPDA_int0_mask                                   (0x00000002)
#define MIS_UMSK_ISR_GPDA_write_data_mask                             (0x00000001)
#define MIS_UMSK_ISR_GPDA_int30(data)                                 (0x80000000&((data)<<31))
#define MIS_UMSK_ISR_GPDA_int29(data)                                 (0x40000000&((data)<<30))
#define MIS_UMSK_ISR_GPDA_int28(data)                                 (0x20000000&((data)<<29))
#define MIS_UMSK_ISR_GPDA_int27(data)                                 (0x10000000&((data)<<28))
#define MIS_UMSK_ISR_GPDA_int26(data)                                 (0x08000000&((data)<<27))
#define MIS_UMSK_ISR_GPDA_int25(data)                                 (0x04000000&((data)<<26))
#define MIS_UMSK_ISR_GPDA_int24(data)                                 (0x02000000&((data)<<25))
#define MIS_UMSK_ISR_GPDA_int23(data)                                 (0x01000000&((data)<<24))
#define MIS_UMSK_ISR_GPDA_int22(data)                                 (0x00800000&((data)<<23))
#define MIS_UMSK_ISR_GPDA_int21(data)                                 (0x00400000&((data)<<22))
#define MIS_UMSK_ISR_GPDA_int20(data)                                 (0x00200000&((data)<<21))
#define MIS_UMSK_ISR_GPDA_int19(data)                                 (0x00100000&((data)<<20))
#define MIS_UMSK_ISR_GPDA_int18(data)                                 (0x00080000&((data)<<19))
#define MIS_UMSK_ISR_GPDA_int17(data)                                 (0x00040000&((data)<<18))
#define MIS_UMSK_ISR_GPDA_int16(data)                                 (0x00020000&((data)<<17))
#define MIS_UMSK_ISR_GPDA_int15(data)                                 (0x00010000&((data)<<16))
#define MIS_UMSK_ISR_GPDA_int14(data)                                 (0x00008000&((data)<<15))
#define MIS_UMSK_ISR_GPDA_int13(data)                                 (0x00004000&((data)<<14))
#define MIS_UMSK_ISR_GPDA_int12(data)                                 (0x00002000&((data)<<13))
#define MIS_UMSK_ISR_GPDA_int11(data)                                 (0x00001000&((data)<<12))
#define MIS_UMSK_ISR_GPDA_int10(data)                                 (0x00000800&((data)<<11))
#define MIS_UMSK_ISR_GPDA_int9(data)                                  (0x00000400&((data)<<10))
#define MIS_UMSK_ISR_GPDA_int8(data)                                  (0x00000200&((data)<<9))
#define MIS_UMSK_ISR_GPDA_int7(data)                                  (0x00000100&((data)<<8))
#define MIS_UMSK_ISR_GPDA_int6(data)                                  (0x00000080&((data)<<7))
#define MIS_UMSK_ISR_GPDA_int5(data)                                  (0x00000040&((data)<<6))
#define MIS_UMSK_ISR_GPDA_int4(data)                                  (0x00000020&((data)<<5))
#define MIS_UMSK_ISR_GPDA_int3(data)                                  (0x00000010&((data)<<4))
#define MIS_UMSK_ISR_GPDA_int2(data)                                  (0x00000008&((data)<<3))
#define MIS_UMSK_ISR_GPDA_int1(data)                                  (0x00000004&((data)<<2))
#define MIS_UMSK_ISR_GPDA_int0(data)                                  (0x00000002&((data)<<1))
#define MIS_UMSK_ISR_GPDA_write_data(data)                            (0x00000001&(data))
#define MIS_UMSK_ISR_GPDA_get_int30(data)                             ((0x80000000&(data))>>31)
#define MIS_UMSK_ISR_GPDA_get_int29(data)                             ((0x40000000&(data))>>30)
#define MIS_UMSK_ISR_GPDA_get_int28(data)                             ((0x20000000&(data))>>29)
#define MIS_UMSK_ISR_GPDA_get_int27(data)                             ((0x10000000&(data))>>28)
#define MIS_UMSK_ISR_GPDA_get_int26(data)                             ((0x08000000&(data))>>27)
#define MIS_UMSK_ISR_GPDA_get_int25(data)                             ((0x04000000&(data))>>26)
#define MIS_UMSK_ISR_GPDA_get_int24(data)                             ((0x02000000&(data))>>25)
#define MIS_UMSK_ISR_GPDA_get_int23(data)                             ((0x01000000&(data))>>24)
#define MIS_UMSK_ISR_GPDA_get_int22(data)                             ((0x00800000&(data))>>23)
#define MIS_UMSK_ISR_GPDA_get_int21(data)                             ((0x00400000&(data))>>22)
#define MIS_UMSK_ISR_GPDA_get_int20(data)                             ((0x00200000&(data))>>21)
#define MIS_UMSK_ISR_GPDA_get_int19(data)                             ((0x00100000&(data))>>20)
#define MIS_UMSK_ISR_GPDA_get_int18(data)                             ((0x00080000&(data))>>19)
#define MIS_UMSK_ISR_GPDA_get_int17(data)                             ((0x00040000&(data))>>18)
#define MIS_UMSK_ISR_GPDA_get_int16(data)                             ((0x00020000&(data))>>17)
#define MIS_UMSK_ISR_GPDA_get_int15(data)                             ((0x00010000&(data))>>16)
#define MIS_UMSK_ISR_GPDA_get_int14(data)                             ((0x00008000&(data))>>15)
#define MIS_UMSK_ISR_GPDA_get_int13(data)                             ((0x00004000&(data))>>14)
#define MIS_UMSK_ISR_GPDA_get_int12(data)                             ((0x00002000&(data))>>13)
#define MIS_UMSK_ISR_GPDA_get_int11(data)                             ((0x00001000&(data))>>12)
#define MIS_UMSK_ISR_GPDA_get_int10(data)                             ((0x00000800&(data))>>11)
#define MIS_UMSK_ISR_GPDA_get_int9(data)                              ((0x00000400&(data))>>10)
#define MIS_UMSK_ISR_GPDA_get_int8(data)                              ((0x00000200&(data))>>9)
#define MIS_UMSK_ISR_GPDA_get_int7(data)                              ((0x00000100&(data))>>8)
#define MIS_UMSK_ISR_GPDA_get_int6(data)                              ((0x00000080&(data))>>7)
#define MIS_UMSK_ISR_GPDA_get_int5(data)                              ((0x00000040&(data))>>6)
#define MIS_UMSK_ISR_GPDA_get_int4(data)                              ((0x00000020&(data))>>5)
#define MIS_UMSK_ISR_GPDA_get_int3(data)                              ((0x00000010&(data))>>4)
#define MIS_UMSK_ISR_GPDA_get_int2(data)                              ((0x00000008&(data))>>3)
#define MIS_UMSK_ISR_GPDA_get_int1(data)                              ((0x00000004&(data))>>2)
#define MIS_UMSK_ISR_GPDA_get_int0(data)                              ((0x00000002&(data))>>1)
#define MIS_UMSK_ISR_GPDA_get_write_data(data)                        (0x00000001&(data))

#define MIS_UMSK_ISR_KPADAH                                           0x1801B018
#define MIS_UMSK_ISR_KPADAH_reg_addr                                  "0xB801B018"
#define MIS_UMSK_ISR_KPADAH_reg                                       0xB801B018
#define MIS_UMSK_ISR_KPADAH_inst_addr                                 "0x0006"
#define MIS_UMSK_ISR_KPADAH_inst                                      0x0006
#define MIS_UMSK_ISR_KPADAH_int47_shift                               (23)
#define MIS_UMSK_ISR_KPADAH_int46_shift                               (22)
#define MIS_UMSK_ISR_KPADAH_int45_shift                               (21)
#define MIS_UMSK_ISR_KPADAH_int44_shift                               (20)
#define MIS_UMSK_ISR_KPADAH_int43_shift                               (19)
#define MIS_UMSK_ISR_KPADAH_int42_shift                               (18)
#define MIS_UMSK_ISR_KPADAH_int41_shift                               (17)
#define MIS_UMSK_ISR_KPADAH_int40_shift                               (16)
#define MIS_UMSK_ISR_KPADAH_int39_shift                               (15)
#define MIS_UMSK_ISR_KPADAH_int38_shift                               (14)
#define MIS_UMSK_ISR_KPADAH_int37_shift                               (13)
#define MIS_UMSK_ISR_KPADAH_int36_shift                               (12)
#define MIS_UMSK_ISR_KPADAH_int35_shift                               (11)
#define MIS_UMSK_ISR_KPADAH_int34_shift                               (10)
#define MIS_UMSK_ISR_KPADAH_int33_shift                               (9)
#define MIS_UMSK_ISR_KPADAH_int32_shift                               (8)
#define MIS_UMSK_ISR_KPADAH_int31_shift                               (7)
#define MIS_UMSK_ISR_KPADAH_int30_shift                               (6)
#define MIS_UMSK_ISR_KPADAH_int29_shift                               (5)
#define MIS_UMSK_ISR_KPADAH_int28_shift                               (4)
#define MIS_UMSK_ISR_KPADAH_write_data_shift                          (0)
#define MIS_UMSK_ISR_KPADAH_int47_mask                                (0x00800000)
#define MIS_UMSK_ISR_KPADAH_int46_mask                                (0x00400000)
#define MIS_UMSK_ISR_KPADAH_int45_mask                                (0x00200000)
#define MIS_UMSK_ISR_KPADAH_int44_mask                                (0x00100000)
#define MIS_UMSK_ISR_KPADAH_int43_mask                                (0x00080000)
#define MIS_UMSK_ISR_KPADAH_int42_mask                                (0x00040000)
#define MIS_UMSK_ISR_KPADAH_int41_mask                                (0x00020000)
#define MIS_UMSK_ISR_KPADAH_int40_mask                                (0x00010000)
#define MIS_UMSK_ISR_KPADAH_int39_mask                                (0x00008000)
#define MIS_UMSK_ISR_KPADAH_int38_mask                                (0x00004000)
#define MIS_UMSK_ISR_KPADAH_int37_mask                                (0x00002000)
#define MIS_UMSK_ISR_KPADAH_int36_mask                                (0x00001000)
#define MIS_UMSK_ISR_KPADAH_int35_mask                                (0x00000800)
#define MIS_UMSK_ISR_KPADAH_int34_mask                                (0x00000400)
#define MIS_UMSK_ISR_KPADAH_int33_mask                                (0x00000200)
#define MIS_UMSK_ISR_KPADAH_int32_mask                                (0x00000100)
#define MIS_UMSK_ISR_KPADAH_int31_mask                                (0x00000080)
#define MIS_UMSK_ISR_KPADAH_int30_mask                                (0x00000040)
#define MIS_UMSK_ISR_KPADAH_int29_mask                                (0x00000020)
#define MIS_UMSK_ISR_KPADAH_int28_mask                                (0x00000010)
#define MIS_UMSK_ISR_KPADAH_write_data_mask                           (0x00000001)
#define MIS_UMSK_ISR_KPADAH_int47(data)                               (0x00800000&((data)<<23))
#define MIS_UMSK_ISR_KPADAH_int46(data)                               (0x00400000&((data)<<22))
#define MIS_UMSK_ISR_KPADAH_int45(data)                               (0x00200000&((data)<<21))
#define MIS_UMSK_ISR_KPADAH_int44(data)                               (0x00100000&((data)<<20))
#define MIS_UMSK_ISR_KPADAH_int43(data)                               (0x00080000&((data)<<19))
#define MIS_UMSK_ISR_KPADAH_int42(data)                               (0x00040000&((data)<<18))
#define MIS_UMSK_ISR_KPADAH_int41(data)                               (0x00020000&((data)<<17))
#define MIS_UMSK_ISR_KPADAH_int40(data)                               (0x00010000&((data)<<16))
#define MIS_UMSK_ISR_KPADAH_int39(data)                               (0x00008000&((data)<<15))
#define MIS_UMSK_ISR_KPADAH_int38(data)                               (0x00004000&((data)<<14))
#define MIS_UMSK_ISR_KPADAH_int37(data)                               (0x00002000&((data)<<13))
#define MIS_UMSK_ISR_KPADAH_int36(data)                               (0x00001000&((data)<<12))
#define MIS_UMSK_ISR_KPADAH_int35(data)                               (0x00000800&((data)<<11))
#define MIS_UMSK_ISR_KPADAH_int34(data)                               (0x00000400&((data)<<10))
#define MIS_UMSK_ISR_KPADAH_int33(data)                               (0x00000200&((data)<<9))
#define MIS_UMSK_ISR_KPADAH_int32(data)                               (0x00000100&((data)<<8))
#define MIS_UMSK_ISR_KPADAH_int31(data)                               (0x00000080&((data)<<7))
#define MIS_UMSK_ISR_KPADAH_int30(data)                               (0x00000040&((data)<<6))
#define MIS_UMSK_ISR_KPADAH_int29(data)                               (0x00000020&((data)<<5))
#define MIS_UMSK_ISR_KPADAH_int28(data)                               (0x00000010&((data)<<4))
#define MIS_UMSK_ISR_KPADAH_write_data(data)                          (0x00000001&(data))
#define MIS_UMSK_ISR_KPADAH_get_int47(data)                           ((0x00800000&(data))>>23)
#define MIS_UMSK_ISR_KPADAH_get_int46(data)                           ((0x00400000&(data))>>22)
#define MIS_UMSK_ISR_KPADAH_get_int45(data)                           ((0x00200000&(data))>>21)
#define MIS_UMSK_ISR_KPADAH_get_int44(data)                           ((0x00100000&(data))>>20)
#define MIS_UMSK_ISR_KPADAH_get_int43(data)                           ((0x00080000&(data))>>19)
#define MIS_UMSK_ISR_KPADAH_get_int42(data)                           ((0x00040000&(data))>>18)
#define MIS_UMSK_ISR_KPADAH_get_int41(data)                           ((0x00020000&(data))>>17)
#define MIS_UMSK_ISR_KPADAH_get_int40(data)                           ((0x00010000&(data))>>16)
#define MIS_UMSK_ISR_KPADAH_get_int39(data)                           ((0x00008000&(data))>>15)
#define MIS_UMSK_ISR_KPADAH_get_int38(data)                           ((0x00004000&(data))>>14)
#define MIS_UMSK_ISR_KPADAH_get_int37(data)                           ((0x00002000&(data))>>13)
#define MIS_UMSK_ISR_KPADAH_get_int36(data)                           ((0x00001000&(data))>>12)
#define MIS_UMSK_ISR_KPADAH_get_int35(data)                           ((0x00000800&(data))>>11)
#define MIS_UMSK_ISR_KPADAH_get_int34(data)                           ((0x00000400&(data))>>10)
#define MIS_UMSK_ISR_KPADAH_get_int33(data)                           ((0x00000200&(data))>>9)
#define MIS_UMSK_ISR_KPADAH_get_int32(data)                           ((0x00000100&(data))>>8)
#define MIS_UMSK_ISR_KPADAH_get_int31(data)                           ((0x00000080&(data))>>7)
#define MIS_UMSK_ISR_KPADAH_get_int30(data)                           ((0x00000040&(data))>>6)
#define MIS_UMSK_ISR_KPADAH_get_int29(data)                           ((0x00000020&(data))>>5)
#define MIS_UMSK_ISR_KPADAH_get_int28(data)                           ((0x00000010&(data))>>4)
#define MIS_UMSK_ISR_KPADAH_get_write_data(data)                      (0x00000001&(data))

#define MIS_UMSK_ISR_KPADAL                                           0x1801B01C
#define MIS_UMSK_ISR_KPADAL_reg_addr                                  "0xB801B01C"
#define MIS_UMSK_ISR_KPADAL_reg                                       0xB801B01C
#define MIS_UMSK_ISR_KPADAL_inst_addr                                 "0x0007"
#define MIS_UMSK_ISR_KPADAL_inst                                      0x0007
#define MIS_UMSK_ISR_KPADAL_int27_shift                               (31)
#define MIS_UMSK_ISR_KPADAL_int26_shift                               (30)
#define MIS_UMSK_ISR_KPADAL_int25_shift                               (29)
#define MIS_UMSK_ISR_KPADAL_int24_shift                               (28)
#define MIS_UMSK_ISR_KPADAL_int23_shift                               (27)
#define MIS_UMSK_ISR_KPADAL_int22_shift                               (26)
#define MIS_UMSK_ISR_KPADAL_int21_shift                               (25)
#define MIS_UMSK_ISR_KPADAL_int20_shift                               (24)
#define MIS_UMSK_ISR_KPADAL_int19_shift                               (23)
#define MIS_UMSK_ISR_KPADAL_int18_shift                               (22)
#define MIS_UMSK_ISR_KPADAL_int17_shift                               (21)
#define MIS_UMSK_ISR_KPADAL_int16_shift                               (20)
#define MIS_UMSK_ISR_KPADAL_int15_shift                               (19)
#define MIS_UMSK_ISR_KPADAL_int14_shift                               (18)
#define MIS_UMSK_ISR_KPADAL_int13_shift                               (17)
#define MIS_UMSK_ISR_KPADAL_int12_shift                               (16)
#define MIS_UMSK_ISR_KPADAL_int11_shift                               (15)
#define MIS_UMSK_ISR_KPADAL_int10_shift                               (14)
#define MIS_UMSK_ISR_KPADAL_int9_shift                                (13)
#define MIS_UMSK_ISR_KPADAL_int8_shift                                (12)
#define MIS_UMSK_ISR_KPADAL_int7_shift                                (11)
#define MIS_UMSK_ISR_KPADAL_int6_shift                                (10)
#define MIS_UMSK_ISR_KPADAL_int5_shift                                (9)
#define MIS_UMSK_ISR_KPADAL_int4_shift                                (8)
#define MIS_UMSK_ISR_KPADAL_int3_shift                                (7)
#define MIS_UMSK_ISR_KPADAL_int2_shift                                (6)
#define MIS_UMSK_ISR_KPADAL_int1_shift                                (5)
#define MIS_UMSK_ISR_KPADAL_int0_shift                                (4)
#define MIS_UMSK_ISR_KPADAL_write_data_shift                          (0)
#define MIS_UMSK_ISR_KPADAL_int27_mask                                (0x80000000)
#define MIS_UMSK_ISR_KPADAL_int26_mask                                (0x40000000)
#define MIS_UMSK_ISR_KPADAL_int25_mask                                (0x20000000)
#define MIS_UMSK_ISR_KPADAL_int24_mask                                (0x10000000)
#define MIS_UMSK_ISR_KPADAL_int23_mask                                (0x08000000)
#define MIS_UMSK_ISR_KPADAL_int22_mask                                (0x04000000)
#define MIS_UMSK_ISR_KPADAL_int21_mask                                (0x02000000)
#define MIS_UMSK_ISR_KPADAL_int20_mask                                (0x01000000)
#define MIS_UMSK_ISR_KPADAL_int19_mask                                (0x00800000)
#define MIS_UMSK_ISR_KPADAL_int18_mask                                (0x00400000)
#define MIS_UMSK_ISR_KPADAL_int17_mask                                (0x00200000)
#define MIS_UMSK_ISR_KPADAL_int16_mask                                (0x00100000)
#define MIS_UMSK_ISR_KPADAL_int15_mask                                (0x00080000)
#define MIS_UMSK_ISR_KPADAL_int14_mask                                (0x00040000)
#define MIS_UMSK_ISR_KPADAL_int13_mask                                (0x00020000)
#define MIS_UMSK_ISR_KPADAL_int12_mask                                (0x00010000)
#define MIS_UMSK_ISR_KPADAL_int11_mask                                (0x00008000)
#define MIS_UMSK_ISR_KPADAL_int10_mask                                (0x00004000)
#define MIS_UMSK_ISR_KPADAL_int9_mask                                 (0x00002000)
#define MIS_UMSK_ISR_KPADAL_int8_mask                                 (0x00001000)
#define MIS_UMSK_ISR_KPADAL_int7_mask                                 (0x00000800)
#define MIS_UMSK_ISR_KPADAL_int6_mask                                 (0x00000400)
#define MIS_UMSK_ISR_KPADAL_int5_mask                                 (0x00000200)
#define MIS_UMSK_ISR_KPADAL_int4_mask                                 (0x00000100)
#define MIS_UMSK_ISR_KPADAL_int3_mask                                 (0x00000080)
#define MIS_UMSK_ISR_KPADAL_int2_mask                                 (0x00000040)
#define MIS_UMSK_ISR_KPADAL_int1_mask                                 (0x00000020)
#define MIS_UMSK_ISR_KPADAL_int0_mask                                 (0x00000010)
#define MIS_UMSK_ISR_KPADAL_write_data_mask                           (0x00000001)
#define MIS_UMSK_ISR_KPADAL_int27(data)                               (0x80000000&((data)<<31))
#define MIS_UMSK_ISR_KPADAL_int26(data)                               (0x40000000&((data)<<30))
#define MIS_UMSK_ISR_KPADAL_int25(data)                               (0x20000000&((data)<<29))
#define MIS_UMSK_ISR_KPADAL_int24(data)                               (0x10000000&((data)<<28))
#define MIS_UMSK_ISR_KPADAL_int23(data)                               (0x08000000&((data)<<27))
#define MIS_UMSK_ISR_KPADAL_int22(data)                               (0x04000000&((data)<<26))
#define MIS_UMSK_ISR_KPADAL_int21(data)                               (0x02000000&((data)<<25))
#define MIS_UMSK_ISR_KPADAL_int20(data)                               (0x01000000&((data)<<24))
#define MIS_UMSK_ISR_KPADAL_int19(data)                               (0x00800000&((data)<<23))
#define MIS_UMSK_ISR_KPADAL_int18(data)                               (0x00400000&((data)<<22))
#define MIS_UMSK_ISR_KPADAL_int17(data)                               (0x00200000&((data)<<21))
#define MIS_UMSK_ISR_KPADAL_int16(data)                               (0x00100000&((data)<<20))
#define MIS_UMSK_ISR_KPADAL_int15(data)                               (0x00080000&((data)<<19))
#define MIS_UMSK_ISR_KPADAL_int14(data)                               (0x00040000&((data)<<18))
#define MIS_UMSK_ISR_KPADAL_int13(data)                               (0x00020000&((data)<<17))
#define MIS_UMSK_ISR_KPADAL_int12(data)                               (0x00010000&((data)<<16))
#define MIS_UMSK_ISR_KPADAL_int11(data)                               (0x00008000&((data)<<15))
#define MIS_UMSK_ISR_KPADAL_int10(data)                               (0x00004000&((data)<<14))
#define MIS_UMSK_ISR_KPADAL_int9(data)                                (0x00002000&((data)<<13))
#define MIS_UMSK_ISR_KPADAL_int8(data)                                (0x00001000&((data)<<12))
#define MIS_UMSK_ISR_KPADAL_int7(data)                                (0x00000800&((data)<<11))
#define MIS_UMSK_ISR_KPADAL_int6(data)                                (0x00000400&((data)<<10))
#define MIS_UMSK_ISR_KPADAL_int5(data)                                (0x00000200&((data)<<9))
#define MIS_UMSK_ISR_KPADAL_int4(data)                                (0x00000100&((data)<<8))
#define MIS_UMSK_ISR_KPADAL_int3(data)                                (0x00000080&((data)<<7))
#define MIS_UMSK_ISR_KPADAL_int2(data)                                (0x00000040&((data)<<6))
#define MIS_UMSK_ISR_KPADAL_int1(data)                                (0x00000020&((data)<<5))
#define MIS_UMSK_ISR_KPADAL_int0(data)                                (0x00000010&((data)<<4))
#define MIS_UMSK_ISR_KPADAL_write_data(data)                          (0x00000001&(data))
#define MIS_UMSK_ISR_KPADAL_get_int27(data)                           ((0x80000000&(data))>>31)
#define MIS_UMSK_ISR_KPADAL_get_int26(data)                           ((0x40000000&(data))>>30)
#define MIS_UMSK_ISR_KPADAL_get_int25(data)                           ((0x20000000&(data))>>29)
#define MIS_UMSK_ISR_KPADAL_get_int24(data)                           ((0x10000000&(data))>>28)
#define MIS_UMSK_ISR_KPADAL_get_int23(data)                           ((0x08000000&(data))>>27)
#define MIS_UMSK_ISR_KPADAL_get_int22(data)                           ((0x04000000&(data))>>26)
#define MIS_UMSK_ISR_KPADAL_get_int21(data)                           ((0x02000000&(data))>>25)
#define MIS_UMSK_ISR_KPADAL_get_int20(data)                           ((0x01000000&(data))>>24)
#define MIS_UMSK_ISR_KPADAL_get_int19(data)                           ((0x00800000&(data))>>23)
#define MIS_UMSK_ISR_KPADAL_get_int18(data)                           ((0x00400000&(data))>>22)
#define MIS_UMSK_ISR_KPADAL_get_int17(data)                           ((0x00200000&(data))>>21)
#define MIS_UMSK_ISR_KPADAL_get_int16(data)                           ((0x00100000&(data))>>20)
#define MIS_UMSK_ISR_KPADAL_get_int15(data)                           ((0x00080000&(data))>>19)
#define MIS_UMSK_ISR_KPADAL_get_int14(data)                           ((0x00040000&(data))>>18)
#define MIS_UMSK_ISR_KPADAL_get_int13(data)                           ((0x00020000&(data))>>17)
#define MIS_UMSK_ISR_KPADAL_get_int12(data)                           ((0x00010000&(data))>>16)
#define MIS_UMSK_ISR_KPADAL_get_int11(data)                           ((0x00008000&(data))>>15)
#define MIS_UMSK_ISR_KPADAL_get_int10(data)                           ((0x00004000&(data))>>14)
#define MIS_UMSK_ISR_KPADAL_get_int9(data)                            ((0x00002000&(data))>>13)
#define MIS_UMSK_ISR_KPADAL_get_int8(data)                            ((0x00001000&(data))>>12)
#define MIS_UMSK_ISR_KPADAL_get_int7(data)                            ((0x00000800&(data))>>11)
#define MIS_UMSK_ISR_KPADAL_get_int6(data)                            ((0x00000400&(data))>>10)
#define MIS_UMSK_ISR_KPADAL_get_int5(data)                            ((0x00000200&(data))>>9)
#define MIS_UMSK_ISR_KPADAL_get_int4(data)                            ((0x00000100&(data))>>8)
#define MIS_UMSK_ISR_KPADAL_get_int3(data)                            ((0x00000080&(data))>>7)
#define MIS_UMSK_ISR_KPADAL_get_int2(data)                            ((0x00000040&(data))>>6)
#define MIS_UMSK_ISR_KPADAL_get_int1(data)                            ((0x00000020&(data))>>5)
#define MIS_UMSK_ISR_KPADAL_get_int0(data)                            ((0x00000010&(data))>>4)
#define MIS_UMSK_ISR_KPADAL_get_write_data(data)                      (0x00000001&(data))

#define MIS_UMSK_ISR_KPADDAH                                          0x1801B020
#define MIS_UMSK_ISR_KPADDAH_reg_addr                                 "0xB801B020"
#define MIS_UMSK_ISR_KPADDAH_reg                                      0xB801B020
#define MIS_UMSK_ISR_KPADDAH_inst_addr                                "0x0008"
#define MIS_UMSK_ISR_KPADDAH_inst                                     0x0008
#define MIS_UMSK_ISR_KPADDAH_int47_shift                              (23)
#define MIS_UMSK_ISR_KPADDAH_int46_shift                              (22)
#define MIS_UMSK_ISR_KPADDAH_int45_shift                              (21)
#define MIS_UMSK_ISR_KPADDAH_int44_shift                              (20)
#define MIS_UMSK_ISR_KPADDAH_int43_shift                              (19)
#define MIS_UMSK_ISR_KPADDAH_int42_shift                              (18)
#define MIS_UMSK_ISR_KPADDAH_int41_shift                              (17)
#define MIS_UMSK_ISR_KPADDAH_int40_shift                              (16)
#define MIS_UMSK_ISR_KPADDAH_int39_shift                              (15)
#define MIS_UMSK_ISR_KPADDAH_int38_shift                              (14)
#define MIS_UMSK_ISR_KPADDAH_int37_shift                              (13)
#define MIS_UMSK_ISR_KPADDAH_int36_shift                              (12)
#define MIS_UMSK_ISR_KPADDAH_int35_shift                              (11)
#define MIS_UMSK_ISR_KPADDAH_int34_shift                              (10)
#define MIS_UMSK_ISR_KPADDAH_int33_shift                              (9)
#define MIS_UMSK_ISR_KPADDAH_int32_shift                              (8)
#define MIS_UMSK_ISR_KPADDAH_int31_shift                              (7)
#define MIS_UMSK_ISR_KPADDAH_int30_shift                              (6)
#define MIS_UMSK_ISR_KPADDAH_int29_shift                              (5)
#define MIS_UMSK_ISR_KPADDAH_int28_shift                              (4)
#define MIS_UMSK_ISR_KPADDAH_write_data_shift                         (0)
#define MIS_UMSK_ISR_KPADDAH_int47_mask                               (0x00800000)
#define MIS_UMSK_ISR_KPADDAH_int46_mask                               (0x00400000)
#define MIS_UMSK_ISR_KPADDAH_int45_mask                               (0x00200000)
#define MIS_UMSK_ISR_KPADDAH_int44_mask                               (0x00100000)
#define MIS_UMSK_ISR_KPADDAH_int43_mask                               (0x00080000)
#define MIS_UMSK_ISR_KPADDAH_int42_mask                               (0x00040000)
#define MIS_UMSK_ISR_KPADDAH_int41_mask                               (0x00020000)
#define MIS_UMSK_ISR_KPADDAH_int40_mask                               (0x00010000)
#define MIS_UMSK_ISR_KPADDAH_int39_mask                               (0x00008000)
#define MIS_UMSK_ISR_KPADDAH_int38_mask                               (0x00004000)
#define MIS_UMSK_ISR_KPADDAH_int37_mask                               (0x00002000)
#define MIS_UMSK_ISR_KPADDAH_int36_mask                               (0x00001000)
#define MIS_UMSK_ISR_KPADDAH_int35_mask                               (0x00000800)
#define MIS_UMSK_ISR_KPADDAH_int34_mask                               (0x00000400)
#define MIS_UMSK_ISR_KPADDAH_int33_mask                               (0x00000200)
#define MIS_UMSK_ISR_KPADDAH_int32_mask                               (0x00000100)
#define MIS_UMSK_ISR_KPADDAH_int31_mask                               (0x00000080)
#define MIS_UMSK_ISR_KPADDAH_int30_mask                               (0x00000040)
#define MIS_UMSK_ISR_KPADDAH_int29_mask                               (0x00000020)
#define MIS_UMSK_ISR_KPADDAH_int28_mask                               (0x00000010)
#define MIS_UMSK_ISR_KPADDAH_write_data_mask                          (0x00000001)
#define MIS_UMSK_ISR_KPADDAH_int47(data)                              (0x00800000&((data)<<23))
#define MIS_UMSK_ISR_KPADDAH_int46(data)                              (0x00400000&((data)<<22))
#define MIS_UMSK_ISR_KPADDAH_int45(data)                              (0x00200000&((data)<<21))
#define MIS_UMSK_ISR_KPADDAH_int44(data)                              (0x00100000&((data)<<20))
#define MIS_UMSK_ISR_KPADDAH_int43(data)                              (0x00080000&((data)<<19))
#define MIS_UMSK_ISR_KPADDAH_int42(data)                              (0x00040000&((data)<<18))
#define MIS_UMSK_ISR_KPADDAH_int41(data)                              (0x00020000&((data)<<17))
#define MIS_UMSK_ISR_KPADDAH_int40(data)                              (0x00010000&((data)<<16))
#define MIS_UMSK_ISR_KPADDAH_int39(data)                              (0x00008000&((data)<<15))
#define MIS_UMSK_ISR_KPADDAH_int38(data)                              (0x00004000&((data)<<14))
#define MIS_UMSK_ISR_KPADDAH_int37(data)                              (0x00002000&((data)<<13))
#define MIS_UMSK_ISR_KPADDAH_int36(data)                              (0x00001000&((data)<<12))
#define MIS_UMSK_ISR_KPADDAH_int35(data)                              (0x00000800&((data)<<11))
#define MIS_UMSK_ISR_KPADDAH_int34(data)                              (0x00000400&((data)<<10))
#define MIS_UMSK_ISR_KPADDAH_int33(data)                              (0x00000200&((data)<<9))
#define MIS_UMSK_ISR_KPADDAH_int32(data)                              (0x00000100&((data)<<8))
#define MIS_UMSK_ISR_KPADDAH_int31(data)                              (0x00000080&((data)<<7))
#define MIS_UMSK_ISR_KPADDAH_int30(data)                              (0x00000040&((data)<<6))
#define MIS_UMSK_ISR_KPADDAH_int29(data)                              (0x00000020&((data)<<5))
#define MIS_UMSK_ISR_KPADDAH_int28(data)                              (0x00000010&((data)<<4))
#define MIS_UMSK_ISR_KPADDAH_write_data(data)                         (0x00000001&(data))
#define MIS_UMSK_ISR_KPADDAH_get_int47(data)                          ((0x00800000&(data))>>23)
#define MIS_UMSK_ISR_KPADDAH_get_int46(data)                          ((0x00400000&(data))>>22)
#define MIS_UMSK_ISR_KPADDAH_get_int45(data)                          ((0x00200000&(data))>>21)
#define MIS_UMSK_ISR_KPADDAH_get_int44(data)                          ((0x00100000&(data))>>20)
#define MIS_UMSK_ISR_KPADDAH_get_int43(data)                          ((0x00080000&(data))>>19)
#define MIS_UMSK_ISR_KPADDAH_get_int42(data)                          ((0x00040000&(data))>>18)
#define MIS_UMSK_ISR_KPADDAH_get_int41(data)                          ((0x00020000&(data))>>17)
#define MIS_UMSK_ISR_KPADDAH_get_int40(data)                          ((0x00010000&(data))>>16)
#define MIS_UMSK_ISR_KPADDAH_get_int39(data)                          ((0x00008000&(data))>>15)
#define MIS_UMSK_ISR_KPADDAH_get_int38(data)                          ((0x00004000&(data))>>14)
#define MIS_UMSK_ISR_KPADDAH_get_int37(data)                          ((0x00002000&(data))>>13)
#define MIS_UMSK_ISR_KPADDAH_get_int36(data)                          ((0x00001000&(data))>>12)
#define MIS_UMSK_ISR_KPADDAH_get_int35(data)                          ((0x00000800&(data))>>11)
#define MIS_UMSK_ISR_KPADDAH_get_int34(data)                          ((0x00000400&(data))>>10)
#define MIS_UMSK_ISR_KPADDAH_get_int33(data)                          ((0x00000200&(data))>>9)
#define MIS_UMSK_ISR_KPADDAH_get_int32(data)                          ((0x00000100&(data))>>8)
#define MIS_UMSK_ISR_KPADDAH_get_int31(data)                          ((0x00000080&(data))>>7)
#define MIS_UMSK_ISR_KPADDAH_get_int30(data)                          ((0x00000040&(data))>>6)
#define MIS_UMSK_ISR_KPADDAH_get_int29(data)                          ((0x00000020&(data))>>5)
#define MIS_UMSK_ISR_KPADDAH_get_int28(data)                          ((0x00000010&(data))>>4)
#define MIS_UMSK_ISR_KPADDAH_get_write_data(data)                     (0x00000001&(data))

#define MIS_UMSK_ISR_KPADDAL                                          0x1801B024
#define MIS_UMSK_ISR_KPADDAL_reg_addr                                 "0xB801B024"
#define MIS_UMSK_ISR_KPADDAL_reg                                      0xB801B024
#define MIS_UMSK_ISR_KPADDAL_inst_addr                                "0x0009"
#define MIS_UMSK_ISR_KPADDAL_inst                                     0x0009
#define MIS_UMSK_ISR_KPADDAL_int27_shift                              (31)
#define MIS_UMSK_ISR_KPADDAL_int26_shift                              (30)
#define MIS_UMSK_ISR_KPADDAL_int25_shift                              (29)
#define MIS_UMSK_ISR_KPADDAL_int24_shift                              (28)
#define MIS_UMSK_ISR_KPADDAL_int23_shift                              (27)
#define MIS_UMSK_ISR_KPADDAL_int22_shift                              (26)
#define MIS_UMSK_ISR_KPADDAL_int21_shift                              (25)
#define MIS_UMSK_ISR_KPADDAL_int20_shift                              (24)
#define MIS_UMSK_ISR_KPADDAL_int19_shift                              (23)
#define MIS_UMSK_ISR_KPADDAL_int18_shift                              (22)
#define MIS_UMSK_ISR_KPADDAL_int17_shift                              (21)
#define MIS_UMSK_ISR_KPADDAL_int16_shift                              (20)
#define MIS_UMSK_ISR_KPADDAL_int15_shift                              (19)
#define MIS_UMSK_ISR_KPADDAL_int14_shift                              (18)
#define MIS_UMSK_ISR_KPADDAL_int13_shift                              (17)
#define MIS_UMSK_ISR_KPADDAL_int12_shift                              (16)
#define MIS_UMSK_ISR_KPADDAL_int11_shift                              (15)
#define MIS_UMSK_ISR_KPADDAL_int10_shift                              (14)
#define MIS_UMSK_ISR_KPADDAL_int9_shift                               (13)
#define MIS_UMSK_ISR_KPADDAL_int8_shift                               (12)
#define MIS_UMSK_ISR_KPADDAL_int7_shift                               (11)
#define MIS_UMSK_ISR_KPADDAL_int6_shift                               (10)
#define MIS_UMSK_ISR_KPADDAL_int5_shift                               (9)
#define MIS_UMSK_ISR_KPADDAL_int4_shift                               (8)
#define MIS_UMSK_ISR_KPADDAL_int3_shift                               (7)
#define MIS_UMSK_ISR_KPADDAL_int2_shift                               (6)
#define MIS_UMSK_ISR_KPADDAL_int1_shift                               (5)
#define MIS_UMSK_ISR_KPADDAL_int0_shift                               (4)
#define MIS_UMSK_ISR_KPADDAL_write_data_shift                         (0)
#define MIS_UMSK_ISR_KPADDAL_int27_mask                               (0x80000000)
#define MIS_UMSK_ISR_KPADDAL_int26_mask                               (0x40000000)
#define MIS_UMSK_ISR_KPADDAL_int25_mask                               (0x20000000)
#define MIS_UMSK_ISR_KPADDAL_int24_mask                               (0x10000000)
#define MIS_UMSK_ISR_KPADDAL_int23_mask                               (0x08000000)
#define MIS_UMSK_ISR_KPADDAL_int22_mask                               (0x04000000)
#define MIS_UMSK_ISR_KPADDAL_int21_mask                               (0x02000000)
#define MIS_UMSK_ISR_KPADDAL_int20_mask                               (0x01000000)
#define MIS_UMSK_ISR_KPADDAL_int19_mask                               (0x00800000)
#define MIS_UMSK_ISR_KPADDAL_int18_mask                               (0x00400000)
#define MIS_UMSK_ISR_KPADDAL_int17_mask                               (0x00200000)
#define MIS_UMSK_ISR_KPADDAL_int16_mask                               (0x00100000)
#define MIS_UMSK_ISR_KPADDAL_int15_mask                               (0x00080000)
#define MIS_UMSK_ISR_KPADDAL_int14_mask                               (0x00040000)
#define MIS_UMSK_ISR_KPADDAL_int13_mask                               (0x00020000)
#define MIS_UMSK_ISR_KPADDAL_int12_mask                               (0x00010000)
#define MIS_UMSK_ISR_KPADDAL_int11_mask                               (0x00008000)
#define MIS_UMSK_ISR_KPADDAL_int10_mask                               (0x00004000)
#define MIS_UMSK_ISR_KPADDAL_int9_mask                                (0x00002000)
#define MIS_UMSK_ISR_KPADDAL_int8_mask                                (0x00001000)
#define MIS_UMSK_ISR_KPADDAL_int7_mask                                (0x00000800)
#define MIS_UMSK_ISR_KPADDAL_int6_mask                                (0x00000400)
#define MIS_UMSK_ISR_KPADDAL_int5_mask                                (0x00000200)
#define MIS_UMSK_ISR_KPADDAL_int4_mask                                (0x00000100)
#define MIS_UMSK_ISR_KPADDAL_int3_mask                                (0x00000080)
#define MIS_UMSK_ISR_KPADDAL_int2_mask                                (0x00000040)
#define MIS_UMSK_ISR_KPADDAL_int1_mask                                (0x00000020)
#define MIS_UMSK_ISR_KPADDAL_int0_mask                                (0x00000010)
#define MIS_UMSK_ISR_KPADDAL_write_data_mask                          (0x00000001)
#define MIS_UMSK_ISR_KPADDAL_int27(data)                              (0x80000000&((data)<<31))
#define MIS_UMSK_ISR_KPADDAL_int26(data)                              (0x40000000&((data)<<30))
#define MIS_UMSK_ISR_KPADDAL_int25(data)                              (0x20000000&((data)<<29))
#define MIS_UMSK_ISR_KPADDAL_int24(data)                              (0x10000000&((data)<<28))
#define MIS_UMSK_ISR_KPADDAL_int23(data)                              (0x08000000&((data)<<27))
#define MIS_UMSK_ISR_KPADDAL_int22(data)                              (0x04000000&((data)<<26))
#define MIS_UMSK_ISR_KPADDAL_int21(data)                              (0x02000000&((data)<<25))
#define MIS_UMSK_ISR_KPADDAL_int20(data)                              (0x01000000&((data)<<24))
#define MIS_UMSK_ISR_KPADDAL_int19(data)                              (0x00800000&((data)<<23))
#define MIS_UMSK_ISR_KPADDAL_int18(data)                              (0x00400000&((data)<<22))
#define MIS_UMSK_ISR_KPADDAL_int17(data)                              (0x00200000&((data)<<21))
#define MIS_UMSK_ISR_KPADDAL_int16(data)                              (0x00100000&((data)<<20))
#define MIS_UMSK_ISR_KPADDAL_int15(data)                              (0x00080000&((data)<<19))
#define MIS_UMSK_ISR_KPADDAL_int14(data)                              (0x00040000&((data)<<18))
#define MIS_UMSK_ISR_KPADDAL_int13(data)                              (0x00020000&((data)<<17))
#define MIS_UMSK_ISR_KPADDAL_int12(data)                              (0x00010000&((data)<<16))
#define MIS_UMSK_ISR_KPADDAL_int11(data)                              (0x00008000&((data)<<15))
#define MIS_UMSK_ISR_KPADDAL_int10(data)                              (0x00004000&((data)<<14))
#define MIS_UMSK_ISR_KPADDAL_int9(data)                               (0x00002000&((data)<<13))
#define MIS_UMSK_ISR_KPADDAL_int8(data)                               (0x00001000&((data)<<12))
#define MIS_UMSK_ISR_KPADDAL_int7(data)                               (0x00000800&((data)<<11))
#define MIS_UMSK_ISR_KPADDAL_int6(data)                               (0x00000400&((data)<<10))
#define MIS_UMSK_ISR_KPADDAL_int5(data)                               (0x00000200&((data)<<9))
#define MIS_UMSK_ISR_KPADDAL_int4(data)                               (0x00000100&((data)<<8))
#define MIS_UMSK_ISR_KPADDAL_int3(data)                               (0x00000080&((data)<<7))
#define MIS_UMSK_ISR_KPADDAL_int2(data)                               (0x00000040&((data)<<6))
#define MIS_UMSK_ISR_KPADDAL_int1(data)                               (0x00000020&((data)<<5))
#define MIS_UMSK_ISR_KPADDAL_int0(data)                               (0x00000010&((data)<<4))
#define MIS_UMSK_ISR_KPADDAL_write_data(data)                         (0x00000001&(data))
#define MIS_UMSK_ISR_KPADDAL_get_int27(data)                          ((0x80000000&(data))>>31)
#define MIS_UMSK_ISR_KPADDAL_get_int26(data)                          ((0x40000000&(data))>>30)
#define MIS_UMSK_ISR_KPADDAL_get_int25(data)                          ((0x20000000&(data))>>29)
#define MIS_UMSK_ISR_KPADDAL_get_int24(data)                          ((0x10000000&(data))>>28)
#define MIS_UMSK_ISR_KPADDAL_get_int23(data)                          ((0x08000000&(data))>>27)
#define MIS_UMSK_ISR_KPADDAL_get_int22(data)                          ((0x04000000&(data))>>26)
#define MIS_UMSK_ISR_KPADDAL_get_int21(data)                          ((0x02000000&(data))>>25)
#define MIS_UMSK_ISR_KPADDAL_get_int20(data)                          ((0x01000000&(data))>>24)
#define MIS_UMSK_ISR_KPADDAL_get_int19(data)                          ((0x00800000&(data))>>23)
#define MIS_UMSK_ISR_KPADDAL_get_int18(data)                          ((0x00400000&(data))>>22)
#define MIS_UMSK_ISR_KPADDAL_get_int17(data)                          ((0x00200000&(data))>>21)
#define MIS_UMSK_ISR_KPADDAL_get_int16(data)                          ((0x00100000&(data))>>20)
#define MIS_UMSK_ISR_KPADDAL_get_int15(data)                          ((0x00080000&(data))>>19)
#define MIS_UMSK_ISR_KPADDAL_get_int14(data)                          ((0x00040000&(data))>>18)
#define MIS_UMSK_ISR_KPADDAL_get_int13(data)                          ((0x00020000&(data))>>17)
#define MIS_UMSK_ISR_KPADDAL_get_int12(data)                          ((0x00010000&(data))>>16)
#define MIS_UMSK_ISR_KPADDAL_get_int11(data)                          ((0x00008000&(data))>>15)
#define MIS_UMSK_ISR_KPADDAL_get_int10(data)                          ((0x00004000&(data))>>14)
#define MIS_UMSK_ISR_KPADDAL_get_int9(data)                           ((0x00002000&(data))>>13)
#define MIS_UMSK_ISR_KPADDAL_get_int8(data)                           ((0x00001000&(data))>>12)
#define MIS_UMSK_ISR_KPADDAL_get_int7(data)                           ((0x00000800&(data))>>11)
#define MIS_UMSK_ISR_KPADDAL_get_int6(data)                           ((0x00000400&(data))>>10)
#define MIS_UMSK_ISR_KPADDAL_get_int5(data)                           ((0x00000200&(data))>>9)
#define MIS_UMSK_ISR_KPADDAL_get_int4(data)                           ((0x00000100&(data))>>8)
#define MIS_UMSK_ISR_KPADDAL_get_int3(data)                           ((0x00000080&(data))>>7)
#define MIS_UMSK_ISR_KPADDAL_get_int2(data)                           ((0x00000040&(data))>>6)
#define MIS_UMSK_ISR_KPADDAL_get_int1(data)                           ((0x00000020&(data))>>5)
#define MIS_UMSK_ISR_KPADDAL_get_int0(data)                           ((0x00000010&(data))>>4)
#define MIS_UMSK_ISR_KPADDAL_get_write_data(data)                     (0x00000001&(data))

#define MIS_UMSK_ISR_SW                                               0x1801B028
#define MIS_UMSK_ISR_SW_reg_addr                                      "0xB801B028"
#define MIS_UMSK_ISR_SW_reg                                           0xB801B028
#define MIS_UMSK_ISR_SW_inst_addr                                     "0x000A"
#define MIS_UMSK_ISR_SW_inst                                          0x000A
#define MIS_UMSK_ISR_SW_da_int3_shift                                 (11)
#define MIS_UMSK_ISR_SW_da_int2_shift                                 (10)
#define MIS_UMSK_ISR_SW_da_int1_shift                                 (9)
#define MIS_UMSK_ISR_SW_da_int0_shift                                 (8)
#define MIS_UMSK_ISR_SW_a_int3_shift                                  (7)
#define MIS_UMSK_ISR_SW_a_int2_shift                                  (6)
#define MIS_UMSK_ISR_SW_a_int1_shift                                  (5)
#define MIS_UMSK_ISR_SW_a_int0_shift                                  (4)
#define MIS_UMSK_ISR_SW_write_data_shift                              (0)
#define MIS_UMSK_ISR_SW_da_int3_mask                                  (0x00000800)
#define MIS_UMSK_ISR_SW_da_int2_mask                                  (0x00000400)
#define MIS_UMSK_ISR_SW_da_int1_mask                                  (0x00000200)
#define MIS_UMSK_ISR_SW_da_int0_mask                                  (0x00000100)
#define MIS_UMSK_ISR_SW_a_int3_mask                                   (0x00000080)
#define MIS_UMSK_ISR_SW_a_int2_mask                                   (0x00000040)
#define MIS_UMSK_ISR_SW_a_int1_mask                                   (0x00000020)
#define MIS_UMSK_ISR_SW_a_int0_mask                                   (0x00000010)
#define MIS_UMSK_ISR_SW_write_data_mask                               (0x00000001)
#define MIS_UMSK_ISR_SW_da_int3(data)                                 (0x00000800&((data)<<11))
#define MIS_UMSK_ISR_SW_da_int2(data)                                 (0x00000400&((data)<<10))
#define MIS_UMSK_ISR_SW_da_int1(data)                                 (0x00000200&((data)<<9))
#define MIS_UMSK_ISR_SW_da_int0(data)                                 (0x00000100&((data)<<8))
#define MIS_UMSK_ISR_SW_a_int3(data)                                  (0x00000080&((data)<<7))
#define MIS_UMSK_ISR_SW_a_int2(data)                                  (0x00000040&((data)<<6))
#define MIS_UMSK_ISR_SW_a_int1(data)                                  (0x00000020&((data)<<5))
#define MIS_UMSK_ISR_SW_a_int0(data)                                  (0x00000010&((data)<<4))
#define MIS_UMSK_ISR_SW_write_data(data)                              (0x00000001&(data))
#define MIS_UMSK_ISR_SW_get_da_int3(data)                             ((0x00000800&(data))>>11)
#define MIS_UMSK_ISR_SW_get_da_int2(data)                             ((0x00000400&(data))>>10)
#define MIS_UMSK_ISR_SW_get_da_int1(data)                             ((0x00000200&(data))>>9)
#define MIS_UMSK_ISR_SW_get_da_int0(data)                             ((0x00000100&(data))>>8)
#define MIS_UMSK_ISR_SW_get_a_int3(data)                              ((0x00000080&(data))>>7)
#define MIS_UMSK_ISR_SW_get_a_int2(data)                              ((0x00000040&(data))>>6)
#define MIS_UMSK_ISR_SW_get_a_int1(data)                              ((0x00000020&(data))>>5)
#define MIS_UMSK_ISR_SW_get_a_int0(data)                              ((0x00000010&(data))>>4)
#define MIS_UMSK_ISR_SW_get_write_data(data)                          (0x00000001&(data))

#define MIS_DBG                                                       0x1801B02C
#define MIS_DBG_reg_addr                                              "0xB801B02C"
#define MIS_DBG_reg                                                   0xB801B02C
#define MIS_DBG_inst_addr                                             "0x000B"
#define MIS_DBG_inst                                                  0x000B
#define MIS_DBG_write_enable3_shift                                   (11)
#define MIS_DBG_sel1_shift                                            (7)
#define MIS_DBG_write_enable2_shift                                   (6)
#define MIS_DBG_sel0_shift                                            (2)
#define MIS_DBG_write_enable1_shift                                   (1)
#define MIS_DBG_enable_shift                                          (0)
#define MIS_DBG_write_enable3_mask                                    (0x00000800)
#define MIS_DBG_sel1_mask                                             (0x00000780)
#define MIS_DBG_write_enable2_mask                                    (0x00000040)
#define MIS_DBG_sel0_mask                                             (0x0000003C)
#define MIS_DBG_write_enable1_mask                                    (0x00000002)
#define MIS_DBG_enable_mask                                           (0x00000001)
#define MIS_DBG_write_enable3(data)                                   (0x00000800&((data)<<11))
#define MIS_DBG_sel1(data)                                            (0x00000780&((data)<<7))
#define MIS_DBG_write_enable2(data)                                   (0x00000040&((data)<<6))
#define MIS_DBG_sel0(data)                                            (0x0000003C&((data)<<2))
#define MIS_DBG_write_enable1(data)                                   (0x00000002&((data)<<1))
#define MIS_DBG_enable(data)                                          (0x00000001&(data))
#define MIS_DBG_get_write_enable3(data)                               ((0x00000800&(data))>>11)
#define MIS_DBG_get_sel1(data)                                        ((0x00000780&(data))>>7)
#define MIS_DBG_get_write_enable2(data)                               ((0x00000040&(data))>>6)
#define MIS_DBG_get_sel0(data)                                        ((0x0000003C&(data))>>2)
#define MIS_DBG_get_write_enable1(data)                               ((0x00000002&(data))>>1)
#define MIS_DBG_get_enable(data)                                      (0x00000001&(data))

#define MIS_DUMMY                                                     0x1801B030
#define MIS_DUMMY_reg_addr                                            "0xB801B030"
#define MIS_DUMMY_reg                                                 0xB801B030
#define MIS_DUMMY_inst_addr                                           "0x000C"
#define MIS_DUMMY_inst                                                0x000C
#define MIS_DUMMY_write_enable4_shift                                 (31)
#define MIS_DUMMY_reserved4_shift                                     (24)
#define MIS_DUMMY_write_enable3_shift                                 (23)
#define MIS_DUMMY_reserved3_shift                                     (16)
#define MIS_DUMMY_write_enable2_shift                                 (15)
#define MIS_DUMMY_reserved2_shift                                     (8)
#define MIS_DUMMY_write_enable1_shift                                 (7)
#define MIS_DUMMY_reserved1_shift                                     (0)
#define MIS_DUMMY_write_enable4_mask                                  (0x80000000)
#define MIS_DUMMY_reserved4_mask                                      (0x7F000000)
#define MIS_DUMMY_write_enable3_mask                                  (0x00800000)
#define MIS_DUMMY_reserved3_mask                                      (0x007F0000)
#define MIS_DUMMY_write_enable2_mask                                  (0x00008000)
#define MIS_DUMMY_reserved2_mask                                      (0x00007F00)
#define MIS_DUMMY_write_enable1_mask                                  (0x00000080)
#define MIS_DUMMY_reserved1_mask                                      (0x0000007F)
#define MIS_DUMMY_write_enable4(data)                                 (0x80000000&((data)<<31))
#define MIS_DUMMY_reserved4(data)                                     (0x7F000000&((data)<<24))
#define MIS_DUMMY_write_enable3(data)                                 (0x00800000&((data)<<23))
#define MIS_DUMMY_reserved3(data)                                     (0x007F0000&((data)<<16))
#define MIS_DUMMY_write_enable2(data)                                 (0x00008000&((data)<<15))
#define MIS_DUMMY_reserved2(data)                                     (0x00007F00&((data)<<8))
#define MIS_DUMMY_write_enable1(data)                                 (0x00000080&((data)<<7))
#define MIS_DUMMY_reserved1(data)                                     (0x0000007F&(data))
#define MIS_DUMMY_get_write_enable4(data)                             ((0x80000000&(data))>>31)
#define MIS_DUMMY_get_reserved4(data)                                 ((0x7F000000&(data))>>24)
#define MIS_DUMMY_get_write_enable3(data)                             ((0x00800000&(data))>>23)
#define MIS_DUMMY_get_reserved3(data)                                 ((0x007F0000&(data))>>16)
#define MIS_DUMMY_get_write_enable2(data)                             ((0x00008000&(data))>>15)
#define MIS_DUMMY_get_reserved2(data)                                 ((0x00007F00&(data))>>8)
#define MIS_DUMMY_get_write_enable1(data)                             ((0x00000080&(data))>>7)
#define MIS_DUMMY_get_reserved1(data)                                 (0x0000007F&(data))

#define MIS_GPDIR                                                     0x1801B100
#define MIS_GPDIR_reg_addr                                            "0xB801B100"
#define MIS_GPDIR_reg                                                 0xB801B100
#define MIS_GPDIR_inst_addr                                           "0x0040"
#define MIS_GPDIR_inst                                                0x0040
#define MIS_GPDIR_gpdir_shift                                         (0)
#define MIS_GPDIR_gpdir_mask                                          (0x7FFFFFFF)
#define MIS_GPDIR_gpdir(data)                                         (0x7FFFFFFF&(data))
#define MIS_GPDIR_get_gpdir(data)                                     (0x7FFFFFFF&(data))

#define MIS_GPDATO                                                    0x1801B104
#define MIS_GPDATO_reg_addr                                           "0xB801B104"
#define MIS_GPDATO_reg                                                0xB801B104
#define MIS_GPDATO_inst_addr                                          "0x0041"
#define MIS_GPDATO_inst                                               0x0041
#define MIS_GPDATO_gpdato_shift                                       (0)
#define MIS_GPDATO_gpdato_mask                                        (0x7FFFFFFF)
#define MIS_GPDATO_gpdato(data)                                       (0x7FFFFFFF&(data))
#define MIS_GPDATO_get_gpdato(data)                                   (0x7FFFFFFF&(data))

#define MIS_GPDATI                                                    0x1801B108
#define MIS_GPDATI_reg_addr                                           "0xB801B108"
#define MIS_GPDATI_reg                                                0xB801B108
#define MIS_GPDATI_inst_addr                                          "0x0042"
#define MIS_GPDATI_inst                                               0x0042
#define MIS_GPDATI_gpdati_shift                                       (0)
#define MIS_GPDATI_gpdati_mask                                        (0x7FFFFFFF)
#define MIS_GPDATI_gpdati(data)                                       (0x7FFFFFFF&(data))
#define MIS_GPDATI_get_gpdati(data)                                   (0x7FFFFFFF&(data))

#define MIS_GPIE                                                      0x1801B10C
#define MIS_GPIE_reg_addr                                             "0xB801B10C"
#define MIS_GPIE_reg                                                  0xB801B10C
#define MIS_GPIE_inst_addr                                            "0x0043"
#define MIS_GPIE_inst                                                 0x0043
#define MIS_GPIE_gp_shift                                             (0)
#define MIS_GPIE_gp_mask                                              (0x7FFFFFFF)
#define MIS_GPIE_gp(data)                                             (0x7FFFFFFF&(data))
#define MIS_GPIE_get_gp(data)                                         (0x7FFFFFFF&(data))

#define MIS_GPDP                                                      0x1801B110
#define MIS_GPDP_reg_addr                                             "0xB801B110"
#define MIS_GPDP_reg                                                  0xB801B110
#define MIS_GPDP_inst_addr                                            "0x0044"
#define MIS_GPDP_inst                                                 0x0044
#define MIS_GPDP_gpha_shift                                           (0)
#define MIS_GPDP_gpha_mask                                            (0x7FFFFFFF)
#define MIS_GPDP_gpha(data)                                           (0x7FFFFFFF&(data))
#define MIS_GPDP_get_gpha(data)                                       (0x7FFFFFFF&(data))

#define MIS_GPDEB                                                     0x1801B114
#define MIS_GPDEB_reg_addr                                            "0xB801B114"
#define MIS_GPDEB_reg                                                 0xB801B114
#define MIS_GPDEB_inst_addr                                           "0x0045"
#define MIS_GPDEB_inst                                                0x0045
#define MIS_GPDEB_write_enable4_shift                                 (15)
#define MIS_GPDEB_clk4_shift                                          (12)
#define MIS_GPDEB_write_enable3_shift                                 (11)
#define MIS_GPDEB_clk3_shift                                          (8)
#define MIS_GPDEB_write_enable2_shift                                 (7)
#define MIS_GPDEB_clk2_shift                                          (4)
#define MIS_GPDEB_write_enable1_shift                                 (3)
#define MIS_GPDEB_clk1_shift                                          (0)
#define MIS_GPDEB_write_enable4_mask                                  (0x00008000)
#define MIS_GPDEB_clk4_mask                                           (0x00007000)
#define MIS_GPDEB_write_enable3_mask                                  (0x00000800)
#define MIS_GPDEB_clk3_mask                                           (0x00000700)
#define MIS_GPDEB_write_enable2_mask                                  (0x00000080)
#define MIS_GPDEB_clk2_mask                                           (0x00000070)
#define MIS_GPDEB_write_enable1_mask                                  (0x00000008)
#define MIS_GPDEB_clk1_mask                                           (0x00000007)
#define MIS_GPDEB_write_enable4(data)                                 (0x00008000&((data)<<15))
#define MIS_GPDEB_clk4(data)                                          (0x00007000&((data)<<12))
#define MIS_GPDEB_write_enable3(data)                                 (0x00000800&((data)<<11))
#define MIS_GPDEB_clk3(data)                                          (0x00000700&((data)<<8))
#define MIS_GPDEB_write_enable2(data)                                 (0x00000080&((data)<<7))
#define MIS_GPDEB_clk2(data)                                          (0x00000070&((data)<<4))
#define MIS_GPDEB_write_enable1(data)                                 (0x00000008&((data)<<3))
#define MIS_GPDEB_clk1(data)                                          (0x00000007&(data))
#define MIS_GPDEB_get_write_enable4(data)                             ((0x00008000&(data))>>15)
#define MIS_GPDEB_get_clk4(data)                                      ((0x00007000&(data))>>12)
#define MIS_GPDEB_get_write_enable3(data)                             ((0x00000800&(data))>>11)
#define MIS_GPDEB_get_clk3(data)                                      ((0x00000700&(data))>>8)
#define MIS_GPDEB_get_write_enable2(data)                             ((0x00000080&(data))>>7)
#define MIS_GPDEB_get_clk2(data)                                      ((0x00000070&(data))>>4)
#define MIS_GPDEB_get_write_enable1(data)                             ((0x00000008&(data))>>3)
#define MIS_GPDEB_get_clk1(data)                                      (0x00000007&(data))

#define MIS_U0RBR_THR_DLL                                             0x1801B200
#define MIS_U0RBR_THR_DLL_reg_addr                                    "0xB801B200"
#define MIS_U0RBR_THR_DLL_reg                                         0xB801B200
#define MIS_U0RBR_THR_DLL_inst_addr                                   "0x0080"
#define MIS_U0RBR_THR_DLL_inst                                        0x0080
#define MIS_U0RBR_THR_DLL_dll_shift                                   (0)
#define MIS_U0RBR_THR_DLL_dll_mask                                    (0x000000FF)
#define MIS_U0RBR_THR_DLL_dll(data)                                   (0x000000FF&(data))
#define MIS_U0RBR_THR_DLL_get_dll(data)                               (0x000000FF&(data))

#define MIS_U0IER_DLH                                                 0x1801B204
#define MIS_U0IER_DLH_reg_addr                                        "0xB801B204"
#define MIS_U0IER_DLH_reg                                             0xB801B204
#define MIS_U0IER_DLH_inst_addr                                       "0x0081"
#define MIS_U0IER_DLH_inst                                            0x0081
#define MIS_U0IER_DLH_dlh_shift                                       (0)
#define MIS_U0IER_DLH_dlh_mask                                        (0x000000FF)
#define MIS_U0IER_DLH_dlh(data)                                       (0x000000FF&(data))
#define MIS_U0IER_DLH_get_dlh(data)                                   (0x000000FF&(data))

#define MIS_U0IIR_FCR                                                 0x1801B208
#define MIS_U0IIR_FCR_reg_addr                                        "0xB801B208"
#define MIS_U0IIR_FCR_reg                                             0xB801B208
#define MIS_U0IIR_FCR_inst_addr                                       "0x0082"
#define MIS_U0IIR_FCR_inst                                            0x0082
#define MIS_U0IIR_FCR_fifo16_shift                                    (6)
#define MIS_U0IIR_FCR_iid_shift                                       (1)
#define MIS_U0IIR_FCR_ipnd_shift                                      (0)
#define MIS_U0IIR_FCR_fifo16_mask                                     (0x000000C0)
#define MIS_U0IIR_FCR_iid_mask                                        (0x0000000E)
#define MIS_U0IIR_FCR_ipnd_mask                                       (0x00000001)
#define MIS_U0IIR_FCR_fifo16(data)                                    (0x000000C0&((data)<<6))
#define MIS_U0IIR_FCR_iid(data)                                       (0x0000000E&((data)<<1))
#define MIS_U0IIR_FCR_ipnd(data)                                      (0x00000001&(data))
#define MIS_U0IIR_FCR_get_fifo16(data)                                ((0x000000C0&(data))>>6)
#define MIS_U0IIR_FCR_get_iid(data)                                   ((0x0000000E&(data))>>1)
#define MIS_U0IIR_FCR_get_ipnd(data)                                  (0x00000001&(data))

#define MIS_U0LCR                                                     0x1801B20C
#define MIS_U0LCR_reg_addr                                            "0xB801B20C"
#define MIS_U0LCR_reg                                                 0xB801B20C
#define MIS_U0LCR_inst_addr                                           "0x0083"
#define MIS_U0LCR_inst                                                0x0083
#define MIS_U0LCR_dlab_shift                                          (7)
#define MIS_U0LCR_brk_shift                                           (6)
#define MIS_U0LCR_eps_shift                                           (4)
#define MIS_U0LCR_pen_shift                                           (3)
#define MIS_U0LCR_stb_shift                                           (2)
#define MIS_U0LCR_wls_shift                                           (0)
#define MIS_U0LCR_dlab_mask                                           (0x00000080)
#define MIS_U0LCR_brk_mask                                            (0x00000040)
#define MIS_U0LCR_eps_mask                                            (0x00000030)
#define MIS_U0LCR_pen_mask                                            (0x00000008)
#define MIS_U0LCR_stb_mask                                            (0x00000004)
#define MIS_U0LCR_wls_mask                                            (0x00000003)
#define MIS_U0LCR_dlab(data)                                          (0x00000080&((data)<<7))
#define MIS_U0LCR_brk(data)                                           (0x00000040&((data)<<6))
#define MIS_U0LCR_eps(data)                                           (0x00000030&((data)<<4))
#define MIS_U0LCR_pen(data)                                           (0x00000008&((data)<<3))
#define MIS_U0LCR_stb(data)                                           (0x00000004&((data)<<2))
#define MIS_U0LCR_wls(data)                                           (0x00000003&(data))
#define MIS_U0LCR_get_dlab(data)                                      ((0x00000080&(data))>>7)
#define MIS_U0LCR_get_brk(data)                                       ((0x00000040&(data))>>6)
#define MIS_U0LCR_get_eps(data)                                       ((0x00000030&(data))>>4)
#define MIS_U0LCR_get_pen(data)                                       ((0x00000008&(data))>>3)
#define MIS_U0LCR_get_stb(data)                                       ((0x00000004&(data))>>2)
#define MIS_U0LCR_get_wls(data)                                       (0x00000003&(data))

#define MIS_U0MCR                                                     0x1801B210
#define MIS_U0MCR_reg_addr                                            "0xB801B210"
#define MIS_U0MCR_reg                                                 0xB801B210
#define MIS_U0MCR_inst_addr                                           "0x0084"
#define MIS_U0MCR_inst                                                0x0084
#define MIS_U0MCR_loop_shift                                          (4)
#define MIS_U0MCR_rts_shift                                           (1)
#define MIS_U0MCR_dtr_shift                                           (0)
#define MIS_U0MCR_loop_mask                                           (0x00000010)
#define MIS_U0MCR_rts_mask                                            (0x00000002)
#define MIS_U0MCR_dtr_mask                                            (0x00000001)
#define MIS_U0MCR_loop(data)                                          (0x00000010&((data)<<4))
#define MIS_U0MCR_rts(data)                                           (0x00000002&((data)<<1))
#define MIS_U0MCR_dtr(data)                                           (0x00000001&(data))
#define MIS_U0MCR_get_loop(data)                                      ((0x00000010&(data))>>4)
#define MIS_U0MCR_get_rts(data)                                       ((0x00000002&(data))>>1)
#define MIS_U0MCR_get_dtr(data)                                       (0x00000001&(data))

#define MIS_U0LSR                                                     0x1801B214
#define MIS_U0LSR_reg_addr                                            "0xB801B214"
#define MIS_U0LSR_reg                                                 0xB801B214
#define MIS_U0LSR_inst_addr                                           "0x0085"
#define MIS_U0LSR_inst                                                0x0085
#define MIS_U0LSR_rfe_shift                                           (7)
#define MIS_U0LSR_temt_shift                                          (6)
#define MIS_U0LSR_thre_shift                                          (5)
#define MIS_U0LSR_bi_shift                                            (4)
#define MIS_U0LSR_fe_shift                                            (3)
#define MIS_U0LSR_pe_shift                                            (2)
#define MIS_U0LSR_oe_shift                                            (1)
#define MIS_U0LSR_dr_shift                                            (0)
#define MIS_U0LSR_rfe_mask                                            (0x00000080)
#define MIS_U0LSR_temt_mask                                           (0x00000040)
#define MIS_U0LSR_thre_mask                                           (0x00000020)
#define MIS_U0LSR_bi_mask                                             (0x00000010)
#define MIS_U0LSR_fe_mask                                             (0x00000008)
#define MIS_U0LSR_pe_mask                                             (0x00000004)
#define MIS_U0LSR_oe_mask                                             (0x00000002)
#define MIS_U0LSR_dr_mask                                             (0x00000001)
#define MIS_U0LSR_rfe(data)                                           (0x00000080&((data)<<7))
#define MIS_U0LSR_temt(data)                                          (0x00000040&((data)<<6))
#define MIS_U0LSR_thre(data)                                          (0x00000020&((data)<<5))
#define MIS_U0LSR_bi(data)                                            (0x00000010&((data)<<4))
#define MIS_U0LSR_fe(data)                                            (0x00000008&((data)<<3))
#define MIS_U0LSR_pe(data)                                            (0x00000004&((data)<<2))
#define MIS_U0LSR_oe(data)                                            (0x00000002&((data)<<1))
#define MIS_U0LSR_dr(data)                                            (0x00000001&(data))
#define MIS_U0LSR_get_rfe(data)                                       ((0x00000080&(data))>>7)
#define MIS_U0LSR_get_temt(data)                                      ((0x00000040&(data))>>6)
#define MIS_U0LSR_get_thre(data)                                      ((0x00000020&(data))>>5)
#define MIS_U0LSR_get_bi(data)                                        ((0x00000010&(data))>>4)
#define MIS_U0LSR_get_fe(data)                                        ((0x00000008&(data))>>3)
#define MIS_U0LSR_get_pe(data)                                        ((0x00000004&(data))>>2)
#define MIS_U0LSR_get_oe(data)                                        ((0x00000002&(data))>>1)
#define MIS_U0LSR_get_dr(data)                                        (0x00000001&(data))

#define MIS_U0MSR                                                     0x1801B218
#define MIS_U0MSR_reg_addr                                            "0xB801B218"
#define MIS_U0MSR_reg                                                 0xB801B218
#define MIS_U0MSR_inst_addr                                           "0x0086"
#define MIS_U0MSR_inst                                                0x0086
#define MIS_U0MSR_dcd_shift                                           (7)
#define MIS_U0MSR_ri_shift                                            (6)
#define MIS_U0MSR_dsr_shift                                           (5)
#define MIS_U0MSR_cts_shift                                           (4)
#define MIS_U0MSR_dcts_shift                                          (0)
#define MIS_U0MSR_dcd_mask                                            (0x00000080)
#define MIS_U0MSR_ri_mask                                             (0x00000040)
#define MIS_U0MSR_dsr_mask                                            (0x00000020)
#define MIS_U0MSR_cts_mask                                            (0x00000010)
#define MIS_U0MSR_dcts_mask                                           (0x00000001)
#define MIS_U0MSR_dcd(data)                                           (0x00000080&((data)<<7))
#define MIS_U0MSR_ri(data)                                            (0x00000040&((data)<<6))
#define MIS_U0MSR_dsr(data)                                           (0x00000020&((data)<<5))
#define MIS_U0MSR_cts(data)                                           (0x00000010&((data)<<4))
#define MIS_U0MSR_dcts(data)                                          (0x00000001&(data))
#define MIS_U0MSR_get_dcd(data)                                       ((0x00000080&(data))>>7)
#define MIS_U0MSR_get_ri(data)                                        ((0x00000040&(data))>>6)
#define MIS_U0MSR_get_dsr(data)                                       ((0x00000020&(data))>>5)
#define MIS_U0MSR_get_cts(data)                                       ((0x00000010&(data))>>4)
#define MIS_U0MSR_get_dcts(data)                                      (0x00000001&(data))

#define MIS_U0SCR                                                     0x1801B21C
#define MIS_U0SCR_reg_addr                                            "0xB801B21C"
#define MIS_U0SCR_reg                                                 0xB801B21C
#define MIS_U0SCR_inst_addr                                           "0x0087"
#define MIS_U0SCR_inst                                                0x0087
#define MIS_U0SCR_scr_shift                                           (0)
#define MIS_U0SCR_scr_mask                                            (0x000000FF)
#define MIS_U0SCR_scr(data)                                           (0x000000FF&(data))
#define MIS_U0SCR_get_scr(data)                                       (0x000000FF&(data))

#define MIS_U1RBR_THR_DLL                                             0x1801B220
#define MIS_U1RBR_THR_DLL_reg_addr                                    "0xB801B220"
#define MIS_U1RBR_THR_DLL_reg                                         0xB801B220
#define MIS_U1RBR_THR_DLL_inst_addr                                   "0x0088"
#define MIS_U1RBR_THR_DLL_inst                                        0x0088
#define MIS_U1RBR_THR_DLL_dll_shift                                   (0)
#define MIS_U1RBR_THR_DLL_dll_mask                                    (0x000000FF)
#define MIS_U1RBR_THR_DLL_dll(data)                                   (0x000000FF&(data))
#define MIS_U1RBR_THR_DLL_get_dll(data)                               (0x000000FF&(data))

#define MIS_U1IER_DLH                                                 0x1801B224
#define MIS_U1IER_DLH_reg_addr                                        "0xB801B224"
#define MIS_U1IER_DLH_reg                                             0xB801B224
#define MIS_U1IER_DLH_inst_addr                                       "0x0089"
#define MIS_U1IER_DLH_inst                                            0x0089
#define MIS_U1IER_DLH_dlh_shift                                       (0)
#define MIS_U1IER_DLH_dlh_mask                                        (0x000000FF)
#define MIS_U1IER_DLH_dlh(data)                                       (0x000000FF&(data))
#define MIS_U1IER_DLH_get_dlh(data)                                   (0x000000FF&(data))

#define MIS_U1IIR_FCR                                                 0x1801B228
#define MIS_U1IIR_FCR_reg_addr                                        "0xB801B228"
#define MIS_U1IIR_FCR_reg                                             0xB801B228
#define MIS_U1IIR_FCR_inst_addr                                       "0x008A"
#define MIS_U1IIR_FCR_inst                                            0x008A
#define MIS_U1IIR_FCR_fifo16_shift                                    (6)
#define MIS_U1IIR_FCR_iid_shift                                       (1)
#define MIS_U1IIR_FCR_ipnd_shift                                      (0)
#define MIS_U1IIR_FCR_fifo16_mask                                     (0x000000C0)
#define MIS_U1IIR_FCR_iid_mask                                        (0x0000000E)
#define MIS_U1IIR_FCR_ipnd_mask                                       (0x00000001)
#define MIS_U1IIR_FCR_fifo16(data)                                    (0x000000C0&((data)<<6))
#define MIS_U1IIR_FCR_iid(data)                                       (0x0000000E&((data)<<1))
#define MIS_U1IIR_FCR_ipnd(data)                                      (0x00000001&(data))
#define MIS_U1IIR_FCR_get_fifo16(data)                                ((0x000000C0&(data))>>6)
#define MIS_U1IIR_FCR_get_iid(data)                                   ((0x0000000E&(data))>>1)
#define MIS_U1IIR_FCR_get_ipnd(data)                                  (0x00000001&(data))

#define MIS_U1LCR                                                     0x1801B22C
#define MIS_U1LCR_reg_addr                                            "0xB801B22C"
#define MIS_U1LCR_reg                                                 0xB801B22C
#define MIS_U1LCR_inst_addr                                           "0x008B"
#define MIS_U1LCR_inst                                                0x008B
#define MIS_U1LCR_dlab_shift                                          (7)
#define MIS_U1LCR_brk_shift                                           (6)
#define MIS_U1LCR_eps_shift                                           (4)
#define MIS_U1LCR_pen_shift                                           (3)
#define MIS_U1LCR_stb_shift                                           (2)
#define MIS_U1LCR_wls_shift                                           (0)
#define MIS_U1LCR_dlab_mask                                           (0x00000080)
#define MIS_U1LCR_brk_mask                                            (0x00000040)
#define MIS_U1LCR_eps_mask                                            (0x00000030)
#define MIS_U1LCR_pen_mask                                            (0x00000008)
#define MIS_U1LCR_stb_mask                                            (0x00000004)
#define MIS_U1LCR_wls_mask                                            (0x00000003)
#define MIS_U1LCR_dlab(data)                                          (0x00000080&((data)<<7))
#define MIS_U1LCR_brk(data)                                           (0x00000040&((data)<<6))
#define MIS_U1LCR_eps(data)                                           (0x00000030&((data)<<4))
#define MIS_U1LCR_pen(data)                                           (0x00000008&((data)<<3))
#define MIS_U1LCR_stb(data)                                           (0x00000004&((data)<<2))
#define MIS_U1LCR_wls(data)                                           (0x00000003&(data))
#define MIS_U1LCR_get_dlab(data)                                      ((0x00000080&(data))>>7)
#define MIS_U1LCR_get_brk(data)                                       ((0x00000040&(data))>>6)
#define MIS_U1LCR_get_eps(data)                                       ((0x00000030&(data))>>4)
#define MIS_U1LCR_get_pen(data)                                       ((0x00000008&(data))>>3)
#define MIS_U1LCR_get_stb(data)                                       ((0x00000004&(data))>>2)
#define MIS_U1LCR_get_wls(data)                                       (0x00000003&(data))

#define MIS_U1MCR                                                     0x1801B230
#define MIS_U1MCR_reg_addr                                            "0xB801B230"
#define MIS_U1MCR_reg                                                 0xB801B230
#define MIS_U1MCR_inst_addr                                           "0x008C"
#define MIS_U1MCR_inst                                                0x008C
#define MIS_U1MCR_loop_shift                                          (4)
#define MIS_U1MCR_rts_shift                                           (1)
#define MIS_U1MCR_dtr_shift                                           (0)
#define MIS_U1MCR_loop_mask                                           (0x00000010)
#define MIS_U1MCR_rts_mask                                            (0x00000002)
#define MIS_U1MCR_dtr_mask                                            (0x00000001)
#define MIS_U1MCR_loop(data)                                          (0x00000010&((data)<<4))
#define MIS_U1MCR_rts(data)                                           (0x00000002&((data)<<1))
#define MIS_U1MCR_dtr(data)                                           (0x00000001&(data))
#define MIS_U1MCR_get_loop(data)                                      ((0x00000010&(data))>>4)
#define MIS_U1MCR_get_rts(data)                                       ((0x00000002&(data))>>1)
#define MIS_U1MCR_get_dtr(data)                                       (0x00000001&(data))

#define MIS_U1LSR                                                     0x1801B234
#define MIS_U1LSR_reg_addr                                            "0xB801B234"
#define MIS_U1LSR_reg                                                 0xB801B234
#define MIS_U1LSR_inst_addr                                           "0x008D"
#define MIS_U1LSR_inst                                                0x008D
#define MIS_U1LSR_rfe_shift                                           (7)
#define MIS_U1LSR_temt_shift                                          (6)
#define MIS_U1LSR_thre_shift                                          (5)
#define MIS_U1LSR_bi_shift                                            (4)
#define MIS_U1LSR_fe_shift                                            (3)
#define MIS_U1LSR_pe_shift                                            (2)
#define MIS_U1LSR_oe_shift                                            (1)
#define MIS_U1LSR_dr_shift                                            (0)
#define MIS_U1LSR_rfe_mask                                            (0x00000080)
#define MIS_U1LSR_temt_mask                                           (0x00000040)
#define MIS_U1LSR_thre_mask                                           (0x00000020)
#define MIS_U1LSR_bi_mask                                             (0x00000010)
#define MIS_U1LSR_fe_mask                                             (0x00000008)
#define MIS_U1LSR_pe_mask                                             (0x00000004)
#define MIS_U1LSR_oe_mask                                             (0x00000002)
#define MIS_U1LSR_dr_mask                                             (0x00000001)
#define MIS_U1LSR_rfe(data)                                           (0x00000080&((data)<<7))
#define MIS_U1LSR_temt(data)                                          (0x00000040&((data)<<6))
#define MIS_U1LSR_thre(data)                                          (0x00000020&((data)<<5))
#define MIS_U1LSR_bi(data)                                            (0x00000010&((data)<<4))
#define MIS_U1LSR_fe(data)                                            (0x00000008&((data)<<3))
#define MIS_U1LSR_pe(data)                                            (0x00000004&((data)<<2))
#define MIS_U1LSR_oe(data)                                            (0x00000002&((data)<<1))
#define MIS_U1LSR_dr(data)                                            (0x00000001&(data))
#define MIS_U1LSR_get_rfe(data)                                       ((0x00000080&(data))>>7)
#define MIS_U1LSR_get_temt(data)                                      ((0x00000040&(data))>>6)
#define MIS_U1LSR_get_thre(data)                                      ((0x00000020&(data))>>5)
#define MIS_U1LSR_get_bi(data)                                        ((0x00000010&(data))>>4)
#define MIS_U1LSR_get_fe(data)                                        ((0x00000008&(data))>>3)
#define MIS_U1LSR_get_pe(data)                                        ((0x00000004&(data))>>2)
#define MIS_U1LSR_get_oe(data)                                        ((0x00000002&(data))>>1)
#define MIS_U1LSR_get_dr(data)                                        (0x00000001&(data))

#define MIS_U1MSR                                                     0x1801B238
#define MIS_U1MSR_reg_addr                                            "0xB801B238"
#define MIS_U1MSR_reg                                                 0xB801B238
#define MIS_U1MSR_inst_addr                                           "0x008E"
#define MIS_U1MSR_inst                                                0x008E
#define MIS_U1MSR_dcd_shift                                           (7)
#define MIS_U1MSR_ri_shift                                            (6)
#define MIS_U1MSR_dsr_shift                                           (5)
#define MIS_U1MSR_cts_shift                                           (4)
#define MIS_U1MSR_dcts_shift                                          (0)
#define MIS_U1MSR_dcd_mask                                            (0x00000080)
#define MIS_U1MSR_ri_mask                                             (0x00000040)
#define MIS_U1MSR_dsr_mask                                            (0x00000020)
#define MIS_U1MSR_cts_mask                                            (0x00000010)
#define MIS_U1MSR_dcts_mask                                           (0x00000001)
#define MIS_U1MSR_dcd(data)                                           (0x00000080&((data)<<7))
#define MIS_U1MSR_ri(data)                                            (0x00000040&((data)<<6))
#define MIS_U1MSR_dsr(data)                                           (0x00000020&((data)<<5))
#define MIS_U1MSR_cts(data)                                           (0x00000010&((data)<<4))
#define MIS_U1MSR_dcts(data)                                          (0x00000001&(data))
#define MIS_U1MSR_get_dcd(data)                                       ((0x00000080&(data))>>7)
#define MIS_U1MSR_get_ri(data)                                        ((0x00000040&(data))>>6)
#define MIS_U1MSR_get_dsr(data)                                       ((0x00000020&(data))>>5)
#define MIS_U1MSR_get_cts(data)                                       ((0x00000010&(data))>>4)
#define MIS_U1MSR_get_dcts(data)                                      (0x00000001&(data))

#define MIS_U1SCR                                                     0x1801B23C
#define MIS_U1SCR_reg_addr                                            "0xB801B23C"
#define MIS_U1SCR_reg                                                 0xB801B23C
#define MIS_U1SCR_inst_addr                                           "0x008F"
#define MIS_U1SCR_inst                                                0x008F
#define MIS_U1SCR_scr_shift                                           (0)
#define MIS_U1SCR_scr_mask                                            (0x000000FF)
#define MIS_U1SCR_scr(data)                                           (0x000000FF&(data))
#define MIS_U1SCR_get_scr(data)                                       (0x000000FF&(data))

#define MIS_IC_CON                                                    0x1801B300
#define MIS_IC_CON_reg_addr                                           "0xB801B300"
#define MIS_IC_CON_reg                                                0xB801B300
#define MIS_IC_CON_inst_addr                                          "0x00C0"
#define MIS_IC_CON_inst                                               0x00C0
#define MIS_IC_CON_ic_slave_disable_shift                             (6)
#define MIS_IC_CON_ic_restart_en_shift                                (5)
#define MIS_IC_CON_ic_10bitaddr_master_shift                          (4)
#define MIS_IC_CON_ic_10bitaddr_slave_shift                           (3)
#define MIS_IC_CON_speed_shift                                        (1)
#define MIS_IC_CON_master_mode_shift                                  (0)
#define MIS_IC_CON_ic_slave_disable_mask                              (0x00000040)
#define MIS_IC_CON_ic_restart_en_mask                                 (0x00000020)
#define MIS_IC_CON_ic_10bitaddr_master_mask                           (0x00000010)
#define MIS_IC_CON_ic_10bitaddr_slave_mask                            (0x00000008)
#define MIS_IC_CON_speed_mask                                         (0x00000006)
#define MIS_IC_CON_master_mode_mask                                   (0x00000001)
#define MIS_IC_CON_ic_slave_disable(data)                             (0x00000040&((data)<<6))
#define MIS_IC_CON_ic_restart_en(data)                                (0x00000020&((data)<<5))
#define MIS_IC_CON_ic_10bitaddr_master(data)                          (0x00000010&((data)<<4))
#define MIS_IC_CON_ic_10bitaddr_slave(data)                           (0x00000008&((data)<<3))
#define MIS_IC_CON_speed(data)                                        (0x00000006&((data)<<1))
#define MIS_IC_CON_master_mode(data)                                  (0x00000001&(data))
#define MIS_IC_CON_get_ic_slave_disable(data)                         ((0x00000040&(data))>>6)
#define MIS_IC_CON_get_ic_restart_en(data)                            ((0x00000020&(data))>>5)
#define MIS_IC_CON_get_ic_10bitaddr_master(data)                      ((0x00000010&(data))>>4)
#define MIS_IC_CON_get_ic_10bitaddr_slave(data)                       ((0x00000008&(data))>>3)
#define MIS_IC_CON_get_speed(data)                                    ((0x00000006&(data))>>1)
#define MIS_IC_CON_get_master_mode(data)                              (0x00000001&(data))

#define MIS_IC_TAR                                                    0x1801B304
#define MIS_IC_TAR_reg_addr                                           "0xB801B304"
#define MIS_IC_TAR_reg                                                0xB801B304
#define MIS_IC_TAR_inst_addr                                          "0x00C1"
#define MIS_IC_TAR_inst                                               0x00C1
#define MIS_IC_TAR_special_shift                                      (11)
#define MIS_IC_TAR_gc_or_start_shift                                  (10)
#define MIS_IC_TAR_ic_tar_shift                                       (0)
#define MIS_IC_TAR_special_mask                                       (0x00000800)
#define MIS_IC_TAR_gc_or_start_mask                                   (0x00000400)
#define MIS_IC_TAR_ic_tar_mask                                        (0x000003FF)
#define MIS_IC_TAR_special(data)                                      (0x00000800&((data)<<11))
#define MIS_IC_TAR_gc_or_start(data)                                  (0x00000400&((data)<<10))
#define MIS_IC_TAR_ic_tar(data)                                       (0x000003FF&(data))
#define MIS_IC_TAR_get_special(data)                                  ((0x00000800&(data))>>11)
#define MIS_IC_TAR_get_gc_or_start(data)                              ((0x00000400&(data))>>10)
#define MIS_IC_TAR_get_ic_tar(data)                                   (0x000003FF&(data))

#define MIS_IC_SAR                                                    0x1801B308
#define MIS_IC_SAR_reg_addr                                           "0xB801B308"
#define MIS_IC_SAR_reg                                                0xB801B308
#define MIS_IC_SAR_inst_addr                                          "0x00C2"
#define MIS_IC_SAR_inst                                               0x00C2
#define MIS_IC_SAR_ic_sar_shift                                       (0)
#define MIS_IC_SAR_ic_sar_mask                                        (0x000003FF)
#define MIS_IC_SAR_ic_sar(data)                                       (0x000003FF&(data))
#define MIS_IC_SAR_get_ic_sar(data)                                   (0x000003FF&(data))

#define MIS_IC_HS_MADDR                                               0x1801B30C
#define MIS_IC_HS_MADDR_reg_addr                                      "0xB801B30C"
#define MIS_IC_HS_MADDR_reg                                           0xB801B30C
#define MIS_IC_HS_MADDR_inst_addr                                     "0x00C3"
#define MIS_IC_HS_MADDR_inst                                          0x00C3
#define MIS_IC_HS_MADDR_ic_hs_mar_shift                               (0)
#define MIS_IC_HS_MADDR_ic_hs_mar_mask                                (0x00000007)
#define MIS_IC_HS_MADDR_ic_hs_mar(data)                               (0x00000007&(data))
#define MIS_IC_HS_MADDR_get_ic_hs_mar(data)                           (0x00000007&(data))

#define MIS_IC_DATA_CMD                                               0x1801B310
#define MIS_IC_DATA_CMD_reg_addr                                      "0xB801B310"
#define MIS_IC_DATA_CMD_reg                                           0xB801B310
#define MIS_IC_DATA_CMD_inst_addr                                     "0x00C4"
#define MIS_IC_DATA_CMD_inst                                          0x00C4
#define MIS_IC_DATA_CMD_cmd_shift                                     (8)
#define MIS_IC_DATA_CMD_dat_shift                                     (0)
#define MIS_IC_DATA_CMD_cmd_mask                                      (0x00000100)
#define MIS_IC_DATA_CMD_dat_mask                                      (0x000000FF)
#define MIS_IC_DATA_CMD_cmd(data)                                     (0x00000100&((data)<<8))
#define MIS_IC_DATA_CMD_dat(data)                                     (0x000000FF&(data))
#define MIS_IC_DATA_CMD_get_cmd(data)                                 ((0x00000100&(data))>>8)
#define MIS_IC_DATA_CMD_get_dat(data)                                 (0x000000FF&(data))

#define MIS_IC_SS_SCL_HCNT                                            0x1801B314
#define MIS_IC_SS_SCL_HCNT_reg_addr                                   "0xB801B314"
#define MIS_IC_SS_SCL_HCNT_reg                                        0xB801B314
#define MIS_IC_SS_SCL_HCNT_inst_addr                                  "0x00C5"
#define MIS_IC_SS_SCL_HCNT_inst                                       0x00C5
#define MIS_IC_SS_SCL_HCNT_ic_ss_scl_hcnt_shift                       (0)
#define MIS_IC_SS_SCL_HCNT_ic_ss_scl_hcnt_mask                        (0x0000FFFF)
#define MIS_IC_SS_SCL_HCNT_ic_ss_scl_hcnt(data)                       (0x0000FFFF&(data))
#define MIS_IC_SS_SCL_HCNT_get_ic_ss_scl_hcnt(data)                   (0x0000FFFF&(data))

#define MIS_IC_SS_SCL_LCNT                                            0x1801B318
#define MIS_IC_SS_SCL_LCNT_reg_addr                                   "0xB801B318"
#define MIS_IC_SS_SCL_LCNT_reg                                        0xB801B318
#define MIS_IC_SS_SCL_LCNT_inst_addr                                  "0x00C6"
#define MIS_IC_SS_SCL_LCNT_inst                                       0x00C6
#define MIS_IC_SS_SCL_LCNT_ic_ss_scl_lcnt_shift                       (0)
#define MIS_IC_SS_SCL_LCNT_ic_ss_scl_lcnt_mask                        (0x0000FFFF)
#define MIS_IC_SS_SCL_LCNT_ic_ss_scl_lcnt(data)                       (0x0000FFFF&(data))
#define MIS_IC_SS_SCL_LCNT_get_ic_ss_scl_lcnt(data)                   (0x0000FFFF&(data))

#define MIS_IC_FS_SCL_HCNT                                            0x1801B31C
#define MIS_IC_FS_SCL_HCNT_reg_addr                                   "0xB801B31C"
#define MIS_IC_FS_SCL_HCNT_reg                                        0xB801B31C
#define MIS_IC_FS_SCL_HCNT_inst_addr                                  "0x00C7"
#define MIS_IC_FS_SCL_HCNT_inst                                       0x00C7
#define MIS_IC_FS_SCL_HCNT_ic_fs_scl_hcnt_shift                       (0)
#define MIS_IC_FS_SCL_HCNT_ic_fs_scl_hcnt_mask                        (0x0000FFFF)
#define MIS_IC_FS_SCL_HCNT_ic_fs_scl_hcnt(data)                       (0x0000FFFF&(data))
#define MIS_IC_FS_SCL_HCNT_get_ic_fs_scl_hcnt(data)                   (0x0000FFFF&(data))

#define MIS_IC_FS_SCL_LCNT                                            0x1801B320
#define MIS_IC_FS_SCL_LCNT_reg_addr                                   "0xB801B320"
#define MIS_IC_FS_SCL_LCNT_reg                                        0xB801B320
#define MIS_IC_FS_SCL_LCNT_inst_addr                                  "0x00C8"
#define MIS_IC_FS_SCL_LCNT_inst                                       0x00C8
#define MIS_IC_FS_SCL_LCNT_ic_fs_scl_lcnt_shift                       (0)
#define MIS_IC_FS_SCL_LCNT_ic_fs_scl_lcnt_mask                        (0x0000FFFF)
#define MIS_IC_FS_SCL_LCNT_ic_fs_scl_lcnt(data)                       (0x0000FFFF&(data))
#define MIS_IC_FS_SCL_LCNT_get_ic_fs_scl_lcnt(data)                   (0x0000FFFF&(data))

#define MIS_IC_RAW_INTR_STAT                                          0x1801B334
#define MIS_IC_RAW_INTR_STAT_reg_addr                                 "0xB801B334"
#define MIS_IC_RAW_INTR_STAT_reg                                      0xB801B334
#define MIS_IC_RAW_INTR_STAT_inst_addr                                "0x00CD"
#define MIS_IC_RAW_INTR_STAT_inst                                     0x00CD
#define MIS_IC_RAW_INTR_STAT_gen_call_shift                           (11)
#define MIS_IC_RAW_INTR_STAT_start_det_shift                          (10)
#define MIS_IC_RAW_INTR_STAT_stop_det_shift                           (9)
#define MIS_IC_RAW_INTR_STAT_activity_shift                           (8)
#define MIS_IC_RAW_INTR_STAT_rx_done_shift                            (7)
#define MIS_IC_RAW_INTR_STAT_tx_abrt_shift                            (6)
#define MIS_IC_RAW_INTR_STAT_rd_req_shift                             (5)
#define MIS_IC_RAW_INTR_STAT_tx_empty_shift                           (4)
#define MIS_IC_RAW_INTR_STAT_tx_over_shift                            (3)
#define MIS_IC_RAW_INTR_STAT_rx_full_shift                            (2)
#define MIS_IC_RAW_INTR_STAT_rx_over_shift                            (1)
#define MIS_IC_RAW_INTR_STAT_rx_under_shift                           (0)
#define MIS_IC_RAW_INTR_STAT_gen_call_mask                            (0x00000800)
#define MIS_IC_RAW_INTR_STAT_start_det_mask                           (0x00000400)
#define MIS_IC_RAW_INTR_STAT_stop_det_mask                            (0x00000200)
#define MIS_IC_RAW_INTR_STAT_activity_mask                            (0x00000100)
#define MIS_IC_RAW_INTR_STAT_rx_done_mask                             (0x00000080)
#define MIS_IC_RAW_INTR_STAT_tx_abrt_mask                             (0x00000040)
#define MIS_IC_RAW_INTR_STAT_rd_req_mask                              (0x00000020)
#define MIS_IC_RAW_INTR_STAT_tx_empty_mask                            (0x00000010)
#define MIS_IC_RAW_INTR_STAT_tx_over_mask                             (0x00000008)
#define MIS_IC_RAW_INTR_STAT_rx_full_mask                             (0x00000004)
#define MIS_IC_RAW_INTR_STAT_rx_over_mask                             (0x00000002)
#define MIS_IC_RAW_INTR_STAT_rx_under_mask                            (0x00000001)
#define MIS_IC_RAW_INTR_STAT_gen_call(data)                           (0x00000800&((data)<<11))
#define MIS_IC_RAW_INTR_STAT_start_det(data)                          (0x00000400&((data)<<10))
#define MIS_IC_RAW_INTR_STAT_stop_det(data)                           (0x00000200&((data)<<9))
#define MIS_IC_RAW_INTR_STAT_activity(data)                           (0x00000100&((data)<<8))
#define MIS_IC_RAW_INTR_STAT_rx_done(data)                            (0x00000080&((data)<<7))
#define MIS_IC_RAW_INTR_STAT_tx_abrt(data)                            (0x00000040&((data)<<6))
#define MIS_IC_RAW_INTR_STAT_rd_req(data)                             (0x00000020&((data)<<5))
#define MIS_IC_RAW_INTR_STAT_tx_empty(data)                           (0x00000010&((data)<<4))
#define MIS_IC_RAW_INTR_STAT_tx_over(data)                            (0x00000008&((data)<<3))
#define MIS_IC_RAW_INTR_STAT_rx_full(data)                            (0x00000004&((data)<<2))
#define MIS_IC_RAW_INTR_STAT_rx_over(data)                            (0x00000002&((data)<<1))
#define MIS_IC_RAW_INTR_STAT_rx_under(data)                           (0x00000001&(data))
#define MIS_IC_RAW_INTR_STAT_get_gen_call(data)                       ((0x00000800&(data))>>11)
#define MIS_IC_RAW_INTR_STAT_get_start_det(data)                      ((0x00000400&(data))>>10)
#define MIS_IC_RAW_INTR_STAT_get_stop_det(data)                       ((0x00000200&(data))>>9)
#define MIS_IC_RAW_INTR_STAT_get_activity(data)                       ((0x00000100&(data))>>8)
#define MIS_IC_RAW_INTR_STAT_get_rx_done(data)                        ((0x00000080&(data))>>7)
#define MIS_IC_RAW_INTR_STAT_get_tx_abrt(data)                        ((0x00000040&(data))>>6)
#define MIS_IC_RAW_INTR_STAT_get_rd_req(data)                         ((0x00000020&(data))>>5)
#define MIS_IC_RAW_INTR_STAT_get_tx_empty(data)                       ((0x00000010&(data))>>4)
#define MIS_IC_RAW_INTR_STAT_get_tx_over(data)                        ((0x00000008&(data))>>3)
#define MIS_IC_RAW_INTR_STAT_get_rx_full(data)                        ((0x00000004&(data))>>2)
#define MIS_IC_RAW_INTR_STAT_get_rx_over(data)                        ((0x00000002&(data))>>1)
#define MIS_IC_RAW_INTR_STAT_get_rx_under(data)                       (0x00000001&(data))

#define MIS_IC_INTR_MASK                                              0x1801B330
#define MIS_IC_INTR_MASK_reg_addr                                     "0xB801B330"
#define MIS_IC_INTR_MASK_reg                                          0xB801B330
#define MIS_IC_INTR_MASK_inst_addr                                    "0x00CC"
#define MIS_IC_INTR_MASK_inst                                         0x00CC
#define MIS_IC_INTR_MASK_m_gen_call_shift                             (11)
#define MIS_IC_INTR_MASK_m_start_det_shift                            (10)
#define MIS_IC_INTR_MASK_m_stop_det_shift                             (9)
#define MIS_IC_INTR_MASK_m_activity_shift                             (8)
#define MIS_IC_INTR_MASK_m_rx_done_shift                              (7)
#define MIS_IC_INTR_MASK_m_tx_abrt_shift                              (6)
#define MIS_IC_INTR_MASK_m_rd_req_shift                               (5)
#define MIS_IC_INTR_MASK_m_tx_empty_shift                             (4)
#define MIS_IC_INTR_MASK_m_tx_over_shift                              (3)
#define MIS_IC_INTR_MASK_m_rx_full_shift                              (2)
#define MIS_IC_INTR_MASK_m_rx_over_shift                              (1)
#define MIS_IC_INTR_MASK_m_rx_under_shift                             (0)
#define MIS_IC_INTR_MASK_m_gen_call_mask                              (0x00000800)
#define MIS_IC_INTR_MASK_m_start_det_mask                             (0x00000400)
#define MIS_IC_INTR_MASK_m_stop_det_mask                              (0x00000200)
#define MIS_IC_INTR_MASK_m_activity_mask                              (0x00000100)
#define MIS_IC_INTR_MASK_m_rx_done_mask                               (0x00000080)
#define MIS_IC_INTR_MASK_m_tx_abrt_mask                               (0x00000040)
#define MIS_IC_INTR_MASK_m_rd_req_mask                                (0x00000020)
#define MIS_IC_INTR_MASK_m_tx_empty_mask                              (0x00000010)
#define MIS_IC_INTR_MASK_m_tx_over_mask                               (0x00000008)
#define MIS_IC_INTR_MASK_m_rx_full_mask                               (0x00000004)
#define MIS_IC_INTR_MASK_m_rx_over_mask                               (0x00000002)
#define MIS_IC_INTR_MASK_m_rx_under_mask                              (0x00000001)
#define MIS_IC_INTR_MASK_m_gen_call(data)                             (0x00000800&((data)<<11))
#define MIS_IC_INTR_MASK_m_start_det(data)                            (0x00000400&((data)<<10))
#define MIS_IC_INTR_MASK_m_stop_det(data)                             (0x00000200&((data)<<9))
#define MIS_IC_INTR_MASK_m_activity(data)                             (0x00000100&((data)<<8))
#define MIS_IC_INTR_MASK_m_rx_done(data)                              (0x00000080&((data)<<7))
#define MIS_IC_INTR_MASK_m_tx_abrt(data)                              (0x00000040&((data)<<6))
#define MIS_IC_INTR_MASK_m_rd_req(data)                               (0x00000020&((data)<<5))
#define MIS_IC_INTR_MASK_m_tx_empty(data)                             (0x00000010&((data)<<4))
#define MIS_IC_INTR_MASK_m_tx_over(data)                              (0x00000008&((data)<<3))
#define MIS_IC_INTR_MASK_m_rx_full(data)                              (0x00000004&((data)<<2))
#define MIS_IC_INTR_MASK_m_rx_over(data)                              (0x00000002&((data)<<1))
#define MIS_IC_INTR_MASK_m_rx_under(data)                             (0x00000001&(data))
#define MIS_IC_INTR_MASK_get_m_gen_call(data)                         ((0x00000800&(data))>>11)
#define MIS_IC_INTR_MASK_get_m_start_det(data)                        ((0x00000400&(data))>>10)
#define MIS_IC_INTR_MASK_get_m_stop_det(data)                         ((0x00000200&(data))>>9)
#define MIS_IC_INTR_MASK_get_m_activity(data)                         ((0x00000100&(data))>>8)
#define MIS_IC_INTR_MASK_get_m_rx_done(data)                          ((0x00000080&(data))>>7)
#define MIS_IC_INTR_MASK_get_m_tx_abrt(data)                          ((0x00000040&(data))>>6)
#define MIS_IC_INTR_MASK_get_m_rd_req(data)                           ((0x00000020&(data))>>5)
#define MIS_IC_INTR_MASK_get_m_tx_empty(data)                         ((0x00000010&(data))>>4)
#define MIS_IC_INTR_MASK_get_m_tx_over(data)                          ((0x00000008&(data))>>3)
#define MIS_IC_INTR_MASK_get_m_rx_full(data)                          ((0x00000004&(data))>>2)
#define MIS_IC_INTR_MASK_get_m_rx_over(data)                          ((0x00000002&(data))>>1)
#define MIS_IC_INTR_MASK_get_m_rx_under(data)                         (0x00000001&(data))

#define MIS_IC_INTR_STAT                                              0x1801B32C
#define MIS_IC_INTR_STAT_reg_addr                                     "0xB801B32C"
#define MIS_IC_INTR_STAT_reg                                          0xB801B32C
#define MIS_IC_INTR_STAT_inst_addr                                    "0x00CB"
#define MIS_IC_INTR_STAT_inst                                         0x00CB
#define MIS_IC_INTR_STAT_r_gen_call_shift                             (11)
#define MIS_IC_INTR_STAT_r_start_det_shift                            (10)
#define MIS_IC_INTR_STAT_r_stop_det_shift                             (9)
#define MIS_IC_INTR_STAT_r_activity_shift                             (8)
#define MIS_IC_INTR_STAT_r_rx_done_shift                              (7)
#define MIS_IC_INTR_STAT_r_tx_abrt_shift                              (6)
#define MIS_IC_INTR_STAT_r_rd_req_shift                               (5)
#define MIS_IC_INTR_STAT_r_tx_empty_shift                             (4)
#define MIS_IC_INTR_STAT_r_tx_over_shift                              (3)
#define MIS_IC_INTR_STAT_r_rx_full_shift                              (2)
#define MIS_IC_INTR_STAT_r_rx_over_shift                              (1)
#define MIS_IC_INTR_STAT_r_rx_under_shift                             (0)
#define MIS_IC_INTR_STAT_r_gen_call_mask                              (0x00000800)
#define MIS_IC_INTR_STAT_r_start_det_mask                             (0x00000400)
#define MIS_IC_INTR_STAT_r_stop_det_mask                              (0x00000200)
#define MIS_IC_INTR_STAT_r_activity_mask                              (0x00000100)
#define MIS_IC_INTR_STAT_r_rx_done_mask                               (0x00000080)
#define MIS_IC_INTR_STAT_r_tx_abrt_mask                               (0x00000040)
#define MIS_IC_INTR_STAT_r_rd_req_mask                                (0x00000020)
#define MIS_IC_INTR_STAT_r_tx_empty_mask                              (0x00000010)
#define MIS_IC_INTR_STAT_r_tx_over_mask                               (0x00000008)
#define MIS_IC_INTR_STAT_r_rx_full_mask                               (0x00000004)
#define MIS_IC_INTR_STAT_r_rx_over_mask                               (0x00000002)
#define MIS_IC_INTR_STAT_r_rx_under_mask                              (0x00000001)
#define MIS_IC_INTR_STAT_r_gen_call(data)                             (0x00000800&((data)<<11))
#define MIS_IC_INTR_STAT_r_start_det(data)                            (0x00000400&((data)<<10))
#define MIS_IC_INTR_STAT_r_stop_det(data)                             (0x00000200&((data)<<9))
#define MIS_IC_INTR_STAT_r_activity(data)                             (0x00000100&((data)<<8))
#define MIS_IC_INTR_STAT_r_rx_done(data)                              (0x00000080&((data)<<7))
#define MIS_IC_INTR_STAT_r_tx_abrt(data)                              (0x00000040&((data)<<6))
#define MIS_IC_INTR_STAT_r_rd_req(data)                               (0x00000020&((data)<<5))
#define MIS_IC_INTR_STAT_r_tx_empty(data)                             (0x00000010&((data)<<4))
#define MIS_IC_INTR_STAT_r_tx_over(data)                              (0x00000008&((data)<<3))
#define MIS_IC_INTR_STAT_r_rx_full(data)                              (0x00000004&((data)<<2))
#define MIS_IC_INTR_STAT_r_rx_over(data)                              (0x00000002&((data)<<1))
#define MIS_IC_INTR_STAT_r_rx_under(data)                             (0x00000001&(data))
#define MIS_IC_INTR_STAT_get_r_gen_call(data)                         ((0x00000800&(data))>>11)
#define MIS_IC_INTR_STAT_get_r_start_det(data)                        ((0x00000400&(data))>>10)
#define MIS_IC_INTR_STAT_get_r_stop_det(data)                         ((0x00000200&(data))>>9)
#define MIS_IC_INTR_STAT_get_r_activity(data)                         ((0x00000100&(data))>>8)
#define MIS_IC_INTR_STAT_get_r_rx_done(data)                          ((0x00000080&(data))>>7)
#define MIS_IC_INTR_STAT_get_r_tx_abrt(data)                          ((0x00000040&(data))>>6)
#define MIS_IC_INTR_STAT_get_r_rd_req(data)                           ((0x00000020&(data))>>5)
#define MIS_IC_INTR_STAT_get_r_tx_empty(data)                         ((0x00000010&(data))>>4)
#define MIS_IC_INTR_STAT_get_r_tx_over(data)                          ((0x00000008&(data))>>3)
#define MIS_IC_INTR_STAT_get_r_rx_full(data)                          ((0x00000004&(data))>>2)
#define MIS_IC_INTR_STAT_get_r_rx_over(data)                          ((0x00000002&(data))>>1)
#define MIS_IC_INTR_STAT_get_r_rx_under(data)                         (0x00000001&(data))

#define MIS_IC_RX_TL                                                  0x1801B338
#define MIS_IC_RX_TL_reg_addr                                         "0xB801B338"
#define MIS_IC_RX_TL_reg                                              0xB801B338
#define MIS_IC_RX_TL_inst_addr                                        "0x00CE"
#define MIS_IC_RX_TL_inst                                             0x00CE
#define MIS_IC_RX_TL_rx_tl_shift                                      (0)
#define MIS_IC_RX_TL_rx_tl_mask                                       (0x000000FF)
#define MIS_IC_RX_TL_rx_tl(data)                                      (0x000000FF&(data))
#define MIS_IC_RX_TL_get_rx_tl(data)                                  (0x000000FF&(data))

#define MIS_IC_TX_TL                                                  0x1801B33C
#define MIS_IC_TX_TL_reg_addr                                         "0xB801B33C"
#define MIS_IC_TX_TL_reg                                              0xB801B33C
#define MIS_IC_TX_TL_inst_addr                                        "0x00CF"
#define MIS_IC_TX_TL_inst                                             0x00CF
#define MIS_IC_TX_TL_tx_tl_shift                                      (0)
#define MIS_IC_TX_TL_tx_tl_mask                                       (0x000000FF)
#define MIS_IC_TX_TL_tx_tl(data)                                      (0x000000FF&(data))
#define MIS_IC_TX_TL_get_tx_tl(data)                                  (0x000000FF&(data))

#define MIS_IC_CLR_INTR                                               0x1801B340
#define MIS_IC_CLR_INTR_reg_addr                                      "0xB801B340"
#define MIS_IC_CLR_INTR_reg                                           0xB801B340
#define MIS_IC_CLR_INTR_inst_addr                                     "0x00D0"
#define MIS_IC_CLR_INTR_inst                                          0x00D0
#define MIS_IC_CLR_INTR_clr_intr_shift                                (0)
#define MIS_IC_CLR_INTR_clr_intr_mask                                 (0x00000001)
#define MIS_IC_CLR_INTR_clr_intr(data)                                (0x00000001&(data))
#define MIS_IC_CLR_INTR_get_clr_intr(data)                            (0x00000001&(data))

#define MIS_IC_CLR_RX_UNDER                                           0x1801B344
#define MIS_IC_CLR_RX_UNDER_reg_addr                                  "0xB801B344"
#define MIS_IC_CLR_RX_UNDER_reg                                       0xB801B344
#define MIS_IC_CLR_RX_UNDER_inst_addr                                 "0x00D1"
#define MIS_IC_CLR_RX_UNDER_inst                                      0x00D1
#define MIS_IC_CLR_RX_UNDER_clr_rx_under_shift                        (0)
#define MIS_IC_CLR_RX_UNDER_clr_rx_under_mask                         (0x00000001)
#define MIS_IC_CLR_RX_UNDER_clr_rx_under(data)                        (0x00000001&(data))
#define MIS_IC_CLR_RX_UNDER_get_clr_rx_under(data)                    (0x00000001&(data))

#define MIS_IC_CLR_RX_OVER                                            0x1801B348
#define MIS_IC_CLR_RX_OVER_reg_addr                                   "0xB801B348"
#define MIS_IC_CLR_RX_OVER_reg                                        0xB801B348
#define MIS_IC_CLR_RX_OVER_inst_addr                                  "0x00D2"
#define MIS_IC_CLR_RX_OVER_inst                                       0x00D2
#define MIS_IC_CLR_RX_OVER_clr_rx_over_shift                          (0)
#define MIS_IC_CLR_RX_OVER_clr_rx_over_mask                           (0x00000001)
#define MIS_IC_CLR_RX_OVER_clr_rx_over(data)                          (0x00000001&(data))
#define MIS_IC_CLR_RX_OVER_get_clr_rx_over(data)                      (0x00000001&(data))

#define MIS_IC_CLR_TX_OVER                                            0x1801B34C
#define MIS_IC_CLR_TX_OVER_reg_addr                                   "0xB801B34C"
#define MIS_IC_CLR_TX_OVER_reg                                        0xB801B34C
#define MIS_IC_CLR_TX_OVER_inst_addr                                  "0x00D3"
#define MIS_IC_CLR_TX_OVER_inst                                       0x00D3
#define MIS_IC_CLR_TX_OVER_clr_tx_over_shift                          (0)
#define MIS_IC_CLR_TX_OVER_clr_tx_over_mask                           (0x00000001)
#define MIS_IC_CLR_TX_OVER_clr_tx_over(data)                          (0x00000001&(data))
#define MIS_IC_CLR_TX_OVER_get_clr_tx_over(data)                      (0x00000001&(data))

#define MIS_IC_CLR_RD_REQ                                             0x1801B350
#define MIS_IC_CLR_RD_REQ_reg_addr                                    "0xB801B350"
#define MIS_IC_CLR_RD_REQ_reg                                         0xB801B350
#define MIS_IC_CLR_RD_REQ_inst_addr                                   "0x00D4"
#define MIS_IC_CLR_RD_REQ_inst                                        0x00D4
#define MIS_IC_CLR_RD_REQ_clr_rd_req_shift                            (0)
#define MIS_IC_CLR_RD_REQ_clr_rd_req_mask                             (0x00000001)
#define MIS_IC_CLR_RD_REQ_clr_rd_req(data)                            (0x00000001&(data))
#define MIS_IC_CLR_RD_REQ_get_clr_rd_req(data)                        (0x00000001&(data))

#define MIS_IC_CLR_TX_ABRT                                            0x1801B354
#define MIS_IC_CLR_TX_ABRT_reg_addr                                   "0xB801B354"
#define MIS_IC_CLR_TX_ABRT_reg                                        0xB801B354
#define MIS_IC_CLR_TX_ABRT_inst_addr                                  "0x00D5"
#define MIS_IC_CLR_TX_ABRT_inst                                       0x00D5
#define MIS_IC_CLR_TX_ABRT_clr_tx_abrt_shift                          (0)
#define MIS_IC_CLR_TX_ABRT_clr_tx_abrt_mask                           (0x00000001)
#define MIS_IC_CLR_TX_ABRT_clr_tx_abrt(data)                          (0x00000001&(data))
#define MIS_IC_CLR_TX_ABRT_get_clr_tx_abrt(data)                      (0x00000001&(data))

#define MIS_IC_CLR_RX_DONE                                            0x1801B358
#define MIS_IC_CLR_RX_DONE_reg_addr                                   "0xB801B358"
#define MIS_IC_CLR_RX_DONE_reg                                        0xB801B358
#define MIS_IC_CLR_RX_DONE_inst_addr                                  "0x00D6"
#define MIS_IC_CLR_RX_DONE_inst                                       0x00D6
#define MIS_IC_CLR_RX_DONE_clr_rx_done_shift                          (0)
#define MIS_IC_CLR_RX_DONE_clr_rx_done_mask                           (0x00000001)
#define MIS_IC_CLR_RX_DONE_clr_rx_done(data)                          (0x00000001&(data))
#define MIS_IC_CLR_RX_DONE_get_clr_rx_done(data)                      (0x00000001&(data))

#define MIS_IC_CLR_ACTIVITY                                           0x1801B35C
#define MIS_IC_CLR_ACTIVITY_reg_addr                                  "0xB801B35C"
#define MIS_IC_CLR_ACTIVITY_reg                                       0xB801B35C
#define MIS_IC_CLR_ACTIVITY_inst_addr                                 "0x00D7"
#define MIS_IC_CLR_ACTIVITY_inst                                      0x00D7
#define MIS_IC_CLR_ACTIVITY_clr_activity_shift                        (0)
#define MIS_IC_CLR_ACTIVITY_clr_activity_mask                         (0x00000001)
#define MIS_IC_CLR_ACTIVITY_clr_activity(data)                        (0x00000001&(data))
#define MIS_IC_CLR_ACTIVITY_get_clr_activity(data)                    (0x00000001&(data))

#define MIS_IC_CLR_STOP_DET                                           0x1801B360
#define MIS_IC_CLR_STOP_DET_reg_addr                                  "0xB801B360"
#define MIS_IC_CLR_STOP_DET_reg                                       0xB801B360
#define MIS_IC_CLR_STOP_DET_inst_addr                                 "0x00D8"
#define MIS_IC_CLR_STOP_DET_inst                                      0x00D8
#define MIS_IC_CLR_STOP_DET_clr_stop_det_shift                        (0)
#define MIS_IC_CLR_STOP_DET_clr_stop_det_mask                         (0x00000001)
#define MIS_IC_CLR_STOP_DET_clr_stop_det(data)                        (0x00000001&(data))
#define MIS_IC_CLR_STOP_DET_get_clr_stop_det(data)                    (0x00000001&(data))

#define MIS_IC_CLR_START_DET                                          0x1801B364
#define MIS_IC_CLR_START_DET_reg_addr                                 "0xB801B364"
#define MIS_IC_CLR_START_DET_reg                                      0xB801B364
#define MIS_IC_CLR_START_DET_inst_addr                                "0x00D9"
#define MIS_IC_CLR_START_DET_inst                                     0x00D9
#define MIS_IC_CLR_START_DET_clr_start_det_shift                      (0)
#define MIS_IC_CLR_START_DET_clr_start_det_mask                       (0x00000001)
#define MIS_IC_CLR_START_DET_clr_start_det(data)                      (0x00000001&(data))
#define MIS_IC_CLR_START_DET_get_clr_start_det(data)                  (0x00000001&(data))

#define MIS_IC_CLR_GEN_CALL                                           0x1801B368
#define MIS_IC_CLR_GEN_CALL_reg_addr                                  "0xB801B368"
#define MIS_IC_CLR_GEN_CALL_reg                                       0xB801B368
#define MIS_IC_CLR_GEN_CALL_inst_addr                                 "0x00DA"
#define MIS_IC_CLR_GEN_CALL_inst                                      0x00DA
#define MIS_IC_CLR_GEN_CALL_clr_gen_call_shift                        (0)
#define MIS_IC_CLR_GEN_CALL_clr_gen_call_mask                         (0x00000001)
#define MIS_IC_CLR_GEN_CALL_clr_gen_call(data)                        (0x00000001&(data))
#define MIS_IC_CLR_GEN_CALL_get_clr_gen_call(data)                    (0x00000001&(data))

#define MIS_IC_ENABLE                                                 0x1801B36C
#define MIS_IC_ENABLE_reg_addr                                        "0xB801B36C"
#define MIS_IC_ENABLE_reg                                             0xB801B36C
#define MIS_IC_ENABLE_inst_addr                                       "0x00DB"
#define MIS_IC_ENABLE_inst                                            0x00DB
#define MIS_IC_ENABLE_enable_shift                                    (0)
#define MIS_IC_ENABLE_enable_mask                                     (0x00000001)
#define MIS_IC_ENABLE_enable(data)                                    (0x00000001&(data))
#define MIS_IC_ENABLE_get_enable(data)                                (0x00000001&(data))

#define MIS_IC_STATUS                                                 0x1801B370
#define MIS_IC_STATUS_reg_addr                                        "0xB801B370"
#define MIS_IC_STATUS_reg                                             0xB801B370
#define MIS_IC_STATUS_inst_addr                                       "0x00DC"
#define MIS_IC_STATUS_inst                                            0x00DC
#define MIS_IC_STATUS_rff_shift                                       (4)
#define MIS_IC_STATUS_rfne_shift                                      (3)
#define MIS_IC_STATUS_tfe_shift                                       (2)
#define MIS_IC_STATUS_tfnf_shift                                      (1)
#define MIS_IC_STATUS_activity_shift                                  (0)
#define MIS_IC_STATUS_rff_mask                                        (0x00000010)
#define MIS_IC_STATUS_rfne_mask                                       (0x00000008)
#define MIS_IC_STATUS_tfe_mask                                        (0x00000004)
#define MIS_IC_STATUS_tfnf_mask                                       (0x00000002)
#define MIS_IC_STATUS_activity_mask                                   (0x00000001)
#define MIS_IC_STATUS_rff(data)                                       (0x00000010&((data)<<4))
#define MIS_IC_STATUS_rfne(data)                                      (0x00000008&((data)<<3))
#define MIS_IC_STATUS_tfe(data)                                       (0x00000004&((data)<<2))
#define MIS_IC_STATUS_tfnf(data)                                      (0x00000002&((data)<<1))
#define MIS_IC_STATUS_activity(data)                                  (0x00000001&(data))
#define MIS_IC_STATUS_get_rff(data)                                   ((0x00000010&(data))>>4)
#define MIS_IC_STATUS_get_rfne(data)                                  ((0x00000008&(data))>>3)
#define MIS_IC_STATUS_get_tfe(data)                                   ((0x00000004&(data))>>2)
#define MIS_IC_STATUS_get_tfnf(data)                                  ((0x00000002&(data))>>1)
#define MIS_IC_STATUS_get_activity(data)                              (0x00000001&(data))

#define MIS_IC_TXFLR                                                  0x1801B374
#define MIS_IC_TXFLR_reg_addr                                         "0xB801B374"
#define MIS_IC_TXFLR_reg                                              0xB801B374
#define MIS_IC_TXFLR_inst_addr                                        "0x00DD"
#define MIS_IC_TXFLR_inst                                             0x00DD
#define MIS_IC_TXFLR_txflr_shift                                      (0)
#define MIS_IC_TXFLR_txflr_mask                                       (0x00000001)
#define MIS_IC_TXFLR_txflr(data)                                      (0x00000001&(data))
#define MIS_IC_TXFLR_get_txflr(data)                                  (0x00000001&(data))

#define MIS_IC_RXFLR                                                  0x1801B378
#define MIS_IC_RXFLR_reg_addr                                         "0xB801B378"
#define MIS_IC_RXFLR_reg                                              0xB801B378
#define MIS_IC_RXFLR_inst_addr                                        "0x00DE"
#define MIS_IC_RXFLR_inst                                             0x00DE
#define MIS_IC_RXFLR_rxflr_shift                                      (0)
#define MIS_IC_RXFLR_rxflr_mask                                       (0x00000001)
#define MIS_IC_RXFLR_rxflr(data)                                      (0x00000001&(data))
#define MIS_IC_RXFLR_get_rxflr(data)                                  (0x00000001&(data))

#define MIS_IC_TX_ABRT_SOURCE                                         0x1801B380
#define MIS_IC_TX_ABRT_SOURCE_reg_addr                                "0xB801B380"
#define MIS_IC_TX_ABRT_SOURCE_reg                                     0xB801B380
#define MIS_IC_TX_ABRT_SOURCE_inst_addr                               "0x00E0"
#define MIS_IC_TX_ABRT_SOURCE_inst                                    0x00E0
#define MIS_IC_TX_ABRT_SOURCE_abrt_slvrd_intx_shift                   (15)
#define MIS_IC_TX_ABRT_SOURCE_abrt_slv_arblost_shift                  (14)
#define MIS_IC_TX_ABRT_SOURCE_abrt_slvflush_txfifo_shift              (13)
#define MIS_IC_TX_ABRT_SOURCE_arb_lost_shift                          (12)
#define MIS_IC_TX_ABRT_SOURCE_arb_master_dis_shift                    (11)
#define MIS_IC_TX_ABRT_SOURCE_abrt_10b_rd_norstrt_shift               (10)
#define MIS_IC_TX_ABRT_SOURCE_abrt_sbyte_norstrt_shift                (9)
#define MIS_IC_TX_ABRT_SOURCE_abrt_hs_norstrt_shift                   (8)
#define MIS_IC_TX_ABRT_SOURCE_abrt_sbyte_ackdet_shift                 (7)
#define MIS_IC_TX_ABRT_SOURCE_abrt_hs_ackdet_shift                    (6)
#define MIS_IC_TX_ABRT_SOURCE_abrt_gcall_read_shift                   (5)
#define MIS_IC_TX_ABRT_SOURCE_abrt_gcall_noack_shift                  (4)
#define MIS_IC_TX_ABRT_SOURCE_abrt_txdata_noack_shift                 (3)
#define MIS_IC_TX_ABRT_SOURCE_abrt_10addr2_noack_shift                (2)
#define MIS_IC_TX_ABRT_SOURCE_abrt_10addr1_noack_shift                (1)
#define MIS_IC_TX_ABRT_SOURCE_abrt_7b_addr_noack_shift                (0)
#define MIS_IC_TX_ABRT_SOURCE_abrt_slvrd_intx_mask                    (0x00008000)
#define MIS_IC_TX_ABRT_SOURCE_abrt_slv_arblost_mask                   (0x00004000)
#define MIS_IC_TX_ABRT_SOURCE_abrt_slvflush_txfifo_mask               (0x00002000)
#define MIS_IC_TX_ABRT_SOURCE_arb_lost_mask                           (0x00001000)
#define MIS_IC_TX_ABRT_SOURCE_arb_master_dis_mask                     (0x00000800)
#define MIS_IC_TX_ABRT_SOURCE_abrt_10b_rd_norstrt_mask                (0x00000400)
#define MIS_IC_TX_ABRT_SOURCE_abrt_sbyte_norstrt_mask                 (0x00000200)
#define MIS_IC_TX_ABRT_SOURCE_abrt_hs_norstrt_mask                    (0x00000100)
#define MIS_IC_TX_ABRT_SOURCE_abrt_sbyte_ackdet_mask                  (0x00000080)
#define MIS_IC_TX_ABRT_SOURCE_abrt_hs_ackdet_mask                     (0x00000040)
#define MIS_IC_TX_ABRT_SOURCE_abrt_gcall_read_mask                    (0x00000020)
#define MIS_IC_TX_ABRT_SOURCE_abrt_gcall_noack_mask                   (0x00000010)
#define MIS_IC_TX_ABRT_SOURCE_abrt_txdata_noack_mask                  (0x00000008)
#define MIS_IC_TX_ABRT_SOURCE_abrt_10addr2_noack_mask                 (0x00000004)
#define MIS_IC_TX_ABRT_SOURCE_abrt_10addr1_noack_mask                 (0x00000002)
#define MIS_IC_TX_ABRT_SOURCE_abrt_7b_addr_noack_mask                 (0x00000001)
#define MIS_IC_TX_ABRT_SOURCE_abrt_slvrd_intx(data)                   (0x00008000&((data)<<15))
#define MIS_IC_TX_ABRT_SOURCE_abrt_slv_arblost(data)                  (0x00004000&((data)<<14))
#define MIS_IC_TX_ABRT_SOURCE_abrt_slvflush_txfifo(data)              (0x00002000&((data)<<13))
#define MIS_IC_TX_ABRT_SOURCE_arb_lost(data)                          (0x00001000&((data)<<12))
#define MIS_IC_TX_ABRT_SOURCE_arb_master_dis(data)                    (0x00000800&((data)<<11))
#define MIS_IC_TX_ABRT_SOURCE_abrt_10b_rd_norstrt(data)               (0x00000400&((data)<<10))
#define MIS_IC_TX_ABRT_SOURCE_abrt_sbyte_norstrt(data)                (0x00000200&((data)<<9))
#define MIS_IC_TX_ABRT_SOURCE_abrt_hs_norstrt(data)                   (0x00000100&((data)<<8))
#define MIS_IC_TX_ABRT_SOURCE_abrt_sbyte_ackdet(data)                 (0x00000080&((data)<<7))
#define MIS_IC_TX_ABRT_SOURCE_abrt_hs_ackdet(data)                    (0x00000040&((data)<<6))
#define MIS_IC_TX_ABRT_SOURCE_abrt_gcall_read(data)                   (0x00000020&((data)<<5))
#define MIS_IC_TX_ABRT_SOURCE_abrt_gcall_noack(data)                  (0x00000010&((data)<<4))
#define MIS_IC_TX_ABRT_SOURCE_abrt_txdata_noack(data)                 (0x00000008&((data)<<3))
#define MIS_IC_TX_ABRT_SOURCE_abrt_10addr2_noack(data)                (0x00000004&((data)<<2))
#define MIS_IC_TX_ABRT_SOURCE_abrt_10addr1_noack(data)                (0x00000002&((data)<<1))
#define MIS_IC_TX_ABRT_SOURCE_abrt_7b_addr_noack(data)                (0x00000001&(data))
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_slvrd_intx(data)               ((0x00008000&(data))>>15)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_slv_arblost(data)              ((0x00004000&(data))>>14)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_slvflush_txfifo(data)          ((0x00002000&(data))>>13)
#define MIS_IC_TX_ABRT_SOURCE_get_arb_lost(data)                      ((0x00001000&(data))>>12)
#define MIS_IC_TX_ABRT_SOURCE_get_arb_master_dis(data)                ((0x00000800&(data))>>11)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_10b_rd_norstrt(data)           ((0x00000400&(data))>>10)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_sbyte_norstrt(data)            ((0x00000200&(data))>>9)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_hs_norstrt(data)               ((0x00000100&(data))>>8)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_sbyte_ackdet(data)             ((0x00000080&(data))>>7)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_hs_ackdet(data)                ((0x00000040&(data))>>6)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_gcall_read(data)               ((0x00000020&(data))>>5)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_gcall_noack(data)              ((0x00000010&(data))>>4)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_txdata_noack(data)             ((0x00000008&(data))>>3)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_10addr2_noack(data)            ((0x00000004&(data))>>2)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_10addr1_noack(data)            ((0x00000002&(data))>>1)
#define MIS_IC_TX_ABRT_SOURCE_get_abrt_7b_addr_noack(data)            (0x00000001&(data))

#define MIS_IC_DMA_CR                                                 0x1801B388
#define MIS_IC_DMA_CR_reg_addr                                        "0xB801B388"
#define MIS_IC_DMA_CR_reg                                             0xB801B388
#define MIS_IC_DMA_CR_inst_addr                                       "0x00E2"
#define MIS_IC_DMA_CR_inst                                            0x00E2
#define MIS_IC_DMA_CR_tdmae_shift                                     (1)
#define MIS_IC_DMA_CR_rdmae_shift                                     (0)
#define MIS_IC_DMA_CR_tdmae_mask                                      (0x00000002)
#define MIS_IC_DMA_CR_rdmae_mask                                      (0x00000001)
#define MIS_IC_DMA_CR_tdmae(data)                                     (0x00000002&((data)<<1))
#define MIS_IC_DMA_CR_rdmae(data)                                     (0x00000001&(data))
#define MIS_IC_DMA_CR_get_tdmae(data)                                 ((0x00000002&(data))>>1)
#define MIS_IC_DMA_CR_get_rdmae(data)                                 (0x00000001&(data))

#define MIS_IC_DMA_TDLR                                               0x1801B38C
#define MIS_IC_DMA_TDLR_reg_addr                                      "0xB801B38C"
#define MIS_IC_DMA_TDLR_reg                                           0xB801B38C
#define MIS_IC_DMA_TDLR_inst_addr                                     "0x00E3"
#define MIS_IC_DMA_TDLR_inst                                          0x00E3
#define MIS_IC_DMA_TDLR_dmatdl_shift                                  (0)
#define MIS_IC_DMA_TDLR_dmatdl_mask                                   (0x00000003)
#define MIS_IC_DMA_TDLR_dmatdl(data)                                  (0x00000003&(data))
#define MIS_IC_DMA_TDLR_get_dmatdl(data)                              (0x00000003&(data))

#define MIS_IC_DMA_RDLR                                               0x1801B390
#define MIS_IC_DMA_RDLR_reg_addr                                      "0xB801B390"
#define MIS_IC_DMA_RDLR_reg                                           0xB801B390
#define MIS_IC_DMA_RDLR_inst_addr                                     "0x00E4"
#define MIS_IC_DMA_RDLR_inst                                          0x00E4
#define MIS_IC_DMA_RDLR_dmardl_shift                                  (0)
#define MIS_IC_DMA_RDLR_dmardl_mask                                   (0x00000003)
#define MIS_IC_DMA_RDLR_dmardl(data)                                  (0x00000003&(data))
#define MIS_IC_DMA_RDLR_get_dmardl(data)                              (0x00000003&(data))

#define MIS_IC_COMP_PARAM_1                                           0x1801B3F4
#define MIS_IC_COMP_PARAM_1_reg_addr                                  "0xB801B3F4"
#define MIS_IC_COMP_PARAM_1_reg                                       0xB801B3F4
#define MIS_IC_COMP_PARAM_1_inst_addr                                 "0x00FD"
#define MIS_IC_COMP_PARAM_1_inst                                      0x00FD
#define MIS_IC_COMP_PARAM_1_tx_buffer_depth_shift                     (16)
#define MIS_IC_COMP_PARAM_1_rx_buffer_depth_shift                     (8)
#define MIS_IC_COMP_PARAM_1_add_encoded_params_shift                  (7)
#define MIS_IC_COMP_PARAM_1_has_dma_shift                             (6)
#define MIS_IC_COMP_PARAM_1_intr_io_shift                             (5)
#define MIS_IC_COMP_PARAM_1_hc_count_values_shift                     (4)
#define MIS_IC_COMP_PARAM_1_max_speed_mode_shift                      (2)
#define MIS_IC_COMP_PARAM_1_apb_data_width_shift                      (0)
#define MIS_IC_COMP_PARAM_1_tx_buffer_depth_mask                      (0x00FF0000)
#define MIS_IC_COMP_PARAM_1_rx_buffer_depth_mask                      (0x0000FF00)
#define MIS_IC_COMP_PARAM_1_add_encoded_params_mask                   (0x00000080)
#define MIS_IC_COMP_PARAM_1_has_dma_mask                              (0x00000040)
#define MIS_IC_COMP_PARAM_1_intr_io_mask                              (0x00000020)
#define MIS_IC_COMP_PARAM_1_hc_count_values_mask                      (0x00000010)
#define MIS_IC_COMP_PARAM_1_max_speed_mode_mask                       (0x0000000C)
#define MIS_IC_COMP_PARAM_1_apb_data_width_mask                       (0x00000003)
#define MIS_IC_COMP_PARAM_1_tx_buffer_depth(data)                     (0x00FF0000&((data)<<16))
#define MIS_IC_COMP_PARAM_1_rx_buffer_depth(data)                     (0x0000FF00&((data)<<8))
#define MIS_IC_COMP_PARAM_1_add_encoded_params(data)                  (0x00000080&((data)<<7))
#define MIS_IC_COMP_PARAM_1_has_dma(data)                             (0x00000040&((data)<<6))
#define MIS_IC_COMP_PARAM_1_intr_io(data)                             (0x00000020&((data)<<5))
#define MIS_IC_COMP_PARAM_1_hc_count_values(data)                     (0x00000010&((data)<<4))
#define MIS_IC_COMP_PARAM_1_max_speed_mode(data)                      (0x0000000C&((data)<<2))
#define MIS_IC_COMP_PARAM_1_apb_data_width(data)                      (0x00000003&(data))
#define MIS_IC_COMP_PARAM_1_get_tx_buffer_depth(data)                 ((0x00FF0000&(data))>>16)
#define MIS_IC_COMP_PARAM_1_get_rx_buffer_depth(data)                 ((0x0000FF00&(data))>>8)
#define MIS_IC_COMP_PARAM_1_get_add_encoded_params(data)              ((0x00000080&(data))>>7)
#define MIS_IC_COMP_PARAM_1_get_has_dma(data)                         ((0x00000040&(data))>>6)
#define MIS_IC_COMP_PARAM_1_get_intr_io(data)                         ((0x00000020&(data))>>5)
#define MIS_IC_COMP_PARAM_1_get_hc_count_values(data)                 ((0x00000010&(data))>>4)
#define MIS_IC_COMP_PARAM_1_get_max_speed_mode(data)                  ((0x0000000C&(data))>>2)
#define MIS_IC_COMP_PARAM_1_get_apb_data_width(data)                  (0x00000003&(data))

#define MIS_IC_COMP_VERSION                                           0x1801B3F8
#define MIS_IC_COMP_VERSION_reg_addr                                  "0xB801B3F8"
#define MIS_IC_COMP_VERSION_reg                                       0xB801B3F8
#define MIS_IC_COMP_VERSION_inst_addr                                 "0x00FE"
#define MIS_IC_COMP_VERSION_inst                                      0x00FE
#define MIS_IC_COMP_VERSION_ic_comp_version_shift                     (0)
#define MIS_IC_COMP_VERSION_ic_comp_version_mask                      (0xFFFFFFFF)
#define MIS_IC_COMP_VERSION_ic_comp_version(data)                     (0xFFFFFFFF&(data))
#define MIS_IC_COMP_VERSION_get_ic_comp_version(data)                 (0xFFFFFFFF&(data))

#define MIS_IC_COMP_TYPE                                              0x1801B3FC
#define MIS_IC_COMP_TYPE_reg_addr                                     "0xB801B3FC"
#define MIS_IC_COMP_TYPE_reg                                          0xB801B3FC
#define MIS_IC_COMP_TYPE_inst_addr                                    "0x00FF"
#define MIS_IC_COMP_TYPE_inst                                         0x00FF
#define MIS_IC_COMP_TYPE_ic_comp_type_shift                           (0)
#define MIS_IC_COMP_TYPE_ic_comp_type_mask                            (0xFFFFFFFF)
#define MIS_IC_COMP_TYPE_ic_comp_type(data)                           (0xFFFFFFFF&(data))
#define MIS_IC_COMP_TYPE_get_ic_comp_type(data)                       (0xFFFFFFFF&(data))

#define MIS_IR_PSR                                                    0x1801B400
#define MIS_IR_PSR_reg_addr                                           "0xB801B400"
#define MIS_IR_PSR_reg                                                0xB801B400
#define MIS_IR_PSR_inst_addr                                          "0x0100"
#define MIS_IR_PSR_inst                                               0x0100
#define MIS_IR_PSR_irrbl_shift                                        (24)
#define MIS_IR_PSR_irrml_shift                                        (16)
#define MIS_IR_PSR_irrdzl_shift                                       (8)
#define MIS_IR_PSR_irrdol_shift                                       (0)
#define MIS_IR_PSR_irrbl_mask                                         (0xFF000000)
#define MIS_IR_PSR_irrml_mask                                         (0x00FF0000)
#define MIS_IR_PSR_irrdzl_mask                                        (0x0000FF00)
#define MIS_IR_PSR_irrdol_mask                                        (0x000000FF)
#define MIS_IR_PSR_irrbl(data)                                        (0xFF000000&((data)<<24))
#define MIS_IR_PSR_irrml(data)                                        (0x00FF0000&((data)<<16))
#define MIS_IR_PSR_irrdzl(data)                                       (0x0000FF00&((data)<<8))
#define MIS_IR_PSR_irrdol(data)                                       (0x000000FF&(data))
#define MIS_IR_PSR_get_irrbl(data)                                    ((0xFF000000&(data))>>24)
#define MIS_IR_PSR_get_irrml(data)                                    ((0x00FF0000&(data))>>16)
#define MIS_IR_PSR_get_irrdzl(data)                                   ((0x0000FF00&(data))>>8)
#define MIS_IR_PSR_get_irrdol(data)                                   (0x000000FF&(data))

#define MIS_IR_PER                                                    0x1801B404
#define MIS_IR_PER_reg_addr                                           "0xB801B404"
#define MIS_IR_PER_reg                                                0xB801B404
#define MIS_IR_PER_inst_addr                                          "0x0101"
#define MIS_IR_PER_inst                                               0x0101
#define MIS_IR_PER_irrdl_shift                                        (16)
#define MIS_IR_PER_irrrl_shift                                        (8)
#define MIS_IR_PER_irrsl_shift                                        (0)
#define MIS_IR_PER_irrdl_mask                                         (0x001F0000)
#define MIS_IR_PER_irrrl_mask                                         (0x0000FF00)
#define MIS_IR_PER_irrsl_mask                                         (0x000000FF)
#define MIS_IR_PER_irrdl(data)                                        (0x001F0000&((data)<<16))
#define MIS_IR_PER_irrrl(data)                                        (0x0000FF00&((data)<<8))
#define MIS_IR_PER_irrsl(data)                                        (0x000000FF&(data))
#define MIS_IR_PER_get_irrdl(data)                                    ((0x001F0000&(data))>>16)
#define MIS_IR_PER_get_irrrl(data)                                    ((0x0000FF00&(data))>>8)
#define MIS_IR_PER_get_irrsl(data)                                    (0x000000FF&(data))

#define MIS_IR_SF                                                     0x1801B408
#define MIS_IR_SF_reg_addr                                            "0xB801B408"
#define MIS_IR_SF_reg                                                 0xB801B408
#define MIS_IR_SF_inst_addr                                           "0x0102"
#define MIS_IR_SF_inst                                                0x0102
#define MIS_IR_SF_irfd_shift                                          (0)
#define MIS_IR_SF_irfd_mask                                           (0x00001FFF)
#define MIS_IR_SF_irfd(data)                                          (0x00001FFF&(data))
#define MIS_IR_SF_get_irfd(data)                                      (0x00001FFF&(data))

#define MIS_IR_DPIR                                                   0x1801B40C
#define MIS_IR_DPIR_reg_addr                                          "0xB801B40C"
#define MIS_IR_DPIR_reg                                               0xB801B40C
#define MIS_IR_DPIR_inst_addr                                         "0x0103"
#define MIS_IR_DPIR_inst                                              0x0103
#define MIS_IR_DPIR_iriotcdp_shift                                    (0)
#define MIS_IR_DPIR_iriotcdp_mask                                     (0x0000FFFF)
#define MIS_IR_DPIR_iriotcdp(data)                                    (0x0000FFFF&(data))
#define MIS_IR_DPIR_get_iriotcdp(data)                                (0x0000FFFF&(data))

#define MIS_IR_CR                                                     0x1801B410
#define MIS_IR_CR_reg_addr                                            "0xB801B410"
#define MIS_IR_CR_reg                                                 0xB801B410
#define MIS_IR_CR_inst_addr                                           "0x0104"
#define MIS_IR_CR_inst                                                0x0104
#define MIS_IR_CR_irsr_shift                                          (31)
#define MIS_IR_CR_mlae_shift                                          (11)
#define MIS_IR_CR_irdvie_shift                                        (10)
#define MIS_IR_CR_irres_shift                                         (9)
#define MIS_IR_CR_irue_shift                                          (8)
#define MIS_IR_CR_ircm_shift                                          (7)
#define MIS_IR_CR_irbme_shift                                         (6)
#define MIS_IR_CR_irdpm_shift                                         (5)
#define MIS_IR_CR_irdn_shift                                          (0)
#define MIS_IR_CR_irsr_mask                                           (0x80000000)
#define MIS_IR_CR_mlae_mask                                           (0x00000800)
#define MIS_IR_CR_irdvie_mask                                         (0x00000400)
#define MIS_IR_CR_irres_mask                                          (0x00000200)
#define MIS_IR_CR_irue_mask                                           (0x00000100)
#define MIS_IR_CR_ircm_mask                                           (0x00000080)
#define MIS_IR_CR_irbme_mask                                          (0x00000040)
#define MIS_IR_CR_irdpm_mask                                          (0x00000020)
#define MIS_IR_CR_irdn_mask                                           (0x0000001F)
#define MIS_IR_CR_irsr(data)                                          (0x80000000&((data)<<31))
#define MIS_IR_CR_mlae(data)                                          (0x00000800&((data)<<11))
#define MIS_IR_CR_irdvie(data)                                        (0x00000400&((data)<<10))
#define MIS_IR_CR_irres(data)                                         (0x00000200&((data)<<9))
#define MIS_IR_CR_irue(data)                                          (0x00000100&((data)<<8))
#define MIS_IR_CR_ircm(data)                                          (0x00000080&((data)<<7))
#define MIS_IR_CR_irbme(data)                                         (0x00000040&((data)<<6))
#define MIS_IR_CR_irdpm(data)                                         (0x00000020&((data)<<5))
#define MIS_IR_CR_irdn(data)                                          (0x0000001F&(data))
#define MIS_IR_CR_get_irsr(data)                                      ((0x80000000&(data))>>31)
#define MIS_IR_CR_get_mlae(data)                                      ((0x00000800&(data))>>11)
#define MIS_IR_CR_get_irdvie(data)                                    ((0x00000400&(data))>>10)
#define MIS_IR_CR_get_irres(data)                                     ((0x00000200&(data))>>9)
#define MIS_IR_CR_get_irue(data)                                      ((0x00000100&(data))>>8)
#define MIS_IR_CR_get_ircm(data)                                      ((0x00000080&(data))>>7)
#define MIS_IR_CR_get_irbme(data)                                     ((0x00000040&(data))>>6)
#define MIS_IR_CR_get_irdpm(data)                                     ((0x00000020&(data))>>5)
#define MIS_IR_CR_get_irdn(data)                                      (0x0000001F&(data))

#define MIS_IR_RP                                                     0x1801B414
#define MIS_IR_RP_reg_addr                                            "0xB801B414"
#define MIS_IR_RP_reg                                                 0xB801B414
#define MIS_IR_RP_inst_addr                                           "0x0105"
#define MIS_IR_RP_inst                                                0x0105
#define MIS_IR_RP_irrp_shift                                          (0)
#define MIS_IR_RP_irrp_mask                                           (0xFFFFFFFF)
#define MIS_IR_RP_irrp(data)                                          (0xFFFFFFFF&(data))
#define MIS_IR_RP_get_irrp(data)                                      (0xFFFFFFFF&(data))

#define MIS_IR_SR                                                     0x1801B418
#define MIS_IR_SR_reg_addr                                            "0xB801B418"
#define MIS_IR_SR_reg                                                 0xB801B418
#define MIS_IR_SR_inst_addr                                           "0x0106"
#define MIS_IR_SR_inst                                                0x0106
#define MIS_IR_SR_irrf_shift                                          (1)
#define MIS_IR_SR_irdvf_shift                                         (0)
#define MIS_IR_SR_irrf_mask                                           (0x00000002)
#define MIS_IR_SR_irdvf_mask                                          (0x00000001)
#define MIS_IR_SR_irrf(data)                                          (0x00000002&((data)<<1))
#define MIS_IR_SR_irdvf(data)                                         (0x00000001&(data))
#define MIS_IR_SR_get_irrf(data)                                      ((0x00000002&(data))>>1)
#define MIS_IR_SR_get_irdvf(data)                                     (0x00000001&(data))

#define MIS_TC0TVR                                                    0x1801B500
#define MIS_TC0TVR_reg_addr                                           "0xB801B500"
#define MIS_TC0TVR_reg                                                0xB801B500
#define MIS_TC0TVR_inst_addr                                          "0x0140"
#define MIS_TC0TVR_inst                                               0x0140
#define MIS_TC0TVR_tc0tvr_shift                                       (0)
#define MIS_TC0TVR_tc0tvr_mask                                        (0xFFFFFFFF)
#define MIS_TC0TVR_tc0tvr(data)                                       (0xFFFFFFFF&(data))
#define MIS_TC0TVR_get_tc0tvr(data)                                   (0xFFFFFFFF&(data))

#define MIS_TC1TVR                                                    0x1801B504
#define MIS_TC1TVR_reg_addr                                           "0xB801B504"
#define MIS_TC1TVR_reg                                                0xB801B504
#define MIS_TC1TVR_inst_addr                                          "0x0141"
#define MIS_TC1TVR_inst                                               0x0141
#define MIS_TC1TVR_tc1tvr_shift                                       (0)
#define MIS_TC1TVR_tc1tvr_mask                                        (0xFFFFFFFF)
#define MIS_TC1TVR_tc1tvr(data)                                       (0xFFFFFFFF&(data))
#define MIS_TC1TVR_get_tc1tvr(data)                                   (0xFFFFFFFF&(data))

#define MIS_TC2TVR                                                    0x1801B508
#define MIS_TC2TVR_reg_addr                                           "0xB801B508"
#define MIS_TC2TVR_reg                                                0xB801B508
#define MIS_TC2TVR_inst_addr                                          "0x0142"
#define MIS_TC2TVR_inst                                               0x0142
#define MIS_TC2TVR_tc2tvr_shift                                       (0)
#define MIS_TC2TVR_tc2tvr_mask                                        (0xFFFFFFFF)
#define MIS_TC2TVR_tc2tvr(data)                                       (0xFFFFFFFF&(data))
#define MIS_TC2TVR_get_tc2tvr(data)                                   (0xFFFFFFFF&(data))

#define MIS_TC0CVR                                                    0x1801B50C
#define MIS_TC0CVR_reg_addr                                           "0xB801B50C"
#define MIS_TC0CVR_reg                                                0xB801B50C
#define MIS_TC0CVR_inst_addr                                          "0x0143"
#define MIS_TC0CVR_inst                                               0x0143
#define MIS_TC0CVR_tc0cvr_shift                                       (0)
#define MIS_TC0CVR_tc0cvr_mask                                        (0xFFFFFFFF)
#define MIS_TC0CVR_tc0cvr(data)                                       (0xFFFFFFFF&(data))
#define MIS_TC0CVR_get_tc0cvr(data)                                   (0xFFFFFFFF&(data))

#define MIS_TC1CVR                                                    0x1801B510
#define MIS_TC1CVR_reg_addr                                           "0xB801B510"
#define MIS_TC1CVR_reg                                                0xB801B510
#define MIS_TC1CVR_inst_addr                                          "0x0144"
#define MIS_TC1CVR_inst                                               0x0144
#define MIS_TC1CVR_tc1cvr_shift                                       (0)
#define MIS_TC1CVR_tc1cvr_mask                                        (0xFFFFFFFF)
#define MIS_TC1CVR_tc1cvr(data)                                       (0xFFFFFFFF&(data))
#define MIS_TC1CVR_get_tc1cvr(data)                                   (0xFFFFFFFF&(data))

#define MIS_TC2CVR                                                    0x1801B514
#define MIS_TC2CVR_reg_addr                                           "0xB801B514"
#define MIS_TC2CVR_reg                                                0xB801B514
#define MIS_TC2CVR_inst_addr                                          "0x0145"
#define MIS_TC2CVR_inst                                               0x0145
#define MIS_TC2CVR_tc2vr_shift                                        (0)
#define MIS_TC2CVR_tc2vr_mask                                         (0xFFFFFFFF)
#define MIS_TC2CVR_tc2vr(data)                                        (0xFFFFFFFF&(data))
#define MIS_TC2CVR_get_tc2vr(data)                                    (0xFFFFFFFF&(data))

#define MIS_TC0CR                                                     0x1801B518
#define MIS_TC0CR_reg_addr                                            "0xB801B518"
#define MIS_TC0CR_reg                                                 0xB801B518
#define MIS_TC0CR_inst_addr                                           "0x0146"
#define MIS_TC0CR_inst                                                0x0146
#define MIS_TC0CR_tc0en_shift                                         (31)
#define MIS_TC0CR_tc0mode_shift                                       (30)
#define MIS_TC0CR_reserveda_shift                                     (24)
#define MIS_TC0CR_tc0en_mask                                          (0x80000000)
#define MIS_TC0CR_tc0mode_mask                                        (0x40000000)
#define MIS_TC0CR_reserveda_mask                                      (0x3F000000)
#define MIS_TC0CR_tc0en(data)                                         (0x80000000&((data)<<31))
#define MIS_TC0CR_tc0mode(data)                                       (0x40000000&((data)<<30))
#define MIS_TC0CR_reserveda(data)                                     (0x3F000000&((data)<<24))
#define MIS_TC0CR_get_tc0en(data)                                     ((0x80000000&(data))>>31)
#define MIS_TC0CR_get_tc0mode(data)                                   ((0x40000000&(data))>>30)
#define MIS_TC0CR_get_reserveda(data)                                 ((0x3F000000&(data))>>24)

#define MIS_TC1CR                                                     0x1801B51C
#define MIS_TC1CR_reg_addr                                            "0xB801B51C"
#define MIS_TC1CR_reg                                                 0xB801B51C
#define MIS_TC1CR_inst_addr                                           "0x0147"
#define MIS_TC1CR_inst                                                0x0147
#define MIS_TC1CR_tc1en_shift                                         (31)
#define MIS_TC1CR_tc1mode_shift                                       (30)
#define MIS_TC1CR_reserveda_shift                                     (24)
#define MIS_TC1CR_tc1en_mask                                          (0x80000000)
#define MIS_TC1CR_tc1mode_mask                                        (0x40000000)
#define MIS_TC1CR_reserveda_mask                                      (0x3F000000)
#define MIS_TC1CR_tc1en(data)                                         (0x80000000&((data)<<31))
#define MIS_TC1CR_tc1mode(data)                                       (0x40000000&((data)<<30))
#define MIS_TC1CR_reserveda(data)                                     (0x3F000000&((data)<<24))
#define MIS_TC1CR_get_tc1en(data)                                     ((0x80000000&(data))>>31)
#define MIS_TC1CR_get_tc1mode(data)                                   ((0x40000000&(data))>>30)
#define MIS_TC1CR_get_reserveda(data)                                 ((0x3F000000&(data))>>24)

#define MIS_TC2CR                                                     0x1801B520
#define MIS_TC2CR_reg_addr                                            "0xB801B520"
#define MIS_TC2CR_reg                                                 0xB801B520
#define MIS_TC2CR_inst_addr                                           "0x0148"
#define MIS_TC2CR_inst                                                0x0148
#define MIS_TC2CR_tc2en_shift                                         (31)
#define MIS_TC2CR_tc2mode_shift                                       (30)
#define MIS_TC2CR_reserveda_shift                                     (24)
#define MIS_TC2CR_tc2en_mask                                          (0x80000000)
#define MIS_TC2CR_tc2mode_mask                                        (0x40000000)
#define MIS_TC2CR_reserveda_mask                                      (0x3F000000)
#define MIS_TC2CR_tc2en(data)                                         (0x80000000&((data)<<31))
#define MIS_TC2CR_tc2mode(data)                                       (0x40000000&((data)<<30))
#define MIS_TC2CR_reserveda(data)                                     (0x3F000000&((data)<<24))
#define MIS_TC2CR_get_tc2en(data)                                     ((0x80000000&(data))>>31)
#define MIS_TC2CR_get_tc2mode(data)                                   ((0x40000000&(data))>>30)
#define MIS_TC2CR_get_reserveda(data)                                 ((0x3F000000&(data))>>24)

#define MIS_TC0ICR                                                    0x1801B524
#define MIS_TC0ICR_reg_addr                                           "0xB801B524"
#define MIS_TC0ICR_reg                                                0xB801B524
#define MIS_TC0ICR_inst_addr                                          "0x0149"
#define MIS_TC0ICR_inst                                               0x0149
#define MIS_TC0ICR_tc0ie_shift                                        (31)
#define MIS_TC0ICR_tc0ie_mask                                         (0x80000000)
#define MIS_TC0ICR_tc0ie(data)                                        (0x80000000&((data)<<31))
#define MIS_TC0ICR_get_tc0ie(data)                                    ((0x80000000&(data))>>31)

#define MIS_TC1ICR                                                    0x1801B528
#define MIS_TC1ICR_reg_addr                                           "0xB801B528"
#define MIS_TC1ICR_reg                                                0xB801B528
#define MIS_TC1ICR_inst_addr                                          "0x014A"
#define MIS_TC1ICR_inst                                               0x014A
#define MIS_TC1ICR_tc1ie_shift                                        (31)
#define MIS_TC1ICR_tc1ie_mask                                         (0x80000000)
#define MIS_TC1ICR_tc1ie(data)                                        (0x80000000&((data)<<31))
#define MIS_TC1ICR_get_tc1ie(data)                                    ((0x80000000&(data))>>31)

#define MIS_TC2ICR                                                    0x1801B52C
#define MIS_TC2ICR_reg_addr                                           "0xB801B52C"
#define MIS_TC2ICR_reg                                                0xB801B52C
#define MIS_TC2ICR_inst_addr                                          "0x014B"
#define MIS_TC2ICR_inst                                               0x014B
#define MIS_TC2ICR_tc2ie_shift                                        (31)
#define MIS_TC2ICR_tc2ie_mask                                         (0x80000000)
#define MIS_TC2ICR_tc2ie(data)                                        (0x80000000&((data)<<31))
#define MIS_TC2ICR_get_tc2ie(data)                                    ((0x80000000&(data))>>31)

#define MIS_TCWCR                                                     0x1801B530
#define MIS_TCWCR_reg_addr                                            "0xB801B530"
#define MIS_TCWCR_reg                                                 0xB801B530
#define MIS_TCWCR_inst_addr                                           "0x014C"
#define MIS_TCWCR_inst                                                0x014C
#define MIS_TCWCR_ovsel_shift                                         (29)
#define MIS_TCWCR_wdc_shift                                           (25)
#define MIS_TCWCR_wden_shift                                          (0)
#define MIS_TCWCR_ovsel_mask                                          (0xE0000000)
#define MIS_TCWCR_wdc_mask                                            (0x1E000000)
#define MIS_TCWCR_wden_mask                                           (0x000000FF)
#define MIS_TCWCR_ovsel(data)                                         (0xE0000000&((data)<<29))
#define MIS_TCWCR_wdc(data)                                           (0x1E000000&((data)<<25))
#define MIS_TCWCR_wden(data)                                          (0x000000FF&(data))
#define MIS_TCWCR_get_ovsel(data)                                     ((0xE0000000&(data))>>29)
#define MIS_TCWCR_get_wdc(data)                                       ((0x1E000000&(data))>>25)
#define MIS_TCWCR_get_wden(data)                                      (0x000000FF&(data))

#define MIS_TCWTR                                                     0x1801B534
#define MIS_TCWTR_reg_addr                                            "0xB801B534"
#define MIS_TCWTR_reg                                                 0xB801B534
#define MIS_TCWTR_inst_addr                                           "0x014D"
#define MIS_TCWTR_inst                                                0x014D
#define MIS_TCWTR_wdclr_shift                                         (0)
#define MIS_TCWTR_wdclr_mask                                          (0x00000001)
#define MIS_TCWTR_wdclr(data)                                         (0x00000001&(data))
#define MIS_TCWTR_get_wdclr(data)                                     (0x00000001&(data))

#define MIS_CLK27M_CLK90K                                             0x1801B538
#define MIS_CLK27M_CLK90K_reg_addr                                    "0xB801B538"
#define MIS_CLK27M_CLK90K_reg                                         0xB801B538
#define MIS_CLK27M_CLK90K_inst_addr                                   "0x014E"
#define MIS_CLK27M_CLK90K_inst                                        0x014E
#define MIS_CLK27M_CLK90K_en_shift                                    (9)
#define MIS_CLK27M_CLK90K_cnt_shift                                   (0)
#define MIS_CLK27M_CLK90K_en_mask                                     (0x00000200)
#define MIS_CLK27M_CLK90K_cnt_mask                                    (0x000001FF)
#define MIS_CLK27M_CLK90K_en(data)                                    (0x00000200&((data)<<9))
#define MIS_CLK27M_CLK90K_cnt(data)                                   (0x000001FF&(data))
#define MIS_CLK27M_CLK90K_get_en(data)                                ((0x00000200&(data))>>9)
#define MIS_CLK27M_CLK90K_get_cnt(data)                               (0x000001FF&(data))

#define MIS_CLK90K_TM_LO                                              0x1801B53C
#define MIS_CLK90K_TM_LO_reg_addr                                     "0xB801B53C"
#define MIS_CLK90K_TM_LO_reg                                          0xB801B53C
#define MIS_CLK90K_TM_LO_inst_addr                                    "0x014F"
#define MIS_CLK90K_TM_LO_inst                                         0x014F
#define MIS_CLK90K_TM_LO_cur_val_shift                                (0)
#define MIS_CLK90K_TM_LO_cur_val_mask                                 (0xFFFFFFFF)
#define MIS_CLK90K_TM_LO_cur_val(data)                                (0xFFFFFFFF&(data))
#define MIS_CLK90K_TM_LO_get_cur_val(data)                            (0xFFFFFFFF&(data))

#define MIS_CLK90K_TM_HI                                              0x1801B540
#define MIS_CLK90K_TM_HI_reg_addr                                     "0xB801B540"
#define MIS_CLK90K_TM_HI_reg                                          0xB801B540
#define MIS_CLK90K_TM_HI_inst_addr                                    "0x0150"
#define MIS_CLK90K_TM_HI_inst                                         0x0150
#define MIS_CLK90K_TM_HI_cur_val_shift                                (0)
#define MIS_CLK90K_TM_HI_cur_val_mask                                 (0x0000FFFF)
#define MIS_CLK90K_TM_HI_cur_val(data)                                (0x0000FFFF&(data))
#define MIS_CLK90K_TM_HI_get_cur_val(data)                            (0x0000FFFF&(data))

#define MIS_RTCSEC                                                    0x1801B600
#define MIS_RTCSEC_reg_addr                                           "0xB801B600"
#define MIS_RTCSEC_reg                                                0xB801B600
#define MIS_RTCSEC_inst_addr                                          "0x0180"
#define MIS_RTCSEC_inst                                               0x0180
#define MIS_RTCSEC_rtcsec_shift                                       (0)
#define MIS_RTCSEC_rtcsec_mask                                        (0x0000007F)
#define MIS_RTCSEC_rtcsec(data)                                       (0x0000007F&(data))
#define MIS_RTCSEC_get_rtcsec(data)                                   (0x0000007F&(data))

#define MIS_RTCMIN                                                    0x1801B604
#define MIS_RTCMIN_reg_addr                                           "0xB801B604"
#define MIS_RTCMIN_reg                                                0xB801B604
#define MIS_RTCMIN_inst_addr                                          "0x0181"
#define MIS_RTCMIN_inst                                               0x0181
#define MIS_RTCMIN_rtcmin_shift                                       (0)
#define MIS_RTCMIN_rtcmin_mask                                        (0x0000003F)
#define MIS_RTCMIN_rtcmin(data)                                       (0x0000003F&(data))
#define MIS_RTCMIN_get_rtcmin(data)                                   (0x0000003F&(data))

#define MIS_RTCHR                                                     0x1801B608
#define MIS_RTCHR_reg_addr                                            "0xB801B608"
#define MIS_RTCHR_reg                                                 0xB801B608
#define MIS_RTCHR_inst_addr                                           "0x0182"
#define MIS_RTCHR_inst                                                0x0182
#define MIS_RTCHR_rtchr_shift                                         (0)
#define MIS_RTCHR_rtchr_mask                                          (0x0000001F)
#define MIS_RTCHR_rtchr(data)                                         (0x0000001F&(data))
#define MIS_RTCHR_get_rtchr(data)                                     (0x0000001F&(data))

#define MIS_RTCDATE1                                                  0x1801B60C
#define MIS_RTCDATE1_reg_addr                                         "0xB801B60C"
#define MIS_RTCDATE1_reg                                              0xB801B60C
#define MIS_RTCDATE1_inst_addr                                        "0x0183"
#define MIS_RTCDATE1_inst                                             0x0183
#define MIS_RTCDATE1_rtcdate1_shift                                   (0)
#define MIS_RTCDATE1_rtcdate1_mask                                    (0x000000FF)
#define MIS_RTCDATE1_rtcdate1(data)                                   (0x000000FF&(data))
#define MIS_RTCDATE1_get_rtcdate1(data)                               (0x000000FF&(data))

#define MIS_RTCDATE2                                                  0x1801B610
#define MIS_RTCDATE2_reg_addr                                         "0xB801B610"
#define MIS_RTCDATE2_reg                                              0xB801B610
#define MIS_RTCDATE2_inst_addr                                        "0x0184"
#define MIS_RTCDATE2_inst                                             0x0184
#define MIS_RTCDATE2_rtcdate2_shift                                   (0)
#define MIS_RTCDATE2_rtcdate2_mask                                    (0x0000003F)
#define MIS_RTCDATE2_rtcdate2(data)                                   (0x0000003F&(data))
#define MIS_RTCDATE2_get_rtcdate2(data)                               (0x0000003F&(data))

#define MIS_ALMMIN                                                    0x1801B614
#define MIS_ALMMIN_reg_addr                                           "0xB801B614"
#define MIS_ALMMIN_reg                                                0xB801B614
#define MIS_ALMMIN_inst_addr                                          "0x0185"
#define MIS_ALMMIN_inst                                               0x0185
#define MIS_ALMMIN_almmin_shift                                       (0)
#define MIS_ALMMIN_almmin_mask                                        (0x0000003F)
#define MIS_ALMMIN_almmin(data)                                       (0x0000003F&(data))
#define MIS_ALMMIN_get_almmin(data)                                   (0x0000003F&(data))

#define MIS_ALMHR                                                     0x1801B618
#define MIS_ALMHR_reg_addr                                            "0xB801B618"
#define MIS_ALMHR_reg                                                 0xB801B618
#define MIS_ALMHR_inst_addr                                           "0x0186"
#define MIS_ALMHR_inst                                                0x0186
#define MIS_ALMHR_almhr_shift                                         (0)
#define MIS_ALMHR_almhr_mask                                          (0x0000001F)
#define MIS_ALMHR_almhr(data)                                         (0x0000001F&(data))
#define MIS_ALMHR_get_almhr(data)                                     (0x0000001F&(data))

#define MIS_ALMDATE1                                                  0x1801B61C
#define MIS_ALMDATE1_reg_addr                                         "0xB801B61C"
#define MIS_ALMDATE1_reg                                              0xB801B61C
#define MIS_ALMDATE1_inst_addr                                        "0x0187"
#define MIS_ALMDATE1_inst                                             0x0187
#define MIS_ALMDATE1_almdate1_shift                                   (0)
#define MIS_ALMDATE1_almdate1_mask                                    (0x000000FF)
#define MIS_ALMDATE1_almdate1(data)                                   (0x000000FF&(data))
#define MIS_ALMDATE1_get_almdate1(data)                               (0x000000FF&(data))

#define MIS_ALMDATE2                                                  0x1801B620
#define MIS_ALMDATE2_reg_addr                                         "0xB801B620"
#define MIS_ALMDATE2_reg                                              0xB801B620
#define MIS_ALMDATE2_inst_addr                                        "0x0188"
#define MIS_ALMDATE2_inst                                             0x0188
#define MIS_ALMDATE2_almdate2_shift                                   (0)
#define MIS_ALMDATE2_almdate2_mask                                    (0x0000003F)
#define MIS_ALMDATE2_almdate2(data)                                   (0x0000003F&(data))
#define MIS_ALMDATE2_get_almdate2(data)                               (0x0000003F&(data))

#define MIS_RTCSTOP                                                   0x1801B624
#define MIS_RTCSTOP_reg_addr                                          "0xB801B624"
#define MIS_RTCSTOP_reg                                               0xB801B624
#define MIS_RTCSTOP_inst_addr                                         "0x0189"
#define MIS_RTCSTOP_inst                                              0x0189
#define MIS_RTCSTOP_rtcstop_shift                                     (0)
#define MIS_RTCSTOP_rtcstop_mask                                      (0x00000001)
#define MIS_RTCSTOP_rtcstop(data)                                     (0x00000001&(data))
#define MIS_RTCSTOP_get_rtcstop(data)                                 (0x00000001&(data))

#define MIS_RTCOSC                                                    0x1801B628
#define MIS_RTCOSC_reg_addr                                           "0xB801B628"
#define MIS_RTCOSC_reg                                                0xB801B628
#define MIS_RTCOSC_inst_addr                                          "0x018A"
#define MIS_RTCOSC_inst                                               0x018A
#define MIS_RTCOSC_bc_shift                                           (0)
#define MIS_RTCOSC_bc_mask                                            (0x00000003)
#define MIS_RTCOSC_bc(data)                                           (0x00000003&(data))
#define MIS_RTCOSC_get_bc(data)                                       (0x00000003&(data))

#define MIS_RTCCR                                                     0x1801B62C
#define MIS_RTCCR_reg_addr                                            "0xB801B62C"
#define MIS_RTCCR_reg                                                 0xB801B62C
#define MIS_RTCCR_inst_addr                                           "0x018B"
#define MIS_RTCCR_inst                                                0x018B
#define MIS_RTCCR_rtcrst_shift                                        (6)
#define MIS_RTCCR_nrtcen_shift                                        (5)
#define MIS_RTCCR_almen_shift                                         (4)
#define MIS_RTCCR_dainte_shift                                        (3)
#define MIS_RTCCR_huinte_shift                                        (2)
#define MIS_RTCCR_muinte_shift                                        (1)
#define MIS_RTCCR_hsuinte_shift                                       (0)
#define MIS_RTCCR_rtcrst_mask                                         (0x00000040)
#define MIS_RTCCR_nrtcen_mask                                         (0x00000020)
#define MIS_RTCCR_almen_mask                                          (0x00000010)
#define MIS_RTCCR_dainte_mask                                         (0x00000008)
#define MIS_RTCCR_huinte_mask                                         (0x00000004)
#define MIS_RTCCR_muinte_mask                                         (0x00000002)
#define MIS_RTCCR_hsuinte_mask                                        (0x00000001)
#define MIS_RTCCR_rtcrst(data)                                        (0x00000040&((data)<<6))
#define MIS_RTCCR_nrtcen(data)                                        (0x00000020&((data)<<5))
#define MIS_RTCCR_almen(data)                                         (0x00000010&((data)<<4))
#define MIS_RTCCR_dainte(data)                                        (0x00000008&((data)<<3))
#define MIS_RTCCR_huinte(data)                                        (0x00000004&((data)<<2))
#define MIS_RTCCR_muinte(data)                                        (0x00000002&((data)<<1))
#define MIS_RTCCR_hsuinte(data)                                       (0x00000001&(data))
#define MIS_RTCCR_get_rtcrst(data)                                    ((0x00000040&(data))>>6)
#define MIS_RTCCR_get_nrtcen(data)                                    ((0x00000020&(data))>>5)
#define MIS_RTCCR_get_almen(data)                                     ((0x00000010&(data))>>4)
#define MIS_RTCCR_get_dainte(data)                                    ((0x00000008&(data))>>3)
#define MIS_RTCCR_get_huinte(data)                                    ((0x00000004&(data))>>2)
#define MIS_RTCCR_get_muinte(data)                                    ((0x00000002&(data))>>1)
#define MIS_RTCCR_get_hsuinte(data)                                   (0x00000001&(data))

#define MIS_VFD_CTL                                                   0x1801B700
#define MIS_VFD_CTL_reg_addr                                          "0xB801B700"
#define MIS_VFD_CTL_reg                                               0xB801B700
#define MIS_VFD_CTL_inst_addr                                         "0x01C0"
#define MIS_VFD_CTL_inst                                              0x01C0
#define MIS_VFD_CTL_swen_shift                                        (2)
#define MIS_VFD_CTL_clksel_shift                                      (1)
#define MIS_VFD_CTL_envfd_shift                                       (0)
#define MIS_VFD_CTL_swen_mask                                         (0x00000004)
#define MIS_VFD_CTL_clksel_mask                                       (0x00000002)
#define MIS_VFD_CTL_envfd_mask                                        (0x00000001)
#define MIS_VFD_CTL_swen(data)                                        (0x00000004&((data)<<2))
#define MIS_VFD_CTL_clksel(data)                                      (0x00000002&((data)<<1))
#define MIS_VFD_CTL_envfd(data)                                       (0x00000001&(data))
#define MIS_VFD_CTL_get_swen(data)                                    ((0x00000004&(data))>>2)
#define MIS_VFD_CTL_get_clksel(data)                                  ((0x00000002&(data))>>1)
#define MIS_VFD_CTL_get_envfd(data)                                   (0x00000001&(data))

#define MIS_VFD_WRCTL                                                 0x1801B704
#define MIS_VFD_WRCTL_reg_addr                                        "0xB801B704"
#define MIS_VFD_WRCTL_reg                                             0xB801B704
#define MIS_VFD_WRCTL_inst_addr                                       "0x01C1"
#define MIS_VFD_WRCTL_inst                                            0x01C1
#define MIS_VFD_WRCTL_nact_csn_shift                                  (12)
#define MIS_VFD_WRCTL_b3c_shift                                       (11)
#define MIS_VFD_WRCTL_b2c_shift                                       (10)
#define MIS_VFD_WRCTL_b1c_shift                                       (9)
#define MIS_VFD_WRCTL_b0c_shift                                       (8)
#define MIS_VFD_WRCTL_enb3_shift                                      (7)
#define MIS_VFD_WRCTL_enb2_shift                                      (6)
#define MIS_VFD_WRCTL_enb1_shift                                      (5)
#define MIS_VFD_WRCTL_enb0_shift                                      (4)
#define MIS_VFD_WRCTL_wd_shift                                        (1)
#define MIS_VFD_WRCTL_wdie_shift                                      (0)
#define MIS_VFD_WRCTL_nact_csn_mask                                   (0x00001000)
#define MIS_VFD_WRCTL_b3c_mask                                        (0x00000800)
#define MIS_VFD_WRCTL_b2c_mask                                        (0x00000400)
#define MIS_VFD_WRCTL_b1c_mask                                        (0x00000200)
#define MIS_VFD_WRCTL_b0c_mask                                        (0x00000100)
#define MIS_VFD_WRCTL_enb3_mask                                       (0x00000080)
#define MIS_VFD_WRCTL_enb2_mask                                       (0x00000040)
#define MIS_VFD_WRCTL_enb1_mask                                       (0x00000020)
#define MIS_VFD_WRCTL_enb0_mask                                       (0x00000010)
#define MIS_VFD_WRCTL_wd_mask                                         (0x00000002)
#define MIS_VFD_WRCTL_wdie_mask                                       (0x00000001)
#define MIS_VFD_WRCTL_nact_csn(data)                                  (0x00001000&((data)<<12))
#define MIS_VFD_WRCTL_b3c(data)                                       (0x00000800&((data)<<11))
#define MIS_VFD_WRCTL_b2c(data)                                       (0x00000400&((data)<<10))
#define MIS_VFD_WRCTL_b1c(data)                                       (0x00000200&((data)<<9))
#define MIS_VFD_WRCTL_b0c(data)                                       (0x00000100&((data)<<8))
#define MIS_VFD_WRCTL_enb3(data)                                      (0x00000080&((data)<<7))
#define MIS_VFD_WRCTL_enb2(data)                                      (0x00000040&((data)<<6))
#define MIS_VFD_WRCTL_enb1(data)                                      (0x00000020&((data)<<5))
#define MIS_VFD_WRCTL_enb0(data)                                      (0x00000010&((data)<<4))
#define MIS_VFD_WRCTL_wd(data)                                        (0x00000002&((data)<<1))
#define MIS_VFD_WRCTL_wdie(data)                                      (0x00000001&(data))
#define MIS_VFD_WRCTL_get_nact_csn(data)                              ((0x00001000&(data))>>12)
#define MIS_VFD_WRCTL_get_b3c(data)                                   ((0x00000800&(data))>>11)
#define MIS_VFD_WRCTL_get_b2c(data)                                   ((0x00000400&(data))>>10)
#define MIS_VFD_WRCTL_get_b1c(data)                                   ((0x00000200&(data))>>9)
#define MIS_VFD_WRCTL_get_b0c(data)                                   ((0x00000100&(data))>>8)
#define MIS_VFD_WRCTL_get_enb3(data)                                  ((0x00000080&(data))>>7)
#define MIS_VFD_WRCTL_get_enb2(data)                                  ((0x00000040&(data))>>6)
#define MIS_VFD_WRCTL_get_enb1(data)                                  ((0x00000020&(data))>>5)
#define MIS_VFD_WRCTL_get_enb0(data)                                  ((0x00000010&(data))>>4)
#define MIS_VFD_WRCTL_get_wd(data)                                    ((0x00000002&(data))>>1)
#define MIS_VFD_WRCTL_get_wdie(data)                                  (0x00000001&(data))

#define MIS_VFDO                                                      0x1801B708
#define MIS_VFDO_reg_addr                                             "0xB801B708"
#define MIS_VFDO_reg                                                  0xB801B708
#define MIS_VFDO_inst_addr                                            "0x01C2"
#define MIS_VFDO_inst                                                 0x01C2
#define MIS_VFDO_byte3_shift                                          (24)
#define MIS_VFDO_byte2_shift                                          (16)
#define MIS_VFDO_byte1_shift                                          (8)
#define MIS_VFDO_byte0_shift                                          (0)
#define MIS_VFDO_byte3_mask                                           (0xFF000000)
#define MIS_VFDO_byte2_mask                                           (0x00FF0000)
#define MIS_VFDO_byte1_mask                                           (0x0000FF00)
#define MIS_VFDO_byte0_mask                                           (0x000000FF)
#define MIS_VFDO_byte3(data)                                          (0xFF000000&((data)<<24))
#define MIS_VFDO_byte2(data)                                          (0x00FF0000&((data)<<16))
#define MIS_VFDO_byte1(data)                                          (0x0000FF00&((data)<<8))
#define MIS_VFDO_byte0(data)                                          (0x000000FF&(data))
#define MIS_VFDO_get_byte3(data)                                      ((0xFF000000&(data))>>24)
#define MIS_VFDO_get_byte2(data)                                      ((0x00FF0000&(data))>>16)
#define MIS_VFDO_get_byte1(data)                                      ((0x0000FF00&(data))>>8)
#define MIS_VFDO_get_byte0(data)                                      (0x000000FF&(data))

#define MIS_VFD_ARDCTL                                                0x1801B70C
#define MIS_VFD_ARDCTL_reg_addr                                       "0xB801B70C"
#define MIS_VFD_ARDCTL_reg                                            0xB801B70C
#define MIS_VFD_ARDCTL_inst_addr                                      "0x01C3"
#define MIS_VFD_ARDCTL_inst                                           0x01C3
#define MIS_VFD_ARDCTL_kpadbn_shift                                   (8)
#define MIS_VFD_ARDCTL_swha_shift                                     (5)
#define MIS_VFD_ARDCTL_kpadha_shift                                   (4)
#define MIS_VFD_ARDCTL_ardp_shift                                     (0)
#define MIS_VFD_ARDCTL_kpadbn_mask                                    (0x00000700)
#define MIS_VFD_ARDCTL_swha_mask                                      (0x00000020)
#define MIS_VFD_ARDCTL_kpadha_mask                                    (0x00000010)
#define MIS_VFD_ARDCTL_ardp_mask                                      (0x00000003)
#define MIS_VFD_ARDCTL_kpadbn(data)                                   (0x00000700&((data)<<8))
#define MIS_VFD_ARDCTL_swha(data)                                     (0x00000020&((data)<<5))
#define MIS_VFD_ARDCTL_kpadha(data)                                   (0x00000010&((data)<<4))
#define MIS_VFD_ARDCTL_ardp(data)                                     (0x00000003&(data))
#define MIS_VFD_ARDCTL_get_kpadbn(data)                               ((0x00000700&(data))>>8)
#define MIS_VFD_ARDCTL_get_swha(data)                                 ((0x00000020&(data))>>5)
#define MIS_VFD_ARDCTL_get_kpadha(data)                               ((0x00000010&(data))>>4)
#define MIS_VFD_ARDCTL_get_ardp(data)                                 (0x00000003&(data))

#define MIS_VFD_KPADLIE                                               0x1801B710
#define MIS_VFD_KPADLIE_reg_addr                                      "0xB801B710"
#define MIS_VFD_KPADLIE_reg                                           0xB801B710
#define MIS_VFD_KPADLIE_inst_addr                                     "0x01C4"
#define MIS_VFD_KPADLIE_inst                                          0x01C4
#define MIS_VFD_KPADLIE_kpadie_shift                                  (0)
#define MIS_VFD_KPADLIE_kpadie_mask                                   (0xFFFFFFFF)
#define MIS_VFD_KPADLIE_kpadie(data)                                  (0xFFFFFFFF&(data))
#define MIS_VFD_KPADLIE_get_kpadie(data)                              (0xFFFFFFFF&(data))

#define MIS_VFD_KPADHIE                                               0x1801B714
#define MIS_VFD_KPADHIE_reg_addr                                      "0xB801B714"
#define MIS_VFD_KPADHIE_reg                                           0xB801B714
#define MIS_VFD_KPADHIE_inst_addr                                     "0x01C5"
#define MIS_VFD_KPADHIE_inst                                          0x01C5
#define MIS_VFD_KPADHIE_kpadie_shift                                  (0)
#define MIS_VFD_KPADHIE_kpadie_mask                                   (0x0000FFFF)
#define MIS_VFD_KPADHIE_kpadie(data)                                  (0x0000FFFF&(data))
#define MIS_VFD_KPADHIE_get_kpadie(data)                              (0x0000FFFF&(data))

#define MIS_VFD_SWIE                                                  0x1801B718
#define MIS_VFD_SWIE_reg_addr                                         "0xB801B718"
#define MIS_VFD_SWIE_reg                                              0xB801B718
#define MIS_VFD_SWIE_inst_addr                                        "0x01C6"
#define MIS_VFD_SWIE_inst                                             0x01C6
#define MIS_VFD_SWIE_swie_shift                                       (0)
#define MIS_VFD_SWIE_swie_mask                                        (0x0000000F)
#define MIS_VFD_SWIE_swie(data)                                       (0x0000000F&(data))
#define MIS_VFD_SWIE_get_swie(data)                                   (0x0000000F&(data))

#define MIS_VFD_ARDKPADL                                              0x1801B71C
#define MIS_VFD_ARDKPADL_reg_addr                                     "0xB801B71C"
#define MIS_VFD_ARDKPADL_reg                                          0xB801B71C
#define MIS_VFD_ARDKPADL_inst_addr                                    "0x01C7"
#define MIS_VFD_ARDKPADL_inst                                         0x01C7
#define MIS_VFD_ARDKPADL_st_shift                                     (0)
#define MIS_VFD_ARDKPADL_st_mask                                      (0xFFFFFFFF)
#define MIS_VFD_ARDKPADL_st(data)                                     (0xFFFFFFFF&(data))
#define MIS_VFD_ARDKPADL_get_st(data)                                 (0xFFFFFFFF&(data))

#define MIS_VFD_ARDKPADH                                              0x1801B720
#define MIS_VFD_ARDKPADH_reg_addr                                     "0xB801B720"
#define MIS_VFD_ARDKPADH_reg                                          0xB801B720
#define MIS_VFD_ARDKPADH_inst_addr                                    "0x01C8"
#define MIS_VFD_ARDKPADH_inst                                         0x01C8
#define MIS_VFD_ARDKPADH_st_shift                                     (0)
#define MIS_VFD_ARDKPADH_st_mask                                      (0x0000FFFF)
#define MIS_VFD_ARDKPADH_st(data)                                     (0x0000FFFF&(data))
#define MIS_VFD_ARDKPADH_get_st(data)                                 (0x0000FFFF&(data))

#define MIS_VFD_ARDSW                                                 0x1801B724
#define MIS_VFD_ARDSW_reg_addr                                        "0xB801B724"
#define MIS_VFD_ARDSW_reg                                             0xB801B724
#define MIS_VFD_ARDSW_inst_addr                                       "0x01C9"
#define MIS_VFD_ARDSW_inst                                            0x01C9
#define MIS_VFD_ARDSW_reserveda_shift                                 (4)
#define MIS_VFD_ARDSW_st_shift                                        (0)
#define MIS_VFD_ARDSW_reserveda_mask                                  (0x0000FFF0)
#define MIS_VFD_ARDSW_st_mask                                         (0x0000000F)
#define MIS_VFD_ARDSW_reserveda(data)                                 (0x0000FFF0&((data)<<4))
#define MIS_VFD_ARDSW_st(data)                                        (0x0000000F&(data))
#define MIS_VFD_ARDSW_get_reserveda(data)                             ((0x0000FFF0&(data))>>4)
#define MIS_VFD_ARDSW_get_st(data)                                    (0x0000000F&(data))
#endif
