// This file is generated using the spec version 0.07, firmware template version 1.39and DVR_Parser_0.46
#ifndef _SB2_REG_H_INCLUDED_
#define _SB2_REG_H_INCLUDED_

//#define  _SB2_USE_STRUCT
#ifdef _SB2_USE_STRUCT

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    semaphore:1;
}sb2_HD_SEM;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    to_en:1;
    unsigned int    acivairq_en:1;
    unsigned int    vcivairq_en:1;
    unsigned int    scivairq_en:1;
    unsigned int    write_data:1;
}sb2_INV_INTEN;

typedef struct
{
    unsigned int    reserved_0:28;
    unsigned int    aciva_int:1;
    unsigned int    vciva_int:1;
    unsigned int    sciva_int:1;
    unsigned int    write_data:1;
}sb2_INV_INTSTAT;

typedef struct
{
    unsigned int    inv_adr:32;
}sb2_INV_ADDR;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    to_thr:2;
}sb2_DEBUG_REG;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    wr_hold_cyc:4;
    unsigned int    fl_sz:3;
    unsigned int    wwr_cyc:5;
    unsigned int    wr_cyc:5;
    unsigned int    rd_cyc:5;
}sb2_FLASH_CTRL;

typedef struct
{
    unsigned int    reserved_0:20;
    unsigned int    write_enable3:1;
    unsigned int    ac_mode:3;
    unsigned int    write_enable2:1;
    unsigned int    vc_mode:3;
    unsigned int    write_enable1:1;
    unsigned int    sc_mode:3;
}sb2_WRAPPER_CTRL;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    write_enable3:1;
    unsigned int    tile_start_adr:16;
    unsigned int    write_enable2:1;
    unsigned int    pic_width:3;
    unsigned int    write_enable1:1;
    unsigned int    pic_index:6;
}sb2_TILE_ACCESS_SET;

typedef struct
{
    unsigned int    sync:32;
}sb2_SYNC;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    dbg_mode:5;
}sb2_dbg;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    mips_endian:1;
}sb2_Endian;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    int_vs:1;
    unsigned int    int_va:1;
    unsigned int    int_av:1;
    unsigned int    int_as:1;
    unsigned int    int_sv:1;
    unsigned int    int_sa:1;
    unsigned int    write_data:1;
}sb2_CPU_INT;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    int_vs_en:1;
    unsigned int    int_va_en:1;
    unsigned int    int_av_en:1;
    unsigned int    int_as_en:1;
    unsigned int    int_sv_en:1;
    unsigned int    int_sa_en:1;
    unsigned int    write_data:1;
}sb2_CPU_INT_EN;

typedef struct
{
    unsigned int    reserved_0:3;
    unsigned int    m3_run:1;
    unsigned int    m3_sel:4;
    unsigned int    reserved_1:3;
    unsigned int    m2_run:1;
    unsigned int    m2_sel:4;
    unsigned int    reserved_2:3;
    unsigned int    m1_run:1;
    unsigned int    m1_sel:4;
    unsigned int    reserved_3:3;
    unsigned int    m0_run:1;
    unsigned int    m0_sel:4;
}sb2_PM_CNTL;

typedef struct
{
    unsigned int    cnt_lo:32;
}sb2_PM_CNT_LO;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    cnt_hi:16;
}sb2_PM_CNT_HI;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    pend_id:4;
    unsigned int    mask_id:4;
}sb2_DREQ_MASK;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    reserved_1:5;
    unsigned int    pc_go:1;
    unsigned int    pc_sel:3;
}sb2_PC_CTRL;

typedef struct
{
    unsigned int    pc_acc:32;
}sb2_PC_ACC;

typedef struct
{
    unsigned int    pc_max_lat:16;
    unsigned int    pc_req_num:16;
}sb2_PC_RLT;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    ata_pio1_current:1;
    unsigned int    ata_pio2_current:1;
    unsigned int    ata_preset_current:1;
    unsigned int    ata_preset_pud_en:1;
    unsigned int    ata_preset_pud_sel:1;
    unsigned int    ata_piordy_pu_en:1;
    unsigned int    ata_pdmarq_pd_en:1;
    unsigned int    ata_pintrq_pud_en:1;
    unsigned int    ata_pintrq_pud_sel:1;
    unsigned int    ata_pdd_pud_en:1;
    unsigned int    ata_pdd_pud_sel:1;
    unsigned int    ata_pdmackn_pud_en:1;
    unsigned int    ata_pdmackn_pud_sel:1;
    unsigned int    ata_pdiown_pud_en:1;
    unsigned int    ata_pdiown_pud_sel:1;
    unsigned int    ata_pdiorn_pud_en:1;
    unsigned int    ata_pdiorn_pud_sel:1;
    unsigned int    ata_sio1_current:1;
    unsigned int    ata_sio2_current:1;
    unsigned int    ata_siordy_pu_en:1;
    unsigned int    ata_sdmarq_pd_en:1;
    unsigned int    ata_sintrq_pud_en:1;
    unsigned int    ata_sintrq_pud_sel:1;
    unsigned int    ata_sdd_pud_en:1;
    unsigned int    ata_sdd_pud_sel:1;
    unsigned int    ata_sdmackn_pud_en:1;
    unsigned int    ata_sdmackn_pud_sel:1;
    unsigned int    ata_sdiown_pud_en:1;
    unsigned int    ata_sdiown_pud_sel:1;
    unsigned int    ata_sdiorn_pud_en:1;
    unsigned int    ata_sdiorn_pud_sel:1;
}sb2_ATA_PAD_FUNC_SEL;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    rom_io24_current:1;
    unsigned int    rom_io48_current:1;
    unsigned int    rom_csn_pu_en:1;
    unsigned int    rom_wrn_pud_en:1;
    unsigned int    rom_wrn_pud_sel:1;
    unsigned int    rom_rdn_pud_en:1;
    unsigned int    rom_rdn_pud_sel:1;
    unsigned int    rom_da22_7_pud_en:1;
    unsigned int    rom_da22_7_pud_sel:1;
    unsigned int    rom_da4_pd_en:1;
    unsigned int    rom_da3_pud_en:1;
    unsigned int    rom_da3_pud_sel:1;
    unsigned int    rom_dd7_pud_en:1;
    unsigned int    rom_dd7_pud_sel:1;
    unsigned int    rom_dd6_0_pud_en:1;
    unsigned int    rom_dd6_0_pud_sel:1;
}sb2_ROM_PAD_FUNC_SEL;

typedef struct
{
    unsigned int    reserved_0:2;
    unsigned int    uart_rx0_current:1;
    unsigned int    uart_rx0_pud_en:1;
    unsigned int    uart_rx0_pud_sel:1;
    unsigned int    uart_tx0_current:1;
    unsigned int    uart_tx0_pud_en:1;
    unsigned int    uart_tx0_pud_sel:1;
    unsigned int    uart_rx1_current:1;
    unsigned int    uart_rx1_pud_en:1;
    unsigned int    uart_rx1_pud_sel:1;
    unsigned int    uart_tx1_current:1;
    unsigned int    uart_tx1_pud_en:1;
    unsigned int    uart_tx1_pud_sel:1;
    unsigned int    i2c_scl_current:1;
    unsigned int    i2c_scl_pud_en:1;
    unsigned int    i2c_scl_pud_sel:1;
    unsigned int    i2c_sda_current:1;
    unsigned int    i2c_sda_pud_en:1;
    unsigned int    i2c_sda_pud_sel:1;
    unsigned int    gpio6_current:1;
    unsigned int    gpio6_pud_en:1;
    unsigned int    gpio6_pud_sel:1;
    unsigned int    gpio7_current:1;
    unsigned int    gpio7_pud_en:1;
    unsigned int    gpio7_pud_sel:1;
    unsigned int    gpio8_current:1;
    unsigned int    gpio8_pud_en:1;
    unsigned int    gpio8_pud_sel:1;
    unsigned int    gpio9_current:1;
    unsigned int    gpio9_pud_en:1;
    unsigned int    gpio9_pud_sel:1;
}sb2_GPIO1_PAD_FUNC_SEL;

typedef struct
{
    unsigned int    reserved_0:2;
    unsigned int    gpio10_current:1;
    unsigned int    gpio10_pud_en:1;
    unsigned int    gpio10_pud_sel:1;
    unsigned int    gpio11_current:1;
    unsigned int    gpio11_pud_en:1;
    unsigned int    gpio11_pud_sel:1;
    unsigned int    gpio12_current:1;
    unsigned int    gpio12_pud_en:1;
    unsigned int    gpio12_pud_sel:1;
    unsigned int    vdclk_current:1;
    unsigned int    vdclk_pud_en:1;
    unsigned int    vdclk_pud_sel:1;
    unsigned int    vdpd7_current:1;
    unsigned int    vdpd7_pud_en:1;
    unsigned int    vdpd7_pud_sel:1;
    unsigned int    vdpd6_current:1;
    unsigned int    vdpd6_pud_en:1;
    unsigned int    vdpd6_pud_sel:1;
    unsigned int    vdpd5_current:1;
    unsigned int    vdpd5_pud_en:1;
    unsigned int    vdpd5_pud_sel:1;
    unsigned int    vdpd4_current:1;
    unsigned int    vdpd4_pud_en:1;
    unsigned int    vdpd4_pud_sel:1;
    unsigned int    vdpd3_current:1;
    unsigned int    vdpd3_pud_en:1;
    unsigned int    vdpd3_pud_sel:1;
    unsigned int    vdpd2_current:1;
    unsigned int    vdpd2_pud_en:1;
    unsigned int    vdpd2_pud_sel:1;
}sb2_GPIO2_PAD_FUNC_SEL;

typedef struct
{
    unsigned int    reserved_0:2;
    unsigned int    vdpd1_current:1;
    unsigned int    vdpd1_pud_en:1;
    unsigned int    vdpd1_pud_sel:1;
    unsigned int    vdpd0_current:1;
    unsigned int    vdpd0_pud_en:1;
    unsigned int    vdpd0_pud_sel:1;
    unsigned int    ao_sd1_current:1;
    unsigned int    ao_sd1_pud_en:1;
    unsigned int    ao_sd1_pud_sel:1;
    unsigned int    ao_sd2_current:1;
    unsigned int    ao_sd2_pud_en:1;
    unsigned int    ao_sd2_pud_sel:1;
    unsigned int    ao_sd3_current:1;
    unsigned int    ao_sd3_pud_en:1;
    unsigned int    ao_sd3_pud_sel:1;
    unsigned int    ej_rstn_current:1;
    unsigned int    ej_rstn_pud_en:1;
    unsigned int    ej_rstn_pud_sel:1;
    unsigned int    ej_tclk_current:1;
    unsigned int    ej_tclk_pud_en:1;
    unsigned int    ej_tclk_pud_sel:1;
    unsigned int    ej_tms_current:1;
    unsigned int    ej_tms_pud_en:1;
    unsigned int    ej_tms_pud_sel:1;
    unsigned int    ej_tdi_current:1;
    unsigned int    ej_tdi_pud_en:1;
    unsigned int    ej_tdi_pud_sel:1;
    unsigned int    ej_tdo_current:1;
    unsigned int    ej_tdo_pud_en:1;
    unsigned int    ej_tdo_pud_sel:1;
}sb2_GPIO3_PAD_FUNC_SEL;

typedef struct
{
    unsigned int    ddr_in_pwr_down_en:1;
    unsigned int    ddr_out_tri_state_en:1;
    unsigned int    reserved_0:15;
    unsigned int    gpio35_current:1;
    unsigned int    gpio35_pud_en:1;
    unsigned int    gpio35_pud_sel:1;
    unsigned int    gpio34_current:1;
    unsigned int    gpio34_pud_en:1;
    unsigned int    gpio34_pud_sel:1;
    unsigned int    ai_sd1_current:1;
    unsigned int    ai_sd1_pud_en:1;
    unsigned int    ai_sd1_pud_sel:1;
    unsigned int    spdif_in_current:1;
    unsigned int    spdif_in_pud_en:1;
    unsigned int    spdif_in_pud_sel:1;
    unsigned int    gpio33_current:1;
    unsigned int    gpio33_pud_en:1;
    unsigned int    gpio33_pud_sel:1;
}sb2_GPIO4_PAD_FUNC_SEL;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    chip_id:16;
}sb2_CHIP_ID;

typedef struct
{
    unsigned int    revise_id:16;
    unsigned int    pow_latch:8;
    unsigned int    bound_opt:8;
}sb2_CHIP_INFO;

typedef struct
{
    unsigned int    sf_sel:1;
    unsigned int    reserved_0:23;
    unsigned int    opc:8;
}sb2_SFC_OPCODE;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    dataen:1;
    unsigned int    adren:1;
    unsigned int    dmycnt:3;
}sb2_SFC_CTL;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    mode:1;
    unsigned int    fdiv:8;
}sb2_SFC_SCK;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    tdt:8;
    unsigned int    phcnt:8;
    unsigned int    plcnt:8;
}sb2_SFC_CE;
#endif

#define SB2_HD_SEM                                                    0x1801A000
#define SB2_HD_SEM_reg_addr                                           "0xB801A000"
#define SB2_HD_SEM_reg                                                0xB801A000
#define SB2_HD_SEM_inst_addr                                          "0x0000"
#define SB2_HD_SEM_inst                                               0x0000
#define SB2_HD_SEM_semaphore_shift                                    (0)
#define SB2_HD_SEM_semaphore_mask                                     (0x00000001)
#define SB2_HD_SEM_semaphore(data)                                    (0x00000001&(data))
#define SB2_HD_SEM_get_semaphore(data)                                (0x00000001&(data))

#define SB2_INV_INTEN                                                 0x1801A004
#define SB2_INV_INTEN_reg_addr                                        "0xB801A004"
#define SB2_INV_INTEN_reg                                             0xB801A004
#define SB2_INV_INTEN_inst_addr                                       "0x0001"
#define SB2_INV_INTEN_inst                                            0x0001
#define SB2_INV_INTEN_to_en_shift                                     (4)
#define SB2_INV_INTEN_acivairq_en_shift                               (3)
#define SB2_INV_INTEN_vcivairq_en_shift                               (2)
#define SB2_INV_INTEN_scivairq_en_shift                               (1)
#define SB2_INV_INTEN_write_data_shift                                (0)
#define SB2_INV_INTEN_to_en_mask                                      (0x00000010)
#define SB2_INV_INTEN_acivairq_en_mask                                (0x00000008)
#define SB2_INV_INTEN_vcivairq_en_mask                                (0x00000004)
#define SB2_INV_INTEN_scivairq_en_mask                                (0x00000002)
#define SB2_INV_INTEN_write_data_mask                                 (0x00000001)
#define SB2_INV_INTEN_to_en(data)                                     (0x00000010&((data)<<4))
#define SB2_INV_INTEN_acivairq_en(data)                               (0x00000008&((data)<<3))
#define SB2_INV_INTEN_vcivairq_en(data)                               (0x00000004&((data)<<2))
#define SB2_INV_INTEN_scivairq_en(data)                               (0x00000002&((data)<<1))
#define SB2_INV_INTEN_write_data(data)                                (0x00000001&(data))
#define SB2_INV_INTEN_get_to_en(data)                                 ((0x00000010&(data))>>4)
#define SB2_INV_INTEN_get_acivairq_en(data)                           ((0x00000008&(data))>>3)
#define SB2_INV_INTEN_get_vcivairq_en(data)                           ((0x00000004&(data))>>2)
#define SB2_INV_INTEN_get_scivairq_en(data)                           ((0x00000002&(data))>>1)
#define SB2_INV_INTEN_get_write_data(data)                            (0x00000001&(data))

#define SB2_INV_INTSTAT                                               0x1801A008
#define SB2_INV_INTSTAT_reg_addr                                      "0xB801A008"
#define SB2_INV_INTSTAT_reg                                           0xB801A008
#define SB2_INV_INTSTAT_inst_addr                                     "0x0002"
#define SB2_INV_INTSTAT_inst                                          0x0002
#define SB2_INV_INTSTAT_aciva_int_shift                               (3)
#define SB2_INV_INTSTAT_vciva_int_shift                               (2)
#define SB2_INV_INTSTAT_sciva_int_shift                               (1)
#define SB2_INV_INTSTAT_write_data_shift                              (0)
#define SB2_INV_INTSTAT_aciva_int_mask                                (0x00000008)
#define SB2_INV_INTSTAT_vciva_int_mask                                (0x00000004)
#define SB2_INV_INTSTAT_sciva_int_mask                                (0x00000002)
#define SB2_INV_INTSTAT_write_data_mask                               (0x00000001)
#define SB2_INV_INTSTAT_aciva_int(data)                               (0x00000008&((data)<<3))
#define SB2_INV_INTSTAT_vciva_int(data)                               (0x00000004&((data)<<2))
#define SB2_INV_INTSTAT_sciva_int(data)                               (0x00000002&((data)<<1))
#define SB2_INV_INTSTAT_write_data(data)                              (0x00000001&(data))
#define SB2_INV_INTSTAT_get_aciva_int(data)                           ((0x00000008&(data))>>3)
#define SB2_INV_INTSTAT_get_vciva_int(data)                           ((0x00000004&(data))>>2)
#define SB2_INV_INTSTAT_get_sciva_int(data)                           ((0x00000002&(data))>>1)
#define SB2_INV_INTSTAT_get_write_data(data)                          (0x00000001&(data))

#define SB2_INV_ADDR                                                  0x1801A00C
#define SB2_INV_ADDR_reg_addr                                         "0xB801A00C"
#define SB2_INV_ADDR_reg                                              0xB801A00C
#define SB2_INV_ADDR_inst_addr                                        "0x0003"
#define SB2_INV_ADDR_inst                                             0x0003
#define SB2_INV_ADDR_inv_adr_shift                                    (0)
#define SB2_INV_ADDR_inv_adr_mask                                     (0xFFFFFFFF)
#define SB2_INV_ADDR_inv_adr(data)                                    (0xFFFFFFFF&(data))
#define SB2_INV_ADDR_get_inv_adr(data)                                (0xFFFFFFFF&(data))

#define SB2_DEBUG_REG                                                 0x1801A010
#define SB2_DEBUG_REG_reg_addr                                        "0xB801A010"
#define SB2_DEBUG_REG_reg                                             0xB801A010
#define SB2_DEBUG_REG_inst_addr                                       "0x0004"
#define SB2_DEBUG_REG_inst                                            0x0004
#define SB2_DEBUG_REG_to_thr_shift                                    (0)
#define SB2_DEBUG_REG_to_thr_mask                                     (0x00000003)
#define SB2_DEBUG_REG_to_thr(data)                                    (0x00000003&(data))
#define SB2_DEBUG_REG_get_to_thr(data)                                (0x00000003&(data))

#define SB2_FLASH_CTRL                                                0x1801A014
#define SB2_FLASH_CTRL_reg_addr                                       "0xB801A014"
#define SB2_FLASH_CTRL_reg                                            0xB801A014
#define SB2_FLASH_CTRL_inst_addr                                      "0x0005"
#define SB2_FLASH_CTRL_inst                                           0x0005
#define SB2_FLASH_CTRL_wr_hold_cyc_shift                              (18)
#define SB2_FLASH_CTRL_fl_sz_shift                                    (15)
#define SB2_FLASH_CTRL_wwr_cyc_shift                                  (10)
#define SB2_FLASH_CTRL_wr_cyc_shift                                   (5)
#define SB2_FLASH_CTRL_rd_cyc_shift                                   (0)
#define SB2_FLASH_CTRL_wr_hold_cyc_mask                               (0x003C0000)
#define SB2_FLASH_CTRL_fl_sz_mask                                     (0x00038000)
#define SB2_FLASH_CTRL_wwr_cyc_mask                                   (0x00007C00)
#define SB2_FLASH_CTRL_wr_cyc_mask                                    (0x000003E0)
#define SB2_FLASH_CTRL_rd_cyc_mask                                    (0x0000001F)
#define SB2_FLASH_CTRL_wr_hold_cyc(data)                              (0x003C0000&((data)<<18))
#define SB2_FLASH_CTRL_fl_sz(data)                                    (0x00038000&((data)<<15))
#define SB2_FLASH_CTRL_wwr_cyc(data)                                  (0x00007C00&((data)<<10))
#define SB2_FLASH_CTRL_wr_cyc(data)                                   (0x000003E0&((data)<<5))
#define SB2_FLASH_CTRL_rd_cyc(data)                                   (0x0000001F&(data))
#define SB2_FLASH_CTRL_get_wr_hold_cyc(data)                          ((0x003C0000&(data))>>18)
#define SB2_FLASH_CTRL_get_fl_sz(data)                                ((0x00038000&(data))>>15)
#define SB2_FLASH_CTRL_get_wwr_cyc(data)                              ((0x00007C00&(data))>>10)
#define SB2_FLASH_CTRL_get_wr_cyc(data)                               ((0x000003E0&(data))>>5)
#define SB2_FLASH_CTRL_get_rd_cyc(data)                               (0x0000001F&(data))

#define SB2_WRAPPER_CTRL                                              0x1801A018
#define SB2_WRAPPER_CTRL_reg_addr                                     "0xB801A018"
#define SB2_WRAPPER_CTRL_reg                                          0xB801A018
#define SB2_WRAPPER_CTRL_inst_addr                                    "0x0006"
#define SB2_WRAPPER_CTRL_inst                                         0x0006
#define SB2_WRAPPER_CTRL_write_enable3_shift                          (11)
#define SB2_WRAPPER_CTRL_ac_mode_shift                                (8)
#define SB2_WRAPPER_CTRL_write_enable2_shift                          (7)
#define SB2_WRAPPER_CTRL_vc_mode_shift                                (4)
#define SB2_WRAPPER_CTRL_write_enable1_shift                          (3)
#define SB2_WRAPPER_CTRL_sc_mode_shift                                (0)
#define SB2_WRAPPER_CTRL_write_enable3_mask                           (0x00000800)
#define SB2_WRAPPER_CTRL_ac_mode_mask                                 (0x00000700)
#define SB2_WRAPPER_CTRL_write_enable2_mask                           (0x00000080)
#define SB2_WRAPPER_CTRL_vc_mode_mask                                 (0x00000070)
#define SB2_WRAPPER_CTRL_write_enable1_mask                           (0x00000008)
#define SB2_WRAPPER_CTRL_sc_mode_mask                                 (0x00000007)
#define SB2_WRAPPER_CTRL_write_enable3(data)                          (0x00000800&((data)<<11))
#define SB2_WRAPPER_CTRL_ac_mode(data)                                (0x00000700&((data)<<8))
#define SB2_WRAPPER_CTRL_write_enable2(data)                          (0x00000080&((data)<<7))
#define SB2_WRAPPER_CTRL_vc_mode(data)                                (0x00000070&((data)<<4))
#define SB2_WRAPPER_CTRL_write_enable1(data)                          (0x00000008&((data)<<3))
#define SB2_WRAPPER_CTRL_sc_mode(data)                                (0x00000007&(data))
#define SB2_WRAPPER_CTRL_get_write_enable3(data)                      ((0x00000800&(data))>>11)
#define SB2_WRAPPER_CTRL_get_ac_mode(data)                            ((0x00000700&(data))>>8)
#define SB2_WRAPPER_CTRL_get_write_enable2(data)                      ((0x00000080&(data))>>7)
#define SB2_WRAPPER_CTRL_get_vc_mode(data)                            ((0x00000070&(data))>>4)
#define SB2_WRAPPER_CTRL_get_write_enable1(data)                      ((0x00000008&(data))>>3)
#define SB2_WRAPPER_CTRL_get_sc_mode(data)                            (0x00000007&(data))

#define SB2_TILE_ACCESS_SET                                           0x1801A01C
#define SB2_TILE_ACCESS_SET_reg_addr                                  "0xB801A01C"
#define SB2_TILE_ACCESS_SET_reg                                       0xB801A01C
#define SB2_TILE_ACCESS_SET_inst_addr                                 "0x0007"
#define SB2_TILE_ACCESS_SET_inst                                      0x0007
#define SB2_TILE_ACCESS_SET_write_enable3_shift                       (27)
#define SB2_TILE_ACCESS_SET_tile_start_adr_shift                      (11)
#define SB2_TILE_ACCESS_SET_write_enable2_shift                       (10)
#define SB2_TILE_ACCESS_SET_pic_width_shift                           (7)
#define SB2_TILE_ACCESS_SET_write_enable1_shift                       (6)
#define SB2_TILE_ACCESS_SET_pic_index_shift                           (0)
#define SB2_TILE_ACCESS_SET_write_enable3_mask                        (0x08000000)
#define SB2_TILE_ACCESS_SET_tile_start_adr_mask                       (0x07FFF800)
#define SB2_TILE_ACCESS_SET_write_enable2_mask                        (0x00000400)
#define SB2_TILE_ACCESS_SET_pic_width_mask                            (0x00000380)
#define SB2_TILE_ACCESS_SET_write_enable1_mask                        (0x00000040)
#define SB2_TILE_ACCESS_SET_pic_index_mask                            (0x0000003F)
#define SB2_TILE_ACCESS_SET_write_enable3(data)                       (0x08000000&((data)<<27))
#define SB2_TILE_ACCESS_SET_tile_start_adr(data)                      (0x07FFF800&((data)<<11))
#define SB2_TILE_ACCESS_SET_write_enable2(data)                       (0x00000400&((data)<<10))
#define SB2_TILE_ACCESS_SET_pic_width(data)                           (0x00000380&((data)<<7))
#define SB2_TILE_ACCESS_SET_write_enable1(data)                       (0x00000040&((data)<<6))
#define SB2_TILE_ACCESS_SET_pic_index(data)                           (0x0000003F&(data))
#define SB2_TILE_ACCESS_SET_get_write_enable3(data)                   ((0x08000000&(data))>>27)
#define SB2_TILE_ACCESS_SET_get_tile_start_adr(data)                  ((0x07FFF800&(data))>>11)
#define SB2_TILE_ACCESS_SET_get_write_enable2(data)                   ((0x00000400&(data))>>10)
#define SB2_TILE_ACCESS_SET_get_pic_width(data)                       ((0x00000380&(data))>>7)
#define SB2_TILE_ACCESS_SET_get_write_enable1(data)                   ((0x00000040&(data))>>6)
#define SB2_TILE_ACCESS_SET_get_pic_index(data)                       (0x0000003F&(data))

#define SB2_SYNC                                                      0x1801A020
#define SB2_SYNC_reg_addr                                             "0xB801A020"
#define SB2_SYNC_reg                                                  0xB801A020
#define SB2_SYNC_inst_addr                                            "0x0008"
#define SB2_SYNC_inst                                                 0x0008
#define SB2_SYNC_sync_shift                                           (0)
#define SB2_SYNC_sync_mask                                            (0xFFFFFFFF)
#define SB2_SYNC_sync(data)                                           (0xFFFFFFFF&(data))
#define SB2_SYNC_get_sync(data)                                       (0xFFFFFFFF&(data))

#define SB2_dbg                                                       0x1801A024
#define SB2_dbg_reg_addr                                              "0xB801A024"
#define SB2_dbg_reg                                                   0xB801A024
#define SB2_dbg_inst_addr                                             "0x0009"
#define SB2_dbg_inst                                                  0x0009
#define SB2_dbg_dbg_mode_shift                                        (0)
#define SB2_dbg_dbg_mode_mask                                         (0x0000001F)
#define SB2_dbg_dbg_mode(data)                                        (0x0000001F&(data))
#define SB2_dbg_get_dbg_mode(data)                                    (0x0000001F&(data))

#define SB2_Endian                                                    0x1801A100
#define SB2_Endian_reg_addr                                           "0xB801A100"
#define SB2_Endian_reg                                                0xB801A100
#define SB2_Endian_inst_addr                                          "0x0040"
#define SB2_Endian_inst                                               0x0040
#define SB2_Endian_mips_endian_shift                                  (0)
#define SB2_Endian_mips_endian_mask                                   (0x00000001)
#define SB2_Endian_mips_endian(data)                                  (0x00000001&(data))
#define SB2_Endian_get_mips_endian(data)                              (0x00000001&(data))

#define SB2_CPU_INT                                                   0x1801A104
#define SB2_CPU_INT_reg_addr                                          "0xB801A104"
#define SB2_CPU_INT_reg                                               0xB801A104
#define SB2_CPU_INT_inst_addr                                         "0x0041"
#define SB2_CPU_INT_inst                                              0x0041
#define SB2_CPU_INT_int_vs_shift                                      (6)
#define SB2_CPU_INT_int_va_shift                                      (5)
#define SB2_CPU_INT_int_av_shift                                      (4)
#define SB2_CPU_INT_int_as_shift                                      (3)
#define SB2_CPU_INT_int_sv_shift                                      (2)
#define SB2_CPU_INT_int_sa_shift                                      (1)
#define SB2_CPU_INT_write_data_shift                                  (0)
#define SB2_CPU_INT_int_vs_mask                                       (0x00000040)
#define SB2_CPU_INT_int_va_mask                                       (0x00000020)
#define SB2_CPU_INT_int_av_mask                                       (0x00000010)
#define SB2_CPU_INT_int_as_mask                                       (0x00000008)
#define SB2_CPU_INT_int_sv_mask                                       (0x00000004)
#define SB2_CPU_INT_int_sa_mask                                       (0x00000002)
#define SB2_CPU_INT_write_data_mask                                   (0x00000001)
#define SB2_CPU_INT_int_vs(data)                                      (0x00000040&((data)<<6))
#define SB2_CPU_INT_int_va(data)                                      (0x00000020&((data)<<5))
#define SB2_CPU_INT_int_av(data)                                      (0x00000010&((data)<<4))
#define SB2_CPU_INT_int_as(data)                                      (0x00000008&((data)<<3))
#define SB2_CPU_INT_int_sv(data)                                      (0x00000004&((data)<<2))
#define SB2_CPU_INT_int_sa(data)                                      (0x00000002&((data)<<1))
#define SB2_CPU_INT_write_data(data)                                  (0x00000001&(data))
#define SB2_CPU_INT_get_int_vs(data)                                  ((0x00000040&(data))>>6)
#define SB2_CPU_INT_get_int_va(data)                                  ((0x00000020&(data))>>5)
#define SB2_CPU_INT_get_int_av(data)                                  ((0x00000010&(data))>>4)
#define SB2_CPU_INT_get_int_as(data)                                  ((0x00000008&(data))>>3)
#define SB2_CPU_INT_get_int_sv(data)                                  ((0x00000004&(data))>>2)
#define SB2_CPU_INT_get_int_sa(data)                                  ((0x00000002&(data))>>1)
#define SB2_CPU_INT_get_write_data(data)                              (0x00000001&(data))

#define SB2_CPU_INT_EN                                                0x1801A108
#define SB2_CPU_INT_EN_reg_addr                                       "0xB801A108"
#define SB2_CPU_INT_EN_reg                                            0xB801A108
#define SB2_CPU_INT_EN_inst_addr                                      "0x0042"
#define SB2_CPU_INT_EN_inst                                           0x0042
#define SB2_CPU_INT_EN_int_vs_en_shift                                (6)
#define SB2_CPU_INT_EN_int_va_en_shift                                (5)
#define SB2_CPU_INT_EN_int_av_en_shift                                (4)
#define SB2_CPU_INT_EN_int_as_en_shift                                (3)
#define SB2_CPU_INT_EN_int_sv_en_shift                                (2)
#define SB2_CPU_INT_EN_int_sa_en_shift                                (1)
#define SB2_CPU_INT_EN_write_data_shift                               (0)
#define SB2_CPU_INT_EN_int_vs_en_mask                                 (0x00000040)
#define SB2_CPU_INT_EN_int_va_en_mask                                 (0x00000020)
#define SB2_CPU_INT_EN_int_av_en_mask                                 (0x00000010)
#define SB2_CPU_INT_EN_int_as_en_mask                                 (0x00000008)
#define SB2_CPU_INT_EN_int_sv_en_mask                                 (0x00000004)
#define SB2_CPU_INT_EN_int_sa_en_mask                                 (0x00000002)
#define SB2_CPU_INT_EN_write_data_mask                                (0x00000001)
#define SB2_CPU_INT_EN_int_vs_en(data)                                (0x00000040&((data)<<6))
#define SB2_CPU_INT_EN_int_va_en(data)                                (0x00000020&((data)<<5))
#define SB2_CPU_INT_EN_int_av_en(data)                                (0x00000010&((data)<<4))
#define SB2_CPU_INT_EN_int_as_en(data)                                (0x00000008&((data)<<3))
#define SB2_CPU_INT_EN_int_sv_en(data)                                (0x00000004&((data)<<2))
#define SB2_CPU_INT_EN_int_sa_en(data)                                (0x00000002&((data)<<1))
#define SB2_CPU_INT_EN_write_data(data)                               (0x00000001&(data))
#define SB2_CPU_INT_EN_get_int_vs_en(data)                            ((0x00000040&(data))>>6)
#define SB2_CPU_INT_EN_get_int_va_en(data)                            ((0x00000020&(data))>>5)
#define SB2_CPU_INT_EN_get_int_av_en(data)                            ((0x00000010&(data))>>4)
#define SB2_CPU_INT_EN_get_int_as_en(data)                            ((0x00000008&(data))>>3)
#define SB2_CPU_INT_EN_get_int_sv_en(data)                            ((0x00000004&(data))>>2)
#define SB2_CPU_INT_EN_get_int_sa_en(data)                            ((0x00000002&(data))>>1)
#define SB2_CPU_INT_EN_get_write_data(data)                           (0x00000001&(data))

#define SB2_PM_CNTL                                                   0x1801A10C
#define SB2_PM_CNTL_reg_addr                                          "0xB801A10C"
#define SB2_PM_CNTL_reg                                               0xB801A10C
#define SB2_PM_CNTL_inst_addr                                         "0x0043"
#define SB2_PM_CNTL_inst                                              0x0043
#define SB2_PM_CNTL_m3_run_shift                                      (28)
#define SB2_PM_CNTL_m3_sel_shift                                      (24)
#define SB2_PM_CNTL_m2_run_shift                                      (20)
#define SB2_PM_CNTL_m2_sel_shift                                      (16)
#define SB2_PM_CNTL_m1_run_shift                                      (12)
#define SB2_PM_CNTL_m1_sel_shift                                      (8)
#define SB2_PM_CNTL_m0_run_shift                                      (4)
#define SB2_PM_CNTL_m0_sel_shift                                      (0)
#define SB2_PM_CNTL_m3_run_mask                                       (0x10000000)
#define SB2_PM_CNTL_m3_sel_mask                                       (0x0F000000)
#define SB2_PM_CNTL_m2_run_mask                                       (0x00100000)
#define SB2_PM_CNTL_m2_sel_mask                                       (0x000F0000)
#define SB2_PM_CNTL_m1_run_mask                                       (0x00001000)
#define SB2_PM_CNTL_m1_sel_mask                                       (0x00000F00)
#define SB2_PM_CNTL_m0_run_mask                                       (0x00000010)
#define SB2_PM_CNTL_m0_sel_mask                                       (0x0000000F)
#define SB2_PM_CNTL_m3_run(data)                                      (0x10000000&((data)<<28))
#define SB2_PM_CNTL_m3_sel(data)                                      (0x0F000000&((data)<<24))
#define SB2_PM_CNTL_m2_run(data)                                      (0x00100000&((data)<<20))
#define SB2_PM_CNTL_m2_sel(data)                                      (0x000F0000&((data)<<16))
#define SB2_PM_CNTL_m1_run(data)                                      (0x00001000&((data)<<12))
#define SB2_PM_CNTL_m1_sel(data)                                      (0x00000F00&((data)<<8))
#define SB2_PM_CNTL_m0_run(data)                                      (0x00000010&((data)<<4))
#define SB2_PM_CNTL_m0_sel(data)                                      (0x0000000F&(data))
#define SB2_PM_CNTL_get_m3_run(data)                                  ((0x10000000&(data))>>28)
#define SB2_PM_CNTL_get_m3_sel(data)                                  ((0x0F000000&(data))>>24)
#define SB2_PM_CNTL_get_m2_run(data)                                  ((0x00100000&(data))>>20)
#define SB2_PM_CNTL_get_m2_sel(data)                                  ((0x000F0000&(data))>>16)
#define SB2_PM_CNTL_get_m1_run(data)                                  ((0x00001000&(data))>>12)
#define SB2_PM_CNTL_get_m1_sel(data)                                  ((0x00000F00&(data))>>8)
#define SB2_PM_CNTL_get_m0_run(data)                                  ((0x00000010&(data))>>4)
#define SB2_PM_CNTL_get_m0_sel(data)                                  (0x0000000F&(data))

#define SB2_PM_CNT_LO_0                                               0x1801A110
#define SB2_PM_CNT_LO_1                                               0x1801A118
#define SB2_PM_CNT_LO_2                                               0x1801A120
#define SB2_PM_CNT_LO_3                                               0x1801A128
#define SB2_PM_CNT_LO_0_reg_addr                                      "0xB801A110"
#define SB2_PM_CNT_LO_1_reg_addr                                      "0xB801A118"
#define SB2_PM_CNT_LO_2_reg_addr                                      "0xB801A120"
#define SB2_PM_CNT_LO_3_reg_addr                                      "0xB801A128"
#define SB2_PM_CNT_LO_0_reg                                           0xB801A110
#define SB2_PM_CNT_LO_1_reg                                           0xB801A118
#define SB2_PM_CNT_LO_2_reg                                           0xB801A120
#define SB2_PM_CNT_LO_3_reg                                           0xB801A128
#define SB2_PM_CNT_LO_0_inst_addr                                     "0x0044"
#define SB2_PM_CNT_LO_0_inst                                          0x0044
#define SB2_PM_CNT_LO_1_inst_addr                                     "0x0046"
#define SB2_PM_CNT_LO_1_inst                                          0x0046
#define SB2_PM_CNT_LO_2_inst_addr                                     "0x0048"
#define SB2_PM_CNT_LO_2_inst                                          0x0048
#define SB2_PM_CNT_LO_3_inst_addr                                     "0x004A"
#define SB2_PM_CNT_LO_3_inst                                          0x004A
#define SB2_PM_CNT_LO_cnt_lo_shift                                    (0)
#define SB2_PM_CNT_LO_cnt_lo_mask                                     (0xFFFFFFFF)
#define SB2_PM_CNT_LO_cnt_lo(data)                                    (0xFFFFFFFF&(data))
#define SB2_PM_CNT_LO_get_cnt_lo(data)                                (0xFFFFFFFF&(data))

#define SB2_PM_CNT_HI_0                                               0x1801A114
#define SB2_PM_CNT_HI_1                                               0x1801A11C
#define SB2_PM_CNT_HI_2                                               0x1801A124
#define SB2_PM_CNT_HI_3                                               0x1801A12C
#define SB2_PM_CNT_HI_0_reg_addr                                      "0xB801A114"
#define SB2_PM_CNT_HI_1_reg_addr                                      "0xB801A11C"
#define SB2_PM_CNT_HI_2_reg_addr                                      "0xB801A124"
#define SB2_PM_CNT_HI_3_reg_addr                                      "0xB801A12C"
#define SB2_PM_CNT_HI_0_reg                                           0xB801A114
#define SB2_PM_CNT_HI_1_reg                                           0xB801A11C
#define SB2_PM_CNT_HI_2_reg                                           0xB801A124
#define SB2_PM_CNT_HI_3_reg                                           0xB801A12C
#define SB2_PM_CNT_HI_0_inst_addr                                     "0x0045"
#define SB2_PM_CNT_HI_0_inst                                          0x0045
#define SB2_PM_CNT_HI_1_inst_addr                                     "0x0047"
#define SB2_PM_CNT_HI_1_inst                                          0x0047
#define SB2_PM_CNT_HI_2_inst_addr                                     "0x0049"
#define SB2_PM_CNT_HI_2_inst                                          0x0049
#define SB2_PM_CNT_HI_3_inst_addr                                     "0x004B"
#define SB2_PM_CNT_HI_3_inst                                          0x004B
#define SB2_PM_CNT_HI_cnt_hi_shift                                    (0)
#define SB2_PM_CNT_HI_cnt_hi_mask                                     (0x0000FFFF)
#define SB2_PM_CNT_HI_cnt_hi(data)                                    (0x0000FFFF&(data))
#define SB2_PM_CNT_HI_get_cnt_hi(data)                                (0x0000FFFF&(data))

#define SB2_DREQ_MASK                                                 0x1801A130
#define SB2_DREQ_MASK_reg_addr                                        "0xB801A130"
#define SB2_DREQ_MASK_reg                                             0xB801A130
#define SB2_DREQ_MASK_inst_addr                                       "0x004C"
#define SB2_DREQ_MASK_inst                                            0x004C
#define SB2_DREQ_MASK_pend_id_shift                                   (4)
#define SB2_DREQ_MASK_mask_id_shift                                   (0)
#define SB2_DREQ_MASK_pend_id_mask                                    (0x000000F0)
#define SB2_DREQ_MASK_mask_id_mask                                    (0x0000000F)
#define SB2_DREQ_MASK_pend_id(data)                                   (0x000000F0&((data)<<4))
#define SB2_DREQ_MASK_mask_id(data)                                   (0x0000000F&(data))
#define SB2_DREQ_MASK_get_pend_id(data)                               ((0x000000F0&(data))>>4)
#define SB2_DREQ_MASK_get_mask_id(data)                               (0x0000000F&(data))

#define SB2_PC_CTRL                                                   0x1801A134
#define SB2_PC_CTRL_reg_addr                                          "0xB801A134"
#define SB2_PC_CTRL_reg                                               0xB801A134
#define SB2_PC_CTRL_inst_addr                                         "0x004D"
#define SB2_PC_CTRL_inst                                              0x004D
#define SB2_PC_CTRL_pc_go_shift                                       (3)
#define SB2_PC_CTRL_pc_sel_shift                                      (0)
#define SB2_PC_CTRL_pc_go_mask                                        (0x00000008)
#define SB2_PC_CTRL_pc_sel_mask                                       (0x00000007)
#define SB2_PC_CTRL_pc_go(data)                                       (0x00000008&((data)<<3))
#define SB2_PC_CTRL_pc_sel(data)                                      (0x00000007&(data))
#define SB2_PC_CTRL_get_pc_go(data)                                   ((0x00000008&(data))>>3)
#define SB2_PC_CTRL_get_pc_sel(data)                                  (0x00000007&(data))

#define SB2_PC_ACC                                                    0x1801A138
#define SB2_PC_ACC_reg_addr                                           "0xB801A138"
#define SB2_PC_ACC_reg                                                0xB801A138
#define SB2_PC_ACC_inst_addr                                          "0x004E"
#define SB2_PC_ACC_inst                                               0x004E
#define SB2_PC_ACC_pc_acc_shift                                       (0)
#define SB2_PC_ACC_pc_acc_mask                                        (0xFFFFFFFF)
#define SB2_PC_ACC_pc_acc(data)                                       (0xFFFFFFFF&(data))
#define SB2_PC_ACC_get_pc_acc(data)                                   (0xFFFFFFFF&(data))

#define SB2_PC_RLT                                                    0x1801A13C
#define SB2_PC_RLT_reg_addr                                           "0xB801A13C"
#define SB2_PC_RLT_reg                                                0xB801A13C
#define SB2_PC_RLT_inst_addr                                          "0x004F"
#define SB2_PC_RLT_inst                                               0x004F
#define SB2_PC_RLT_pc_max_lat_shift                                   (16)
#define SB2_PC_RLT_pc_req_num_shift                                   (0)
#define SB2_PC_RLT_pc_max_lat_mask                                    (0xFFFF0000)
#define SB2_PC_RLT_pc_req_num_mask                                    (0x0000FFFF)
#define SB2_PC_RLT_pc_max_lat(data)                                   (0xFFFF0000&((data)<<16))
#define SB2_PC_RLT_pc_req_num(data)                                   (0x0000FFFF&(data))
#define SB2_PC_RLT_get_pc_max_lat(data)                               ((0xFFFF0000&(data))>>16)
#define SB2_PC_RLT_get_pc_req_num(data)                               (0x0000FFFF&(data))

#define SB2_ATA_PAD_FUNC_SEL                                          0x1801A140
#define SB2_ATA_PAD_FUNC_SEL_reg_addr                                 "0xB801A140"
#define SB2_ATA_PAD_FUNC_SEL_reg                                      0xB801A140
#define SB2_ATA_PAD_FUNC_SEL_inst_addr                                "0x0050"
#define SB2_ATA_PAD_FUNC_SEL_inst                                     0x0050
#define SB2_ATA_PAD_FUNC_SEL_ata_pio1_current_shift                   (30)
#define SB2_ATA_PAD_FUNC_SEL_ata_pio2_current_shift                   (29)
#define SB2_ATA_PAD_FUNC_SEL_ata_preset_current_shift                 (28)
#define SB2_ATA_PAD_FUNC_SEL_ata_preset_pud_en_shift                  (27)
#define SB2_ATA_PAD_FUNC_SEL_ata_preset_pud_sel_shift                 (26)
#define SB2_ATA_PAD_FUNC_SEL_ata_piordy_pu_en_shift                   (25)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdmarq_pd_en_shift                   (24)
#define SB2_ATA_PAD_FUNC_SEL_ata_pintrq_pud_en_shift                  (23)
#define SB2_ATA_PAD_FUNC_SEL_ata_pintrq_pud_sel_shift                 (22)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdd_pud_en_shift                     (21)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdd_pud_sel_shift                    (20)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdmackn_pud_en_shift                 (19)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdmackn_pud_sel_shift                (18)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiown_pud_en_shift                  (17)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiown_pud_sel_shift                 (16)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiorn_pud_en_shift                  (15)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiorn_pud_sel_shift                 (14)
#define SB2_ATA_PAD_FUNC_SEL_ata_sio1_current_shift                   (13)
#define SB2_ATA_PAD_FUNC_SEL_ata_sio2_current_shift                   (12)
#define SB2_ATA_PAD_FUNC_SEL_ata_siordy_pu_en_shift                   (11)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdmarq_pd_en_shift                   (10)
#define SB2_ATA_PAD_FUNC_SEL_ata_sintrq_pud_en_shift                  (9)
#define SB2_ATA_PAD_FUNC_SEL_ata_sintrq_pud_sel_shift                 (8)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdd_pud_en_shift                     (7)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdd_pud_sel_shift                    (6)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdmackn_pud_en_shift                 (5)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdmackn_pud_sel_shift                (4)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiown_pud_en_shift                  (3)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiown_pud_sel_shift                 (2)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiorn_pud_en_shift                  (1)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiorn_pud_sel_shift                 (0)
#define SB2_ATA_PAD_FUNC_SEL_ata_pio1_current_mask                    (0x40000000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pio2_current_mask                    (0x20000000)
#define SB2_ATA_PAD_FUNC_SEL_ata_preset_current_mask                  (0x10000000)
#define SB2_ATA_PAD_FUNC_SEL_ata_preset_pud_en_mask                   (0x08000000)
#define SB2_ATA_PAD_FUNC_SEL_ata_preset_pud_sel_mask                  (0x04000000)
#define SB2_ATA_PAD_FUNC_SEL_ata_piordy_pu_en_mask                    (0x02000000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdmarq_pd_en_mask                    (0x01000000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pintrq_pud_en_mask                   (0x00800000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pintrq_pud_sel_mask                  (0x00400000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdd_pud_en_mask                      (0x00200000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdd_pud_sel_mask                     (0x00100000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdmackn_pud_en_mask                  (0x00080000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdmackn_pud_sel_mask                 (0x00040000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiown_pud_en_mask                   (0x00020000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiown_pud_sel_mask                  (0x00010000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiorn_pud_en_mask                   (0x00008000)
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiorn_pud_sel_mask                  (0x00004000)
#define SB2_ATA_PAD_FUNC_SEL_ata_sio1_current_mask                    (0x00002000)
#define SB2_ATA_PAD_FUNC_SEL_ata_sio2_current_mask                    (0x00001000)
#define SB2_ATA_PAD_FUNC_SEL_ata_siordy_pu_en_mask                    (0x00000800)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdmarq_pd_en_mask                    (0x00000400)
#define SB2_ATA_PAD_FUNC_SEL_ata_sintrq_pud_en_mask                   (0x00000200)
#define SB2_ATA_PAD_FUNC_SEL_ata_sintrq_pud_sel_mask                  (0x00000100)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdd_pud_en_mask                      (0x00000080)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdd_pud_sel_mask                     (0x00000040)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdmackn_pud_en_mask                  (0x00000020)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdmackn_pud_sel_mask                 (0x00000010)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiown_pud_en_mask                   (0x00000008)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiown_pud_sel_mask                  (0x00000004)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiorn_pud_en_mask                   (0x00000002)
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiorn_pud_sel_mask                  (0x00000001)
#define SB2_ATA_PAD_FUNC_SEL_ata_pio1_current(data)                   (0x40000000&((data)<<30))
#define SB2_ATA_PAD_FUNC_SEL_ata_pio2_current(data)                   (0x20000000&((data)<<29))
#define SB2_ATA_PAD_FUNC_SEL_ata_preset_current(data)                 (0x10000000&((data)<<28))
#define SB2_ATA_PAD_FUNC_SEL_ata_preset_pud_en(data)                  (0x08000000&((data)<<27))
#define SB2_ATA_PAD_FUNC_SEL_ata_preset_pud_sel(data)                 (0x04000000&((data)<<26))
#define SB2_ATA_PAD_FUNC_SEL_ata_piordy_pu_en(data)                   (0x02000000&((data)<<25))
#define SB2_ATA_PAD_FUNC_SEL_ata_pdmarq_pd_en(data)                   (0x01000000&((data)<<24))
#define SB2_ATA_PAD_FUNC_SEL_ata_pintrq_pud_en(data)                  (0x00800000&((data)<<23))
#define SB2_ATA_PAD_FUNC_SEL_ata_pintrq_pud_sel(data)                 (0x00400000&((data)<<22))
#define SB2_ATA_PAD_FUNC_SEL_ata_pdd_pud_en(data)                     (0x00200000&((data)<<21))
#define SB2_ATA_PAD_FUNC_SEL_ata_pdd_pud_sel(data)                    (0x00100000&((data)<<20))
#define SB2_ATA_PAD_FUNC_SEL_ata_pdmackn_pud_en(data)                 (0x00080000&((data)<<19))
#define SB2_ATA_PAD_FUNC_SEL_ata_pdmackn_pud_sel(data)                (0x00040000&((data)<<18))
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiown_pud_en(data)                  (0x00020000&((data)<<17))
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiown_pud_sel(data)                 (0x00010000&((data)<<16))
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiorn_pud_en(data)                  (0x00008000&((data)<<15))
#define SB2_ATA_PAD_FUNC_SEL_ata_pdiorn_pud_sel(data)                 (0x00004000&((data)<<14))
#define SB2_ATA_PAD_FUNC_SEL_ata_sio1_current(data)                   (0x00002000&((data)<<13))
#define SB2_ATA_PAD_FUNC_SEL_ata_sio2_current(data)                   (0x00001000&((data)<<12))
#define SB2_ATA_PAD_FUNC_SEL_ata_siordy_pu_en(data)                   (0x00000800&((data)<<11))
#define SB2_ATA_PAD_FUNC_SEL_ata_sdmarq_pd_en(data)                   (0x00000400&((data)<<10))
#define SB2_ATA_PAD_FUNC_SEL_ata_sintrq_pud_en(data)                  (0x00000200&((data)<<9))
#define SB2_ATA_PAD_FUNC_SEL_ata_sintrq_pud_sel(data)                 (0x00000100&((data)<<8))
#define SB2_ATA_PAD_FUNC_SEL_ata_sdd_pud_en(data)                     (0x00000080&((data)<<7))
#define SB2_ATA_PAD_FUNC_SEL_ata_sdd_pud_sel(data)                    (0x00000040&((data)<<6))
#define SB2_ATA_PAD_FUNC_SEL_ata_sdmackn_pud_en(data)                 (0x00000020&((data)<<5))
#define SB2_ATA_PAD_FUNC_SEL_ata_sdmackn_pud_sel(data)                (0x00000010&((data)<<4))
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiown_pud_en(data)                  (0x00000008&((data)<<3))
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiown_pud_sel(data)                 (0x00000004&((data)<<2))
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiorn_pud_en(data)                  (0x00000002&((data)<<1))
#define SB2_ATA_PAD_FUNC_SEL_ata_sdiorn_pud_sel(data)                 (0x00000001&(data))
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pio1_current(data)               ((0x40000000&(data))>>30)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pio2_current(data)               ((0x20000000&(data))>>29)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_preset_current(data)             ((0x10000000&(data))>>28)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_preset_pud_en(data)              ((0x08000000&(data))>>27)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_preset_pud_sel(data)             ((0x04000000&(data))>>26)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_piordy_pu_en(data)               ((0x02000000&(data))>>25)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pdmarq_pd_en(data)               ((0x01000000&(data))>>24)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pintrq_pud_en(data)              ((0x00800000&(data))>>23)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pintrq_pud_sel(data)             ((0x00400000&(data))>>22)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pdd_pud_en(data)                 ((0x00200000&(data))>>21)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pdd_pud_sel(data)                ((0x00100000&(data))>>20)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pdmackn_pud_en(data)             ((0x00080000&(data))>>19)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pdmackn_pud_sel(data)            ((0x00040000&(data))>>18)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pdiown_pud_en(data)              ((0x00020000&(data))>>17)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pdiown_pud_sel(data)             ((0x00010000&(data))>>16)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pdiorn_pud_en(data)              ((0x00008000&(data))>>15)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_pdiorn_pud_sel(data)             ((0x00004000&(data))>>14)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sio1_current(data)               ((0x00002000&(data))>>13)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sio2_current(data)               ((0x00001000&(data))>>12)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_siordy_pu_en(data)               ((0x00000800&(data))>>11)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sdmarq_pd_en(data)               ((0x00000400&(data))>>10)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sintrq_pud_en(data)              ((0x00000200&(data))>>9)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sintrq_pud_sel(data)             ((0x00000100&(data))>>8)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sdd_pud_en(data)                 ((0x00000080&(data))>>7)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sdd_pud_sel(data)                ((0x00000040&(data))>>6)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sdmackn_pud_en(data)             ((0x00000020&(data))>>5)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sdmackn_pud_sel(data)            ((0x00000010&(data))>>4)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sdiown_pud_en(data)              ((0x00000008&(data))>>3)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sdiown_pud_sel(data)             ((0x00000004&(data))>>2)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sdiorn_pud_en(data)              ((0x00000002&(data))>>1)
#define SB2_ATA_PAD_FUNC_SEL_get_ata_sdiorn_pud_sel(data)             (0x00000001&(data))

#define SB2_ROM_PAD_FUNC_SEL                                          0x1801A144
#define SB2_ROM_PAD_FUNC_SEL_reg_addr                                 "0xB801A144"
#define SB2_ROM_PAD_FUNC_SEL_reg                                      0xB801A144
#define SB2_ROM_PAD_FUNC_SEL_inst_addr                                "0x0051"
#define SB2_ROM_PAD_FUNC_SEL_inst                                     0x0051
#define SB2_ROM_PAD_FUNC_SEL_rom_io24_current_shift                   (15)
#define SB2_ROM_PAD_FUNC_SEL_rom_io48_current_shift                   (14)
#define SB2_ROM_PAD_FUNC_SEL_rom_csn_pu_en_shift                      (13)
#define SB2_ROM_PAD_FUNC_SEL_rom_wrn_pud_en_shift                     (12)
#define SB2_ROM_PAD_FUNC_SEL_rom_wrn_pud_sel_shift                    (11)
#define SB2_ROM_PAD_FUNC_SEL_rom_rdn_pud_en_shift                     (10)
#define SB2_ROM_PAD_FUNC_SEL_rom_rdn_pud_sel_shift                    (9)
#define SB2_ROM_PAD_FUNC_SEL_rom_da22_7_pud_en_shift                  (8)
#define SB2_ROM_PAD_FUNC_SEL_rom_da22_7_pud_sel_shift                 (7)
#define SB2_ROM_PAD_FUNC_SEL_rom_da4_pd_en_shift                      (6)
#define SB2_ROM_PAD_FUNC_SEL_rom_da3_pud_en_shift                     (5)
#define SB2_ROM_PAD_FUNC_SEL_rom_da3_pud_sel_shift                    (4)
#define SB2_ROM_PAD_FUNC_SEL_rom_dd7_pud_en_shift                     (3)
#define SB2_ROM_PAD_FUNC_SEL_rom_dd7_pud_sel_shift                    (2)
#define SB2_ROM_PAD_FUNC_SEL_rom_dd6_0_pud_en_shift                   (1)
#define SB2_ROM_PAD_FUNC_SEL_rom_dd6_0_pud_sel_shift                  (0)
#define SB2_ROM_PAD_FUNC_SEL_rom_io24_current_mask                    (0x00008000)
#define SB2_ROM_PAD_FUNC_SEL_rom_io48_current_mask                    (0x00004000)
#define SB2_ROM_PAD_FUNC_SEL_rom_csn_pu_en_mask                       (0x00002000)
#define SB2_ROM_PAD_FUNC_SEL_rom_wrn_pud_en_mask                      (0x00001000)
#define SB2_ROM_PAD_FUNC_SEL_rom_wrn_pud_sel_mask                     (0x00000800)
#define SB2_ROM_PAD_FUNC_SEL_rom_rdn_pud_en_mask                      (0x00000400)
#define SB2_ROM_PAD_FUNC_SEL_rom_rdn_pud_sel_mask                     (0x00000200)
#define SB2_ROM_PAD_FUNC_SEL_rom_da22_7_pud_en_mask                   (0x00000100)
#define SB2_ROM_PAD_FUNC_SEL_rom_da22_7_pud_sel_mask                  (0x00000080)
#define SB2_ROM_PAD_FUNC_SEL_rom_da4_pd_en_mask                       (0x00000040)
#define SB2_ROM_PAD_FUNC_SEL_rom_da3_pud_en_mask                      (0x00000020)
#define SB2_ROM_PAD_FUNC_SEL_rom_da3_pud_sel_mask                     (0x00000010)
#define SB2_ROM_PAD_FUNC_SEL_rom_dd7_pud_en_mask                      (0x00000008)
#define SB2_ROM_PAD_FUNC_SEL_rom_dd7_pud_sel_mask                     (0x00000004)
#define SB2_ROM_PAD_FUNC_SEL_rom_dd6_0_pud_en_mask                    (0x00000002)
#define SB2_ROM_PAD_FUNC_SEL_rom_dd6_0_pud_sel_mask                   (0x00000001)
#define SB2_ROM_PAD_FUNC_SEL_rom_io24_current(data)                   (0x00008000&((data)<<15))
#define SB2_ROM_PAD_FUNC_SEL_rom_io48_current(data)                   (0x00004000&((data)<<14))
#define SB2_ROM_PAD_FUNC_SEL_rom_csn_pu_en(data)                      (0x00002000&((data)<<13))
#define SB2_ROM_PAD_FUNC_SEL_rom_wrn_pud_en(data)                     (0x00001000&((data)<<12))
#define SB2_ROM_PAD_FUNC_SEL_rom_wrn_pud_sel(data)                    (0x00000800&((data)<<11))
#define SB2_ROM_PAD_FUNC_SEL_rom_rdn_pud_en(data)                     (0x00000400&((data)<<10))
#define SB2_ROM_PAD_FUNC_SEL_rom_rdn_pud_sel(data)                    (0x00000200&((data)<<9))
#define SB2_ROM_PAD_FUNC_SEL_rom_da22_7_pud_en(data)                  (0x00000100&((data)<<8))
#define SB2_ROM_PAD_FUNC_SEL_rom_da22_7_pud_sel(data)                 (0x00000080&((data)<<7))
#define SB2_ROM_PAD_FUNC_SEL_rom_da4_pd_en(data)                      (0x00000040&((data)<<6))
#define SB2_ROM_PAD_FUNC_SEL_rom_da3_pud_en(data)                     (0x00000020&((data)<<5))
#define SB2_ROM_PAD_FUNC_SEL_rom_da3_pud_sel(data)                    (0x00000010&((data)<<4))
#define SB2_ROM_PAD_FUNC_SEL_rom_dd7_pud_en(data)                     (0x00000008&((data)<<3))
#define SB2_ROM_PAD_FUNC_SEL_rom_dd7_pud_sel(data)                    (0x00000004&((data)<<2))
#define SB2_ROM_PAD_FUNC_SEL_rom_dd6_0_pud_en(data)                   (0x00000002&((data)<<1))
#define SB2_ROM_PAD_FUNC_SEL_rom_dd6_0_pud_sel(data)                  (0x00000001&(data))
#define SB2_ROM_PAD_FUNC_SEL_get_rom_io24_current(data)               ((0x00008000&(data))>>15)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_io48_current(data)               ((0x00004000&(data))>>14)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_csn_pu_en(data)                  ((0x00002000&(data))>>13)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_wrn_pud_en(data)                 ((0x00001000&(data))>>12)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_wrn_pud_sel(data)                ((0x00000800&(data))>>11)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_rdn_pud_en(data)                 ((0x00000400&(data))>>10)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_rdn_pud_sel(data)                ((0x00000200&(data))>>9)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_da22_7_pud_en(data)              ((0x00000100&(data))>>8)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_da22_7_pud_sel(data)             ((0x00000080&(data))>>7)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_da4_pd_en(data)                  ((0x00000040&(data))>>6)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_da3_pud_en(data)                 ((0x00000020&(data))>>5)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_da3_pud_sel(data)                ((0x00000010&(data))>>4)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_dd7_pud_en(data)                 ((0x00000008&(data))>>3)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_dd7_pud_sel(data)                ((0x00000004&(data))>>2)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_dd6_0_pud_en(data)               ((0x00000002&(data))>>1)
#define SB2_ROM_PAD_FUNC_SEL_get_rom_dd6_0_pud_sel(data)              (0x00000001&(data))

#define SB2_GPIO1_PAD_FUNC_SEL                                        0x1801A148
#define SB2_GPIO1_PAD_FUNC_SEL_reg_addr                               "0xB801A148"
#define SB2_GPIO1_PAD_FUNC_SEL_reg                                    0xB801A148
#define SB2_GPIO1_PAD_FUNC_SEL_inst_addr                              "0x0052"
#define SB2_GPIO1_PAD_FUNC_SEL_inst                                   0x0052
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx0_current_shift                 (29)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx0_pud_en_shift                  (28)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx0_pud_sel_shift                 (27)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx0_current_shift                 (26)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx0_pud_en_shift                  (25)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx0_pud_sel_shift                 (24)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx1_current_shift                 (23)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx1_pud_en_shift                  (22)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx1_pud_sel_shift                 (21)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx1_current_shift                 (20)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx1_pud_en_shift                  (19)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx1_pud_sel_shift                 (18)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_scl_current_shift                  (17)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_scl_pud_en_shift                   (16)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_scl_pud_sel_shift                  (15)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_sda_current_shift                  (14)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_sda_pud_en_shift                   (13)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_sda_pud_sel_shift                  (12)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio6_current_shift                    (11)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio6_pud_en_shift                     (10)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio6_pud_sel_shift                    (9)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio7_current_shift                    (8)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio7_pud_en_shift                     (7)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio7_pud_sel_shift                    (6)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio8_current_shift                    (5)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio8_pud_en_shift                     (4)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio8_pud_sel_shift                    (3)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio9_current_shift                    (2)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio9_pud_en_shift                     (1)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio9_pud_sel_shift                    (0)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx0_current_mask                  (0x20000000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx0_pud_en_mask                   (0x10000000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx0_pud_sel_mask                  (0x08000000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx0_current_mask                  (0x04000000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx0_pud_en_mask                   (0x02000000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx0_pud_sel_mask                  (0x01000000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx1_current_mask                  (0x00800000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx1_pud_en_mask                   (0x00400000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx1_pud_sel_mask                  (0x00200000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx1_current_mask                  (0x00100000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx1_pud_en_mask                   (0x00080000)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx1_pud_sel_mask                  (0x00040000)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_scl_current_mask                   (0x00020000)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_scl_pud_en_mask                    (0x00010000)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_scl_pud_sel_mask                   (0x00008000)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_sda_current_mask                   (0x00004000)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_sda_pud_en_mask                    (0x00002000)
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_sda_pud_sel_mask                   (0x00001000)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio6_current_mask                     (0x00000800)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio6_pud_en_mask                      (0x00000400)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio6_pud_sel_mask                     (0x00000200)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio7_current_mask                     (0x00000100)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio7_pud_en_mask                      (0x00000080)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio7_pud_sel_mask                     (0x00000040)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio8_current_mask                     (0x00000020)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio8_pud_en_mask                      (0x00000010)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio8_pud_sel_mask                     (0x00000008)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio9_current_mask                     (0x00000004)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio9_pud_en_mask                      (0x00000002)
#define SB2_GPIO1_PAD_FUNC_SEL_gpio9_pud_sel_mask                     (0x00000001)
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx0_current(data)                 (0x20000000&((data)<<29))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx0_pud_en(data)                  (0x10000000&((data)<<28))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx0_pud_sel(data)                 (0x08000000&((data)<<27))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx0_current(data)                 (0x04000000&((data)<<26))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx0_pud_en(data)                  (0x02000000&((data)<<25))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx0_pud_sel(data)                 (0x01000000&((data)<<24))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx1_current(data)                 (0x00800000&((data)<<23))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx1_pud_en(data)                  (0x00400000&((data)<<22))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_rx1_pud_sel(data)                 (0x00200000&((data)<<21))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx1_current(data)                 (0x00100000&((data)<<20))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx1_pud_en(data)                  (0x00080000&((data)<<19))
#define SB2_GPIO1_PAD_FUNC_SEL_uart_tx1_pud_sel(data)                 (0x00040000&((data)<<18))
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_scl_current(data)                  (0x00020000&((data)<<17))
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_scl_pud_en(data)                   (0x00010000&((data)<<16))
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_scl_pud_sel(data)                  (0x00008000&((data)<<15))
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_sda_current(data)                  (0x00004000&((data)<<14))
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_sda_pud_en(data)                   (0x00002000&((data)<<13))
#define SB2_GPIO1_PAD_FUNC_SEL_i2c_sda_pud_sel(data)                  (0x00001000&((data)<<12))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio6_current(data)                    (0x00000800&((data)<<11))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio6_pud_en(data)                     (0x00000400&((data)<<10))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio6_pud_sel(data)                    (0x00000200&((data)<<9))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio7_current(data)                    (0x00000100&((data)<<8))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio7_pud_en(data)                     (0x00000080&((data)<<7))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio7_pud_sel(data)                    (0x00000040&((data)<<6))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio8_current(data)                    (0x00000020&((data)<<5))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio8_pud_en(data)                     (0x00000010&((data)<<4))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio8_pud_sel(data)                    (0x00000008&((data)<<3))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio9_current(data)                    (0x00000004&((data)<<2))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio9_pud_en(data)                     (0x00000002&((data)<<1))
#define SB2_GPIO1_PAD_FUNC_SEL_gpio9_pud_sel(data)                    (0x00000001&(data))
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_rx0_current(data)             ((0x20000000&(data))>>29)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_rx0_pud_en(data)              ((0x10000000&(data))>>28)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_rx0_pud_sel(data)             ((0x08000000&(data))>>27)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_tx0_current(data)             ((0x04000000&(data))>>26)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_tx0_pud_en(data)              ((0x02000000&(data))>>25)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_tx0_pud_sel(data)             ((0x01000000&(data))>>24)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_rx1_current(data)             ((0x00800000&(data))>>23)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_rx1_pud_en(data)              ((0x00400000&(data))>>22)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_rx1_pud_sel(data)             ((0x00200000&(data))>>21)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_tx1_current(data)             ((0x00100000&(data))>>20)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_tx1_pud_en(data)              ((0x00080000&(data))>>19)
#define SB2_GPIO1_PAD_FUNC_SEL_get_uart_tx1_pud_sel(data)             ((0x00040000&(data))>>18)
#define SB2_GPIO1_PAD_FUNC_SEL_get_i2c_scl_current(data)              ((0x00020000&(data))>>17)
#define SB2_GPIO1_PAD_FUNC_SEL_get_i2c_scl_pud_en(data)               ((0x00010000&(data))>>16)
#define SB2_GPIO1_PAD_FUNC_SEL_get_i2c_scl_pud_sel(data)              ((0x00008000&(data))>>15)
#define SB2_GPIO1_PAD_FUNC_SEL_get_i2c_sda_current(data)              ((0x00004000&(data))>>14)
#define SB2_GPIO1_PAD_FUNC_SEL_get_i2c_sda_pud_en(data)               ((0x00002000&(data))>>13)
#define SB2_GPIO1_PAD_FUNC_SEL_get_i2c_sda_pud_sel(data)              ((0x00001000&(data))>>12)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio6_current(data)                ((0x00000800&(data))>>11)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio6_pud_en(data)                 ((0x00000400&(data))>>10)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio6_pud_sel(data)                ((0x00000200&(data))>>9)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio7_current(data)                ((0x00000100&(data))>>8)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio7_pud_en(data)                 ((0x00000080&(data))>>7)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio7_pud_sel(data)                ((0x00000040&(data))>>6)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio8_current(data)                ((0x00000020&(data))>>5)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio8_pud_en(data)                 ((0x00000010&(data))>>4)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio8_pud_sel(data)                ((0x00000008&(data))>>3)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio9_current(data)                ((0x00000004&(data))>>2)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio9_pud_en(data)                 ((0x00000002&(data))>>1)
#define SB2_GPIO1_PAD_FUNC_SEL_get_gpio9_pud_sel(data)                (0x00000001&(data))

#define SB2_GPIO2_PAD_FUNC_SEL                                        0x1801A14C
#define SB2_GPIO2_PAD_FUNC_SEL_reg_addr                               "0xB801A14C"
#define SB2_GPIO2_PAD_FUNC_SEL_reg                                    0xB801A14C
#define SB2_GPIO2_PAD_FUNC_SEL_inst_addr                              "0x0053"
#define SB2_GPIO2_PAD_FUNC_SEL_inst                                   0x0053
#define SB2_GPIO2_PAD_FUNC_SEL_gpio10_current_shift                   (29)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio10_pud_en_shift                    (28)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio10_pud_sel_shift                   (27)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio11_current_shift                   (26)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio11_pud_en_shift                    (25)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio11_pud_sel_shift                   (24)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio12_current_shift                   (23)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio12_pud_en_shift                    (22)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio12_pud_sel_shift                   (21)
#define SB2_GPIO2_PAD_FUNC_SEL_vdclk_current_shift                    (20)
#define SB2_GPIO2_PAD_FUNC_SEL_vdclk_pud_en_shift                     (19)
#define SB2_GPIO2_PAD_FUNC_SEL_vdclk_pud_sel_shift                    (18)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd7_current_shift                    (17)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd7_pud_en_shift                     (16)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd7_pud_sel_shift                    (15)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd6_current_shift                    (14)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd6_pud_en_shift                     (13)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd6_pud_sel_shift                    (12)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd5_current_shift                    (11)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd5_pud_en_shift                     (10)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd5_pud_sel_shift                    (9)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd4_current_shift                    (8)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd4_pud_en_shift                     (7)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd4_pud_sel_shift                    (6)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd3_current_shift                    (5)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd3_pud_en_shift                     (4)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd3_pud_sel_shift                    (3)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd2_current_shift                    (2)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd2_pud_en_shift                     (1)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd2_pud_sel_shift                    (0)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio10_current_mask                    (0x20000000)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio10_pud_en_mask                     (0x10000000)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio10_pud_sel_mask                    (0x08000000)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio11_current_mask                    (0x04000000)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio11_pud_en_mask                     (0x02000000)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio11_pud_sel_mask                    (0x01000000)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio12_current_mask                    (0x00800000)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio12_pud_en_mask                     (0x00400000)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio12_pud_sel_mask                    (0x00200000)
#define SB2_GPIO2_PAD_FUNC_SEL_vdclk_current_mask                     (0x00100000)
#define SB2_GPIO2_PAD_FUNC_SEL_vdclk_pud_en_mask                      (0x00080000)
#define SB2_GPIO2_PAD_FUNC_SEL_vdclk_pud_sel_mask                     (0x00040000)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd7_current_mask                     (0x00020000)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd7_pud_en_mask                      (0x00010000)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd7_pud_sel_mask                     (0x00008000)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd6_current_mask                     (0x00004000)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd6_pud_en_mask                      (0x00002000)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd6_pud_sel_mask                     (0x00001000)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd5_current_mask                     (0x00000800)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd5_pud_en_mask                      (0x00000400)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd5_pud_sel_mask                     (0x00000200)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd4_current_mask                     (0x00000100)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd4_pud_en_mask                      (0x00000080)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd4_pud_sel_mask                     (0x00000040)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd3_current_mask                     (0x00000020)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd3_pud_en_mask                      (0x00000010)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd3_pud_sel_mask                     (0x00000008)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd2_current_mask                     (0x00000004)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd2_pud_en_mask                      (0x00000002)
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd2_pud_sel_mask                     (0x00000001)
#define SB2_GPIO2_PAD_FUNC_SEL_gpio10_current(data)                   (0x20000000&((data)<<29))
#define SB2_GPIO2_PAD_FUNC_SEL_gpio10_pud_en(data)                    (0x10000000&((data)<<28))
#define SB2_GPIO2_PAD_FUNC_SEL_gpio10_pud_sel(data)                   (0x08000000&((data)<<27))
#define SB2_GPIO2_PAD_FUNC_SEL_gpio11_current(data)                   (0x04000000&((data)<<26))
#define SB2_GPIO2_PAD_FUNC_SEL_gpio11_pud_en(data)                    (0x02000000&((data)<<25))
#define SB2_GPIO2_PAD_FUNC_SEL_gpio11_pud_sel(data)                   (0x01000000&((data)<<24))
#define SB2_GPIO2_PAD_FUNC_SEL_gpio12_current(data)                   (0x00800000&((data)<<23))
#define SB2_GPIO2_PAD_FUNC_SEL_gpio12_pud_en(data)                    (0x00400000&((data)<<22))
#define SB2_GPIO2_PAD_FUNC_SEL_gpio12_pud_sel(data)                   (0x00200000&((data)<<21))
#define SB2_GPIO2_PAD_FUNC_SEL_vdclk_current(data)                    (0x00100000&((data)<<20))
#define SB2_GPIO2_PAD_FUNC_SEL_vdclk_pud_en(data)                     (0x00080000&((data)<<19))
#define SB2_GPIO2_PAD_FUNC_SEL_vdclk_pud_sel(data)                    (0x00040000&((data)<<18))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd7_current(data)                    (0x00020000&((data)<<17))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd7_pud_en(data)                     (0x00010000&((data)<<16))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd7_pud_sel(data)                    (0x00008000&((data)<<15))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd6_current(data)                    (0x00004000&((data)<<14))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd6_pud_en(data)                     (0x00002000&((data)<<13))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd6_pud_sel(data)                    (0x00001000&((data)<<12))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd5_current(data)                    (0x00000800&((data)<<11))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd5_pud_en(data)                     (0x00000400&((data)<<10))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd5_pud_sel(data)                    (0x00000200&((data)<<9))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd4_current(data)                    (0x00000100&((data)<<8))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd4_pud_en(data)                     (0x00000080&((data)<<7))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd4_pud_sel(data)                    (0x00000040&((data)<<6))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd3_current(data)                    (0x00000020&((data)<<5))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd3_pud_en(data)                     (0x00000010&((data)<<4))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd3_pud_sel(data)                    (0x00000008&((data)<<3))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd2_current(data)                    (0x00000004&((data)<<2))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd2_pud_en(data)                     (0x00000002&((data)<<1))
#define SB2_GPIO2_PAD_FUNC_SEL_vdpd2_pud_sel(data)                    (0x00000001&(data))
#define SB2_GPIO2_PAD_FUNC_SEL_get_gpio10_current(data)               ((0x20000000&(data))>>29)
#define SB2_GPIO2_PAD_FUNC_SEL_get_gpio10_pud_en(data)                ((0x10000000&(data))>>28)
#define SB2_GPIO2_PAD_FUNC_SEL_get_gpio10_pud_sel(data)               ((0x08000000&(data))>>27)
#define SB2_GPIO2_PAD_FUNC_SEL_get_gpio11_current(data)               ((0x04000000&(data))>>26)
#define SB2_GPIO2_PAD_FUNC_SEL_get_gpio11_pud_en(data)                ((0x02000000&(data))>>25)
#define SB2_GPIO2_PAD_FUNC_SEL_get_gpio11_pud_sel(data)               ((0x01000000&(data))>>24)
#define SB2_GPIO2_PAD_FUNC_SEL_get_gpio12_current(data)               ((0x00800000&(data))>>23)
#define SB2_GPIO2_PAD_FUNC_SEL_get_gpio12_pud_en(data)                ((0x00400000&(data))>>22)
#define SB2_GPIO2_PAD_FUNC_SEL_get_gpio12_pud_sel(data)               ((0x00200000&(data))>>21)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdclk_current(data)                ((0x00100000&(data))>>20)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdclk_pud_en(data)                 ((0x00080000&(data))>>19)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdclk_pud_sel(data)                ((0x00040000&(data))>>18)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd7_current(data)                ((0x00020000&(data))>>17)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd7_pud_en(data)                 ((0x00010000&(data))>>16)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd7_pud_sel(data)                ((0x00008000&(data))>>15)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd6_current(data)                ((0x00004000&(data))>>14)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd6_pud_en(data)                 ((0x00002000&(data))>>13)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd6_pud_sel(data)                ((0x00001000&(data))>>12)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd5_current(data)                ((0x00000800&(data))>>11)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd5_pud_en(data)                 ((0x00000400&(data))>>10)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd5_pud_sel(data)                ((0x00000200&(data))>>9)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd4_current(data)                ((0x00000100&(data))>>8)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd4_pud_en(data)                 ((0x00000080&(data))>>7)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd4_pud_sel(data)                ((0x00000040&(data))>>6)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd3_current(data)                ((0x00000020&(data))>>5)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd3_pud_en(data)                 ((0x00000010&(data))>>4)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd3_pud_sel(data)                ((0x00000008&(data))>>3)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd2_current(data)                ((0x00000004&(data))>>2)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd2_pud_en(data)                 ((0x00000002&(data))>>1)
#define SB2_GPIO2_PAD_FUNC_SEL_get_vdpd2_pud_sel(data)                (0x00000001&(data))

#define SB2_GPIO3_PAD_FUNC_SEL                                        0x1801A150
#define SB2_GPIO3_PAD_FUNC_SEL_reg_addr                               "0xB801A150"
#define SB2_GPIO3_PAD_FUNC_SEL_reg                                    0xB801A150
#define SB2_GPIO3_PAD_FUNC_SEL_inst_addr                              "0x0054"
#define SB2_GPIO3_PAD_FUNC_SEL_inst                                   0x0054
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd1_current_shift                    (29)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd1_pud_en_shift                     (28)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd1_pud_sel_shift                    (27)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd0_current_shift                    (26)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd0_pud_en_shift                     (25)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd0_pud_sel_shift                    (24)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd1_current_shift                   (23)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd1_pud_en_shift                    (22)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd1_pud_sel_shift                   (21)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd2_current_shift                   (20)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd2_pud_en_shift                    (19)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd2_pud_sel_shift                   (18)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd3_current_shift                   (17)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd3_pud_en_shift                    (16)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd3_pud_sel_shift                   (15)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_rstn_current_shift                  (14)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_rstn_pud_en_shift                   (13)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_rstn_pud_sel_shift                  (12)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tclk_current_shift                  (11)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tclk_pud_en_shift                   (10)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tclk_pud_sel_shift                  (9)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tms_current_shift                   (8)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tms_pud_en_shift                    (7)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tms_pud_sel_shift                   (6)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdi_current_shift                   (5)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdi_pud_en_shift                    (4)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdi_pud_sel_shift                   (3)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdo_current_shift                   (2)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdo_pud_en_shift                    (1)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdo_pud_sel_shift                   (0)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd1_current_mask                     (0x20000000)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd1_pud_en_mask                      (0x10000000)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd1_pud_sel_mask                     (0x08000000)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd0_current_mask                     (0x04000000)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd0_pud_en_mask                      (0x02000000)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd0_pud_sel_mask                     (0x01000000)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd1_current_mask                    (0x00800000)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd1_pud_en_mask                     (0x00400000)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd1_pud_sel_mask                    (0x00200000)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd2_current_mask                    (0x00100000)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd2_pud_en_mask                     (0x00080000)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd2_pud_sel_mask                    (0x00040000)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd3_current_mask                    (0x00020000)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd3_pud_en_mask                     (0x00010000)
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd3_pud_sel_mask                    (0x00008000)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_rstn_current_mask                   (0x00004000)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_rstn_pud_en_mask                    (0x00002000)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_rstn_pud_sel_mask                   (0x00001000)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tclk_current_mask                   (0x00000800)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tclk_pud_en_mask                    (0x00000400)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tclk_pud_sel_mask                   (0x00000200)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tms_current_mask                    (0x00000100)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tms_pud_en_mask                     (0x00000080)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tms_pud_sel_mask                    (0x00000040)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdi_current_mask                    (0x00000020)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdi_pud_en_mask                     (0x00000010)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdi_pud_sel_mask                    (0x00000008)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdo_current_mask                    (0x00000004)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdo_pud_en_mask                     (0x00000002)
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdo_pud_sel_mask                    (0x00000001)
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd1_current(data)                    (0x20000000&((data)<<29))
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd1_pud_en(data)                     (0x10000000&((data)<<28))
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd1_pud_sel(data)                    (0x08000000&((data)<<27))
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd0_current(data)                    (0x04000000&((data)<<26))
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd0_pud_en(data)                     (0x02000000&((data)<<25))
#define SB2_GPIO3_PAD_FUNC_SEL_vdpd0_pud_sel(data)                    (0x01000000&((data)<<24))
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd1_current(data)                   (0x00800000&((data)<<23))
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd1_pud_en(data)                    (0x00400000&((data)<<22))
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd1_pud_sel(data)                   (0x00200000&((data)<<21))
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd2_current(data)                   (0x00100000&((data)<<20))
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd2_pud_en(data)                    (0x00080000&((data)<<19))
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd2_pud_sel(data)                   (0x00040000&((data)<<18))
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd3_current(data)                   (0x00020000&((data)<<17))
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd3_pud_en(data)                    (0x00010000&((data)<<16))
#define SB2_GPIO3_PAD_FUNC_SEL_ao_sd3_pud_sel(data)                   (0x00008000&((data)<<15))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_rstn_current(data)                  (0x00004000&((data)<<14))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_rstn_pud_en(data)                   (0x00002000&((data)<<13))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_rstn_pud_sel(data)                  (0x00001000&((data)<<12))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tclk_current(data)                  (0x00000800&((data)<<11))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tclk_pud_en(data)                   (0x00000400&((data)<<10))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tclk_pud_sel(data)                  (0x00000200&((data)<<9))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tms_current(data)                   (0x00000100&((data)<<8))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tms_pud_en(data)                    (0x00000080&((data)<<7))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tms_pud_sel(data)                   (0x00000040&((data)<<6))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdi_current(data)                   (0x00000020&((data)<<5))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdi_pud_en(data)                    (0x00000010&((data)<<4))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdi_pud_sel(data)                   (0x00000008&((data)<<3))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdo_current(data)                   (0x00000004&((data)<<2))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdo_pud_en(data)                    (0x00000002&((data)<<1))
#define SB2_GPIO3_PAD_FUNC_SEL_ej_tdo_pud_sel(data)                   (0x00000001&(data))
#define SB2_GPIO3_PAD_FUNC_SEL_get_vdpd1_current(data)                ((0x20000000&(data))>>29)
#define SB2_GPIO3_PAD_FUNC_SEL_get_vdpd1_pud_en(data)                 ((0x10000000&(data))>>28)
#define SB2_GPIO3_PAD_FUNC_SEL_get_vdpd1_pud_sel(data)                ((0x08000000&(data))>>27)
#define SB2_GPIO3_PAD_FUNC_SEL_get_vdpd0_current(data)                ((0x04000000&(data))>>26)
#define SB2_GPIO3_PAD_FUNC_SEL_get_vdpd0_pud_en(data)                 ((0x02000000&(data))>>25)
#define SB2_GPIO3_PAD_FUNC_SEL_get_vdpd0_pud_sel(data)                ((0x01000000&(data))>>24)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ao_sd1_current(data)               ((0x00800000&(data))>>23)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ao_sd1_pud_en(data)                ((0x00400000&(data))>>22)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ao_sd1_pud_sel(data)               ((0x00200000&(data))>>21)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ao_sd2_current(data)               ((0x00100000&(data))>>20)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ao_sd2_pud_en(data)                ((0x00080000&(data))>>19)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ao_sd2_pud_sel(data)               ((0x00040000&(data))>>18)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ao_sd3_current(data)               ((0x00020000&(data))>>17)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ao_sd3_pud_en(data)                ((0x00010000&(data))>>16)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ao_sd3_pud_sel(data)               ((0x00008000&(data))>>15)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_rstn_current(data)              ((0x00004000&(data))>>14)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_rstn_pud_en(data)               ((0x00002000&(data))>>13)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_rstn_pud_sel(data)              ((0x00001000&(data))>>12)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tclk_current(data)              ((0x00000800&(data))>>11)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tclk_pud_en(data)               ((0x00000400&(data))>>10)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tclk_pud_sel(data)              ((0x00000200&(data))>>9)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tms_current(data)               ((0x00000100&(data))>>8)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tms_pud_en(data)                ((0x00000080&(data))>>7)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tms_pud_sel(data)               ((0x00000040&(data))>>6)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tdi_current(data)               ((0x00000020&(data))>>5)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tdi_pud_en(data)                ((0x00000010&(data))>>4)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tdi_pud_sel(data)               ((0x00000008&(data))>>3)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tdo_current(data)               ((0x00000004&(data))>>2)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tdo_pud_en(data)                ((0x00000002&(data))>>1)
#define SB2_GPIO3_PAD_FUNC_SEL_get_ej_tdo_pud_sel(data)               (0x00000001&(data))

#define SB2_GPIO4_PAD_FUNC_SEL                                        0x1801A154
#define SB2_GPIO4_PAD_FUNC_SEL_reg_addr                               "0xB801A154"
#define SB2_GPIO4_PAD_FUNC_SEL_reg                                    0xB801A154
#define SB2_GPIO4_PAD_FUNC_SEL_inst_addr                              "0x0055"
#define SB2_GPIO4_PAD_FUNC_SEL_inst                                   0x0055
#define SB2_GPIO4_PAD_FUNC_SEL_ddr_in_pwr_down_en_shift               (31)
#define SB2_GPIO4_PAD_FUNC_SEL_ddr_out_tri_state_en_shift             (30)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio35_current_shift                   (14)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio35_pud_en_shift                    (13)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio35_pud_sel_shift                   (12)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio34_current_shift                   (11)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio34_pud_en_shift                    (10)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio34_pud_sel_shift                   (9)
#define SB2_GPIO4_PAD_FUNC_SEL_ai_sd1_current_shift                   (8)
#define SB2_GPIO4_PAD_FUNC_SEL_ai_sd1_pud_en_shift                    (7)
#define SB2_GPIO4_PAD_FUNC_SEL_ai_sd1_pud_sel_shift                   (6)
#define SB2_GPIO4_PAD_FUNC_SEL_spdif_in_current_shift                 (5)
#define SB2_GPIO4_PAD_FUNC_SEL_spdif_in_pud_en_shift                  (4)
#define SB2_GPIO4_PAD_FUNC_SEL_spdif_in_pud_sel_shift                 (3)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio33_current_shift                   (2)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio33_pud_en_shift                    (1)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio33_pud_sel_shift                   (0)
#define SB2_GPIO4_PAD_FUNC_SEL_ddr_in_pwr_down_en_mask                (0x80000000)
#define SB2_GPIO4_PAD_FUNC_SEL_ddr_out_tri_state_en_mask              (0x40000000)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio35_current_mask                    (0x00004000)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio35_pud_en_mask                     (0x00002000)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio35_pud_sel_mask                    (0x00001000)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio34_current_mask                    (0x00000800)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio34_pud_en_mask                     (0x00000400)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio34_pud_sel_mask                    (0x00000200)
#define SB2_GPIO4_PAD_FUNC_SEL_ai_sd1_current_mask                    (0x00000100)
#define SB2_GPIO4_PAD_FUNC_SEL_ai_sd1_pud_en_mask                     (0x00000080)
#define SB2_GPIO4_PAD_FUNC_SEL_ai_sd1_pud_sel_mask                    (0x00000040)
#define SB2_GPIO4_PAD_FUNC_SEL_spdif_in_current_mask                  (0x00000020)
#define SB2_GPIO4_PAD_FUNC_SEL_spdif_in_pud_en_mask                   (0x00000010)
#define SB2_GPIO4_PAD_FUNC_SEL_spdif_in_pud_sel_mask                  (0x00000008)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio33_current_mask                    (0x00000004)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio33_pud_en_mask                     (0x00000002)
#define SB2_GPIO4_PAD_FUNC_SEL_gpio33_pud_sel_mask                    (0x00000001)
#define SB2_GPIO4_PAD_FUNC_SEL_ddr_in_pwr_down_en(data)               (0x80000000&((data)<<31))
#define SB2_GPIO4_PAD_FUNC_SEL_ddr_out_tri_state_en(data)             (0x40000000&((data)<<30))
#define SB2_GPIO4_PAD_FUNC_SEL_gpio35_current(data)                   (0x00004000&((data)<<14))
#define SB2_GPIO4_PAD_FUNC_SEL_gpio35_pud_en(data)                    (0x00002000&((data)<<13))
#define SB2_GPIO4_PAD_FUNC_SEL_gpio35_pud_sel(data)                   (0x00001000&((data)<<12))
#define SB2_GPIO4_PAD_FUNC_SEL_gpio34_current(data)                   (0x00000800&((data)<<11))
#define SB2_GPIO4_PAD_FUNC_SEL_gpio34_pud_en(data)                    (0x00000400&((data)<<10))
#define SB2_GPIO4_PAD_FUNC_SEL_gpio34_pud_sel(data)                   (0x00000200&((data)<<9))
#define SB2_GPIO4_PAD_FUNC_SEL_ai_sd1_current(data)                   (0x00000100&((data)<<8))
#define SB2_GPIO4_PAD_FUNC_SEL_ai_sd1_pud_en(data)                    (0x00000080&((data)<<7))
#define SB2_GPIO4_PAD_FUNC_SEL_ai_sd1_pud_sel(data)                   (0x00000040&((data)<<6))
#define SB2_GPIO4_PAD_FUNC_SEL_spdif_in_current(data)                 (0x00000020&((data)<<5))
#define SB2_GPIO4_PAD_FUNC_SEL_spdif_in_pud_en(data)                  (0x00000010&((data)<<4))
#define SB2_GPIO4_PAD_FUNC_SEL_spdif_in_pud_sel(data)                 (0x00000008&((data)<<3))
#define SB2_GPIO4_PAD_FUNC_SEL_gpio33_current(data)                   (0x00000004&((data)<<2))
#define SB2_GPIO4_PAD_FUNC_SEL_gpio33_pud_en(data)                    (0x00000002&((data)<<1))
#define SB2_GPIO4_PAD_FUNC_SEL_gpio33_pud_sel(data)                   (0x00000001&(data))
#define SB2_GPIO4_PAD_FUNC_SEL_get_ddr_in_pwr_down_en(data)           ((0x80000000&(data))>>31)
#define SB2_GPIO4_PAD_FUNC_SEL_get_ddr_out_tri_state_en(data)         ((0x40000000&(data))>>30)
#define SB2_GPIO4_PAD_FUNC_SEL_get_gpio35_current(data)               ((0x00004000&(data))>>14)
#define SB2_GPIO4_PAD_FUNC_SEL_get_gpio35_pud_en(data)                ((0x00002000&(data))>>13)
#define SB2_GPIO4_PAD_FUNC_SEL_get_gpio35_pud_sel(data)               ((0x00001000&(data))>>12)
#define SB2_GPIO4_PAD_FUNC_SEL_get_gpio34_current(data)               ((0x00000800&(data))>>11)
#define SB2_GPIO4_PAD_FUNC_SEL_get_gpio34_pud_en(data)                ((0x00000400&(data))>>10)
#define SB2_GPIO4_PAD_FUNC_SEL_get_gpio34_pud_sel(data)               ((0x00000200&(data))>>9)
#define SB2_GPIO4_PAD_FUNC_SEL_get_ai_sd1_current(data)               ((0x00000100&(data))>>8)
#define SB2_GPIO4_PAD_FUNC_SEL_get_ai_sd1_pud_en(data)                ((0x00000080&(data))>>7)
#define SB2_GPIO4_PAD_FUNC_SEL_get_ai_sd1_pud_sel(data)               ((0x00000040&(data))>>6)
#define SB2_GPIO4_PAD_FUNC_SEL_get_spdif_in_current(data)             ((0x00000020&(data))>>5)
#define SB2_GPIO4_PAD_FUNC_SEL_get_spdif_in_pud_en(data)              ((0x00000010&(data))>>4)
#define SB2_GPIO4_PAD_FUNC_SEL_get_spdif_in_pud_sel(data)             ((0x00000008&(data))>>3)
#define SB2_GPIO4_PAD_FUNC_SEL_get_gpio33_current(data)               ((0x00000004&(data))>>2)
#define SB2_GPIO4_PAD_FUNC_SEL_get_gpio33_pud_en(data)                ((0x00000002&(data))>>1)
#define SB2_GPIO4_PAD_FUNC_SEL_get_gpio33_pud_sel(data)               (0x00000001&(data))

#define SB2_CHIP_ID                                                   0x1801A200
#define SB2_CHIP_ID_reg_addr                                          "0xB801A200"
#define SB2_CHIP_ID_reg                                               0xB801A200
#define SB2_CHIP_ID_inst_addr                                         "0x0080"
#define SB2_CHIP_ID_inst                                              0x0080
#define SB2_CHIP_ID_chip_id_shift                                     (0)
#define SB2_CHIP_ID_chip_id_mask                                      (0x0000FFFF)
#define SB2_CHIP_ID_chip_id(data)                                     (0x0000FFFF&(data))
#define SB2_CHIP_ID_get_chip_id(data)                                 (0x0000FFFF&(data))

#define SB2_CHIP_INFO                                                 0x1801A204
#define SB2_CHIP_INFO_reg_addr                                        "0xB801A204"
#define SB2_CHIP_INFO_reg                                             0xB801A204
#define SB2_CHIP_INFO_inst_addr                                       "0x0081"
#define SB2_CHIP_INFO_inst                                            0x0081
#define SB2_CHIP_INFO_revise_id_shift                                 (16)
#define SB2_CHIP_INFO_pow_latch_shift                                 (8)
#define SB2_CHIP_INFO_bound_opt_shift                                 (0)
#define SB2_CHIP_INFO_revise_id_mask                                  (0xFFFF0000)
#define SB2_CHIP_INFO_pow_latch_mask                                  (0x0000FF00)
#define SB2_CHIP_INFO_bound_opt_mask                                  (0x000000FF)
#define SB2_CHIP_INFO_revise_id(data)                                 (0xFFFF0000&((data)<<16))
#define SB2_CHIP_INFO_pow_latch(data)                                 (0x0000FF00&((data)<<8))
#define SB2_CHIP_INFO_bound_opt(data)                                 (0x000000FF&(data))
#define SB2_CHIP_INFO_get_revise_id(data)                             ((0xFFFF0000&(data))>>16)
#define SB2_CHIP_INFO_get_pow_latch(data)                             ((0x0000FF00&(data))>>8)
#define SB2_CHIP_INFO_get_bound_opt(data)                             (0x000000FF&(data))

#define SB2_SFC_OPCODE                                                0x1801A800
#define SB2_SFC_OPCODE_reg_addr                                       "0xB801A800"
#define SB2_SFC_OPCODE_reg                                            0xB801A800
#define SB2_SFC_OPCODE_inst_addr                                      "0x0200"
#define SB2_SFC_OPCODE_inst                                           0x0200
#define SB2_SFC_OPCODE_sf_sel_shift                                   (31)
#define SB2_SFC_OPCODE_opc_shift                                      (0)
#define SB2_SFC_OPCODE_sf_sel_mask                                    (0x80000000)
#define SB2_SFC_OPCODE_opc_mask                                       (0x000000FF)
#define SB2_SFC_OPCODE_sf_sel(data)                                   (0x80000000&((data)<<31))
#define SB2_SFC_OPCODE_opc(data)                                      (0x000000FF&(data))
#define SB2_SFC_OPCODE_get_sf_sel(data)                               ((0x80000000&(data))>>31)
#define SB2_SFC_OPCODE_get_opc(data)                                  (0x000000FF&(data))

#define SB2_SFC_CTL                                                   0x1801A804
#define SB2_SFC_CTL_reg_addr                                          "0xB801A804"
#define SB2_SFC_CTL_reg                                               0xB801A804
#define SB2_SFC_CTL_inst_addr                                         "0x0201"
#define SB2_SFC_CTL_inst                                              0x0201
#define SB2_SFC_CTL_dataen_shift                                      (4)
#define SB2_SFC_CTL_adren_shift                                       (3)
#define SB2_SFC_CTL_dmycnt_shift                                      (0)
#define SB2_SFC_CTL_dataen_mask                                       (0x00000010)
#define SB2_SFC_CTL_adren_mask                                        (0x00000008)
#define SB2_SFC_CTL_dmycnt_mask                                       (0x00000007)
#define SB2_SFC_CTL_dataen(data)                                      (0x00000010&((data)<<4))
#define SB2_SFC_CTL_adren(data)                                       (0x00000008&((data)<<3))
#define SB2_SFC_CTL_dmycnt(data)                                      (0x00000007&(data))
#define SB2_SFC_CTL_get_dataen(data)                                  ((0x00000010&(data))>>4)
#define SB2_SFC_CTL_get_adren(data)                                   ((0x00000008&(data))>>3)
#define SB2_SFC_CTL_get_dmycnt(data)                                  (0x00000007&(data))

#define SB2_SFC_SCK                                                   0x1801A808
#define SB2_SFC_SCK_reg_addr                                          "0xB801A808"
#define SB2_SFC_SCK_reg                                               0xB801A808
#define SB2_SFC_SCK_inst_addr                                         "0x0202"
#define SB2_SFC_SCK_inst                                              0x0202
#define SB2_SFC_SCK_mode_shift                                        (8)
#define SB2_SFC_SCK_fdiv_shift                                        (0)
#define SB2_SFC_SCK_mode_mask                                         (0x00000100)
#define SB2_SFC_SCK_fdiv_mask                                         (0x000000FF)
#define SB2_SFC_SCK_mode(data)                                        (0x00000100&((data)<<8))
#define SB2_SFC_SCK_fdiv(data)                                        (0x000000FF&(data))
#define SB2_SFC_SCK_get_mode(data)                                    ((0x00000100&(data))>>8)
#define SB2_SFC_SCK_get_fdiv(data)                                    (0x000000FF&(data))

#define SB2_SFC_CE                                                    0x1801A80C
#define SB2_SFC_CE_reg_addr                                           "0xB801A80C"
#define SB2_SFC_CE_reg                                                0xB801A80C
#define SB2_SFC_CE_inst_addr                                          "0x0203"
#define SB2_SFC_CE_inst                                               0x0203
#define SB2_SFC_CE_tdt_shift                                          (16)
#define SB2_SFC_CE_phcnt_shift                                        (8)
#define SB2_SFC_CE_plcnt_shift                                        (0)
#define SB2_SFC_CE_tdt_mask                                           (0x00FF0000)
#define SB2_SFC_CE_phcnt_mask                                         (0x0000FF00)
#define SB2_SFC_CE_plcnt_mask                                         (0x000000FF)
#define SB2_SFC_CE_tdt(data)                                          (0x00FF0000&((data)<<16))
#define SB2_SFC_CE_phcnt(data)                                        (0x0000FF00&((data)<<8))
#define SB2_SFC_CE_plcnt(data)                                        (0x000000FF&(data))
#define SB2_SFC_CE_get_tdt(data)                                      ((0x00FF0000&(data))>>16)
#define SB2_SFC_CE_get_phcnt(data)                                    ((0x0000FF00&(data))>>8)
#define SB2_SFC_CE_get_plcnt(data)                                    (0x000000FF&(data))
#endif
