// This file is generated using the spec version 9.3, firmware template version 1.39and DVR_Parser_0.46
#ifndef _SYS_REG_H_INCLUDED_
#define _SYS_REG_H_INCLUDED_

//#define  _SYS_USE_STRUCT
#ifdef _SYS_USE_STRUCT

typedef struct
{
    unsigned int    reserved_0:13;
    unsigned int    rstn_ilk_phy:1;
    unsigned int    rstn_usb_phy:1;
    unsigned int    rstn_ilk:1;
    unsigned int    rstn_usb:1;
    unsigned int    rstn_etn:1;
    unsigned int    rstn_sb1:1;
    unsigned int    reserved_1:1;
    unsigned int    rstn_acpu:1;
    unsigned int    rstn_vcpu:1;
    unsigned int    rstn_dcu:1;
    unsigned int    rstn_tvd:1;
    unsigned int    rstn_tve:1;
    unsigned int    rstn_ve:1;
    unsigned int    rstn_me:1;
    unsigned int    rstn_aio:1;
    unsigned int    rstn_se:1;
    unsigned int    rstn_ide:1;
    unsigned int    rstn_misc:1;
    unsigned int    rstn_ae:1;
}sys_SOFT_RESET1;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    rstn_sb2:1;
}sys_SOFT_RESET2;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    clk_en_sb1:1;
    unsigned int    clk_en_acpu:1;
    unsigned int    clk_en_vcpu:1;
    unsigned int    clk_en_dcu:1;
    unsigned int    clk_en_tvd:1;
    unsigned int    clk_en_tve:1;
    unsigned int    clk_en_ve:1;
    unsigned int    clk_en_me:1;
    unsigned int    clk_en_aio:1;
    unsigned int    clk_en_se:1;
    unsigned int    clk_en_ide:1;
    unsigned int    clk_en_etn:1;
    unsigned int    clk_en_usb:1;
    unsigned int    clk_en_1394:1;
    unsigned int    clk_en_misc:1;
    unsigned int    clk_en_ae:1;
}sys_CLOCK_ENABLE;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    sclk_sel:1;
}sys_GROUP1_CLOCK;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    tveck_sel:1;
}sys_TVECK_SEL;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    clk_en_scpu:1;
    unsigned int    clk_en_sb2:1;
}sys_GROUP1_CKEN;

typedef struct
{
    unsigned int    reserved_0:29;
    unsigned int    dac_div:3;
}sys_DISP_PLL_D1;

typedef struct
{
    unsigned int    reserved_0:29;
    unsigned int    tve_div:3;
}sys_DISP_PLL_D2;

typedef struct
{
    unsigned int    bus_ssc_sse:1;
    unsigned int    reserved_0:1;
    unsigned int    bus_ssc_sss:6;
    unsigned int    reserved_1:1;
    unsigned int    bus_ssc_ssn:7;
    unsigned int    bus_ssc_ssfpv:8;
    unsigned int    reserved_2:6;
    unsigned int    bus_ssc_stms:2;
}sys_BUS_PLL_SSC;

typedef struct
{
    unsigned int    ddr_ssc_sse:1;
    unsigned int    reserved_0:1;
    unsigned int    ddr_ssc_sss:6;
    unsigned int    reserved_1:1;
    unsigned int    ddr_ssc_ssn:7;
    unsigned int    ddr_ssc_ssfpv:8;
    unsigned int    reserved_2:6;
    unsigned int    ddr_ssc_stms:2;
}sys_DDR_PLL_SSC;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    pllbus_fupdn:1;
    unsigned int    pllddr_fupdn:1;
}sys_PLL_SSC;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    aio_ps_en:1;
}sys_AUDIO_PLL_PS;

typedef struct
{
    unsigned int    reserved_0:13;
    unsigned int    scpu_bist_en:1;
    unsigned int    vcpu_bist_en:1;
    unsigned int    acpu_bist1_en:1;
    unsigned int    acpu_bist2_en:1;
    unsigned int    dc_bist_en:1;
    unsigned int    se_bist_en:1;
    unsigned int    etn_aio_bist_en:1;
    unsigned int    vo_bist1_en:1;
    unsigned int    vo_bist2_en:1;
    unsigned int    vi_bist_en:1;
    unsigned int    tvd_bist_en:1;
    unsigned int    ilk_usb_bist_en:1;
    unsigned int    ide_bist_en:1;
    unsigned int    ve_bist1_en:1;
    unsigned int    ve_bist2_en:1;
    unsigned int    ve_bist3_en:1;
    unsigned int    me_bist1_en:1;
    unsigned int    me_bist2_en:1;
    unsigned int    write_data:1;
}sys_BIST_EN;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    dc_bist_fail2:1;
    unsigned int    dc_bist_fail1:1;
    unsigned int    dc_bist_fail0:1;
    unsigned int    dc_bist_fail_tgl:1;
    unsigned int    dc_bist_done:1;
}sys_DC_BIST_ST;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    se_bist_fail2:1;
    unsigned int    se_bist_fail1:1;
    unsigned int    se_bist_fail0:1;
    unsigned int    se_bist_fail_tgl:1;
    unsigned int    se_bist_done:1;
}sys_SE_BIST_ST;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    etn_aio_bist_fail3:1;
    unsigned int    etn_aio_bist_fail2:1;
    unsigned int    etn_aio_bist_fail1:1;
    unsigned int    etn_aio_bist_fail0:1;
    unsigned int    etn_aio_bist_fail_tgl:1;
    unsigned int    etn_aio_bist_done:1;
}sys_ETN_AIO_BIST_ST;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    vo_bist1_fail6:1;
    unsigned int    vo_bist1_fail5:1;
    unsigned int    vo_bist1_fail4:1;
    unsigned int    vo_bist1_fail3:1;
    unsigned int    vo_bist1_fail2:1;
    unsigned int    vo_bist1_fail1:1;
    unsigned int    vo_bist1_fail0:1;
    unsigned int    vo_bist1_fail_tgl:1;
    unsigned int    vo_bist1_done:1;
}sys_VO_BIST1_ST;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    vo_bist2_fail6:1;
    unsigned int    vo_bist2_fail5:1;
    unsigned int    vo_bist2_fail4:1;
    unsigned int    vo_bist2_fail3:1;
    unsigned int    vo_bist2_fail2:1;
    unsigned int    vo_bist2_fail1:1;
    unsigned int    vo_bist2_fail0:1;
    unsigned int    vo_bist2_fail_tgl:1;
    unsigned int    vo_bist2_done:1;
}sys_VO_BIST2_ST;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    vi_bist_fail4:1;
    unsigned int    vi_bist_fail3:1;
    unsigned int    vi_bist_fail2:1;
    unsigned int    vi_bist_fail1:1;
    unsigned int    vi_bist_fail0:1;
    unsigned int    vi_bist_fail_tgl:1;
    unsigned int    vi_bist_done:1;
}sys_VI_BIST_ST;

typedef struct
{
    unsigned int    reserved_0:22;
    unsigned int    tvd_bist_fail7:1;
    unsigned int    tvd_bist_fail6:1;
    unsigned int    tvd_bist_fail5:1;
    unsigned int    tvd_bist_fail4:1;
    unsigned int    tvd_bist_fail3:1;
    unsigned int    tvd_bist_fail2:1;
    unsigned int    tvd_bist_fail1:1;
    unsigned int    tvd_bist_fail0:1;
    unsigned int    tvd_bist_fail_tgl:1;
    unsigned int    tvd_bist_done:1;
}sys_TVD_BIST_ST;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    ilk_usb_bist_fail6:1;
    unsigned int    ilk_usb_bist_fail5:1;
    unsigned int    ilk_usb_bist_fail4:1;
    unsigned int    ilk_usb_bist_fail3:1;
    unsigned int    ilk_usb_bist_fail2:1;
    unsigned int    ilk_usb_bist_fail1:1;
    unsigned int    ilk_usb_bist_fail0:1;
    unsigned int    ilk_usb_bist_fail_tgl:1;
    unsigned int    ilk_usb_bist_done:1;
}sys_ILK_USB_BIST_ST;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    ide_bist_fail5:1;
    unsigned int    ide_bist_fail4:1;
    unsigned int    ide_bist_fail3:1;
    unsigned int    ide_bist_fail2:1;
    unsigned int    ide_bist_fail1:1;
    unsigned int    ide_bist_fail0:1;
    unsigned int    ide_bist_fail_tgl:1;
    unsigned int    ide_bist_done:1;
}sys_IDE_BIST_ST;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    ve_bist1_fail3:1;
    unsigned int    ve_bist1_fail2:1;
    unsigned int    ve_bist1_fail1:1;
    unsigned int    ve_bist1_fail0:1;
    unsigned int    ve_bist1_fail_tgl:1;
    unsigned int    ve_bist1_done:1;
}sys_VE_BIST1_ST;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    ve_bist2_fail6:1;
    unsigned int    ve_bist2_fail5:1;
    unsigned int    ve_bist2_fail4:1;
    unsigned int    ve_bist2_fail3:1;
    unsigned int    ve_bist2_fail2:1;
    unsigned int    ve_bist2_fail1:1;
    unsigned int    ve_bist2_fail0:1;
    unsigned int    ve_bist2_fail_tgl:1;
    unsigned int    ve_bist2_done:1;
}sys_VE_BIST2_ST;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    ve_bist3_fail3:1;
    unsigned int    ve_bist3_fail2:1;
    unsigned int    ve_bist3_fail1:1;
    unsigned int    ve_bist3_fail0:1;
    unsigned int    ve_bist3_fail_tgl:1;
    unsigned int    ve_bist3_done:1;
}sys_VE_BIST3_ST;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    me_bist1_fail5:1;
    unsigned int    me_bist1_fail4:1;
    unsigned int    me_bist1_fail3:1;
    unsigned int    me_bist1_fail2:1;
    unsigned int    me_bist1_fail1:1;
    unsigned int    me_bist1_fail0:1;
    unsigned int    me_bist1_fail_tgl:1;
    unsigned int    me_bist1_done:1;
}sys_ME_BIST1_ST;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    me_bist2_fail5:1;
    unsigned int    me_bist2_fail4:1;
    unsigned int    me_bist2_fail3:1;
    unsigned int    me_bist2_fail2:1;
    unsigned int    me_bist2_fail1:1;
    unsigned int    me_bist2_fail0:1;
    unsigned int    me_bist2_fail_tgl:1;
    unsigned int    me_bist2_done:1;
}sys_ME_BIST2_ST;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    adsp_bist1_fail6:1;
    unsigned int    adsp_bist1_fail5:1;
    unsigned int    adsp_bist1_fail4:1;
    unsigned int    adsp_bist1_fail3:1;
    unsigned int    adsp_bist1_fail2:1;
    unsigned int    adsp_bist1_fail1:1;
    unsigned int    adsp_bist1_fail0:1;
    unsigned int    adsp_bist1_fail_tgl:1;
    unsigned int    adsp_bist1_done:1;
}sys_ACPU_BIST1_ST;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    adsp_bist2_fail3:1;
    unsigned int    adsp_bist2_fail2:1;
    unsigned int    adsp_bist2_fail1:1;
    unsigned int    adsp_bist2_fail0:1;
    unsigned int    adsp_bist2_fail_tgl:1;
    unsigned int    adsp_bist2_done:1;
}sys_ACPU_BIST2_ST;

typedef struct
{
    unsigned int    reserved_0:22;
    unsigned int    vcpu_bist_fail7:1;
    unsigned int    vcpu_bist_fail6:1;
    unsigned int    vcpu_bist_fail5:1;
    unsigned int    vcpu_bist_fail4:1;
    unsigned int    vcpu_bist_fail3:1;
    unsigned int    vcpu_bist_fail2:1;
    unsigned int    vcpu_bist_fail1:1;
    unsigned int    vcpu_bist_fail0:1;
    unsigned int    vcpu_bist_fail_tgl:1;
    unsigned int    vcpu_bist_done:1;
}sys_VCPU_BIST_ST;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    scpu_bist_fail5:1;
    unsigned int    scpu_bist_fail4:1;
    unsigned int    scpu_bist_fail3:1;
    unsigned int    scpu_bist_fail2:1;
    unsigned int    scpu_bist_fail1:1;
    unsigned int    scpu_bist_fail0:1;
    unsigned int    scpu_bist_fail_tgl:1;
    unsigned int    scpu_bist_done:1;
}sys_SCPU_BIST_ST;

typedef struct
{
    unsigned int    reserved_0:2;
    unsigned int    plletn_bpn:1;
    unsigned int    plletn_n:4;
    unsigned int    plletn_m:7;
    unsigned int    plletn_p:4;
    unsigned int    plletn_ip:3;
    unsigned int    plletn_rs:2;
    unsigned int    plletn_cs:2;
    unsigned int    plletn_r3:1;
    unsigned int    plletn_c3:1;
    unsigned int    plletn_wdvr:1;
    unsigned int    plletn_wdrst:1;
    unsigned int    plletn_wdset:1;
    unsigned int    reserved_1:1;
    unsigned int    plletn_tst:1;
}sys_PLL_ETN1;

typedef struct
{
    unsigned int    reserved_0:29;
    unsigned int    plletn_pwdn:1;
    unsigned int    plletn_oeb:1;
    unsigned int    plletn_rstb:1;
}sys_PLL_ETN2;

typedef struct
{
    unsigned int    reserved_0:3;
    unsigned int    plldisp_bpn:1;
    unsigned int    plldisp_n:4;
    unsigned int    plldisp_m:7;
    unsigned int    plldisp_ip:3;
    unsigned int    plldisp_rs:2;
    unsigned int    plldisp_cs:2;
    unsigned int    plldisp_r3:1;
    unsigned int    plldisp_c3:1;
    unsigned int    plldisp_wdvr:1;
    unsigned int    plldisp_wdrst:1;
    unsigned int    plldisp_wdset:1;
    unsigned int    reserved_1:1;
    unsigned int    plldisp_tst:1;
    unsigned int    reserved_2:3;
}sys_PLL_DISP1;

typedef struct
{
    unsigned int    reserved_0:29;
    unsigned int    plldisp_pwdn:1;
    unsigned int    plldisp_oeb:1;
    unsigned int    plldisp_rstb:1;
}sys_PLL_DISP2;

typedef struct
{
    unsigned int    reserved_0:3;
    unsigned int    pllcpu_bpn:1;
    unsigned int    pllcpu_n:4;
    unsigned int    pllcpu_m:7;
    unsigned int    pllcpu_ip:3;
    unsigned int    pllcpu_rs:2;
    unsigned int    pllcpu_cs:2;
    unsigned int    pllcpu_r3:1;
    unsigned int    pllcpu_c3:1;
    unsigned int    pllcpu_wdvr:1;
    unsigned int    pllcpu_wdrst:1;
    unsigned int    pllcpu_wdset:1;
    unsigned int    reserved_1:1;
    unsigned int    pllcpu_tst:1;
    unsigned int    reserved_2:3;
}sys_PLL_CPU1;

typedef struct
{
    unsigned int    pllbus_bpn:1;
    unsigned int    pllbus_n:4;
    unsigned int    pllbus_m:7;
    unsigned int    pllbus_ip:3;
    unsigned int    pllbus_rs:2;
    unsigned int    pllbus_cs:2;
    unsigned int    pllbus_cp:2;
    unsigned int    pllbus_r3:1;
    unsigned int    pllbus_c3:1;
    unsigned int    pllbus_wdvr:1;
    unsigned int    pllbus_wdrst:1;
    unsigned int    pllbus_wdset:1;
    unsigned int    pllbus_phrl:2;
    unsigned int    pllbus_phrs:3;
    unsigned int    pllbus_tst:1;
}sys_PLL_BUS1;

typedef struct
{
    unsigned int    reserved_0:28;
    unsigned int    pllbus_ckpstst:1;
    unsigned int    pllbus_pwdn:1;
    unsigned int    pllbus_oeb:1;
    unsigned int    pllbus_rstb:1;
}sys_PLL_BUS2;

typedef struct
{
    unsigned int    pllddr_bpn:1;
    unsigned int    pllddr_n:4;
    unsigned int    pllddr_m:7;
    unsigned int    pllddr_ip:3;
    unsigned int    pllddr_rs:2;
    unsigned int    pllddr_cs:2;
    unsigned int    pllddr_cp:2;
    unsigned int    pllddr_r3:1;
    unsigned int    pllddr_c3:1;
    unsigned int    pllddr_wdvr:1;
    unsigned int    pllddr_wdrst:1;
    unsigned int    pllddr_wdset:1;
    unsigned int    pllddr_phrl:2;
    unsigned int    pllddr_phrs:3;
    unsigned int    pllddr_tst:1;
}sys_PLL_DDR1;

typedef struct
{
    unsigned int    reserved_0:28;
    unsigned int    pllddr_ckpstst:1;
    unsigned int    pllddr_pwdn:1;
    unsigned int    pllddr_oeb:1;
    unsigned int    pllddr_rstb:1;
}sys_PLL_DDR2;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    audio441_oeb:1;
    unsigned int    audio441_rstb:1;
    unsigned int    audio48_oeb:1;
    unsigned int    pll1394_pwdn:1;
    unsigned int    pll1394_oeb:1;
    unsigned int    pll1394_rstb:1;
}sys_PLL_1394;

typedef struct
{
    unsigned int    reserved_0:9;
    unsigned int    bg_v12:1;
    unsigned int    bg_r:2;
    unsigned int    por_vset:2;
    unsigned int    plltst_sel:4;
    unsigned int    plltst_diven:1;
    unsigned int    plltst_div:2;
    unsigned int    pll_tpsel:3;
    unsigned int    pll_resv:8;
}sys_PLL_BG;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    pll1394_wdout:1;
    unsigned int    plletn_wdout:1;
    unsigned int    plldisp_wdout:1;
    unsigned int    pllcpu_wdout:1;
    unsigned int    pllbus_wdout:1;
    unsigned int    pllddr_wdout:1;
}sys_PLL_WDOUT;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    crt_dbg_en:1;
    unsigned int    crt_dbg_sel0:2;
    unsigned int    crt_dbg_sel1:2;
}sys_CRT_DEBUG;

typedef struct
{
    unsigned int    reserved_0:21;
    unsigned int    dbg_en:1;
    unsigned int    dbg_sel0:5;
    unsigned int    dbg_sel1:5;
}sys_DEBUG;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    adc_sel:2;
    unsigned int    dac_sel:3;
}sys_ADCDAC_SEL;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    pll1394_sip:3;
    unsigned int    pll1394_sr:3;
    unsigned int    pll1394_sc1:2;
    unsigned int    pll1394_sc2:2;
    unsigned int    pll1394_wdrst:1;
    unsigned int    pll1394_wdset:1;
    unsigned int    pll1394_fupdn:1;
    unsigned int    audio441_fupdn:1;
    unsigned int    audio441_ctrl:1;
    unsigned int    audio441_tst:1;
    unsigned int    audio48_tst:1;
}sys_PLL_1394_2;

typedef struct
{
    unsigned int    reserved_0:29;
    unsigned int    acpu_freq_sel:1;
    unsigned int    ddr_freq_sel:1;
    unsigned int    bus_freq_sel:1;
}sys_PLL_DIV;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    inv:1;
}sys_TVD_CLKINV;

typedef struct
{
    unsigned int    reserved_0:29;
    unsigned int    pllcpu_pwdn:1;
    unsigned int    pllcpu_oeb:1;
    unsigned int    pllcpu_rstb:1;
}sys_PLL_CPU2;
#endif

#define SYS_SOFT_RESET1                                               0x18000000
#define SYS_SOFT_RESET1_reg_addr                                      "0xB8000000"
#define SYS_SOFT_RESET1_reg                                           0xB8000000
#define SYS_SOFT_RESET1_inst_addr                                     "0x0000"
#define SYS_SOFT_RESET1_inst                                          0x0000
#define SYS_SOFT_RESET1_rstn_ilk_phy_shift                            (18)
#define SYS_SOFT_RESET1_rstn_usb_phy_shift                            (17)
#define SYS_SOFT_RESET1_rstn_ilk_shift                                (16)
#define SYS_SOFT_RESET1_rstn_usb_shift                                (15)
#define SYS_SOFT_RESET1_rstn_etn_shift                                (14)
#define SYS_SOFT_RESET1_rstn_sb1_shift                                (13)
#define SYS_SOFT_RESET1_rstn_acpu_shift                               (11)
#define SYS_SOFT_RESET1_rstn_vcpu_shift                               (10)
#define SYS_SOFT_RESET1_rstn_dcu_shift                                (9)
#define SYS_SOFT_RESET1_rstn_tvd_shift                                (8)
#define SYS_SOFT_RESET1_rstn_tve_shift                                (7)
#define SYS_SOFT_RESET1_rstn_ve_shift                                 (6)
#define SYS_SOFT_RESET1_rstn_me_shift                                 (5)
#define SYS_SOFT_RESET1_rstn_aio_shift                                (4)
#define SYS_SOFT_RESET1_rstn_se_shift                                 (3)
#define SYS_SOFT_RESET1_rstn_ide_shift                                (2)
#define SYS_SOFT_RESET1_rstn_misc_shift                               (1)
#define SYS_SOFT_RESET1_rstn_ae_shift                                 (0)
#define SYS_SOFT_RESET1_rstn_ilk_phy_mask                             (0x00040000)
#define SYS_SOFT_RESET1_rstn_usb_phy_mask                             (0x00020000)
#define SYS_SOFT_RESET1_rstn_ilk_mask                                 (0x00010000)
#define SYS_SOFT_RESET1_rstn_usb_mask                                 (0x00008000)
#define SYS_SOFT_RESET1_rstn_etn_mask                                 (0x00004000)
#define SYS_SOFT_RESET1_rstn_sb1_mask                                 (0x00002000)
#define SYS_SOFT_RESET1_rstn_acpu_mask                                (0x00000800)
#define SYS_SOFT_RESET1_rstn_vcpu_mask                                (0x00000400)
#define SYS_SOFT_RESET1_rstn_dcu_mask                                 (0x00000200)
#define SYS_SOFT_RESET1_rstn_tvd_mask                                 (0x00000100)
#define SYS_SOFT_RESET1_rstn_tve_mask                                 (0x00000080)
#define SYS_SOFT_RESET1_rstn_ve_mask                                  (0x00000040)
#define SYS_SOFT_RESET1_rstn_me_mask                                  (0x00000020)
#define SYS_SOFT_RESET1_rstn_aio_mask                                 (0x00000010)
#define SYS_SOFT_RESET1_rstn_se_mask                                  (0x00000008)
#define SYS_SOFT_RESET1_rstn_ide_mask                                 (0x00000004)
#define SYS_SOFT_RESET1_rstn_misc_mask                                (0x00000002)
#define SYS_SOFT_RESET1_rstn_ae_mask                                  (0x00000001)
#define SYS_SOFT_RESET1_rstn_ilk_phy(data)                            (0x00040000&((data)<<18))
#define SYS_SOFT_RESET1_rstn_usb_phy(data)                            (0x00020000&((data)<<17))
#define SYS_SOFT_RESET1_rstn_ilk(data)                                (0x00010000&((data)<<16))
#define SYS_SOFT_RESET1_rstn_usb(data)                                (0x00008000&((data)<<15))
#define SYS_SOFT_RESET1_rstn_etn(data)                                (0x00004000&((data)<<14))
#define SYS_SOFT_RESET1_rstn_sb1(data)                                (0x00002000&((data)<<13))
#define SYS_SOFT_RESET1_rstn_acpu(data)                               (0x00000800&((data)<<11))
#define SYS_SOFT_RESET1_rstn_vcpu(data)                               (0x00000400&((data)<<10))
#define SYS_SOFT_RESET1_rstn_dcu(data)                                (0x00000200&((data)<<9))
#define SYS_SOFT_RESET1_rstn_tvd(data)                                (0x00000100&((data)<<8))
#define SYS_SOFT_RESET1_rstn_tve(data)                                (0x00000080&((data)<<7))
#define SYS_SOFT_RESET1_rstn_ve(data)                                 (0x00000040&((data)<<6))
#define SYS_SOFT_RESET1_rstn_me(data)                                 (0x00000020&((data)<<5))
#define SYS_SOFT_RESET1_rstn_aio(data)                                (0x00000010&((data)<<4))
#define SYS_SOFT_RESET1_rstn_se(data)                                 (0x00000008&((data)<<3))
#define SYS_SOFT_RESET1_rstn_ide(data)                                (0x00000004&((data)<<2))
#define SYS_SOFT_RESET1_rstn_misc(data)                               (0x00000002&((data)<<1))
#define SYS_SOFT_RESET1_rstn_ae(data)                                 (0x00000001&(data))
#define SYS_SOFT_RESET1_get_rstn_ilk_phy(data)                        ((0x00040000&(data))>>18)
#define SYS_SOFT_RESET1_get_rstn_usb_phy(data)                        ((0x00020000&(data))>>17)
#define SYS_SOFT_RESET1_get_rstn_ilk(data)                            ((0x00010000&(data))>>16)
#define SYS_SOFT_RESET1_get_rstn_usb(data)                            ((0x00008000&(data))>>15)
#define SYS_SOFT_RESET1_get_rstn_etn(data)                            ((0x00004000&(data))>>14)
#define SYS_SOFT_RESET1_get_rstn_sb1(data)                            ((0x00002000&(data))>>13)
#define SYS_SOFT_RESET1_get_rstn_acpu(data)                           ((0x00000800&(data))>>11)
#define SYS_SOFT_RESET1_get_rstn_vcpu(data)                           ((0x00000400&(data))>>10)
#define SYS_SOFT_RESET1_get_rstn_dcu(data)                            ((0x00000200&(data))>>9)
#define SYS_SOFT_RESET1_get_rstn_tvd(data)                            ((0x00000100&(data))>>8)
#define SYS_SOFT_RESET1_get_rstn_tve(data)                            ((0x00000080&(data))>>7)
#define SYS_SOFT_RESET1_get_rstn_ve(data)                             ((0x00000040&(data))>>6)
#define SYS_SOFT_RESET1_get_rstn_me(data)                             ((0x00000020&(data))>>5)
#define SYS_SOFT_RESET1_get_rstn_aio(data)                            ((0x00000010&(data))>>4)
#define SYS_SOFT_RESET1_get_rstn_se(data)                             ((0x00000008&(data))>>3)
#define SYS_SOFT_RESET1_get_rstn_ide(data)                            ((0x00000004&(data))>>2)
#define SYS_SOFT_RESET1_get_rstn_misc(data)                           ((0x00000002&(data))>>1)
#define SYS_SOFT_RESET1_get_rstn_ae(data)                             (0x00000001&(data))

#define SYS_SOFT_RESET2                                               0x180000C4
#define SYS_SOFT_RESET2_reg_addr                                      "0xB80000C4"
#define SYS_SOFT_RESET2_reg                                           0xB80000C4
#define SYS_SOFT_RESET2_inst_addr                                     "0x0031"
#define SYS_SOFT_RESET2_inst                                          0x0031
#define SYS_SOFT_RESET2_rstn_sb2_shift                                (0)
#define SYS_SOFT_RESET2_rstn_sb2_mask                                 (0x00000001)
#define SYS_SOFT_RESET2_rstn_sb2(data)                                (0x00000001&(data))
#define SYS_SOFT_RESET2_get_rstn_sb2(data)                            (0x00000001&(data))

#define SYS_CLOCK_ENABLE                                              0x18000004
#define SYS_CLOCK_ENABLE_reg_addr                                     "0xB8000004"
#define SYS_CLOCK_ENABLE_reg                                          0xB8000004
#define SYS_CLOCK_ENABLE_inst_addr                                    "0x0001"
#define SYS_CLOCK_ENABLE_inst                                         0x0001
#define SYS_CLOCK_ENABLE_clk_en_sb1_shift                             (15)
#define SYS_CLOCK_ENABLE_clk_en_acpu_shift                            (14)
#define SYS_CLOCK_ENABLE_clk_en_vcpu_shift                            (13)
#define SYS_CLOCK_ENABLE_clk_en_dcu_shift                             (12)
#define SYS_CLOCK_ENABLE_clk_en_tvd_shift                             (11)
#define SYS_CLOCK_ENABLE_clk_en_tve_shift                             (10)
#define SYS_CLOCK_ENABLE_clk_en_ve_shift                              (9)
#define SYS_CLOCK_ENABLE_clk_en_me_shift                              (8)
#define SYS_CLOCK_ENABLE_clk_en_aio_shift                             (7)
#define SYS_CLOCK_ENABLE_clk_en_se_shift                              (6)
#define SYS_CLOCK_ENABLE_clk_en_ide_shift                             (5)
#define SYS_CLOCK_ENABLE_clk_en_etn_shift                             (4)
#define SYS_CLOCK_ENABLE_clk_en_usb_shift                             (3)
#define SYS_CLOCK_ENABLE_clk_en_1394_shift                            (2)
#define SYS_CLOCK_ENABLE_clk_en_misc_shift                            (1)
#define SYS_CLOCK_ENABLE_clk_en_ae_shift                              (0)
#define SYS_CLOCK_ENABLE_clk_en_sb1_mask                              (0x00008000)
#define SYS_CLOCK_ENABLE_clk_en_acpu_mask                             (0x00004000)
#define SYS_CLOCK_ENABLE_clk_en_vcpu_mask                             (0x00002000)
#define SYS_CLOCK_ENABLE_clk_en_dcu_mask                              (0x00001000)
#define SYS_CLOCK_ENABLE_clk_en_tvd_mask                              (0x00000800)
#define SYS_CLOCK_ENABLE_clk_en_tve_mask                              (0x00000400)
#define SYS_CLOCK_ENABLE_clk_en_ve_mask                               (0x00000200)
#define SYS_CLOCK_ENABLE_clk_en_me_mask                               (0x00000100)
#define SYS_CLOCK_ENABLE_clk_en_aio_mask                              (0x00000080)
#define SYS_CLOCK_ENABLE_clk_en_se_mask                               (0x00000040)
#define SYS_CLOCK_ENABLE_clk_en_ide_mask                              (0x00000020)
#define SYS_CLOCK_ENABLE_clk_en_etn_mask                              (0x00000010)
#define SYS_CLOCK_ENABLE_clk_en_usb_mask                              (0x00000008)
#define SYS_CLOCK_ENABLE_clk_en_1394_mask                             (0x00000004)
#define SYS_CLOCK_ENABLE_clk_en_misc_mask                             (0x00000002)
#define SYS_CLOCK_ENABLE_clk_en_ae_mask                               (0x00000001)
#define SYS_CLOCK_ENABLE_clk_en_sb1(data)                             (0x00008000&((data)<<15))
#define SYS_CLOCK_ENABLE_clk_en_acpu(data)                            (0x00004000&((data)<<14))
#define SYS_CLOCK_ENABLE_clk_en_vcpu(data)                            (0x00002000&((data)<<13))
#define SYS_CLOCK_ENABLE_clk_en_dcu(data)                             (0x00001000&((data)<<12))
#define SYS_CLOCK_ENABLE_clk_en_tvd(data)                             (0x00000800&((data)<<11))
#define SYS_CLOCK_ENABLE_clk_en_tve(data)                             (0x00000400&((data)<<10))
#define SYS_CLOCK_ENABLE_clk_en_ve(data)                              (0x00000200&((data)<<9))
#define SYS_CLOCK_ENABLE_clk_en_me(data)                              (0x00000100&((data)<<8))
#define SYS_CLOCK_ENABLE_clk_en_aio(data)                             (0x00000080&((data)<<7))
#define SYS_CLOCK_ENABLE_clk_en_se(data)                              (0x00000040&((data)<<6))
#define SYS_CLOCK_ENABLE_clk_en_ide(data)                             (0x00000020&((data)<<5))
#define SYS_CLOCK_ENABLE_clk_en_etn(data)                             (0x00000010&((data)<<4))
#define SYS_CLOCK_ENABLE_clk_en_usb(data)                             (0x00000008&((data)<<3))
#define SYS_CLOCK_ENABLE_clk_en_1394(data)                            (0x00000004&((data)<<2))
#define SYS_CLOCK_ENABLE_clk_en_misc(data)                            (0x00000002&((data)<<1))
#define SYS_CLOCK_ENABLE_clk_en_ae(data)                              (0x00000001&(data))
#define SYS_CLOCK_ENABLE_get_clk_en_sb1(data)                         ((0x00008000&(data))>>15)
#define SYS_CLOCK_ENABLE_get_clk_en_acpu(data)                        ((0x00004000&(data))>>14)
#define SYS_CLOCK_ENABLE_get_clk_en_vcpu(data)                        ((0x00002000&(data))>>13)
#define SYS_CLOCK_ENABLE_get_clk_en_dcu(data)                         ((0x00001000&(data))>>12)
#define SYS_CLOCK_ENABLE_get_clk_en_tvd(data)                         ((0x00000800&(data))>>11)
#define SYS_CLOCK_ENABLE_get_clk_en_tve(data)                         ((0x00000400&(data))>>10)
#define SYS_CLOCK_ENABLE_get_clk_en_ve(data)                          ((0x00000200&(data))>>9)
#define SYS_CLOCK_ENABLE_get_clk_en_me(data)                          ((0x00000100&(data))>>8)
#define SYS_CLOCK_ENABLE_get_clk_en_aio(data)                         ((0x00000080&(data))>>7)
#define SYS_CLOCK_ENABLE_get_clk_en_se(data)                          ((0x00000040&(data))>>6)
#define SYS_CLOCK_ENABLE_get_clk_en_ide(data)                         ((0x00000020&(data))>>5)
#define SYS_CLOCK_ENABLE_get_clk_en_etn(data)                         ((0x00000010&(data))>>4)
#define SYS_CLOCK_ENABLE_get_clk_en_usb(data)                         ((0x00000008&(data))>>3)
#define SYS_CLOCK_ENABLE_get_clk_en_1394(data)                        ((0x00000004&(data))>>2)
#define SYS_CLOCK_ENABLE_get_clk_en_misc(data)                        ((0x00000002&(data))>>1)
#define SYS_CLOCK_ENABLE_get_clk_en_ae(data)                          (0x00000001&(data))

#define SYS_GROUP1_CLOCK                                              0x18000008
#define SYS_GROUP1_CLOCK_reg_addr                                     "0xB8000008"
#define SYS_GROUP1_CLOCK_reg                                          0xB8000008
#define SYS_GROUP1_CLOCK_inst_addr                                    "0x0002"
#define SYS_GROUP1_CLOCK_inst                                         0x0002
#define SYS_GROUP1_CLOCK_sclk_sel_shift                               (0)
#define SYS_GROUP1_CLOCK_sclk_sel_mask                                (0x00000001)
#define SYS_GROUP1_CLOCK_sclk_sel(data)                               (0x00000001&(data))
#define SYS_GROUP1_CLOCK_get_sclk_sel(data)                           (0x00000001&(data))

#define SYS_TVECK_SEL                                                 0x1800000C
#define SYS_TVECK_SEL_reg_addr                                        "0xB800000C"
#define SYS_TVECK_SEL_reg                                             0xB800000C
#define SYS_TVECK_SEL_inst_addr                                       "0x0003"
#define SYS_TVECK_SEL_inst                                            0x0003
#define SYS_TVECK_SEL_tveck_sel_shift                                 (0)
#define SYS_TVECK_SEL_tveck_sel_mask                                  (0x00000001)
#define SYS_TVECK_SEL_tveck_sel(data)                                 (0x00000001&(data))
#define SYS_TVECK_SEL_get_tveck_sel(data)                             (0x00000001&(data))

#define SYS_GROUP1_CKEN                                               0x18000010
#define SYS_GROUP1_CKEN_reg_addr                                      "0xB8000010"
#define SYS_GROUP1_CKEN_reg                                           0xB8000010
#define SYS_GROUP1_CKEN_inst_addr                                     "0x0004"
#define SYS_GROUP1_CKEN_inst                                          0x0004
#define SYS_GROUP1_CKEN_clk_en_scpu_shift                             (1)
#define SYS_GROUP1_CKEN_clk_en_sb2_shift                              (0)
#define SYS_GROUP1_CKEN_clk_en_scpu_mask                              (0x00000002)
#define SYS_GROUP1_CKEN_clk_en_sb2_mask                               (0x00000001)
#define SYS_GROUP1_CKEN_clk_en_scpu(data)                             (0x00000002&((data)<<1))
#define SYS_GROUP1_CKEN_clk_en_sb2(data)                              (0x00000001&(data))
#define SYS_GROUP1_CKEN_get_clk_en_scpu(data)                         ((0x00000002&(data))>>1)
#define SYS_GROUP1_CKEN_get_clk_en_sb2(data)                          (0x00000001&(data))

#define SYS_DISP_PLL_D1                                               0x18000014
#define SYS_DISP_PLL_D1_reg_addr                                      "0xB8000014"
#define SYS_DISP_PLL_D1_reg                                           0xB8000014
#define SYS_DISP_PLL_D1_inst_addr                                     "0x0005"
#define SYS_DISP_PLL_D1_inst                                          0x0005
#define SYS_DISP_PLL_D1_dac_div_shift                                 (0)
#define SYS_DISP_PLL_D1_dac_div_mask                                  (0x00000007)
#define SYS_DISP_PLL_D1_dac_div(data)                                 (0x00000007&(data))
#define SYS_DISP_PLL_D1_get_dac_div(data)                             (0x00000007&(data))

#define SYS_DISP_PLL_D2                                               0x18000018
#define SYS_DISP_PLL_D2_reg_addr                                      "0xB8000018"
#define SYS_DISP_PLL_D2_reg                                           0xB8000018
#define SYS_DISP_PLL_D2_inst_addr                                     "0x0006"
#define SYS_DISP_PLL_D2_inst                                          0x0006
#define SYS_DISP_PLL_D2_tve_div_shift                                 (0)
#define SYS_DISP_PLL_D2_tve_div_mask                                  (0x00000007)
#define SYS_DISP_PLL_D2_tve_div(data)                                 (0x00000007&(data))
#define SYS_DISP_PLL_D2_get_tve_div(data)                             (0x00000007&(data))

#define SYS_BUS_PLL_SSC                                               0x1800001C
#define SYS_BUS_PLL_SSC_reg_addr                                      "0xB800001C"
#define SYS_BUS_PLL_SSC_reg                                           0xB800001C
#define SYS_BUS_PLL_SSC_inst_addr                                     "0x0007"
#define SYS_BUS_PLL_SSC_inst                                          0x0007
#define SYS_BUS_PLL_SSC_bus_ssc_sse_shift                             (31)
#define SYS_BUS_PLL_SSC_bus_ssc_sss_shift                             (24)
#define SYS_BUS_PLL_SSC_bus_ssc_ssn_shift                             (16)
#define SYS_BUS_PLL_SSC_bus_ssc_ssfpv_shift                           (8)
#define SYS_BUS_PLL_SSC_bus_ssc_stms_shift                            (0)
#define SYS_BUS_PLL_SSC_bus_ssc_sse_mask                              (0x80000000)
#define SYS_BUS_PLL_SSC_bus_ssc_sss_mask                              (0x3F000000)
#define SYS_BUS_PLL_SSC_bus_ssc_ssn_mask                              (0x007F0000)
#define SYS_BUS_PLL_SSC_bus_ssc_ssfpv_mask                            (0x0000FF00)
#define SYS_BUS_PLL_SSC_bus_ssc_stms_mask                             (0x00000003)
#define SYS_BUS_PLL_SSC_bus_ssc_sse(data)                             (0x80000000&((data)<<31))
#define SYS_BUS_PLL_SSC_bus_ssc_sss(data)                             (0x3F000000&((data)<<24))
#define SYS_BUS_PLL_SSC_bus_ssc_ssn(data)                             (0x007F0000&((data)<<16))
#define SYS_BUS_PLL_SSC_bus_ssc_ssfpv(data)                           (0x0000FF00&((data)<<8))
#define SYS_BUS_PLL_SSC_bus_ssc_stms(data)                            (0x00000003&(data))
#define SYS_BUS_PLL_SSC_get_bus_ssc_sse(data)                         ((0x80000000&(data))>>31)
#define SYS_BUS_PLL_SSC_get_bus_ssc_sss(data)                         ((0x3F000000&(data))>>24)
#define SYS_BUS_PLL_SSC_get_bus_ssc_ssn(data)                         ((0x007F0000&(data))>>16)
#define SYS_BUS_PLL_SSC_get_bus_ssc_ssfpv(data)                       ((0x0000FF00&(data))>>8)
#define SYS_BUS_PLL_SSC_get_bus_ssc_stms(data)                        (0x00000003&(data))

#define SYS_DDR_PLL_SSC                                               0x18000020
#define SYS_DDR_PLL_SSC_reg_addr                                      "0xB8000020"
#define SYS_DDR_PLL_SSC_reg                                           0xB8000020
#define SYS_DDR_PLL_SSC_inst_addr                                     "0x0008"
#define SYS_DDR_PLL_SSC_inst                                          0x0008
#define SYS_DDR_PLL_SSC_ddr_ssc_sse_shift                             (31)
#define SYS_DDR_PLL_SSC_ddr_ssc_sss_shift                             (24)
#define SYS_DDR_PLL_SSC_ddr_ssc_ssn_shift                             (16)
#define SYS_DDR_PLL_SSC_ddr_ssc_ssfpv_shift                           (8)
#define SYS_DDR_PLL_SSC_ddr_ssc_stms_shift                            (0)
#define SYS_DDR_PLL_SSC_ddr_ssc_sse_mask                              (0x80000000)
#define SYS_DDR_PLL_SSC_ddr_ssc_sss_mask                              (0x3F000000)
#define SYS_DDR_PLL_SSC_ddr_ssc_ssn_mask                              (0x007F0000)
#define SYS_DDR_PLL_SSC_ddr_ssc_ssfpv_mask                            (0x0000FF00)
#define SYS_DDR_PLL_SSC_ddr_ssc_stms_mask                             (0x00000003)
#define SYS_DDR_PLL_SSC_ddr_ssc_sse(data)                             (0x80000000&((data)<<31))
#define SYS_DDR_PLL_SSC_ddr_ssc_sss(data)                             (0x3F000000&((data)<<24))
#define SYS_DDR_PLL_SSC_ddr_ssc_ssn(data)                             (0x007F0000&((data)<<16))
#define SYS_DDR_PLL_SSC_ddr_ssc_ssfpv(data)                           (0x0000FF00&((data)<<8))
#define SYS_DDR_PLL_SSC_ddr_ssc_stms(data)                            (0x00000003&(data))
#define SYS_DDR_PLL_SSC_get_ddr_ssc_sse(data)                         ((0x80000000&(data))>>31)
#define SYS_DDR_PLL_SSC_get_ddr_ssc_sss(data)                         ((0x3F000000&(data))>>24)
#define SYS_DDR_PLL_SSC_get_ddr_ssc_ssn(data)                         ((0x007F0000&(data))>>16)
#define SYS_DDR_PLL_SSC_get_ddr_ssc_ssfpv(data)                       ((0x0000FF00&(data))>>8)
#define SYS_DDR_PLL_SSC_get_ddr_ssc_stms(data)                        (0x00000003&(data))

#define SYS_PLL_SSC                                                   0x18000024
#define SYS_PLL_SSC_reg_addr                                          "0xB8000024"
#define SYS_PLL_SSC_reg                                               0xB8000024
#define SYS_PLL_SSC_inst_addr                                         "0x0009"
#define SYS_PLL_SSC_inst                                              0x0009
#define SYS_PLL_SSC_pllbus_fupdn_shift                                (1)
#define SYS_PLL_SSC_pllddr_fupdn_shift                                (0)
#define SYS_PLL_SSC_pllbus_fupdn_mask                                 (0x00000002)
#define SYS_PLL_SSC_pllddr_fupdn_mask                                 (0x00000001)
#define SYS_PLL_SSC_pllbus_fupdn(data)                                (0x00000002&((data)<<1))
#define SYS_PLL_SSC_pllddr_fupdn(data)                                (0x00000001&(data))
#define SYS_PLL_SSC_get_pllbus_fupdn(data)                            ((0x00000002&(data))>>1)
#define SYS_PLL_SSC_get_pllddr_fupdn(data)                            (0x00000001&(data))

#define SYS_AUDIO_PLL_PS                                              0x18000028
#define SYS_AUDIO_PLL_PS_reg_addr                                     "0xB8000028"
#define SYS_AUDIO_PLL_PS_reg                                          0xB8000028
#define SYS_AUDIO_PLL_PS_inst_addr                                    "0x000A"
#define SYS_AUDIO_PLL_PS_inst                                         0x000A
#define SYS_AUDIO_PLL_PS_aio_ps_en_shift                              (0)
#define SYS_AUDIO_PLL_PS_aio_ps_en_mask                               (0x00000001)
#define SYS_AUDIO_PLL_PS_aio_ps_en(data)                              (0x00000001&(data))
#define SYS_AUDIO_PLL_PS_get_aio_ps_en(data)                          (0x00000001&(data))

#define SYS_BIST_EN                                                   0x18000030
#define SYS_BIST_EN_reg_addr                                          "0xB8000030"
#define SYS_BIST_EN_reg                                               0xB8000030
#define SYS_BIST_EN_inst_addr                                         "0x000C"
#define SYS_BIST_EN_inst                                              0x000C
#define SYS_BIST_EN_scpu_bist_en_shift                                (18)
#define SYS_BIST_EN_vcpu_bist_en_shift                                (17)
#define SYS_BIST_EN_acpu_bist1_en_shift                               (16)
#define SYS_BIST_EN_acpu_bist2_en_shift                               (15)
#define SYS_BIST_EN_dc_bist_en_shift                                  (14)
#define SYS_BIST_EN_se_bist_en_shift                                  (13)
#define SYS_BIST_EN_etn_aio_bist_en_shift                             (12)
#define SYS_BIST_EN_vo_bist1_en_shift                                 (11)
#define SYS_BIST_EN_vo_bist2_en_shift                                 (10)
#define SYS_BIST_EN_vi_bist_en_shift                                  (9)
#define SYS_BIST_EN_tvd_bist_en_shift                                 (8)
#define SYS_BIST_EN_ilk_usb_bist_en_shift                             (7)
#define SYS_BIST_EN_ide_bist_en_shift                                 (6)
#define SYS_BIST_EN_ve_bist1_en_shift                                 (5)
#define SYS_BIST_EN_ve_bist2_en_shift                                 (4)
#define SYS_BIST_EN_ve_bist3_en_shift                                 (3)
#define SYS_BIST_EN_me_bist1_en_shift                                 (2)
#define SYS_BIST_EN_me_bist2_en_shift                                 (1)
#define SYS_BIST_EN_write_data_shift                                  (0)
#define SYS_BIST_EN_scpu_bist_en_mask                                 (0x00040000)
#define SYS_BIST_EN_vcpu_bist_en_mask                                 (0x00020000)
#define SYS_BIST_EN_acpu_bist1_en_mask                                (0x00010000)
#define SYS_BIST_EN_acpu_bist2_en_mask                                (0x00008000)
#define SYS_BIST_EN_dc_bist_en_mask                                   (0x00004000)
#define SYS_BIST_EN_se_bist_en_mask                                   (0x00002000)
#define SYS_BIST_EN_etn_aio_bist_en_mask                              (0x00001000)
#define SYS_BIST_EN_vo_bist1_en_mask                                  (0x00000800)
#define SYS_BIST_EN_vo_bist2_en_mask                                  (0x00000400)
#define SYS_BIST_EN_vi_bist_en_mask                                   (0x00000200)
#define SYS_BIST_EN_tvd_bist_en_mask                                  (0x00000100)
#define SYS_BIST_EN_ilk_usb_bist_en_mask                              (0x00000080)
#define SYS_BIST_EN_ide_bist_en_mask                                  (0x00000040)
#define SYS_BIST_EN_ve_bist1_en_mask                                  (0x00000020)
#define SYS_BIST_EN_ve_bist2_en_mask                                  (0x00000010)
#define SYS_BIST_EN_ve_bist3_en_mask                                  (0x00000008)
#define SYS_BIST_EN_me_bist1_en_mask                                  (0x00000004)
#define SYS_BIST_EN_me_bist2_en_mask                                  (0x00000002)
#define SYS_BIST_EN_write_data_mask                                   (0x00000001)
#define SYS_BIST_EN_scpu_bist_en(data)                                (0x00040000&((data)<<18))
#define SYS_BIST_EN_vcpu_bist_en(data)                                (0x00020000&((data)<<17))
#define SYS_BIST_EN_acpu_bist1_en(data)                               (0x00010000&((data)<<16))
#define SYS_BIST_EN_acpu_bist2_en(data)                               (0x00008000&((data)<<15))
#define SYS_BIST_EN_dc_bist_en(data)                                  (0x00004000&((data)<<14))
#define SYS_BIST_EN_se_bist_en(data)                                  (0x00002000&((data)<<13))
#define SYS_BIST_EN_etn_aio_bist_en(data)                             (0x00001000&((data)<<12))
#define SYS_BIST_EN_vo_bist1_en(data)                                 (0x00000800&((data)<<11))
#define SYS_BIST_EN_vo_bist2_en(data)                                 (0x00000400&((data)<<10))
#define SYS_BIST_EN_vi_bist_en(data)                                  (0x00000200&((data)<<9))
#define SYS_BIST_EN_tvd_bist_en(data)                                 (0x00000100&((data)<<8))
#define SYS_BIST_EN_ilk_usb_bist_en(data)                             (0x00000080&((data)<<7))
#define SYS_BIST_EN_ide_bist_en(data)                                 (0x00000040&((data)<<6))
#define SYS_BIST_EN_ve_bist1_en(data)                                 (0x00000020&((data)<<5))
#define SYS_BIST_EN_ve_bist2_en(data)                                 (0x00000010&((data)<<4))
#define SYS_BIST_EN_ve_bist3_en(data)                                 (0x00000008&((data)<<3))
#define SYS_BIST_EN_me_bist1_en(data)                                 (0x00000004&((data)<<2))
#define SYS_BIST_EN_me_bist2_en(data)                                 (0x00000002&((data)<<1))
#define SYS_BIST_EN_write_data(data)                                  (0x00000001&(data))
#define SYS_BIST_EN_get_scpu_bist_en(data)                            ((0x00040000&(data))>>18)
#define SYS_BIST_EN_get_vcpu_bist_en(data)                            ((0x00020000&(data))>>17)
#define SYS_BIST_EN_get_acpu_bist1_en(data)                           ((0x00010000&(data))>>16)
#define SYS_BIST_EN_get_acpu_bist2_en(data)                           ((0x00008000&(data))>>15)
#define SYS_BIST_EN_get_dc_bist_en(data)                              ((0x00004000&(data))>>14)
#define SYS_BIST_EN_get_se_bist_en(data)                              ((0x00002000&(data))>>13)
#define SYS_BIST_EN_get_etn_aio_bist_en(data)                         ((0x00001000&(data))>>12)
#define SYS_BIST_EN_get_vo_bist1_en(data)                             ((0x00000800&(data))>>11)
#define SYS_BIST_EN_get_vo_bist2_en(data)                             ((0x00000400&(data))>>10)
#define SYS_BIST_EN_get_vi_bist_en(data)                              ((0x00000200&(data))>>9)
#define SYS_BIST_EN_get_tvd_bist_en(data)                             ((0x00000100&(data))>>8)
#define SYS_BIST_EN_get_ilk_usb_bist_en(data)                         ((0x00000080&(data))>>7)
#define SYS_BIST_EN_get_ide_bist_en(data)                             ((0x00000040&(data))>>6)
#define SYS_BIST_EN_get_ve_bist1_en(data)                             ((0x00000020&(data))>>5)
#define SYS_BIST_EN_get_ve_bist2_en(data)                             ((0x00000010&(data))>>4)
#define SYS_BIST_EN_get_ve_bist3_en(data)                             ((0x00000008&(data))>>3)
#define SYS_BIST_EN_get_me_bist1_en(data)                             ((0x00000004&(data))>>2)
#define SYS_BIST_EN_get_me_bist2_en(data)                             ((0x00000002&(data))>>1)
#define SYS_BIST_EN_get_write_data(data)                              (0x00000001&(data))

#define SYS_DC_BIST_ST                                                0x18000034
#define SYS_DC_BIST_ST_reg_addr                                       "0xB8000034"
#define SYS_DC_BIST_ST_reg                                            0xB8000034
#define SYS_DC_BIST_ST_inst_addr                                      "0x000D"
#define SYS_DC_BIST_ST_inst                                           0x000D
#define SYS_DC_BIST_ST_dc_bist_fail2_shift                            (4)
#define SYS_DC_BIST_ST_dc_bist_fail1_shift                            (3)
#define SYS_DC_BIST_ST_dc_bist_fail0_shift                            (2)
#define SYS_DC_BIST_ST_dc_bist_fail_tgl_shift                         (1)
#define SYS_DC_BIST_ST_dc_bist_done_shift                             (0)
#define SYS_DC_BIST_ST_dc_bist_fail2_mask                             (0x00000010)
#define SYS_DC_BIST_ST_dc_bist_fail1_mask                             (0x00000008)
#define SYS_DC_BIST_ST_dc_bist_fail0_mask                             (0x00000004)
#define SYS_DC_BIST_ST_dc_bist_fail_tgl_mask                          (0x00000002)
#define SYS_DC_BIST_ST_dc_bist_done_mask                              (0x00000001)
#define SYS_DC_BIST_ST_dc_bist_fail2(data)                            (0x00000010&((data)<<4))
#define SYS_DC_BIST_ST_dc_bist_fail1(data)                            (0x00000008&((data)<<3))
#define SYS_DC_BIST_ST_dc_bist_fail0(data)                            (0x00000004&((data)<<2))
#define SYS_DC_BIST_ST_dc_bist_fail_tgl(data)                         (0x00000002&((data)<<1))
#define SYS_DC_BIST_ST_dc_bist_done(data)                             (0x00000001&(data))
#define SYS_DC_BIST_ST_get_dc_bist_fail2(data)                        ((0x00000010&(data))>>4)
#define SYS_DC_BIST_ST_get_dc_bist_fail1(data)                        ((0x00000008&(data))>>3)
#define SYS_DC_BIST_ST_get_dc_bist_fail0(data)                        ((0x00000004&(data))>>2)
#define SYS_DC_BIST_ST_get_dc_bist_fail_tgl(data)                     ((0x00000002&(data))>>1)
#define SYS_DC_BIST_ST_get_dc_bist_done(data)                         (0x00000001&(data))

#define SYS_SE_BIST_ST                                                0x18000038
#define SYS_SE_BIST_ST_reg_addr                                       "0xB8000038"
#define SYS_SE_BIST_ST_reg                                            0xB8000038
#define SYS_SE_BIST_ST_inst_addr                                      "0x000E"
#define SYS_SE_BIST_ST_inst                                           0x000E
#define SYS_SE_BIST_ST_se_bist_fail2_shift                            (4)
#define SYS_SE_BIST_ST_se_bist_fail1_shift                            (3)
#define SYS_SE_BIST_ST_se_bist_fail0_shift                            (2)
#define SYS_SE_BIST_ST_se_bist_fail_tgl_shift                         (1)
#define SYS_SE_BIST_ST_se_bist_done_shift                             (0)
#define SYS_SE_BIST_ST_se_bist_fail2_mask                             (0x00000010)
#define SYS_SE_BIST_ST_se_bist_fail1_mask                             (0x00000008)
#define SYS_SE_BIST_ST_se_bist_fail0_mask                             (0x00000004)
#define SYS_SE_BIST_ST_se_bist_fail_tgl_mask                          (0x00000002)
#define SYS_SE_BIST_ST_se_bist_done_mask                              (0x00000001)
#define SYS_SE_BIST_ST_se_bist_fail2(data)                            (0x00000010&((data)<<4))
#define SYS_SE_BIST_ST_se_bist_fail1(data)                            (0x00000008&((data)<<3))
#define SYS_SE_BIST_ST_se_bist_fail0(data)                            (0x00000004&((data)<<2))
#define SYS_SE_BIST_ST_se_bist_fail_tgl(data)                         (0x00000002&((data)<<1))
#define SYS_SE_BIST_ST_se_bist_done(data)                             (0x00000001&(data))
#define SYS_SE_BIST_ST_get_se_bist_fail2(data)                        ((0x00000010&(data))>>4)
#define SYS_SE_BIST_ST_get_se_bist_fail1(data)                        ((0x00000008&(data))>>3)
#define SYS_SE_BIST_ST_get_se_bist_fail0(data)                        ((0x00000004&(data))>>2)
#define SYS_SE_BIST_ST_get_se_bist_fail_tgl(data)                     ((0x00000002&(data))>>1)
#define SYS_SE_BIST_ST_get_se_bist_done(data)                         (0x00000001&(data))

#define SYS_ETN_AIO_BIST_ST                                           0x1800003C
#define SYS_ETN_AIO_BIST_ST_reg_addr                                  "0xB800003C"
#define SYS_ETN_AIO_BIST_ST_reg                                       0xB800003C
#define SYS_ETN_AIO_BIST_ST_inst_addr                                 "0x000F"
#define SYS_ETN_AIO_BIST_ST_inst                                      0x000F
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail3_shift                  (5)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail2_shift                  (4)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail1_shift                  (3)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail0_shift                  (2)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail_tgl_shift               (1)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_done_shift                   (0)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail3_mask                   (0x00000020)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail2_mask                   (0x00000010)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail1_mask                   (0x00000008)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail0_mask                   (0x00000004)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail_tgl_mask                (0x00000002)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_done_mask                    (0x00000001)
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail3(data)                  (0x00000020&((data)<<5))
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail2(data)                  (0x00000010&((data)<<4))
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail1(data)                  (0x00000008&((data)<<3))
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail0(data)                  (0x00000004&((data)<<2))
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_fail_tgl(data)               (0x00000002&((data)<<1))
#define SYS_ETN_AIO_BIST_ST_etn_aio_bist_done(data)                   (0x00000001&(data))
#define SYS_ETN_AIO_BIST_ST_get_etn_aio_bist_fail3(data)              ((0x00000020&(data))>>5)
#define SYS_ETN_AIO_BIST_ST_get_etn_aio_bist_fail2(data)              ((0x00000010&(data))>>4)
#define SYS_ETN_AIO_BIST_ST_get_etn_aio_bist_fail1(data)              ((0x00000008&(data))>>3)
#define SYS_ETN_AIO_BIST_ST_get_etn_aio_bist_fail0(data)              ((0x00000004&(data))>>2)
#define SYS_ETN_AIO_BIST_ST_get_etn_aio_bist_fail_tgl(data)           ((0x00000002&(data))>>1)
#define SYS_ETN_AIO_BIST_ST_get_etn_aio_bist_done(data)               (0x00000001&(data))

#define SYS_VO_BIST1_ST                                               0x18000040
#define SYS_VO_BIST1_ST_reg_addr                                      "0xB8000040"
#define SYS_VO_BIST1_ST_reg                                           0xB8000040
#define SYS_VO_BIST1_ST_inst_addr                                     "0x0010"
#define SYS_VO_BIST1_ST_inst                                          0x0010
#define SYS_VO_BIST1_ST_vo_bist1_fail6_shift                          (8)
#define SYS_VO_BIST1_ST_vo_bist1_fail5_shift                          (7)
#define SYS_VO_BIST1_ST_vo_bist1_fail4_shift                          (6)
#define SYS_VO_BIST1_ST_vo_bist1_fail3_shift                          (5)
#define SYS_VO_BIST1_ST_vo_bist1_fail2_shift                          (4)
#define SYS_VO_BIST1_ST_vo_bist1_fail1_shift                          (3)
#define SYS_VO_BIST1_ST_vo_bist1_fail0_shift                          (2)
#define SYS_VO_BIST1_ST_vo_bist1_fail_tgl_shift                       (1)
#define SYS_VO_BIST1_ST_vo_bist1_done_shift                           (0)
#define SYS_VO_BIST1_ST_vo_bist1_fail6_mask                           (0x00000100)
#define SYS_VO_BIST1_ST_vo_bist1_fail5_mask                           (0x00000080)
#define SYS_VO_BIST1_ST_vo_bist1_fail4_mask                           (0x00000040)
#define SYS_VO_BIST1_ST_vo_bist1_fail3_mask                           (0x00000020)
#define SYS_VO_BIST1_ST_vo_bist1_fail2_mask                           (0x00000010)
#define SYS_VO_BIST1_ST_vo_bist1_fail1_mask                           (0x00000008)
#define SYS_VO_BIST1_ST_vo_bist1_fail0_mask                           (0x00000004)
#define SYS_VO_BIST1_ST_vo_bist1_fail_tgl_mask                        (0x00000002)
#define SYS_VO_BIST1_ST_vo_bist1_done_mask                            (0x00000001)
#define SYS_VO_BIST1_ST_vo_bist1_fail6(data)                          (0x00000100&((data)<<8))
#define SYS_VO_BIST1_ST_vo_bist1_fail5(data)                          (0x00000080&((data)<<7))
#define SYS_VO_BIST1_ST_vo_bist1_fail4(data)                          (0x00000040&((data)<<6))
#define SYS_VO_BIST1_ST_vo_bist1_fail3(data)                          (0x00000020&((data)<<5))
#define SYS_VO_BIST1_ST_vo_bist1_fail2(data)                          (0x00000010&((data)<<4))
#define SYS_VO_BIST1_ST_vo_bist1_fail1(data)                          (0x00000008&((data)<<3))
#define SYS_VO_BIST1_ST_vo_bist1_fail0(data)                          (0x00000004&((data)<<2))
#define SYS_VO_BIST1_ST_vo_bist1_fail_tgl(data)                       (0x00000002&((data)<<1))
#define SYS_VO_BIST1_ST_vo_bist1_done(data)                           (0x00000001&(data))
#define SYS_VO_BIST1_ST_get_vo_bist1_fail6(data)                      ((0x00000100&(data))>>8)
#define SYS_VO_BIST1_ST_get_vo_bist1_fail5(data)                      ((0x00000080&(data))>>7)
#define SYS_VO_BIST1_ST_get_vo_bist1_fail4(data)                      ((0x00000040&(data))>>6)
#define SYS_VO_BIST1_ST_get_vo_bist1_fail3(data)                      ((0x00000020&(data))>>5)
#define SYS_VO_BIST1_ST_get_vo_bist1_fail2(data)                      ((0x00000010&(data))>>4)
#define SYS_VO_BIST1_ST_get_vo_bist1_fail1(data)                      ((0x00000008&(data))>>3)
#define SYS_VO_BIST1_ST_get_vo_bist1_fail0(data)                      ((0x00000004&(data))>>2)
#define SYS_VO_BIST1_ST_get_vo_bist1_fail_tgl(data)                   ((0x00000002&(data))>>1)
#define SYS_VO_BIST1_ST_get_vo_bist1_done(data)                       (0x00000001&(data))

#define SYS_VO_BIST2_ST                                               0x18000044
#define SYS_VO_BIST2_ST_reg_addr                                      "0xB8000044"
#define SYS_VO_BIST2_ST_reg                                           0xB8000044
#define SYS_VO_BIST2_ST_inst_addr                                     "0x0011"
#define SYS_VO_BIST2_ST_inst                                          0x0011
#define SYS_VO_BIST2_ST_vo_bist2_fail6_shift                          (8)
#define SYS_VO_BIST2_ST_vo_bist2_fail5_shift                          (7)
#define SYS_VO_BIST2_ST_vo_bist2_fail4_shift                          (6)
#define SYS_VO_BIST2_ST_vo_bist2_fail3_shift                          (5)
#define SYS_VO_BIST2_ST_vo_bist2_fail2_shift                          (4)
#define SYS_VO_BIST2_ST_vo_bist2_fail1_shift                          (3)
#define SYS_VO_BIST2_ST_vo_bist2_fail0_shift                          (2)
#define SYS_VO_BIST2_ST_vo_bist2_fail_tgl_shift                       (1)
#define SYS_VO_BIST2_ST_vo_bist2_done_shift                           (0)
#define SYS_VO_BIST2_ST_vo_bist2_fail6_mask                           (0x00000100)
#define SYS_VO_BIST2_ST_vo_bist2_fail5_mask                           (0x00000080)
#define SYS_VO_BIST2_ST_vo_bist2_fail4_mask                           (0x00000040)
#define SYS_VO_BIST2_ST_vo_bist2_fail3_mask                           (0x00000020)
#define SYS_VO_BIST2_ST_vo_bist2_fail2_mask                           (0x00000010)
#define SYS_VO_BIST2_ST_vo_bist2_fail1_mask                           (0x00000008)
#define SYS_VO_BIST2_ST_vo_bist2_fail0_mask                           (0x00000004)
#define SYS_VO_BIST2_ST_vo_bist2_fail_tgl_mask                        (0x00000002)
#define SYS_VO_BIST2_ST_vo_bist2_done_mask                            (0x00000001)
#define SYS_VO_BIST2_ST_vo_bist2_fail6(data)                          (0x00000100&((data)<<8))
#define SYS_VO_BIST2_ST_vo_bist2_fail5(data)                          (0x00000080&((data)<<7))
#define SYS_VO_BIST2_ST_vo_bist2_fail4(data)                          (0x00000040&((data)<<6))
#define SYS_VO_BIST2_ST_vo_bist2_fail3(data)                          (0x00000020&((data)<<5))
#define SYS_VO_BIST2_ST_vo_bist2_fail2(data)                          (0x00000010&((data)<<4))
#define SYS_VO_BIST2_ST_vo_bist2_fail1(data)                          (0x00000008&((data)<<3))
#define SYS_VO_BIST2_ST_vo_bist2_fail0(data)                          (0x00000004&((data)<<2))
#define SYS_VO_BIST2_ST_vo_bist2_fail_tgl(data)                       (0x00000002&((data)<<1))
#define SYS_VO_BIST2_ST_vo_bist2_done(data)                           (0x00000001&(data))
#define SYS_VO_BIST2_ST_get_vo_bist2_fail6(data)                      ((0x00000100&(data))>>8)
#define SYS_VO_BIST2_ST_get_vo_bist2_fail5(data)                      ((0x00000080&(data))>>7)
#define SYS_VO_BIST2_ST_get_vo_bist2_fail4(data)                      ((0x00000040&(data))>>6)
#define SYS_VO_BIST2_ST_get_vo_bist2_fail3(data)                      ((0x00000020&(data))>>5)
#define SYS_VO_BIST2_ST_get_vo_bist2_fail2(data)                      ((0x00000010&(data))>>4)
#define SYS_VO_BIST2_ST_get_vo_bist2_fail1(data)                      ((0x00000008&(data))>>3)
#define SYS_VO_BIST2_ST_get_vo_bist2_fail0(data)                      ((0x00000004&(data))>>2)
#define SYS_VO_BIST2_ST_get_vo_bist2_fail_tgl(data)                   ((0x00000002&(data))>>1)
#define SYS_VO_BIST2_ST_get_vo_bist2_done(data)                       (0x00000001&(data))

#define SYS_VI_BIST_ST                                                0x18000048
#define SYS_VI_BIST_ST_reg_addr                                       "0xB8000048"
#define SYS_VI_BIST_ST_reg                                            0xB8000048
#define SYS_VI_BIST_ST_inst_addr                                      "0x0012"
#define SYS_VI_BIST_ST_inst                                           0x0012
#define SYS_VI_BIST_ST_vi_bist_fail4_shift                            (6)
#define SYS_VI_BIST_ST_vi_bist_fail3_shift                            (5)
#define SYS_VI_BIST_ST_vi_bist_fail2_shift                            (4)
#define SYS_VI_BIST_ST_vi_bist_fail1_shift                            (3)
#define SYS_VI_BIST_ST_vi_bist_fail0_shift                            (2)
#define SYS_VI_BIST_ST_vi_bist_fail_tgl_shift                         (1)
#define SYS_VI_BIST_ST_vi_bist_done_shift                             (0)
#define SYS_VI_BIST_ST_vi_bist_fail4_mask                             (0x00000040)
#define SYS_VI_BIST_ST_vi_bist_fail3_mask                             (0x00000020)
#define SYS_VI_BIST_ST_vi_bist_fail2_mask                             (0x00000010)
#define SYS_VI_BIST_ST_vi_bist_fail1_mask                             (0x00000008)
#define SYS_VI_BIST_ST_vi_bist_fail0_mask                             (0x00000004)
#define SYS_VI_BIST_ST_vi_bist_fail_tgl_mask                          (0x00000002)
#define SYS_VI_BIST_ST_vi_bist_done_mask                              (0x00000001)
#define SYS_VI_BIST_ST_vi_bist_fail4(data)                            (0x00000040&((data)<<6))
#define SYS_VI_BIST_ST_vi_bist_fail3(data)                            (0x00000020&((data)<<5))
#define SYS_VI_BIST_ST_vi_bist_fail2(data)                            (0x00000010&((data)<<4))
#define SYS_VI_BIST_ST_vi_bist_fail1(data)                            (0x00000008&((data)<<3))
#define SYS_VI_BIST_ST_vi_bist_fail0(data)                            (0x00000004&((data)<<2))
#define SYS_VI_BIST_ST_vi_bist_fail_tgl(data)                         (0x00000002&((data)<<1))
#define SYS_VI_BIST_ST_vi_bist_done(data)                             (0x00000001&(data))
#define SYS_VI_BIST_ST_get_vi_bist_fail4(data)                        ((0x00000040&(data))>>6)
#define SYS_VI_BIST_ST_get_vi_bist_fail3(data)                        ((0x00000020&(data))>>5)
#define SYS_VI_BIST_ST_get_vi_bist_fail2(data)                        ((0x00000010&(data))>>4)
#define SYS_VI_BIST_ST_get_vi_bist_fail1(data)                        ((0x00000008&(data))>>3)
#define SYS_VI_BIST_ST_get_vi_bist_fail0(data)                        ((0x00000004&(data))>>2)
#define SYS_VI_BIST_ST_get_vi_bist_fail_tgl(data)                     ((0x00000002&(data))>>1)
#define SYS_VI_BIST_ST_get_vi_bist_done(data)                         (0x00000001&(data))

#define SYS_TVD_BIST_ST                                               0x1800004C
#define SYS_TVD_BIST_ST_reg_addr                                      "0xB800004C"
#define SYS_TVD_BIST_ST_reg                                           0xB800004C
#define SYS_TVD_BIST_ST_inst_addr                                     "0x0013"
#define SYS_TVD_BIST_ST_inst                                          0x0013
#define SYS_TVD_BIST_ST_tvd_bist_fail7_shift                          (9)
#define SYS_TVD_BIST_ST_tvd_bist_fail6_shift                          (8)
#define SYS_TVD_BIST_ST_tvd_bist_fail5_shift                          (7)
#define SYS_TVD_BIST_ST_tvd_bist_fail4_shift                          (6)
#define SYS_TVD_BIST_ST_tvd_bist_fail3_shift                          (5)
#define SYS_TVD_BIST_ST_tvd_bist_fail2_shift                          (4)
#define SYS_TVD_BIST_ST_tvd_bist_fail1_shift                          (3)
#define SYS_TVD_BIST_ST_tvd_bist_fail0_shift                          (2)
#define SYS_TVD_BIST_ST_tvd_bist_fail_tgl_shift                       (1)
#define SYS_TVD_BIST_ST_tvd_bist_done_shift                           (0)
#define SYS_TVD_BIST_ST_tvd_bist_fail7_mask                           (0x00000200)
#define SYS_TVD_BIST_ST_tvd_bist_fail6_mask                           (0x00000100)
#define SYS_TVD_BIST_ST_tvd_bist_fail5_mask                           (0x00000080)
#define SYS_TVD_BIST_ST_tvd_bist_fail4_mask                           (0x00000040)
#define SYS_TVD_BIST_ST_tvd_bist_fail3_mask                           (0x00000020)
#define SYS_TVD_BIST_ST_tvd_bist_fail2_mask                           (0x00000010)
#define SYS_TVD_BIST_ST_tvd_bist_fail1_mask                           (0x00000008)
#define SYS_TVD_BIST_ST_tvd_bist_fail0_mask                           (0x00000004)
#define SYS_TVD_BIST_ST_tvd_bist_fail_tgl_mask                        (0x00000002)
#define SYS_TVD_BIST_ST_tvd_bist_done_mask                            (0x00000001)
#define SYS_TVD_BIST_ST_tvd_bist_fail7(data)                          (0x00000200&((data)<<9))
#define SYS_TVD_BIST_ST_tvd_bist_fail6(data)                          (0x00000100&((data)<<8))
#define SYS_TVD_BIST_ST_tvd_bist_fail5(data)                          (0x00000080&((data)<<7))
#define SYS_TVD_BIST_ST_tvd_bist_fail4(data)                          (0x00000040&((data)<<6))
#define SYS_TVD_BIST_ST_tvd_bist_fail3(data)                          (0x00000020&((data)<<5))
#define SYS_TVD_BIST_ST_tvd_bist_fail2(data)                          (0x00000010&((data)<<4))
#define SYS_TVD_BIST_ST_tvd_bist_fail1(data)                          (0x00000008&((data)<<3))
#define SYS_TVD_BIST_ST_tvd_bist_fail0(data)                          (0x00000004&((data)<<2))
#define SYS_TVD_BIST_ST_tvd_bist_fail_tgl(data)                       (0x00000002&((data)<<1))
#define SYS_TVD_BIST_ST_tvd_bist_done(data)                           (0x00000001&(data))
#define SYS_TVD_BIST_ST_get_tvd_bist_fail7(data)                      ((0x00000200&(data))>>9)
#define SYS_TVD_BIST_ST_get_tvd_bist_fail6(data)                      ((0x00000100&(data))>>8)
#define SYS_TVD_BIST_ST_get_tvd_bist_fail5(data)                      ((0x00000080&(data))>>7)
#define SYS_TVD_BIST_ST_get_tvd_bist_fail4(data)                      ((0x00000040&(data))>>6)
#define SYS_TVD_BIST_ST_get_tvd_bist_fail3(data)                      ((0x00000020&(data))>>5)
#define SYS_TVD_BIST_ST_get_tvd_bist_fail2(data)                      ((0x00000010&(data))>>4)
#define SYS_TVD_BIST_ST_get_tvd_bist_fail1(data)                      ((0x00000008&(data))>>3)
#define SYS_TVD_BIST_ST_get_tvd_bist_fail0(data)                      ((0x00000004&(data))>>2)
#define SYS_TVD_BIST_ST_get_tvd_bist_fail_tgl(data)                   ((0x00000002&(data))>>1)
#define SYS_TVD_BIST_ST_get_tvd_bist_done(data)                       (0x00000001&(data))

#define SYS_ILK_USB_BIST_ST                                           0x18000050
#define SYS_ILK_USB_BIST_ST_reg_addr                                  "0xB8000050"
#define SYS_ILK_USB_BIST_ST_reg                                       0xB8000050
#define SYS_ILK_USB_BIST_ST_inst_addr                                 "0x0014"
#define SYS_ILK_USB_BIST_ST_inst                                      0x0014
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail6_shift                  (8)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail5_shift                  (7)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail4_shift                  (6)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail3_shift                  (5)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail2_shift                  (4)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail1_shift                  (3)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail0_shift                  (2)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail_tgl_shift               (1)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_done_shift                   (0)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail6_mask                   (0x00000100)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail5_mask                   (0x00000080)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail4_mask                   (0x00000040)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail3_mask                   (0x00000020)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail2_mask                   (0x00000010)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail1_mask                   (0x00000008)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail0_mask                   (0x00000004)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail_tgl_mask                (0x00000002)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_done_mask                    (0x00000001)
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail6(data)                  (0x00000100&((data)<<8))
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail5(data)                  (0x00000080&((data)<<7))
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail4(data)                  (0x00000040&((data)<<6))
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail3(data)                  (0x00000020&((data)<<5))
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail2(data)                  (0x00000010&((data)<<4))
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail1(data)                  (0x00000008&((data)<<3))
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail0(data)                  (0x00000004&((data)<<2))
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_fail_tgl(data)               (0x00000002&((data)<<1))
#define SYS_ILK_USB_BIST_ST_ilk_usb_bist_done(data)                   (0x00000001&(data))
#define SYS_ILK_USB_BIST_ST_get_ilk_usb_bist_fail6(data)              ((0x00000100&(data))>>8)
#define SYS_ILK_USB_BIST_ST_get_ilk_usb_bist_fail5(data)              ((0x00000080&(data))>>7)
#define SYS_ILK_USB_BIST_ST_get_ilk_usb_bist_fail4(data)              ((0x00000040&(data))>>6)
#define SYS_ILK_USB_BIST_ST_get_ilk_usb_bist_fail3(data)              ((0x00000020&(data))>>5)
#define SYS_ILK_USB_BIST_ST_get_ilk_usb_bist_fail2(data)              ((0x00000010&(data))>>4)
#define SYS_ILK_USB_BIST_ST_get_ilk_usb_bist_fail1(data)              ((0x00000008&(data))>>3)
#define SYS_ILK_USB_BIST_ST_get_ilk_usb_bist_fail0(data)              ((0x00000004&(data))>>2)
#define SYS_ILK_USB_BIST_ST_get_ilk_usb_bist_fail_tgl(data)           ((0x00000002&(data))>>1)
#define SYS_ILK_USB_BIST_ST_get_ilk_usb_bist_done(data)               (0x00000001&(data))

#define SYS_IDE_BIST_ST                                               0x18000054
#define SYS_IDE_BIST_ST_reg_addr                                      "0xB8000054"
#define SYS_IDE_BIST_ST_reg                                           0xB8000054
#define SYS_IDE_BIST_ST_inst_addr                                     "0x0015"
#define SYS_IDE_BIST_ST_inst                                          0x0015
#define SYS_IDE_BIST_ST_ide_bist_fail5_shift                          (7)
#define SYS_IDE_BIST_ST_ide_bist_fail4_shift                          (6)
#define SYS_IDE_BIST_ST_ide_bist_fail3_shift                          (5)
#define SYS_IDE_BIST_ST_ide_bist_fail2_shift                          (4)
#define SYS_IDE_BIST_ST_ide_bist_fail1_shift                          (3)
#define SYS_IDE_BIST_ST_ide_bist_fail0_shift                          (2)
#define SYS_IDE_BIST_ST_ide_bist_fail_tgl_shift                       (1)
#define SYS_IDE_BIST_ST_ide_bist_done_shift                           (0)
#define SYS_IDE_BIST_ST_ide_bist_fail5_mask                           (0x00000080)
#define SYS_IDE_BIST_ST_ide_bist_fail4_mask                           (0x00000040)
#define SYS_IDE_BIST_ST_ide_bist_fail3_mask                           (0x00000020)
#define SYS_IDE_BIST_ST_ide_bist_fail2_mask                           (0x00000010)
#define SYS_IDE_BIST_ST_ide_bist_fail1_mask                           (0x00000008)
#define SYS_IDE_BIST_ST_ide_bist_fail0_mask                           (0x00000004)
#define SYS_IDE_BIST_ST_ide_bist_fail_tgl_mask                        (0x00000002)
#define SYS_IDE_BIST_ST_ide_bist_done_mask                            (0x00000001)
#define SYS_IDE_BIST_ST_ide_bist_fail5(data)                          (0x00000080&((data)<<7))
#define SYS_IDE_BIST_ST_ide_bist_fail4(data)                          (0x00000040&((data)<<6))
#define SYS_IDE_BIST_ST_ide_bist_fail3(data)                          (0x00000020&((data)<<5))
#define SYS_IDE_BIST_ST_ide_bist_fail2(data)                          (0x00000010&((data)<<4))
#define SYS_IDE_BIST_ST_ide_bist_fail1(data)                          (0x00000008&((data)<<3))
#define SYS_IDE_BIST_ST_ide_bist_fail0(data)                          (0x00000004&((data)<<2))
#define SYS_IDE_BIST_ST_ide_bist_fail_tgl(data)                       (0x00000002&((data)<<1))
#define SYS_IDE_BIST_ST_ide_bist_done(data)                           (0x00000001&(data))
#define SYS_IDE_BIST_ST_get_ide_bist_fail5(data)                      ((0x00000080&(data))>>7)
#define SYS_IDE_BIST_ST_get_ide_bist_fail4(data)                      ((0x00000040&(data))>>6)
#define SYS_IDE_BIST_ST_get_ide_bist_fail3(data)                      ((0x00000020&(data))>>5)
#define SYS_IDE_BIST_ST_get_ide_bist_fail2(data)                      ((0x00000010&(data))>>4)
#define SYS_IDE_BIST_ST_get_ide_bist_fail1(data)                      ((0x00000008&(data))>>3)
#define SYS_IDE_BIST_ST_get_ide_bist_fail0(data)                      ((0x00000004&(data))>>2)
#define SYS_IDE_BIST_ST_get_ide_bist_fail_tgl(data)                   ((0x00000002&(data))>>1)
#define SYS_IDE_BIST_ST_get_ide_bist_done(data)                       (0x00000001&(data))

#define SYS_VE_BIST1_ST                                               0x18000058
#define SYS_VE_BIST1_ST_reg_addr                                      "0xB8000058"
#define SYS_VE_BIST1_ST_reg                                           0xB8000058
#define SYS_VE_BIST1_ST_inst_addr                                     "0x0016"
#define SYS_VE_BIST1_ST_inst                                          0x0016
#define SYS_VE_BIST1_ST_ve_bist1_fail3_shift                          (5)
#define SYS_VE_BIST1_ST_ve_bist1_fail2_shift                          (4)
#define SYS_VE_BIST1_ST_ve_bist1_fail1_shift                          (3)
#define SYS_VE_BIST1_ST_ve_bist1_fail0_shift                          (2)
#define SYS_VE_BIST1_ST_ve_bist1_fail_tgl_shift                       (1)
#define SYS_VE_BIST1_ST_ve_bist1_done_shift                           (0)
#define SYS_VE_BIST1_ST_ve_bist1_fail3_mask                           (0x00000020)
#define SYS_VE_BIST1_ST_ve_bist1_fail2_mask                           (0x00000010)
#define SYS_VE_BIST1_ST_ve_bist1_fail1_mask                           (0x00000008)
#define SYS_VE_BIST1_ST_ve_bist1_fail0_mask                           (0x00000004)
#define SYS_VE_BIST1_ST_ve_bist1_fail_tgl_mask                        (0x00000002)
#define SYS_VE_BIST1_ST_ve_bist1_done_mask                            (0x00000001)
#define SYS_VE_BIST1_ST_ve_bist1_fail3(data)                          (0x00000020&((data)<<5))
#define SYS_VE_BIST1_ST_ve_bist1_fail2(data)                          (0x00000010&((data)<<4))
#define SYS_VE_BIST1_ST_ve_bist1_fail1(data)                          (0x00000008&((data)<<3))
#define SYS_VE_BIST1_ST_ve_bist1_fail0(data)                          (0x00000004&((data)<<2))
#define SYS_VE_BIST1_ST_ve_bist1_fail_tgl(data)                       (0x00000002&((data)<<1))
#define SYS_VE_BIST1_ST_ve_bist1_done(data)                           (0x00000001&(data))
#define SYS_VE_BIST1_ST_get_ve_bist1_fail3(data)                      ((0x00000020&(data))>>5)
#define SYS_VE_BIST1_ST_get_ve_bist1_fail2(data)                      ((0x00000010&(data))>>4)
#define SYS_VE_BIST1_ST_get_ve_bist1_fail1(data)                      ((0x00000008&(data))>>3)
#define SYS_VE_BIST1_ST_get_ve_bist1_fail0(data)                      ((0x00000004&(data))>>2)
#define SYS_VE_BIST1_ST_get_ve_bist1_fail_tgl(data)                   ((0x00000002&(data))>>1)
#define SYS_VE_BIST1_ST_get_ve_bist1_done(data)                       (0x00000001&(data))

#define SYS_VE_BIST2_ST                                               0x1800005C
#define SYS_VE_BIST2_ST_reg_addr                                      "0xB800005C"
#define SYS_VE_BIST2_ST_reg                                           0xB800005C
#define SYS_VE_BIST2_ST_inst_addr                                     "0x0017"
#define SYS_VE_BIST2_ST_inst                                          0x0017
#define SYS_VE_BIST2_ST_ve_bist2_fail6_shift                          (8)
#define SYS_VE_BIST2_ST_ve_bist2_fail5_shift                          (7)
#define SYS_VE_BIST2_ST_ve_bist2_fail4_shift                          (6)
#define SYS_VE_BIST2_ST_ve_bist2_fail3_shift                          (5)
#define SYS_VE_BIST2_ST_ve_bist2_fail2_shift                          (4)
#define SYS_VE_BIST2_ST_ve_bist2_fail1_shift                          (3)
#define SYS_VE_BIST2_ST_ve_bist2_fail0_shift                          (2)
#define SYS_VE_BIST2_ST_ve_bist2_fail_tgl_shift                       (1)
#define SYS_VE_BIST2_ST_ve_bist2_done_shift                           (0)
#define SYS_VE_BIST2_ST_ve_bist2_fail6_mask                           (0x00000100)
#define SYS_VE_BIST2_ST_ve_bist2_fail5_mask                           (0x00000080)
#define SYS_VE_BIST2_ST_ve_bist2_fail4_mask                           (0x00000040)
#define SYS_VE_BIST2_ST_ve_bist2_fail3_mask                           (0x00000020)
#define SYS_VE_BIST2_ST_ve_bist2_fail2_mask                           (0x00000010)
#define SYS_VE_BIST2_ST_ve_bist2_fail1_mask                           (0x00000008)
#define SYS_VE_BIST2_ST_ve_bist2_fail0_mask                           (0x00000004)
#define SYS_VE_BIST2_ST_ve_bist2_fail_tgl_mask                        (0x00000002)
#define SYS_VE_BIST2_ST_ve_bist2_done_mask                            (0x00000001)
#define SYS_VE_BIST2_ST_ve_bist2_fail6(data)                          (0x00000100&((data)<<8))
#define SYS_VE_BIST2_ST_ve_bist2_fail5(data)                          (0x00000080&((data)<<7))
#define SYS_VE_BIST2_ST_ve_bist2_fail4(data)                          (0x00000040&((data)<<6))
#define SYS_VE_BIST2_ST_ve_bist2_fail3(data)                          (0x00000020&((data)<<5))
#define SYS_VE_BIST2_ST_ve_bist2_fail2(data)                          (0x00000010&((data)<<4))
#define SYS_VE_BIST2_ST_ve_bist2_fail1(data)                          (0x00000008&((data)<<3))
#define SYS_VE_BIST2_ST_ve_bist2_fail0(data)                          (0x00000004&((data)<<2))
#define SYS_VE_BIST2_ST_ve_bist2_fail_tgl(data)                       (0x00000002&((data)<<1))
#define SYS_VE_BIST2_ST_ve_bist2_done(data)                           (0x00000001&(data))
#define SYS_VE_BIST2_ST_get_ve_bist2_fail6(data)                      ((0x00000100&(data))>>8)
#define SYS_VE_BIST2_ST_get_ve_bist2_fail5(data)                      ((0x00000080&(data))>>7)
#define SYS_VE_BIST2_ST_get_ve_bist2_fail4(data)                      ((0x00000040&(data))>>6)
#define SYS_VE_BIST2_ST_get_ve_bist2_fail3(data)                      ((0x00000020&(data))>>5)
#define SYS_VE_BIST2_ST_get_ve_bist2_fail2(data)                      ((0x00000010&(data))>>4)
#define SYS_VE_BIST2_ST_get_ve_bist2_fail1(data)                      ((0x00000008&(data))>>3)
#define SYS_VE_BIST2_ST_get_ve_bist2_fail0(data)                      ((0x00000004&(data))>>2)
#define SYS_VE_BIST2_ST_get_ve_bist2_fail_tgl(data)                   ((0x00000002&(data))>>1)
#define SYS_VE_BIST2_ST_get_ve_bist2_done(data)                       (0x00000001&(data))

#define SYS_VE_BIST3_ST                                               0x18000060
#define SYS_VE_BIST3_ST_reg_addr                                      "0xB8000060"
#define SYS_VE_BIST3_ST_reg                                           0xB8000060
#define SYS_VE_BIST3_ST_inst_addr                                     "0x0018"
#define SYS_VE_BIST3_ST_inst                                          0x0018
#define SYS_VE_BIST3_ST_ve_bist3_fail3_shift                          (5)
#define SYS_VE_BIST3_ST_ve_bist3_fail2_shift                          (4)
#define SYS_VE_BIST3_ST_ve_bist3_fail1_shift                          (3)
#define SYS_VE_BIST3_ST_ve_bist3_fail0_shift                          (2)
#define SYS_VE_BIST3_ST_ve_bist3_fail_tgl_shift                       (1)
#define SYS_VE_BIST3_ST_ve_bist3_done_shift                           (0)
#define SYS_VE_BIST3_ST_ve_bist3_fail3_mask                           (0x00000020)
#define SYS_VE_BIST3_ST_ve_bist3_fail2_mask                           (0x00000010)
#define SYS_VE_BIST3_ST_ve_bist3_fail1_mask                           (0x00000008)
#define SYS_VE_BIST3_ST_ve_bist3_fail0_mask                           (0x00000004)
#define SYS_VE_BIST3_ST_ve_bist3_fail_tgl_mask                        (0x00000002)
#define SYS_VE_BIST3_ST_ve_bist3_done_mask                            (0x00000001)
#define SYS_VE_BIST3_ST_ve_bist3_fail3(data)                          (0x00000020&((data)<<5))
#define SYS_VE_BIST3_ST_ve_bist3_fail2(data)                          (0x00000010&((data)<<4))
#define SYS_VE_BIST3_ST_ve_bist3_fail1(data)                          (0x00000008&((data)<<3))
#define SYS_VE_BIST3_ST_ve_bist3_fail0(data)                          (0x00000004&((data)<<2))
#define SYS_VE_BIST3_ST_ve_bist3_fail_tgl(data)                       (0x00000002&((data)<<1))
#define SYS_VE_BIST3_ST_ve_bist3_done(data)                           (0x00000001&(data))
#define SYS_VE_BIST3_ST_get_ve_bist3_fail3(data)                      ((0x00000020&(data))>>5)
#define SYS_VE_BIST3_ST_get_ve_bist3_fail2(data)                      ((0x00000010&(data))>>4)
#define SYS_VE_BIST3_ST_get_ve_bist3_fail1(data)                      ((0x00000008&(data))>>3)
#define SYS_VE_BIST3_ST_get_ve_bist3_fail0(data)                      ((0x00000004&(data))>>2)
#define SYS_VE_BIST3_ST_get_ve_bist3_fail_tgl(data)                   ((0x00000002&(data))>>1)
#define SYS_VE_BIST3_ST_get_ve_bist3_done(data)                       (0x00000001&(data))

#define SYS_ME_BIST1_ST                                               0x18000064
#define SYS_ME_BIST1_ST_reg_addr                                      "0xB8000064"
#define SYS_ME_BIST1_ST_reg                                           0xB8000064
#define SYS_ME_BIST1_ST_inst_addr                                     "0x0019"
#define SYS_ME_BIST1_ST_inst                                          0x0019
#define SYS_ME_BIST1_ST_me_bist1_fail5_shift                          (7)
#define SYS_ME_BIST1_ST_me_bist1_fail4_shift                          (6)
#define SYS_ME_BIST1_ST_me_bist1_fail3_shift                          (5)
#define SYS_ME_BIST1_ST_me_bist1_fail2_shift                          (4)
#define SYS_ME_BIST1_ST_me_bist1_fail1_shift                          (3)
#define SYS_ME_BIST1_ST_me_bist1_fail0_shift                          (2)
#define SYS_ME_BIST1_ST_me_bist1_fail_tgl_shift                       (1)
#define SYS_ME_BIST1_ST_me_bist1_done_shift                           (0)
#define SYS_ME_BIST1_ST_me_bist1_fail5_mask                           (0x00000080)
#define SYS_ME_BIST1_ST_me_bist1_fail4_mask                           (0x00000040)
#define SYS_ME_BIST1_ST_me_bist1_fail3_mask                           (0x00000020)
#define SYS_ME_BIST1_ST_me_bist1_fail2_mask                           (0x00000010)
#define SYS_ME_BIST1_ST_me_bist1_fail1_mask                           (0x00000008)
#define SYS_ME_BIST1_ST_me_bist1_fail0_mask                           (0x00000004)
#define SYS_ME_BIST1_ST_me_bist1_fail_tgl_mask                        (0x00000002)
#define SYS_ME_BIST1_ST_me_bist1_done_mask                            (0x00000001)
#define SYS_ME_BIST1_ST_me_bist1_fail5(data)                          (0x00000080&((data)<<7))
#define SYS_ME_BIST1_ST_me_bist1_fail4(data)                          (0x00000040&((data)<<6))
#define SYS_ME_BIST1_ST_me_bist1_fail3(data)                          (0x00000020&((data)<<5))
#define SYS_ME_BIST1_ST_me_bist1_fail2(data)                          (0x00000010&((data)<<4))
#define SYS_ME_BIST1_ST_me_bist1_fail1(data)                          (0x00000008&((data)<<3))
#define SYS_ME_BIST1_ST_me_bist1_fail0(data)                          (0x00000004&((data)<<2))
#define SYS_ME_BIST1_ST_me_bist1_fail_tgl(data)                       (0x00000002&((data)<<1))
#define SYS_ME_BIST1_ST_me_bist1_done(data)                           (0x00000001&(data))
#define SYS_ME_BIST1_ST_get_me_bist1_fail5(data)                      ((0x00000080&(data))>>7)
#define SYS_ME_BIST1_ST_get_me_bist1_fail4(data)                      ((0x00000040&(data))>>6)
#define SYS_ME_BIST1_ST_get_me_bist1_fail3(data)                      ((0x00000020&(data))>>5)
#define SYS_ME_BIST1_ST_get_me_bist1_fail2(data)                      ((0x00000010&(data))>>4)
#define SYS_ME_BIST1_ST_get_me_bist1_fail1(data)                      ((0x00000008&(data))>>3)
#define SYS_ME_BIST1_ST_get_me_bist1_fail0(data)                      ((0x00000004&(data))>>2)
#define SYS_ME_BIST1_ST_get_me_bist1_fail_tgl(data)                   ((0x00000002&(data))>>1)
#define SYS_ME_BIST1_ST_get_me_bist1_done(data)                       (0x00000001&(data))

#define SYS_ME_BIST2_ST                                               0x18000068
#define SYS_ME_BIST2_ST_reg_addr                                      "0xB8000068"
#define SYS_ME_BIST2_ST_reg                                           0xB8000068
#define SYS_ME_BIST2_ST_inst_addr                                     "0x001A"
#define SYS_ME_BIST2_ST_inst                                          0x001A
#define SYS_ME_BIST2_ST_me_bist2_fail5_shift                          (7)
#define SYS_ME_BIST2_ST_me_bist2_fail4_shift                          (6)
#define SYS_ME_BIST2_ST_me_bist2_fail3_shift                          (5)
#define SYS_ME_BIST2_ST_me_bist2_fail2_shift                          (4)
#define SYS_ME_BIST2_ST_me_bist2_fail1_shift                          (3)
#define SYS_ME_BIST2_ST_me_bist2_fail0_shift                          (2)
#define SYS_ME_BIST2_ST_me_bist2_fail_tgl_shift                       (1)
#define SYS_ME_BIST2_ST_me_bist2_done_shift                           (0)
#define SYS_ME_BIST2_ST_me_bist2_fail5_mask                           (0x00000080)
#define SYS_ME_BIST2_ST_me_bist2_fail4_mask                           (0x00000040)
#define SYS_ME_BIST2_ST_me_bist2_fail3_mask                           (0x00000020)
#define SYS_ME_BIST2_ST_me_bist2_fail2_mask                           (0x00000010)
#define SYS_ME_BIST2_ST_me_bist2_fail1_mask                           (0x00000008)
#define SYS_ME_BIST2_ST_me_bist2_fail0_mask                           (0x00000004)
#define SYS_ME_BIST2_ST_me_bist2_fail_tgl_mask                        (0x00000002)
#define SYS_ME_BIST2_ST_me_bist2_done_mask                            (0x00000001)
#define SYS_ME_BIST2_ST_me_bist2_fail5(data)                          (0x00000080&((data)<<7))
#define SYS_ME_BIST2_ST_me_bist2_fail4(data)                          (0x00000040&((data)<<6))
#define SYS_ME_BIST2_ST_me_bist2_fail3(data)                          (0x00000020&((data)<<5))
#define SYS_ME_BIST2_ST_me_bist2_fail2(data)                          (0x00000010&((data)<<4))
#define SYS_ME_BIST2_ST_me_bist2_fail1(data)                          (0x00000008&((data)<<3))
#define SYS_ME_BIST2_ST_me_bist2_fail0(data)                          (0x00000004&((data)<<2))
#define SYS_ME_BIST2_ST_me_bist2_fail_tgl(data)                       (0x00000002&((data)<<1))
#define SYS_ME_BIST2_ST_me_bist2_done(data)                           (0x00000001&(data))
#define SYS_ME_BIST2_ST_get_me_bist2_fail5(data)                      ((0x00000080&(data))>>7)
#define SYS_ME_BIST2_ST_get_me_bist2_fail4(data)                      ((0x00000040&(data))>>6)
#define SYS_ME_BIST2_ST_get_me_bist2_fail3(data)                      ((0x00000020&(data))>>5)
#define SYS_ME_BIST2_ST_get_me_bist2_fail2(data)                      ((0x00000010&(data))>>4)
#define SYS_ME_BIST2_ST_get_me_bist2_fail1(data)                      ((0x00000008&(data))>>3)
#define SYS_ME_BIST2_ST_get_me_bist2_fail0(data)                      ((0x00000004&(data))>>2)
#define SYS_ME_BIST2_ST_get_me_bist2_fail_tgl(data)                   ((0x00000002&(data))>>1)
#define SYS_ME_BIST2_ST_get_me_bist2_done(data)                       (0x00000001&(data))

#define SYS_ACPU_BIST1_ST                                             0x1800006C
#define SYS_ACPU_BIST1_ST_reg_addr                                    "0xB800006C"
#define SYS_ACPU_BIST1_ST_reg                                         0xB800006C
#define SYS_ACPU_BIST1_ST_inst_addr                                   "0x001B"
#define SYS_ACPU_BIST1_ST_inst                                        0x001B
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail6_shift                      (8)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail5_shift                      (7)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail4_shift                      (6)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail3_shift                      (5)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail2_shift                      (4)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail1_shift                      (3)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail0_shift                      (2)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail_tgl_shift                   (1)
#define SYS_ACPU_BIST1_ST_adsp_bist1_done_shift                       (0)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail6_mask                       (0x00000100)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail5_mask                       (0x00000080)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail4_mask                       (0x00000040)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail3_mask                       (0x00000020)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail2_mask                       (0x00000010)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail1_mask                       (0x00000008)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail0_mask                       (0x00000004)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail_tgl_mask                    (0x00000002)
#define SYS_ACPU_BIST1_ST_adsp_bist1_done_mask                        (0x00000001)
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail6(data)                      (0x00000100&((data)<<8))
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail5(data)                      (0x00000080&((data)<<7))
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail4(data)                      (0x00000040&((data)<<6))
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail3(data)                      (0x00000020&((data)<<5))
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail2(data)                      (0x00000010&((data)<<4))
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail1(data)                      (0x00000008&((data)<<3))
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail0(data)                      (0x00000004&((data)<<2))
#define SYS_ACPU_BIST1_ST_adsp_bist1_fail_tgl(data)                   (0x00000002&((data)<<1))
#define SYS_ACPU_BIST1_ST_adsp_bist1_done(data)                       (0x00000001&(data))
#define SYS_ACPU_BIST1_ST_get_adsp_bist1_fail6(data)                  ((0x00000100&(data))>>8)
#define SYS_ACPU_BIST1_ST_get_adsp_bist1_fail5(data)                  ((0x00000080&(data))>>7)
#define SYS_ACPU_BIST1_ST_get_adsp_bist1_fail4(data)                  ((0x00000040&(data))>>6)
#define SYS_ACPU_BIST1_ST_get_adsp_bist1_fail3(data)                  ((0x00000020&(data))>>5)
#define SYS_ACPU_BIST1_ST_get_adsp_bist1_fail2(data)                  ((0x00000010&(data))>>4)
#define SYS_ACPU_BIST1_ST_get_adsp_bist1_fail1(data)                  ((0x00000008&(data))>>3)
#define SYS_ACPU_BIST1_ST_get_adsp_bist1_fail0(data)                  ((0x00000004&(data))>>2)
#define SYS_ACPU_BIST1_ST_get_adsp_bist1_fail_tgl(data)               ((0x00000002&(data))>>1)
#define SYS_ACPU_BIST1_ST_get_adsp_bist1_done(data)                   (0x00000001&(data))

#define SYS_ACPU_BIST2_ST                                             0x18000070
#define SYS_ACPU_BIST2_ST_reg_addr                                    "0xB8000070"
#define SYS_ACPU_BIST2_ST_reg                                         0xB8000070
#define SYS_ACPU_BIST2_ST_inst_addr                                   "0x001C"
#define SYS_ACPU_BIST2_ST_inst                                        0x001C
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail3_shift                      (5)
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail2_shift                      (4)
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail1_shift                      (3)
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail0_shift                      (2)
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail_tgl_shift                   (1)
#define SYS_ACPU_BIST2_ST_adsp_bist2_done_shift                       (0)
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail3_mask                       (0x00000020)
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail2_mask                       (0x00000010)
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail1_mask                       (0x00000008)
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail0_mask                       (0x00000004)
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail_tgl_mask                    (0x00000002)
#define SYS_ACPU_BIST2_ST_adsp_bist2_done_mask                        (0x00000001)
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail3(data)                      (0x00000020&((data)<<5))
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail2(data)                      (0x00000010&((data)<<4))
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail1(data)                      (0x00000008&((data)<<3))
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail0(data)                      (0x00000004&((data)<<2))
#define SYS_ACPU_BIST2_ST_adsp_bist2_fail_tgl(data)                   (0x00000002&((data)<<1))
#define SYS_ACPU_BIST2_ST_adsp_bist2_done(data)                       (0x00000001&(data))
#define SYS_ACPU_BIST2_ST_get_adsp_bist2_fail3(data)                  ((0x00000020&(data))>>5)
#define SYS_ACPU_BIST2_ST_get_adsp_bist2_fail2(data)                  ((0x00000010&(data))>>4)
#define SYS_ACPU_BIST2_ST_get_adsp_bist2_fail1(data)                  ((0x00000008&(data))>>3)
#define SYS_ACPU_BIST2_ST_get_adsp_bist2_fail0(data)                  ((0x00000004&(data))>>2)
#define SYS_ACPU_BIST2_ST_get_adsp_bist2_fail_tgl(data)               ((0x00000002&(data))>>1)
#define SYS_ACPU_BIST2_ST_get_adsp_bist2_done(data)                   (0x00000001&(data))

#define SYS_VCPU_BIST_ST                                              0x18000074
#define SYS_VCPU_BIST_ST_reg_addr                                     "0xB8000074"
#define SYS_VCPU_BIST_ST_reg                                          0xB8000074
#define SYS_VCPU_BIST_ST_inst_addr                                    "0x001D"
#define SYS_VCPU_BIST_ST_inst                                         0x001D
#define SYS_VCPU_BIST_ST_vcpu_bist_fail7_shift                        (9)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail6_shift                        (8)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail5_shift                        (7)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail4_shift                        (6)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail3_shift                        (5)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail2_shift                        (4)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail1_shift                        (3)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail0_shift                        (2)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail_tgl_shift                     (1)
#define SYS_VCPU_BIST_ST_vcpu_bist_done_shift                         (0)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail7_mask                         (0x00000200)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail6_mask                         (0x00000100)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail5_mask                         (0x00000080)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail4_mask                         (0x00000040)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail3_mask                         (0x00000020)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail2_mask                         (0x00000010)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail1_mask                         (0x00000008)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail0_mask                         (0x00000004)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail_tgl_mask                      (0x00000002)
#define SYS_VCPU_BIST_ST_vcpu_bist_done_mask                          (0x00000001)
#define SYS_VCPU_BIST_ST_vcpu_bist_fail7(data)                        (0x00000200&((data)<<9))
#define SYS_VCPU_BIST_ST_vcpu_bist_fail6(data)                        (0x00000100&((data)<<8))
#define SYS_VCPU_BIST_ST_vcpu_bist_fail5(data)                        (0x00000080&((data)<<7))
#define SYS_VCPU_BIST_ST_vcpu_bist_fail4(data)                        (0x00000040&((data)<<6))
#define SYS_VCPU_BIST_ST_vcpu_bist_fail3(data)                        (0x00000020&((data)<<5))
#define SYS_VCPU_BIST_ST_vcpu_bist_fail2(data)                        (0x00000010&((data)<<4))
#define SYS_VCPU_BIST_ST_vcpu_bist_fail1(data)                        (0x00000008&((data)<<3))
#define SYS_VCPU_BIST_ST_vcpu_bist_fail0(data)                        (0x00000004&((data)<<2))
#define SYS_VCPU_BIST_ST_vcpu_bist_fail_tgl(data)                     (0x00000002&((data)<<1))
#define SYS_VCPU_BIST_ST_vcpu_bist_done(data)                         (0x00000001&(data))
#define SYS_VCPU_BIST_ST_get_vcpu_bist_fail7(data)                    ((0x00000200&(data))>>9)
#define SYS_VCPU_BIST_ST_get_vcpu_bist_fail6(data)                    ((0x00000100&(data))>>8)
#define SYS_VCPU_BIST_ST_get_vcpu_bist_fail5(data)                    ((0x00000080&(data))>>7)
#define SYS_VCPU_BIST_ST_get_vcpu_bist_fail4(data)                    ((0x00000040&(data))>>6)
#define SYS_VCPU_BIST_ST_get_vcpu_bist_fail3(data)                    ((0x00000020&(data))>>5)
#define SYS_VCPU_BIST_ST_get_vcpu_bist_fail2(data)                    ((0x00000010&(data))>>4)
#define SYS_VCPU_BIST_ST_get_vcpu_bist_fail1(data)                    ((0x00000008&(data))>>3)
#define SYS_VCPU_BIST_ST_get_vcpu_bist_fail0(data)                    ((0x00000004&(data))>>2)
#define SYS_VCPU_BIST_ST_get_vcpu_bist_fail_tgl(data)                 ((0x00000002&(data))>>1)
#define SYS_VCPU_BIST_ST_get_vcpu_bist_done(data)                     (0x00000001&(data))

#define SYS_SCPU_BIST_ST                                              0x18000078
#define SYS_SCPU_BIST_ST_reg_addr                                     "0xB8000078"
#define SYS_SCPU_BIST_ST_reg                                          0xB8000078
#define SYS_SCPU_BIST_ST_inst_addr                                    "0x001E"
#define SYS_SCPU_BIST_ST_inst                                         0x001E
#define SYS_SCPU_BIST_ST_scpu_bist_fail5_shift                        (7)
#define SYS_SCPU_BIST_ST_scpu_bist_fail4_shift                        (6)
#define SYS_SCPU_BIST_ST_scpu_bist_fail3_shift                        (5)
#define SYS_SCPU_BIST_ST_scpu_bist_fail2_shift                        (4)
#define SYS_SCPU_BIST_ST_scpu_bist_fail1_shift                        (3)
#define SYS_SCPU_BIST_ST_scpu_bist_fail0_shift                        (2)
#define SYS_SCPU_BIST_ST_scpu_bist_fail_tgl_shift                     (1)
#define SYS_SCPU_BIST_ST_scpu_bist_done_shift                         (0)
#define SYS_SCPU_BIST_ST_scpu_bist_fail5_mask                         (0x00000080)
#define SYS_SCPU_BIST_ST_scpu_bist_fail4_mask                         (0x00000040)
#define SYS_SCPU_BIST_ST_scpu_bist_fail3_mask                         (0x00000020)
#define SYS_SCPU_BIST_ST_scpu_bist_fail2_mask                         (0x00000010)
#define SYS_SCPU_BIST_ST_scpu_bist_fail1_mask                         (0x00000008)
#define SYS_SCPU_BIST_ST_scpu_bist_fail0_mask                         (0x00000004)
#define SYS_SCPU_BIST_ST_scpu_bist_fail_tgl_mask                      (0x00000002)
#define SYS_SCPU_BIST_ST_scpu_bist_done_mask                          (0x00000001)
#define SYS_SCPU_BIST_ST_scpu_bist_fail5(data)                        (0x00000080&((data)<<7))
#define SYS_SCPU_BIST_ST_scpu_bist_fail4(data)                        (0x00000040&((data)<<6))
#define SYS_SCPU_BIST_ST_scpu_bist_fail3(data)                        (0x00000020&((data)<<5))
#define SYS_SCPU_BIST_ST_scpu_bist_fail2(data)                        (0x00000010&((data)<<4))
#define SYS_SCPU_BIST_ST_scpu_bist_fail1(data)                        (0x00000008&((data)<<3))
#define SYS_SCPU_BIST_ST_scpu_bist_fail0(data)                        (0x00000004&((data)<<2))
#define SYS_SCPU_BIST_ST_scpu_bist_fail_tgl(data)                     (0x00000002&((data)<<1))
#define SYS_SCPU_BIST_ST_scpu_bist_done(data)                         (0x00000001&(data))
#define SYS_SCPU_BIST_ST_get_scpu_bist_fail5(data)                    ((0x00000080&(data))>>7)
#define SYS_SCPU_BIST_ST_get_scpu_bist_fail4(data)                    ((0x00000040&(data))>>6)
#define SYS_SCPU_BIST_ST_get_scpu_bist_fail3(data)                    ((0x00000020&(data))>>5)
#define SYS_SCPU_BIST_ST_get_scpu_bist_fail2(data)                    ((0x00000010&(data))>>4)
#define SYS_SCPU_BIST_ST_get_scpu_bist_fail1(data)                    ((0x00000008&(data))>>3)
#define SYS_SCPU_BIST_ST_get_scpu_bist_fail0(data)                    ((0x00000004&(data))>>2)
#define SYS_SCPU_BIST_ST_get_scpu_bist_fail_tgl(data)                 ((0x00000002&(data))>>1)
#define SYS_SCPU_BIST_ST_get_scpu_bist_done(data)                     (0x00000001&(data))

#define SYS_PLL_ETN1                                                  0x1800007C
#define SYS_PLL_ETN1_reg_addr                                         "0xB800007C"
#define SYS_PLL_ETN1_reg                                              0xB800007C
#define SYS_PLL_ETN1_inst_addr                                        "0x001F"
#define SYS_PLL_ETN1_inst                                             0x001F
#define SYS_PLL_ETN1_plletn_bpn_shift                                 (29)
#define SYS_PLL_ETN1_plletn_n_shift                                   (25)
#define SYS_PLL_ETN1_plletn_m_shift                                   (18)
#define SYS_PLL_ETN1_plletn_p_shift                                   (14)
#define SYS_PLL_ETN1_plletn_ip_shift                                  (11)
#define SYS_PLL_ETN1_plletn_rs_shift                                  (9)
#define SYS_PLL_ETN1_plletn_cs_shift                                  (7)
#define SYS_PLL_ETN1_plletn_r3_shift                                  (6)
#define SYS_PLL_ETN1_plletn_c3_shift                                  (5)
#define SYS_PLL_ETN1_plletn_wdvr_shift                                (4)
#define SYS_PLL_ETN1_plletn_wdrst_shift                               (3)
#define SYS_PLL_ETN1_plletn_wdset_shift                               (2)
#define SYS_PLL_ETN1_plletn_tst_shift                                 (0)
#define SYS_PLL_ETN1_plletn_bpn_mask                                  (0x20000000)
#define SYS_PLL_ETN1_plletn_n_mask                                    (0x1E000000)
#define SYS_PLL_ETN1_plletn_m_mask                                    (0x01FC0000)
#define SYS_PLL_ETN1_plletn_p_mask                                    (0x0003C000)
#define SYS_PLL_ETN1_plletn_ip_mask                                   (0x00003800)
#define SYS_PLL_ETN1_plletn_rs_mask                                   (0x00000600)
#define SYS_PLL_ETN1_plletn_cs_mask                                   (0x00000180)
#define SYS_PLL_ETN1_plletn_r3_mask                                   (0x00000040)
#define SYS_PLL_ETN1_plletn_c3_mask                                   (0x00000020)
#define SYS_PLL_ETN1_plletn_wdvr_mask                                 (0x00000010)
#define SYS_PLL_ETN1_plletn_wdrst_mask                                (0x00000008)
#define SYS_PLL_ETN1_plletn_wdset_mask                                (0x00000004)
#define SYS_PLL_ETN1_plletn_tst_mask                                  (0x00000001)
#define SYS_PLL_ETN1_plletn_bpn(data)                                 (0x20000000&((data)<<29))
#define SYS_PLL_ETN1_plletn_n(data)                                   (0x1E000000&((data)<<25))
#define SYS_PLL_ETN1_plletn_m(data)                                   (0x01FC0000&((data)<<18))
#define SYS_PLL_ETN1_plletn_p(data)                                   (0x0003C000&((data)<<14))
#define SYS_PLL_ETN1_plletn_ip(data)                                  (0x00003800&((data)<<11))
#define SYS_PLL_ETN1_plletn_rs(data)                                  (0x00000600&((data)<<9))
#define SYS_PLL_ETN1_plletn_cs(data)                                  (0x00000180&((data)<<7))
#define SYS_PLL_ETN1_plletn_r3(data)                                  (0x00000040&((data)<<6))
#define SYS_PLL_ETN1_plletn_c3(data)                                  (0x00000020&((data)<<5))
#define SYS_PLL_ETN1_plletn_wdvr(data)                                (0x00000010&((data)<<4))
#define SYS_PLL_ETN1_plletn_wdrst(data)                               (0x00000008&((data)<<3))
#define SYS_PLL_ETN1_plletn_wdset(data)                               (0x00000004&((data)<<2))
#define SYS_PLL_ETN1_plletn_tst(data)                                 (0x00000001&(data))
#define SYS_PLL_ETN1_get_plletn_bpn(data)                             ((0x20000000&(data))>>29)
#define SYS_PLL_ETN1_get_plletn_n(data)                               ((0x1E000000&(data))>>25)
#define SYS_PLL_ETN1_get_plletn_m(data)                               ((0x01FC0000&(data))>>18)
#define SYS_PLL_ETN1_get_plletn_p(data)                               ((0x0003C000&(data))>>14)
#define SYS_PLL_ETN1_get_plletn_ip(data)                              ((0x00003800&(data))>>11)
#define SYS_PLL_ETN1_get_plletn_rs(data)                              ((0x00000600&(data))>>9)
#define SYS_PLL_ETN1_get_plletn_cs(data)                              ((0x00000180&(data))>>7)
#define SYS_PLL_ETN1_get_plletn_r3(data)                              ((0x00000040&(data))>>6)
#define SYS_PLL_ETN1_get_plletn_c3(data)                              ((0x00000020&(data))>>5)
#define SYS_PLL_ETN1_get_plletn_wdvr(data)                            ((0x00000010&(data))>>4)
#define SYS_PLL_ETN1_get_plletn_wdrst(data)                           ((0x00000008&(data))>>3)
#define SYS_PLL_ETN1_get_plletn_wdset(data)                           ((0x00000004&(data))>>2)
#define SYS_PLL_ETN1_get_plletn_tst(data)                             (0x00000001&(data))

#define SYS_PLL_ETN2                                                  0x18000080
#define SYS_PLL_ETN2_reg_addr                                         "0xB8000080"
#define SYS_PLL_ETN2_reg                                              0xB8000080
#define SYS_PLL_ETN2_inst_addr                                        "0x0020"
#define SYS_PLL_ETN2_inst                                             0x0020
#define SYS_PLL_ETN2_plletn_pwdn_shift                                (2)
#define SYS_PLL_ETN2_plletn_oeb_shift                                 (1)
#define SYS_PLL_ETN2_plletn_rstb_shift                                (0)
#define SYS_PLL_ETN2_plletn_pwdn_mask                                 (0x00000004)
#define SYS_PLL_ETN2_plletn_oeb_mask                                  (0x00000002)
#define SYS_PLL_ETN2_plletn_rstb_mask                                 (0x00000001)
#define SYS_PLL_ETN2_plletn_pwdn(data)                                (0x00000004&((data)<<2))
#define SYS_PLL_ETN2_plletn_oeb(data)                                 (0x00000002&((data)<<1))
#define SYS_PLL_ETN2_plletn_rstb(data)                                (0x00000001&(data))
#define SYS_PLL_ETN2_get_plletn_pwdn(data)                            ((0x00000004&(data))>>2)
#define SYS_PLL_ETN2_get_plletn_oeb(data)                             ((0x00000002&(data))>>1)
#define SYS_PLL_ETN2_get_plletn_rstb(data)                            (0x00000001&(data))

#define SYS_PLL_DISP1                                                 0x18000084
#define SYS_PLL_DISP1_reg_addr                                        "0xB8000084"
#define SYS_PLL_DISP1_reg                                             0xB8000084
#define SYS_PLL_DISP1_inst_addr                                       "0x0021"
#define SYS_PLL_DISP1_inst                                            0x0021
#define SYS_PLL_DISP1_plldisp_bpn_shift                               (28)
#define SYS_PLL_DISP1_plldisp_n_shift                                 (24)
#define SYS_PLL_DISP1_plldisp_m_shift                                 (17)
#define SYS_PLL_DISP1_plldisp_ip_shift                                (14)
#define SYS_PLL_DISP1_plldisp_rs_shift                                (12)
#define SYS_PLL_DISP1_plldisp_cs_shift                                (10)
#define SYS_PLL_DISP1_plldisp_r3_shift                                (9)
#define SYS_PLL_DISP1_plldisp_c3_shift                                (8)
#define SYS_PLL_DISP1_plldisp_wdvr_shift                              (7)
#define SYS_PLL_DISP1_plldisp_wdrst_shift                             (6)
#define SYS_PLL_DISP1_plldisp_wdset_shift                             (5)
#define SYS_PLL_DISP1_plldisp_tst_shift                               (3)
#define SYS_PLL_DISP1_plldisp_bpn_mask                                (0x10000000)
#define SYS_PLL_DISP1_plldisp_n_mask                                  (0x0F000000)
#define SYS_PLL_DISP1_plldisp_m_mask                                  (0x00FE0000)
#define SYS_PLL_DISP1_plldisp_ip_mask                                 (0x0001C000)
#define SYS_PLL_DISP1_plldisp_rs_mask                                 (0x00003000)
#define SYS_PLL_DISP1_plldisp_cs_mask                                 (0x00000C00)
#define SYS_PLL_DISP1_plldisp_r3_mask                                 (0x00000200)
#define SYS_PLL_DISP1_plldisp_c3_mask                                 (0x00000100)
#define SYS_PLL_DISP1_plldisp_wdvr_mask                               (0x00000080)
#define SYS_PLL_DISP1_plldisp_wdrst_mask                              (0x00000040)
#define SYS_PLL_DISP1_plldisp_wdset_mask                              (0x00000020)
#define SYS_PLL_DISP1_plldisp_tst_mask                                (0x00000008)
#define SYS_PLL_DISP1_plldisp_bpn(data)                               (0x10000000&((data)<<28))
#define SYS_PLL_DISP1_plldisp_n(data)                                 (0x0F000000&((data)<<24))
#define SYS_PLL_DISP1_plldisp_m(data)                                 (0x00FE0000&((data)<<17))
#define SYS_PLL_DISP1_plldisp_ip(data)                                (0x0001C000&((data)<<14))
#define SYS_PLL_DISP1_plldisp_rs(data)                                (0x00003000&((data)<<12))
#define SYS_PLL_DISP1_plldisp_cs(data)                                (0x00000C00&((data)<<10))
#define SYS_PLL_DISP1_plldisp_r3(data)                                (0x00000200&((data)<<9))
#define SYS_PLL_DISP1_plldisp_c3(data)                                (0x00000100&((data)<<8))
#define SYS_PLL_DISP1_plldisp_wdvr(data)                              (0x00000080&((data)<<7))
#define SYS_PLL_DISP1_plldisp_wdrst(data)                             (0x00000040&((data)<<6))
#define SYS_PLL_DISP1_plldisp_wdset(data)                             (0x00000020&((data)<<5))
#define SYS_PLL_DISP1_plldisp_tst(data)                               (0x00000008&((data)<<3))
#define SYS_PLL_DISP1_get_plldisp_bpn(data)                           ((0x10000000&(data))>>28)
#define SYS_PLL_DISP1_get_plldisp_n(data)                             ((0x0F000000&(data))>>24)
#define SYS_PLL_DISP1_get_plldisp_m(data)                             ((0x00FE0000&(data))>>17)
#define SYS_PLL_DISP1_get_plldisp_ip(data)                            ((0x0001C000&(data))>>14)
#define SYS_PLL_DISP1_get_plldisp_rs(data)                            ((0x00003000&(data))>>12)
#define SYS_PLL_DISP1_get_plldisp_cs(data)                            ((0x00000C00&(data))>>10)
#define SYS_PLL_DISP1_get_plldisp_r3(data)                            ((0x00000200&(data))>>9)
#define SYS_PLL_DISP1_get_plldisp_c3(data)                            ((0x00000100&(data))>>8)
#define SYS_PLL_DISP1_get_plldisp_wdvr(data)                          ((0x00000080&(data))>>7)
#define SYS_PLL_DISP1_get_plldisp_wdrst(data)                         ((0x00000040&(data))>>6)
#define SYS_PLL_DISP1_get_plldisp_wdset(data)                         ((0x00000020&(data))>>5)
#define SYS_PLL_DISP1_get_plldisp_tst(data)                           ((0x00000008&(data))>>3)

#define SYS_PLL_DISP2                                                 0x180000C0
#define SYS_PLL_DISP2_reg_addr                                        "0xB80000C0"
#define SYS_PLL_DISP2_reg                                             0xB80000C0
#define SYS_PLL_DISP2_inst_addr                                       "0x0030"
#define SYS_PLL_DISP2_inst                                            0x0030
#define SYS_PLL_DISP2_plldisp_pwdn_shift                              (2)
#define SYS_PLL_DISP2_plldisp_oeb_shift                               (1)
#define SYS_PLL_DISP2_plldisp_rstb_shift                              (0)
#define SYS_PLL_DISP2_plldisp_pwdn_mask                               (0x00000004)
#define SYS_PLL_DISP2_plldisp_oeb_mask                                (0x00000002)
#define SYS_PLL_DISP2_plldisp_rstb_mask                               (0x00000001)
#define SYS_PLL_DISP2_plldisp_pwdn(data)                              (0x00000004&((data)<<2))
#define SYS_PLL_DISP2_plldisp_oeb(data)                               (0x00000002&((data)<<1))
#define SYS_PLL_DISP2_plldisp_rstb(data)                              (0x00000001&(data))
#define SYS_PLL_DISP2_get_plldisp_pwdn(data)                          ((0x00000004&(data))>>2)
#define SYS_PLL_DISP2_get_plldisp_oeb(data)                           ((0x00000002&(data))>>1)
#define SYS_PLL_DISP2_get_plldisp_rstb(data)                          (0x00000001&(data))

#define SYS_PLL_CPU1                                                  0x18000088
#define SYS_PLL_CPU1_reg_addr                                         "0xB8000088"
#define SYS_PLL_CPU1_reg                                              0xB8000088
#define SYS_PLL_CPU1_inst_addr                                        "0x0022"
#define SYS_PLL_CPU1_inst                                             0x0022
#define SYS_PLL_CPU1_pllcpu_bpn_shift                                 (28)
#define SYS_PLL_CPU1_pllcpu_n_shift                                   (24)
#define SYS_PLL_CPU1_pllcpu_m_shift                                   (17)
#define SYS_PLL_CPU1_pllcpu_ip_shift                                  (14)
#define SYS_PLL_CPU1_pllcpu_rs_shift                                  (12)
#define SYS_PLL_CPU1_pllcpu_cs_shift                                  (10)
#define SYS_PLL_CPU1_pllcpu_r3_shift                                  (9)
#define SYS_PLL_CPU1_pllcpu_c3_shift                                  (8)
#define SYS_PLL_CPU1_pllcpu_wdvr_shift                                (7)
#define SYS_PLL_CPU1_pllcpu_wdrst_shift                               (6)
#define SYS_PLL_CPU1_pllcpu_wdset_shift                               (5)
#define SYS_PLL_CPU1_pllcpu_tst_shift                                 (3)
#define SYS_PLL_CPU1_pllcpu_bpn_mask                                  (0x10000000)
#define SYS_PLL_CPU1_pllcpu_n_mask                                    (0x0F000000)
#define SYS_PLL_CPU1_pllcpu_m_mask                                    (0x00FE0000)
#define SYS_PLL_CPU1_pllcpu_ip_mask                                   (0x0001C000)
#define SYS_PLL_CPU1_pllcpu_rs_mask                                   (0x00003000)
#define SYS_PLL_CPU1_pllcpu_cs_mask                                   (0x00000C00)
#define SYS_PLL_CPU1_pllcpu_r3_mask                                   (0x00000200)
#define SYS_PLL_CPU1_pllcpu_c3_mask                                   (0x00000100)
#define SYS_PLL_CPU1_pllcpu_wdvr_mask                                 (0x00000080)
#define SYS_PLL_CPU1_pllcpu_wdrst_mask                                (0x00000040)
#define SYS_PLL_CPU1_pllcpu_wdset_mask                                (0x00000020)
#define SYS_PLL_CPU1_pllcpu_tst_mask                                  (0x00000008)
#define SYS_PLL_CPU1_pllcpu_bpn(data)                                 (0x10000000&((data)<<28))
#define SYS_PLL_CPU1_pllcpu_n(data)                                   (0x0F000000&((data)<<24))
#define SYS_PLL_CPU1_pllcpu_m(data)                                   (0x00FE0000&((data)<<17))
#define SYS_PLL_CPU1_pllcpu_ip(data)                                  (0x0001C000&((data)<<14))
#define SYS_PLL_CPU1_pllcpu_rs(data)                                  (0x00003000&((data)<<12))
#define SYS_PLL_CPU1_pllcpu_cs(data)                                  (0x00000C00&((data)<<10))
#define SYS_PLL_CPU1_pllcpu_r3(data)                                  (0x00000200&((data)<<9))
#define SYS_PLL_CPU1_pllcpu_c3(data)                                  (0x00000100&((data)<<8))
#define SYS_PLL_CPU1_pllcpu_wdvr(data)                                (0x00000080&((data)<<7))
#define SYS_PLL_CPU1_pllcpu_wdrst(data)                               (0x00000040&((data)<<6))
#define SYS_PLL_CPU1_pllcpu_wdset(data)                               (0x00000020&((data)<<5))
#define SYS_PLL_CPU1_pllcpu_tst(data)                                 (0x00000008&((data)<<3))
#define SYS_PLL_CPU1_get_pllcpu_bpn(data)                             ((0x10000000&(data))>>28)
#define SYS_PLL_CPU1_get_pllcpu_n(data)                               ((0x0F000000&(data))>>24)
#define SYS_PLL_CPU1_get_pllcpu_m(data)                               ((0x00FE0000&(data))>>17)
#define SYS_PLL_CPU1_get_pllcpu_ip(data)                              ((0x0001C000&(data))>>14)
#define SYS_PLL_CPU1_get_pllcpu_rs(data)                              ((0x00003000&(data))>>12)
#define SYS_PLL_CPU1_get_pllcpu_cs(data)                              ((0x00000C00&(data))>>10)
#define SYS_PLL_CPU1_get_pllcpu_r3(data)                              ((0x00000200&(data))>>9)
#define SYS_PLL_CPU1_get_pllcpu_c3(data)                              ((0x00000100&(data))>>8)
#define SYS_PLL_CPU1_get_pllcpu_wdvr(data)                            ((0x00000080&(data))>>7)
#define SYS_PLL_CPU1_get_pllcpu_wdrst(data)                           ((0x00000040&(data))>>6)
#define SYS_PLL_CPU1_get_pllcpu_wdset(data)                           ((0x00000020&(data))>>5)
#define SYS_PLL_CPU1_get_pllcpu_tst(data)                             ((0x00000008&(data))>>3)

#define SYS_PLL_BUS1                                                  0x1800008C
#define SYS_PLL_BUS1_reg_addr                                         "0xB800008C"
#define SYS_PLL_BUS1_reg                                              0xB800008C
#define SYS_PLL_BUS1_inst_addr                                        "0x0023"
#define SYS_PLL_BUS1_inst                                             0x0023
#define SYS_PLL_BUS1_pllbus_bpn_shift                                 (31)
#define SYS_PLL_BUS1_pllbus_n_shift                                   (27)
#define SYS_PLL_BUS1_pllbus_m_shift                                   (20)
#define SYS_PLL_BUS1_pllbus_ip_shift                                  (17)
#define SYS_PLL_BUS1_pllbus_rs_shift                                  (15)
#define SYS_PLL_BUS1_pllbus_cs_shift                                  (13)
#define SYS_PLL_BUS1_pllbus_cp_shift                                  (11)
#define SYS_PLL_BUS1_pllbus_r3_shift                                  (10)
#define SYS_PLL_BUS1_pllbus_c3_shift                                  (9)
#define SYS_PLL_BUS1_pllbus_wdvr_shift                                (8)
#define SYS_PLL_BUS1_pllbus_wdrst_shift                               (7)
#define SYS_PLL_BUS1_pllbus_wdset_shift                               (6)
#define SYS_PLL_BUS1_pllbus_phrl_shift                                (4)
#define SYS_PLL_BUS1_pllbus_phrs_shift                                (1)
#define SYS_PLL_BUS1_pllbus_tst_shift                                 (0)
#define SYS_PLL_BUS1_pllbus_bpn_mask                                  (0x80000000)
#define SYS_PLL_BUS1_pllbus_n_mask                                    (0x78000000)
#define SYS_PLL_BUS1_pllbus_m_mask                                    (0x07F00000)
#define SYS_PLL_BUS1_pllbus_ip_mask                                   (0x000E0000)
#define SYS_PLL_BUS1_pllbus_rs_mask                                   (0x00018000)
#define SYS_PLL_BUS1_pllbus_cs_mask                                   (0x00006000)
#define SYS_PLL_BUS1_pllbus_cp_mask                                   (0x00001800)
#define SYS_PLL_BUS1_pllbus_r3_mask                                   (0x00000400)
#define SYS_PLL_BUS1_pllbus_c3_mask                                   (0x00000200)
#define SYS_PLL_BUS1_pllbus_wdvr_mask                                 (0x00000100)
#define SYS_PLL_BUS1_pllbus_wdrst_mask                                (0x00000080)
#define SYS_PLL_BUS1_pllbus_wdset_mask                                (0x00000040)
#define SYS_PLL_BUS1_pllbus_phrl_mask                                 (0x00000030)
#define SYS_PLL_BUS1_pllbus_phrs_mask                                 (0x0000000E)
#define SYS_PLL_BUS1_pllbus_tst_mask                                  (0x00000001)
#define SYS_PLL_BUS1_pllbus_bpn(data)                                 (0x80000000&((data)<<31))
#define SYS_PLL_BUS1_pllbus_n(data)                                   (0x78000000&((data)<<27))
#define SYS_PLL_BUS1_pllbus_m(data)                                   (0x07F00000&((data)<<20))
#define SYS_PLL_BUS1_pllbus_ip(data)                                  (0x000E0000&((data)<<17))
#define SYS_PLL_BUS1_pllbus_rs(data)                                  (0x00018000&((data)<<15))
#define SYS_PLL_BUS1_pllbus_cs(data)                                  (0x00006000&((data)<<13))
#define SYS_PLL_BUS1_pllbus_cp(data)                                  (0x00001800&((data)<<11))
#define SYS_PLL_BUS1_pllbus_r3(data)                                  (0x00000400&((data)<<10))
#define SYS_PLL_BUS1_pllbus_c3(data)                                  (0x00000200&((data)<<9))
#define SYS_PLL_BUS1_pllbus_wdvr(data)                                (0x00000100&((data)<<8))
#define SYS_PLL_BUS1_pllbus_wdrst(data)                               (0x00000080&((data)<<7))
#define SYS_PLL_BUS1_pllbus_wdset(data)                               (0x00000040&((data)<<6))
#define SYS_PLL_BUS1_pllbus_phrl(data)                                (0x00000030&((data)<<4))
#define SYS_PLL_BUS1_pllbus_phrs(data)                                (0x0000000E&((data)<<1))
#define SYS_PLL_BUS1_pllbus_tst(data)                                 (0x00000001&(data))
#define SYS_PLL_BUS1_get_pllbus_bpn(data)                             ((0x80000000&(data))>>31)
#define SYS_PLL_BUS1_get_pllbus_n(data)                               ((0x78000000&(data))>>27)
#define SYS_PLL_BUS1_get_pllbus_m(data)                               ((0x07F00000&(data))>>20)
#define SYS_PLL_BUS1_get_pllbus_ip(data)                              ((0x000E0000&(data))>>17)
#define SYS_PLL_BUS1_get_pllbus_rs(data)                              ((0x00018000&(data))>>15)
#define SYS_PLL_BUS1_get_pllbus_cs(data)                              ((0x00006000&(data))>>13)
#define SYS_PLL_BUS1_get_pllbus_cp(data)                              ((0x00001800&(data))>>11)
#define SYS_PLL_BUS1_get_pllbus_r3(data)                              ((0x00000400&(data))>>10)
#define SYS_PLL_BUS1_get_pllbus_c3(data)                              ((0x00000200&(data))>>9)
#define SYS_PLL_BUS1_get_pllbus_wdvr(data)                            ((0x00000100&(data))>>8)
#define SYS_PLL_BUS1_get_pllbus_wdrst(data)                           ((0x00000080&(data))>>7)
#define SYS_PLL_BUS1_get_pllbus_wdset(data)                           ((0x00000040&(data))>>6)
#define SYS_PLL_BUS1_get_pllbus_phrl(data)                            ((0x00000030&(data))>>4)
#define SYS_PLL_BUS1_get_pllbus_phrs(data)                            ((0x0000000E&(data))>>1)
#define SYS_PLL_BUS1_get_pllbus_tst(data)                             (0x00000001&(data))

#define SYS_PLL_BUS2                                                  0x18000090
#define SYS_PLL_BUS2_reg_addr                                         "0xB8000090"
#define SYS_PLL_BUS2_reg                                              0xB8000090
#define SYS_PLL_BUS2_inst_addr                                        "0x0024"
#define SYS_PLL_BUS2_inst                                             0x0024
#define SYS_PLL_BUS2_pllbus_ckpstst_shift                             (3)
#define SYS_PLL_BUS2_pllbus_pwdn_shift                                (2)
#define SYS_PLL_BUS2_pllbus_oeb_shift                                 (1)
#define SYS_PLL_BUS2_pllbus_rstb_shift                                (0)
#define SYS_PLL_BUS2_pllbus_ckpstst_mask                              (0x00000008)
#define SYS_PLL_BUS2_pllbus_pwdn_mask                                 (0x00000004)
#define SYS_PLL_BUS2_pllbus_oeb_mask                                  (0x00000002)
#define SYS_PLL_BUS2_pllbus_rstb_mask                                 (0x00000001)
#define SYS_PLL_BUS2_pllbus_ckpstst(data)                             (0x00000008&((data)<<3))
#define SYS_PLL_BUS2_pllbus_pwdn(data)                                (0x00000004&((data)<<2))
#define SYS_PLL_BUS2_pllbus_oeb(data)                                 (0x00000002&((data)<<1))
#define SYS_PLL_BUS2_pllbus_rstb(data)                                (0x00000001&(data))
#define SYS_PLL_BUS2_get_pllbus_ckpstst(data)                         ((0x00000008&(data))>>3)
#define SYS_PLL_BUS2_get_pllbus_pwdn(data)                            ((0x00000004&(data))>>2)
#define SYS_PLL_BUS2_get_pllbus_oeb(data)                             ((0x00000002&(data))>>1)
#define SYS_PLL_BUS2_get_pllbus_rstb(data)                            (0x00000001&(data))

#define SYS_PLL_DDR1                                                  0x18000094
#define SYS_PLL_DDR1_reg_addr                                         "0xB8000094"
#define SYS_PLL_DDR1_reg                                              0xB8000094
#define SYS_PLL_DDR1_inst_addr                                        "0x0025"
#define SYS_PLL_DDR1_inst                                             0x0025
#define SYS_PLL_DDR1_pllddr_bpn_shift                                 (31)
#define SYS_PLL_DDR1_pllddr_n_shift                                   (27)
#define SYS_PLL_DDR1_pllddr_m_shift                                   (20)
#define SYS_PLL_DDR1_pllddr_ip_shift                                  (17)
#define SYS_PLL_DDR1_pllddr_rs_shift                                  (15)
#define SYS_PLL_DDR1_pllddr_cs_shift                                  (13)
#define SYS_PLL_DDR1_pllddr_cp_shift                                  (11)
#define SYS_PLL_DDR1_pllddr_r3_shift                                  (10)
#define SYS_PLL_DDR1_pllddr_c3_shift                                  (9)
#define SYS_PLL_DDR1_pllddr_wdvr_shift                                (8)
#define SYS_PLL_DDR1_pllddr_wdrst_shift                               (7)
#define SYS_PLL_DDR1_pllddr_wdset_shift                               (6)
#define SYS_PLL_DDR1_pllddr_phrl_shift                                (4)
#define SYS_PLL_DDR1_pllddr_phrs_shift                                (1)
#define SYS_PLL_DDR1_pllddr_tst_shift                                 (0)
#define SYS_PLL_DDR1_pllddr_bpn_mask                                  (0x80000000)
#define SYS_PLL_DDR1_pllddr_n_mask                                    (0x78000000)
#define SYS_PLL_DDR1_pllddr_m_mask                                    (0x07F00000)
#define SYS_PLL_DDR1_pllddr_ip_mask                                   (0x000E0000)
#define SYS_PLL_DDR1_pllddr_rs_mask                                   (0x00018000)
#define SYS_PLL_DDR1_pllddr_cs_mask                                   (0x00006000)
#define SYS_PLL_DDR1_pllddr_cp_mask                                   (0x00001800)
#define SYS_PLL_DDR1_pllddr_r3_mask                                   (0x00000400)
#define SYS_PLL_DDR1_pllddr_c3_mask                                   (0x00000200)
#define SYS_PLL_DDR1_pllddr_wdvr_mask                                 (0x00000100)
#define SYS_PLL_DDR1_pllddr_wdrst_mask                                (0x00000080)
#define SYS_PLL_DDR1_pllddr_wdset_mask                                (0x00000040)
#define SYS_PLL_DDR1_pllddr_phrl_mask                                 (0x00000030)
#define SYS_PLL_DDR1_pllddr_phrs_mask                                 (0x0000000E)
#define SYS_PLL_DDR1_pllddr_tst_mask                                  (0x00000001)
#define SYS_PLL_DDR1_pllddr_bpn(data)                                 (0x80000000&((data)<<31))
#define SYS_PLL_DDR1_pllddr_n(data)                                   (0x78000000&((data)<<27))
#define SYS_PLL_DDR1_pllddr_m(data)                                   (0x07F00000&((data)<<20))
#define SYS_PLL_DDR1_pllddr_ip(data)                                  (0x000E0000&((data)<<17))
#define SYS_PLL_DDR1_pllddr_rs(data)                                  (0x00018000&((data)<<15))
#define SYS_PLL_DDR1_pllddr_cs(data)                                  (0x00006000&((data)<<13))
#define SYS_PLL_DDR1_pllddr_cp(data)                                  (0x00001800&((data)<<11))
#define SYS_PLL_DDR1_pllddr_r3(data)                                  (0x00000400&((data)<<10))
#define SYS_PLL_DDR1_pllddr_c3(data)                                  (0x00000200&((data)<<9))
#define SYS_PLL_DDR1_pllddr_wdvr(data)                                (0x00000100&((data)<<8))
#define SYS_PLL_DDR1_pllddr_wdrst(data)                               (0x00000080&((data)<<7))
#define SYS_PLL_DDR1_pllddr_wdset(data)                               (0x00000040&((data)<<6))
#define SYS_PLL_DDR1_pllddr_phrl(data)                                (0x00000030&((data)<<4))
#define SYS_PLL_DDR1_pllddr_phrs(data)                                (0x0000000E&((data)<<1))
#define SYS_PLL_DDR1_pllddr_tst(data)                                 (0x00000001&(data))
#define SYS_PLL_DDR1_get_pllddr_bpn(data)                             ((0x80000000&(data))>>31)
#define SYS_PLL_DDR1_get_pllddr_n(data)                               ((0x78000000&(data))>>27)
#define SYS_PLL_DDR1_get_pllddr_m(data)                               ((0x07F00000&(data))>>20)
#define SYS_PLL_DDR1_get_pllddr_ip(data)                              ((0x000E0000&(data))>>17)
#define SYS_PLL_DDR1_get_pllddr_rs(data)                              ((0x00018000&(data))>>15)
#define SYS_PLL_DDR1_get_pllddr_cs(data)                              ((0x00006000&(data))>>13)
#define SYS_PLL_DDR1_get_pllddr_cp(data)                              ((0x00001800&(data))>>11)
#define SYS_PLL_DDR1_get_pllddr_r3(data)                              ((0x00000400&(data))>>10)
#define SYS_PLL_DDR1_get_pllddr_c3(data)                              ((0x00000200&(data))>>9)
#define SYS_PLL_DDR1_get_pllddr_wdvr(data)                            ((0x00000100&(data))>>8)
#define SYS_PLL_DDR1_get_pllddr_wdrst(data)                           ((0x00000080&(data))>>7)
#define SYS_PLL_DDR1_get_pllddr_wdset(data)                           ((0x00000040&(data))>>6)
#define SYS_PLL_DDR1_get_pllddr_phrl(data)                            ((0x00000030&(data))>>4)
#define SYS_PLL_DDR1_get_pllddr_phrs(data)                            ((0x0000000E&(data))>>1)
#define SYS_PLL_DDR1_get_pllddr_tst(data)                             (0x00000001&(data))

#define SYS_PLL_DDR2                                                  0x18000098
#define SYS_PLL_DDR2_reg_addr                                         "0xB8000098"
#define SYS_PLL_DDR2_reg                                              0xB8000098
#define SYS_PLL_DDR2_inst_addr                                        "0x0026"
#define SYS_PLL_DDR2_inst                                             0x0026
#define SYS_PLL_DDR2_pllddr_ckpstst_shift                             (3)
#define SYS_PLL_DDR2_pllddr_pwdn_shift                                (2)
#define SYS_PLL_DDR2_pllddr_oeb_shift                                 (1)
#define SYS_PLL_DDR2_pllddr_rstb_shift                                (0)
#define SYS_PLL_DDR2_pllddr_ckpstst_mask                              (0x00000008)
#define SYS_PLL_DDR2_pllddr_pwdn_mask                                 (0x00000004)
#define SYS_PLL_DDR2_pllddr_oeb_mask                                  (0x00000002)
#define SYS_PLL_DDR2_pllddr_rstb_mask                                 (0x00000001)
#define SYS_PLL_DDR2_pllddr_ckpstst(data)                             (0x00000008&((data)<<3))
#define SYS_PLL_DDR2_pllddr_pwdn(data)                                (0x00000004&((data)<<2))
#define SYS_PLL_DDR2_pllddr_oeb(data)                                 (0x00000002&((data)<<1))
#define SYS_PLL_DDR2_pllddr_rstb(data)                                (0x00000001&(data))
#define SYS_PLL_DDR2_get_pllddr_ckpstst(data)                         ((0x00000008&(data))>>3)
#define SYS_PLL_DDR2_get_pllddr_pwdn(data)                            ((0x00000004&(data))>>2)
#define SYS_PLL_DDR2_get_pllddr_oeb(data)                             ((0x00000002&(data))>>1)
#define SYS_PLL_DDR2_get_pllddr_rstb(data)                            (0x00000001&(data))

#define SYS_PLL_1394                                                  0x1800009C
#define SYS_PLL_1394_reg_addr                                         "0xB800009C"
#define SYS_PLL_1394_reg                                              0xB800009C
#define SYS_PLL_1394_inst_addr                                        "0x0027"
#define SYS_PLL_1394_inst                                             0x0027
#define SYS_PLL_1394_audio441_oeb_shift                               (5)
#define SYS_PLL_1394_audio441_rstb_shift                              (4)
#define SYS_PLL_1394_audio48_oeb_shift                                (3)
#define SYS_PLL_1394_pll1394_pwdn_shift                               (2)
#define SYS_PLL_1394_pll1394_oeb_shift                                (1)
#define SYS_PLL_1394_pll1394_rstb_shift                               (0)
#define SYS_PLL_1394_audio441_oeb_mask                                (0x00000020)
#define SYS_PLL_1394_audio441_rstb_mask                               (0x00000010)
#define SYS_PLL_1394_audio48_oeb_mask                                 (0x00000008)
#define SYS_PLL_1394_pll1394_pwdn_mask                                (0x00000004)
#define SYS_PLL_1394_pll1394_oeb_mask                                 (0x00000002)
#define SYS_PLL_1394_pll1394_rstb_mask                                (0x00000001)
#define SYS_PLL_1394_audio441_oeb(data)                               (0x00000020&((data)<<5))
#define SYS_PLL_1394_audio441_rstb(data)                              (0x00000010&((data)<<4))
#define SYS_PLL_1394_audio48_oeb(data)                                (0x00000008&((data)<<3))
#define SYS_PLL_1394_pll1394_pwdn(data)                               (0x00000004&((data)<<2))
#define SYS_PLL_1394_pll1394_oeb(data)                                (0x00000002&((data)<<1))
#define SYS_PLL_1394_pll1394_rstb(data)                               (0x00000001&(data))
#define SYS_PLL_1394_get_audio441_oeb(data)                           ((0x00000020&(data))>>5)
#define SYS_PLL_1394_get_audio441_rstb(data)                          ((0x00000010&(data))>>4)
#define SYS_PLL_1394_get_audio48_oeb(data)                            ((0x00000008&(data))>>3)
#define SYS_PLL_1394_get_pll1394_pwdn(data)                           ((0x00000004&(data))>>2)
#define SYS_PLL_1394_get_pll1394_oeb(data)                            ((0x00000002&(data))>>1)
#define SYS_PLL_1394_get_pll1394_rstb(data)                           (0x00000001&(data))

#define SYS_PLL_BG                                                    0x180000A0
#define SYS_PLL_BG_reg_addr                                           "0xB80000A0"
#define SYS_PLL_BG_reg                                                0xB80000A0
#define SYS_PLL_BG_inst_addr                                          "0x0028"
#define SYS_PLL_BG_inst                                               0x0028
#define SYS_PLL_BG_bg_v12_shift                                       (22)
#define SYS_PLL_BG_bg_r_shift                                         (20)
#define SYS_PLL_BG_por_vset_shift                                     (18)
#define SYS_PLL_BG_plltst_sel_shift                                   (14)
#define SYS_PLL_BG_plltst_diven_shift                                 (13)
#define SYS_PLL_BG_plltst_div_shift                                   (11)
#define SYS_PLL_BG_pll_tpsel_shift                                    (8)
#define SYS_PLL_BG_pll_resv_shift                                     (0)
#define SYS_PLL_BG_bg_v12_mask                                        (0x00400000)
#define SYS_PLL_BG_bg_r_mask                                          (0x00300000)
#define SYS_PLL_BG_por_vset_mask                                      (0x000C0000)
#define SYS_PLL_BG_plltst_sel_mask                                    (0x0003C000)
#define SYS_PLL_BG_plltst_diven_mask                                  (0x00002000)
#define SYS_PLL_BG_plltst_div_mask                                    (0x00001800)
#define SYS_PLL_BG_pll_tpsel_mask                                     (0x00000700)
#define SYS_PLL_BG_pll_resv_mask                                      (0x000000FF)
#define SYS_PLL_BG_bg_v12(data)                                       (0x00400000&((data)<<22))
#define SYS_PLL_BG_bg_r(data)                                         (0x00300000&((data)<<20))
#define SYS_PLL_BG_por_vset(data)                                     (0x000C0000&((data)<<18))
#define SYS_PLL_BG_plltst_sel(data)                                   (0x0003C000&((data)<<14))
#define SYS_PLL_BG_plltst_diven(data)                                 (0x00002000&((data)<<13))
#define SYS_PLL_BG_plltst_div(data)                                   (0x00001800&((data)<<11))
#define SYS_PLL_BG_pll_tpsel(data)                                    (0x00000700&((data)<<8))
#define SYS_PLL_BG_pll_resv(data)                                     (0x000000FF&(data))
#define SYS_PLL_BG_get_bg_v12(data)                                   ((0x00400000&(data))>>22)
#define SYS_PLL_BG_get_bg_r(data)                                     ((0x00300000&(data))>>20)
#define SYS_PLL_BG_get_por_vset(data)                                 ((0x000C0000&(data))>>18)
#define SYS_PLL_BG_get_plltst_sel(data)                               ((0x0003C000&(data))>>14)
#define SYS_PLL_BG_get_plltst_diven(data)                             ((0x00002000&(data))>>13)
#define SYS_PLL_BG_get_plltst_div(data)                               ((0x00001800&(data))>>11)
#define SYS_PLL_BG_get_pll_tpsel(data)                                ((0x00000700&(data))>>8)
#define SYS_PLL_BG_get_pll_resv(data)                                 (0x000000FF&(data))

#define SYS_PLL_WDOUT                                                 0x180000A4
#define SYS_PLL_WDOUT_reg_addr                                        "0xB80000A4"
#define SYS_PLL_WDOUT_reg                                             0xB80000A4
#define SYS_PLL_WDOUT_inst_addr                                       "0x0029"
#define SYS_PLL_WDOUT_inst                                            0x0029
#define SYS_PLL_WDOUT_pll1394_wdout_shift                             (5)
#define SYS_PLL_WDOUT_plletn_wdout_shift                              (4)
#define SYS_PLL_WDOUT_plldisp_wdout_shift                             (3)
#define SYS_PLL_WDOUT_pllcpu_wdout_shift                              (2)
#define SYS_PLL_WDOUT_pllbus_wdout_shift                              (1)
#define SYS_PLL_WDOUT_pllddr_wdout_shift                              (0)
#define SYS_PLL_WDOUT_pll1394_wdout_mask                              (0x00000020)
#define SYS_PLL_WDOUT_plletn_wdout_mask                               (0x00000010)
#define SYS_PLL_WDOUT_plldisp_wdout_mask                              (0x00000008)
#define SYS_PLL_WDOUT_pllcpu_wdout_mask                               (0x00000004)
#define SYS_PLL_WDOUT_pllbus_wdout_mask                               (0x00000002)
#define SYS_PLL_WDOUT_pllddr_wdout_mask                               (0x00000001)
#define SYS_PLL_WDOUT_pll1394_wdout(data)                             (0x00000020&((data)<<5))
#define SYS_PLL_WDOUT_plletn_wdout(data)                              (0x00000010&((data)<<4))
#define SYS_PLL_WDOUT_plldisp_wdout(data)                             (0x00000008&((data)<<3))
#define SYS_PLL_WDOUT_pllcpu_wdout(data)                              (0x00000004&((data)<<2))
#define SYS_PLL_WDOUT_pllbus_wdout(data)                              (0x00000002&((data)<<1))
#define SYS_PLL_WDOUT_pllddr_wdout(data)                              (0x00000001&(data))
#define SYS_PLL_WDOUT_get_pll1394_wdout(data)                         ((0x00000020&(data))>>5)
#define SYS_PLL_WDOUT_get_plletn_wdout(data)                          ((0x00000010&(data))>>4)
#define SYS_PLL_WDOUT_get_plldisp_wdout(data)                         ((0x00000008&(data))>>3)
#define SYS_PLL_WDOUT_get_pllcpu_wdout(data)                          ((0x00000004&(data))>>2)
#define SYS_PLL_WDOUT_get_pllbus_wdout(data)                          ((0x00000002&(data))>>1)
#define SYS_PLL_WDOUT_get_pllddr_wdout(data)                          (0x00000001&(data))

#define SYS_CRT_DEBUG                                                 0x180000A8
#define SYS_CRT_DEBUG_reg_addr                                        "0xB80000A8"
#define SYS_CRT_DEBUG_reg                                             0xB80000A8
#define SYS_CRT_DEBUG_inst_addr                                       "0x002A"
#define SYS_CRT_DEBUG_inst                                            0x002A
#define SYS_CRT_DEBUG_crt_dbg_en_shift                                (4)
#define SYS_CRT_DEBUG_crt_dbg_sel0_shift                              (2)
#define SYS_CRT_DEBUG_crt_dbg_sel1_shift                              (0)
#define SYS_CRT_DEBUG_crt_dbg_en_mask                                 (0x00000010)
#define SYS_CRT_DEBUG_crt_dbg_sel0_mask                               (0x0000000C)
#define SYS_CRT_DEBUG_crt_dbg_sel1_mask                               (0x00000003)
#define SYS_CRT_DEBUG_crt_dbg_en(data)                                (0x00000010&((data)<<4))
#define SYS_CRT_DEBUG_crt_dbg_sel0(data)                              (0x0000000C&((data)<<2))
#define SYS_CRT_DEBUG_crt_dbg_sel1(data)                              (0x00000003&(data))
#define SYS_CRT_DEBUG_get_crt_dbg_en(data)                            ((0x00000010&(data))>>4)
#define SYS_CRT_DEBUG_get_crt_dbg_sel0(data)                          ((0x0000000C&(data))>>2)
#define SYS_CRT_DEBUG_get_crt_dbg_sel1(data)                          (0x00000003&(data))

#define SYS_DEBUG                                                     0x180000AC
#define SYS_DEBUG_reg_addr                                            "0xB80000AC"
#define SYS_DEBUG_reg                                                 0xB80000AC
#define SYS_DEBUG_inst_addr                                           "0x002B"
#define SYS_DEBUG_inst                                                0x002B
#define SYS_DEBUG_dbg_en_shift                                        (10)
#define SYS_DEBUG_dbg_sel0_shift                                      (5)
#define SYS_DEBUG_dbg_sel1_shift                                      (0)
#define SYS_DEBUG_dbg_en_mask                                         (0x00000400)
#define SYS_DEBUG_dbg_sel0_mask                                       (0x000003E0)
#define SYS_DEBUG_dbg_sel1_mask                                       (0x0000001F)
#define SYS_DEBUG_dbg_en(data)                                        (0x00000400&((data)<<10))
#define SYS_DEBUG_dbg_sel0(data)                                      (0x000003E0&((data)<<5))
#define SYS_DEBUG_dbg_sel1(data)                                      (0x0000001F&(data))
#define SYS_DEBUG_get_dbg_en(data)                                    ((0x00000400&(data))>>10)
#define SYS_DEBUG_get_dbg_sel0(data)                                  ((0x000003E0&(data))>>5)
#define SYS_DEBUG_get_dbg_sel1(data)                                  (0x0000001F&(data))

#define SYS_ADCDAC_SEL                                                0x180000B0
#define SYS_ADCDAC_SEL_reg_addr                                       "0xB80000B0"
#define SYS_ADCDAC_SEL_reg                                            0xB80000B0
#define SYS_ADCDAC_SEL_inst_addr                                      "0x002C"
#define SYS_ADCDAC_SEL_inst                                           0x002C
#define SYS_ADCDAC_SEL_adc_sel_shift                                  (3)
#define SYS_ADCDAC_SEL_dac_sel_shift                                  (0)
#define SYS_ADCDAC_SEL_adc_sel_mask                                   (0x00000018)
#define SYS_ADCDAC_SEL_dac_sel_mask                                   (0x00000007)
#define SYS_ADCDAC_SEL_adc_sel(data)                                  (0x00000018&((data)<<3))
#define SYS_ADCDAC_SEL_dac_sel(data)                                  (0x00000007&(data))
#define SYS_ADCDAC_SEL_get_adc_sel(data)                              ((0x00000018&(data))>>3)
#define SYS_ADCDAC_SEL_get_dac_sel(data)                              (0x00000007&(data))

#define SYS_PLL_1394_2                                                0x180000B4
#define SYS_PLL_1394_2_reg_addr                                       "0xB80000B4"
#define SYS_PLL_1394_2_reg                                            0xB80000B4
#define SYS_PLL_1394_2_inst_addr                                      "0x002D"
#define SYS_PLL_1394_2_inst                                           0x002D
#define SYS_PLL_1394_2_pll1394_sip_shift                              (14)
#define SYS_PLL_1394_2_pll1394_sr_shift                               (11)
#define SYS_PLL_1394_2_pll1394_sc1_shift                              (9)
#define SYS_PLL_1394_2_pll1394_sc2_shift                              (7)
#define SYS_PLL_1394_2_pll1394_wdrst_shift                            (6)
#define SYS_PLL_1394_2_pll1394_wdset_shift                            (5)
#define SYS_PLL_1394_2_pll1394_fupdn_shift                            (4)
#define SYS_PLL_1394_2_audio441_fupdn_shift                           (3)
#define SYS_PLL_1394_2_audio441_ctrl_shift                            (2)
#define SYS_PLL_1394_2_audio441_tst_shift                             (1)
#define SYS_PLL_1394_2_audio48_tst_shift                              (0)
#define SYS_PLL_1394_2_pll1394_sip_mask                               (0x0001C000)
#define SYS_PLL_1394_2_pll1394_sr_mask                                (0x00003800)
#define SYS_PLL_1394_2_pll1394_sc1_mask                               (0x00000600)
#define SYS_PLL_1394_2_pll1394_sc2_mask                               (0x00000180)
#define SYS_PLL_1394_2_pll1394_wdrst_mask                             (0x00000040)
#define SYS_PLL_1394_2_pll1394_wdset_mask                             (0x00000020)
#define SYS_PLL_1394_2_pll1394_fupdn_mask                             (0x00000010)
#define SYS_PLL_1394_2_audio441_fupdn_mask                            (0x00000008)
#define SYS_PLL_1394_2_audio441_ctrl_mask                             (0x00000004)
#define SYS_PLL_1394_2_audio441_tst_mask                              (0x00000002)
#define SYS_PLL_1394_2_audio48_tst_mask                               (0x00000001)
#define SYS_PLL_1394_2_pll1394_sip(data)                              (0x0001C000&((data)<<14))
#define SYS_PLL_1394_2_pll1394_sr(data)                               (0x00003800&((data)<<11))
#define SYS_PLL_1394_2_pll1394_sc1(data)                              (0x00000600&((data)<<9))
#define SYS_PLL_1394_2_pll1394_sc2(data)                              (0x00000180&((data)<<7))
#define SYS_PLL_1394_2_pll1394_wdrst(data)                            (0x00000040&((data)<<6))
#define SYS_PLL_1394_2_pll1394_wdset(data)                            (0x00000020&((data)<<5))
#define SYS_PLL_1394_2_pll1394_fupdn(data)                            (0x00000010&((data)<<4))
#define SYS_PLL_1394_2_audio441_fupdn(data)                           (0x00000008&((data)<<3))
#define SYS_PLL_1394_2_audio441_ctrl(data)                            (0x00000004&((data)<<2))
#define SYS_PLL_1394_2_audio441_tst(data)                             (0x00000002&((data)<<1))
#define SYS_PLL_1394_2_audio48_tst(data)                              (0x00000001&(data))
#define SYS_PLL_1394_2_get_pll1394_sip(data)                          ((0x0001C000&(data))>>14)
#define SYS_PLL_1394_2_get_pll1394_sr(data)                           ((0x00003800&(data))>>11)
#define SYS_PLL_1394_2_get_pll1394_sc1(data)                          ((0x00000600&(data))>>9)
#define SYS_PLL_1394_2_get_pll1394_sc2(data)                          ((0x00000180&(data))>>7)
#define SYS_PLL_1394_2_get_pll1394_wdrst(data)                        ((0x00000040&(data))>>6)
#define SYS_PLL_1394_2_get_pll1394_wdset(data)                        ((0x00000020&(data))>>5)
#define SYS_PLL_1394_2_get_pll1394_fupdn(data)                        ((0x00000010&(data))>>4)
#define SYS_PLL_1394_2_get_audio441_fupdn(data)                       ((0x00000008&(data))>>3)
#define SYS_PLL_1394_2_get_audio441_ctrl(data)                        ((0x00000004&(data))>>2)
#define SYS_PLL_1394_2_get_audio441_tst(data)                         ((0x00000002&(data))>>1)
#define SYS_PLL_1394_2_get_audio48_tst(data)                          (0x00000001&(data))

#define SYS_PLL_DIV                                                   0x180000B8
#define SYS_PLL_DIV_reg_addr                                          "0xB80000B8"
#define SYS_PLL_DIV_reg                                               0xB80000B8
#define SYS_PLL_DIV_inst_addr                                         "0x002E"
#define SYS_PLL_DIV_inst                                              0x002E
#define SYS_PLL_DIV_acpu_freq_sel_shift                               (2)
#define SYS_PLL_DIV_ddr_freq_sel_shift                                (1)
#define SYS_PLL_DIV_bus_freq_sel_shift                                (0)
#define SYS_PLL_DIV_acpu_freq_sel_mask                                (0x00000004)
#define SYS_PLL_DIV_ddr_freq_sel_mask                                 (0x00000002)
#define SYS_PLL_DIV_bus_freq_sel_mask                                 (0x00000001)
#define SYS_PLL_DIV_acpu_freq_sel(data)                               (0x00000004&((data)<<2))
#define SYS_PLL_DIV_ddr_freq_sel(data)                                (0x00000002&((data)<<1))
#define SYS_PLL_DIV_bus_freq_sel(data)                                (0x00000001&(data))
#define SYS_PLL_DIV_get_acpu_freq_sel(data)                           ((0x00000004&(data))>>2)
#define SYS_PLL_DIV_get_ddr_freq_sel(data)                            ((0x00000002&(data))>>1)
#define SYS_PLL_DIV_get_bus_freq_sel(data)                            (0x00000001&(data))

#define SYS_TVD_CLKINV                                                0x180000BC
#define SYS_TVD_CLKINV_reg_addr                                       "0xB80000BC"
#define SYS_TVD_CLKINV_reg                                            0xB80000BC
#define SYS_TVD_CLKINV_inst_addr                                      "0x002F"
#define SYS_TVD_CLKINV_inst                                           0x002F
#define SYS_TVD_CLKINV_inv_shift                                      (0)
#define SYS_TVD_CLKINV_inv_mask                                       (0x00000001)
#define SYS_TVD_CLKINV_inv(data)                                      (0x00000001&(data))
#define SYS_TVD_CLKINV_get_inv(data)                                  (0x00000001&(data))

#define SYS_PLL_CPU2                                                  0x180000C8
#define SYS_PLL_CPU2_reg_addr                                         "0xB80000C8"
#define SYS_PLL_CPU2_reg                                              0xB80000C8
#define SYS_PLL_CPU2_inst_addr                                        "0x0032"
#define SYS_PLL_CPU2_inst                                             0x0032
#define SYS_PLL_CPU2_pllcpu_pwdn_shift                                (2)
#define SYS_PLL_CPU2_pllcpu_oeb_shift                                 (1)
#define SYS_PLL_CPU2_pllcpu_rstb_shift                                (0)
#define SYS_PLL_CPU2_pllcpu_pwdn_mask                                 (0x00000004)
#define SYS_PLL_CPU2_pllcpu_oeb_mask                                  (0x00000002)
#define SYS_PLL_CPU2_pllcpu_rstb_mask                                 (0x00000001)
#define SYS_PLL_CPU2_pllcpu_pwdn(data)                                (0x00000004&((data)<<2))
#define SYS_PLL_CPU2_pllcpu_oeb(data)                                 (0x00000002&((data)<<1))
#define SYS_PLL_CPU2_pllcpu_rstb(data)                                (0x00000001&(data))
#define SYS_PLL_CPU2_get_pllcpu_pwdn(data)                            ((0x00000004&(data))>>2)
#define SYS_PLL_CPU2_get_pllcpu_oeb(data)                             ((0x00000002&(data))>>1)
#define SYS_PLL_CPU2_get_pllcpu_rstb(data)                            (0x00000001&(data))
#endif
