// This file is generated using the spec version 0.4.3, firmware template version 1.39and DVR_Parser_0.46
#ifndef _TVE_REG_H_INCLUDED_
#define _TVE_REG_H_INCLUDED_

//#define  _TVE_USE_STRUCT
#ifdef _TVE_USE_STRUCT

typedef struct
{
    unsigned int    write_enable5:1;
    unsigned int    i_p_req:1;
    unsigned int    write_enable4:1;
    unsigned int    sgen:1;
    unsigned int    write_enable3:1;
    unsigned int    i_p_sel:1;
    unsigned int    write_enable2:1;
    unsigned int    v_thr:11;
    unsigned int    write_enable1:1;
    unsigned int    h_thr:13;
}tve_SYNCGEN_CTRL;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable2:1;
    unsigned int    ip_vsync_pos1:10;
    unsigned int    write_enable1:1;
    unsigned int    ip_vsync_pos2:10;
}tve_IP_VSYNCPOS;

typedef struct
{
    unsigned int    reserved_0:9;
    unsigned int    i_field:1;
    unsigned int    i_vcnt:11;
    unsigned int    p_vcnt:11;
}tve_SYNCGEN_STATUS;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    write_enable2:1;
    unsigned int    i_h_st:13;
    unsigned int    write_enable1:1;
    unsigned int    i_h_end:13;
}tve_I_HPOS;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    write_enable2:1;
    unsigned int    p_h_st:13;
    unsigned int    write_enable1:1;
    unsigned int    p_h_end:13;
}tve_P_HPOS;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable2:1;
    unsigned int    itop_v_st:11;
    unsigned int    write_enable1:1;
    unsigned int    itop_v_end:11;
}tve_ITOP_VPOS;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable2:1;
    unsigned int    ibot_v_st:11;
    unsigned int    write_enable1:1;
    unsigned int    ibot_v_end:11;
}tve_IBOT_VPOS;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable2:1;
    unsigned int    p_v_st:11;
    unsigned int    write_enable1:1;
    unsigned int    p_v_end:11;
}tve_P_VPOS;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    write_enable2:1;
    unsigned int    hact_start:13;
    unsigned int    write_enable1:1;
    unsigned int    hact_end:13;
}tve_DIF_HACTIVE;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable2:1;
    unsigned int    gain_lsb:11;
    unsigned int    write_enable1:1;
    unsigned int    gain_msb:4;
    unsigned int    reserved_1:2;
    unsigned int    vbi_gain_ebl:1;
    unsigned int    offset_msb:4;
}tve_VBI_GAIN;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable2:1;
    unsigned int    offset_lsb:11;
    unsigned int    write_enable1:1;
    unsigned int    ip_sync_vthr:11;
}tve_VBI_OFFSET;

typedef struct
{
    unsigned int    reserved_0:13;
    unsigned int    write_enable5:1;
    unsigned int    i_en:1;
    unsigned int    write_enable4:1;
    unsigned int    p_en:1;
    unsigned int    write_enable3:1;
    unsigned int    i_slewrate:2;
    unsigned int    write_enable2:1;
    unsigned int    p_slewrate:2;
    unsigned int    write_enable1:1;
    unsigned int    y_black_level:8;
}tve_SLEW_CTTL;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    i_colorbar_ebl:1;
    unsigned int    p_colorbar_ebl:1;
    unsigned int    i_blackpic_ebl:1;
    unsigned int    p_blackpic_ebl:1;
    unsigned int    write_data:1;
}tve_SRC_CTRL;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable2:1;
    unsigned int    i_h_width:10;
    unsigned int    write_enable1:1;
    unsigned int    i_h_st_pos:10;
}tve_I_COLOR_BAR;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable2:1;
    unsigned int    p_h_width:10;
    unsigned int    write_enable1:1;
    unsigned int    p_h_st_pos:10;
}tve_P_COLOR_BAR;

typedef struct
{
    unsigned int    reserved_0:5;
    unsigned int    write_enable4:1;
    unsigned int    cgms_1080i_ebl:1;
    unsigned int    write_enable3:1;
    unsigned int    cgms_i_ebl:1;
    unsigned int    write_enable2:1;
    unsigned int    cgms_p_ebl:1;
    unsigned int    write_enable1:1;
    unsigned int    cgms_data:20;
}tve_CGMS_DATA;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable2:1;
    unsigned int    cgms_i_hst:10;
    unsigned int    write_enable1:1;
    unsigned int    cgms_i_len:10;
}tve_CGMS_I_HPOS;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    write_enable3:1;
    unsigned int    cgms_p_lvl:8;
    unsigned int    write_enable2:1;
    unsigned int    cgms_p_hst:10;
    unsigned int    write_enable1:1;
    unsigned int    cgms_p_len:10;
}tve_CGMS_P_HPOS;

typedef struct
{
    unsigned int    write_enable3:1;
    unsigned int    cgms_p_vpos:10;
    unsigned int    write_enable2:1;
    unsigned int    cgms_i_vpos1:9;
    unsigned int    write_enable1:1;
    unsigned int    cgms_i_vpos2:10;
}tve_CGMS_VPOS;

typedef struct
{
    unsigned int    reserved_0:13;
    unsigned int    write_enable3:1;
    unsigned int    wss_ebl:1;
    unsigned int    write_enable2:1;
    unsigned int    wss_intp_sel:1;
    unsigned int    write_enable1:1;
    unsigned int    wss_data:14;
}tve_WSS_DATA;

typedef struct
{
    unsigned int    reserved_0:9;
    unsigned int    write_enable2:1;
    unsigned int    wss_h_pos:11;
    unsigned int    write_enable1:1;
    unsigned int    wss_v_pos:10;
}tve_WSS_POS;

typedef struct
{
    unsigned int    reserved_0:21;
    unsigned int    wss_end_hpos:11;
}tve_WSS_END_HPOS;

typedef struct
{
    unsigned int    reserved_0:7;
    unsigned int    write_enable4:1;
    unsigned int    tt_h_st:11;
    unsigned int    write_enable3:1;
    unsigned int    tt_line_no:8;
    unsigned int    write_enable2:1;
    unsigned int    tt_intp_sel:1;
    unsigned int    write_enable1:1;
    unsigned int    vbi_tt_ebl:1;
}tve_TT_CTRL;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    write_enable2:1;
    unsigned int    tt_b_vst:9;
    unsigned int    write_enable1:1;
    unsigned int    tt_t_vst:5;
}tve_TT_VSTART;

typedef struct
{
    unsigned int    write_enable4:1;
    unsigned int    dwn_ebl:2;
    unsigned int    write_enable3:1;
    unsigned int    dwn_i_p_sel:1;
    unsigned int    write_enable2:1;
    unsigned int    dwn_st:12;
    unsigned int    write_enable1:1;
    unsigned int    dwn_end:13;
}tve_VBI_DWN_CTRL;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable2:1;
    unsigned int    vbi_start_line2:11;
    unsigned int    write_enable1:1;
    unsigned int    vbi_start_line1:11;
}tve_VBI_START_LINE;

typedef struct
{
    unsigned int    vbi_line_flg:32;
}tve_VBI_LINE_FLG0;

typedef struct
{
    unsigned int    vbi_line_flg:32;
}tve_VBI_LINE_FLG1;

typedef struct
{
    unsigned int    vbi_pty:32;
}tve_VBI_LINE_PTY0;

typedef struct
{
    unsigned int    vbi_pty:32;
}tve_VBI_LINE_PTY1;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable2:1;
    unsigned int    start_line2:11;
    unsigned int    write_enable1:1;
    unsigned int    start_line1:11;
}tve_TT_MASK_START_LINE;

typedef struct
{
    unsigned int    tt_line_mask:32;
}tve_TT_MASK_LINE1;

typedef struct
{
    unsigned int    tt_line_mask:32;
}tve_TT_MASK_LINE2;

typedef struct
{
    unsigned int    reserved_0:5;
    unsigned int    write_enable4:1;
    unsigned int    vps_h_pos:11;
    unsigned int    write_enable3:1;
    unsigned int    vps_v_pos:10;
    unsigned int    write_enable2:1;
    unsigned int    vps_intp_sel:1;
    unsigned int    write_enable1:1;
    unsigned int    vbi_vps_ebl:1;
}tve_VPS_CTRL;

typedef struct
{
    unsigned int    vps_data1:32;
}tve_VPS_DATA1;

typedef struct
{
    unsigned int    vps_data2:32;
}tve_VPS_DATA2;

typedef struct
{
    unsigned int    vps_data3:32;
}tve_VPS_DATA3;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    vps_data4:8;
}tve_VPS_DATA4;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    fir422_sel:2;
}tve_CAV_422;

typedef struct
{
    unsigned int    reserved_0:2;
    unsigned int    write_enable3:1;
    unsigned int    negsyncst:9;
    unsigned int    write_enable2:1;
    unsigned int    possyncst:9;
    unsigned int    write_enable1:1;
    unsigned int    syncend:9;
}tve_COMP_SYNCPOS;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    write_enable2:1;
    unsigned int    ser_hstart:13;
    unsigned int    write_enable1:1;
    unsigned int    ser_hend:13;
}tve_SER_HPOS;

typedef struct
{
    unsigned int    reserved_0:20;
    unsigned int    write_enable2:1;
    unsigned int    ser_vstart:5;
    unsigned int    write_enable1:1;
    unsigned int    ser_vend:5;
}tve_SER_VPOS;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable4:1;
    unsigned int    dsync_t_vstart:5;
    unsigned int    write_enable3:1;
    unsigned int    dsync_t_vend:5;
    unsigned int    write_enable2:1;
    unsigned int    dsync_b_vstart:5;
    unsigned int    write_enable1:1;
    unsigned int    dsync_b_vend:5;
}tve_DSYNC_VPOS;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    mv_ebl:1;
}tve_MV_CTL;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    mv_rd:20;
}tve_MV_RD;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    mv_dn:20;
}tve_MV_DN;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    mv_ru:20;
}tve_MV_RU;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    mv_up:20;
}tve_MV_UP;

typedef struct
{
    unsigned int    reserved_0:2;
    unsigned int    write_enable4:1;
    unsigned int    mv_st_ps:8;
    unsigned int    write_enable3:1;
    unsigned int    mv_ps_len:6;
    unsigned int    write_enable2:1;
    unsigned int    mv_agc_len:6;
    unsigned int    write_enable1:1;
    unsigned int    mv_blnk_len:6;
}tve_PROG_MV_LEN;

typedef struct
{
    unsigned int    reserved_0:18;
    unsigned int    write_enable2:1;
    unsigned int    mv_end_line:6;
    unsigned int    write_enable1:1;
    unsigned int    mv_st_line:6;
}tve_PROG_MV_LINE;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    write_enable3:1;
    unsigned int    mv_ru_dlt:8;
    unsigned int    write_enable2:1;
    unsigned int    mv_rd_dlt:8;
    unsigned int    write_enable1:1;
    unsigned int    mv_stn:12;
}tve_PROG_MV_STN;

typedef struct
{
    unsigned int    write_enable2:1;
    unsigned int    c2:15;
    unsigned int    write_enable1:1;
    unsigned int    c1:15;
}tve_CONV_COEFS1;

typedef struct
{
    unsigned int    write_enable2:1;
    unsigned int    c4:15;
    unsigned int    write_enable1:1;
    unsigned int    c3:15;
}tve_CONV_COEFS2;

typedef struct
{
    unsigned int    write_enable2:1;
    unsigned int    c6:15;
    unsigned int    write_enable1:1;
    unsigned int    c5:15;
}tve_CONV_COEFS3;

typedef struct
{
    unsigned int    write_enable2:1;
    unsigned int    k2:15;
    unsigned int    write_enable1:1;
    unsigned int    k1:15;
}tve_CONV_COEFS4;

typedef struct
{
    unsigned int    reserved_0:17;
    unsigned int    k3:15;
}tve_CONV_COEFS5;

typedef struct
{
    unsigned int    write_enable2:1;
    unsigned int    gain:15;
    unsigned int    write_enable1:1;
    unsigned int    offset:15;
}tve_MVVBI_CONV;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    write_enable4:1;
    unsigned int    slewrate:2;
    unsigned int    write_enable3:1;
    unsigned int    hdsync:1;
    unsigned int    write_enable2:1;
    unsigned int    y_negsynclvl:12;
    unsigned int    write_enable1:1;
    unsigned int    y_possynclvl:12;
}tve_COMP_SYNCLVL;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    write_enable3:1;
    unsigned int    syncmod_sel:1;
    unsigned int    write_enable2:1;
    unsigned int    comp_sync_high:12;
    unsigned int    write_enable1:1;
    unsigned int    comp_sync_mid:12;
}tve_COMP_SLEW_SEL0;

typedef struct
{
    unsigned int    reserved_0:20;
    unsigned int    comp_sync_low:12;
}tve_COMP_SLEW_SEL1;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    write_enable2:1;
    unsigned int    pbpr_negsynclvl:12;
    unsigned int    write_enable1:1;
    unsigned int    pbpr_possynclvl:12;
}tve_PBPR_SYNCLVL;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    write_enable2:1;
    unsigned int    y_blank_lvl:12;
    unsigned int    write_enable1:1;
    unsigned int    pbpr_blank_lvl:12;
}tve_BLANK_LVL;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    write_enable2:1;
    unsigned int    g_up_lvl:12;
    unsigned int    write_enable1:1;
    unsigned int    g_down_lvl:12;
}tve_G_CLAMP_LVL;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    write_enable2:1;
    unsigned int    rb_up_lvl:12;
    unsigned int    write_enable1:1;
    unsigned int    rb_down_lvl:12;
}tve_RB_CLAMP_LVL;

typedef struct
{
    unsigned int    reserved_0:17;
    unsigned int    write_enable2:1;
    unsigned int    rgb_mod:1;
    unsigned int    write_enable1:1;
    unsigned int    bp_lvl:12;
}tve_BP_LVL;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    di_vbi_bypass:1;
    unsigned int    di_ebl:1;
    unsigned int    di_source_sel:1;
    unsigned int    di_mod:1;
    unsigned int    di_hdr_ebl:1;
    unsigned int    di_i_p_sel:1;
    unsigned int    write_data:1;
}tve_DIF_CTRL;

typedef struct
{
    unsigned int    reserved_0:2;
    unsigned int    write_enable3:1;
    unsigned int    hs_polar:1;
    unsigned int    write_enable2:1;
    unsigned int    hs_start:13;
    unsigned int    write_enable1:1;
    unsigned int    hs_end:13;
}tve_DIF_HSYNC;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    write_enable3:1;
    unsigned int    vs_polar:1;
    unsigned int    write_enable2:1;
    unsigned int    vs_st_pos1v:11;
    unsigned int    write_enable1:1;
    unsigned int    vs_st_pos1h:13;
}tve_DIF_VS_ST_POS1;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    write_enable2:1;
    unsigned int    vs_end_pos1v:11;
    unsigned int    write_enable1:1;
    unsigned int    vs_end_pos1h:13;
}tve_DIF_VS_END_POS1;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    write_enable2:1;
    unsigned int    vs_st_pos2v:11;
    unsigned int    write_enable1:1;
    unsigned int    vs_st_pos2h:13;
}tve_DIF_VS_ST_POS2;

typedef struct
{
    unsigned int    reserved_0:6;
    unsigned int    write_enable2:1;
    unsigned int    vs_end_pos2v:11;
    unsigned int    write_enable1:1;
    unsigned int    vs_end_pos2h:13;
}tve_DIF_VS_END_POS2;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable2:1;
    unsigned int    v_tgl_hi:11;
    unsigned int    write_enable1:1;
    unsigned int    v_tgl_lo:11;
}tve_DIF_F_BIT_POS;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable2:1;
    unsigned int    v_tgl1_hi:11;
    unsigned int    write_enable1:1;
    unsigned int    v_tgl1_lo:11;
}tve_DIF_V_BIT_POS1;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    write_enable2:1;
    unsigned int    v_tgl2_hi:11;
    unsigned int    write_enable1:1;
    unsigned int    v_tgl2_lo:11;
}tve_DIF_V_BIT_POS2;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    write_enable3:1;
    unsigned int    ygdelay:2;
    unsigned int    write_enable2:1;
    unsigned int    bdelay:2;
    unsigned int    write_enable1:1;
    unsigned int    rdelay:2;
}tve_CMP_DLY;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    write_enable4:1;
    unsigned int    up_ctrl:1;
    unsigned int    write_enable3:1;
    unsigned int    dacmode:2;
    unsigned int    write_enable2:1;
    unsigned int    swap23:1;
    unsigned int    write_enable1:1;
    unsigned int    swap56:1;
}tve_DAC_MUX;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable3:1;
    unsigned int    neg_out:6;
    unsigned int    write_enable2:1;
    unsigned int    out_control:1;
    unsigned int    write_enable1:1;
    unsigned int    dac_value:12;
}tve_DAC_CONTROL;

typedef struct
{
    unsigned int    reserved_0:11;
    unsigned int    apow:1;
    unsigned int    bpow:1;
    unsigned int    cpow:1;
    unsigned int    ckmode:1;
    unsigned int    powbias:1;
    unsigned int    sbias_all:4;
    unsigned int    sbias_a:4;
    unsigned int    sbias_b:4;
    unsigned int    sbias_c:4;
}tve_VIDEO_DAC_CTRL0;

typedef struct
{
    unsigned int    reserved_0:11;
    unsigned int    apow:1;
    unsigned int    bpow:1;
    unsigned int    cpow:1;
    unsigned int    ckmode:1;
    unsigned int    powbias:1;
    unsigned int    sbias_all:4;
    unsigned int    sbias_a:4;
    unsigned int    sbias_b:4;
    unsigned int    sbias_c:4;
}tve_VIDEO_DAC_CTRL1;

typedef struct
{
    unsigned int    reserved_0:21;
    unsigned int    di_clk_phs:1;
    unsigned int    comp_ebl:1;
    unsigned int    sdtv_ebl:1;
    unsigned int    comp_sel:1;
    unsigned int    mv_rb_ebl:1;
    unsigned int    mv_g_ebl:1;
    unsigned int    vbi_rb_ebl:1;
    unsigned int    vbi_g_ebl:1;
    unsigned int    sync_rb_ebl:1;
    unsigned int    sync_g_ebl:1;
    unsigned int    write_data:1;
}tve_CTRL;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    inten:1;
}tve_INTEN;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    intst:1;
}tve_INTST;

typedef struct
{
    unsigned int    reserved_0:4;
    unsigned int    write_enable3:1;
    unsigned int    int_pos_src:1;
    unsigned int    write_enable2:1;
    unsigned int    int_vpos:11;
    unsigned int    write_enable1:1;
    unsigned int    int_hpos:13;
}tve_INTPOS;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    srstn:1;
}tve_SRSTN;

typedef struct
{
    unsigned int    reserved_0:22;
    unsigned int    y_gain:10;
}tve_IP_Y_GAIN;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    phi:8;
}tve_PHS0;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    phi:8;
}tve_PHS1;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    phi:8;
}tve_PHS2;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    phi:8;
}tve_PHS3;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    sctoh:8;
}tve_SCTOH0;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    sctoh:8;
}tve_SCTOH1;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    sctoh:8;
}tve_SCTOH2;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    sctoh:8;
}tve_SCTOH3;

typedef struct
{
    unsigned int    reserved_0:28;
    unsigned int    u_invert:1;
    unsigned int    v_invert:1;
    unsigned int    t_offset_phase:1;
    unsigned int    t_reset_fsc:1;
}tve_F_CTRL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    black_lvl:8;
}tve_BLCK_LVL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    blank_lvl:8;
}tve_BLNK_LVL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    clamp_lvl:8;
}tve_CLAMP_LVL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    sync_lvl:8;
}tve_SYNC_LVL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    y_interp:2;
    unsigned int    y_colorbar_en:1;
    unsigned int    t_ydel_adj:3;
    unsigned int    t_sel_ylpf0:1;
    unsigned int    t_ygain_val:1;
}tve_Y_CTRL;

typedef struct
{
    unsigned int    reserved_0:28;
    unsigned int    y_tsel_yuv:1;
    unsigned int    t_pd_cvdac:1;
    unsigned int    t_pd_ydac:1;
    unsigned int    t_pd_cdac:1;
}tve_O_CTRL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    nba:8;
}tve_NBA;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    pba:8;
}tve_PBA;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    t_pal_clpf:1;
    unsigned int    t_sel_c_gain:1;
}tve_C_CTRL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    t_hsync_phs:1;
    unsigned int    t_vsync_phs:1;
    unsigned int    y_tsyncmode:3;
    unsigned int    y_tencd_mode:3;
}tve_S_CTRL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    clk_phs:2;
    unsigned int    t_fsync_enbl:1;
    unsigned int    t_fsync_phs:1;
    unsigned int    reserved_1:2;
    unsigned int    vso0:2;
}tve_VSO0;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    vso1:8;
}tve_VSO1;

typedef struct
{
    unsigned int    reserved_0:29;
    unsigned int    hso0:3;
}tve_HSO0;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    hso1:8;
}tve_HSO1;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    hlc0:2;
}tve_HLC0;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    hlc1:8;
}tve_HLC1;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    ccd_odd1:8;
}tve_CCD_ODD0;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    ccd_odd0:8;
}tve_CCD_ODD1;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    ccd_even1:8;
}tve_CCD_EVEN0;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    ccd_even0:8;
}tve_CCD_EVEN1;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    cc_enbl:2;
}tve_CCD_ENBL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvfcr:8;
}tve_MVFCR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvcsl1:8;
}tve_MVCSL1;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    mvcls1:6;
}tve_MVCLS1;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvcsl2:8;
}tve_MVCSL2;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    mvcls2:6;
}tve_MVCLS2;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvcssp:3;
    unsigned int    mvcsnum:3;
    unsigned int    mvcsln:2;
}tve_MVCSSP;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    mvpsd:6;
}tve_MVPSD;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    mvpsl:6;
}tve_MVPSL;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    mvpss:6;
}tve_MVPSS;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    mvpsls0:7;
}tve_MVPSLS0;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvpsls1:8;
}tve_MVPSLS1;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    mvpsfs0:7;
}tve_MVPSFS0;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvpsfs1:8;
}tve_MVPSFS1;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvpsagca:8;
}tve_MVPSAGCA;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvpsagcb:8;
}tve_MVPSAGCB;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mveofbpc:8;
}tve_MVEOFBPC;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvpbz1:4;
    unsigned int    mvpbz2:4;
}tve_MVPBZ1;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvpbz3:4;
    unsigned int    mvpadvbsen:1;
    unsigned int    mvpzninvrt:3;
}tve_MVPZ3;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvpcslimd_lsb:8;
}tve_MVPCSLIMD0;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    mvpcslimd_msb:2;
}tve_MVPCSLIMD1;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    t_sel_sin:1;
    unsigned int    t_fsc_rom:1;
}tve_T_SEL_SIN;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    t_byp_yups:1;
    unsigned int    t_sel_ylp1:1;
    unsigned int    t_ygain_off:1;
    unsigned int    y_tsin_cos:1;
    unsigned int    y_tsel_dac_tst:1;
    unsigned int    y_tdig_out:2;
}tve_TEST_PARAM;

typedef struct
{
    unsigned int    reserved_0:29;
    unsigned int    t_byp_cups:1;
    unsigned int    t_byp_clpf:1;
    unsigned int    t_c_gain_off:1;
}tve_TEST_T_BYP_CUPS;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    mvtms:8;
}tve_MV_CTRL;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    hlr0:2;
}tve_TEST_HLR0;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    hlr1:8;
}tve_TEST_HLR1;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    vsmr:5;
}tve_TEST_VSMR;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    sync_lvl_h:8;
}tve_SYNC_LVL2;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    sync_lvl_m:8;
}tve_SYNC_LVL3;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    sync_lvl_l:8;
}tve_SYNC_LVL4;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    clpf_gain:8;
}tve_CLPF_GAIN;

typedef struct
{
    unsigned int    reserved_0:28;
    unsigned int    sync_strt:4;
}tve_SYNC_STRT;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    sync_end:7;
}tve_SYNC_END;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    sync_srend:8;
}tve_SYNC_SREND;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    sync_eqend:6;
}tve_SYNC_EQEND;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    actv_strt:8;
}tve_ACTV_STRT;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    actv_end:8;
}tve_ACTV_END;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    wbrst_strt:7;
}tve_WBRST_STRT;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    nbrst_strt:7;
}tve_NBRST_STRT;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    nbrst_end:8;
}tve_NBRST_END;

typedef struct
{
    unsigned int    reserved_0:20;
    unsigned int    write_enable3:1;
    unsigned int    sel1:4;
    unsigned int    write_enable2:1;
    unsigned int    sel0:4;
    unsigned int    write_enable1:1;
    unsigned int    enable:1;
}tve_DBG;
#endif

#define TVE_SYNCGEN_CTRL                                              0x18018000
#define TVE_SYNCGEN_CTRL_reg_addr                                     "0xB8018000"
#define TVE_SYNCGEN_CTRL_reg                                          0xB8018000
#define TVE_SYNCGEN_CTRL_inst_addr                                    "0x0000"
#define TVE_SYNCGEN_CTRL_inst                                         0x0000
#define TVE_SYNCGEN_CTRL_write_enable5_shift                          (31)
#define TVE_SYNCGEN_CTRL_i_p_req_shift                                (30)
#define TVE_SYNCGEN_CTRL_write_enable4_shift                          (29)
#define TVE_SYNCGEN_CTRL_sgen_shift                                   (28)
#define TVE_SYNCGEN_CTRL_write_enable3_shift                          (27)
#define TVE_SYNCGEN_CTRL_i_p_sel_shift                                (26)
#define TVE_SYNCGEN_CTRL_write_enable2_shift                          (25)
#define TVE_SYNCGEN_CTRL_v_thr_shift                                  (14)
#define TVE_SYNCGEN_CTRL_write_enable1_shift                          (13)
#define TVE_SYNCGEN_CTRL_h_thr_shift                                  (0)
#define TVE_SYNCGEN_CTRL_write_enable5_mask                           (0x80000000)
#define TVE_SYNCGEN_CTRL_i_p_req_mask                                 (0x40000000)
#define TVE_SYNCGEN_CTRL_write_enable4_mask                           (0x20000000)
#define TVE_SYNCGEN_CTRL_sgen_mask                                    (0x10000000)
#define TVE_SYNCGEN_CTRL_write_enable3_mask                           (0x08000000)
#define TVE_SYNCGEN_CTRL_i_p_sel_mask                                 (0x04000000)
#define TVE_SYNCGEN_CTRL_write_enable2_mask                           (0x02000000)
#define TVE_SYNCGEN_CTRL_v_thr_mask                                   (0x01FFC000)
#define TVE_SYNCGEN_CTRL_write_enable1_mask                           (0x00002000)
#define TVE_SYNCGEN_CTRL_h_thr_mask                                   (0x00001FFF)
#define TVE_SYNCGEN_CTRL_write_enable5(data)                          (0x80000000&((data)<<31))
#define TVE_SYNCGEN_CTRL_i_p_req(data)                                (0x40000000&((data)<<30))
#define TVE_SYNCGEN_CTRL_write_enable4(data)                          (0x20000000&((data)<<29))
#define TVE_SYNCGEN_CTRL_sgen(data)                                   (0x10000000&((data)<<28))
#define TVE_SYNCGEN_CTRL_write_enable3(data)                          (0x08000000&((data)<<27))
#define TVE_SYNCGEN_CTRL_i_p_sel(data)                                (0x04000000&((data)<<26))
#define TVE_SYNCGEN_CTRL_write_enable2(data)                          (0x02000000&((data)<<25))
#define TVE_SYNCGEN_CTRL_v_thr(data)                                  (0x01FFC000&((data)<<14))
#define TVE_SYNCGEN_CTRL_write_enable1(data)                          (0x00002000&((data)<<13))
#define TVE_SYNCGEN_CTRL_h_thr(data)                                  (0x00001FFF&(data))
#define TVE_SYNCGEN_CTRL_get_write_enable5(data)                      ((0x80000000&(data))>>31)
#define TVE_SYNCGEN_CTRL_get_i_p_req(data)                            ((0x40000000&(data))>>30)
#define TVE_SYNCGEN_CTRL_get_write_enable4(data)                      ((0x20000000&(data))>>29)
#define TVE_SYNCGEN_CTRL_get_sgen(data)                               ((0x10000000&(data))>>28)
#define TVE_SYNCGEN_CTRL_get_write_enable3(data)                      ((0x08000000&(data))>>27)
#define TVE_SYNCGEN_CTRL_get_i_p_sel(data)                            ((0x04000000&(data))>>26)
#define TVE_SYNCGEN_CTRL_get_write_enable2(data)                      ((0x02000000&(data))>>25)
#define TVE_SYNCGEN_CTRL_get_v_thr(data)                              ((0x01FFC000&(data))>>14)
#define TVE_SYNCGEN_CTRL_get_write_enable1(data)                      ((0x00002000&(data))>>13)
#define TVE_SYNCGEN_CTRL_get_h_thr(data)                              (0x00001FFF&(data))

#define TVE_IP_VSYNCPOS                                               0x18018004
#define TVE_IP_VSYNCPOS_reg_addr                                      "0xB8018004"
#define TVE_IP_VSYNCPOS_reg                                           0xB8018004
#define TVE_IP_VSYNCPOS_inst_addr                                     "0x0001"
#define TVE_IP_VSYNCPOS_inst                                          0x0001
#define TVE_IP_VSYNCPOS_write_enable2_shift                           (21)
#define TVE_IP_VSYNCPOS_ip_vsync_pos1_shift                           (11)
#define TVE_IP_VSYNCPOS_write_enable1_shift                           (10)
#define TVE_IP_VSYNCPOS_ip_vsync_pos2_shift                           (0)
#define TVE_IP_VSYNCPOS_write_enable2_mask                            (0x00200000)
#define TVE_IP_VSYNCPOS_ip_vsync_pos1_mask                            (0x001FF800)
#define TVE_IP_VSYNCPOS_write_enable1_mask                            (0x00000400)
#define TVE_IP_VSYNCPOS_ip_vsync_pos2_mask                            (0x000003FF)
#define TVE_IP_VSYNCPOS_write_enable2(data)                           (0x00200000&((data)<<21))
#define TVE_IP_VSYNCPOS_ip_vsync_pos1(data)                           (0x001FF800&((data)<<11))
#define TVE_IP_VSYNCPOS_write_enable1(data)                           (0x00000400&((data)<<10))
#define TVE_IP_VSYNCPOS_ip_vsync_pos2(data)                           (0x000003FF&(data))
#define TVE_IP_VSYNCPOS_get_write_enable2(data)                       ((0x00200000&(data))>>21)
#define TVE_IP_VSYNCPOS_get_ip_vsync_pos1(data)                       ((0x001FF800&(data))>>11)
#define TVE_IP_VSYNCPOS_get_write_enable1(data)                       ((0x00000400&(data))>>10)
#define TVE_IP_VSYNCPOS_get_ip_vsync_pos2(data)                       (0x000003FF&(data))

#define TVE_SYNCGEN_STATUS                                            0x18018008
#define TVE_SYNCGEN_STATUS_reg_addr                                   "0xB8018008"
#define TVE_SYNCGEN_STATUS_reg                                        0xB8018008
#define TVE_SYNCGEN_STATUS_inst_addr                                  "0x0002"
#define TVE_SYNCGEN_STATUS_inst                                       0x0002
#define TVE_SYNCGEN_STATUS_i_field_shift                              (22)
#define TVE_SYNCGEN_STATUS_i_vcnt_shift                               (11)
#define TVE_SYNCGEN_STATUS_p_vcnt_shift                               (0)
#define TVE_SYNCGEN_STATUS_i_field_mask                               (0x00400000)
#define TVE_SYNCGEN_STATUS_i_vcnt_mask                                (0x003FF800)
#define TVE_SYNCGEN_STATUS_p_vcnt_mask                                (0x000007FF)
#define TVE_SYNCGEN_STATUS_i_field(data)                              (0x00400000&((data)<<22))
#define TVE_SYNCGEN_STATUS_i_vcnt(data)                               (0x003FF800&((data)<<11))
#define TVE_SYNCGEN_STATUS_p_vcnt(data)                               (0x000007FF&(data))
#define TVE_SYNCGEN_STATUS_get_i_field(data)                          ((0x00400000&(data))>>22)
#define TVE_SYNCGEN_STATUS_get_i_vcnt(data)                           ((0x003FF800&(data))>>11)
#define TVE_SYNCGEN_STATUS_get_p_vcnt(data)                           (0x000007FF&(data))

#define TVE_I_HPOS                                                    0x18018048
#define TVE_I_HPOS_reg_addr                                           "0xB8018048"
#define TVE_I_HPOS_reg                                                0xB8018048
#define TVE_I_HPOS_inst_addr                                          "0x0012"
#define TVE_I_HPOS_inst                                               0x0012
#define TVE_I_HPOS_write_enable2_shift                                (27)
#define TVE_I_HPOS_i_h_st_shift                                       (14)
#define TVE_I_HPOS_write_enable1_shift                                (13)
#define TVE_I_HPOS_i_h_end_shift                                      (0)
#define TVE_I_HPOS_write_enable2_mask                                 (0x08000000)
#define TVE_I_HPOS_i_h_st_mask                                        (0x07FFC000)
#define TVE_I_HPOS_write_enable1_mask                                 (0x00002000)
#define TVE_I_HPOS_i_h_end_mask                                       (0x00001FFF)
#define TVE_I_HPOS_write_enable2(data)                                (0x08000000&((data)<<27))
#define TVE_I_HPOS_i_h_st(data)                                       (0x07FFC000&((data)<<14))
#define TVE_I_HPOS_write_enable1(data)                                (0x00002000&((data)<<13))
#define TVE_I_HPOS_i_h_end(data)                                      (0x00001FFF&(data))
#define TVE_I_HPOS_get_write_enable2(data)                            ((0x08000000&(data))>>27)
#define TVE_I_HPOS_get_i_h_st(data)                                   ((0x07FFC000&(data))>>14)
#define TVE_I_HPOS_get_write_enable1(data)                            ((0x00002000&(data))>>13)
#define TVE_I_HPOS_get_i_h_end(data)                                  (0x00001FFF&(data))

#define TVE_P_HPOS                                                    0x1801804C
#define TVE_P_HPOS_reg_addr                                           "0xB801804C"
#define TVE_P_HPOS_reg                                                0xB801804C
#define TVE_P_HPOS_inst_addr                                          "0x0013"
#define TVE_P_HPOS_inst                                               0x0013
#define TVE_P_HPOS_write_enable2_shift                                (27)
#define TVE_P_HPOS_p_h_st_shift                                       (14)
#define TVE_P_HPOS_write_enable1_shift                                (13)
#define TVE_P_HPOS_p_h_end_shift                                      (0)
#define TVE_P_HPOS_write_enable2_mask                                 (0x08000000)
#define TVE_P_HPOS_p_h_st_mask                                        (0x07FFC000)
#define TVE_P_HPOS_write_enable1_mask                                 (0x00002000)
#define TVE_P_HPOS_p_h_end_mask                                       (0x00001FFF)
#define TVE_P_HPOS_write_enable2(data)                                (0x08000000&((data)<<27))
#define TVE_P_HPOS_p_h_st(data)                                       (0x07FFC000&((data)<<14))
#define TVE_P_HPOS_write_enable1(data)                                (0x00002000&((data)<<13))
#define TVE_P_HPOS_p_h_end(data)                                      (0x00001FFF&(data))
#define TVE_P_HPOS_get_write_enable2(data)                            ((0x08000000&(data))>>27)
#define TVE_P_HPOS_get_p_h_st(data)                                   ((0x07FFC000&(data))>>14)
#define TVE_P_HPOS_get_write_enable1(data)                            ((0x00002000&(data))>>13)
#define TVE_P_HPOS_get_p_h_end(data)                                  (0x00001FFF&(data))

#define TVE_ITOP_VPOS                                                 0x18018050
#define TVE_ITOP_VPOS_reg_addr                                        "0xB8018050"
#define TVE_ITOP_VPOS_reg                                             0xB8018050
#define TVE_ITOP_VPOS_inst_addr                                       "0x0014"
#define TVE_ITOP_VPOS_inst                                            0x0014
#define TVE_ITOP_VPOS_write_enable2_shift                             (23)
#define TVE_ITOP_VPOS_itop_v_st_shift                                 (12)
#define TVE_ITOP_VPOS_write_enable1_shift                             (11)
#define TVE_ITOP_VPOS_itop_v_end_shift                                (0)
#define TVE_ITOP_VPOS_write_enable2_mask                              (0x00800000)
#define TVE_ITOP_VPOS_itop_v_st_mask                                  (0x007FF000)
#define TVE_ITOP_VPOS_write_enable1_mask                              (0x00000800)
#define TVE_ITOP_VPOS_itop_v_end_mask                                 (0x000007FF)
#define TVE_ITOP_VPOS_write_enable2(data)                             (0x00800000&((data)<<23))
#define TVE_ITOP_VPOS_itop_v_st(data)                                 (0x007FF000&((data)<<12))
#define TVE_ITOP_VPOS_write_enable1(data)                             (0x00000800&((data)<<11))
#define TVE_ITOP_VPOS_itop_v_end(data)                                (0x000007FF&(data))
#define TVE_ITOP_VPOS_get_write_enable2(data)                         ((0x00800000&(data))>>23)
#define TVE_ITOP_VPOS_get_itop_v_st(data)                             ((0x007FF000&(data))>>12)
#define TVE_ITOP_VPOS_get_write_enable1(data)                         ((0x00000800&(data))>>11)
#define TVE_ITOP_VPOS_get_itop_v_end(data)                            (0x000007FF&(data))

#define TVE_IBOT_VPOS                                                 0x18018054
#define TVE_IBOT_VPOS_reg_addr                                        "0xB8018054"
#define TVE_IBOT_VPOS_reg                                             0xB8018054
#define TVE_IBOT_VPOS_inst_addr                                       "0x0015"
#define TVE_IBOT_VPOS_inst                                            0x0015
#define TVE_IBOT_VPOS_write_enable2_shift                             (23)
#define TVE_IBOT_VPOS_ibot_v_st_shift                                 (12)
#define TVE_IBOT_VPOS_write_enable1_shift                             (11)
#define TVE_IBOT_VPOS_ibot_v_end_shift                                (0)
#define TVE_IBOT_VPOS_write_enable2_mask                              (0x00800000)
#define TVE_IBOT_VPOS_ibot_v_st_mask                                  (0x007FF000)
#define TVE_IBOT_VPOS_write_enable1_mask                              (0x00000800)
#define TVE_IBOT_VPOS_ibot_v_end_mask                                 (0x000007FF)
#define TVE_IBOT_VPOS_write_enable2(data)                             (0x00800000&((data)<<23))
#define TVE_IBOT_VPOS_ibot_v_st(data)                                 (0x007FF000&((data)<<12))
#define TVE_IBOT_VPOS_write_enable1(data)                             (0x00000800&((data)<<11))
#define TVE_IBOT_VPOS_ibot_v_end(data)                                (0x000007FF&(data))
#define TVE_IBOT_VPOS_get_write_enable2(data)                         ((0x00800000&(data))>>23)
#define TVE_IBOT_VPOS_get_ibot_v_st(data)                             ((0x007FF000&(data))>>12)
#define TVE_IBOT_VPOS_get_write_enable1(data)                         ((0x00000800&(data))>>11)
#define TVE_IBOT_VPOS_get_ibot_v_end(data)                            (0x000007FF&(data))

#define TVE_P_VPOS                                                    0x18018058
#define TVE_P_VPOS_reg_addr                                           "0xB8018058"
#define TVE_P_VPOS_reg                                                0xB8018058
#define TVE_P_VPOS_inst_addr                                          "0x0016"
#define TVE_P_VPOS_inst                                               0x0016
#define TVE_P_VPOS_write_enable2_shift                                (23)
#define TVE_P_VPOS_p_v_st_shift                                       (12)
#define TVE_P_VPOS_write_enable1_shift                                (11)
#define TVE_P_VPOS_p_v_end_shift                                      (0)
#define TVE_P_VPOS_write_enable2_mask                                 (0x00800000)
#define TVE_P_VPOS_p_v_st_mask                                        (0x007FF000)
#define TVE_P_VPOS_write_enable1_mask                                 (0x00000800)
#define TVE_P_VPOS_p_v_end_mask                                       (0x000007FF)
#define TVE_P_VPOS_write_enable2(data)                                (0x00800000&((data)<<23))
#define TVE_P_VPOS_p_v_st(data)                                       (0x007FF000&((data)<<12))
#define TVE_P_VPOS_write_enable1(data)                                (0x00000800&((data)<<11))
#define TVE_P_VPOS_p_v_end(data)                                      (0x000007FF&(data))
#define TVE_P_VPOS_get_write_enable2(data)                            ((0x00800000&(data))>>23)
#define TVE_P_VPOS_get_p_v_st(data)                                   ((0x007FF000&(data))>>12)
#define TVE_P_VPOS_get_write_enable1(data)                            ((0x00000800&(data))>>11)
#define TVE_P_VPOS_get_p_v_end(data)                                  (0x000007FF&(data))

#define TVE_DIF_HACTIVE                                               0x180180A4
#define TVE_DIF_HACTIVE_reg_addr                                      "0xB80180A4"
#define TVE_DIF_HACTIVE_reg                                           0xB80180A4
#define TVE_DIF_HACTIVE_inst_addr                                     "0x0029"
#define TVE_DIF_HACTIVE_inst                                          0x0029
#define TVE_DIF_HACTIVE_write_enable2_shift                           (27)
#define TVE_DIF_HACTIVE_hact_start_shift                              (14)
#define TVE_DIF_HACTIVE_write_enable1_shift                           (13)
#define TVE_DIF_HACTIVE_hact_end_shift                                (0)
#define TVE_DIF_HACTIVE_write_enable2_mask                            (0x08000000)
#define TVE_DIF_HACTIVE_hact_start_mask                               (0x07FFC000)
#define TVE_DIF_HACTIVE_write_enable1_mask                            (0x00002000)
#define TVE_DIF_HACTIVE_hact_end_mask                                 (0x00001FFF)
#define TVE_DIF_HACTIVE_write_enable2(data)                           (0x08000000&((data)<<27))
#define TVE_DIF_HACTIVE_hact_start(data)                              (0x07FFC000&((data)<<14))
#define TVE_DIF_HACTIVE_write_enable1(data)                           (0x00002000&((data)<<13))
#define TVE_DIF_HACTIVE_hact_end(data)                                (0x00001FFF&(data))
#define TVE_DIF_HACTIVE_get_write_enable2(data)                       ((0x08000000&(data))>>27)
#define TVE_DIF_HACTIVE_get_hact_start(data)                          ((0x07FFC000&(data))>>14)
#define TVE_DIF_HACTIVE_get_write_enable1(data)                       ((0x00002000&(data))>>13)
#define TVE_DIF_HACTIVE_get_hact_end(data)                            (0x00001FFF&(data))

#define TVE_VBI_GAIN                                                  0x180180A8
#define TVE_VBI_GAIN_reg_addr                                         "0xB80180A8"
#define TVE_VBI_GAIN_reg                                              0xB80180A8
#define TVE_VBI_GAIN_inst_addr                                        "0x002A"
#define TVE_VBI_GAIN_inst                                             0x002A
#define TVE_VBI_GAIN_write_enable2_shift                              (23)
#define TVE_VBI_GAIN_gain_lsb_shift                                   (12)
#define TVE_VBI_GAIN_write_enable1_shift                              (11)
#define TVE_VBI_GAIN_gain_msb_shift                                   (7)
#define TVE_VBI_GAIN_vbi_gain_ebl_shift                               (4)
#define TVE_VBI_GAIN_offset_msb_shift                                 (0)
#define TVE_VBI_GAIN_write_enable2_mask                               (0x00800000)
#define TVE_VBI_GAIN_gain_lsb_mask                                    (0x007FF000)
#define TVE_VBI_GAIN_write_enable1_mask                               (0x00000800)
#define TVE_VBI_GAIN_gain_msb_mask                                    (0x00000780)
#define TVE_VBI_GAIN_vbi_gain_ebl_mask                                (0x00000010)
#define TVE_VBI_GAIN_offset_msb_mask                                  (0x0000000F)
#define TVE_VBI_GAIN_write_enable2(data)                              (0x00800000&((data)<<23))
#define TVE_VBI_GAIN_gain_lsb(data)                                   (0x007FF000&((data)<<12))
#define TVE_VBI_GAIN_write_enable1(data)                              (0x00000800&((data)<<11))
#define TVE_VBI_GAIN_gain_msb(data)                                   (0x00000780&((data)<<7))
#define TVE_VBI_GAIN_vbi_gain_ebl(data)                               (0x00000010&((data)<<4))
#define TVE_VBI_GAIN_offset_msb(data)                                 (0x0000000F&(data))
#define TVE_VBI_GAIN_get_write_enable2(data)                          ((0x00800000&(data))>>23)
#define TVE_VBI_GAIN_get_gain_lsb(data)                               ((0x007FF000&(data))>>12)
#define TVE_VBI_GAIN_get_write_enable1(data)                          ((0x00000800&(data))>>11)
#define TVE_VBI_GAIN_get_gain_msb(data)                               ((0x00000780&(data))>>7)
#define TVE_VBI_GAIN_get_vbi_gain_ebl(data)                           ((0x00000010&(data))>>4)
#define TVE_VBI_GAIN_get_offset_msb(data)                             (0x0000000F&(data))

#define TVE_VBI_OFFSET                                                0x180180AC
#define TVE_VBI_OFFSET_reg_addr                                       "0xB80180AC"
#define TVE_VBI_OFFSET_reg                                            0xB80180AC
#define TVE_VBI_OFFSET_inst_addr                                      "0x002B"
#define TVE_VBI_OFFSET_inst                                           0x002B
#define TVE_VBI_OFFSET_write_enable2_shift                            (23)
#define TVE_VBI_OFFSET_offset_lsb_shift                               (12)
#define TVE_VBI_OFFSET_write_enable1_shift                            (11)
#define TVE_VBI_OFFSET_ip_sync_vthr_shift                             (0)
#define TVE_VBI_OFFSET_write_enable2_mask                             (0x00800000)
#define TVE_VBI_OFFSET_offset_lsb_mask                                (0x007FF000)
#define TVE_VBI_OFFSET_write_enable1_mask                             (0x00000800)
#define TVE_VBI_OFFSET_ip_sync_vthr_mask                              (0x000007FF)
#define TVE_VBI_OFFSET_write_enable2(data)                            (0x00800000&((data)<<23))
#define TVE_VBI_OFFSET_offset_lsb(data)                               (0x007FF000&((data)<<12))
#define TVE_VBI_OFFSET_write_enable1(data)                            (0x00000800&((data)<<11))
#define TVE_VBI_OFFSET_ip_sync_vthr(data)                             (0x000007FF&(data))
#define TVE_VBI_OFFSET_get_write_enable2(data)                        ((0x00800000&(data))>>23)
#define TVE_VBI_OFFSET_get_offset_lsb(data)                           ((0x007FF000&(data))>>12)
#define TVE_VBI_OFFSET_get_write_enable1(data)                        ((0x00000800&(data))>>11)
#define TVE_VBI_OFFSET_get_ip_sync_vthr(data)                         (0x000007FF&(data))

#define TVE_SLEW_CTTL                                                 0x180180C4
#define TVE_SLEW_CTTL_reg_addr                                        "0xB80180C4"
#define TVE_SLEW_CTTL_reg                                             0xB80180C4
#define TVE_SLEW_CTTL_inst_addr                                       "0x0031"
#define TVE_SLEW_CTTL_inst                                            0x0031
#define TVE_SLEW_CTTL_write_enable5_shift                             (18)
#define TVE_SLEW_CTTL_i_en_shift                                      (17)
#define TVE_SLEW_CTTL_write_enable4_shift                             (16)
#define TVE_SLEW_CTTL_p_en_shift                                      (15)
#define TVE_SLEW_CTTL_write_enable3_shift                             (14)
#define TVE_SLEW_CTTL_i_slewrate_shift                                (12)
#define TVE_SLEW_CTTL_write_enable2_shift                             (11)
#define TVE_SLEW_CTTL_p_slewrate_shift                                (9)
#define TVE_SLEW_CTTL_write_enable1_shift                             (8)
#define TVE_SLEW_CTTL_y_black_level_shift                             (0)
#define TVE_SLEW_CTTL_write_enable5_mask                              (0x00040000)
#define TVE_SLEW_CTTL_i_en_mask                                       (0x00020000)
#define TVE_SLEW_CTTL_write_enable4_mask                              (0x00010000)
#define TVE_SLEW_CTTL_p_en_mask                                       (0x00008000)
#define TVE_SLEW_CTTL_write_enable3_mask                              (0x00004000)
#define TVE_SLEW_CTTL_i_slewrate_mask                                 (0x00003000)
#define TVE_SLEW_CTTL_write_enable2_mask                              (0x00000800)
#define TVE_SLEW_CTTL_p_slewrate_mask                                 (0x00000600)
#define TVE_SLEW_CTTL_write_enable1_mask                              (0x00000100)
#define TVE_SLEW_CTTL_y_black_level_mask                              (0x000000FF)
#define TVE_SLEW_CTTL_write_enable5(data)                             (0x00040000&((data)<<18))
#define TVE_SLEW_CTTL_i_en(data)                                      (0x00020000&((data)<<17))
#define TVE_SLEW_CTTL_write_enable4(data)                             (0x00010000&((data)<<16))
#define TVE_SLEW_CTTL_p_en(data)                                      (0x00008000&((data)<<15))
#define TVE_SLEW_CTTL_write_enable3(data)                             (0x00004000&((data)<<14))
#define TVE_SLEW_CTTL_i_slewrate(data)                                (0x00003000&((data)<<12))
#define TVE_SLEW_CTTL_write_enable2(data)                             (0x00000800&((data)<<11))
#define TVE_SLEW_CTTL_p_slewrate(data)                                (0x00000600&((data)<<9))
#define TVE_SLEW_CTTL_write_enable1(data)                             (0x00000100&((data)<<8))
#define TVE_SLEW_CTTL_y_black_level(data)                             (0x000000FF&(data))
#define TVE_SLEW_CTTL_get_write_enable5(data)                         ((0x00040000&(data))>>18)
#define TVE_SLEW_CTTL_get_i_en(data)                                  ((0x00020000&(data))>>17)
#define TVE_SLEW_CTTL_get_write_enable4(data)                         ((0x00010000&(data))>>16)
#define TVE_SLEW_CTTL_get_p_en(data)                                  ((0x00008000&(data))>>15)
#define TVE_SLEW_CTTL_get_write_enable3(data)                         ((0x00004000&(data))>>14)
#define TVE_SLEW_CTTL_get_i_slewrate(data)                            ((0x00003000&(data))>>12)
#define TVE_SLEW_CTTL_get_write_enable2(data)                         ((0x00000800&(data))>>11)
#define TVE_SLEW_CTTL_get_p_slewrate(data)                            ((0x00000600&(data))>>9)
#define TVE_SLEW_CTTL_get_write_enable1(data)                         ((0x00000100&(data))>>8)
#define TVE_SLEW_CTTL_get_y_black_level(data)                         (0x000000FF&(data))

#define TVE_SRC_CTRL                                                  0x180180EC
#define TVE_SRC_CTRL_reg_addr                                         "0xB80180EC"
#define TVE_SRC_CTRL_reg                                              0xB80180EC
#define TVE_SRC_CTRL_inst_addr                                        "0x003B"
#define TVE_SRC_CTRL_inst                                             0x003B
#define TVE_SRC_CTRL_i_colorbar_ebl_shift                             (4)
#define TVE_SRC_CTRL_p_colorbar_ebl_shift                             (3)
#define TVE_SRC_CTRL_i_blackpic_ebl_shift                             (2)
#define TVE_SRC_CTRL_p_blackpic_ebl_shift                             (1)
#define TVE_SRC_CTRL_write_data_shift                                 (0)
#define TVE_SRC_CTRL_i_colorbar_ebl_mask                              (0x00000010)
#define TVE_SRC_CTRL_p_colorbar_ebl_mask                              (0x00000008)
#define TVE_SRC_CTRL_i_blackpic_ebl_mask                              (0x00000004)
#define TVE_SRC_CTRL_p_blackpic_ebl_mask                              (0x00000002)
#define TVE_SRC_CTRL_write_data_mask                                  (0x00000001)
#define TVE_SRC_CTRL_i_colorbar_ebl(data)                             (0x00000010&((data)<<4))
#define TVE_SRC_CTRL_p_colorbar_ebl(data)                             (0x00000008&((data)<<3))
#define TVE_SRC_CTRL_i_blackpic_ebl(data)                             (0x00000004&((data)<<2))
#define TVE_SRC_CTRL_p_blackpic_ebl(data)                             (0x00000002&((data)<<1))
#define TVE_SRC_CTRL_write_data(data)                                 (0x00000001&(data))
#define TVE_SRC_CTRL_get_i_colorbar_ebl(data)                         ((0x00000010&(data))>>4)
#define TVE_SRC_CTRL_get_p_colorbar_ebl(data)                         ((0x00000008&(data))>>3)
#define TVE_SRC_CTRL_get_i_blackpic_ebl(data)                         ((0x00000004&(data))>>2)
#define TVE_SRC_CTRL_get_p_blackpic_ebl(data)                         ((0x00000002&(data))>>1)
#define TVE_SRC_CTRL_get_write_data(data)                             (0x00000001&(data))

#define TVE_I_COLOR_BAR                                               0x180180F0
#define TVE_I_COLOR_BAR_reg_addr                                      "0xB80180F0"
#define TVE_I_COLOR_BAR_reg                                           0xB80180F0
#define TVE_I_COLOR_BAR_inst_addr                                     "0x003C"
#define TVE_I_COLOR_BAR_inst                                          0x003C
#define TVE_I_COLOR_BAR_write_enable2_shift                           (21)
#define TVE_I_COLOR_BAR_i_h_width_shift                               (11)
#define TVE_I_COLOR_BAR_write_enable1_shift                           (10)
#define TVE_I_COLOR_BAR_i_h_st_pos_shift                              (0)
#define TVE_I_COLOR_BAR_write_enable2_mask                            (0x00200000)
#define TVE_I_COLOR_BAR_i_h_width_mask                                (0x001FF800)
#define TVE_I_COLOR_BAR_write_enable1_mask                            (0x00000400)
#define TVE_I_COLOR_BAR_i_h_st_pos_mask                               (0x000003FF)
#define TVE_I_COLOR_BAR_write_enable2(data)                           (0x00200000&((data)<<21))
#define TVE_I_COLOR_BAR_i_h_width(data)                               (0x001FF800&((data)<<11))
#define TVE_I_COLOR_BAR_write_enable1(data)                           (0x00000400&((data)<<10))
#define TVE_I_COLOR_BAR_i_h_st_pos(data)                              (0x000003FF&(data))
#define TVE_I_COLOR_BAR_get_write_enable2(data)                       ((0x00200000&(data))>>21)
#define TVE_I_COLOR_BAR_get_i_h_width(data)                           ((0x001FF800&(data))>>11)
#define TVE_I_COLOR_BAR_get_write_enable1(data)                       ((0x00000400&(data))>>10)
#define TVE_I_COLOR_BAR_get_i_h_st_pos(data)                          (0x000003FF&(data))

#define TVE_P_COLOR_BAR                                               0x180180F4
#define TVE_P_COLOR_BAR_reg_addr                                      "0xB80180F4"
#define TVE_P_COLOR_BAR_reg                                           0xB80180F4
#define TVE_P_COLOR_BAR_inst_addr                                     "0x003D"
#define TVE_P_COLOR_BAR_inst                                          0x003D
#define TVE_P_COLOR_BAR_write_enable2_shift                           (21)
#define TVE_P_COLOR_BAR_p_h_width_shift                               (11)
#define TVE_P_COLOR_BAR_write_enable1_shift                           (10)
#define TVE_P_COLOR_BAR_p_h_st_pos_shift                              (0)
#define TVE_P_COLOR_BAR_write_enable2_mask                            (0x00200000)
#define TVE_P_COLOR_BAR_p_h_width_mask                                (0x001FF800)
#define TVE_P_COLOR_BAR_write_enable1_mask                            (0x00000400)
#define TVE_P_COLOR_BAR_p_h_st_pos_mask                               (0x000003FF)
#define TVE_P_COLOR_BAR_write_enable2(data)                           (0x00200000&((data)<<21))
#define TVE_P_COLOR_BAR_p_h_width(data)                               (0x001FF800&((data)<<11))
#define TVE_P_COLOR_BAR_write_enable1(data)                           (0x00000400&((data)<<10))
#define TVE_P_COLOR_BAR_p_h_st_pos(data)                              (0x000003FF&(data))
#define TVE_P_COLOR_BAR_get_write_enable2(data)                       ((0x00200000&(data))>>21)
#define TVE_P_COLOR_BAR_get_p_h_width(data)                           ((0x001FF800&(data))>>11)
#define TVE_P_COLOR_BAR_get_write_enable1(data)                       ((0x00000400&(data))>>10)
#define TVE_P_COLOR_BAR_get_p_h_st_pos(data)                          (0x000003FF&(data))

#define TVE_CGMS_DATA                                                 0x1801800C
#define TVE_CGMS_DATA_reg_addr                                        "0xB801800C"
#define TVE_CGMS_DATA_reg                                             0xB801800C
#define TVE_CGMS_DATA_inst_addr                                       "0x0003"
#define TVE_CGMS_DATA_inst                                            0x0003
#define TVE_CGMS_DATA_write_enable4_shift                             (26)
#define TVE_CGMS_DATA_cgms_1080i_ebl_shift                            (25)
#define TVE_CGMS_DATA_write_enable3_shift                             (24)
#define TVE_CGMS_DATA_cgms_i_ebl_shift                                (23)
#define TVE_CGMS_DATA_write_enable2_shift                             (22)
#define TVE_CGMS_DATA_cgms_p_ebl_shift                                (21)
#define TVE_CGMS_DATA_write_enable1_shift                             (20)
#define TVE_CGMS_DATA_cgms_data_shift                                 (0)
#define TVE_CGMS_DATA_write_enable4_mask                              (0x04000000)
#define TVE_CGMS_DATA_cgms_1080i_ebl_mask                             (0x02000000)
#define TVE_CGMS_DATA_write_enable3_mask                              (0x01000000)
#define TVE_CGMS_DATA_cgms_i_ebl_mask                                 (0x00800000)
#define TVE_CGMS_DATA_write_enable2_mask                              (0x00400000)
#define TVE_CGMS_DATA_cgms_p_ebl_mask                                 (0x00200000)
#define TVE_CGMS_DATA_write_enable1_mask                              (0x00100000)
#define TVE_CGMS_DATA_cgms_data_mask                                  (0x000FFFFF)
#define TVE_CGMS_DATA_write_enable4(data)                             (0x04000000&((data)<<26))
#define TVE_CGMS_DATA_cgms_1080i_ebl(data)                            (0x02000000&((data)<<25))
#define TVE_CGMS_DATA_write_enable3(data)                             (0x01000000&((data)<<24))
#define TVE_CGMS_DATA_cgms_i_ebl(data)                                (0x00800000&((data)<<23))
#define TVE_CGMS_DATA_write_enable2(data)                             (0x00400000&((data)<<22))
#define TVE_CGMS_DATA_cgms_p_ebl(data)                                (0x00200000&((data)<<21))
#define TVE_CGMS_DATA_write_enable1(data)                             (0x00100000&((data)<<20))
#define TVE_CGMS_DATA_cgms_data(data)                                 (0x000FFFFF&(data))
#define TVE_CGMS_DATA_get_write_enable4(data)                         ((0x04000000&(data))>>26)
#define TVE_CGMS_DATA_get_cgms_1080i_ebl(data)                        ((0x02000000&(data))>>25)
#define TVE_CGMS_DATA_get_write_enable3(data)                         ((0x01000000&(data))>>24)
#define TVE_CGMS_DATA_get_cgms_i_ebl(data)                            ((0x00800000&(data))>>23)
#define TVE_CGMS_DATA_get_write_enable2(data)                         ((0x00400000&(data))>>22)
#define TVE_CGMS_DATA_get_cgms_p_ebl(data)                            ((0x00200000&(data))>>21)
#define TVE_CGMS_DATA_get_write_enable1(data)                         ((0x00100000&(data))>>20)
#define TVE_CGMS_DATA_get_cgms_data(data)                             (0x000FFFFF&(data))

#define TVE_CGMS_I_HPOS                                               0x18018010
#define TVE_CGMS_I_HPOS_reg_addr                                      "0xB8018010"
#define TVE_CGMS_I_HPOS_reg                                           0xB8018010
#define TVE_CGMS_I_HPOS_inst_addr                                     "0x0004"
#define TVE_CGMS_I_HPOS_inst                                          0x0004
#define TVE_CGMS_I_HPOS_write_enable2_shift                           (21)
#define TVE_CGMS_I_HPOS_cgms_i_hst_shift                              (11)
#define TVE_CGMS_I_HPOS_write_enable1_shift                           (10)
#define TVE_CGMS_I_HPOS_cgms_i_len_shift                              (0)
#define TVE_CGMS_I_HPOS_write_enable2_mask                            (0x00200000)
#define TVE_CGMS_I_HPOS_cgms_i_hst_mask                               (0x001FF800)
#define TVE_CGMS_I_HPOS_write_enable1_mask                            (0x00000400)
#define TVE_CGMS_I_HPOS_cgms_i_len_mask                               (0x000003FF)
#define TVE_CGMS_I_HPOS_write_enable2(data)                           (0x00200000&((data)<<21))
#define TVE_CGMS_I_HPOS_cgms_i_hst(data)                              (0x001FF800&((data)<<11))
#define TVE_CGMS_I_HPOS_write_enable1(data)                           (0x00000400&((data)<<10))
#define TVE_CGMS_I_HPOS_cgms_i_len(data)                              (0x000003FF&(data))
#define TVE_CGMS_I_HPOS_get_write_enable2(data)                       ((0x00200000&(data))>>21)
#define TVE_CGMS_I_HPOS_get_cgms_i_hst(data)                          ((0x001FF800&(data))>>11)
#define TVE_CGMS_I_HPOS_get_write_enable1(data)                       ((0x00000400&(data))>>10)
#define TVE_CGMS_I_HPOS_get_cgms_i_len(data)                          (0x000003FF&(data))

#define TVE_CGMS_P_HPOS                                               0x18018014
#define TVE_CGMS_P_HPOS_reg_addr                                      "0xB8018014"
#define TVE_CGMS_P_HPOS_reg                                           0xB8018014
#define TVE_CGMS_P_HPOS_inst_addr                                     "0x0005"
#define TVE_CGMS_P_HPOS_inst                                          0x0005
#define TVE_CGMS_P_HPOS_write_enable3_shift                           (30)
#define TVE_CGMS_P_HPOS_cgms_p_lvl_shift                              (22)
#define TVE_CGMS_P_HPOS_write_enable2_shift                           (21)
#define TVE_CGMS_P_HPOS_cgms_p_hst_shift                              (11)
#define TVE_CGMS_P_HPOS_write_enable1_shift                           (10)
#define TVE_CGMS_P_HPOS_cgms_p_len_shift                              (0)
#define TVE_CGMS_P_HPOS_write_enable3_mask                            (0x40000000)
#define TVE_CGMS_P_HPOS_cgms_p_lvl_mask                               (0x3FC00000)
#define TVE_CGMS_P_HPOS_write_enable2_mask                            (0x00200000)
#define TVE_CGMS_P_HPOS_cgms_p_hst_mask                               (0x001FF800)
#define TVE_CGMS_P_HPOS_write_enable1_mask                            (0x00000400)
#define TVE_CGMS_P_HPOS_cgms_p_len_mask                               (0x000003FF)
#define TVE_CGMS_P_HPOS_write_enable3(data)                           (0x40000000&((data)<<30))
#define TVE_CGMS_P_HPOS_cgms_p_lvl(data)                              (0x3FC00000&((data)<<22))
#define TVE_CGMS_P_HPOS_write_enable2(data)                           (0x00200000&((data)<<21))
#define TVE_CGMS_P_HPOS_cgms_p_hst(data)                              (0x001FF800&((data)<<11))
#define TVE_CGMS_P_HPOS_write_enable1(data)                           (0x00000400&((data)<<10))
#define TVE_CGMS_P_HPOS_cgms_p_len(data)                              (0x000003FF&(data))
#define TVE_CGMS_P_HPOS_get_write_enable3(data)                       ((0x40000000&(data))>>30)
#define TVE_CGMS_P_HPOS_get_cgms_p_lvl(data)                          ((0x3FC00000&(data))>>22)
#define TVE_CGMS_P_HPOS_get_write_enable2(data)                       ((0x00200000&(data))>>21)
#define TVE_CGMS_P_HPOS_get_cgms_p_hst(data)                          ((0x001FF800&(data))>>11)
#define TVE_CGMS_P_HPOS_get_write_enable1(data)                       ((0x00000400&(data))>>10)
#define TVE_CGMS_P_HPOS_get_cgms_p_len(data)                          (0x000003FF&(data))

#define TVE_CGMS_VPOS                                                 0x18018018
#define TVE_CGMS_VPOS_reg_addr                                        "0xB8018018"
#define TVE_CGMS_VPOS_reg                                             0xB8018018
#define TVE_CGMS_VPOS_inst_addr                                       "0x0006"
#define TVE_CGMS_VPOS_inst                                            0x0006
#define TVE_CGMS_VPOS_write_enable3_shift                             (31)
#define TVE_CGMS_VPOS_cgms_p_vpos_shift                               (21)
#define TVE_CGMS_VPOS_write_enable2_shift                             (20)
#define TVE_CGMS_VPOS_cgms_i_vpos1_shift                              (11)
#define TVE_CGMS_VPOS_write_enable1_shift                             (10)
#define TVE_CGMS_VPOS_cgms_i_vpos2_shift                              (0)
#define TVE_CGMS_VPOS_write_enable3_mask                              (0x80000000)
#define TVE_CGMS_VPOS_cgms_p_vpos_mask                                (0x7FE00000)
#define TVE_CGMS_VPOS_write_enable2_mask                              (0x00100000)
#define TVE_CGMS_VPOS_cgms_i_vpos1_mask                               (0x000FF800)
#define TVE_CGMS_VPOS_write_enable1_mask                              (0x00000400)
#define TVE_CGMS_VPOS_cgms_i_vpos2_mask                               (0x000003FF)
#define TVE_CGMS_VPOS_write_enable3(data)                             (0x80000000&((data)<<31))
#define TVE_CGMS_VPOS_cgms_p_vpos(data)                               (0x7FE00000&((data)<<21))
#define TVE_CGMS_VPOS_write_enable2(data)                             (0x00100000&((data)<<20))
#define TVE_CGMS_VPOS_cgms_i_vpos1(data)                              (0x000FF800&((data)<<11))
#define TVE_CGMS_VPOS_write_enable1(data)                             (0x00000400&((data)<<10))
#define TVE_CGMS_VPOS_cgms_i_vpos2(data)                              (0x000003FF&(data))
#define TVE_CGMS_VPOS_get_write_enable3(data)                         ((0x80000000&(data))>>31)
#define TVE_CGMS_VPOS_get_cgms_p_vpos(data)                           ((0x7FE00000&(data))>>21)
#define TVE_CGMS_VPOS_get_write_enable2(data)                         ((0x00100000&(data))>>20)
#define TVE_CGMS_VPOS_get_cgms_i_vpos1(data)                          ((0x000FF800&(data))>>11)
#define TVE_CGMS_VPOS_get_write_enable1(data)                         ((0x00000400&(data))>>10)
#define TVE_CGMS_VPOS_get_cgms_i_vpos2(data)                          (0x000003FF&(data))

#define TVE_WSS_DATA                                                  0x1801801C
#define TVE_WSS_DATA_reg_addr                                         "0xB801801C"
#define TVE_WSS_DATA_reg                                              0xB801801C
#define TVE_WSS_DATA_inst_addr                                        "0x0007"
#define TVE_WSS_DATA_inst                                             0x0007
#define TVE_WSS_DATA_write_enable3_shift                              (18)
#define TVE_WSS_DATA_wss_ebl_shift                                    (17)
#define TVE_WSS_DATA_write_enable2_shift                              (16)
#define TVE_WSS_DATA_wss_intp_sel_shift                               (15)
#define TVE_WSS_DATA_write_enable1_shift                              (14)
#define TVE_WSS_DATA_wss_data_shift                                   (0)
#define TVE_WSS_DATA_write_enable3_mask                               (0x00040000)
#define TVE_WSS_DATA_wss_ebl_mask                                     (0x00020000)
#define TVE_WSS_DATA_write_enable2_mask                               (0x00010000)
#define TVE_WSS_DATA_wss_intp_sel_mask                                (0x00008000)
#define TVE_WSS_DATA_write_enable1_mask                               (0x00004000)
#define TVE_WSS_DATA_wss_data_mask                                    (0x00003FFF)
#define TVE_WSS_DATA_write_enable3(data)                              (0x00040000&((data)<<18))
#define TVE_WSS_DATA_wss_ebl(data)                                    (0x00020000&((data)<<17))
#define TVE_WSS_DATA_write_enable2(data)                              (0x00010000&((data)<<16))
#define TVE_WSS_DATA_wss_intp_sel(data)                               (0x00008000&((data)<<15))
#define TVE_WSS_DATA_write_enable1(data)                              (0x00004000&((data)<<14))
#define TVE_WSS_DATA_wss_data(data)                                   (0x00003FFF&(data))
#define TVE_WSS_DATA_get_write_enable3(data)                          ((0x00040000&(data))>>18)
#define TVE_WSS_DATA_get_wss_ebl(data)                                ((0x00020000&(data))>>17)
#define TVE_WSS_DATA_get_write_enable2(data)                          ((0x00010000&(data))>>16)
#define TVE_WSS_DATA_get_wss_intp_sel(data)                           ((0x00008000&(data))>>15)
#define TVE_WSS_DATA_get_write_enable1(data)                          ((0x00004000&(data))>>14)
#define TVE_WSS_DATA_get_wss_data(data)                               (0x00003FFF&(data))

#define TVE_WSS_POS                                                   0x18018020
#define TVE_WSS_POS_reg_addr                                          "0xB8018020"
#define TVE_WSS_POS_reg                                               0xB8018020
#define TVE_WSS_POS_inst_addr                                         "0x0008"
#define TVE_WSS_POS_inst                                              0x0008
#define TVE_WSS_POS_write_enable2_shift                               (22)
#define TVE_WSS_POS_wss_h_pos_shift                                   (11)
#define TVE_WSS_POS_write_enable1_shift                               (10)
#define TVE_WSS_POS_wss_v_pos_shift                                   (0)
#define TVE_WSS_POS_write_enable2_mask                                (0x00400000)
#define TVE_WSS_POS_wss_h_pos_mask                                    (0x003FF800)
#define TVE_WSS_POS_write_enable1_mask                                (0x00000400)
#define TVE_WSS_POS_wss_v_pos_mask                                    (0x000003FF)
#define TVE_WSS_POS_write_enable2(data)                               (0x00400000&((data)<<22))
#define TVE_WSS_POS_wss_h_pos(data)                                   (0x003FF800&((data)<<11))
#define TVE_WSS_POS_write_enable1(data)                               (0x00000400&((data)<<10))
#define TVE_WSS_POS_wss_v_pos(data)                                   (0x000003FF&(data))
#define TVE_WSS_POS_get_write_enable2(data)                           ((0x00400000&(data))>>22)
#define TVE_WSS_POS_get_wss_h_pos(data)                               ((0x003FF800&(data))>>11)
#define TVE_WSS_POS_get_write_enable1(data)                           ((0x00000400&(data))>>10)
#define TVE_WSS_POS_get_wss_v_pos(data)                               (0x000003FF&(data))

#define TVE_WSS_END_HPOS                                              0x18018138
#define TVE_WSS_END_HPOS_reg_addr                                     "0xB8018138"
#define TVE_WSS_END_HPOS_reg                                          0xB8018138
#define TVE_WSS_END_HPOS_inst_addr                                    "0x004E"
#define TVE_WSS_END_HPOS_inst                                         0x004E
#define TVE_WSS_END_HPOS_wss_end_hpos_shift                           (0)
#define TVE_WSS_END_HPOS_wss_end_hpos_mask                            (0x000007FF)
#define TVE_WSS_END_HPOS_wss_end_hpos(data)                           (0x000007FF&(data))
#define TVE_WSS_END_HPOS_get_wss_end_hpos(data)                       (0x000007FF&(data))

#define TVE_TT_CTRL                                                   0x18018024
#define TVE_TT_CTRL_reg_addr                                          "0xB8018024"
#define TVE_TT_CTRL_reg                                               0xB8018024
#define TVE_TT_CTRL_inst_addr                                         "0x0009"
#define TVE_TT_CTRL_inst                                              0x0009
#define TVE_TT_CTRL_write_enable4_shift                               (24)
#define TVE_TT_CTRL_tt_h_st_shift                                     (13)
#define TVE_TT_CTRL_write_enable3_shift                               (12)
#define TVE_TT_CTRL_tt_line_no_shift                                  (4)
#define TVE_TT_CTRL_write_enable2_shift                               (3)
#define TVE_TT_CTRL_tt_intp_sel_shift                                 (2)
#define TVE_TT_CTRL_write_enable1_shift                               (1)
#define TVE_TT_CTRL_vbi_tt_ebl_shift                                  (0)
#define TVE_TT_CTRL_write_enable4_mask                                (0x01000000)
#define TVE_TT_CTRL_tt_h_st_mask                                      (0x00FFE000)
#define TVE_TT_CTRL_write_enable3_mask                                (0x00001000)
#define TVE_TT_CTRL_tt_line_no_mask                                   (0x00000FF0)
#define TVE_TT_CTRL_write_enable2_mask                                (0x00000008)
#define TVE_TT_CTRL_tt_intp_sel_mask                                  (0x00000004)
#define TVE_TT_CTRL_write_enable1_mask                                (0x00000002)
#define TVE_TT_CTRL_vbi_tt_ebl_mask                                   (0x00000001)
#define TVE_TT_CTRL_write_enable4(data)                               (0x01000000&((data)<<24))
#define TVE_TT_CTRL_tt_h_st(data)                                     (0x00FFE000&((data)<<13))
#define TVE_TT_CTRL_write_enable3(data)                               (0x00001000&((data)<<12))
#define TVE_TT_CTRL_tt_line_no(data)                                  (0x00000FF0&((data)<<4))
#define TVE_TT_CTRL_write_enable2(data)                               (0x00000008&((data)<<3))
#define TVE_TT_CTRL_tt_intp_sel(data)                                 (0x00000004&((data)<<2))
#define TVE_TT_CTRL_write_enable1(data)                               (0x00000002&((data)<<1))
#define TVE_TT_CTRL_vbi_tt_ebl(data)                                  (0x00000001&(data))
#define TVE_TT_CTRL_get_write_enable4(data)                           ((0x01000000&(data))>>24)
#define TVE_TT_CTRL_get_tt_h_st(data)                                 ((0x00FFE000&(data))>>13)
#define TVE_TT_CTRL_get_write_enable3(data)                           ((0x00001000&(data))>>12)
#define TVE_TT_CTRL_get_tt_line_no(data)                              ((0x00000FF0&(data))>>4)
#define TVE_TT_CTRL_get_write_enable2(data)                           ((0x00000008&(data))>>3)
#define TVE_TT_CTRL_get_tt_intp_sel(data)                             ((0x00000004&(data))>>2)
#define TVE_TT_CTRL_get_write_enable1(data)                           ((0x00000002&(data))>>1)
#define TVE_TT_CTRL_get_vbi_tt_ebl(data)                              (0x00000001&(data))

#define TVE_TT_VSTART                                                 0x18018028
#define TVE_TT_VSTART_reg_addr                                        "0xB8018028"
#define TVE_TT_VSTART_reg                                             0xB8018028
#define TVE_TT_VSTART_inst_addr                                       "0x000A"
#define TVE_TT_VSTART_inst                                            0x000A
#define TVE_TT_VSTART_write_enable2_shift                             (15)
#define TVE_TT_VSTART_tt_b_vst_shift                                  (6)
#define TVE_TT_VSTART_write_enable1_shift                             (5)
#define TVE_TT_VSTART_tt_t_vst_shift                                  (0)
#define TVE_TT_VSTART_write_enable2_mask                              (0x00008000)
#define TVE_TT_VSTART_tt_b_vst_mask                                   (0x00007FC0)
#define TVE_TT_VSTART_write_enable1_mask                              (0x00000020)
#define TVE_TT_VSTART_tt_t_vst_mask                                   (0x0000001F)
#define TVE_TT_VSTART_write_enable2(data)                             (0x00008000&((data)<<15))
#define TVE_TT_VSTART_tt_b_vst(data)                                  (0x00007FC0&((data)<<6))
#define TVE_TT_VSTART_write_enable1(data)                             (0x00000020&((data)<<5))
#define TVE_TT_VSTART_tt_t_vst(data)                                  (0x0000001F&(data))
#define TVE_TT_VSTART_get_write_enable2(data)                         ((0x00008000&(data))>>15)
#define TVE_TT_VSTART_get_tt_b_vst(data)                              ((0x00007FC0&(data))>>6)
#define TVE_TT_VSTART_get_write_enable1(data)                         ((0x00000020&(data))>>5)
#define TVE_TT_VSTART_get_tt_t_vst(data)                              (0x0000001F&(data))

#define TVE_VBI_DWN_CTRL                                              0x1801802C
#define TVE_VBI_DWN_CTRL_reg_addr                                     "0xB801802C"
#define TVE_VBI_DWN_CTRL_reg                                          0xB801802C
#define TVE_VBI_DWN_CTRL_inst_addr                                    "0x000B"
#define TVE_VBI_DWN_CTRL_inst                                         0x000B
#define TVE_VBI_DWN_CTRL_write_enable4_shift                          (31)
#define TVE_VBI_DWN_CTRL_dwn_ebl_shift                                (29)
#define TVE_VBI_DWN_CTRL_write_enable3_shift                          (28)
#define TVE_VBI_DWN_CTRL_dwn_i_p_sel_shift                            (27)
#define TVE_VBI_DWN_CTRL_write_enable2_shift                          (26)
#define TVE_VBI_DWN_CTRL_dwn_st_shift                                 (14)
#define TVE_VBI_DWN_CTRL_write_enable1_shift                          (13)
#define TVE_VBI_DWN_CTRL_dwn_end_shift                                (0)
#define TVE_VBI_DWN_CTRL_write_enable4_mask                           (0x80000000)
#define TVE_VBI_DWN_CTRL_dwn_ebl_mask                                 (0x60000000)
#define TVE_VBI_DWN_CTRL_write_enable3_mask                           (0x10000000)
#define TVE_VBI_DWN_CTRL_dwn_i_p_sel_mask                             (0x08000000)
#define TVE_VBI_DWN_CTRL_write_enable2_mask                           (0x04000000)
#define TVE_VBI_DWN_CTRL_dwn_st_mask                                  (0x03FFC000)
#define TVE_VBI_DWN_CTRL_write_enable1_mask                           (0x00002000)
#define TVE_VBI_DWN_CTRL_dwn_end_mask                                 (0x00001FFF)
#define TVE_VBI_DWN_CTRL_write_enable4(data)                          (0x80000000&((data)<<31))
#define TVE_VBI_DWN_CTRL_dwn_ebl(data)                                (0x60000000&((data)<<29))
#define TVE_VBI_DWN_CTRL_write_enable3(data)                          (0x10000000&((data)<<28))
#define TVE_VBI_DWN_CTRL_dwn_i_p_sel(data)                            (0x08000000&((data)<<27))
#define TVE_VBI_DWN_CTRL_write_enable2(data)                          (0x04000000&((data)<<26))
#define TVE_VBI_DWN_CTRL_dwn_st(data)                                 (0x03FFC000&((data)<<14))
#define TVE_VBI_DWN_CTRL_write_enable1(data)                          (0x00002000&((data)<<13))
#define TVE_VBI_DWN_CTRL_dwn_end(data)                                (0x00001FFF&(data))
#define TVE_VBI_DWN_CTRL_get_write_enable4(data)                      ((0x80000000&(data))>>31)
#define TVE_VBI_DWN_CTRL_get_dwn_ebl(data)                            ((0x60000000&(data))>>29)
#define TVE_VBI_DWN_CTRL_get_write_enable3(data)                      ((0x10000000&(data))>>28)
#define TVE_VBI_DWN_CTRL_get_dwn_i_p_sel(data)                        ((0x08000000&(data))>>27)
#define TVE_VBI_DWN_CTRL_get_write_enable2(data)                      ((0x04000000&(data))>>26)
#define TVE_VBI_DWN_CTRL_get_dwn_st(data)                             ((0x03FFC000&(data))>>14)
#define TVE_VBI_DWN_CTRL_get_write_enable1(data)                      ((0x00002000&(data))>>13)
#define TVE_VBI_DWN_CTRL_get_dwn_end(data)                            (0x00001FFF&(data))

#define TVE_VBI_START_LINE                                            0x180180E4
#define TVE_VBI_START_LINE_reg_addr                                   "0xB80180E4"
#define TVE_VBI_START_LINE_reg                                        0xB80180E4
#define TVE_VBI_START_LINE_inst_addr                                  "0x0039"
#define TVE_VBI_START_LINE_inst                                       0x0039
#define TVE_VBI_START_LINE_write_enable2_shift                        (23)
#define TVE_VBI_START_LINE_vbi_start_line2_shift                      (12)
#define TVE_VBI_START_LINE_write_enable1_shift                        (11)
#define TVE_VBI_START_LINE_vbi_start_line1_shift                      (0)
#define TVE_VBI_START_LINE_write_enable2_mask                         (0x00800000)
#define TVE_VBI_START_LINE_vbi_start_line2_mask                       (0x007FF000)
#define TVE_VBI_START_LINE_write_enable1_mask                         (0x00000800)
#define TVE_VBI_START_LINE_vbi_start_line1_mask                       (0x000007FF)
#define TVE_VBI_START_LINE_write_enable2(data)                        (0x00800000&((data)<<23))
#define TVE_VBI_START_LINE_vbi_start_line2(data)                      (0x007FF000&((data)<<12))
#define TVE_VBI_START_LINE_write_enable1(data)                        (0x00000800&((data)<<11))
#define TVE_VBI_START_LINE_vbi_start_line1(data)                      (0x000007FF&(data))
#define TVE_VBI_START_LINE_get_write_enable2(data)                    ((0x00800000&(data))>>23)
#define TVE_VBI_START_LINE_get_vbi_start_line2(data)                  ((0x007FF000&(data))>>12)
#define TVE_VBI_START_LINE_get_write_enable1(data)                    ((0x00000800&(data))>>11)
#define TVE_VBI_START_LINE_get_vbi_start_line1(data)                  (0x000007FF&(data))

#define TVE_VBI_LINE_FLG0                                             0x18018030
#define TVE_VBI_LINE_FLG0_reg_addr                                    "0xB8018030"
#define TVE_VBI_LINE_FLG0_reg                                         0xB8018030
#define TVE_VBI_LINE_FLG0_inst_addr                                   "0x000C"
#define TVE_VBI_LINE_FLG0_inst                                        0x000C
#define TVE_VBI_LINE_FLG0_vbi_line_flg_shift                          (0)
#define TVE_VBI_LINE_FLG0_vbi_line_flg_mask                           (0xFFFFFFFF)
#define TVE_VBI_LINE_FLG0_vbi_line_flg(data)                          (0xFFFFFFFF&(data))
#define TVE_VBI_LINE_FLG0_get_vbi_line_flg(data)                      (0xFFFFFFFF&(data))

#define TVE_VBI_LINE_FLG1                                             0x18018034
#define TVE_VBI_LINE_FLG1_reg_addr                                    "0xB8018034"
#define TVE_VBI_LINE_FLG1_reg                                         0xB8018034
#define TVE_VBI_LINE_FLG1_inst_addr                                   "0x000D"
#define TVE_VBI_LINE_FLG1_inst                                        0x000D
#define TVE_VBI_LINE_FLG1_vbi_line_flg_shift                          (0)
#define TVE_VBI_LINE_FLG1_vbi_line_flg_mask                           (0xFFFFFFFF)
#define TVE_VBI_LINE_FLG1_vbi_line_flg(data)                          (0xFFFFFFFF&(data))
#define TVE_VBI_LINE_FLG1_get_vbi_line_flg(data)                      (0xFFFFFFFF&(data))

#define TVE_VBI_LINE_PTY0                                             0x18018038
#define TVE_VBI_LINE_PTY0_reg_addr                                    "0xB8018038"
#define TVE_VBI_LINE_PTY0_reg                                         0xB8018038
#define TVE_VBI_LINE_PTY0_inst_addr                                   "0x000E"
#define TVE_VBI_LINE_PTY0_inst                                        0x000E
#define TVE_VBI_LINE_PTY0_vbi_pty_shift                               (0)
#define TVE_VBI_LINE_PTY0_vbi_pty_mask                                (0xFFFFFFFF)
#define TVE_VBI_LINE_PTY0_vbi_pty(data)                               (0xFFFFFFFF&(data))
#define TVE_VBI_LINE_PTY0_get_vbi_pty(data)                           (0xFFFFFFFF&(data))

#define TVE_VBI_LINE_PTY1                                             0x1801803C
#define TVE_VBI_LINE_PTY1_reg_addr                                    "0xB801803C"
#define TVE_VBI_LINE_PTY1_reg                                         0xB801803C
#define TVE_VBI_LINE_PTY1_inst_addr                                   "0x000F"
#define TVE_VBI_LINE_PTY1_inst                                        0x000F
#define TVE_VBI_LINE_PTY1_vbi_pty_shift                               (0)
#define TVE_VBI_LINE_PTY1_vbi_pty_mask                                (0xFFFFFFFF)
#define TVE_VBI_LINE_PTY1_vbi_pty(data)                               (0xFFFFFFFF&(data))
#define TVE_VBI_LINE_PTY1_get_vbi_pty(data)                           (0xFFFFFFFF&(data))

#define TVE_TT_MASK_START_LINE                                        0x18018114
#define TVE_TT_MASK_START_LINE_reg_addr                               "0xB8018114"
#define TVE_TT_MASK_START_LINE_reg                                    0xB8018114
#define TVE_TT_MASK_START_LINE_inst_addr                              "0x0045"
#define TVE_TT_MASK_START_LINE_inst                                   0x0045
#define TVE_TT_MASK_START_LINE_write_enable2_shift                    (23)
#define TVE_TT_MASK_START_LINE_start_line2_shift                      (12)
#define TVE_TT_MASK_START_LINE_write_enable1_shift                    (11)
#define TVE_TT_MASK_START_LINE_start_line1_shift                      (0)
#define TVE_TT_MASK_START_LINE_write_enable2_mask                     (0x00800000)
#define TVE_TT_MASK_START_LINE_start_line2_mask                       (0x007FF000)
#define TVE_TT_MASK_START_LINE_write_enable1_mask                     (0x00000800)
#define TVE_TT_MASK_START_LINE_start_line1_mask                       (0x000007FF)
#define TVE_TT_MASK_START_LINE_write_enable2(data)                    (0x00800000&((data)<<23))
#define TVE_TT_MASK_START_LINE_start_line2(data)                      (0x007FF000&((data)<<12))
#define TVE_TT_MASK_START_LINE_write_enable1(data)                    (0x00000800&((data)<<11))
#define TVE_TT_MASK_START_LINE_start_line1(data)                      (0x000007FF&(data))
#define TVE_TT_MASK_START_LINE_get_write_enable2(data)                ((0x00800000&(data))>>23)
#define TVE_TT_MASK_START_LINE_get_start_line2(data)                  ((0x007FF000&(data))>>12)
#define TVE_TT_MASK_START_LINE_get_write_enable1(data)                ((0x00000800&(data))>>11)
#define TVE_TT_MASK_START_LINE_get_start_line1(data)                  (0x000007FF&(data))

#define TVE_TT_MASK_LINE1                                             0x18018118
#define TVE_TT_MASK_LINE1_reg_addr                                    "0xB8018118"
#define TVE_TT_MASK_LINE1_reg                                         0xB8018118
#define TVE_TT_MASK_LINE1_inst_addr                                   "0x0046"
#define TVE_TT_MASK_LINE1_inst                                        0x0046
#define TVE_TT_MASK_LINE1_tt_line_mask_shift                          (0)
#define TVE_TT_MASK_LINE1_tt_line_mask_mask                           (0xFFFFFFFF)
#define TVE_TT_MASK_LINE1_tt_line_mask(data)                          (0xFFFFFFFF&(data))
#define TVE_TT_MASK_LINE1_get_tt_line_mask(data)                      (0xFFFFFFFF&(data))

#define TVE_TT_MASK_LINE2                                             0x1801811C
#define TVE_TT_MASK_LINE2_reg_addr                                    "0xB801811C"
#define TVE_TT_MASK_LINE2_reg                                         0xB801811C
#define TVE_TT_MASK_LINE2_inst_addr                                   "0x0047"
#define TVE_TT_MASK_LINE2_inst                                        0x0047
#define TVE_TT_MASK_LINE2_tt_line_mask_shift                          (0)
#define TVE_TT_MASK_LINE2_tt_line_mask_mask                           (0xFFFFFFFF)
#define TVE_TT_MASK_LINE2_tt_line_mask(data)                          (0xFFFFFFFF&(data))
#define TVE_TT_MASK_LINE2_get_tt_line_mask(data)                      (0xFFFFFFFF&(data))

#define TVE_VPS_CTRL                                                  0x18018120
#define TVE_VPS_CTRL_reg_addr                                         "0xB8018120"
#define TVE_VPS_CTRL_reg                                              0xB8018120
#define TVE_VPS_CTRL_inst_addr                                        "0x0048"
#define TVE_VPS_CTRL_inst                                             0x0048
#define TVE_VPS_CTRL_write_enable4_shift                              (26)
#define TVE_VPS_CTRL_vps_h_pos_shift                                  (15)
#define TVE_VPS_CTRL_write_enable3_shift                              (14)
#define TVE_VPS_CTRL_vps_v_pos_shift                                  (4)
#define TVE_VPS_CTRL_write_enable2_shift                              (3)
#define TVE_VPS_CTRL_vps_intp_sel_shift                               (2)
#define TVE_VPS_CTRL_write_enable1_shift                              (1)
#define TVE_VPS_CTRL_vbi_vps_ebl_shift                                (0)
#define TVE_VPS_CTRL_write_enable4_mask                               (0x04000000)
#define TVE_VPS_CTRL_vps_h_pos_mask                                   (0x03FF8000)
#define TVE_VPS_CTRL_write_enable3_mask                               (0x00004000)
#define TVE_VPS_CTRL_vps_v_pos_mask                                   (0x00003FF0)
#define TVE_VPS_CTRL_write_enable2_mask                               (0x00000008)
#define TVE_VPS_CTRL_vps_intp_sel_mask                                (0x00000004)
#define TVE_VPS_CTRL_write_enable1_mask                               (0x00000002)
#define TVE_VPS_CTRL_vbi_vps_ebl_mask                                 (0x00000001)
#define TVE_VPS_CTRL_write_enable4(data)                              (0x04000000&((data)<<26))
#define TVE_VPS_CTRL_vps_h_pos(data)                                  (0x03FF8000&((data)<<15))
#define TVE_VPS_CTRL_write_enable3(data)                              (0x00004000&((data)<<14))
#define TVE_VPS_CTRL_vps_v_pos(data)                                  (0x00003FF0&((data)<<4))
#define TVE_VPS_CTRL_write_enable2(data)                              (0x00000008&((data)<<3))
#define TVE_VPS_CTRL_vps_intp_sel(data)                               (0x00000004&((data)<<2))
#define TVE_VPS_CTRL_write_enable1(data)                              (0x00000002&((data)<<1))
#define TVE_VPS_CTRL_vbi_vps_ebl(data)                                (0x00000001&(data))
#define TVE_VPS_CTRL_get_write_enable4(data)                          ((0x04000000&(data))>>26)
#define TVE_VPS_CTRL_get_vps_h_pos(data)                              ((0x03FF8000&(data))>>15)
#define TVE_VPS_CTRL_get_write_enable3(data)                          ((0x00004000&(data))>>14)
#define TVE_VPS_CTRL_get_vps_v_pos(data)                              ((0x00003FF0&(data))>>4)
#define TVE_VPS_CTRL_get_write_enable2(data)                          ((0x00000008&(data))>>3)
#define TVE_VPS_CTRL_get_vps_intp_sel(data)                           ((0x00000004&(data))>>2)
#define TVE_VPS_CTRL_get_write_enable1(data)                          ((0x00000002&(data))>>1)
#define TVE_VPS_CTRL_get_vbi_vps_ebl(data)                            (0x00000001&(data))

#define TVE_VPS_DATA1                                                 0x18018124
#define TVE_VPS_DATA1_reg_addr                                        "0xB8018124"
#define TVE_VPS_DATA1_reg                                             0xB8018124
#define TVE_VPS_DATA1_inst_addr                                       "0x0049"
#define TVE_VPS_DATA1_inst                                            0x0049
#define TVE_VPS_DATA1_vps_data1_shift                                 (0)
#define TVE_VPS_DATA1_vps_data1_mask                                  (0xFFFFFFFF)
#define TVE_VPS_DATA1_vps_data1(data)                                 (0xFFFFFFFF&(data))
#define TVE_VPS_DATA1_get_vps_data1(data)                             (0xFFFFFFFF&(data))

#define TVE_VPS_DATA2                                                 0x18018128
#define TVE_VPS_DATA2_reg_addr                                        "0xB8018128"
#define TVE_VPS_DATA2_reg                                             0xB8018128
#define TVE_VPS_DATA2_inst_addr                                       "0x004A"
#define TVE_VPS_DATA2_inst                                            0x004A
#define TVE_VPS_DATA2_vps_data2_shift                                 (0)
#define TVE_VPS_DATA2_vps_data2_mask                                  (0xFFFFFFFF)
#define TVE_VPS_DATA2_vps_data2(data)                                 (0xFFFFFFFF&(data))
#define TVE_VPS_DATA2_get_vps_data2(data)                             (0xFFFFFFFF&(data))

#define TVE_VPS_DATA3                                                 0x1801812C
#define TVE_VPS_DATA3_reg_addr                                        "0xB801812C"
#define TVE_VPS_DATA3_reg                                             0xB801812C
#define TVE_VPS_DATA3_inst_addr                                       "0x004B"
#define TVE_VPS_DATA3_inst                                            0x004B
#define TVE_VPS_DATA3_vps_data3_shift                                 (0)
#define TVE_VPS_DATA3_vps_data3_mask                                  (0xFFFFFFFF)
#define TVE_VPS_DATA3_vps_data3(data)                                 (0xFFFFFFFF&(data))
#define TVE_VPS_DATA3_get_vps_data3(data)                             (0xFFFFFFFF&(data))

#define TVE_VPS_DATA4                                                 0x18018130
#define TVE_VPS_DATA4_reg_addr                                        "0xB8018130"
#define TVE_VPS_DATA4_reg                                             0xB8018130
#define TVE_VPS_DATA4_inst_addr                                       "0x004C"
#define TVE_VPS_DATA4_inst                                            0x004C
#define TVE_VPS_DATA4_vps_data4_shift                                 (0)
#define TVE_VPS_DATA4_vps_data4_mask                                  (0x000000FF)
#define TVE_VPS_DATA4_vps_data4(data)                                 (0x000000FF&(data))
#define TVE_VPS_DATA4_get_vps_data4(data)                             (0x000000FF&(data))

#define TVE_CAV_422                                                   0x18018040
#define TVE_CAV_422_reg_addr                                          "0xB8018040"
#define TVE_CAV_422_reg                                               0xB8018040
#define TVE_CAV_422_inst_addr                                         "0x0010"
#define TVE_CAV_422_inst                                              0x0010
#define TVE_CAV_422_fir422_sel_shift                                  (0)
#define TVE_CAV_422_fir422_sel_mask                                   (0x00000003)
#define TVE_CAV_422_fir422_sel(data)                                  (0x00000003&(data))
#define TVE_CAV_422_get_fir422_sel(data)                              (0x00000003&(data))

#define TVE_COMP_SYNCPOS                                              0x18018044
#define TVE_COMP_SYNCPOS_reg_addr                                     "0xB8018044"
#define TVE_COMP_SYNCPOS_reg                                          0xB8018044
#define TVE_COMP_SYNCPOS_inst_addr                                    "0x0011"
#define TVE_COMP_SYNCPOS_inst                                         0x0011
#define TVE_COMP_SYNCPOS_write_enable3_shift                          (29)
#define TVE_COMP_SYNCPOS_negsyncst_shift                              (20)
#define TVE_COMP_SYNCPOS_write_enable2_shift                          (19)
#define TVE_COMP_SYNCPOS_possyncst_shift                              (10)
#define TVE_COMP_SYNCPOS_write_enable1_shift                          (9)
#define TVE_COMP_SYNCPOS_syncend_shift                                (0)
#define TVE_COMP_SYNCPOS_write_enable3_mask                           (0x20000000)
#define TVE_COMP_SYNCPOS_negsyncst_mask                               (0x1FF00000)
#define TVE_COMP_SYNCPOS_write_enable2_mask                           (0x00080000)
#define TVE_COMP_SYNCPOS_possyncst_mask                               (0x0007FC00)
#define TVE_COMP_SYNCPOS_write_enable1_mask                           (0x00000200)
#define TVE_COMP_SYNCPOS_syncend_mask                                 (0x000001FF)
#define TVE_COMP_SYNCPOS_write_enable3(data)                          (0x20000000&((data)<<29))
#define TVE_COMP_SYNCPOS_negsyncst(data)                              (0x1FF00000&((data)<<20))
#define TVE_COMP_SYNCPOS_write_enable2(data)                          (0x00080000&((data)<<19))
#define TVE_COMP_SYNCPOS_possyncst(data)                              (0x0007FC00&((data)<<10))
#define TVE_COMP_SYNCPOS_write_enable1(data)                          (0x00000200&((data)<<9))
#define TVE_COMP_SYNCPOS_syncend(data)                                (0x000001FF&(data))
#define TVE_COMP_SYNCPOS_get_write_enable3(data)                      ((0x20000000&(data))>>29)
#define TVE_COMP_SYNCPOS_get_negsyncst(data)                          ((0x1FF00000&(data))>>20)
#define TVE_COMP_SYNCPOS_get_write_enable2(data)                      ((0x00080000&(data))>>19)
#define TVE_COMP_SYNCPOS_get_possyncst(data)                          ((0x0007FC00&(data))>>10)
#define TVE_COMP_SYNCPOS_get_write_enable1(data)                      ((0x00000200&(data))>>9)
#define TVE_COMP_SYNCPOS_get_syncend(data)                            (0x000001FF&(data))

#define TVE_SER_HPOS                                                  0x1801805C
#define TVE_SER_HPOS_reg_addr                                         "0xB801805C"
#define TVE_SER_HPOS_reg                                              0xB801805C
#define TVE_SER_HPOS_inst_addr                                        "0x0017"
#define TVE_SER_HPOS_inst                                             0x0017
#define TVE_SER_HPOS_write_enable2_shift                              (27)
#define TVE_SER_HPOS_ser_hstart_shift                                 (14)
#define TVE_SER_HPOS_write_enable1_shift                              (13)
#define TVE_SER_HPOS_ser_hend_shift                                   (0)
#define TVE_SER_HPOS_write_enable2_mask                               (0x08000000)
#define TVE_SER_HPOS_ser_hstart_mask                                  (0x07FFC000)
#define TVE_SER_HPOS_write_enable1_mask                               (0x00002000)
#define TVE_SER_HPOS_ser_hend_mask                                    (0x00001FFF)
#define TVE_SER_HPOS_write_enable2(data)                              (0x08000000&((data)<<27))
#define TVE_SER_HPOS_ser_hstart(data)                                 (0x07FFC000&((data)<<14))
#define TVE_SER_HPOS_write_enable1(data)                              (0x00002000&((data)<<13))
#define TVE_SER_HPOS_ser_hend(data)                                   (0x00001FFF&(data))
#define TVE_SER_HPOS_get_write_enable2(data)                          ((0x08000000&(data))>>27)
#define TVE_SER_HPOS_get_ser_hstart(data)                             ((0x07FFC000&(data))>>14)
#define TVE_SER_HPOS_get_write_enable1(data)                          ((0x00002000&(data))>>13)
#define TVE_SER_HPOS_get_ser_hend(data)                               (0x00001FFF&(data))

#define TVE_SER_VPOS                                                  0x18018060
#define TVE_SER_VPOS_reg_addr                                         "0xB8018060"
#define TVE_SER_VPOS_reg                                              0xB8018060
#define TVE_SER_VPOS_inst_addr                                        "0x0018"
#define TVE_SER_VPOS_inst                                             0x0018
#define TVE_SER_VPOS_write_enable2_shift                              (11)
#define TVE_SER_VPOS_ser_vstart_shift                                 (6)
#define TVE_SER_VPOS_write_enable1_shift                              (5)
#define TVE_SER_VPOS_ser_vend_shift                                   (0)
#define TVE_SER_VPOS_write_enable2_mask                               (0x00000800)
#define TVE_SER_VPOS_ser_vstart_mask                                  (0x000007C0)
#define TVE_SER_VPOS_write_enable1_mask                               (0x00000020)
#define TVE_SER_VPOS_ser_vend_mask                                    (0x0000001F)
#define TVE_SER_VPOS_write_enable2(data)                              (0x00000800&((data)<<11))
#define TVE_SER_VPOS_ser_vstart(data)                                 (0x000007C0&((data)<<6))
#define TVE_SER_VPOS_write_enable1(data)                              (0x00000020&((data)<<5))
#define TVE_SER_VPOS_ser_vend(data)                                   (0x0000001F&(data))
#define TVE_SER_VPOS_get_write_enable2(data)                          ((0x00000800&(data))>>11)
#define TVE_SER_VPOS_get_ser_vstart(data)                             ((0x000007C0&(data))>>6)
#define TVE_SER_VPOS_get_write_enable1(data)                          ((0x00000020&(data))>>5)
#define TVE_SER_VPOS_get_ser_vend(data)                               (0x0000001F&(data))

#define TVE_DSYNC_VPOS                                                0x18018064
#define TVE_DSYNC_VPOS_reg_addr                                       "0xB8018064"
#define TVE_DSYNC_VPOS_reg                                            0xB8018064
#define TVE_DSYNC_VPOS_inst_addr                                      "0x0019"
#define TVE_DSYNC_VPOS_inst                                           0x0019
#define TVE_DSYNC_VPOS_write_enable4_shift                            (23)
#define TVE_DSYNC_VPOS_dsync_t_vstart_shift                           (18)
#define TVE_DSYNC_VPOS_write_enable3_shift                            (17)
#define TVE_DSYNC_VPOS_dsync_t_vend_shift                             (12)
#define TVE_DSYNC_VPOS_write_enable2_shift                            (11)
#define TVE_DSYNC_VPOS_dsync_b_vstart_shift                           (6)
#define TVE_DSYNC_VPOS_write_enable1_shift                            (5)
#define TVE_DSYNC_VPOS_dsync_b_vend_shift                             (0)
#define TVE_DSYNC_VPOS_write_enable4_mask                             (0x00800000)
#define TVE_DSYNC_VPOS_dsync_t_vstart_mask                            (0x007C0000)
#define TVE_DSYNC_VPOS_write_enable3_mask                             (0x00020000)
#define TVE_DSYNC_VPOS_dsync_t_vend_mask                              (0x0001F000)
#define TVE_DSYNC_VPOS_write_enable2_mask                             (0x00000800)
#define TVE_DSYNC_VPOS_dsync_b_vstart_mask                            (0x000007C0)
#define TVE_DSYNC_VPOS_write_enable1_mask                             (0x00000020)
#define TVE_DSYNC_VPOS_dsync_b_vend_mask                              (0x0000001F)
#define TVE_DSYNC_VPOS_write_enable4(data)                            (0x00800000&((data)<<23))
#define TVE_DSYNC_VPOS_dsync_t_vstart(data)                           (0x007C0000&((data)<<18))
#define TVE_DSYNC_VPOS_write_enable3(data)                            (0x00020000&((data)<<17))
#define TVE_DSYNC_VPOS_dsync_t_vend(data)                             (0x0001F000&((data)<<12))
#define TVE_DSYNC_VPOS_write_enable2(data)                            (0x00000800&((data)<<11))
#define TVE_DSYNC_VPOS_dsync_b_vstart(data)                           (0x000007C0&((data)<<6))
#define TVE_DSYNC_VPOS_write_enable1(data)                            (0x00000020&((data)<<5))
#define TVE_DSYNC_VPOS_dsync_b_vend(data)                             (0x0000001F&(data))
#define TVE_DSYNC_VPOS_get_write_enable4(data)                        ((0x00800000&(data))>>23)
#define TVE_DSYNC_VPOS_get_dsync_t_vstart(data)                       ((0x007C0000&(data))>>18)
#define TVE_DSYNC_VPOS_get_write_enable3(data)                        ((0x00020000&(data))>>17)
#define TVE_DSYNC_VPOS_get_dsync_t_vend(data)                         ((0x0001F000&(data))>>12)
#define TVE_DSYNC_VPOS_get_write_enable2(data)                        ((0x00000800&(data))>>11)
#define TVE_DSYNC_VPOS_get_dsync_b_vstart(data)                       ((0x000007C0&(data))>>6)
#define TVE_DSYNC_VPOS_get_write_enable1(data)                        ((0x00000020&(data))>>5)
#define TVE_DSYNC_VPOS_get_dsync_b_vend(data)                         (0x0000001F&(data))

#define TVE_MV_CTL                                                    0x18018068
#define TVE_MV_CTL_reg_addr                                           "0xB8018068"
#define TVE_MV_CTL_reg                                                0xB8018068
#define TVE_MV_CTL_inst_addr                                          "0x001A"
#define TVE_MV_CTL_inst                                               0x001A
#define TVE_MV_CTL_mv_ebl_shift                                       (0)
#define TVE_MV_CTL_mv_ebl_mask                                        (0x00000001)
#define TVE_MV_CTL_mv_ebl(data)                                       (0x00000001&(data))
#define TVE_MV_CTL_get_mv_ebl(data)                                   (0x00000001&(data))

#define TVE_MV_RD                                                     0x1801806C
#define TVE_MV_RD_reg_addr                                            "0xB801806C"
#define TVE_MV_RD_reg                                                 0xB801806C
#define TVE_MV_RD_inst_addr                                           "0x001B"
#define TVE_MV_RD_inst                                                0x001B
#define TVE_MV_RD_mv_rd_shift                                         (0)
#define TVE_MV_RD_mv_rd_mask                                          (0x000FFFFF)
#define TVE_MV_RD_mv_rd(data)                                         (0x000FFFFF&(data))
#define TVE_MV_RD_get_mv_rd(data)                                     (0x000FFFFF&(data))

#define TVE_MV_DN                                                     0x18018070
#define TVE_MV_DN_reg_addr                                            "0xB8018070"
#define TVE_MV_DN_reg                                                 0xB8018070
#define TVE_MV_DN_inst_addr                                           "0x001C"
#define TVE_MV_DN_inst                                                0x001C
#define TVE_MV_DN_mv_dn_shift                                         (0)
#define TVE_MV_DN_mv_dn_mask                                          (0x000FFFFF)
#define TVE_MV_DN_mv_dn(data)                                         (0x000FFFFF&(data))
#define TVE_MV_DN_get_mv_dn(data)                                     (0x000FFFFF&(data))

#define TVE_MV_RU                                                     0x18018074
#define TVE_MV_RU_reg_addr                                            "0xB8018074"
#define TVE_MV_RU_reg                                                 0xB8018074
#define TVE_MV_RU_inst_addr                                           "0x001D"
#define TVE_MV_RU_inst                                                0x001D
#define TVE_MV_RU_mv_ru_shift                                         (0)
#define TVE_MV_RU_mv_ru_mask                                          (0x000FFFFF)
#define TVE_MV_RU_mv_ru(data)                                         (0x000FFFFF&(data))
#define TVE_MV_RU_get_mv_ru(data)                                     (0x000FFFFF&(data))

#define TVE_MV_UP                                                     0x18018078
#define TVE_MV_UP_reg_addr                                            "0xB8018078"
#define TVE_MV_UP_reg                                                 0xB8018078
#define TVE_MV_UP_inst_addr                                           "0x001E"
#define TVE_MV_UP_inst                                                0x001E
#define TVE_MV_UP_mv_up_shift                                         (0)
#define TVE_MV_UP_mv_up_mask                                          (0x000FFFFF)
#define TVE_MV_UP_mv_up(data)                                         (0x000FFFFF&(data))
#define TVE_MV_UP_get_mv_up(data)                                     (0x000FFFFF&(data))

#define TVE_PROG_MV_LEN                                               0x1801807C
#define TVE_PROG_MV_LEN_reg_addr                                      "0xB801807C"
#define TVE_PROG_MV_LEN_reg                                           0xB801807C
#define TVE_PROG_MV_LEN_inst_addr                                     "0x001F"
#define TVE_PROG_MV_LEN_inst                                          0x001F
#define TVE_PROG_MV_LEN_write_enable4_shift                           (29)
#define TVE_PROG_MV_LEN_mv_st_ps_shift                                (21)
#define TVE_PROG_MV_LEN_write_enable3_shift                           (20)
#define TVE_PROG_MV_LEN_mv_ps_len_shift                               (14)
#define TVE_PROG_MV_LEN_write_enable2_shift                           (13)
#define TVE_PROG_MV_LEN_mv_agc_len_shift                              (7)
#define TVE_PROG_MV_LEN_write_enable1_shift                           (6)
#define TVE_PROG_MV_LEN_mv_blnk_len_shift                             (0)
#define TVE_PROG_MV_LEN_write_enable4_mask                            (0x20000000)
#define TVE_PROG_MV_LEN_mv_st_ps_mask                                 (0x1FE00000)
#define TVE_PROG_MV_LEN_write_enable3_mask                            (0x00100000)
#define TVE_PROG_MV_LEN_mv_ps_len_mask                                (0x000FC000)
#define TVE_PROG_MV_LEN_write_enable2_mask                            (0x00002000)
#define TVE_PROG_MV_LEN_mv_agc_len_mask                               (0x00001F80)
#define TVE_PROG_MV_LEN_write_enable1_mask                            (0x00000040)
#define TVE_PROG_MV_LEN_mv_blnk_len_mask                              (0x0000003F)
#define TVE_PROG_MV_LEN_write_enable4(data)                           (0x20000000&((data)<<29))
#define TVE_PROG_MV_LEN_mv_st_ps(data)                                (0x1FE00000&((data)<<21))
#define TVE_PROG_MV_LEN_write_enable3(data)                           (0x00100000&((data)<<20))
#define TVE_PROG_MV_LEN_mv_ps_len(data)                               (0x000FC000&((data)<<14))
#define TVE_PROG_MV_LEN_write_enable2(data)                           (0x00002000&((data)<<13))
#define TVE_PROG_MV_LEN_mv_agc_len(data)                              (0x00001F80&((data)<<7))
#define TVE_PROG_MV_LEN_write_enable1(data)                           (0x00000040&((data)<<6))
#define TVE_PROG_MV_LEN_mv_blnk_len(data)                             (0x0000003F&(data))
#define TVE_PROG_MV_LEN_get_write_enable4(data)                       ((0x20000000&(data))>>29)
#define TVE_PROG_MV_LEN_get_mv_st_ps(data)                            ((0x1FE00000&(data))>>21)
#define TVE_PROG_MV_LEN_get_write_enable3(data)                       ((0x00100000&(data))>>20)
#define TVE_PROG_MV_LEN_get_mv_ps_len(data)                           ((0x000FC000&(data))>>14)
#define TVE_PROG_MV_LEN_get_write_enable2(data)                       ((0x00002000&(data))>>13)
#define TVE_PROG_MV_LEN_get_mv_agc_len(data)                          ((0x00001F80&(data))>>7)
#define TVE_PROG_MV_LEN_get_write_enable1(data)                       ((0x00000040&(data))>>6)
#define TVE_PROG_MV_LEN_get_mv_blnk_len(data)                         (0x0000003F&(data))

#define TVE_PROG_MV_LINE                                              0x180180F8
#define TVE_PROG_MV_LINE_reg_addr                                     "0xB80180F8"
#define TVE_PROG_MV_LINE_reg                                          0xB80180F8
#define TVE_PROG_MV_LINE_inst_addr                                    "0x003E"
#define TVE_PROG_MV_LINE_inst                                         0x003E
#define TVE_PROG_MV_LINE_write_enable2_shift                          (13)
#define TVE_PROG_MV_LINE_mv_end_line_shift                            (7)
#define TVE_PROG_MV_LINE_write_enable1_shift                          (6)
#define TVE_PROG_MV_LINE_mv_st_line_shift                             (0)
#define TVE_PROG_MV_LINE_write_enable2_mask                           (0x00002000)
#define TVE_PROG_MV_LINE_mv_end_line_mask                             (0x00001F80)
#define TVE_PROG_MV_LINE_write_enable1_mask                           (0x00000040)
#define TVE_PROG_MV_LINE_mv_st_line_mask                              (0x0000003F)
#define TVE_PROG_MV_LINE_write_enable2(data)                          (0x00002000&((data)<<13))
#define TVE_PROG_MV_LINE_mv_end_line(data)                            (0x00001F80&((data)<<7))
#define TVE_PROG_MV_LINE_write_enable1(data)                          (0x00000040&((data)<<6))
#define TVE_PROG_MV_LINE_mv_st_line(data)                             (0x0000003F&(data))
#define TVE_PROG_MV_LINE_get_write_enable2(data)                      ((0x00002000&(data))>>13)
#define TVE_PROG_MV_LINE_get_mv_end_line(data)                        ((0x00001F80&(data))>>7)
#define TVE_PROG_MV_LINE_get_write_enable1(data)                      ((0x00000040&(data))>>6)
#define TVE_PROG_MV_LINE_get_mv_st_line(data)                         (0x0000003F&(data))

#define TVE_PROG_MV_STN                                               0x18018080
#define TVE_PROG_MV_STN_reg_addr                                      "0xB8018080"
#define TVE_PROG_MV_STN_reg                                           0xB8018080
#define TVE_PROG_MV_STN_inst_addr                                     "0x0020"
#define TVE_PROG_MV_STN_inst                                          0x0020
#define TVE_PROG_MV_STN_write_enable3_shift                           (30)
#define TVE_PROG_MV_STN_mv_ru_dlt_shift                               (22)
#define TVE_PROG_MV_STN_write_enable2_shift                           (21)
#define TVE_PROG_MV_STN_mv_rd_dlt_shift                               (13)
#define TVE_PROG_MV_STN_write_enable1_shift                           (12)
#define TVE_PROG_MV_STN_mv_stn_shift                                  (0)
#define TVE_PROG_MV_STN_write_enable3_mask                            (0x40000000)
#define TVE_PROG_MV_STN_mv_ru_dlt_mask                                (0x3FC00000)
#define TVE_PROG_MV_STN_write_enable2_mask                            (0x00200000)
#define TVE_PROG_MV_STN_mv_rd_dlt_mask                                (0x001FE000)
#define TVE_PROG_MV_STN_write_enable1_mask                            (0x00001000)
#define TVE_PROG_MV_STN_mv_stn_mask                                   (0x00000FFF)
#define TVE_PROG_MV_STN_write_enable3(data)                           (0x40000000&((data)<<30))
#define TVE_PROG_MV_STN_mv_ru_dlt(data)                               (0x3FC00000&((data)<<22))
#define TVE_PROG_MV_STN_write_enable2(data)                           (0x00200000&((data)<<21))
#define TVE_PROG_MV_STN_mv_rd_dlt(data)                               (0x001FE000&((data)<<13))
#define TVE_PROG_MV_STN_write_enable1(data)                           (0x00001000&((data)<<12))
#define TVE_PROG_MV_STN_mv_stn(data)                                  (0x00000FFF&(data))
#define TVE_PROG_MV_STN_get_write_enable3(data)                       ((0x40000000&(data))>>30)
#define TVE_PROG_MV_STN_get_mv_ru_dlt(data)                           ((0x3FC00000&(data))>>22)
#define TVE_PROG_MV_STN_get_write_enable2(data)                       ((0x00200000&(data))>>21)
#define TVE_PROG_MV_STN_get_mv_rd_dlt(data)                           ((0x001FE000&(data))>>13)
#define TVE_PROG_MV_STN_get_write_enable1(data)                       ((0x00001000&(data))>>12)
#define TVE_PROG_MV_STN_get_mv_stn(data)                              (0x00000FFF&(data))

#define TVE_CONV_COEFS1                                               0x18018084
#define TVE_CONV_COEFS1_reg_addr                                      "0xB8018084"
#define TVE_CONV_COEFS1_reg                                           0xB8018084
#define TVE_CONV_COEFS1_inst_addr                                     "0x0021"
#define TVE_CONV_COEFS1_inst                                          0x0021
#define TVE_CONV_COEFS1_write_enable2_shift                           (31)
#define TVE_CONV_COEFS1_c2_shift                                      (16)
#define TVE_CONV_COEFS1_write_enable1_shift                           (15)
#define TVE_CONV_COEFS1_c1_shift                                      (0)
#define TVE_CONV_COEFS1_write_enable2_mask                            (0x80000000)
#define TVE_CONV_COEFS1_c2_mask                                       (0x7FFF0000)
#define TVE_CONV_COEFS1_write_enable1_mask                            (0x00008000)
#define TVE_CONV_COEFS1_c1_mask                                       (0x00007FFF)
#define TVE_CONV_COEFS1_write_enable2(data)                           (0x80000000&((data)<<31))
#define TVE_CONV_COEFS1_c2(data)                                      (0x7FFF0000&((data)<<16))
#define TVE_CONV_COEFS1_write_enable1(data)                           (0x00008000&((data)<<15))
#define TVE_CONV_COEFS1_c1(data)                                      (0x00007FFF&(data))
#define TVE_CONV_COEFS1_get_write_enable2(data)                       ((0x80000000&(data))>>31)
#define TVE_CONV_COEFS1_get_c2(data)                                  ((0x7FFF0000&(data))>>16)
#define TVE_CONV_COEFS1_get_write_enable1(data)                       ((0x00008000&(data))>>15)
#define TVE_CONV_COEFS1_get_c1(data)                                  (0x00007FFF&(data))

#define TVE_CONV_COEFS2                                               0x18018088
#define TVE_CONV_COEFS2_reg_addr                                      "0xB8018088"
#define TVE_CONV_COEFS2_reg                                           0xB8018088
#define TVE_CONV_COEFS2_inst_addr                                     "0x0022"
#define TVE_CONV_COEFS2_inst                                          0x0022
#define TVE_CONV_COEFS2_write_enable2_shift                           (31)
#define TVE_CONV_COEFS2_c4_shift                                      (16)
#define TVE_CONV_COEFS2_write_enable1_shift                           (15)
#define TVE_CONV_COEFS2_c3_shift                                      (0)
#define TVE_CONV_COEFS2_write_enable2_mask                            (0x80000000)
#define TVE_CONV_COEFS2_c4_mask                                       (0x7FFF0000)
#define TVE_CONV_COEFS2_write_enable1_mask                            (0x00008000)
#define TVE_CONV_COEFS2_c3_mask                                       (0x00007FFF)
#define TVE_CONV_COEFS2_write_enable2(data)                           (0x80000000&((data)<<31))
#define TVE_CONV_COEFS2_c4(data)                                      (0x7FFF0000&((data)<<16))
#define TVE_CONV_COEFS2_write_enable1(data)                           (0x00008000&((data)<<15))
#define TVE_CONV_COEFS2_c3(data)                                      (0x00007FFF&(data))
#define TVE_CONV_COEFS2_get_write_enable2(data)                       ((0x80000000&(data))>>31)
#define TVE_CONV_COEFS2_get_c4(data)                                  ((0x7FFF0000&(data))>>16)
#define TVE_CONV_COEFS2_get_write_enable1(data)                       ((0x00008000&(data))>>15)
#define TVE_CONV_COEFS2_get_c3(data)                                  (0x00007FFF&(data))

#define TVE_CONV_COEFS3                                               0x1801808C
#define TVE_CONV_COEFS3_reg_addr                                      "0xB801808C"
#define TVE_CONV_COEFS3_reg                                           0xB801808C
#define TVE_CONV_COEFS3_inst_addr                                     "0x0023"
#define TVE_CONV_COEFS3_inst                                          0x0023
#define TVE_CONV_COEFS3_write_enable2_shift                           (31)
#define TVE_CONV_COEFS3_c6_shift                                      (16)
#define TVE_CONV_COEFS3_write_enable1_shift                           (15)
#define TVE_CONV_COEFS3_c5_shift                                      (0)
#define TVE_CONV_COEFS3_write_enable2_mask                            (0x80000000)
#define TVE_CONV_COEFS3_c6_mask                                       (0x7FFF0000)
#define TVE_CONV_COEFS3_write_enable1_mask                            (0x00008000)
#define TVE_CONV_COEFS3_c5_mask                                       (0x00007FFF)
#define TVE_CONV_COEFS3_write_enable2(data)                           (0x80000000&((data)<<31))
#define TVE_CONV_COEFS3_c6(data)                                      (0x7FFF0000&((data)<<16))
#define TVE_CONV_COEFS3_write_enable1(data)                           (0x00008000&((data)<<15))
#define TVE_CONV_COEFS3_c5(data)                                      (0x00007FFF&(data))
#define TVE_CONV_COEFS3_get_write_enable2(data)                       ((0x80000000&(data))>>31)
#define TVE_CONV_COEFS3_get_c6(data)                                  ((0x7FFF0000&(data))>>16)
#define TVE_CONV_COEFS3_get_write_enable1(data)                       ((0x00008000&(data))>>15)
#define TVE_CONV_COEFS3_get_c5(data)                                  (0x00007FFF&(data))

#define TVE_CONV_COEFS4                                               0x18018090
#define TVE_CONV_COEFS4_reg_addr                                      "0xB8018090"
#define TVE_CONV_COEFS4_reg                                           0xB8018090
#define TVE_CONV_COEFS4_inst_addr                                     "0x0024"
#define TVE_CONV_COEFS4_inst                                          0x0024
#define TVE_CONV_COEFS4_write_enable2_shift                           (31)
#define TVE_CONV_COEFS4_k2_shift                                      (16)
#define TVE_CONV_COEFS4_write_enable1_shift                           (15)
#define TVE_CONV_COEFS4_k1_shift                                      (0)
#define TVE_CONV_COEFS4_write_enable2_mask                            (0x80000000)
#define TVE_CONV_COEFS4_k2_mask                                       (0x7FFF0000)
#define TVE_CONV_COEFS4_write_enable1_mask                            (0x00008000)
#define TVE_CONV_COEFS4_k1_mask                                       (0x00007FFF)
#define TVE_CONV_COEFS4_write_enable2(data)                           (0x80000000&((data)<<31))
#define TVE_CONV_COEFS4_k2(data)                                      (0x7FFF0000&((data)<<16))
#define TVE_CONV_COEFS4_write_enable1(data)                           (0x00008000&((data)<<15))
#define TVE_CONV_COEFS4_k1(data)                                      (0x00007FFF&(data))
#define TVE_CONV_COEFS4_get_write_enable2(data)                       ((0x80000000&(data))>>31)
#define TVE_CONV_COEFS4_get_k2(data)                                  ((0x7FFF0000&(data))>>16)
#define TVE_CONV_COEFS4_get_write_enable1(data)                       ((0x00008000&(data))>>15)
#define TVE_CONV_COEFS4_get_k1(data)                                  (0x00007FFF&(data))

#define TVE_CONV_COEFS5                                               0x18018110
#define TVE_CONV_COEFS5_reg_addr                                      "0xB8018110"
#define TVE_CONV_COEFS5_reg                                           0xB8018110
#define TVE_CONV_COEFS5_inst_addr                                     "0x0044"
#define TVE_CONV_COEFS5_inst                                          0x0044
#define TVE_CONV_COEFS5_k3_shift                                      (0)
#define TVE_CONV_COEFS5_k3_mask                                       (0x00007FFF)
#define TVE_CONV_COEFS5_k3(data)                                      (0x00007FFF&(data))
#define TVE_CONV_COEFS5_get_k3(data)                                  (0x00007FFF&(data))

#define TVE_MVVBI_CONV                                                0x18018094
#define TVE_MVVBI_CONV_reg_addr                                       "0xB8018094"
#define TVE_MVVBI_CONV_reg                                            0xB8018094
#define TVE_MVVBI_CONV_inst_addr                                      "0x0025"
#define TVE_MVVBI_CONV_inst                                           0x0025
#define TVE_MVVBI_CONV_write_enable2_shift                            (31)
#define TVE_MVVBI_CONV_gain_shift                                     (16)
#define TVE_MVVBI_CONV_write_enable1_shift                            (15)
#define TVE_MVVBI_CONV_offset_shift                                   (0)
#define TVE_MVVBI_CONV_write_enable2_mask                             (0x80000000)
#define TVE_MVVBI_CONV_gain_mask                                      (0x7FFF0000)
#define TVE_MVVBI_CONV_write_enable1_mask                             (0x00008000)
#define TVE_MVVBI_CONV_offset_mask                                    (0x00007FFF)
#define TVE_MVVBI_CONV_write_enable2(data)                            (0x80000000&((data)<<31))
#define TVE_MVVBI_CONV_gain(data)                                     (0x7FFF0000&((data)<<16))
#define TVE_MVVBI_CONV_write_enable1(data)                            (0x00008000&((data)<<15))
#define TVE_MVVBI_CONV_offset(data)                                   (0x00007FFF&(data))
#define TVE_MVVBI_CONV_get_write_enable2(data)                        ((0x80000000&(data))>>31)
#define TVE_MVVBI_CONV_get_gain(data)                                 ((0x7FFF0000&(data))>>16)
#define TVE_MVVBI_CONV_get_write_enable1(data)                        ((0x00008000&(data))>>15)
#define TVE_MVVBI_CONV_get_offset(data)                               (0x00007FFF&(data))

#define TVE_COMP_SYNCLVL                                              0x18018098
#define TVE_COMP_SYNCLVL_reg_addr                                     "0xB8018098"
#define TVE_COMP_SYNCLVL_reg                                          0xB8018098
#define TVE_COMP_SYNCLVL_inst_addr                                    "0x0026"
#define TVE_COMP_SYNCLVL_inst                                         0x0026
#define TVE_COMP_SYNCLVL_write_enable4_shift                          (30)
#define TVE_COMP_SYNCLVL_slewrate_shift                               (28)
#define TVE_COMP_SYNCLVL_write_enable3_shift                          (27)
#define TVE_COMP_SYNCLVL_hdsync_shift                                 (26)
#define TVE_COMP_SYNCLVL_write_enable2_shift                          (25)
#define TVE_COMP_SYNCLVL_y_negsynclvl_shift                           (13)
#define TVE_COMP_SYNCLVL_write_enable1_shift                          (12)
#define TVE_COMP_SYNCLVL_y_possynclvl_shift                           (0)
#define TVE_COMP_SYNCLVL_write_enable4_mask                           (0x40000000)
#define TVE_COMP_SYNCLVL_slewrate_mask                                (0x30000000)
#define TVE_COMP_SYNCLVL_write_enable3_mask                           (0x08000000)
#define TVE_COMP_SYNCLVL_hdsync_mask                                  (0x04000000)
#define TVE_COMP_SYNCLVL_write_enable2_mask                           (0x02000000)
#define TVE_COMP_SYNCLVL_y_negsynclvl_mask                            (0x01FFE000)
#define TVE_COMP_SYNCLVL_write_enable1_mask                           (0x00001000)
#define TVE_COMP_SYNCLVL_y_possynclvl_mask                            (0x00000FFF)
#define TVE_COMP_SYNCLVL_write_enable4(data)                          (0x40000000&((data)<<30))
#define TVE_COMP_SYNCLVL_slewrate(data)                               (0x30000000&((data)<<28))
#define TVE_COMP_SYNCLVL_write_enable3(data)                          (0x08000000&((data)<<27))
#define TVE_COMP_SYNCLVL_hdsync(data)                                 (0x04000000&((data)<<26))
#define TVE_COMP_SYNCLVL_write_enable2(data)                          (0x02000000&((data)<<25))
#define TVE_COMP_SYNCLVL_y_negsynclvl(data)                           (0x01FFE000&((data)<<13))
#define TVE_COMP_SYNCLVL_write_enable1(data)                          (0x00001000&((data)<<12))
#define TVE_COMP_SYNCLVL_y_possynclvl(data)                           (0x00000FFF&(data))
#define TVE_COMP_SYNCLVL_get_write_enable4(data)                      ((0x40000000&(data))>>30)
#define TVE_COMP_SYNCLVL_get_slewrate(data)                           ((0x30000000&(data))>>28)
#define TVE_COMP_SYNCLVL_get_write_enable3(data)                      ((0x08000000&(data))>>27)
#define TVE_COMP_SYNCLVL_get_hdsync(data)                             ((0x04000000&(data))>>26)
#define TVE_COMP_SYNCLVL_get_write_enable2(data)                      ((0x02000000&(data))>>25)
#define TVE_COMP_SYNCLVL_get_y_negsynclvl(data)                       ((0x01FFE000&(data))>>13)
#define TVE_COMP_SYNCLVL_get_write_enable1(data)                      ((0x00001000&(data))>>12)
#define TVE_COMP_SYNCLVL_get_y_possynclvl(data)                       (0x00000FFF&(data))

#define TVE_COMP_SLEW_SEL0                                            0x18018148
#define TVE_COMP_SLEW_SEL0_reg_addr                                   "0xB8018148"
#define TVE_COMP_SLEW_SEL0_reg                                        0xB8018148
#define TVE_COMP_SLEW_SEL0_inst_addr                                  "0x0052"
#define TVE_COMP_SLEW_SEL0_inst                                       0x0052
#define TVE_COMP_SLEW_SEL0_write_enable3_shift                        (27)
#define TVE_COMP_SLEW_SEL0_syncmod_sel_shift                          (26)
#define TVE_COMP_SLEW_SEL0_write_enable2_shift                        (25)
#define TVE_COMP_SLEW_SEL0_comp_sync_high_shift                       (13)
#define TVE_COMP_SLEW_SEL0_write_enable1_shift                        (12)
#define TVE_COMP_SLEW_SEL0_comp_sync_mid_shift                        (0)
#define TVE_COMP_SLEW_SEL0_write_enable3_mask                         (0x08000000)
#define TVE_COMP_SLEW_SEL0_syncmod_sel_mask                           (0x04000000)
#define TVE_COMP_SLEW_SEL0_write_enable2_mask                         (0x02000000)
#define TVE_COMP_SLEW_SEL0_comp_sync_high_mask                        (0x01FFE000)
#define TVE_COMP_SLEW_SEL0_write_enable1_mask                         (0x00001000)
#define TVE_COMP_SLEW_SEL0_comp_sync_mid_mask                         (0x00000FFF)
#define TVE_COMP_SLEW_SEL0_write_enable3(data)                        (0x08000000&((data)<<27))
#define TVE_COMP_SLEW_SEL0_syncmod_sel(data)                          (0x04000000&((data)<<26))
#define TVE_COMP_SLEW_SEL0_write_enable2(data)                        (0x02000000&((data)<<25))
#define TVE_COMP_SLEW_SEL0_comp_sync_high(data)                       (0x01FFE000&((data)<<13))
#define TVE_COMP_SLEW_SEL0_write_enable1(data)                        (0x00001000&((data)<<12))
#define TVE_COMP_SLEW_SEL0_comp_sync_mid(data)                        (0x00000FFF&(data))
#define TVE_COMP_SLEW_SEL0_get_write_enable3(data)                    ((0x08000000&(data))>>27)
#define TVE_COMP_SLEW_SEL0_get_syncmod_sel(data)                      ((0x04000000&(data))>>26)
#define TVE_COMP_SLEW_SEL0_get_write_enable2(data)                    ((0x02000000&(data))>>25)
#define TVE_COMP_SLEW_SEL0_get_comp_sync_high(data)                   ((0x01FFE000&(data))>>13)
#define TVE_COMP_SLEW_SEL0_get_write_enable1(data)                    ((0x00001000&(data))>>12)
#define TVE_COMP_SLEW_SEL0_get_comp_sync_mid(data)                    (0x00000FFF&(data))

#define TVE_COMP_SLEW_SEL1                                            0x1801814C
#define TVE_COMP_SLEW_SEL1_reg_addr                                   "0xB801814C"
#define TVE_COMP_SLEW_SEL1_reg                                        0xB801814C
#define TVE_COMP_SLEW_SEL1_inst_addr                                  "0x0053"
#define TVE_COMP_SLEW_SEL1_inst                                       0x0053
#define TVE_COMP_SLEW_SEL1_comp_sync_low_shift                        (0)
#define TVE_COMP_SLEW_SEL1_comp_sync_low_mask                         (0x00000FFF)
#define TVE_COMP_SLEW_SEL1_comp_sync_low(data)                        (0x00000FFF&(data))
#define TVE_COMP_SLEW_SEL1_get_comp_sync_low(data)                    (0x00000FFF&(data))

#define TVE_PBPR_SYNCLVL                                              0x1801809C
#define TVE_PBPR_SYNCLVL_reg_addr                                     "0xB801809C"
#define TVE_PBPR_SYNCLVL_reg                                          0xB801809C
#define TVE_PBPR_SYNCLVL_inst_addr                                    "0x0027"
#define TVE_PBPR_SYNCLVL_inst                                         0x0027
#define TVE_PBPR_SYNCLVL_write_enable2_shift                          (25)
#define TVE_PBPR_SYNCLVL_pbpr_negsynclvl_shift                        (13)
#define TVE_PBPR_SYNCLVL_write_enable1_shift                          (12)
#define TVE_PBPR_SYNCLVL_pbpr_possynclvl_shift                        (0)
#define TVE_PBPR_SYNCLVL_write_enable2_mask                           (0x02000000)
#define TVE_PBPR_SYNCLVL_pbpr_negsynclvl_mask                         (0x01FFE000)
#define TVE_PBPR_SYNCLVL_write_enable1_mask                           (0x00001000)
#define TVE_PBPR_SYNCLVL_pbpr_possynclvl_mask                         (0x00000FFF)
#define TVE_PBPR_SYNCLVL_write_enable2(data)                          (0x02000000&((data)<<25))
#define TVE_PBPR_SYNCLVL_pbpr_negsynclvl(data)                        (0x01FFE000&((data)<<13))
#define TVE_PBPR_SYNCLVL_write_enable1(data)                          (0x00001000&((data)<<12))
#define TVE_PBPR_SYNCLVL_pbpr_possynclvl(data)                        (0x00000FFF&(data))
#define TVE_PBPR_SYNCLVL_get_write_enable2(data)                      ((0x02000000&(data))>>25)
#define TVE_PBPR_SYNCLVL_get_pbpr_negsynclvl(data)                    ((0x01FFE000&(data))>>13)
#define TVE_PBPR_SYNCLVL_get_write_enable1(data)                      ((0x00001000&(data))>>12)
#define TVE_PBPR_SYNCLVL_get_pbpr_possynclvl(data)                    (0x00000FFF&(data))

#define TVE_BLANK_LVL                                                 0x180180FC
#define TVE_BLANK_LVL_reg_addr                                        "0xB80180FC"
#define TVE_BLANK_LVL_reg                                             0xB80180FC
#define TVE_BLANK_LVL_inst_addr                                       "0x003F"
#define TVE_BLANK_LVL_inst                                            0x003F
#define TVE_BLANK_LVL_write_enable2_shift                             (25)
#define TVE_BLANK_LVL_y_blank_lvl_shift                               (13)
#define TVE_BLANK_LVL_write_enable1_shift                             (12)
#define TVE_BLANK_LVL_pbpr_blank_lvl_shift                            (0)
#define TVE_BLANK_LVL_write_enable2_mask                              (0x02000000)
#define TVE_BLANK_LVL_y_blank_lvl_mask                                (0x01FFE000)
#define TVE_BLANK_LVL_write_enable1_mask                              (0x00001000)
#define TVE_BLANK_LVL_pbpr_blank_lvl_mask                             (0x00000FFF)
#define TVE_BLANK_LVL_write_enable2(data)                             (0x02000000&((data)<<25))
#define TVE_BLANK_LVL_y_blank_lvl(data)                               (0x01FFE000&((data)<<13))
#define TVE_BLANK_LVL_write_enable1(data)                             (0x00001000&((data)<<12))
#define TVE_BLANK_LVL_pbpr_blank_lvl(data)                            (0x00000FFF&(data))
#define TVE_BLANK_LVL_get_write_enable2(data)                         ((0x02000000&(data))>>25)
#define TVE_BLANK_LVL_get_y_blank_lvl(data)                           ((0x01FFE000&(data))>>13)
#define TVE_BLANK_LVL_get_write_enable1(data)                         ((0x00001000&(data))>>12)
#define TVE_BLANK_LVL_get_pbpr_blank_lvl(data)                        (0x00000FFF&(data))

#define TVE_G_CLAMP_LVL                                               0x18018140
#define TVE_G_CLAMP_LVL_reg_addr                                      "0xB8018140"
#define TVE_G_CLAMP_LVL_reg                                           0xB8018140
#define TVE_G_CLAMP_LVL_inst_addr                                     "0x0050"
#define TVE_G_CLAMP_LVL_inst                                          0x0050
#define TVE_G_CLAMP_LVL_write_enable2_shift                           (25)
#define TVE_G_CLAMP_LVL_g_up_lvl_shift                                (13)
#define TVE_G_CLAMP_LVL_write_enable1_shift                           (12)
#define TVE_G_CLAMP_LVL_g_down_lvl_shift                              (0)
#define TVE_G_CLAMP_LVL_write_enable2_mask                            (0x02000000)
#define TVE_G_CLAMP_LVL_g_up_lvl_mask                                 (0x01FFE000)
#define TVE_G_CLAMP_LVL_write_enable1_mask                            (0x00001000)
#define TVE_G_CLAMP_LVL_g_down_lvl_mask                               (0x00000FFF)
#define TVE_G_CLAMP_LVL_write_enable2(data)                           (0x02000000&((data)<<25))
#define TVE_G_CLAMP_LVL_g_up_lvl(data)                                (0x01FFE000&((data)<<13))
#define TVE_G_CLAMP_LVL_write_enable1(data)                           (0x00001000&((data)<<12))
#define TVE_G_CLAMP_LVL_g_down_lvl(data)                              (0x00000FFF&(data))
#define TVE_G_CLAMP_LVL_get_write_enable2(data)                       ((0x02000000&(data))>>25)
#define TVE_G_CLAMP_LVL_get_g_up_lvl(data)                            ((0x01FFE000&(data))>>13)
#define TVE_G_CLAMP_LVL_get_write_enable1(data)                       ((0x00001000&(data))>>12)
#define TVE_G_CLAMP_LVL_get_g_down_lvl(data)                          (0x00000FFF&(data))

#define TVE_RB_CLAMP_LVL                                              0x18018144
#define TVE_RB_CLAMP_LVL_reg_addr                                     "0xB8018144"
#define TVE_RB_CLAMP_LVL_reg                                          0xB8018144
#define TVE_RB_CLAMP_LVL_inst_addr                                    "0x0051"
#define TVE_RB_CLAMP_LVL_inst                                         0x0051
#define TVE_RB_CLAMP_LVL_write_enable2_shift                          (25)
#define TVE_RB_CLAMP_LVL_rb_up_lvl_shift                              (13)
#define TVE_RB_CLAMP_LVL_write_enable1_shift                          (12)
#define TVE_RB_CLAMP_LVL_rb_down_lvl_shift                            (0)
#define TVE_RB_CLAMP_LVL_write_enable2_mask                           (0x02000000)
#define TVE_RB_CLAMP_LVL_rb_up_lvl_mask                               (0x01FFE000)
#define TVE_RB_CLAMP_LVL_write_enable1_mask                           (0x00001000)
#define TVE_RB_CLAMP_LVL_rb_down_lvl_mask                             (0x00000FFF)
#define TVE_RB_CLAMP_LVL_write_enable2(data)                          (0x02000000&((data)<<25))
#define TVE_RB_CLAMP_LVL_rb_up_lvl(data)                              (0x01FFE000&((data)<<13))
#define TVE_RB_CLAMP_LVL_write_enable1(data)                          (0x00001000&((data)<<12))
#define TVE_RB_CLAMP_LVL_rb_down_lvl(data)                            (0x00000FFF&(data))
#define TVE_RB_CLAMP_LVL_get_write_enable2(data)                      ((0x02000000&(data))>>25)
#define TVE_RB_CLAMP_LVL_get_rb_up_lvl(data)                          ((0x01FFE000&(data))>>13)
#define TVE_RB_CLAMP_LVL_get_write_enable1(data)                      ((0x00001000&(data))>>12)
#define TVE_RB_CLAMP_LVL_get_rb_down_lvl(data)                        (0x00000FFF&(data))

#define TVE_BP_LVL                                                    0x18018150
#define TVE_BP_LVL_reg_addr                                           "0xB8018150"
#define TVE_BP_LVL_reg                                                0xB8018150
#define TVE_BP_LVL_inst_addr                                          "0x0054"
#define TVE_BP_LVL_inst                                               0x0054
#define TVE_BP_LVL_write_enable2_shift                                (14)
#define TVE_BP_LVL_rgb_mod_shift                                      (13)
#define TVE_BP_LVL_write_enable1_shift                                (12)
#define TVE_BP_LVL_bp_lvl_shift                                       (0)
#define TVE_BP_LVL_write_enable2_mask                                 (0x00004000)
#define TVE_BP_LVL_rgb_mod_mask                                       (0x00002000)
#define TVE_BP_LVL_write_enable1_mask                                 (0x00001000)
#define TVE_BP_LVL_bp_lvl_mask                                        (0x00000FFF)
#define TVE_BP_LVL_write_enable2(data)                                (0x00004000&((data)<<14))
#define TVE_BP_LVL_rgb_mod(data)                                      (0x00002000&((data)<<13))
#define TVE_BP_LVL_write_enable1(data)                                (0x00001000&((data)<<12))
#define TVE_BP_LVL_bp_lvl(data)                                       (0x00000FFF&(data))
#define TVE_BP_LVL_get_write_enable2(data)                            ((0x00004000&(data))>>14)
#define TVE_BP_LVL_get_rgb_mod(data)                                  ((0x00002000&(data))>>13)
#define TVE_BP_LVL_get_write_enable1(data)                            ((0x00001000&(data))>>12)
#define TVE_BP_LVL_get_bp_lvl(data)                                   (0x00000FFF&(data))

#define TVE_DIF_CTRL                                                  0x180180A0
#define TVE_DIF_CTRL_reg_addr                                         "0xB80180A0"
#define TVE_DIF_CTRL_reg                                              0xB80180A0
#define TVE_DIF_CTRL_inst_addr                                        "0x0028"
#define TVE_DIF_CTRL_inst                                             0x0028
#define TVE_DIF_CTRL_di_vbi_bypass_shift                              (6)
#define TVE_DIF_CTRL_di_ebl_shift                                     (5)
#define TVE_DIF_CTRL_di_source_sel_shift                              (4)
#define TVE_DIF_CTRL_di_mod_shift                                     (3)
#define TVE_DIF_CTRL_di_hdr_ebl_shift                                 (2)
#define TVE_DIF_CTRL_di_i_p_sel_shift                                 (1)
#define TVE_DIF_CTRL_write_data_shift                                 (0)
#define TVE_DIF_CTRL_di_vbi_bypass_mask                               (0x00000040)
#define TVE_DIF_CTRL_di_ebl_mask                                      (0x00000020)
#define TVE_DIF_CTRL_di_source_sel_mask                               (0x00000010)
#define TVE_DIF_CTRL_di_mod_mask                                      (0x00000008)
#define TVE_DIF_CTRL_di_hdr_ebl_mask                                  (0x00000004)
#define TVE_DIF_CTRL_di_i_p_sel_mask                                  (0x00000002)
#define TVE_DIF_CTRL_write_data_mask                                  (0x00000001)
#define TVE_DIF_CTRL_di_vbi_bypass(data)                              (0x00000040&((data)<<6))
#define TVE_DIF_CTRL_di_ebl(data)                                     (0x00000020&((data)<<5))
#define TVE_DIF_CTRL_di_source_sel(data)                              (0x00000010&((data)<<4))
#define TVE_DIF_CTRL_di_mod(data)                                     (0x00000008&((data)<<3))
#define TVE_DIF_CTRL_di_hdr_ebl(data)                                 (0x00000004&((data)<<2))
#define TVE_DIF_CTRL_di_i_p_sel(data)                                 (0x00000002&((data)<<1))
#define TVE_DIF_CTRL_write_data(data)                                 (0x00000001&(data))
#define TVE_DIF_CTRL_get_di_vbi_bypass(data)                          ((0x00000040&(data))>>6)
#define TVE_DIF_CTRL_get_di_ebl(data)                                 ((0x00000020&(data))>>5)
#define TVE_DIF_CTRL_get_di_source_sel(data)                          ((0x00000010&(data))>>4)
#define TVE_DIF_CTRL_get_di_mod(data)                                 ((0x00000008&(data))>>3)
#define TVE_DIF_CTRL_get_di_hdr_ebl(data)                             ((0x00000004&(data))>>2)
#define TVE_DIF_CTRL_get_di_i_p_sel(data)                             ((0x00000002&(data))>>1)
#define TVE_DIF_CTRL_get_write_data(data)                             (0x00000001&(data))

#define TVE_DIF_HSYNC                                                 0x180180B0
#define TVE_DIF_HSYNC_reg_addr                                        "0xB80180B0"
#define TVE_DIF_HSYNC_reg                                             0xB80180B0
#define TVE_DIF_HSYNC_inst_addr                                       "0x002C"
#define TVE_DIF_HSYNC_inst                                            0x002C
#define TVE_DIF_HSYNC_write_enable3_shift                             (29)
#define TVE_DIF_HSYNC_hs_polar_shift                                  (28)
#define TVE_DIF_HSYNC_write_enable2_shift                             (27)
#define TVE_DIF_HSYNC_hs_start_shift                                  (14)
#define TVE_DIF_HSYNC_write_enable1_shift                             (13)
#define TVE_DIF_HSYNC_hs_end_shift                                    (0)
#define TVE_DIF_HSYNC_write_enable3_mask                              (0x20000000)
#define TVE_DIF_HSYNC_hs_polar_mask                                   (0x10000000)
#define TVE_DIF_HSYNC_write_enable2_mask                              (0x08000000)
#define TVE_DIF_HSYNC_hs_start_mask                                   (0x07FFC000)
#define TVE_DIF_HSYNC_write_enable1_mask                              (0x00002000)
#define TVE_DIF_HSYNC_hs_end_mask                                     (0x00001FFF)
#define TVE_DIF_HSYNC_write_enable3(data)                             (0x20000000&((data)<<29))
#define TVE_DIF_HSYNC_hs_polar(data)                                  (0x10000000&((data)<<28))
#define TVE_DIF_HSYNC_write_enable2(data)                             (0x08000000&((data)<<27))
#define TVE_DIF_HSYNC_hs_start(data)                                  (0x07FFC000&((data)<<14))
#define TVE_DIF_HSYNC_write_enable1(data)                             (0x00002000&((data)<<13))
#define TVE_DIF_HSYNC_hs_end(data)                                    (0x00001FFF&(data))
#define TVE_DIF_HSYNC_get_write_enable3(data)                         ((0x20000000&(data))>>29)
#define TVE_DIF_HSYNC_get_hs_polar(data)                              ((0x10000000&(data))>>28)
#define TVE_DIF_HSYNC_get_write_enable2(data)                         ((0x08000000&(data))>>27)
#define TVE_DIF_HSYNC_get_hs_start(data)                              ((0x07FFC000&(data))>>14)
#define TVE_DIF_HSYNC_get_write_enable1(data)                         ((0x00002000&(data))>>13)
#define TVE_DIF_HSYNC_get_hs_end(data)                                (0x00001FFF&(data))

#define TVE_DIF_VS_ST_POS1                                            0x180180B4
#define TVE_DIF_VS_ST_POS1_reg_addr                                   "0xB80180B4"
#define TVE_DIF_VS_ST_POS1_reg                                        0xB80180B4
#define TVE_DIF_VS_ST_POS1_inst_addr                                  "0x002D"
#define TVE_DIF_VS_ST_POS1_inst                                       0x002D
#define TVE_DIF_VS_ST_POS1_write_enable3_shift                        (27)
#define TVE_DIF_VS_ST_POS1_vs_polar_shift                             (26)
#define TVE_DIF_VS_ST_POS1_write_enable2_shift                        (25)
#define TVE_DIF_VS_ST_POS1_vs_st_pos1v_shift                          (14)
#define TVE_DIF_VS_ST_POS1_write_enable1_shift                        (13)
#define TVE_DIF_VS_ST_POS1_vs_st_pos1h_shift                          (0)
#define TVE_DIF_VS_ST_POS1_write_enable3_mask                         (0x08000000)
#define TVE_DIF_VS_ST_POS1_vs_polar_mask                              (0x04000000)
#define TVE_DIF_VS_ST_POS1_write_enable2_mask                         (0x02000000)
#define TVE_DIF_VS_ST_POS1_vs_st_pos1v_mask                           (0x01FFC000)
#define TVE_DIF_VS_ST_POS1_write_enable1_mask                         (0x00002000)
#define TVE_DIF_VS_ST_POS1_vs_st_pos1h_mask                           (0x00001FFF)
#define TVE_DIF_VS_ST_POS1_write_enable3(data)                        (0x08000000&((data)<<27))
#define TVE_DIF_VS_ST_POS1_vs_polar(data)                             (0x04000000&((data)<<26))
#define TVE_DIF_VS_ST_POS1_write_enable2(data)                        (0x02000000&((data)<<25))
#define TVE_DIF_VS_ST_POS1_vs_st_pos1v(data)                          (0x01FFC000&((data)<<14))
#define TVE_DIF_VS_ST_POS1_write_enable1(data)                        (0x00002000&((data)<<13))
#define TVE_DIF_VS_ST_POS1_vs_st_pos1h(data)                          (0x00001FFF&(data))
#define TVE_DIF_VS_ST_POS1_get_write_enable3(data)                    ((0x08000000&(data))>>27)
#define TVE_DIF_VS_ST_POS1_get_vs_polar(data)                         ((0x04000000&(data))>>26)
#define TVE_DIF_VS_ST_POS1_get_write_enable2(data)                    ((0x02000000&(data))>>25)
#define TVE_DIF_VS_ST_POS1_get_vs_st_pos1v(data)                      ((0x01FFC000&(data))>>14)
#define TVE_DIF_VS_ST_POS1_get_write_enable1(data)                    ((0x00002000&(data))>>13)
#define TVE_DIF_VS_ST_POS1_get_vs_st_pos1h(data)                      (0x00001FFF&(data))

#define TVE_DIF_VS_END_POS1                                           0x180180B8
#define TVE_DIF_VS_END_POS1_reg_addr                                  "0xB80180B8"
#define TVE_DIF_VS_END_POS1_reg                                       0xB80180B8
#define TVE_DIF_VS_END_POS1_inst_addr                                 "0x002E"
#define TVE_DIF_VS_END_POS1_inst                                      0x002E
#define TVE_DIF_VS_END_POS1_write_enable2_shift                       (25)
#define TVE_DIF_VS_END_POS1_vs_end_pos1v_shift                        (14)
#define TVE_DIF_VS_END_POS1_write_enable1_shift                       (13)
#define TVE_DIF_VS_END_POS1_vs_end_pos1h_shift                        (0)
#define TVE_DIF_VS_END_POS1_write_enable2_mask                        (0x02000000)
#define TVE_DIF_VS_END_POS1_vs_end_pos1v_mask                         (0x01FFC000)
#define TVE_DIF_VS_END_POS1_write_enable1_mask                        (0x00002000)
#define TVE_DIF_VS_END_POS1_vs_end_pos1h_mask                         (0x00001FFF)
#define TVE_DIF_VS_END_POS1_write_enable2(data)                       (0x02000000&((data)<<25))
#define TVE_DIF_VS_END_POS1_vs_end_pos1v(data)                        (0x01FFC000&((data)<<14))
#define TVE_DIF_VS_END_POS1_write_enable1(data)                       (0x00002000&((data)<<13))
#define TVE_DIF_VS_END_POS1_vs_end_pos1h(data)                        (0x00001FFF&(data))
#define TVE_DIF_VS_END_POS1_get_write_enable2(data)                   ((0x02000000&(data))>>25)
#define TVE_DIF_VS_END_POS1_get_vs_end_pos1v(data)                    ((0x01FFC000&(data))>>14)
#define TVE_DIF_VS_END_POS1_get_write_enable1(data)                   ((0x00002000&(data))>>13)
#define TVE_DIF_VS_END_POS1_get_vs_end_pos1h(data)                    (0x00001FFF&(data))

#define TVE_DIF_VS_ST_POS2                                            0x180180BC
#define TVE_DIF_VS_ST_POS2_reg_addr                                   "0xB80180BC"
#define TVE_DIF_VS_ST_POS2_reg                                        0xB80180BC
#define TVE_DIF_VS_ST_POS2_inst_addr                                  "0x002F"
#define TVE_DIF_VS_ST_POS2_inst                                       0x002F
#define TVE_DIF_VS_ST_POS2_write_enable2_shift                        (25)
#define TVE_DIF_VS_ST_POS2_vs_st_pos2v_shift                          (14)
#define TVE_DIF_VS_ST_POS2_write_enable1_shift                        (13)
#define TVE_DIF_VS_ST_POS2_vs_st_pos2h_shift                          (0)
#define TVE_DIF_VS_ST_POS2_write_enable2_mask                         (0x02000000)
#define TVE_DIF_VS_ST_POS2_vs_st_pos2v_mask                           (0x01FFC000)
#define TVE_DIF_VS_ST_POS2_write_enable1_mask                         (0x00002000)
#define TVE_DIF_VS_ST_POS2_vs_st_pos2h_mask                           (0x00001FFF)
#define TVE_DIF_VS_ST_POS2_write_enable2(data)                        (0x02000000&((data)<<25))
#define TVE_DIF_VS_ST_POS2_vs_st_pos2v(data)                          (0x01FFC000&((data)<<14))
#define TVE_DIF_VS_ST_POS2_write_enable1(data)                        (0x00002000&((data)<<13))
#define TVE_DIF_VS_ST_POS2_vs_st_pos2h(data)                          (0x00001FFF&(data))
#define TVE_DIF_VS_ST_POS2_get_write_enable2(data)                    ((0x02000000&(data))>>25)
#define TVE_DIF_VS_ST_POS2_get_vs_st_pos2v(data)                      ((0x01FFC000&(data))>>14)
#define TVE_DIF_VS_ST_POS2_get_write_enable1(data)                    ((0x00002000&(data))>>13)
#define TVE_DIF_VS_ST_POS2_get_vs_st_pos2h(data)                      (0x00001FFF&(data))

#define TVE_DIF_VS_END_POS2                                           0x180180C0
#define TVE_DIF_VS_END_POS2_reg_addr                                  "0xB80180C0"
#define TVE_DIF_VS_END_POS2_reg                                       0xB80180C0
#define TVE_DIF_VS_END_POS2_inst_addr                                 "0x0030"
#define TVE_DIF_VS_END_POS2_inst                                      0x0030
#define TVE_DIF_VS_END_POS2_write_enable2_shift                       (25)
#define TVE_DIF_VS_END_POS2_vs_end_pos2v_shift                        (14)
#define TVE_DIF_VS_END_POS2_write_enable1_shift                       (13)
#define TVE_DIF_VS_END_POS2_vs_end_pos2h_shift                        (0)
#define TVE_DIF_VS_END_POS2_write_enable2_mask                        (0x02000000)
#define TVE_DIF_VS_END_POS2_vs_end_pos2v_mask                         (0x01FFC000)
#define TVE_DIF_VS_END_POS2_write_enable1_mask                        (0x00002000)
#define TVE_DIF_VS_END_POS2_vs_end_pos2h_mask                         (0x00001FFF)
#define TVE_DIF_VS_END_POS2_write_enable2(data)                       (0x02000000&((data)<<25))
#define TVE_DIF_VS_END_POS2_vs_end_pos2v(data)                        (0x01FFC000&((data)<<14))
#define TVE_DIF_VS_END_POS2_write_enable1(data)                       (0x00002000&((data)<<13))
#define TVE_DIF_VS_END_POS2_vs_end_pos2h(data)                        (0x00001FFF&(data))
#define TVE_DIF_VS_END_POS2_get_write_enable2(data)                   ((0x02000000&(data))>>25)
#define TVE_DIF_VS_END_POS2_get_vs_end_pos2v(data)                    ((0x01FFC000&(data))>>14)
#define TVE_DIF_VS_END_POS2_get_write_enable1(data)                   ((0x00002000&(data))>>13)
#define TVE_DIF_VS_END_POS2_get_vs_end_pos2h(data)                    (0x00001FFF&(data))

#define TVE_DIF_F_BIT_POS                                             0x18018100
#define TVE_DIF_F_BIT_POS_reg_addr                                    "0xB8018100"
#define TVE_DIF_F_BIT_POS_reg                                         0xB8018100
#define TVE_DIF_F_BIT_POS_inst_addr                                   "0x0040"
#define TVE_DIF_F_BIT_POS_inst                                        0x0040
#define TVE_DIF_F_BIT_POS_write_enable2_shift                         (23)
#define TVE_DIF_F_BIT_POS_v_tgl_hi_shift                              (12)
#define TVE_DIF_F_BIT_POS_write_enable1_shift                         (11)
#define TVE_DIF_F_BIT_POS_v_tgl_lo_shift                              (0)
#define TVE_DIF_F_BIT_POS_write_enable2_mask                          (0x00800000)
#define TVE_DIF_F_BIT_POS_v_tgl_hi_mask                               (0x007FF000)
#define TVE_DIF_F_BIT_POS_write_enable1_mask                          (0x00000800)
#define TVE_DIF_F_BIT_POS_v_tgl_lo_mask                               (0x000007FF)
#define TVE_DIF_F_BIT_POS_write_enable2(data)                         (0x00800000&((data)<<23))
#define TVE_DIF_F_BIT_POS_v_tgl_hi(data)                              (0x007FF000&((data)<<12))
#define TVE_DIF_F_BIT_POS_write_enable1(data)                         (0x00000800&((data)<<11))
#define TVE_DIF_F_BIT_POS_v_tgl_lo(data)                              (0x000007FF&(data))
#define TVE_DIF_F_BIT_POS_get_write_enable2(data)                     ((0x00800000&(data))>>23)
#define TVE_DIF_F_BIT_POS_get_v_tgl_hi(data)                          ((0x007FF000&(data))>>12)
#define TVE_DIF_F_BIT_POS_get_write_enable1(data)                     ((0x00000800&(data))>>11)
#define TVE_DIF_F_BIT_POS_get_v_tgl_lo(data)                          (0x000007FF&(data))

#define TVE_DIF_V_BIT_POS1                                            0x18018104
#define TVE_DIF_V_BIT_POS1_reg_addr                                   "0xB8018104"
#define TVE_DIF_V_BIT_POS1_reg                                        0xB8018104
#define TVE_DIF_V_BIT_POS1_inst_addr                                  "0x0041"
#define TVE_DIF_V_BIT_POS1_inst                                       0x0041
#define TVE_DIF_V_BIT_POS1_write_enable2_shift                        (23)
#define TVE_DIF_V_BIT_POS1_v_tgl1_hi_shift                            (12)
#define TVE_DIF_V_BIT_POS1_write_enable1_shift                        (11)
#define TVE_DIF_V_BIT_POS1_v_tgl1_lo_shift                            (0)
#define TVE_DIF_V_BIT_POS1_write_enable2_mask                         (0x00800000)
#define TVE_DIF_V_BIT_POS1_v_tgl1_hi_mask                             (0x007FF000)
#define TVE_DIF_V_BIT_POS1_write_enable1_mask                         (0x00000800)
#define TVE_DIF_V_BIT_POS1_v_tgl1_lo_mask                             (0x000007FF)
#define TVE_DIF_V_BIT_POS1_write_enable2(data)                        (0x00800000&((data)<<23))
#define TVE_DIF_V_BIT_POS1_v_tgl1_hi(data)                            (0x007FF000&((data)<<12))
#define TVE_DIF_V_BIT_POS1_write_enable1(data)                        (0x00000800&((data)<<11))
#define TVE_DIF_V_BIT_POS1_v_tgl1_lo(data)                            (0x000007FF&(data))
#define TVE_DIF_V_BIT_POS1_get_write_enable2(data)                    ((0x00800000&(data))>>23)
#define TVE_DIF_V_BIT_POS1_get_v_tgl1_hi(data)                        ((0x007FF000&(data))>>12)
#define TVE_DIF_V_BIT_POS1_get_write_enable1(data)                    ((0x00000800&(data))>>11)
#define TVE_DIF_V_BIT_POS1_get_v_tgl1_lo(data)                        (0x000007FF&(data))

#define TVE_DIF_V_BIT_POS2                                            0x18018108
#define TVE_DIF_V_BIT_POS2_reg_addr                                   "0xB8018108"
#define TVE_DIF_V_BIT_POS2_reg                                        0xB8018108
#define TVE_DIF_V_BIT_POS2_inst_addr                                  "0x0042"
#define TVE_DIF_V_BIT_POS2_inst                                       0x0042
#define TVE_DIF_V_BIT_POS2_write_enable2_shift                        (23)
#define TVE_DIF_V_BIT_POS2_v_tgl2_hi_shift                            (12)
#define TVE_DIF_V_BIT_POS2_write_enable1_shift                        (11)
#define TVE_DIF_V_BIT_POS2_v_tgl2_lo_shift                            (0)
#define TVE_DIF_V_BIT_POS2_write_enable2_mask                         (0x00800000)
#define TVE_DIF_V_BIT_POS2_v_tgl2_hi_mask                             (0x007FF000)
#define TVE_DIF_V_BIT_POS2_write_enable1_mask                         (0x00000800)
#define TVE_DIF_V_BIT_POS2_v_tgl2_lo_mask                             (0x000007FF)
#define TVE_DIF_V_BIT_POS2_write_enable2(data)                        (0x00800000&((data)<<23))
#define TVE_DIF_V_BIT_POS2_v_tgl2_hi(data)                            (0x007FF000&((data)<<12))
#define TVE_DIF_V_BIT_POS2_write_enable1(data)                        (0x00000800&((data)<<11))
#define TVE_DIF_V_BIT_POS2_v_tgl2_lo(data)                            (0x000007FF&(data))
#define TVE_DIF_V_BIT_POS2_get_write_enable2(data)                    ((0x00800000&(data))>>23)
#define TVE_DIF_V_BIT_POS2_get_v_tgl2_hi(data)                        ((0x007FF000&(data))>>12)
#define TVE_DIF_V_BIT_POS2_get_write_enable1(data)                    ((0x00000800&(data))>>11)
#define TVE_DIF_V_BIT_POS2_get_v_tgl2_lo(data)                        (0x000007FF&(data))

#define TVE_CMP_DLY                                                   0x180180C8
#define TVE_CMP_DLY_reg_addr                                          "0xB80180C8"
#define TVE_CMP_DLY_reg                                               0xB80180C8
#define TVE_CMP_DLY_inst_addr                                         "0x0032"
#define TVE_CMP_DLY_inst                                              0x0032
#define TVE_CMP_DLY_write_enable3_shift                               (8)
#define TVE_CMP_DLY_ygdelay_shift                                     (6)
#define TVE_CMP_DLY_write_enable2_shift                               (5)
#define TVE_CMP_DLY_bdelay_shift                                      (3)
#define TVE_CMP_DLY_write_enable1_shift                               (2)
#define TVE_CMP_DLY_rdelay_shift                                      (0)
#define TVE_CMP_DLY_write_enable3_mask                                (0x00000100)
#define TVE_CMP_DLY_ygdelay_mask                                      (0x000000C0)
#define TVE_CMP_DLY_write_enable2_mask                                (0x00000020)
#define TVE_CMP_DLY_bdelay_mask                                       (0x00000018)
#define TVE_CMP_DLY_write_enable1_mask                                (0x00000004)
#define TVE_CMP_DLY_rdelay_mask                                       (0x00000003)
#define TVE_CMP_DLY_write_enable3(data)                               (0x00000100&((data)<<8))
#define TVE_CMP_DLY_ygdelay(data)                                     (0x000000C0&((data)<<6))
#define TVE_CMP_DLY_write_enable2(data)                               (0x00000020&((data)<<5))
#define TVE_CMP_DLY_bdelay(data)                                      (0x00000018&((data)<<3))
#define TVE_CMP_DLY_write_enable1(data)                               (0x00000004&((data)<<2))
#define TVE_CMP_DLY_rdelay(data)                                      (0x00000003&(data))
#define TVE_CMP_DLY_get_write_enable3(data)                           ((0x00000100&(data))>>8)
#define TVE_CMP_DLY_get_ygdelay(data)                                 ((0x000000C0&(data))>>6)
#define TVE_CMP_DLY_get_write_enable2(data)                           ((0x00000020&(data))>>5)
#define TVE_CMP_DLY_get_bdelay(data)                                  ((0x00000018&(data))>>3)
#define TVE_CMP_DLY_get_write_enable1(data)                           ((0x00000004&(data))>>2)
#define TVE_CMP_DLY_get_rdelay(data)                                  (0x00000003&(data))

#define TVE_DAC_MUX                                                   0x180180CC
#define TVE_DAC_MUX_reg_addr                                          "0xB80180CC"
#define TVE_DAC_MUX_reg                                               0xB80180CC
#define TVE_DAC_MUX_inst_addr                                         "0x0033"
#define TVE_DAC_MUX_inst                                              0x0033
#define TVE_DAC_MUX_write_enable4_shift                               (8)
#define TVE_DAC_MUX_up_ctrl_shift                                     (7)
#define TVE_DAC_MUX_write_enable3_shift                               (6)
#define TVE_DAC_MUX_dacmode_shift                                     (4)
#define TVE_DAC_MUX_write_enable2_shift                               (3)
#define TVE_DAC_MUX_swap23_shift                                      (2)
#define TVE_DAC_MUX_write_enable1_shift                               (1)
#define TVE_DAC_MUX_swap56_shift                                      (0)
#define TVE_DAC_MUX_write_enable4_mask                                (0x00000100)
#define TVE_DAC_MUX_up_ctrl_mask                                      (0x00000080)
#define TVE_DAC_MUX_write_enable3_mask                                (0x00000040)
#define TVE_DAC_MUX_dacmode_mask                                      (0x00000030)
#define TVE_DAC_MUX_write_enable2_mask                                (0x00000008)
#define TVE_DAC_MUX_swap23_mask                                       (0x00000004)
#define TVE_DAC_MUX_write_enable1_mask                                (0x00000002)
#define TVE_DAC_MUX_swap56_mask                                       (0x00000001)
#define TVE_DAC_MUX_write_enable4(data)                               (0x00000100&((data)<<8))
#define TVE_DAC_MUX_up_ctrl(data)                                     (0x00000080&((data)<<7))
#define TVE_DAC_MUX_write_enable3(data)                               (0x00000040&((data)<<6))
#define TVE_DAC_MUX_dacmode(data)                                     (0x00000030&((data)<<4))
#define TVE_DAC_MUX_write_enable2(data)                               (0x00000008&((data)<<3))
#define TVE_DAC_MUX_swap23(data)                                      (0x00000004&((data)<<2))
#define TVE_DAC_MUX_write_enable1(data)                               (0x00000002&((data)<<1))
#define TVE_DAC_MUX_swap56(data)                                      (0x00000001&(data))
#define TVE_DAC_MUX_get_write_enable4(data)                           ((0x00000100&(data))>>8)
#define TVE_DAC_MUX_get_up_ctrl(data)                                 ((0x00000080&(data))>>7)
#define TVE_DAC_MUX_get_write_enable3(data)                           ((0x00000040&(data))>>6)
#define TVE_DAC_MUX_get_dacmode(data)                                 ((0x00000030&(data))>>4)
#define TVE_DAC_MUX_get_write_enable2(data)                           ((0x00000008&(data))>>3)
#define TVE_DAC_MUX_get_swap23(data)                                  ((0x00000004&(data))>>2)
#define TVE_DAC_MUX_get_write_enable1(data)                           ((0x00000002&(data))>>1)
#define TVE_DAC_MUX_get_swap56(data)                                  (0x00000001&(data))

#define TVE_DAC_CONTROL                                               0x18018134
#define TVE_DAC_CONTROL_reg_addr                                      "0xB8018134"
#define TVE_DAC_CONTROL_reg                                           0xB8018134
#define TVE_DAC_CONTROL_inst_addr                                     "0x004D"
#define TVE_DAC_CONTROL_inst                                          0x004D
#define TVE_DAC_CONTROL_write_enable3_shift                           (21)
#define TVE_DAC_CONTROL_neg_out_shift                                 (15)
#define TVE_DAC_CONTROL_write_enable2_shift                           (14)
#define TVE_DAC_CONTROL_out_control_shift                             (13)
#define TVE_DAC_CONTROL_write_enable1_shift                           (12)
#define TVE_DAC_CONTROL_dac_value_shift                               (0)
#define TVE_DAC_CONTROL_write_enable3_mask                            (0x00200000)
#define TVE_DAC_CONTROL_neg_out_mask                                  (0x001F8000)
#define TVE_DAC_CONTROL_write_enable2_mask                            (0x00004000)
#define TVE_DAC_CONTROL_out_control_mask                              (0x00002000)
#define TVE_DAC_CONTROL_write_enable1_mask                            (0x00001000)
#define TVE_DAC_CONTROL_dac_value_mask                                (0x00000FFF)
#define TVE_DAC_CONTROL_write_enable3(data)                           (0x00200000&((data)<<21))
#define TVE_DAC_CONTROL_neg_out(data)                                 (0x001F8000&((data)<<15))
#define TVE_DAC_CONTROL_write_enable2(data)                           (0x00004000&((data)<<14))
#define TVE_DAC_CONTROL_out_control(data)                             (0x00002000&((data)<<13))
#define TVE_DAC_CONTROL_write_enable1(data)                           (0x00001000&((data)<<12))
#define TVE_DAC_CONTROL_dac_value(data)                               (0x00000FFF&(data))
#define TVE_DAC_CONTROL_get_write_enable3(data)                       ((0x00200000&(data))>>21)
#define TVE_DAC_CONTROL_get_neg_out(data)                             ((0x001F8000&(data))>>15)
#define TVE_DAC_CONTROL_get_write_enable2(data)                       ((0x00004000&(data))>>14)
#define TVE_DAC_CONTROL_get_out_control(data)                         ((0x00002000&(data))>>13)
#define TVE_DAC_CONTROL_get_write_enable1(data)                       ((0x00001000&(data))>>12)
#define TVE_DAC_CONTROL_get_dac_value(data)                           (0x00000FFF&(data))

#define TVE_VIDEO_DAC_CTRL0                                           0x180180D0
#define TVE_VIDEO_DAC_CTRL0_reg_addr                                  "0xB80180D0"
#define TVE_VIDEO_DAC_CTRL0_reg                                       0xB80180D0
#define TVE_VIDEO_DAC_CTRL0_inst_addr                                 "0x0034"
#define TVE_VIDEO_DAC_CTRL0_inst                                      0x0034
#define TVE_VIDEO_DAC_CTRL0_apow_shift                                (20)
#define TVE_VIDEO_DAC_CTRL0_bpow_shift                                (19)
#define TVE_VIDEO_DAC_CTRL0_cpow_shift                                (18)
#define TVE_VIDEO_DAC_CTRL0_ckmode_shift                              (17)
#define TVE_VIDEO_DAC_CTRL0_powbias_shift                             (16)
#define TVE_VIDEO_DAC_CTRL0_sbias_all_shift                           (12)
#define TVE_VIDEO_DAC_CTRL0_sbias_a_shift                             (8)
#define TVE_VIDEO_DAC_CTRL0_sbias_b_shift                             (4)
#define TVE_VIDEO_DAC_CTRL0_sbias_c_shift                             (0)
#define TVE_VIDEO_DAC_CTRL0_apow_mask                                 (0x00100000)
#define TVE_VIDEO_DAC_CTRL0_bpow_mask                                 (0x00080000)
#define TVE_VIDEO_DAC_CTRL0_cpow_mask                                 (0x00040000)
#define TVE_VIDEO_DAC_CTRL0_ckmode_mask                               (0x00020000)
#define TVE_VIDEO_DAC_CTRL0_powbias_mask                              (0x00010000)
#define TVE_VIDEO_DAC_CTRL0_sbias_all_mask                            (0x0000F000)
#define TVE_VIDEO_DAC_CTRL0_sbias_a_mask                              (0x00000F00)
#define TVE_VIDEO_DAC_CTRL0_sbias_b_mask                              (0x000000F0)
#define TVE_VIDEO_DAC_CTRL0_sbias_c_mask                              (0x0000000F)
#define TVE_VIDEO_DAC_CTRL0_apow(data)                                (0x00100000&((data)<<20))
#define TVE_VIDEO_DAC_CTRL0_bpow(data)                                (0x00080000&((data)<<19))
#define TVE_VIDEO_DAC_CTRL0_cpow(data)                                (0x00040000&((data)<<18))
#define TVE_VIDEO_DAC_CTRL0_ckmode(data)                              (0x00020000&((data)<<17))
#define TVE_VIDEO_DAC_CTRL0_powbias(data)                             (0x00010000&((data)<<16))
#define TVE_VIDEO_DAC_CTRL0_sbias_all(data)                           (0x0000F000&((data)<<12))
#define TVE_VIDEO_DAC_CTRL0_sbias_a(data)                             (0x00000F00&((data)<<8))
#define TVE_VIDEO_DAC_CTRL0_sbias_b(data)                             (0x000000F0&((data)<<4))
#define TVE_VIDEO_DAC_CTRL0_sbias_c(data)                             (0x0000000F&(data))
#define TVE_VIDEO_DAC_CTRL0_get_apow(data)                            ((0x00100000&(data))>>20)
#define TVE_VIDEO_DAC_CTRL0_get_bpow(data)                            ((0x00080000&(data))>>19)
#define TVE_VIDEO_DAC_CTRL0_get_cpow(data)                            ((0x00040000&(data))>>18)
#define TVE_VIDEO_DAC_CTRL0_get_ckmode(data)                          ((0x00020000&(data))>>17)
#define TVE_VIDEO_DAC_CTRL0_get_powbias(data)                         ((0x00010000&(data))>>16)
#define TVE_VIDEO_DAC_CTRL0_get_sbias_all(data)                       ((0x0000F000&(data))>>12)
#define TVE_VIDEO_DAC_CTRL0_get_sbias_a(data)                         ((0x00000F00&(data))>>8)
#define TVE_VIDEO_DAC_CTRL0_get_sbias_b(data)                         ((0x000000F0&(data))>>4)
#define TVE_VIDEO_DAC_CTRL0_get_sbias_c(data)                         (0x0000000F&(data))

#define TVE_VIDEO_DAC_CTRL1                                           0x180180D4
#define TVE_VIDEO_DAC_CTRL1_reg_addr                                  "0xB80180D4"
#define TVE_VIDEO_DAC_CTRL1_reg                                       0xB80180D4
#define TVE_VIDEO_DAC_CTRL1_inst_addr                                 "0x0035"
#define TVE_VIDEO_DAC_CTRL1_inst                                      0x0035
#define TVE_VIDEO_DAC_CTRL1_apow_shift                                (20)
#define TVE_VIDEO_DAC_CTRL1_bpow_shift                                (19)
#define TVE_VIDEO_DAC_CTRL1_cpow_shift                                (18)
#define TVE_VIDEO_DAC_CTRL1_ckmode_shift                              (17)
#define TVE_VIDEO_DAC_CTRL1_powbias_shift                             (16)
#define TVE_VIDEO_DAC_CTRL1_sbias_all_shift                           (12)
#define TVE_VIDEO_DAC_CTRL1_sbias_a_shift                             (8)
#define TVE_VIDEO_DAC_CTRL1_sbias_b_shift                             (4)
#define TVE_VIDEO_DAC_CTRL1_sbias_c_shift                             (0)
#define TVE_VIDEO_DAC_CTRL1_apow_mask                                 (0x00100000)
#define TVE_VIDEO_DAC_CTRL1_bpow_mask                                 (0x00080000)
#define TVE_VIDEO_DAC_CTRL1_cpow_mask                                 (0x00040000)
#define TVE_VIDEO_DAC_CTRL1_ckmode_mask                               (0x00020000)
#define TVE_VIDEO_DAC_CTRL1_powbias_mask                              (0x00010000)
#define TVE_VIDEO_DAC_CTRL1_sbias_all_mask                            (0x0000F000)
#define TVE_VIDEO_DAC_CTRL1_sbias_a_mask                              (0x00000F00)
#define TVE_VIDEO_DAC_CTRL1_sbias_b_mask                              (0x000000F0)
#define TVE_VIDEO_DAC_CTRL1_sbias_c_mask                              (0x0000000F)
#define TVE_VIDEO_DAC_CTRL1_apow(data)                                (0x00100000&((data)<<20))
#define TVE_VIDEO_DAC_CTRL1_bpow(data)                                (0x00080000&((data)<<19))
#define TVE_VIDEO_DAC_CTRL1_cpow(data)                                (0x00040000&((data)<<18))
#define TVE_VIDEO_DAC_CTRL1_ckmode(data)                              (0x00020000&((data)<<17))
#define TVE_VIDEO_DAC_CTRL1_powbias(data)                             (0x00010000&((data)<<16))
#define TVE_VIDEO_DAC_CTRL1_sbias_all(data)                           (0x0000F000&((data)<<12))
#define TVE_VIDEO_DAC_CTRL1_sbias_a(data)                             (0x00000F00&((data)<<8))
#define TVE_VIDEO_DAC_CTRL1_sbias_b(data)                             (0x000000F0&((data)<<4))
#define TVE_VIDEO_DAC_CTRL1_sbias_c(data)                             (0x0000000F&(data))
#define TVE_VIDEO_DAC_CTRL1_get_apow(data)                            ((0x00100000&(data))>>20)
#define TVE_VIDEO_DAC_CTRL1_get_bpow(data)                            ((0x00080000&(data))>>19)
#define TVE_VIDEO_DAC_CTRL1_get_cpow(data)                            ((0x00040000&(data))>>18)
#define TVE_VIDEO_DAC_CTRL1_get_ckmode(data)                          ((0x00020000&(data))>>17)
#define TVE_VIDEO_DAC_CTRL1_get_powbias(data)                         ((0x00010000&(data))>>16)
#define TVE_VIDEO_DAC_CTRL1_get_sbias_all(data)                       ((0x0000F000&(data))>>12)
#define TVE_VIDEO_DAC_CTRL1_get_sbias_a(data)                         ((0x00000F00&(data))>>8)
#define TVE_VIDEO_DAC_CTRL1_get_sbias_b(data)                         ((0x000000F0&(data))>>4)
#define TVE_VIDEO_DAC_CTRL1_get_sbias_c(data)                         (0x0000000F&(data))

#define TVE_CTRL                                                      0x180180D8
#define TVE_CTRL_reg_addr                                             "0xB80180D8"
#define TVE_CTRL_reg                                                  0xB80180D8
#define TVE_CTRL_inst_addr                                            "0x0036"
#define TVE_CTRL_inst                                                 0x0036
#define TVE_CTRL_di_clk_phs_shift                                     (10)
#define TVE_CTRL_comp_ebl_shift                                       (9)
#define TVE_CTRL_sdtv_ebl_shift                                       (8)
#define TVE_CTRL_comp_sel_shift                                       (7)
#define TVE_CTRL_mv_rb_ebl_shift                                      (6)
#define TVE_CTRL_mv_g_ebl_shift                                       (5)
#define TVE_CTRL_vbi_rb_ebl_shift                                     (4)
#define TVE_CTRL_vbi_g_ebl_shift                                      (3)
#define TVE_CTRL_sync_rb_ebl_shift                                    (2)
#define TVE_CTRL_sync_g_ebl_shift                                     (1)
#define TVE_CTRL_write_data_shift                                     (0)
#define TVE_CTRL_di_clk_phs_mask                                      (0x00000400)
#define TVE_CTRL_comp_ebl_mask                                        (0x00000200)
#define TVE_CTRL_sdtv_ebl_mask                                        (0x00000100)
#define TVE_CTRL_comp_sel_mask                                        (0x00000080)
#define TVE_CTRL_mv_rb_ebl_mask                                       (0x00000040)
#define TVE_CTRL_mv_g_ebl_mask                                        (0x00000020)
#define TVE_CTRL_vbi_rb_ebl_mask                                      (0x00000010)
#define TVE_CTRL_vbi_g_ebl_mask                                       (0x00000008)
#define TVE_CTRL_sync_rb_ebl_mask                                     (0x00000004)
#define TVE_CTRL_sync_g_ebl_mask                                      (0x00000002)
#define TVE_CTRL_write_data_mask                                      (0x00000001)
#define TVE_CTRL_di_clk_phs(data)                                     (0x00000400&((data)<<10))
#define TVE_CTRL_comp_ebl(data)                                       (0x00000200&((data)<<9))
#define TVE_CTRL_sdtv_ebl(data)                                       (0x00000100&((data)<<8))
#define TVE_CTRL_comp_sel(data)                                       (0x00000080&((data)<<7))
#define TVE_CTRL_mv_rb_ebl(data)                                      (0x00000040&((data)<<6))
#define TVE_CTRL_mv_g_ebl(data)                                       (0x00000020&((data)<<5))
#define TVE_CTRL_vbi_rb_ebl(data)                                     (0x00000010&((data)<<4))
#define TVE_CTRL_vbi_g_ebl(data)                                      (0x00000008&((data)<<3))
#define TVE_CTRL_sync_rb_ebl(data)                                    (0x00000004&((data)<<2))
#define TVE_CTRL_sync_g_ebl(data)                                     (0x00000002&((data)<<1))
#define TVE_CTRL_write_data(data)                                     (0x00000001&(data))
#define TVE_CTRL_get_di_clk_phs(data)                                 ((0x00000400&(data))>>10)
#define TVE_CTRL_get_comp_ebl(data)                                   ((0x00000200&(data))>>9)
#define TVE_CTRL_get_sdtv_ebl(data)                                   ((0x00000100&(data))>>8)
#define TVE_CTRL_get_comp_sel(data)                                   ((0x00000080&(data))>>7)
#define TVE_CTRL_get_mv_rb_ebl(data)                                  ((0x00000040&(data))>>6)
#define TVE_CTRL_get_mv_g_ebl(data)                                   ((0x00000020&(data))>>5)
#define TVE_CTRL_get_vbi_rb_ebl(data)                                 ((0x00000010&(data))>>4)
#define TVE_CTRL_get_vbi_g_ebl(data)                                  ((0x00000008&(data))>>3)
#define TVE_CTRL_get_sync_rb_ebl(data)                                ((0x00000004&(data))>>2)
#define TVE_CTRL_get_sync_g_ebl(data)                                 ((0x00000002&(data))>>1)
#define TVE_CTRL_get_write_data(data)                                 (0x00000001&(data))

#define TVE_INTEN                                                     0x180180DC
#define TVE_INTEN_reg_addr                                            "0xB80180DC"
#define TVE_INTEN_reg                                                 0xB80180DC
#define TVE_INTEN_inst_addr                                           "0x0037"
#define TVE_INTEN_inst                                                0x0037
#define TVE_INTEN_inten_shift                                         (0)
#define TVE_INTEN_inten_mask                                          (0x00000001)
#define TVE_INTEN_inten(data)                                         (0x00000001&(data))
#define TVE_INTEN_get_inten(data)                                     (0x00000001&(data))

#define TVE_INTST                                                     0x180180E0
#define TVE_INTST_reg_addr                                            "0xB80180E0"
#define TVE_INTST_reg                                                 0xB80180E0
#define TVE_INTST_inst_addr                                           "0x0038"
#define TVE_INTST_inst                                                0x0038
#define TVE_INTST_intst_shift                                         (0)
#define TVE_INTST_intst_mask                                          (0x00000001)
#define TVE_INTST_intst(data)                                         (0x00000001&(data))
#define TVE_INTST_get_intst(data)                                     (0x00000001&(data))

#define TVE_INTPOS                                                    0x1801810C
#define TVE_INTPOS_reg_addr                                           "0xB801810C"
#define TVE_INTPOS_reg                                                0xB801810C
#define TVE_INTPOS_inst_addr                                          "0x0043"
#define TVE_INTPOS_inst                                               0x0043
#define TVE_INTPOS_write_enable3_shift                                (27)
#define TVE_INTPOS_int_pos_src_shift                                  (26)
#define TVE_INTPOS_write_enable2_shift                                (25)
#define TVE_INTPOS_int_vpos_shift                                     (14)
#define TVE_INTPOS_write_enable1_shift                                (13)
#define TVE_INTPOS_int_hpos_shift                                     (0)
#define TVE_INTPOS_write_enable3_mask                                 (0x08000000)
#define TVE_INTPOS_int_pos_src_mask                                   (0x04000000)
#define TVE_INTPOS_write_enable2_mask                                 (0x02000000)
#define TVE_INTPOS_int_vpos_mask                                      (0x01FFC000)
#define TVE_INTPOS_write_enable1_mask                                 (0x00002000)
#define TVE_INTPOS_int_hpos_mask                                      (0x00001FFF)
#define TVE_INTPOS_write_enable3(data)                                (0x08000000&((data)<<27))
#define TVE_INTPOS_int_pos_src(data)                                  (0x04000000&((data)<<26))
#define TVE_INTPOS_write_enable2(data)                                (0x02000000&((data)<<25))
#define TVE_INTPOS_int_vpos(data)                                     (0x01FFC000&((data)<<14))
#define TVE_INTPOS_write_enable1(data)                                (0x00002000&((data)<<13))
#define TVE_INTPOS_int_hpos(data)                                     (0x00001FFF&(data))
#define TVE_INTPOS_get_write_enable3(data)                            ((0x08000000&(data))>>27)
#define TVE_INTPOS_get_int_pos_src(data)                              ((0x04000000&(data))>>26)
#define TVE_INTPOS_get_write_enable2(data)                            ((0x02000000&(data))>>25)
#define TVE_INTPOS_get_int_vpos(data)                                 ((0x01FFC000&(data))>>14)
#define TVE_INTPOS_get_write_enable1(data)                            ((0x00002000&(data))>>13)
#define TVE_INTPOS_get_int_hpos(data)                                 (0x00001FFF&(data))

#define TVE_SRSTN                                                     0x180180E8
#define TVE_SRSTN_reg_addr                                            "0xB80180E8"
#define TVE_SRSTN_reg                                                 0xB80180E8
#define TVE_SRSTN_inst_addr                                           "0x003A"
#define TVE_SRSTN_inst                                                0x003A
#define TVE_SRSTN_srstn_shift                                         (0)
#define TVE_SRSTN_srstn_mask                                          (0x00000001)
#define TVE_SRSTN_srstn(data)                                         (0x00000001&(data))
#define TVE_SRSTN_get_srstn(data)                                     (0x00000001&(data))

#define TVE_IP_Y_GAIN                                                 0x18018154
#define TVE_IP_Y_GAIN_reg_addr                                        "0xB8018154"
#define TVE_IP_Y_GAIN_reg                                             0xB8018154
#define TVE_IP_Y_GAIN_inst_addr                                       "0x0055"
#define TVE_IP_Y_GAIN_inst                                            0x0055
#define TVE_IP_Y_GAIN_y_gain_shift                                    (0)
#define TVE_IP_Y_GAIN_y_gain_mask                                     (0x000003FF)
#define TVE_IP_Y_GAIN_y_gain(data)                                    (0x000003FF&(data))
#define TVE_IP_Y_GAIN_get_y_gain(data)                                (0x000003FF&(data))

#define TVE_PHS0                                                      0x18018880
#define TVE_PHS0_reg_addr                                             "0xB8018880"
#define TVE_PHS0_reg                                                  0xB8018880
#define TVE_PHS0_inst_addr                                            "0x0220"
#define TVE_PHS0_inst                                                 0x0220
#define TVE_PHS0_phi_shift                                            (0)
#define TVE_PHS0_phi_mask                                             (0x000000FF)
#define TVE_PHS0_phi(data)                                            (0x000000FF&(data))
#define TVE_PHS0_get_phi(data)                                        (0x000000FF&(data))

#define TVE_PHS1                                                      0x18018884
#define TVE_PHS1_reg_addr                                             "0xB8018884"
#define TVE_PHS1_reg                                                  0xB8018884
#define TVE_PHS1_inst_addr                                            "0x0221"
#define TVE_PHS1_inst                                                 0x0221
#define TVE_PHS1_phi_shift                                            (0)
#define TVE_PHS1_phi_mask                                             (0x000000FF)
#define TVE_PHS1_phi(data)                                            (0x000000FF&(data))
#define TVE_PHS1_get_phi(data)                                        (0x000000FF&(data))

#define TVE_PHS2                                                      0x18018888
#define TVE_PHS2_reg_addr                                             "0xB8018888"
#define TVE_PHS2_reg                                                  0xB8018888
#define TVE_PHS2_inst_addr                                            "0x0222"
#define TVE_PHS2_inst                                                 0x0222
#define TVE_PHS2_phi_shift                                            (0)
#define TVE_PHS2_phi_mask                                             (0x000000FF)
#define TVE_PHS2_phi(data)                                            (0x000000FF&(data))
#define TVE_PHS2_get_phi(data)                                        (0x000000FF&(data))

#define TVE_PHS3                                                      0x1801888C
#define TVE_PHS3_reg_addr                                             "0xB801888C"
#define TVE_PHS3_reg                                                  0xB801888C
#define TVE_PHS3_inst_addr                                            "0x0223"
#define TVE_PHS3_inst                                                 0x0223
#define TVE_PHS3_phi_shift                                            (0)
#define TVE_PHS3_phi_mask                                             (0x000000FF)
#define TVE_PHS3_phi(data)                                            (0x000000FF&(data))
#define TVE_PHS3_get_phi(data)                                        (0x000000FF&(data))

#define TVE_SCTOH0                                                    0x18018890
#define TVE_SCTOH0_reg_addr                                           "0xB8018890"
#define TVE_SCTOH0_reg                                                0xB8018890
#define TVE_SCTOH0_inst_addr                                          "0x0224"
#define TVE_SCTOH0_inst                                               0x0224
#define TVE_SCTOH0_sctoh_shift                                        (0)
#define TVE_SCTOH0_sctoh_mask                                         (0x000000FF)
#define TVE_SCTOH0_sctoh(data)                                        (0x000000FF&(data))
#define TVE_SCTOH0_get_sctoh(data)                                    (0x000000FF&(data))

#define TVE_SCTOH1                                                    0x18018894
#define TVE_SCTOH1_reg_addr                                           "0xB8018894"
#define TVE_SCTOH1_reg                                                0xB8018894
#define TVE_SCTOH1_inst_addr                                          "0x0225"
#define TVE_SCTOH1_inst                                               0x0225
#define TVE_SCTOH1_sctoh_shift                                        (0)
#define TVE_SCTOH1_sctoh_mask                                         (0x000000FF)
#define TVE_SCTOH1_sctoh(data)                                        (0x000000FF&(data))
#define TVE_SCTOH1_get_sctoh(data)                                    (0x000000FF&(data))

#define TVE_SCTOH2                                                    0x18018898
#define TVE_SCTOH2_reg_addr                                           "0xB8018898"
#define TVE_SCTOH2_reg                                                0xB8018898
#define TVE_SCTOH2_inst_addr                                          "0x0226"
#define TVE_SCTOH2_inst                                               0x0226
#define TVE_SCTOH2_sctoh_shift                                        (0)
#define TVE_SCTOH2_sctoh_mask                                         (0x000000FF)
#define TVE_SCTOH2_sctoh(data)                                        (0x000000FF&(data))
#define TVE_SCTOH2_get_sctoh(data)                                    (0x000000FF&(data))

#define TVE_SCTOH3                                                    0x1801889C
#define TVE_SCTOH3_reg_addr                                           "0xB801889C"
#define TVE_SCTOH3_reg                                                0xB801889C
#define TVE_SCTOH3_inst_addr                                          "0x0227"
#define TVE_SCTOH3_inst                                               0x0227
#define TVE_SCTOH3_sctoh_shift                                        (0)
#define TVE_SCTOH3_sctoh_mask                                         (0x000000FF)
#define TVE_SCTOH3_sctoh(data)                                        (0x000000FF&(data))
#define TVE_SCTOH3_get_sctoh(data)                                    (0x000000FF&(data))

#define TVE_F_CTRL                                                    0x180188A0
#define TVE_F_CTRL_reg_addr                                           "0xB80188A0"
#define TVE_F_CTRL_reg                                                0xB80188A0
#define TVE_F_CTRL_inst_addr                                          "0x0228"
#define TVE_F_CTRL_inst                                               0x0228
#define TVE_F_CTRL_u_invert_shift                                     (3)
#define TVE_F_CTRL_v_invert_shift                                     (2)
#define TVE_F_CTRL_t_offset_phase_shift                               (1)
#define TVE_F_CTRL_t_reset_fsc_shift                                  (0)
#define TVE_F_CTRL_u_invert_mask                                      (0x00000008)
#define TVE_F_CTRL_v_invert_mask                                      (0x00000004)
#define TVE_F_CTRL_t_offset_phase_mask                                (0x00000002)
#define TVE_F_CTRL_t_reset_fsc_mask                                   (0x00000001)
#define TVE_F_CTRL_u_invert(data)                                     (0x00000008&((data)<<3))
#define TVE_F_CTRL_v_invert(data)                                     (0x00000004&((data)<<2))
#define TVE_F_CTRL_t_offset_phase(data)                               (0x00000002&((data)<<1))
#define TVE_F_CTRL_t_reset_fsc(data)                                  (0x00000001&(data))
#define TVE_F_CTRL_get_u_invert(data)                                 ((0x00000008&(data))>>3)
#define TVE_F_CTRL_get_v_invert(data)                                 ((0x00000004&(data))>>2)
#define TVE_F_CTRL_get_t_offset_phase(data)                           ((0x00000002&(data))>>1)
#define TVE_F_CTRL_get_t_reset_fsc(data)                              (0x00000001&(data))

#define TVE_BLCK_LVL                                                  0x180188A8
#define TVE_BLCK_LVL_reg_addr                                         "0xB80188A8"
#define TVE_BLCK_LVL_reg                                              0xB80188A8
#define TVE_BLCK_LVL_inst_addr                                        "0x022A"
#define TVE_BLCK_LVL_inst                                             0x022A
#define TVE_BLCK_LVL_black_lvl_shift                                  (0)
#define TVE_BLCK_LVL_black_lvl_mask                                   (0x000000FF)
#define TVE_BLCK_LVL_black_lvl(data)                                  (0x000000FF&(data))
#define TVE_BLCK_LVL_get_black_lvl(data)                              (0x000000FF&(data))

#define TVE_BLNK_LVL                                                  0x180188AC
#define TVE_BLNK_LVL_reg_addr                                         "0xB80188AC"
#define TVE_BLNK_LVL_reg                                              0xB80188AC
#define TVE_BLNK_LVL_inst_addr                                        "0x022B"
#define TVE_BLNK_LVL_inst                                             0x022B
#define TVE_BLNK_LVL_blank_lvl_shift                                  (0)
#define TVE_BLNK_LVL_blank_lvl_mask                                   (0x000000FF)
#define TVE_BLNK_LVL_blank_lvl(data)                                  (0x000000FF&(data))
#define TVE_BLNK_LVL_get_blank_lvl(data)                              (0x000000FF&(data))

#define TVE_CLAMP_LVL                                                 0x180188B0
#define TVE_CLAMP_LVL_reg_addr                                        "0xB80188B0"
#define TVE_CLAMP_LVL_reg                                             0xB80188B0
#define TVE_CLAMP_LVL_inst_addr                                       "0x022C"
#define TVE_CLAMP_LVL_inst                                            0x022C
#define TVE_CLAMP_LVL_clamp_lvl_shift                                 (0)
#define TVE_CLAMP_LVL_clamp_lvl_mask                                  (0x000000FF)
#define TVE_CLAMP_LVL_clamp_lvl(data)                                 (0x000000FF&(data))
#define TVE_CLAMP_LVL_get_clamp_lvl(data)                             (0x000000FF&(data))

#define TVE_SYNC_LVL                                                  0x180188B4
#define TVE_SYNC_LVL_reg_addr                                         "0xB80188B4"
#define TVE_SYNC_LVL_reg                                              0xB80188B4
#define TVE_SYNC_LVL_inst_addr                                        "0x022D"
#define TVE_SYNC_LVL_inst                                             0x022D
#define TVE_SYNC_LVL_sync_lvl_shift                                   (0)
#define TVE_SYNC_LVL_sync_lvl_mask                                    (0x000000FF)
#define TVE_SYNC_LVL_sync_lvl(data)                                   (0x000000FF&(data))
#define TVE_SYNC_LVL_get_sync_lvl(data)                               (0x000000FF&(data))

#define TVE_Y_CTRL                                                    0x180188B8
#define TVE_Y_CTRL_reg_addr                                           "0xB80188B8"
#define TVE_Y_CTRL_reg                                                0xB80188B8
#define TVE_Y_CTRL_inst_addr                                          "0x022E"
#define TVE_Y_CTRL_inst                                               0x022E
#define TVE_Y_CTRL_y_interp_shift                                     (6)
#define TVE_Y_CTRL_y_colorbar_en_shift                                (5)
#define TVE_Y_CTRL_t_ydel_adj_shift                                   (2)
#define TVE_Y_CTRL_t_sel_ylpf0_shift                                  (1)
#define TVE_Y_CTRL_t_ygain_val_shift                                  (0)
#define TVE_Y_CTRL_y_interp_mask                                      (0x000000C0)
#define TVE_Y_CTRL_y_colorbar_en_mask                                 (0x00000020)
#define TVE_Y_CTRL_t_ydel_adj_mask                                    (0x0000001C)
#define TVE_Y_CTRL_t_sel_ylpf0_mask                                   (0x00000002)
#define TVE_Y_CTRL_t_ygain_val_mask                                   (0x00000001)
#define TVE_Y_CTRL_y_interp(data)                                     (0x000000C0&((data)<<6))
#define TVE_Y_CTRL_y_colorbar_en(data)                                (0x00000020&((data)<<5))
#define TVE_Y_CTRL_t_ydel_adj(data)                                   (0x0000001C&((data)<<2))
#define TVE_Y_CTRL_t_sel_ylpf0(data)                                  (0x00000002&((data)<<1))
#define TVE_Y_CTRL_t_ygain_val(data)                                  (0x00000001&(data))
#define TVE_Y_CTRL_get_y_interp(data)                                 ((0x000000C0&(data))>>6)
#define TVE_Y_CTRL_get_y_colorbar_en(data)                            ((0x00000020&(data))>>5)
#define TVE_Y_CTRL_get_t_ydel_adj(data)                               ((0x0000001C&(data))>>2)
#define TVE_Y_CTRL_get_t_sel_ylpf0(data)                              ((0x00000002&(data))>>1)
#define TVE_Y_CTRL_get_t_ygain_val(data)                              (0x00000001&(data))

#define TVE_O_CTRL                                                    0x180188BC
#define TVE_O_CTRL_reg_addr                                           "0xB80188BC"
#define TVE_O_CTRL_reg                                                0xB80188BC
#define TVE_O_CTRL_inst_addr                                          "0x022F"
#define TVE_O_CTRL_inst                                               0x022F
#define TVE_O_CTRL_y_tsel_yuv_shift                                   (3)
#define TVE_O_CTRL_t_pd_cvdac_shift                                   (2)
#define TVE_O_CTRL_t_pd_ydac_shift                                    (1)
#define TVE_O_CTRL_t_pd_cdac_shift                                    (0)
#define TVE_O_CTRL_y_tsel_yuv_mask                                    (0x00000008)
#define TVE_O_CTRL_t_pd_cvdac_mask                                    (0x00000004)
#define TVE_O_CTRL_t_pd_ydac_mask                                     (0x00000002)
#define TVE_O_CTRL_t_pd_cdac_mask                                     (0x00000001)
#define TVE_O_CTRL_y_tsel_yuv(data)                                   (0x00000008&((data)<<3))
#define TVE_O_CTRL_t_pd_cvdac(data)                                   (0x00000004&((data)<<2))
#define TVE_O_CTRL_t_pd_ydac(data)                                    (0x00000002&((data)<<1))
#define TVE_O_CTRL_t_pd_cdac(data)                                    (0x00000001&(data))
#define TVE_O_CTRL_get_y_tsel_yuv(data)                               ((0x00000008&(data))>>3)
#define TVE_O_CTRL_get_t_pd_cvdac(data)                               ((0x00000004&(data))>>2)
#define TVE_O_CTRL_get_t_pd_ydac(data)                                ((0x00000002&(data))>>1)
#define TVE_O_CTRL_get_t_pd_cdac(data)                                (0x00000001&(data))

#define TVE_NBA                                                       0x180188C8
#define TVE_NBA_reg_addr                                              "0xB80188C8"
#define TVE_NBA_reg                                                   0xB80188C8
#define TVE_NBA_inst_addr                                             "0x0232"
#define TVE_NBA_inst                                                  0x0232
#define TVE_NBA_nba_shift                                             (0)
#define TVE_NBA_nba_mask                                              (0x000000FF)
#define TVE_NBA_nba(data)                                             (0x000000FF&(data))
#define TVE_NBA_get_nba(data)                                         (0x000000FF&(data))

#define TVE_PBA                                                       0x180188CC
#define TVE_PBA_reg_addr                                              "0xB80188CC"
#define TVE_PBA_reg                                                   0xB80188CC
#define TVE_PBA_inst_addr                                             "0x0233"
#define TVE_PBA_inst                                                  0x0233
#define TVE_PBA_pba_shift                                             (0)
#define TVE_PBA_pba_mask                                              (0x000000FF)
#define TVE_PBA_pba(data)                                             (0x000000FF&(data))
#define TVE_PBA_get_pba(data)                                         (0x000000FF&(data))

#define TVE_C_CTRL                                                    0x180188D0
#define TVE_C_CTRL_reg_addr                                           "0xB80188D0"
#define TVE_C_CTRL_reg                                                0xB80188D0
#define TVE_C_CTRL_inst_addr                                          "0x0234"
#define TVE_C_CTRL_inst                                               0x0234
#define TVE_C_CTRL_t_pal_clpf_shift                                   (1)
#define TVE_C_CTRL_t_sel_c_gain_shift                                 (0)
#define TVE_C_CTRL_t_pal_clpf_mask                                    (0x00000002)
#define TVE_C_CTRL_t_sel_c_gain_mask                                  (0x00000001)
#define TVE_C_CTRL_t_pal_clpf(data)                                   (0x00000002&((data)<<1))
#define TVE_C_CTRL_t_sel_c_gain(data)                                 (0x00000001&(data))
#define TVE_C_CTRL_get_t_pal_clpf(data)                               ((0x00000002&(data))>>1)
#define TVE_C_CTRL_get_t_sel_c_gain(data)                             (0x00000001&(data))

#define TVE_S_CTRL                                                    0x180188E0
#define TVE_S_CTRL_reg_addr                                           "0xB80188E0"
#define TVE_S_CTRL_reg                                                0xB80188E0
#define TVE_S_CTRL_inst_addr                                          "0x0238"
#define TVE_S_CTRL_inst                                               0x0238
#define TVE_S_CTRL_t_hsync_phs_shift                                  (7)
#define TVE_S_CTRL_t_vsync_phs_shift                                  (6)
#define TVE_S_CTRL_y_tsyncmode_shift                                  (3)
#define TVE_S_CTRL_y_tencd_mode_shift                                 (0)
#define TVE_S_CTRL_t_hsync_phs_mask                                   (0x00000080)
#define TVE_S_CTRL_t_vsync_phs_mask                                   (0x00000040)
#define TVE_S_CTRL_y_tsyncmode_mask                                   (0x00000038)
#define TVE_S_CTRL_y_tencd_mode_mask                                  (0x00000007)
#define TVE_S_CTRL_t_hsync_phs(data)                                  (0x00000080&((data)<<7))
#define TVE_S_CTRL_t_vsync_phs(data)                                  (0x00000040&((data)<<6))
#define TVE_S_CTRL_y_tsyncmode(data)                                  (0x00000038&((data)<<3))
#define TVE_S_CTRL_y_tencd_mode(data)                                 (0x00000007&(data))
#define TVE_S_CTRL_get_t_hsync_phs(data)                              ((0x00000080&(data))>>7)
#define TVE_S_CTRL_get_t_vsync_phs(data)                              ((0x00000040&(data))>>6)
#define TVE_S_CTRL_get_y_tsyncmode(data)                              ((0x00000038&(data))>>3)
#define TVE_S_CTRL_get_y_tencd_mode(data)                             (0x00000007&(data))

#define TVE_VSO0                                                      0x180188E4
#define TVE_VSO0_reg_addr                                             "0xB80188E4"
#define TVE_VSO0_reg                                                  0xB80188E4
#define TVE_VSO0_inst_addr                                            "0x0239"
#define TVE_VSO0_inst                                                 0x0239
#define TVE_VSO0_clk_phs_shift                                        (6)
#define TVE_VSO0_t_fsync_enbl_shift                                   (5)
#define TVE_VSO0_t_fsync_phs_shift                                    (4)
#define TVE_VSO0_vso0_shift                                           (0)
#define TVE_VSO0_clk_phs_mask                                         (0x000000C0)
#define TVE_VSO0_t_fsync_enbl_mask                                    (0x00000020)
#define TVE_VSO0_t_fsync_phs_mask                                     (0x00000010)
#define TVE_VSO0_vso0_mask                                            (0x00000003)
#define TVE_VSO0_clk_phs(data)                                        (0x000000C0&((data)<<6))
#define TVE_VSO0_t_fsync_enbl(data)                                   (0x00000020&((data)<<5))
#define TVE_VSO0_t_fsync_phs(data)                                    (0x00000010&((data)<<4))
#define TVE_VSO0_vso0(data)                                           (0x00000003&(data))
#define TVE_VSO0_get_clk_phs(data)                                    ((0x000000C0&(data))>>6)
#define TVE_VSO0_get_t_fsync_enbl(data)                               ((0x00000020&(data))>>5)
#define TVE_VSO0_get_t_fsync_phs(data)                                ((0x00000010&(data))>>4)
#define TVE_VSO0_get_vso0(data)                                       (0x00000003&(data))

#define TVE_VSO1                                                      0x180188E8
#define TVE_VSO1_reg_addr                                             "0xB80188E8"
#define TVE_VSO1_reg                                                  0xB80188E8
#define TVE_VSO1_inst_addr                                            "0x023A"
#define TVE_VSO1_inst                                                 0x023A
#define TVE_VSO1_vso1_shift                                           (0)
#define TVE_VSO1_vso1_mask                                            (0x000000FF)
#define TVE_VSO1_vso1(data)                                           (0x000000FF&(data))
#define TVE_VSO1_get_vso1(data)                                       (0x000000FF&(data))

#define TVE_HSO0                                                      0x180188EC
#define TVE_HSO0_reg_addr                                             "0xB80188EC"
#define TVE_HSO0_reg                                                  0xB80188EC
#define TVE_HSO0_inst_addr                                            "0x023B"
#define TVE_HSO0_inst                                                 0x023B
#define TVE_HSO0_hso0_shift                                           (0)
#define TVE_HSO0_hso0_mask                                            (0x00000007)
#define TVE_HSO0_hso0(data)                                           (0x00000007&(data))
#define TVE_HSO0_get_hso0(data)                                       (0x00000007&(data))

#define TVE_HSO1                                                      0x180188F0
#define TVE_HSO1_reg_addr                                             "0xB80188F0"
#define TVE_HSO1_reg                                                  0xB80188F0
#define TVE_HSO1_inst_addr                                            "0x023C"
#define TVE_HSO1_inst                                                 0x023C
#define TVE_HSO1_hso1_shift                                           (0)
#define TVE_HSO1_hso1_mask                                            (0x000000FF)
#define TVE_HSO1_hso1(data)                                           (0x000000FF&(data))
#define TVE_HSO1_get_hso1(data)                                       (0x000000FF&(data))

#define TVE_HLC0                                                      0x180188F4
#define TVE_HLC0_reg_addr                                             "0xB80188F4"
#define TVE_HLC0_reg                                                  0xB80188F4
#define TVE_HLC0_inst_addr                                            "0x023D"
#define TVE_HLC0_inst                                                 0x023D
#define TVE_HLC0_hlc0_shift                                           (0)
#define TVE_HLC0_hlc0_mask                                            (0x00000003)
#define TVE_HLC0_hlc0(data)                                           (0x00000003&(data))
#define TVE_HLC0_get_hlc0(data)                                       (0x00000003&(data))

#define TVE_HLC1                                                      0x180188F8
#define TVE_HLC1_reg_addr                                             "0xB80188F8"
#define TVE_HLC1_reg                                                  0xB80188F8
#define TVE_HLC1_inst_addr                                            "0x023E"
#define TVE_HLC1_inst                                                 0x023E
#define TVE_HLC1_hlc1_shift                                           (0)
#define TVE_HLC1_hlc1_mask                                            (0x000000FF)
#define TVE_HLC1_hlc1(data)                                           (0x000000FF&(data))
#define TVE_HLC1_get_hlc1(data)                                       (0x000000FF&(data))

#define TVE_CCD_ODD0                                                  0x18018904
#define TVE_CCD_ODD0_reg_addr                                         "0xB8018904"
#define TVE_CCD_ODD0_reg                                              0xB8018904
#define TVE_CCD_ODD0_inst_addr                                        "0x0241"
#define TVE_CCD_ODD0_inst                                             0x0241
#define TVE_CCD_ODD0_ccd_odd1_shift                                   (0)
#define TVE_CCD_ODD0_ccd_odd1_mask                                    (0x000000FF)
#define TVE_CCD_ODD0_ccd_odd1(data)                                   (0x000000FF&(data))
#define TVE_CCD_ODD0_get_ccd_odd1(data)                               (0x000000FF&(data))

#define TVE_CCD_ODD1                                                  0x18018908
#define TVE_CCD_ODD1_reg_addr                                         "0xB8018908"
#define TVE_CCD_ODD1_reg                                              0xB8018908
#define TVE_CCD_ODD1_inst_addr                                        "0x0242"
#define TVE_CCD_ODD1_inst                                             0x0242
#define TVE_CCD_ODD1_ccd_odd0_shift                                   (0)
#define TVE_CCD_ODD1_ccd_odd0_mask                                    (0x000000FF)
#define TVE_CCD_ODD1_ccd_odd0(data)                                   (0x000000FF&(data))
#define TVE_CCD_ODD1_get_ccd_odd0(data)                               (0x000000FF&(data))

#define TVE_CCD_EVEN0                                                 0x1801890C
#define TVE_CCD_EVEN0_reg_addr                                        "0xB801890C"
#define TVE_CCD_EVEN0_reg                                             0xB801890C
#define TVE_CCD_EVEN0_inst_addr                                       "0x0243"
#define TVE_CCD_EVEN0_inst                                            0x0243
#define TVE_CCD_EVEN0_ccd_even1_shift                                 (0)
#define TVE_CCD_EVEN0_ccd_even1_mask                                  (0x000000FF)
#define TVE_CCD_EVEN0_ccd_even1(data)                                 (0x000000FF&(data))
#define TVE_CCD_EVEN0_get_ccd_even1(data)                             (0x000000FF&(data))

#define TVE_CCD_EVEN1                                                 0x18018910
#define TVE_CCD_EVEN1_reg_addr                                        "0xB8018910"
#define TVE_CCD_EVEN1_reg                                             0xB8018910
#define TVE_CCD_EVEN1_inst_addr                                       "0x0244"
#define TVE_CCD_EVEN1_inst                                            0x0244
#define TVE_CCD_EVEN1_ccd_even0_shift                                 (0)
#define TVE_CCD_EVEN1_ccd_even0_mask                                  (0x000000FF)
#define TVE_CCD_EVEN1_ccd_even0(data)                                 (0x000000FF&(data))
#define TVE_CCD_EVEN1_get_ccd_even0(data)                             (0x000000FF&(data))

#define TVE_CCD_ENBL                                                  0x18018914
#define TVE_CCD_ENBL_reg_addr                                         "0xB8018914"
#define TVE_CCD_ENBL_reg                                              0xB8018914
#define TVE_CCD_ENBL_inst_addr                                        "0x0245"
#define TVE_CCD_ENBL_inst                                             0x0245
#define TVE_CCD_ENBL_cc_enbl_shift                                    (0)
#define TVE_CCD_ENBL_cc_enbl_mask                                     (0x00000003)
#define TVE_CCD_ENBL_cc_enbl(data)                                    (0x00000003&(data))
#define TVE_CCD_ENBL_get_cc_enbl(data)                                (0x00000003&(data))

#define TVE_MVFCR                                                     0x18018920
#define TVE_MVFCR_reg_addr                                            "0xB8018920"
#define TVE_MVFCR_reg                                                 0xB8018920
#define TVE_MVFCR_inst_addr                                           "0x0248"
#define TVE_MVFCR_inst                                                0x0248
#define TVE_MVFCR_mvfcr_shift                                         (0)
#define TVE_MVFCR_mvfcr_mask                                          (0x000000FF)
#define TVE_MVFCR_mvfcr(data)                                         (0x000000FF&(data))
#define TVE_MVFCR_get_mvfcr(data)                                     (0x000000FF&(data))

#define TVE_MVCSL1                                                    0x18018924
#define TVE_MVCSL1_reg_addr                                           "0xB8018924"
#define TVE_MVCSL1_reg                                                0xB8018924
#define TVE_MVCSL1_inst_addr                                          "0x0249"
#define TVE_MVCSL1_inst                                               0x0249
#define TVE_MVCSL1_mvcsl1_shift                                       (0)
#define TVE_MVCSL1_mvcsl1_mask                                        (0x000000FF)
#define TVE_MVCSL1_mvcsl1(data)                                       (0x000000FF&(data))
#define TVE_MVCSL1_get_mvcsl1(data)                                   (0x000000FF&(data))

#define TVE_MVCLS1                                                    0x18018928
#define TVE_MVCLS1_reg_addr                                           "0xB8018928"
#define TVE_MVCLS1_reg                                                0xB8018928
#define TVE_MVCLS1_inst_addr                                          "0x024A"
#define TVE_MVCLS1_inst                                               0x024A
#define TVE_MVCLS1_mvcls1_shift                                       (0)
#define TVE_MVCLS1_mvcls1_mask                                        (0x0000003F)
#define TVE_MVCLS1_mvcls1(data)                                       (0x0000003F&(data))
#define TVE_MVCLS1_get_mvcls1(data)                                   (0x0000003F&(data))

#define TVE_MVCSL2                                                    0x1801892C
#define TVE_MVCSL2_reg_addr                                           "0xB801892C"
#define TVE_MVCSL2_reg                                                0xB801892C
#define TVE_MVCSL2_inst_addr                                          "0x024B"
#define TVE_MVCSL2_inst                                               0x024B
#define TVE_MVCSL2_mvcsl2_shift                                       (0)
#define TVE_MVCSL2_mvcsl2_mask                                        (0x000000FF)
#define TVE_MVCSL2_mvcsl2(data)                                       (0x000000FF&(data))
#define TVE_MVCSL2_get_mvcsl2(data)                                   (0x000000FF&(data))

#define TVE_MVCLS2                                                    0x18018930
#define TVE_MVCLS2_reg_addr                                           "0xB8018930"
#define TVE_MVCLS2_reg                                                0xB8018930
#define TVE_MVCLS2_inst_addr                                          "0x024C"
#define TVE_MVCLS2_inst                                               0x024C
#define TVE_MVCLS2_mvcls2_shift                                       (0)
#define TVE_MVCLS2_mvcls2_mask                                        (0x0000003F)
#define TVE_MVCLS2_mvcls2(data)                                       (0x0000003F&(data))
#define TVE_MVCLS2_get_mvcls2(data)                                   (0x0000003F&(data))

#define TVE_MVCSSP                                                    0x18018934
#define TVE_MVCSSP_reg_addr                                           "0xB8018934"
#define TVE_MVCSSP_reg                                                0xB8018934
#define TVE_MVCSSP_inst_addr                                          "0x024D"
#define TVE_MVCSSP_inst                                               0x024D
#define TVE_MVCSSP_mvcssp_shift                                       (5)
#define TVE_MVCSSP_mvcsnum_shift                                      (2)
#define TVE_MVCSSP_mvcsln_shift                                       (0)
#define TVE_MVCSSP_mvcssp_mask                                        (0x000000E0)
#define TVE_MVCSSP_mvcsnum_mask                                       (0x0000001C)
#define TVE_MVCSSP_mvcsln_mask                                        (0x00000003)
#define TVE_MVCSSP_mvcssp(data)                                       (0x000000E0&((data)<<5))
#define TVE_MVCSSP_mvcsnum(data)                                      (0x0000001C&((data)<<2))
#define TVE_MVCSSP_mvcsln(data)                                       (0x00000003&(data))
#define TVE_MVCSSP_get_mvcssp(data)                                   ((0x000000E0&(data))>>5)
#define TVE_MVCSSP_get_mvcsnum(data)                                  ((0x0000001C&(data))>>2)
#define TVE_MVCSSP_get_mvcsln(data)                                   (0x00000003&(data))

#define TVE_MVPSD                                                     0x18018938
#define TVE_MVPSD_reg_addr                                            "0xB8018938"
#define TVE_MVPSD_reg                                                 0xB8018938
#define TVE_MVPSD_inst_addr                                           "0x024E"
#define TVE_MVPSD_inst                                                0x024E
#define TVE_MVPSD_mvpsd_shift                                         (0)
#define TVE_MVPSD_mvpsd_mask                                          (0x0000003F)
#define TVE_MVPSD_mvpsd(data)                                         (0x0000003F&(data))
#define TVE_MVPSD_get_mvpsd(data)                                     (0x0000003F&(data))

#define TVE_MVPSL                                                     0x1801893C
#define TVE_MVPSL_reg_addr                                            "0xB801893C"
#define TVE_MVPSL_reg                                                 0xB801893C
#define TVE_MVPSL_inst_addr                                           "0x024F"
#define TVE_MVPSL_inst                                                0x024F
#define TVE_MVPSL_mvpsl_shift                                         (0)
#define TVE_MVPSL_mvpsl_mask                                          (0x0000003F)
#define TVE_MVPSL_mvpsl(data)                                         (0x0000003F&(data))
#define TVE_MVPSL_get_mvpsl(data)                                     (0x0000003F&(data))

#define TVE_MVPSS                                                     0x18018940
#define TVE_MVPSS_reg_addr                                            "0xB8018940"
#define TVE_MVPSS_reg                                                 0xB8018940
#define TVE_MVPSS_inst_addr                                           "0x0250"
#define TVE_MVPSS_inst                                                0x0250
#define TVE_MVPSS_mvpss_shift                                         (0)
#define TVE_MVPSS_mvpss_mask                                          (0x0000003F)
#define TVE_MVPSS_mvpss(data)                                         (0x0000003F&(data))
#define TVE_MVPSS_get_mvpss(data)                                     (0x0000003F&(data))

#define TVE_MVPSLS0                                                   0x18018944
#define TVE_MVPSLS0_reg_addr                                          "0xB8018944"
#define TVE_MVPSLS0_reg                                               0xB8018944
#define TVE_MVPSLS0_inst_addr                                         "0x0251"
#define TVE_MVPSLS0_inst                                              0x0251
#define TVE_MVPSLS0_mvpsls0_shift                                     (0)
#define TVE_MVPSLS0_mvpsls0_mask                                      (0x0000007F)
#define TVE_MVPSLS0_mvpsls0(data)                                     (0x0000007F&(data))
#define TVE_MVPSLS0_get_mvpsls0(data)                                 (0x0000007F&(data))

#define TVE_MVPSLS1                                                   0x18018948
#define TVE_MVPSLS1_reg_addr                                          "0xB8018948"
#define TVE_MVPSLS1_reg                                               0xB8018948
#define TVE_MVPSLS1_inst_addr                                         "0x0252"
#define TVE_MVPSLS1_inst                                              0x0252
#define TVE_MVPSLS1_mvpsls1_shift                                     (0)
#define TVE_MVPSLS1_mvpsls1_mask                                      (0x000000FF)
#define TVE_MVPSLS1_mvpsls1(data)                                     (0x000000FF&(data))
#define TVE_MVPSLS1_get_mvpsls1(data)                                 (0x000000FF&(data))

#define TVE_MVPSFS0                                                   0x1801894C
#define TVE_MVPSFS0_reg_addr                                          "0xB801894C"
#define TVE_MVPSFS0_reg                                               0xB801894C
#define TVE_MVPSFS0_inst_addr                                         "0x0253"
#define TVE_MVPSFS0_inst                                              0x0253
#define TVE_MVPSFS0_mvpsfs0_shift                                     (0)
#define TVE_MVPSFS0_mvpsfs0_mask                                      (0x0000007F)
#define TVE_MVPSFS0_mvpsfs0(data)                                     (0x0000007F&(data))
#define TVE_MVPSFS0_get_mvpsfs0(data)                                 (0x0000007F&(data))

#define TVE_MVPSFS1                                                   0x18018950
#define TVE_MVPSFS1_reg_addr                                          "0xB8018950"
#define TVE_MVPSFS1_reg                                               0xB8018950
#define TVE_MVPSFS1_inst_addr                                         "0x0254"
#define TVE_MVPSFS1_inst                                              0x0254
#define TVE_MVPSFS1_mvpsfs1_shift                                     (0)
#define TVE_MVPSFS1_mvpsfs1_mask                                      (0x000000FF)
#define TVE_MVPSFS1_mvpsfs1(data)                                     (0x000000FF&(data))
#define TVE_MVPSFS1_get_mvpsfs1(data)                                 (0x000000FF&(data))

#define TVE_MVPSAGCA                                                  0x18018954
#define TVE_MVPSAGCA_reg_addr                                         "0xB8018954"
#define TVE_MVPSAGCA_reg                                              0xB8018954
#define TVE_MVPSAGCA_inst_addr                                        "0x0255"
#define TVE_MVPSAGCA_inst                                             0x0255
#define TVE_MVPSAGCA_mvpsagca_shift                                   (0)
#define TVE_MVPSAGCA_mvpsagca_mask                                    (0x000000FF)
#define TVE_MVPSAGCA_mvpsagca(data)                                   (0x000000FF&(data))
#define TVE_MVPSAGCA_get_mvpsagca(data)                               (0x000000FF&(data))

#define TVE_MVPSAGCB                                                  0x18018958
#define TVE_MVPSAGCB_reg_addr                                         "0xB8018958"
#define TVE_MVPSAGCB_reg                                              0xB8018958
#define TVE_MVPSAGCB_inst_addr                                        "0x0256"
#define TVE_MVPSAGCB_inst                                             0x0256
#define TVE_MVPSAGCB_mvpsagcb_shift                                   (0)
#define TVE_MVPSAGCB_mvpsagcb_mask                                    (0x000000FF)
#define TVE_MVPSAGCB_mvpsagcb(data)                                   (0x000000FF&(data))
#define TVE_MVPSAGCB_get_mvpsagcb(data)                               (0x000000FF&(data))

#define TVE_MVEOFBPC                                                  0x1801895C
#define TVE_MVEOFBPC_reg_addr                                         "0xB801895C"
#define TVE_MVEOFBPC_reg                                              0xB801895C
#define TVE_MVEOFBPC_inst_addr                                        "0x0257"
#define TVE_MVEOFBPC_inst                                             0x0257
#define TVE_MVEOFBPC_mveofbpc_shift                                   (0)
#define TVE_MVEOFBPC_mveofbpc_mask                                    (0x000000FF)
#define TVE_MVEOFBPC_mveofbpc(data)                                   (0x000000FF&(data))
#define TVE_MVEOFBPC_get_mveofbpc(data)                               (0x000000FF&(data))

#define TVE_MVPBZ1                                                    0x18018960
#define TVE_MVPBZ1_reg_addr                                           "0xB8018960"
#define TVE_MVPBZ1_reg                                                0xB8018960
#define TVE_MVPBZ1_inst_addr                                          "0x0258"
#define TVE_MVPBZ1_inst                                               0x0258
#define TVE_MVPBZ1_mvpbz1_shift                                       (4)
#define TVE_MVPBZ1_mvpbz2_shift                                       (0)
#define TVE_MVPBZ1_mvpbz1_mask                                        (0x000000F0)
#define TVE_MVPBZ1_mvpbz2_mask                                        (0x0000000F)
#define TVE_MVPBZ1_mvpbz1(data)                                       (0x000000F0&((data)<<4))
#define TVE_MVPBZ1_mvpbz2(data)                                       (0x0000000F&(data))
#define TVE_MVPBZ1_get_mvpbz1(data)                                   ((0x000000F0&(data))>>4)
#define TVE_MVPBZ1_get_mvpbz2(data)                                   (0x0000000F&(data))

#define TVE_MVPZ3                                                     0x18018964
#define TVE_MVPZ3_reg_addr                                            "0xB8018964"
#define TVE_MVPZ3_reg                                                 0xB8018964
#define TVE_MVPZ3_inst_addr                                           "0x0259"
#define TVE_MVPZ3_inst                                                0x0259
#define TVE_MVPZ3_mvpbz3_shift                                        (4)
#define TVE_MVPZ3_mvpadvbsen_shift                                    (3)
#define TVE_MVPZ3_mvpzninvrt_shift                                    (0)
#define TVE_MVPZ3_mvpbz3_mask                                         (0x000000F0)
#define TVE_MVPZ3_mvpadvbsen_mask                                     (0x00000008)
#define TVE_MVPZ3_mvpzninvrt_mask                                     (0x00000007)
#define TVE_MVPZ3_mvpbz3(data)                                        (0x000000F0&((data)<<4))
#define TVE_MVPZ3_mvpadvbsen(data)                                    (0x00000008&((data)<<3))
#define TVE_MVPZ3_mvpzninvrt(data)                                    (0x00000007&(data))
#define TVE_MVPZ3_get_mvpbz3(data)                                    ((0x000000F0&(data))>>4)
#define TVE_MVPZ3_get_mvpadvbsen(data)                                ((0x00000008&(data))>>3)
#define TVE_MVPZ3_get_mvpzninvrt(data)                                (0x00000007&(data))

#define TVE_MVPCSLIMD0                                                0x18018968
#define TVE_MVPCSLIMD0_reg_addr                                       "0xB8018968"
#define TVE_MVPCSLIMD0_reg                                            0xB8018968
#define TVE_MVPCSLIMD0_inst_addr                                      "0x025A"
#define TVE_MVPCSLIMD0_inst                                           0x025A
#define TVE_MVPCSLIMD0_mvpcslimd_lsb_shift                            (0)
#define TVE_MVPCSLIMD0_mvpcslimd_lsb_mask                             (0x000000FF)
#define TVE_MVPCSLIMD0_mvpcslimd_lsb(data)                            (0x000000FF&(data))
#define TVE_MVPCSLIMD0_get_mvpcslimd_lsb(data)                        (0x000000FF&(data))

#define TVE_MVPCSLIMD1                                                0x1801896C
#define TVE_MVPCSLIMD1_reg_addr                                       "0xB801896C"
#define TVE_MVPCSLIMD1_reg                                            0xB801896C
#define TVE_MVPCSLIMD1_inst_addr                                      "0x025B"
#define TVE_MVPCSLIMD1_inst                                           0x025B
#define TVE_MVPCSLIMD1_mvpcslimd_msb_shift                            (0)
#define TVE_MVPCSLIMD1_mvpcslimd_msb_mask                             (0x00000003)
#define TVE_MVPCSLIMD1_mvpcslimd_msb(data)                            (0x00000003&(data))
#define TVE_MVPCSLIMD1_get_mvpcslimd_msb(data)                        (0x00000003&(data))

#define TVE_T_SEL_SIN                                                 0x18018980
#define TVE_T_SEL_SIN_reg_addr                                        "0xB8018980"
#define TVE_T_SEL_SIN_reg                                             0xB8018980
#define TVE_T_SEL_SIN_inst_addr                                       "0x0260"
#define TVE_T_SEL_SIN_inst                                            0x0260
#define TVE_T_SEL_SIN_t_sel_sin_shift                                 (1)
#define TVE_T_SEL_SIN_t_fsc_rom_shift                                 (0)
#define TVE_T_SEL_SIN_t_sel_sin_mask                                  (0x00000002)
#define TVE_T_SEL_SIN_t_fsc_rom_mask                                  (0x00000001)
#define TVE_T_SEL_SIN_t_sel_sin(data)                                 (0x00000002&((data)<<1))
#define TVE_T_SEL_SIN_t_fsc_rom(data)                                 (0x00000001&(data))
#define TVE_T_SEL_SIN_get_t_sel_sin(data)                             ((0x00000002&(data))>>1)
#define TVE_T_SEL_SIN_get_t_fsc_rom(data)                             (0x00000001&(data))

#define TVE_TEST_PARAM                                                0x18018984
#define TVE_TEST_PARAM_reg_addr                                       "0xB8018984"
#define TVE_TEST_PARAM_reg                                            0xB8018984
#define TVE_TEST_PARAM_inst_addr                                      "0x0261"
#define TVE_TEST_PARAM_inst                                           0x0261
#define TVE_TEST_PARAM_t_byp_yups_shift                               (6)
#define TVE_TEST_PARAM_t_sel_ylp1_shift                               (5)
#define TVE_TEST_PARAM_t_ygain_off_shift                              (4)
#define TVE_TEST_PARAM_y_tsin_cos_shift                               (3)
#define TVE_TEST_PARAM_y_tsel_dac_tst_shift                           (2)
#define TVE_TEST_PARAM_y_tdig_out_shift                               (0)
#define TVE_TEST_PARAM_t_byp_yups_mask                                (0x00000040)
#define TVE_TEST_PARAM_t_sel_ylp1_mask                                (0x00000020)
#define TVE_TEST_PARAM_t_ygain_off_mask                               (0x00000010)
#define TVE_TEST_PARAM_y_tsin_cos_mask                                (0x00000008)
#define TVE_TEST_PARAM_y_tsel_dac_tst_mask                            (0x00000004)
#define TVE_TEST_PARAM_y_tdig_out_mask                                (0x00000003)
#define TVE_TEST_PARAM_t_byp_yups(data)                               (0x00000040&((data)<<6))
#define TVE_TEST_PARAM_t_sel_ylp1(data)                               (0x00000020&((data)<<5))
#define TVE_TEST_PARAM_t_ygain_off(data)                              (0x00000010&((data)<<4))
#define TVE_TEST_PARAM_y_tsin_cos(data)                               (0x00000008&((data)<<3))
#define TVE_TEST_PARAM_y_tsel_dac_tst(data)                           (0x00000004&((data)<<2))
#define TVE_TEST_PARAM_y_tdig_out(data)                               (0x00000003&(data))
#define TVE_TEST_PARAM_get_t_byp_yups(data)                           ((0x00000040&(data))>>6)
#define TVE_TEST_PARAM_get_t_sel_ylp1(data)                           ((0x00000020&(data))>>5)
#define TVE_TEST_PARAM_get_t_ygain_off(data)                          ((0x00000010&(data))>>4)
#define TVE_TEST_PARAM_get_y_tsin_cos(data)                           ((0x00000008&(data))>>3)
#define TVE_TEST_PARAM_get_y_tsel_dac_tst(data)                       ((0x00000004&(data))>>2)
#define TVE_TEST_PARAM_get_y_tdig_out(data)                           (0x00000003&(data))

#define TVE_TEST_T_BYP_CUPS                                           0x1801898C
#define TVE_TEST_T_BYP_CUPS_reg_addr                                  "0xB801898C"
#define TVE_TEST_T_BYP_CUPS_reg                                       0xB801898C
#define TVE_TEST_T_BYP_CUPS_inst_addr                                 "0x0263"
#define TVE_TEST_T_BYP_CUPS_inst                                      0x0263
#define TVE_TEST_T_BYP_CUPS_t_byp_cups_shift                          (2)
#define TVE_TEST_T_BYP_CUPS_t_byp_clpf_shift                          (1)
#define TVE_TEST_T_BYP_CUPS_t_c_gain_off_shift                        (0)
#define TVE_TEST_T_BYP_CUPS_t_byp_cups_mask                           (0x00000004)
#define TVE_TEST_T_BYP_CUPS_t_byp_clpf_mask                           (0x00000002)
#define TVE_TEST_T_BYP_CUPS_t_c_gain_off_mask                         (0x00000001)
#define TVE_TEST_T_BYP_CUPS_t_byp_cups(data)                          (0x00000004&((data)<<2))
#define TVE_TEST_T_BYP_CUPS_t_byp_clpf(data)                          (0x00000002&((data)<<1))
#define TVE_TEST_T_BYP_CUPS_t_c_gain_off(data)                        (0x00000001&(data))
#define TVE_TEST_T_BYP_CUPS_get_t_byp_cups(data)                      ((0x00000004&(data))>>2)
#define TVE_TEST_T_BYP_CUPS_get_t_byp_clpf(data)                      ((0x00000002&(data))>>1)
#define TVE_TEST_T_BYP_CUPS_get_t_c_gain_off(data)                    (0x00000001&(data))

#define TVE_MV_CTRL                                                   0x18018990
#define TVE_MV_CTRL_reg_addr                                          "0xB8018990"
#define TVE_MV_CTRL_reg                                               0xB8018990
#define TVE_MV_CTRL_inst_addr                                         "0x0264"
#define TVE_MV_CTRL_inst                                              0x0264
#define TVE_MV_CTRL_mvtms_shift                                       (0)
#define TVE_MV_CTRL_mvtms_mask                                        (0x000000FF)
#define TVE_MV_CTRL_mvtms(data)                                       (0x000000FF&(data))
#define TVE_MV_CTRL_get_mvtms(data)                                   (0x000000FF&(data))

#define TVE_TEST_HLR0                                                 0x180189B4
#define TVE_TEST_HLR0_reg_addr                                        "0xB80189B4"
#define TVE_TEST_HLR0_reg                                             0xB80189B4
#define TVE_TEST_HLR0_inst_addr                                       "0x026D"
#define TVE_TEST_HLR0_inst                                            0x026D
#define TVE_TEST_HLR0_hlr0_shift                                      (0)
#define TVE_TEST_HLR0_hlr0_mask                                       (0x00000003)
#define TVE_TEST_HLR0_hlr0(data)                                      (0x00000003&(data))
#define TVE_TEST_HLR0_get_hlr0(data)                                  (0x00000003&(data))

#define TVE_TEST_HLR1                                                 0x180189B8
#define TVE_TEST_HLR1_reg_addr                                        "0xB80189B8"
#define TVE_TEST_HLR1_reg                                             0xB80189B8
#define TVE_TEST_HLR1_inst_addr                                       "0x026E"
#define TVE_TEST_HLR1_inst                                            0x026E
#define TVE_TEST_HLR1_hlr1_shift                                      (0)
#define TVE_TEST_HLR1_hlr1_mask                                       (0x000000FF)
#define TVE_TEST_HLR1_hlr1(data)                                      (0x000000FF&(data))
#define TVE_TEST_HLR1_get_hlr1(data)                                  (0x000000FF&(data))

#define TVE_TEST_VSMR                                                 0x180189BC
#define TVE_TEST_VSMR_reg_addr                                        "0xB80189BC"
#define TVE_TEST_VSMR_reg                                             0xB80189BC
#define TVE_TEST_VSMR_inst_addr                                       "0x026F"
#define TVE_TEST_VSMR_inst                                            0x026F
#define TVE_TEST_VSMR_vsmr_shift                                      (0)
#define TVE_TEST_VSMR_vsmr_mask                                       (0x0000001F)
#define TVE_TEST_VSMR_vsmr(data)                                      (0x0000001F&(data))
#define TVE_TEST_VSMR_get_vsmr(data)                                  (0x0000001F&(data))

#define TVE_SYNC_LVL2                                                 0x180189C0
#define TVE_SYNC_LVL2_reg_addr                                        "0xB80189C0"
#define TVE_SYNC_LVL2_reg                                             0xB80189C0
#define TVE_SYNC_LVL2_inst_addr                                       "0x0270"
#define TVE_SYNC_LVL2_inst                                            0x0270
#define TVE_SYNC_LVL2_sync_lvl_h_shift                                (0)
#define TVE_SYNC_LVL2_sync_lvl_h_mask                                 (0x000000FF)
#define TVE_SYNC_LVL2_sync_lvl_h(data)                                (0x000000FF&(data))
#define TVE_SYNC_LVL2_get_sync_lvl_h(data)                            (0x000000FF&(data))

#define TVE_SYNC_LVL3                                                 0x180189C4
#define TVE_SYNC_LVL3_reg_addr                                        "0xB80189C4"
#define TVE_SYNC_LVL3_reg                                             0xB80189C4
#define TVE_SYNC_LVL3_inst_addr                                       "0x0271"
#define TVE_SYNC_LVL3_inst                                            0x0271
#define TVE_SYNC_LVL3_sync_lvl_m_shift                                (0)
#define TVE_SYNC_LVL3_sync_lvl_m_mask                                 (0x000000FF)
#define TVE_SYNC_LVL3_sync_lvl_m(data)                                (0x000000FF&(data))
#define TVE_SYNC_LVL3_get_sync_lvl_m(data)                            (0x000000FF&(data))

#define TVE_SYNC_LVL4                                                 0x180189C8
#define TVE_SYNC_LVL4_reg_addr                                        "0xB80189C8"
#define TVE_SYNC_LVL4_reg                                             0xB80189C8
#define TVE_SYNC_LVL4_inst_addr                                       "0x0272"
#define TVE_SYNC_LVL4_inst                                            0x0272
#define TVE_SYNC_LVL4_sync_lvl_l_shift                                (0)
#define TVE_SYNC_LVL4_sync_lvl_l_mask                                 (0x000000FF)
#define TVE_SYNC_LVL4_sync_lvl_l(data)                                (0x000000FF&(data))
#define TVE_SYNC_LVL4_get_sync_lvl_l(data)                            (0x000000FF&(data))

#define TVE_CLPF_GAIN                                                 0x180189CC
#define TVE_CLPF_GAIN_reg_addr                                        "0xB80189CC"
#define TVE_CLPF_GAIN_reg                                             0xB80189CC
#define TVE_CLPF_GAIN_inst_addr                                       "0x0273"
#define TVE_CLPF_GAIN_inst                                            0x0273
#define TVE_CLPF_GAIN_clpf_gain_shift                                 (0)
#define TVE_CLPF_GAIN_clpf_gain_mask                                  (0x000000FF)
#define TVE_CLPF_GAIN_clpf_gain(data)                                 (0x000000FF&(data))
#define TVE_CLPF_GAIN_get_clpf_gain(data)                             (0x000000FF&(data))

#define TVE_SYNC_STRT                                                 0x180189D0
#define TVE_SYNC_STRT_reg_addr                                        "0xB80189D0"
#define TVE_SYNC_STRT_reg                                             0xB80189D0
#define TVE_SYNC_STRT_inst_addr                                       "0x0274"
#define TVE_SYNC_STRT_inst                                            0x0274
#define TVE_SYNC_STRT_sync_strt_shift                                 (0)
#define TVE_SYNC_STRT_sync_strt_mask                                  (0x0000000F)
#define TVE_SYNC_STRT_sync_strt(data)                                 (0x0000000F&(data))
#define TVE_SYNC_STRT_get_sync_strt(data)                             (0x0000000F&(data))

#define TVE_SYNC_END                                                  0x180189D4
#define TVE_SYNC_END_reg_addr                                         "0xB80189D4"
#define TVE_SYNC_END_reg                                              0xB80189D4
#define TVE_SYNC_END_inst_addr                                        "0x0275"
#define TVE_SYNC_END_inst                                             0x0275
#define TVE_SYNC_END_sync_end_shift                                   (0)
#define TVE_SYNC_END_sync_end_mask                                    (0x0000007F)
#define TVE_SYNC_END_sync_end(data)                                   (0x0000007F&(data))
#define TVE_SYNC_END_get_sync_end(data)                               (0x0000007F&(data))

#define TVE_SYNC_SREND                                                0x180189D8
#define TVE_SYNC_SREND_reg_addr                                       "0xB80189D8"
#define TVE_SYNC_SREND_reg                                            0xB80189D8
#define TVE_SYNC_SREND_inst_addr                                      "0x0276"
#define TVE_SYNC_SREND_inst                                           0x0276
#define TVE_SYNC_SREND_sync_srend_shift                               (0)
#define TVE_SYNC_SREND_sync_srend_mask                                (0x000000FF)
#define TVE_SYNC_SREND_sync_srend(data)                               (0x000000FF&(data))
#define TVE_SYNC_SREND_get_sync_srend(data)                           (0x000000FF&(data))

#define TVE_SYNC_EQEND                                                0x180189DC
#define TVE_SYNC_EQEND_reg_addr                                       "0xB80189DC"
#define TVE_SYNC_EQEND_reg                                            0xB80189DC
#define TVE_SYNC_EQEND_inst_addr                                      "0x0277"
#define TVE_SYNC_EQEND_inst                                           0x0277
#define TVE_SYNC_EQEND_sync_eqend_shift                               (0)
#define TVE_SYNC_EQEND_sync_eqend_mask                                (0x0000003F)
#define TVE_SYNC_EQEND_sync_eqend(data)                               (0x0000003F&(data))
#define TVE_SYNC_EQEND_get_sync_eqend(data)                           (0x0000003F&(data))

#define TVE_ACTV_STRT                                                 0x180189E0
#define TVE_ACTV_STRT_reg_addr                                        "0xB80189E0"
#define TVE_ACTV_STRT_reg                                             0xB80189E0
#define TVE_ACTV_STRT_inst_addr                                       "0x0278"
#define TVE_ACTV_STRT_inst                                            0x0278
#define TVE_ACTV_STRT_actv_strt_shift                                 (0)
#define TVE_ACTV_STRT_actv_strt_mask                                  (0x000000FF)
#define TVE_ACTV_STRT_actv_strt(data)                                 (0x000000FF&(data))
#define TVE_ACTV_STRT_get_actv_strt(data)                             (0x000000FF&(data))

#define TVE_ACTV_END                                                  0x180189E4
#define TVE_ACTV_END_reg_addr                                         "0xB80189E4"
#define TVE_ACTV_END_reg                                              0xB80189E4
#define TVE_ACTV_END_inst_addr                                        "0x0279"
#define TVE_ACTV_END_inst                                             0x0279
#define TVE_ACTV_END_actv_end_shift                                   (0)
#define TVE_ACTV_END_actv_end_mask                                    (0x000000FF)
#define TVE_ACTV_END_actv_end(data)                                   (0x000000FF&(data))
#define TVE_ACTV_END_get_actv_end(data)                               (0x000000FF&(data))

#define TVE_WBRST_STRT                                                0x180189E8
#define TVE_WBRST_STRT_reg_addr                                       "0xB80189E8"
#define TVE_WBRST_STRT_reg                                            0xB80189E8
#define TVE_WBRST_STRT_inst_addr                                      "0x027A"
#define TVE_WBRST_STRT_inst                                           0x027A
#define TVE_WBRST_STRT_wbrst_strt_shift                               (0)
#define TVE_WBRST_STRT_wbrst_strt_mask                                (0x0000007F)
#define TVE_WBRST_STRT_wbrst_strt(data)                               (0x0000007F&(data))
#define TVE_WBRST_STRT_get_wbrst_strt(data)                           (0x0000007F&(data))

#define TVE_NBRST_STRT                                                0x180189EC
#define TVE_NBRST_STRT_reg_addr                                       "0xB80189EC"
#define TVE_NBRST_STRT_reg                                            0xB80189EC
#define TVE_NBRST_STRT_inst_addr                                      "0x027B"
#define TVE_NBRST_STRT_inst                                           0x027B
#define TVE_NBRST_STRT_nbrst_strt_shift                               (0)
#define TVE_NBRST_STRT_nbrst_strt_mask                                (0x0000007F)
#define TVE_NBRST_STRT_nbrst_strt(data)                               (0x0000007F&(data))
#define TVE_NBRST_STRT_get_nbrst_strt(data)                           (0x0000007F&(data))

#define TVE_NBRST_END                                                 0x180189F0
#define TVE_NBRST_END_reg_addr                                        "0xB80189F0"
#define TVE_NBRST_END_reg                                             0xB80189F0
#define TVE_NBRST_END_inst_addr                                       "0x027C"
#define TVE_NBRST_END_inst                                            0x027C
#define TVE_NBRST_END_nbrst_end_shift                                 (0)
#define TVE_NBRST_END_nbrst_end_mask                                  (0x000000FF)
#define TVE_NBRST_END_nbrst_end(data)                                 (0x000000FF&(data))
#define TVE_NBRST_END_get_nbrst_end(data)                             (0x000000FF&(data))

#define TVE_DBG                                                       0x1801813C
#define TVE_DBG_reg_addr                                              "0xB801813C"
#define TVE_DBG_reg                                                   0xB801813C
#define TVE_DBG_inst_addr                                             "0x004F"
#define TVE_DBG_inst                                                  0x004F
#define TVE_DBG_write_enable3_shift                                   (11)
#define TVE_DBG_sel1_shift                                            (7)
#define TVE_DBG_write_enable2_shift                                   (6)
#define TVE_DBG_sel0_shift                                            (2)
#define TVE_DBG_write_enable1_shift                                   (1)
#define TVE_DBG_enable_shift                                          (0)
#define TVE_DBG_write_enable3_mask                                    (0x00000800)
#define TVE_DBG_sel1_mask                                             (0x00000780)
#define TVE_DBG_write_enable2_mask                                    (0x00000040)
#define TVE_DBG_sel0_mask                                             (0x0000003C)
#define TVE_DBG_write_enable1_mask                                    (0x00000002)
#define TVE_DBG_enable_mask                                           (0x00000001)
#define TVE_DBG_write_enable3(data)                                   (0x00000800&((data)<<11))
#define TVE_DBG_sel1(data)                                            (0x00000780&((data)<<7))
#define TVE_DBG_write_enable2(data)                                   (0x00000040&((data)<<6))
#define TVE_DBG_sel0(data)                                            (0x0000003C&((data)<<2))
#define TVE_DBG_write_enable1(data)                                   (0x00000002&((data)<<1))
#define TVE_DBG_enable(data)                                          (0x00000001&(data))
#define TVE_DBG_get_write_enable3(data)                               ((0x00000800&(data))>>11)
#define TVE_DBG_get_sel1(data)                                        ((0x00000780&(data))>>7)
#define TVE_DBG_get_write_enable2(data)                               ((0x00000040&(data))>>6)
#define TVE_DBG_get_sel0(data)                                        ((0x0000003C&(data))>>2)
#define TVE_DBG_get_write_enable1(data)                               ((0x00000002&(data))>>1)
#define TVE_DBG_get_enable(data)                                      (0x00000001&(data))
#endif
