// This file is generated using the spec version 0.7.8, firmware template version 1.39and DVR_Parser_0.43
#ifndef _VI_REG_H_INCLUDED_
#define _VI_REG_H_INCLUDED_

//#define  _VI_USE_STRUCT
#ifdef _VI_USE_STRUCT

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    neg:1;
}vi_EXT_EDGENEG;

typedef struct
{
    unsigned int    reserved_0:29;
    unsigned int    ignore:1;
    unsigned int    enable:1;
    unsigned int    write_data:1;
}vi_PBIT;

typedef struct
{
    unsigned int    reserved_0:31;
    unsigned int    error:1;
}vi_PBIT_ERR;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    field:1;
    unsigned int    vcnt:9;
    unsigned int    hcnt:10;
}vi_FVH1;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    field:1;
    unsigned int    vcnt:9;
    unsigned int    hcnt:10;
}vi_FVH2;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    write_enable1:1;
    unsigned int    vstart:9;
    unsigned int    write_enable2:1;
    unsigned int    vend:9;
}vi_CWV1;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    write_enable1:1;
    unsigned int    vstart:9;
    unsigned int    write_enable2:1;
    unsigned int    vend:9;
}vi_CWV2;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable1:1;
    unsigned int    hstart:10;
    unsigned int    write_enable2:1;
    unsigned int    hend:10;
}vi_CWH1;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable1:1;
    unsigned int    hstart:10;
    unsigned int    write_enable2:1;
    unsigned int    hend:10;
}vi_CWH2;

typedef struct
{
    unsigned int    reserved_0:9;
    unsigned int    threshold:23;
}vi_VSTHRESHLD1;

typedef struct
{
    unsigned int    reserved_0:9;
    unsigned int    threshold:23;
}vi_VSTHRESHLD2;

typedef struct
{
    unsigned int    reserved_0:14;
    unsigned int    flvcnt1:9;
    unsigned int    flvcnt2:9;
}vi_FLVCNT;

typedef struct
{
    unsigned int    reserved_0:14;
    unsigned int    slcnt1:9;
    unsigned int    slcnt2:9;
}vi_SLCNT;

typedef struct
{
    unsigned int    reserved_0:14;
    unsigned int    llcnt1:9;
    unsigned int    llcnt2:9;
}vi_LLCNT;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable1:1;
    unsigned int    slthd1:10;
    unsigned int    write_enable2:1;
    unsigned int    slthd2:10;
}vi_SLTHRESHOLD;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable1:1;
    unsigned int    llthd1:10;
    unsigned int    write_enable2:1;
    unsigned int    llthd2:10;
}vi_LLTHRESHOLD;

typedef struct
{
    unsigned int    reserved_0:18;
    unsigned int    write_enable1:1;
    unsigned int    enable:1;
    unsigned int    write_enable2:1;
    unsigned int    vstart:5;
    unsigned int    write_enable3:1;
    unsigned int    vend:5;
}vi_VBIWV1;

typedef struct
{
    unsigned int    reserved_0:16;
    unsigned int    write_enable1:1;
    unsigned int    yonly:1;
    unsigned int    write_enable2:1;
    unsigned int    enable:1;
    unsigned int    write_enable3:1;
    unsigned int    vstart:5;
    unsigned int    write_enable4:1;
    unsigned int    vend:5;
}vi_VBIWV2;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable1:1;
    unsigned int    hstart:10;
    unsigned int    write_enable2:1;
    unsigned int    hend:10;
}vi_VBIWH1;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable1:1;
    unsigned int    hstart:10;
    unsigned int    write_enable2:1;
    unsigned int    hend:10;
}vi_VBIWH2;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    write_enable1:1;
    unsigned int    scaling_en1:1;
    unsigned int    write_enable2:1;
    unsigned int    gain:8;
    unsigned int    write_enable3:1;
    unsigned int    offset:8;
}vi_VBI_SCALING1;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    write_enable1:1;
    unsigned int    scaling_en2:1;
    unsigned int    write_enable2:1;
    unsigned int    gain:8;
    unsigned int    write_enable3:1;
    unsigned int    offset:8;
}vi_VBI_SCALING2;

typedef struct
{
    unsigned int    reserved_0:7;
    unsigned int    write_enable2:1;
    unsigned int    ywidth:13;
    unsigned int    write_enable3:1;
    unsigned int    yheight:10;
}vi_DINYCTRL;

typedef struct
{
    unsigned int    reserved_0:7;
    unsigned int    write_enable1:1;
    unsigned int    cwidth:13;
    unsigned int    write_enable2:1;
    unsigned int    cheight:10;
}vi_DINCCTRL;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    dc:31;
}vi_YDC1;

typedef struct
{
    unsigned int    reserved_0:1;
    unsigned int    dc:31;
}vi_YDC2;

typedef struct
{
    unsigned int    reserved_0:7;
    unsigned int    write_enable1:1;
    unsigned int    t1:8;
    unsigned int    write_enable2:1;
    unsigned int    t2:8;
    unsigned int    write_enable3:1;
    unsigned int    rshiftsize:3;
    unsigned int    write_enable4:1;
    unsigned int    hornr_select:2;
}vi_HORNR_Y;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable1:1;
    unsigned int    t1:8;
    unsigned int    write_enable2:1;
    unsigned int    t2:8;
    unsigned int    write_enable3:1;
    unsigned int    rshiftsize:3;
}vi_HORNR_C;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    yen:1;
    unsigned int    yoddtype:1;
    unsigned int    cen:1;
    unsigned int    coddtype:1;
    unsigned int    write_data:1;
}vi_SCCTL1;

typedef struct
{
    unsigned int    reserved_0:27;
    unsigned int    yen:1;
    unsigned int    yoddtype:1;
    unsigned int    cen:1;
    unsigned int    coddtype:1;
    unsigned int    write_data:1;
}vi_SCCTL2;

typedef struct
{
    unsigned int    write_enable1:1;
    unsigned int    yonp:13;
    unsigned int    write_enable2:1;
    unsigned int    ydphs:17;
}vi_YSC1;

typedef struct
{
    unsigned int    write_enable1:1;
    unsigned int    conp:13;
    unsigned int    write_enable2:1;
    unsigned int    cdphs:17;
}vi_CSC1;

typedef struct
{
    unsigned int    write_enable1:1;
    unsigned int    yonp:13;
    unsigned int    write_enable2:1;
    unsigned int    ydphs:17;
}vi_YSC2;

typedef struct
{
    unsigned int    write_enable1:1;
    unsigned int    conp:13;
    unsigned int    write_enable2:1;
    unsigned int    cdphs:17;
}vi_CSC2;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    init_offset:10;
    unsigned int    init_phase:14;
}vi_YIPOS1;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    init_offset:10;
    unsigned int    init_phase:14;
}vi_YIPOS2;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    init_offset:10;
    unsigned int    init_phase:14;
}vi_CIPOS1;

typedef struct
{
    unsigned int    reserved_0:8;
    unsigned int    init_offset:10;
    unsigned int    init_phase:14;
}vi_CIPOS2;

typedef struct
{
    unsigned int    reserved_0:18;
    unsigned int    ysccoef:14;
}vi_YSCCOEF1;

typedef struct
{
    unsigned int    reserved_0:18;
    unsigned int    ysccoef:14;
}vi_YSCCOEF2;

typedef struct
{
    unsigned int    reserved_0:18;
    unsigned int    csccoef:14;
}vi_CSCCOEF1;

typedef struct
{
    unsigned int    reserved_0:18;
    unsigned int    csccoef:14;
}vi_CSCCOEF2;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    y1_clamp:1;
    unsigned int    c1_clamp:1;
    unsigned int    y2_clamp:1;
    unsigned int    c2_clamp:1;
    unsigned int    y1:1;
    unsigned int    c1:1;
    unsigned int    y2:1;
    unsigned int    c2:1;
    unsigned int    write_data:1;
}vi_OFFSETEN;

typedef struct
{
    unsigned int    hpd_enable:1;
    unsigned int    hpd_acc:31;
}vi_HPD1;

typedef struct
{
    unsigned int    hpd_enable:1;
    unsigned int    hpd_acc:31;
}vi_HPD2;

typedef struct
{
    unsigned int    reserved_0:22;
    unsigned int    write_enable1:1;
    unsigned int    cvden1:1;
    unsigned int    write_enable2:1;
    unsigned int    cvdtp1:2;
    unsigned int    write_enable3:1;
    unsigned int    cvden2:1;
    unsigned int    write_enable4:1;
    unsigned int    cvdtp2:2;
}vi_CVDEN;

typedef struct
{
    unsigned int    reserved_0:25;
    unsigned int    write_enable1:1;
    unsigned int    yden:1;
    unsigned int    write_enable2:1;
    unsigned int    ydsrc:1;
    unsigned int    write_enable3:1;
    unsigned int    ydrtio:2;
}vi_YDCTL;

typedef struct
{
    unsigned int    reserved_0:24;
    unsigned int    write_enable1:1;
    unsigned int    dmaen1:1;
    unsigned int    write_enable2:1;
    unsigned int    dmaen2:1;
    unsigned int    write_enable3:1;
    unsigned int    bstlen:3;
}vi_DMACTL;

typedef struct
{
    unsigned int    reserved_0:15;
    unsigned int    write_enable1:1;
    unsigned int    thd:6;
    unsigned int    write_enable2:1;
    unsigned int    end:9;
}vi_Y1BUF;

typedef struct
{
    unsigned int    reserved_0:5;
    unsigned int    write_enable1:1;
    unsigned int    thd:6;
    unsigned int    write_enable2:1;
    unsigned int    start:9;
    unsigned int    write_enable3:1;
    unsigned int    end:9;
}vi_Y2BUF;

typedef struct
{
    unsigned int    reserved_0:5;
    unsigned int    write_enable1:1;
    unsigned int    thd:6;
    unsigned int    write_enable2:1;
    unsigned int    start:9;
    unsigned int    write_enable3:1;
    unsigned int    end:9;
}vi_C1BUF;

typedef struct
{
    unsigned int    reserved_0:5;
    unsigned int    write_enable1:1;
    unsigned int    thd:6;
    unsigned int    write_enable2:1;
    unsigned int    start:9;
    unsigned int    write_enable3:1;
    unsigned int    end:9;
}vi_C2BUF;

typedef struct
{
    unsigned int    reserved_0:5;
    unsigned int    write_enable1:1;
    unsigned int    thd:6;
    unsigned int    write_enable2:1;
    unsigned int    start:9;
    unsigned int    write_enable3:1;
    unsigned int    end:9;
}vi_YDBUF;

typedef struct
{
    unsigned int    reserved_0:17;
    unsigned int    write_enable1:1;
    unsigned int    thd:6;
    unsigned int    write_enable2:1;
    unsigned int    end:7;
}vi_YDINBUF;

typedef struct
{
    unsigned int    reserved_0:9;
    unsigned int    write_enable1:1;
    unsigned int    thd:6;
    unsigned int    write_enable2:1;
    unsigned int    start:7;
    unsigned int    write_enable3:1;
    unsigned int    end:7;
}vi_CDINBUF;

typedef struct
{
    unsigned int    reserved_0:11;
    unsigned int    write_enable1:1;
    unsigned int    vbiads:6;
    unsigned int    write_enable2:1;
    unsigned int    yads:6;
    unsigned int    write_enable3:1;
    unsigned int    cads:6;
}vi_DMACTL1;

typedef struct
{
    unsigned int    reserved_0:11;
    unsigned int    write_enable1:1;
    unsigned int    vbiads:6;
    unsigned int    write_enable2:1;
    unsigned int    yads:6;
    unsigned int    write_enable3:1;
    unsigned int    cads:6;
}vi_DMACTL2;

typedef struct
{
    unsigned int    reserved_0:26;
    unsigned int    dyads:6;
}vi_DYDMACTL;

typedef struct
{
    unsigned int    reserved_0:18;
    unsigned int    write_enable1:1;
    unsigned int    yads:6;
    unsigned int    write_enable2:1;
    unsigned int    cads:6;
}vi_DINDMACTL;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    v1_odd:1;
    unsigned int    v1_interleave:1;
    unsigned int    v2_odd:1;
    unsigned int    v2_interleave:1;
    unsigned int    dy_odd:1;
    unsigned int    dy_interleave:1;
    unsigned int    din_odd:1;
    unsigned int    din_interleave:1;
    unsigned int    write_data:1;
}vi_IMMODE;

typedef struct
{
    unsigned int    reserved_0:2;
    unsigned int    write_enable1:1;
    unsigned int    y1c1:4;
    unsigned int    write_enable2:1;
    unsigned int    y2c2:4;
    unsigned int    write_enable3:1;
    unsigned int    vbi1:4;
    unsigned int    write_enable4:1;
    unsigned int    vbi2:4;
    unsigned int    write_enable5:1;
    unsigned int    dy:4;
    unsigned int    write_enable6:1;
    unsigned int    din:4;
}vi_DMA_MIN_TIME;

typedef struct
{
    unsigned int    reserved_0:30;
    unsigned int    ext_err:1;
    unsigned int    int_err:1;
}vi_DMAERR;

typedef struct
{
    unsigned int    reserved_0:21;
    unsigned int    dmaerrinte:1;
    unsigned int    dinendinte:1;
    unsigned int    sfinte1:1;
    unsigned int    sfinte2:1;
    unsigned int    vsinte1:1;
    unsigned int    vsinte2:1;
    unsigned int    tointe1:1;
    unsigned int    tointe2:1;
    unsigned int    olinte1:1;
    unsigned int    olinte2:1;
    unsigned int    write_data:1;
}vi_INTEN;

typedef struct
{
    unsigned int    reserved_0:21;
    unsigned int    dmaerrints:1;
    unsigned int    dinendints:1;
    unsigned int    sfints1:1;
    unsigned int    sfints2:1;
    unsigned int    vsints1:1;
    unsigned int    vsints2:1;
    unsigned int    toints1:1;
    unsigned int    toints2:1;
    unsigned int    olints1:1;
    unsigned int    olints2:1;
    unsigned int    write_data:1;
}vi_INTST;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable1:1;
    unsigned int    y:10;
    unsigned int    write_enable2:1;
    unsigned int    c:10;
}vi_OLN1;

typedef struct
{
    unsigned int    reserved_0:10;
    unsigned int    write_enable1:1;
    unsigned int    y:10;
    unsigned int    write_enable2:1;
    unsigned int    c:10;
}vi_OLN2;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    y:10;
    unsigned int    c:10;
}vi_OLNCNT1;

typedef struct
{
    unsigned int    reserved_0:12;
    unsigned int    y:10;
    unsigned int    c:10;
}vi_OLNCNT2;

typedef struct
{
    unsigned int    reserved_0:23;
    unsigned int    write_enable1:1;
    unsigned int    sel:2;
    unsigned int    write_enable2:1;
    unsigned int    dintrig:1;
    unsigned int    write_enable3:1;
    unsigned int    vsce1:1;
    unsigned int    write_enable4:1;
    unsigned int    vsce2:1;
}vi_GCTL;
#endif

#define VI_EXT_EDGENEG                                                0x18004000
#define VI_EXT_EDGENEG_reg_addr                                       "0xB8004000"
#define VI_EXT_EDGENEG_reg                                            0xB8004000
#define VI_EXT_EDGENEG_inst_addr                                      "0x0000"
#define VI_EXT_EDGENEG_inst                                           0x0000
#define VI_EXT_EDGENEG_neg_shift                                      (0)
#define VI_EXT_EDGENEG_neg_mask                                       (0x00000001)
#define VI_EXT_EDGENEG_neg(data)                                      (0x00000001&(data))
#define VI_EXT_EDGENEG_get_neg(data)                                  (0x00000001&(data))

#define VI_PBIT                                                       0x18004004
#define VI_PBIT_reg_addr                                              "0xB8004004"
#define VI_PBIT_reg                                                   0xB8004004
#define VI_PBIT_inst_addr                                             "0x0001"
#define VI_PBIT_inst                                                  0x0001
#define VI_PBIT_ignore_shift                                          (2)
#define VI_PBIT_enable_shift                                          (1)
#define VI_PBIT_write_data_shift                                      (0)
#define VI_PBIT_ignore_mask                                           (0x00000004)
#define VI_PBIT_enable_mask                                           (0x00000002)
#define VI_PBIT_write_data_mask                                       (0x00000001)
#define VI_PBIT_ignore(data)                                          (0x00000004&((data)<<2))
#define VI_PBIT_enable(data)                                          (0x00000002&((data)<<1))
#define VI_PBIT_write_data(data)                                      (0x00000001&(data))
#define VI_PBIT_get_ignore(data)                                      ((0x00000004&(data))>>2)
#define VI_PBIT_get_enable(data)                                      ((0x00000002&(data))>>1)
#define VI_PBIT_get_write_data(data)                                  (0x00000001&(data))

#define VI_PBIT_ERR                                                   0x18004008
#define VI_PBIT_ERR_reg_addr                                          "0xB8004008"
#define VI_PBIT_ERR_reg                                               0xB8004008
#define VI_PBIT_ERR_inst_addr                                         "0x0002"
#define VI_PBIT_ERR_inst                                              0x0002
#define VI_PBIT_ERR_error_shift                                       (0)
#define VI_PBIT_ERR_error_mask                                        (0x00000001)
#define VI_PBIT_ERR_error(data)                                       (0x00000001&(data))
#define VI_PBIT_ERR_get_error(data)                                   (0x00000001&(data))

#define VI_FVH1                                                       0x1800400C
#define VI_FVH1_reg_addr                                              "0xB800400C"
#define VI_FVH1_reg                                                   0xB800400C
#define VI_FVH1_inst_addr                                             "0x0003"
#define VI_FVH1_inst                                                  0x0003
#define VI_FVH1_field_shift                                           (19)
#define VI_FVH1_vcnt_shift                                            (10)
#define VI_FVH1_hcnt_shift                                            (0)
#define VI_FVH1_field_mask                                            (0x00080000)
#define VI_FVH1_vcnt_mask                                             (0x0007FC00)
#define VI_FVH1_hcnt_mask                                             (0x000003FF)
#define VI_FVH1_field(data)                                           (0x00080000&((data)<<19))
#define VI_FVH1_vcnt(data)                                            (0x0007FC00&((data)<<10))
#define VI_FVH1_hcnt(data)                                            (0x000003FF&(data))
#define VI_FVH1_get_field(data)                                       ((0x00080000&(data))>>19)
#define VI_FVH1_get_vcnt(data)                                        ((0x0007FC00&(data))>>10)
#define VI_FVH1_get_hcnt(data)                                        (0x000003FF&(data))

#define VI_FVH2                                                       0x18004010
#define VI_FVH2_reg_addr                                              "0xB8004010"
#define VI_FVH2_reg                                                   0xB8004010
#define VI_FVH2_inst_addr                                             "0x0004"
#define VI_FVH2_inst                                                  0x0004
#define VI_FVH2_field_shift                                           (19)
#define VI_FVH2_vcnt_shift                                            (10)
#define VI_FVH2_hcnt_shift                                            (0)
#define VI_FVH2_field_mask                                            (0x00080000)
#define VI_FVH2_vcnt_mask                                             (0x0007FC00)
#define VI_FVH2_hcnt_mask                                             (0x000003FF)
#define VI_FVH2_field(data)                                           (0x00080000&((data)<<19))
#define VI_FVH2_vcnt(data)                                            (0x0007FC00&((data)<<10))
#define VI_FVH2_hcnt(data)                                            (0x000003FF&(data))
#define VI_FVH2_get_field(data)                                       ((0x00080000&(data))>>19)
#define VI_FVH2_get_vcnt(data)                                        ((0x0007FC00&(data))>>10)
#define VI_FVH2_get_hcnt(data)                                        (0x000003FF&(data))

#define VI_CWV1                                                       0x18004014
#define VI_CWV1_reg_addr                                              "0xB8004014"
#define VI_CWV1_reg                                                   0xB8004014
#define VI_CWV1_inst_addr                                             "0x0005"
#define VI_CWV1_inst                                                  0x0005
#define VI_CWV1_write_enable1_shift                                   (19)
#define VI_CWV1_vstart_shift                                          (10)
#define VI_CWV1_write_enable2_shift                                   (9)
#define VI_CWV1_vend_shift                                            (0)
#define VI_CWV1_write_enable1_mask                                    (0x00080000)
#define VI_CWV1_vstart_mask                                           (0x0007FC00)
#define VI_CWV1_write_enable2_mask                                    (0x00000200)
#define VI_CWV1_vend_mask                                             (0x000001FF)
#define VI_CWV1_write_enable1(data)                                   (0x00080000&((data)<<19))
#define VI_CWV1_vstart(data)                                          (0x0007FC00&((data)<<10))
#define VI_CWV1_write_enable2(data)                                   (0x00000200&((data)<<9))
#define VI_CWV1_vend(data)                                            (0x000001FF&(data))
#define VI_CWV1_get_write_enable1(data)                               ((0x00080000&(data))>>19)
#define VI_CWV1_get_vstart(data)                                      ((0x0007FC00&(data))>>10)
#define VI_CWV1_get_write_enable2(data)                               ((0x00000200&(data))>>9)
#define VI_CWV1_get_vend(data)                                        (0x000001FF&(data))

#define VI_CWV2                                                       0x18004018
#define VI_CWV2_reg_addr                                              "0xB8004018"
#define VI_CWV2_reg                                                   0xB8004018
#define VI_CWV2_inst_addr                                             "0x0006"
#define VI_CWV2_inst                                                  0x0006
#define VI_CWV2_write_enable1_shift                                   (19)
#define VI_CWV2_vstart_shift                                          (10)
#define VI_CWV2_write_enable2_shift                                   (9)
#define VI_CWV2_vend_shift                                            (0)
#define VI_CWV2_write_enable1_mask                                    (0x00080000)
#define VI_CWV2_vstart_mask                                           (0x0007FC00)
#define VI_CWV2_write_enable2_mask                                    (0x00000200)
#define VI_CWV2_vend_mask                                             (0x000001FF)
#define VI_CWV2_write_enable1(data)                                   (0x00080000&((data)<<19))
#define VI_CWV2_vstart(data)                                          (0x0007FC00&((data)<<10))
#define VI_CWV2_write_enable2(data)                                   (0x00000200&((data)<<9))
#define VI_CWV2_vend(data)                                            (0x000001FF&(data))
#define VI_CWV2_get_write_enable1(data)                               ((0x00080000&(data))>>19)
#define VI_CWV2_get_vstart(data)                                      ((0x0007FC00&(data))>>10)
#define VI_CWV2_get_write_enable2(data)                               ((0x00000200&(data))>>9)
#define VI_CWV2_get_vend(data)                                        (0x000001FF&(data))

#define VI_CWH1                                                       0x1800401C
#define VI_CWH1_reg_addr                                              "0xB800401C"
#define VI_CWH1_reg                                                   0xB800401C
#define VI_CWH1_inst_addr                                             "0x0007"
#define VI_CWH1_inst                                                  0x0007
#define VI_CWH1_write_enable1_shift                                   (21)
#define VI_CWH1_hstart_shift                                          (11)
#define VI_CWH1_write_enable2_shift                                   (10)
#define VI_CWH1_hend_shift                                            (0)
#define VI_CWH1_write_enable1_mask                                    (0x00200000)
#define VI_CWH1_hstart_mask                                           (0x001FF800)
#define VI_CWH1_write_enable2_mask                                    (0x00000400)
#define VI_CWH1_hend_mask                                             (0x000003FF)
#define VI_CWH1_write_enable1(data)                                   (0x00200000&((data)<<21))
#define VI_CWH1_hstart(data)                                          (0x001FF800&((data)<<11))
#define VI_CWH1_write_enable2(data)                                   (0x00000400&((data)<<10))
#define VI_CWH1_hend(data)                                            (0x000003FF&(data))
#define VI_CWH1_get_write_enable1(data)                               ((0x00200000&(data))>>21)
#define VI_CWH1_get_hstart(data)                                      ((0x001FF800&(data))>>11)
#define VI_CWH1_get_write_enable2(data)                               ((0x00000400&(data))>>10)
#define VI_CWH1_get_hend(data)                                        (0x000003FF&(data))

#define VI_CWH2                                                       0x18004020
#define VI_CWH2_reg_addr                                              "0xB8004020"
#define VI_CWH2_reg                                                   0xB8004020
#define VI_CWH2_inst_addr                                             "0x0008"
#define VI_CWH2_inst                                                  0x0008
#define VI_CWH2_write_enable1_shift                                   (21)
#define VI_CWH2_hstart_shift                                          (11)
#define VI_CWH2_write_enable2_shift                                   (10)
#define VI_CWH2_hend_shift                                            (0)
#define VI_CWH2_write_enable1_mask                                    (0x00200000)
#define VI_CWH2_hstart_mask                                           (0x001FF800)
#define VI_CWH2_write_enable2_mask                                    (0x00000400)
#define VI_CWH2_hend_mask                                             (0x000003FF)
#define VI_CWH2_write_enable1(data)                                   (0x00200000&((data)<<21))
#define VI_CWH2_hstart(data)                                          (0x001FF800&((data)<<11))
#define VI_CWH2_write_enable2(data)                                   (0x00000400&((data)<<10))
#define VI_CWH2_hend(data)                                            (0x000003FF&(data))
#define VI_CWH2_get_write_enable1(data)                               ((0x00200000&(data))>>21)
#define VI_CWH2_get_hstart(data)                                      ((0x001FF800&(data))>>11)
#define VI_CWH2_get_write_enable2(data)                               ((0x00000400&(data))>>10)
#define VI_CWH2_get_hend(data)                                        (0x000003FF&(data))

#define VI_VSTHRESHLD1                                                0x18004024
#define VI_VSTHRESHLD1_reg_addr                                       "0xB8004024"
#define VI_VSTHRESHLD1_reg                                            0xB8004024
#define VI_VSTHRESHLD1_inst_addr                                      "0x0009"
#define VI_VSTHRESHLD1_inst                                           0x0009
#define VI_VSTHRESHLD1_threshold_shift                                (0)
#define VI_VSTHRESHLD1_threshold_mask                                 (0x007FFFFF)
#define VI_VSTHRESHLD1_threshold(data)                                (0x007FFFFF&(data))
#define VI_VSTHRESHLD1_get_threshold(data)                            (0x007FFFFF&(data))

#define VI_VSTHRESHLD2                                                0x18004028
#define VI_VSTHRESHLD2_reg_addr                                       "0xB8004028"
#define VI_VSTHRESHLD2_reg                                            0xB8004028
#define VI_VSTHRESHLD2_inst_addr                                      "0x000A"
#define VI_VSTHRESHLD2_inst                                           0x000A
#define VI_VSTHRESHLD2_threshold_shift                                (0)
#define VI_VSTHRESHLD2_threshold_mask                                 (0x007FFFFF)
#define VI_VSTHRESHLD2_threshold(data)                                (0x007FFFFF&(data))
#define VI_VSTHRESHLD2_get_threshold(data)                            (0x007FFFFF&(data))

#define VI_FLVCNT                                                     0x1800402C
#define VI_FLVCNT_reg_addr                                            "0xB800402C"
#define VI_FLVCNT_reg                                                 0xB800402C
#define VI_FLVCNT_inst_addr                                           "0x000B"
#define VI_FLVCNT_inst                                                0x000B
#define VI_FLVCNT_flvcnt1_shift                                       (9)
#define VI_FLVCNT_flvcnt2_shift                                       (0)
#define VI_FLVCNT_flvcnt1_mask                                        (0x0003FE00)
#define VI_FLVCNT_flvcnt2_mask                                        (0x000001FF)
#define VI_FLVCNT_flvcnt1(data)                                       (0x0003FE00&((data)<<9))
#define VI_FLVCNT_flvcnt2(data)                                       (0x000001FF&(data))
#define VI_FLVCNT_get_flvcnt1(data)                                   ((0x0003FE00&(data))>>9)
#define VI_FLVCNT_get_flvcnt2(data)                                   (0x000001FF&(data))

#define VI_SLCNT                                                      0x18004030
#define VI_SLCNT_reg_addr                                             "0xB8004030"
#define VI_SLCNT_reg                                                  0xB8004030
#define VI_SLCNT_inst_addr                                            "0x000C"
#define VI_SLCNT_inst                                                 0x000C
#define VI_SLCNT_slcnt1_shift                                         (9)
#define VI_SLCNT_slcnt2_shift                                         (0)
#define VI_SLCNT_slcnt1_mask                                          (0x0003FE00)
#define VI_SLCNT_slcnt2_mask                                          (0x000001FF)
#define VI_SLCNT_slcnt1(data)                                         (0x0003FE00&((data)<<9))
#define VI_SLCNT_slcnt2(data)                                         (0x000001FF&(data))
#define VI_SLCNT_get_slcnt1(data)                                     ((0x0003FE00&(data))>>9)
#define VI_SLCNT_get_slcnt2(data)                                     (0x000001FF&(data))

#define VI_LLCNT                                                      0x18004034
#define VI_LLCNT_reg_addr                                             "0xB8004034"
#define VI_LLCNT_reg                                                  0xB8004034
#define VI_LLCNT_inst_addr                                            "0x000D"
#define VI_LLCNT_inst                                                 0x000D
#define VI_LLCNT_llcnt1_shift                                         (9)
#define VI_LLCNT_llcnt2_shift                                         (0)
#define VI_LLCNT_llcnt1_mask                                          (0x0003FE00)
#define VI_LLCNT_llcnt2_mask                                          (0x000001FF)
#define VI_LLCNT_llcnt1(data)                                         (0x0003FE00&((data)<<9))
#define VI_LLCNT_llcnt2(data)                                         (0x000001FF&(data))
#define VI_LLCNT_get_llcnt1(data)                                     ((0x0003FE00&(data))>>9)
#define VI_LLCNT_get_llcnt2(data)                                     (0x000001FF&(data))

#define VI_SLTHRESHOLD                                                0x18004038
#define VI_SLTHRESHOLD_reg_addr                                       "0xB8004038"
#define VI_SLTHRESHOLD_reg                                            0xB8004038
#define VI_SLTHRESHOLD_inst_addr                                      "0x000E"
#define VI_SLTHRESHOLD_inst                                           0x000E
#define VI_SLTHRESHOLD_write_enable1_shift                            (21)
#define VI_SLTHRESHOLD_slthd1_shift                                   (11)
#define VI_SLTHRESHOLD_write_enable2_shift                            (10)
#define VI_SLTHRESHOLD_slthd2_shift                                   (0)
#define VI_SLTHRESHOLD_write_enable1_mask                             (0x00200000)
#define VI_SLTHRESHOLD_slthd1_mask                                    (0x001FF800)
#define VI_SLTHRESHOLD_write_enable2_mask                             (0x00000400)
#define VI_SLTHRESHOLD_slthd2_mask                                    (0x000003FF)
#define VI_SLTHRESHOLD_write_enable1(data)                            (0x00200000&((data)<<21))
#define VI_SLTHRESHOLD_slthd1(data)                                   (0x001FF800&((data)<<11))
#define VI_SLTHRESHOLD_write_enable2(data)                            (0x00000400&((data)<<10))
#define VI_SLTHRESHOLD_slthd2(data)                                   (0x000003FF&(data))
#define VI_SLTHRESHOLD_get_write_enable1(data)                        ((0x00200000&(data))>>21)
#define VI_SLTHRESHOLD_get_slthd1(data)                               ((0x001FF800&(data))>>11)
#define VI_SLTHRESHOLD_get_write_enable2(data)                        ((0x00000400&(data))>>10)
#define VI_SLTHRESHOLD_get_slthd2(data)                               (0x000003FF&(data))

#define VI_LLTHRESHOLD                                                0x1800403C
#define VI_LLTHRESHOLD_reg_addr                                       "0xB800403C"
#define VI_LLTHRESHOLD_reg                                            0xB800403C
#define VI_LLTHRESHOLD_inst_addr                                      "0x000F"
#define VI_LLTHRESHOLD_inst                                           0x000F
#define VI_LLTHRESHOLD_write_enable1_shift                            (21)
#define VI_LLTHRESHOLD_llthd1_shift                                   (11)
#define VI_LLTHRESHOLD_write_enable2_shift                            (10)
#define VI_LLTHRESHOLD_llthd2_shift                                   (0)
#define VI_LLTHRESHOLD_write_enable1_mask                             (0x00200000)
#define VI_LLTHRESHOLD_llthd1_mask                                    (0x001FF800)
#define VI_LLTHRESHOLD_write_enable2_mask                             (0x00000400)
#define VI_LLTHRESHOLD_llthd2_mask                                    (0x000003FF)
#define VI_LLTHRESHOLD_write_enable1(data)                            (0x00200000&((data)<<21))
#define VI_LLTHRESHOLD_llthd1(data)                                   (0x001FF800&((data)<<11))
#define VI_LLTHRESHOLD_write_enable2(data)                            (0x00000400&((data)<<10))
#define VI_LLTHRESHOLD_llthd2(data)                                   (0x000003FF&(data))
#define VI_LLTHRESHOLD_get_write_enable1(data)                        ((0x00200000&(data))>>21)
#define VI_LLTHRESHOLD_get_llthd1(data)                               ((0x001FF800&(data))>>11)
#define VI_LLTHRESHOLD_get_write_enable2(data)                        ((0x00000400&(data))>>10)
#define VI_LLTHRESHOLD_get_llthd2(data)                               (0x000003FF&(data))

#define VI_VBIWV1                                                     0x18004040
#define VI_VBIWV1_reg_addr                                            "0xB8004040"
#define VI_VBIWV1_reg                                                 0xB8004040
#define VI_VBIWV1_inst_addr                                           "0x0010"
#define VI_VBIWV1_inst                                                0x0010
#define VI_VBIWV1_write_enable1_shift                                 (13)
#define VI_VBIWV1_enable_shift                                        (12)
#define VI_VBIWV1_write_enable2_shift                                 (11)
#define VI_VBIWV1_vstart_shift                                        (6)
#define VI_VBIWV1_write_enable3_shift                                 (5)
#define VI_VBIWV1_vend_shift                                          (0)
#define VI_VBIWV1_write_enable1_mask                                  (0x00002000)
#define VI_VBIWV1_enable_mask                                         (0x00001000)
#define VI_VBIWV1_write_enable2_mask                                  (0x00000800)
#define VI_VBIWV1_vstart_mask                                         (0x000007C0)
#define VI_VBIWV1_write_enable3_mask                                  (0x00000020)
#define VI_VBIWV1_vend_mask                                           (0x0000001F)
#define VI_VBIWV1_write_enable1(data)                                 (0x00002000&((data)<<13))
#define VI_VBIWV1_enable(data)                                        (0x00001000&((data)<<12))
#define VI_VBIWV1_write_enable2(data)                                 (0x00000800&((data)<<11))
#define VI_VBIWV1_vstart(data)                                        (0x000007C0&((data)<<6))
#define VI_VBIWV1_write_enable3(data)                                 (0x00000020&((data)<<5))
#define VI_VBIWV1_vend(data)                                          (0x0000001F&(data))
#define VI_VBIWV1_get_write_enable1(data)                             ((0x00002000&(data))>>13)
#define VI_VBIWV1_get_enable(data)                                    ((0x00001000&(data))>>12)
#define VI_VBIWV1_get_write_enable2(data)                             ((0x00000800&(data))>>11)
#define VI_VBIWV1_get_vstart(data)                                    ((0x000007C0&(data))>>6)
#define VI_VBIWV1_get_write_enable3(data)                             ((0x00000020&(data))>>5)
#define VI_VBIWV1_get_vend(data)                                      (0x0000001F&(data))

#define VI_VBIWV2                                                     0x18004044
#define VI_VBIWV2_reg_addr                                            "0xB8004044"
#define VI_VBIWV2_reg                                                 0xB8004044
#define VI_VBIWV2_inst_addr                                           "0x0011"
#define VI_VBIWV2_inst                                                0x0011
#define VI_VBIWV2_write_enable1_shift                                 (15)
#define VI_VBIWV2_yonly_shift                                         (14)
#define VI_VBIWV2_write_enable2_shift                                 (13)
#define VI_VBIWV2_enable_shift                                        (12)
#define VI_VBIWV2_write_enable3_shift                                 (11)
#define VI_VBIWV2_vstart_shift                                        (6)
#define VI_VBIWV2_write_enable4_shift                                 (5)
#define VI_VBIWV2_vend_shift                                          (0)
#define VI_VBIWV2_write_enable1_mask                                  (0x00008000)
#define VI_VBIWV2_yonly_mask                                          (0x00004000)
#define VI_VBIWV2_write_enable2_mask                                  (0x00002000)
#define VI_VBIWV2_enable_mask                                         (0x00001000)
#define VI_VBIWV2_write_enable3_mask                                  (0x00000800)
#define VI_VBIWV2_vstart_mask                                         (0x000007C0)
#define VI_VBIWV2_write_enable4_mask                                  (0x00000020)
#define VI_VBIWV2_vend_mask                                           (0x0000001F)
#define VI_VBIWV2_write_enable1(data)                                 (0x00008000&((data)<<15))
#define VI_VBIWV2_yonly(data)                                         (0x00004000&((data)<<14))
#define VI_VBIWV2_write_enable2(data)                                 (0x00002000&((data)<<13))
#define VI_VBIWV2_enable(data)                                        (0x00001000&((data)<<12))
#define VI_VBIWV2_write_enable3(data)                                 (0x00000800&((data)<<11))
#define VI_VBIWV2_vstart(data)                                        (0x000007C0&((data)<<6))
#define VI_VBIWV2_write_enable4(data)                                 (0x00000020&((data)<<5))
#define VI_VBIWV2_vend(data)                                          (0x0000001F&(data))
#define VI_VBIWV2_get_write_enable1(data)                             ((0x00008000&(data))>>15)
#define VI_VBIWV2_get_yonly(data)                                     ((0x00004000&(data))>>14)
#define VI_VBIWV2_get_write_enable2(data)                             ((0x00002000&(data))>>13)
#define VI_VBIWV2_get_enable(data)                                    ((0x00001000&(data))>>12)
#define VI_VBIWV2_get_write_enable3(data)                             ((0x00000800&(data))>>11)
#define VI_VBIWV2_get_vstart(data)                                    ((0x000007C0&(data))>>6)
#define VI_VBIWV2_get_write_enable4(data)                             ((0x00000020&(data))>>5)
#define VI_VBIWV2_get_vend(data)                                      (0x0000001F&(data))

#define VI_VBIWH1                                                     0x18004048
#define VI_VBIWH1_reg_addr                                            "0xB8004048"
#define VI_VBIWH1_reg                                                 0xB8004048
#define VI_VBIWH1_inst_addr                                           "0x0012"
#define VI_VBIWH1_inst                                                0x0012
#define VI_VBIWH1_write_enable1_shift                                 (21)
#define VI_VBIWH1_hstart_shift                                        (11)
#define VI_VBIWH1_write_enable2_shift                                 (10)
#define VI_VBIWH1_hend_shift                                          (0)
#define VI_VBIWH1_write_enable1_mask                                  (0x00200000)
#define VI_VBIWH1_hstart_mask                                         (0x001FF800)
#define VI_VBIWH1_write_enable2_mask                                  (0x00000400)
#define VI_VBIWH1_hend_mask                                           (0x000003FF)
#define VI_VBIWH1_write_enable1(data)                                 (0x00200000&((data)<<21))
#define VI_VBIWH1_hstart(data)                                        (0x001FF800&((data)<<11))
#define VI_VBIWH1_write_enable2(data)                                 (0x00000400&((data)<<10))
#define VI_VBIWH1_hend(data)                                          (0x000003FF&(data))
#define VI_VBIWH1_get_write_enable1(data)                             ((0x00200000&(data))>>21)
#define VI_VBIWH1_get_hstart(data)                                    ((0x001FF800&(data))>>11)
#define VI_VBIWH1_get_write_enable2(data)                             ((0x00000400&(data))>>10)
#define VI_VBIWH1_get_hend(data)                                      (0x000003FF&(data))

#define VI_VBIWH2                                                     0x1800404C
#define VI_VBIWH2_reg_addr                                            "0xB800404C"
#define VI_VBIWH2_reg                                                 0xB800404C
#define VI_VBIWH2_inst_addr                                           "0x0013"
#define VI_VBIWH2_inst                                                0x0013
#define VI_VBIWH2_write_enable1_shift                                 (21)
#define VI_VBIWH2_hstart_shift                                        (11)
#define VI_VBIWH2_write_enable2_shift                                 (10)
#define VI_VBIWH2_hend_shift                                          (0)
#define VI_VBIWH2_write_enable1_mask                                  (0x00200000)
#define VI_VBIWH2_hstart_mask                                         (0x001FF800)
#define VI_VBIWH2_write_enable2_mask                                  (0x00000400)
#define VI_VBIWH2_hend_mask                                           (0x000003FF)
#define VI_VBIWH2_write_enable1(data)                                 (0x00200000&((data)<<21))
#define VI_VBIWH2_hstart(data)                                        (0x001FF800&((data)<<11))
#define VI_VBIWH2_write_enable2(data)                                 (0x00000400&((data)<<10))
#define VI_VBIWH2_hend(data)                                          (0x000003FF&(data))
#define VI_VBIWH2_get_write_enable1(data)                             ((0x00200000&(data))>>21)
#define VI_VBIWH2_get_hstart(data)                                    ((0x001FF800&(data))>>11)
#define VI_VBIWH2_get_write_enable2(data)                             ((0x00000400&(data))>>10)
#define VI_VBIWH2_get_hend(data)                                      (0x000003FF&(data))

#define VI_VBI_SCALING1                                               0x18004050
#define VI_VBI_SCALING1_reg_addr                                      "0xB8004050"
#define VI_VBI_SCALING1_reg                                           0xB8004050
#define VI_VBI_SCALING1_inst_addr                                     "0x0014"
#define VI_VBI_SCALING1_inst                                          0x0014
#define VI_VBI_SCALING1_write_enable1_shift                           (19)
#define VI_VBI_SCALING1_scaling_en1_shift                             (18)
#define VI_VBI_SCALING1_write_enable2_shift                           (17)
#define VI_VBI_SCALING1_gain_shift                                    (9)
#define VI_VBI_SCALING1_write_enable3_shift                           (8)
#define VI_VBI_SCALING1_offset_shift                                  (0)
#define VI_VBI_SCALING1_write_enable1_mask                            (0x00080000)
#define VI_VBI_SCALING1_scaling_en1_mask                              (0x00040000)
#define VI_VBI_SCALING1_write_enable2_mask                            (0x00020000)
#define VI_VBI_SCALING1_gain_mask                                     (0x0001FE00)
#define VI_VBI_SCALING1_write_enable3_mask                            (0x00000100)
#define VI_VBI_SCALING1_offset_mask                                   (0x000000FF)
#define VI_VBI_SCALING1_write_enable1(data)                           (0x00080000&((data)<<19))
#define VI_VBI_SCALING1_scaling_en1(data)                             (0x00040000&((data)<<18))
#define VI_VBI_SCALING1_write_enable2(data)                           (0x00020000&((data)<<17))
#define VI_VBI_SCALING1_gain(data)                                    (0x0001FE00&((data)<<9))
#define VI_VBI_SCALING1_write_enable3(data)                           (0x00000100&((data)<<8))
#define VI_VBI_SCALING1_offset(data)                                  (0x000000FF&(data))
#define VI_VBI_SCALING1_get_write_enable1(data)                       ((0x00080000&(data))>>19)
#define VI_VBI_SCALING1_get_scaling_en1(data)                         ((0x00040000&(data))>>18)
#define VI_VBI_SCALING1_get_write_enable2(data)                       ((0x00020000&(data))>>17)
#define VI_VBI_SCALING1_get_gain(data)                                ((0x0001FE00&(data))>>9)
#define VI_VBI_SCALING1_get_write_enable3(data)                       ((0x00000100&(data))>>8)
#define VI_VBI_SCALING1_get_offset(data)                              (0x000000FF&(data))

#define VI_VBI_SCALING2                                               0x18004054
#define VI_VBI_SCALING2_reg_addr                                      "0xB8004054"
#define VI_VBI_SCALING2_reg                                           0xB8004054
#define VI_VBI_SCALING2_inst_addr                                     "0x0015"
#define VI_VBI_SCALING2_inst                                          0x0015
#define VI_VBI_SCALING2_write_enable1_shift                           (19)
#define VI_VBI_SCALING2_scaling_en2_shift                             (18)
#define VI_VBI_SCALING2_write_enable2_shift                           (17)
#define VI_VBI_SCALING2_gain_shift                                    (9)
#define VI_VBI_SCALING2_write_enable3_shift                           (8)
#define VI_VBI_SCALING2_offset_shift                                  (0)
#define VI_VBI_SCALING2_write_enable1_mask                            (0x00080000)
#define VI_VBI_SCALING2_scaling_en2_mask                              (0x00040000)
#define VI_VBI_SCALING2_write_enable2_mask                            (0x00020000)
#define VI_VBI_SCALING2_gain_mask                                     (0x0001FE00)
#define VI_VBI_SCALING2_write_enable3_mask                            (0x00000100)
#define VI_VBI_SCALING2_offset_mask                                   (0x000000FF)
#define VI_VBI_SCALING2_write_enable1(data)                           (0x00080000&((data)<<19))
#define VI_VBI_SCALING2_scaling_en2(data)                             (0x00040000&((data)<<18))
#define VI_VBI_SCALING2_write_enable2(data)                           (0x00020000&((data)<<17))
#define VI_VBI_SCALING2_gain(data)                                    (0x0001FE00&((data)<<9))
#define VI_VBI_SCALING2_write_enable3(data)                           (0x00000100&((data)<<8))
#define VI_VBI_SCALING2_offset(data)                                  (0x000000FF&(data))
#define VI_VBI_SCALING2_get_write_enable1(data)                       ((0x00080000&(data))>>19)
#define VI_VBI_SCALING2_get_scaling_en2(data)                         ((0x00040000&(data))>>18)
#define VI_VBI_SCALING2_get_write_enable2(data)                       ((0x00020000&(data))>>17)
#define VI_VBI_SCALING2_get_gain(data)                                ((0x0001FE00&(data))>>9)
#define VI_VBI_SCALING2_get_write_enable3(data)                       ((0x00000100&(data))>>8)
#define VI_VBI_SCALING2_get_offset(data)                              (0x000000FF&(data))

#define VI_DINYCTRL                                                   0x18004058
#define VI_DINYCTRL_reg_addr                                          "0xB8004058"
#define VI_DINYCTRL_reg                                               0xB8004058
#define VI_DINYCTRL_inst_addr                                         "0x0016"
#define VI_DINYCTRL_inst                                              0x0016
#define VI_DINYCTRL_write_enable2_shift                               (24)
#define VI_DINYCTRL_ywidth_shift                                      (11)
#define VI_DINYCTRL_write_enable3_shift                               (10)
#define VI_DINYCTRL_yheight_shift                                     (0)
#define VI_DINYCTRL_write_enable2_mask                                (0x01000000)
#define VI_DINYCTRL_ywidth_mask                                       (0x00FFF800)
#define VI_DINYCTRL_write_enable3_mask                                (0x00000400)
#define VI_DINYCTRL_yheight_mask                                      (0x000003FF)
#define VI_DINYCTRL_write_enable2(data)                               (0x01000000&((data)<<24))
#define VI_DINYCTRL_ywidth(data)                                      (0x00FFF800&((data)<<11))
#define VI_DINYCTRL_write_enable3(data)                               (0x00000400&((data)<<10))
#define VI_DINYCTRL_yheight(data)                                     (0x000003FF&(data))
#define VI_DINYCTRL_get_write_enable2(data)                           ((0x01000000&(data))>>24)
#define VI_DINYCTRL_get_ywidth(data)                                  ((0x00FFF800&(data))>>11)
#define VI_DINYCTRL_get_write_enable3(data)                           ((0x00000400&(data))>>10)
#define VI_DINYCTRL_get_yheight(data)                                 (0x000003FF&(data))

#define VI_DINCCTRL                                                   0x1800405C
#define VI_DINCCTRL_reg_addr                                          "0xB800405C"
#define VI_DINCCTRL_reg                                               0xB800405C
#define VI_DINCCTRL_inst_addr                                         "0x0017"
#define VI_DINCCTRL_inst                                              0x0017
#define VI_DINCCTRL_write_enable1_shift                               (24)
#define VI_DINCCTRL_cwidth_shift                                      (11)
#define VI_DINCCTRL_write_enable2_shift                               (10)
#define VI_DINCCTRL_cheight_shift                                     (0)
#define VI_DINCCTRL_write_enable1_mask                                (0x01000000)
#define VI_DINCCTRL_cwidth_mask                                       (0x00FFF800)
#define VI_DINCCTRL_write_enable2_mask                                (0x00000400)
#define VI_DINCCTRL_cheight_mask                                      (0x000003FF)
#define VI_DINCCTRL_write_enable1(data)                               (0x01000000&((data)<<24))
#define VI_DINCCTRL_cwidth(data)                                      (0x00FFF800&((data)<<11))
#define VI_DINCCTRL_write_enable2(data)                               (0x00000400&((data)<<10))
#define VI_DINCCTRL_cheight(data)                                     (0x000003FF&(data))
#define VI_DINCCTRL_get_write_enable1(data)                           ((0x01000000&(data))>>24)
#define VI_DINCCTRL_get_cwidth(data)                                  ((0x00FFF800&(data))>>11)
#define VI_DINCCTRL_get_write_enable2(data)                           ((0x00000400&(data))>>10)
#define VI_DINCCTRL_get_cheight(data)                                 (0x000003FF&(data))

#define VI_YDC1                                                       0x18004060
#define VI_YDC1_reg_addr                                              "0xB8004060"
#define VI_YDC1_reg                                                   0xB8004060
#define VI_YDC1_inst_addr                                             "0x0018"
#define VI_YDC1_inst                                                  0x0018
#define VI_YDC1_dc_shift                                              (0)
#define VI_YDC1_dc_mask                                               (0x7FFFFFFF)
#define VI_YDC1_dc(data)                                              (0x7FFFFFFF&(data))
#define VI_YDC1_get_dc(data)                                          (0x7FFFFFFF&(data))

#define VI_YDC2                                                       0x18004064
#define VI_YDC2_reg_addr                                              "0xB8004064"
#define VI_YDC2_reg                                                   0xB8004064
#define VI_YDC2_inst_addr                                             "0x0019"
#define VI_YDC2_inst                                                  0x0019
#define VI_YDC2_dc_shift                                              (0)
#define VI_YDC2_dc_mask                                               (0x7FFFFFFF)
#define VI_YDC2_dc(data)                                              (0x7FFFFFFF&(data))
#define VI_YDC2_get_dc(data)                                          (0x7FFFFFFF&(data))

#define VI_HORNR_Y                                                    0x18004068
#define VI_HORNR_Y_reg_addr                                           "0xB8004068"
#define VI_HORNR_Y_reg                                                0xB8004068
#define VI_HORNR_Y_inst_addr                                          "0x001A"
#define VI_HORNR_Y_inst                                               0x001A
#define VI_HORNR_Y_write_enable1_shift                                (24)
#define VI_HORNR_Y_t1_shift                                           (16)
#define VI_HORNR_Y_write_enable2_shift                                (15)
#define VI_HORNR_Y_t2_shift                                           (7)
#define VI_HORNR_Y_write_enable3_shift                                (6)
#define VI_HORNR_Y_rshiftsize_shift                                   (3)
#define VI_HORNR_Y_write_enable4_shift                                (2)
#define VI_HORNR_Y_hornr_select_shift                                 (0)
#define VI_HORNR_Y_write_enable1_mask                                 (0x01000000)
#define VI_HORNR_Y_t1_mask                                            (0x00FF0000)
#define VI_HORNR_Y_write_enable2_mask                                 (0x00008000)
#define VI_HORNR_Y_t2_mask                                            (0x00007F80)
#define VI_HORNR_Y_write_enable3_mask                                 (0x00000040)
#define VI_HORNR_Y_rshiftsize_mask                                    (0x00000038)
#define VI_HORNR_Y_write_enable4_mask                                 (0x00000004)
#define VI_HORNR_Y_hornr_select_mask                                  (0x00000003)
#define VI_HORNR_Y_write_enable1(data)                                (0x01000000&((data)<<24))
#define VI_HORNR_Y_t1(data)                                           (0x00FF0000&((data)<<16))
#define VI_HORNR_Y_write_enable2(data)                                (0x00008000&((data)<<15))
#define VI_HORNR_Y_t2(data)                                           (0x00007F80&((data)<<7))
#define VI_HORNR_Y_write_enable3(data)                                (0x00000040&((data)<<6))
#define VI_HORNR_Y_rshiftsize(data)                                   (0x00000038&((data)<<3))
#define VI_HORNR_Y_write_enable4(data)                                (0x00000004&((data)<<2))
#define VI_HORNR_Y_hornr_select(data)                                 (0x00000003&(data))
#define VI_HORNR_Y_get_write_enable1(data)                            ((0x01000000&(data))>>24)
#define VI_HORNR_Y_get_t1(data)                                       ((0x00FF0000&(data))>>16)
#define VI_HORNR_Y_get_write_enable2(data)                            ((0x00008000&(data))>>15)
#define VI_HORNR_Y_get_t2(data)                                       ((0x00007F80&(data))>>7)
#define VI_HORNR_Y_get_write_enable3(data)                            ((0x00000040&(data))>>6)
#define VI_HORNR_Y_get_rshiftsize(data)                               ((0x00000038&(data))>>3)
#define VI_HORNR_Y_get_write_enable4(data)                            ((0x00000004&(data))>>2)
#define VI_HORNR_Y_get_hornr_select(data)                             (0x00000003&(data))

#define VI_HORNR_C                                                    0x1800406C
#define VI_HORNR_C_reg_addr                                           "0xB800406C"
#define VI_HORNR_C_reg                                                0xB800406C
#define VI_HORNR_C_inst_addr                                          "0x001B"
#define VI_HORNR_C_inst                                               0x001B
#define VI_HORNR_C_write_enable1_shift                                (21)
#define VI_HORNR_C_t1_shift                                           (13)
#define VI_HORNR_C_write_enable2_shift                                (12)
#define VI_HORNR_C_t2_shift                                           (4)
#define VI_HORNR_C_write_enable3_shift                                (3)
#define VI_HORNR_C_rshiftsize_shift                                   (0)
#define VI_HORNR_C_write_enable1_mask                                 (0x00200000)
#define VI_HORNR_C_t1_mask                                            (0x001FE000)
#define VI_HORNR_C_write_enable2_mask                                 (0x00001000)
#define VI_HORNR_C_t2_mask                                            (0x00000FF0)
#define VI_HORNR_C_write_enable3_mask                                 (0x00000008)
#define VI_HORNR_C_rshiftsize_mask                                    (0x00000007)
#define VI_HORNR_C_write_enable1(data)                                (0x00200000&((data)<<21))
#define VI_HORNR_C_t1(data)                                           (0x001FE000&((data)<<13))
#define VI_HORNR_C_write_enable2(data)                                (0x00001000&((data)<<12))
#define VI_HORNR_C_t2(data)                                           (0x00000FF0&((data)<<4))
#define VI_HORNR_C_write_enable3(data)                                (0x00000008&((data)<<3))
#define VI_HORNR_C_rshiftsize(data)                                   (0x00000007&(data))
#define VI_HORNR_C_get_write_enable1(data)                            ((0x00200000&(data))>>21)
#define VI_HORNR_C_get_t1(data)                                       ((0x001FE000&(data))>>13)
#define VI_HORNR_C_get_write_enable2(data)                            ((0x00001000&(data))>>12)
#define VI_HORNR_C_get_t2(data)                                       ((0x00000FF0&(data))>>4)
#define VI_HORNR_C_get_write_enable3(data)                            ((0x00000008&(data))>>3)
#define VI_HORNR_C_get_rshiftsize(data)                               (0x00000007&(data))

#define VI_SCCTL1                                                     0x18004070
#define VI_SCCTL1_reg_addr                                            "0xB8004070"
#define VI_SCCTL1_reg                                                 0xB8004070
#define VI_SCCTL1_inst_addr                                           "0x001C"
#define VI_SCCTL1_inst                                                0x001C
#define VI_SCCTL1_yen_shift                                           (4)
#define VI_SCCTL1_yoddtype_shift                                      (3)
#define VI_SCCTL1_cen_shift                                           (2)
#define VI_SCCTL1_coddtype_shift                                      (1)
#define VI_SCCTL1_write_data_shift                                    (0)
#define VI_SCCTL1_yen_mask                                            (0x00000010)
#define VI_SCCTL1_yoddtype_mask                                       (0x00000008)
#define VI_SCCTL1_cen_mask                                            (0x00000004)
#define VI_SCCTL1_coddtype_mask                                       (0x00000002)
#define VI_SCCTL1_write_data_mask                                     (0x00000001)
#define VI_SCCTL1_yen(data)                                           (0x00000010&((data)<<4))
#define VI_SCCTL1_yoddtype(data)                                      (0x00000008&((data)<<3))
#define VI_SCCTL1_cen(data)                                           (0x00000004&((data)<<2))
#define VI_SCCTL1_coddtype(data)                                      (0x00000002&((data)<<1))
#define VI_SCCTL1_write_data(data)                                    (0x00000001&(data))
#define VI_SCCTL1_get_yen(data)                                       ((0x00000010&(data))>>4)
#define VI_SCCTL1_get_yoddtype(data)                                  ((0x00000008&(data))>>3)
#define VI_SCCTL1_get_cen(data)                                       ((0x00000004&(data))>>2)
#define VI_SCCTL1_get_coddtype(data)                                  ((0x00000002&(data))>>1)
#define VI_SCCTL1_get_write_data(data)                                (0x00000001&(data))

#define VI_SCCTL2                                                     0x18004074
#define VI_SCCTL2_reg_addr                                            "0xB8004074"
#define VI_SCCTL2_reg                                                 0xB8004074
#define VI_SCCTL2_inst_addr                                           "0x001D"
#define VI_SCCTL2_inst                                                0x001D
#define VI_SCCTL2_yen_shift                                           (4)
#define VI_SCCTL2_yoddtype_shift                                      (3)
#define VI_SCCTL2_cen_shift                                           (2)
#define VI_SCCTL2_coddtype_shift                                      (1)
#define VI_SCCTL2_write_data_shift                                    (0)
#define VI_SCCTL2_yen_mask                                            (0x00000010)
#define VI_SCCTL2_yoddtype_mask                                       (0x00000008)
#define VI_SCCTL2_cen_mask                                            (0x00000004)
#define VI_SCCTL2_coddtype_mask                                       (0x00000002)
#define VI_SCCTL2_write_data_mask                                     (0x00000001)
#define VI_SCCTL2_yen(data)                                           (0x00000010&((data)<<4))
#define VI_SCCTL2_yoddtype(data)                                      (0x00000008&((data)<<3))
#define VI_SCCTL2_cen(data)                                           (0x00000004&((data)<<2))
#define VI_SCCTL2_coddtype(data)                                      (0x00000002&((data)<<1))
#define VI_SCCTL2_write_data(data)                                    (0x00000001&(data))
#define VI_SCCTL2_get_yen(data)                                       ((0x00000010&(data))>>4)
#define VI_SCCTL2_get_yoddtype(data)                                  ((0x00000008&(data))>>3)
#define VI_SCCTL2_get_cen(data)                                       ((0x00000004&(data))>>2)
#define VI_SCCTL2_get_coddtype(data)                                  ((0x00000002&(data))>>1)
#define VI_SCCTL2_get_write_data(data)                                (0x00000001&(data))

#define VI_YSC1                                                       0x18004078
#define VI_YSC1_reg_addr                                              "0xB8004078"
#define VI_YSC1_reg                                                   0xB8004078
#define VI_YSC1_inst_addr                                             "0x001E"
#define VI_YSC1_inst                                                  0x001E
#define VI_YSC1_write_enable1_shift                                   (31)
#define VI_YSC1_yonp_shift                                            (18)
#define VI_YSC1_write_enable2_shift                                   (17)
#define VI_YSC1_ydphs_shift                                           (0)
#define VI_YSC1_write_enable1_mask                                    (0x80000000)
#define VI_YSC1_yonp_mask                                             (0x7FFC0000)
#define VI_YSC1_write_enable2_mask                                    (0x00020000)
#define VI_YSC1_ydphs_mask                                            (0x0001FFFF)
#define VI_YSC1_write_enable1(data)                                   (0x80000000&((data)<<31))
#define VI_YSC1_yonp(data)                                            (0x7FFC0000&((data)<<18))
#define VI_YSC1_write_enable2(data)                                   (0x00020000&((data)<<17))
#define VI_YSC1_ydphs(data)                                           (0x0001FFFF&(data))
#define VI_YSC1_get_write_enable1(data)                               ((0x80000000&(data))>>31)
#define VI_YSC1_get_yonp(data)                                        ((0x7FFC0000&(data))>>18)
#define VI_YSC1_get_write_enable2(data)                               ((0x00020000&(data))>>17)
#define VI_YSC1_get_ydphs(data)                                       (0x0001FFFF&(data))

#define VI_CSC1                                                       0x1800407C
#define VI_CSC1_reg_addr                                              "0xB800407C"
#define VI_CSC1_reg                                                   0xB800407C
#define VI_CSC1_inst_addr                                             "0x001F"
#define VI_CSC1_inst                                                  0x001F
#define VI_CSC1_write_enable1_shift                                   (31)
#define VI_CSC1_conp_shift                                            (18)
#define VI_CSC1_write_enable2_shift                                   (17)
#define VI_CSC1_cdphs_shift                                           (0)
#define VI_CSC1_write_enable1_mask                                    (0x80000000)
#define VI_CSC1_conp_mask                                             (0x7FFC0000)
#define VI_CSC1_write_enable2_mask                                    (0x00020000)
#define VI_CSC1_cdphs_mask                                            (0x0001FFFF)
#define VI_CSC1_write_enable1(data)                                   (0x80000000&((data)<<31))
#define VI_CSC1_conp(data)                                            (0x7FFC0000&((data)<<18))
#define VI_CSC1_write_enable2(data)                                   (0x00020000&((data)<<17))
#define VI_CSC1_cdphs(data)                                           (0x0001FFFF&(data))
#define VI_CSC1_get_write_enable1(data)                               ((0x80000000&(data))>>31)
#define VI_CSC1_get_conp(data)                                        ((0x7FFC0000&(data))>>18)
#define VI_CSC1_get_write_enable2(data)                               ((0x00020000&(data))>>17)
#define VI_CSC1_get_cdphs(data)                                       (0x0001FFFF&(data))

#define VI_YSC2                                                       0x18004080
#define VI_YSC2_reg_addr                                              "0xB8004080"
#define VI_YSC2_reg                                                   0xB8004080
#define VI_YSC2_inst_addr                                             "0x0020"
#define VI_YSC2_inst                                                  0x0020
#define VI_YSC2_write_enable1_shift                                   (31)
#define VI_YSC2_yonp_shift                                            (18)
#define VI_YSC2_write_enable2_shift                                   (17)
#define VI_YSC2_ydphs_shift                                           (0)
#define VI_YSC2_write_enable1_mask                                    (0x80000000)
#define VI_YSC2_yonp_mask                                             (0x7FFC0000)
#define VI_YSC2_write_enable2_mask                                    (0x00020000)
#define VI_YSC2_ydphs_mask                                            (0x0001FFFF)
#define VI_YSC2_write_enable1(data)                                   (0x80000000&((data)<<31))
#define VI_YSC2_yonp(data)                                            (0x7FFC0000&((data)<<18))
#define VI_YSC2_write_enable2(data)                                   (0x00020000&((data)<<17))
#define VI_YSC2_ydphs(data)                                           (0x0001FFFF&(data))
#define VI_YSC2_get_write_enable1(data)                               ((0x80000000&(data))>>31)
#define VI_YSC2_get_yonp(data)                                        ((0x7FFC0000&(data))>>18)
#define VI_YSC2_get_write_enable2(data)                               ((0x00020000&(data))>>17)
#define VI_YSC2_get_ydphs(data)                                       (0x0001FFFF&(data))

#define VI_CSC2                                                       0x18004084
#define VI_CSC2_reg_addr                                              "0xB8004084"
#define VI_CSC2_reg                                                   0xB8004084
#define VI_CSC2_inst_addr                                             "0x0021"
#define VI_CSC2_inst                                                  0x0021
#define VI_CSC2_write_enable1_shift                                   (31)
#define VI_CSC2_conp_shift                                            (18)
#define VI_CSC2_write_enable2_shift                                   (17)
#define VI_CSC2_cdphs_shift                                           (0)
#define VI_CSC2_write_enable1_mask                                    (0x80000000)
#define VI_CSC2_conp_mask                                             (0x7FFC0000)
#define VI_CSC2_write_enable2_mask                                    (0x00020000)
#define VI_CSC2_cdphs_mask                                            (0x0001FFFF)
#define VI_CSC2_write_enable1(data)                                   (0x80000000&((data)<<31))
#define VI_CSC2_conp(data)                                            (0x7FFC0000&((data)<<18))
#define VI_CSC2_write_enable2(data)                                   (0x00020000&((data)<<17))
#define VI_CSC2_cdphs(data)                                           (0x0001FFFF&(data))
#define VI_CSC2_get_write_enable1(data)                               ((0x80000000&(data))>>31)
#define VI_CSC2_get_conp(data)                                        ((0x7FFC0000&(data))>>18)
#define VI_CSC2_get_write_enable2(data)                               ((0x00020000&(data))>>17)
#define VI_CSC2_get_cdphs(data)                                       (0x0001FFFF&(data))

#define VI_YIPOS1                                                     0x18004088
#define VI_YIPOS1_reg_addr                                            "0xB8004088"
#define VI_YIPOS1_reg                                                 0xB8004088
#define VI_YIPOS1_inst_addr                                           "0x0022"
#define VI_YIPOS1_inst                                                0x0022
#define VI_YIPOS1_init_offset_shift                                   (14)
#define VI_YIPOS1_init_phase_shift                                    (0)
#define VI_YIPOS1_init_offset_mask                                    (0x00FFC000)
#define VI_YIPOS1_init_phase_mask                                     (0x00003FFF)
#define VI_YIPOS1_init_offset(data)                                   (0x00FFC000&((data)<<14))
#define VI_YIPOS1_init_phase(data)                                    (0x00003FFF&(data))
#define VI_YIPOS1_get_init_offset(data)                               ((0x00FFC000&(data))>>14)
#define VI_YIPOS1_get_init_phase(data)                                (0x00003FFF&(data))

#define VI_YIPOS2                                                     0x1800408C
#define VI_YIPOS2_reg_addr                                            "0xB800408C"
#define VI_YIPOS2_reg                                                 0xB800408C
#define VI_YIPOS2_inst_addr                                           "0x0023"
#define VI_YIPOS2_inst                                                0x0023
#define VI_YIPOS2_init_offset_shift                                   (14)
#define VI_YIPOS2_init_phase_shift                                    (0)
#define VI_YIPOS2_init_offset_mask                                    (0x00FFC000)
#define VI_YIPOS2_init_phase_mask                                     (0x00003FFF)
#define VI_YIPOS2_init_offset(data)                                   (0x00FFC000&((data)<<14))
#define VI_YIPOS2_init_phase(data)                                    (0x00003FFF&(data))
#define VI_YIPOS2_get_init_offset(data)                               ((0x00FFC000&(data))>>14)
#define VI_YIPOS2_get_init_phase(data)                                (0x00003FFF&(data))

#define VI_CIPOS1                                                     0x18004090
#define VI_CIPOS1_reg_addr                                            "0xB8004090"
#define VI_CIPOS1_reg                                                 0xB8004090
#define VI_CIPOS1_inst_addr                                           "0x0024"
#define VI_CIPOS1_inst                                                0x0024
#define VI_CIPOS1_init_offset_shift                                   (14)
#define VI_CIPOS1_init_phase_shift                                    (0)
#define VI_CIPOS1_init_offset_mask                                    (0x00FFC000)
#define VI_CIPOS1_init_phase_mask                                     (0x00003FFF)
#define VI_CIPOS1_init_offset(data)                                   (0x00FFC000&((data)<<14))
#define VI_CIPOS1_init_phase(data)                                    (0x00003FFF&(data))
#define VI_CIPOS1_get_init_offset(data)                               ((0x00FFC000&(data))>>14)
#define VI_CIPOS1_get_init_phase(data)                                (0x00003FFF&(data))

#define VI_CIPOS2                                                     0x18004094
#define VI_CIPOS2_reg_addr                                            "0xB8004094"
#define VI_CIPOS2_reg                                                 0xB8004094
#define VI_CIPOS2_inst_addr                                           "0x0025"
#define VI_CIPOS2_inst                                                0x0025
#define VI_CIPOS2_init_offset_shift                                   (14)
#define VI_CIPOS2_init_phase_shift                                    (0)
#define VI_CIPOS2_init_offset_mask                                    (0x00FFC000)
#define VI_CIPOS2_init_phase_mask                                     (0x00003FFF)
#define VI_CIPOS2_init_offset(data)                                   (0x00FFC000&((data)<<14))
#define VI_CIPOS2_init_phase(data)                                    (0x00003FFF&(data))
#define VI_CIPOS2_get_init_offset(data)                               ((0x00FFC000&(data))>>14)
#define VI_CIPOS2_get_init_phase(data)                                (0x00003FFF&(data))

#define VI_YSCCOEF1_0                                                 0x18004098
#define VI_YSCCOEF1_1                                                 0x1800409C
#define VI_YSCCOEF1_2                                                 0x180040A0
#define VI_YSCCOEF1_3                                                 0x180040A4
#define VI_YSCCOEF1_4                                                 0x180040A8
#define VI_YSCCOEF1_5                                                 0x180040AC
#define VI_YSCCOEF1_6                                                 0x180040B0
#define VI_YSCCOEF1_7                                                 0x180040B4
#define VI_YSCCOEF1_8                                                 0x180040B8
#define VI_YSCCOEF1_9                                                 0x180040BC
#define VI_YSCCOEF1_10                                                0x180040C0
#define VI_YSCCOEF1_11                                                0x180040C4
#define VI_YSCCOEF1_12                                                0x180040C8
#define VI_YSCCOEF1_13                                                0x180040CC
#define VI_YSCCOEF1_14                                                0x180040D0
#define VI_YSCCOEF1_15                                                0x180040D4
#define VI_YSCCOEF1_16                                                0x180040D8
#define VI_YSCCOEF1_17                                                0x180040DC
#define VI_YSCCOEF1_18                                                0x180040E0
#define VI_YSCCOEF1_19                                                0x180040E4
#define VI_YSCCOEF1_20                                                0x180040E8
#define VI_YSCCOEF1_21                                                0x180040EC
#define VI_YSCCOEF1_22                                                0x180040F0
#define VI_YSCCOEF1_23                                                0x180040F4
#define VI_YSCCOEF1_24                                                0x180040F8
#define VI_YSCCOEF1_25                                                0x180040FC
#define VI_YSCCOEF1_26                                                0x18004100
#define VI_YSCCOEF1_27                                                0x18004104
#define VI_YSCCOEF1_28                                                0x18004108
#define VI_YSCCOEF1_29                                                0x1800410C
#define VI_YSCCOEF1_30                                                0x18004110
#define VI_YSCCOEF1_31                                                0x18004114
#define VI_YSCCOEF1_0_reg_addr                                        "0xB8004098"
#define VI_YSCCOEF1_1_reg_addr                                        "0xB800409C"
#define VI_YSCCOEF1_2_reg_addr                                        "0xB80040A0"
#define VI_YSCCOEF1_3_reg_addr                                        "0xB80040A4"
#define VI_YSCCOEF1_4_reg_addr                                        "0xB80040A8"
#define VI_YSCCOEF1_5_reg_addr                                        "0xB80040AC"
#define VI_YSCCOEF1_6_reg_addr                                        "0xB80040B0"
#define VI_YSCCOEF1_7_reg_addr                                        "0xB80040B4"
#define VI_YSCCOEF1_8_reg_addr                                        "0xB80040B8"
#define VI_YSCCOEF1_9_reg_addr                                        "0xB80040BC"
#define VI_YSCCOEF1_10_reg_addr                                       "0xB80040C0"
#define VI_YSCCOEF1_11_reg_addr                                       "0xB80040C4"
#define VI_YSCCOEF1_12_reg_addr                                       "0xB80040C8"
#define VI_YSCCOEF1_13_reg_addr                                       "0xB80040CC"
#define VI_YSCCOEF1_14_reg_addr                                       "0xB80040D0"
#define VI_YSCCOEF1_15_reg_addr                                       "0xB80040D4"
#define VI_YSCCOEF1_16_reg_addr                                       "0xB80040D8"
#define VI_YSCCOEF1_17_reg_addr                                       "0xB80040DC"
#define VI_YSCCOEF1_18_reg_addr                                       "0xB80040E0"
#define VI_YSCCOEF1_19_reg_addr                                       "0xB80040E4"
#define VI_YSCCOEF1_20_reg_addr                                       "0xB80040E8"
#define VI_YSCCOEF1_21_reg_addr                                       "0xB80040EC"
#define VI_YSCCOEF1_22_reg_addr                                       "0xB80040F0"
#define VI_YSCCOEF1_23_reg_addr                                       "0xB80040F4"
#define VI_YSCCOEF1_24_reg_addr                                       "0xB80040F8"
#define VI_YSCCOEF1_25_reg_addr                                       "0xB80040FC"
#define VI_YSCCOEF1_26_reg_addr                                       "0xB8004100"
#define VI_YSCCOEF1_27_reg_addr                                       "0xB8004104"
#define VI_YSCCOEF1_28_reg_addr                                       "0xB8004108"
#define VI_YSCCOEF1_29_reg_addr                                       "0xB800410C"
#define VI_YSCCOEF1_30_reg_addr                                       "0xB8004110"
#define VI_YSCCOEF1_31_reg_addr                                       "0xB8004114"
#define VI_YSCCOEF1_0_reg                                             0xB8004098
#define VI_YSCCOEF1_1_reg                                             0xB800409C
#define VI_YSCCOEF1_2_reg                                             0xB80040A0
#define VI_YSCCOEF1_3_reg                                             0xB80040A4
#define VI_YSCCOEF1_4_reg                                             0xB80040A8
#define VI_YSCCOEF1_5_reg                                             0xB80040AC
#define VI_YSCCOEF1_6_reg                                             0xB80040B0
#define VI_YSCCOEF1_7_reg                                             0xB80040B4
#define VI_YSCCOEF1_8_reg                                             0xB80040B8
#define VI_YSCCOEF1_9_reg                                             0xB80040BC
#define VI_YSCCOEF1_10_reg                                            0xB80040C0
#define VI_YSCCOEF1_11_reg                                            0xB80040C4
#define VI_YSCCOEF1_12_reg                                            0xB80040C8
#define VI_YSCCOEF1_13_reg                                            0xB80040CC
#define VI_YSCCOEF1_14_reg                                            0xB80040D0
#define VI_YSCCOEF1_15_reg                                            0xB80040D4
#define VI_YSCCOEF1_16_reg                                            0xB80040D8
#define VI_YSCCOEF1_17_reg                                            0xB80040DC
#define VI_YSCCOEF1_18_reg                                            0xB80040E0
#define VI_YSCCOEF1_19_reg                                            0xB80040E4
#define VI_YSCCOEF1_20_reg                                            0xB80040E8
#define VI_YSCCOEF1_21_reg                                            0xB80040EC
#define VI_YSCCOEF1_22_reg                                            0xB80040F0
#define VI_YSCCOEF1_23_reg                                            0xB80040F4
#define VI_YSCCOEF1_24_reg                                            0xB80040F8
#define VI_YSCCOEF1_25_reg                                            0xB80040FC
#define VI_YSCCOEF1_26_reg                                            0xB8004100
#define VI_YSCCOEF1_27_reg                                            0xB8004104
#define VI_YSCCOEF1_28_reg                                            0xB8004108
#define VI_YSCCOEF1_29_reg                                            0xB800410C
#define VI_YSCCOEF1_30_reg                                            0xB8004110
#define VI_YSCCOEF1_31_reg                                            0xB8004114
#define VI_YSCCOEF1_0_inst_addr                                       "0x0026"
#define VI_YSCCOEF1_0_inst                                            0x0026
#define VI_YSCCOEF1_1_inst_addr                                       "0x0027"
#define VI_YSCCOEF1_1_inst                                            0x0027
#define VI_YSCCOEF1_2_inst_addr                                       "0x0028"
#define VI_YSCCOEF1_2_inst                                            0x0028
#define VI_YSCCOEF1_3_inst_addr                                       "0x0029"
#define VI_YSCCOEF1_3_inst                                            0x0029
#define VI_YSCCOEF1_4_inst_addr                                       "0x002A"
#define VI_YSCCOEF1_4_inst                                            0x002A
#define VI_YSCCOEF1_5_inst_addr                                       "0x002B"
#define VI_YSCCOEF1_5_inst                                            0x002B
#define VI_YSCCOEF1_6_inst_addr                                       "0x002C"
#define VI_YSCCOEF1_6_inst                                            0x002C
#define VI_YSCCOEF1_7_inst_addr                                       "0x002D"
#define VI_YSCCOEF1_7_inst                                            0x002D
#define VI_YSCCOEF1_8_inst_addr                                       "0x002E"
#define VI_YSCCOEF1_8_inst                                            0x002E
#define VI_YSCCOEF1_9_inst_addr                                       "0x002F"
#define VI_YSCCOEF1_9_inst                                            0x002F
#define VI_YSCCOEF1_10_inst_addr                                      "0x0030"
#define VI_YSCCOEF1_10_inst                                           0x0030
#define VI_YSCCOEF1_11_inst_addr                                      "0x0031"
#define VI_YSCCOEF1_11_inst                                           0x0031
#define VI_YSCCOEF1_12_inst_addr                                      "0x0032"
#define VI_YSCCOEF1_12_inst                                           0x0032
#define VI_YSCCOEF1_13_inst_addr                                      "0x0033"
#define VI_YSCCOEF1_13_inst                                           0x0033
#define VI_YSCCOEF1_14_inst_addr                                      "0x0034"
#define VI_YSCCOEF1_14_inst                                           0x0034
#define VI_YSCCOEF1_15_inst_addr                                      "0x0035"
#define VI_YSCCOEF1_15_inst                                           0x0035
#define VI_YSCCOEF1_16_inst_addr                                      "0x0036"
#define VI_YSCCOEF1_16_inst                                           0x0036
#define VI_YSCCOEF1_17_inst_addr                                      "0x0037"
#define VI_YSCCOEF1_17_inst                                           0x0037
#define VI_YSCCOEF1_18_inst_addr                                      "0x0038"
#define VI_YSCCOEF1_18_inst                                           0x0038
#define VI_YSCCOEF1_19_inst_addr                                      "0x0039"
#define VI_YSCCOEF1_19_inst                                           0x0039
#define VI_YSCCOEF1_20_inst_addr                                      "0x003A"
#define VI_YSCCOEF1_20_inst                                           0x003A
#define VI_YSCCOEF1_21_inst_addr                                      "0x003B"
#define VI_YSCCOEF1_21_inst                                           0x003B
#define VI_YSCCOEF1_22_inst_addr                                      "0x003C"
#define VI_YSCCOEF1_22_inst                                           0x003C
#define VI_YSCCOEF1_23_inst_addr                                      "0x003D"
#define VI_YSCCOEF1_23_inst                                           0x003D
#define VI_YSCCOEF1_24_inst_addr                                      "0x003E"
#define VI_YSCCOEF1_24_inst                                           0x003E
#define VI_YSCCOEF1_25_inst_addr                                      "0x003F"
#define VI_YSCCOEF1_25_inst                                           0x003F
#define VI_YSCCOEF1_26_inst_addr                                      "0x0040"
#define VI_YSCCOEF1_26_inst                                           0x0040
#define VI_YSCCOEF1_27_inst_addr                                      "0x0041"
#define VI_YSCCOEF1_27_inst                                           0x0041
#define VI_YSCCOEF1_28_inst_addr                                      "0x0042"
#define VI_YSCCOEF1_28_inst                                           0x0042
#define VI_YSCCOEF1_29_inst_addr                                      "0x0043"
#define VI_YSCCOEF1_29_inst                                           0x0043
#define VI_YSCCOEF1_30_inst_addr                                      "0x0044"
#define VI_YSCCOEF1_30_inst                                           0x0044
#define VI_YSCCOEF1_31_inst_addr                                      "0x0045"
#define VI_YSCCOEF1_31_inst                                           0x0045
#define VI_YSCCOEF1_ysccoef_shift                                     (0)
#define VI_YSCCOEF1_ysccoef_mask                                      (0x00003FFF)
#define VI_YSCCOEF1_ysccoef(data)                                     (0x00003FFF&(data))
#define VI_YSCCOEF1_get_ysccoef(data)                                 (0x00003FFF&(data))

#define VI_YSCCOEF2_0                                                 0x18004118
#define VI_YSCCOEF2_1                                                 0x1800411C
#define VI_YSCCOEF2_2                                                 0x18004120
#define VI_YSCCOEF2_3                                                 0x18004124
#define VI_YSCCOEF2_4                                                 0x18004128
#define VI_YSCCOEF2_5                                                 0x1800412C
#define VI_YSCCOEF2_6                                                 0x18004130
#define VI_YSCCOEF2_7                                                 0x18004134
#define VI_YSCCOEF2_8                                                 0x18004138
#define VI_YSCCOEF2_9                                                 0x1800413C
#define VI_YSCCOEF2_10                                                0x18004140
#define VI_YSCCOEF2_11                                                0x18004144
#define VI_YSCCOEF2_12                                                0x18004148
#define VI_YSCCOEF2_13                                                0x1800414C
#define VI_YSCCOEF2_14                                                0x18004150
#define VI_YSCCOEF2_15                                                0x18004154
#define VI_YSCCOEF2_16                                                0x18004158
#define VI_YSCCOEF2_17                                                0x1800415C
#define VI_YSCCOEF2_18                                                0x18004160
#define VI_YSCCOEF2_19                                                0x18004164
#define VI_YSCCOEF2_20                                                0x18004168
#define VI_YSCCOEF2_21                                                0x1800416C
#define VI_YSCCOEF2_22                                                0x18004170
#define VI_YSCCOEF2_23                                                0x18004174
#define VI_YSCCOEF2_24                                                0x18004178
#define VI_YSCCOEF2_25                                                0x1800417C
#define VI_YSCCOEF2_26                                                0x18004180
#define VI_YSCCOEF2_27                                                0x18004184
#define VI_YSCCOEF2_28                                                0x18004188
#define VI_YSCCOEF2_29                                                0x1800418C
#define VI_YSCCOEF2_30                                                0x18004190
#define VI_YSCCOEF2_31                                                0x18004194
#define VI_YSCCOEF2_0_reg_addr                                        "0xB8004118"
#define VI_YSCCOEF2_1_reg_addr                                        "0xB800411C"
#define VI_YSCCOEF2_2_reg_addr                                        "0xB8004120"
#define VI_YSCCOEF2_3_reg_addr                                        "0xB8004124"
#define VI_YSCCOEF2_4_reg_addr                                        "0xB8004128"
#define VI_YSCCOEF2_5_reg_addr                                        "0xB800412C"
#define VI_YSCCOEF2_6_reg_addr                                        "0xB8004130"
#define VI_YSCCOEF2_7_reg_addr                                        "0xB8004134"
#define VI_YSCCOEF2_8_reg_addr                                        "0xB8004138"
#define VI_YSCCOEF2_9_reg_addr                                        "0xB800413C"
#define VI_YSCCOEF2_10_reg_addr                                       "0xB8004140"
#define VI_YSCCOEF2_11_reg_addr                                       "0xB8004144"
#define VI_YSCCOEF2_12_reg_addr                                       "0xB8004148"
#define VI_YSCCOEF2_13_reg_addr                                       "0xB800414C"
#define VI_YSCCOEF2_14_reg_addr                                       "0xB8004150"
#define VI_YSCCOEF2_15_reg_addr                                       "0xB8004154"
#define VI_YSCCOEF2_16_reg_addr                                       "0xB8004158"
#define VI_YSCCOEF2_17_reg_addr                                       "0xB800415C"
#define VI_YSCCOEF2_18_reg_addr                                       "0xB8004160"
#define VI_YSCCOEF2_19_reg_addr                                       "0xB8004164"
#define VI_YSCCOEF2_20_reg_addr                                       "0xB8004168"
#define VI_YSCCOEF2_21_reg_addr                                       "0xB800416C"
#define VI_YSCCOEF2_22_reg_addr                                       "0xB8004170"
#define VI_YSCCOEF2_23_reg_addr                                       "0xB8004174"
#define VI_YSCCOEF2_24_reg_addr                                       "0xB8004178"
#define VI_YSCCOEF2_25_reg_addr                                       "0xB800417C"
#define VI_YSCCOEF2_26_reg_addr                                       "0xB8004180"
#define VI_YSCCOEF2_27_reg_addr                                       "0xB8004184"
#define VI_YSCCOEF2_28_reg_addr                                       "0xB8004188"
#define VI_YSCCOEF2_29_reg_addr                                       "0xB800418C"
#define VI_YSCCOEF2_30_reg_addr                                       "0xB8004190"
#define VI_YSCCOEF2_31_reg_addr                                       "0xB8004194"
#define VI_YSCCOEF2_0_reg                                             0xB8004118
#define VI_YSCCOEF2_1_reg                                             0xB800411C
#define VI_YSCCOEF2_2_reg                                             0xB8004120
#define VI_YSCCOEF2_3_reg                                             0xB8004124
#define VI_YSCCOEF2_4_reg                                             0xB8004128
#define VI_YSCCOEF2_5_reg                                             0xB800412C
#define VI_YSCCOEF2_6_reg                                             0xB8004130
#define VI_YSCCOEF2_7_reg                                             0xB8004134
#define VI_YSCCOEF2_8_reg                                             0xB8004138
#define VI_YSCCOEF2_9_reg                                             0xB800413C
#define VI_YSCCOEF2_10_reg                                            0xB8004140
#define VI_YSCCOEF2_11_reg                                            0xB8004144
#define VI_YSCCOEF2_12_reg                                            0xB8004148
#define VI_YSCCOEF2_13_reg                                            0xB800414C
#define VI_YSCCOEF2_14_reg                                            0xB8004150
#define VI_YSCCOEF2_15_reg                                            0xB8004154
#define VI_YSCCOEF2_16_reg                                            0xB8004158
#define VI_YSCCOEF2_17_reg                                            0xB800415C
#define VI_YSCCOEF2_18_reg                                            0xB8004160
#define VI_YSCCOEF2_19_reg                                            0xB8004164
#define VI_YSCCOEF2_20_reg                                            0xB8004168
#define VI_YSCCOEF2_21_reg                                            0xB800416C
#define VI_YSCCOEF2_22_reg                                            0xB8004170
#define VI_YSCCOEF2_23_reg                                            0xB8004174
#define VI_YSCCOEF2_24_reg                                            0xB8004178
#define VI_YSCCOEF2_25_reg                                            0xB800417C
#define VI_YSCCOEF2_26_reg                                            0xB8004180
#define VI_YSCCOEF2_27_reg                                            0xB8004184
#define VI_YSCCOEF2_28_reg                                            0xB8004188
#define VI_YSCCOEF2_29_reg                                            0xB800418C
#define VI_YSCCOEF2_30_reg                                            0xB8004190
#define VI_YSCCOEF2_31_reg                                            0xB8004194
#define VI_YSCCOEF2_0_inst_addr                                       "0x0046"
#define VI_YSCCOEF2_0_inst                                            0x0046
#define VI_YSCCOEF2_1_inst_addr                                       "0x0047"
#define VI_YSCCOEF2_1_inst                                            0x0047
#define VI_YSCCOEF2_2_inst_addr                                       "0x0048"
#define VI_YSCCOEF2_2_inst                                            0x0048
#define VI_YSCCOEF2_3_inst_addr                                       "0x0049"
#define VI_YSCCOEF2_3_inst                                            0x0049
#define VI_YSCCOEF2_4_inst_addr                                       "0x004A"
#define VI_YSCCOEF2_4_inst                                            0x004A
#define VI_YSCCOEF2_5_inst_addr                                       "0x004B"
#define VI_YSCCOEF2_5_inst                                            0x004B
#define VI_YSCCOEF2_6_inst_addr                                       "0x004C"
#define VI_YSCCOEF2_6_inst                                            0x004C
#define VI_YSCCOEF2_7_inst_addr                                       "0x004D"
#define VI_YSCCOEF2_7_inst                                            0x004D
#define VI_YSCCOEF2_8_inst_addr                                       "0x004E"
#define VI_YSCCOEF2_8_inst                                            0x004E
#define VI_YSCCOEF2_9_inst_addr                                       "0x004F"
#define VI_YSCCOEF2_9_inst                                            0x004F
#define VI_YSCCOEF2_10_inst_addr                                      "0x0050"
#define VI_YSCCOEF2_10_inst                                           0x0050
#define VI_YSCCOEF2_11_inst_addr                                      "0x0051"
#define VI_YSCCOEF2_11_inst                                           0x0051
#define VI_YSCCOEF2_12_inst_addr                                      "0x0052"
#define VI_YSCCOEF2_12_inst                                           0x0052
#define VI_YSCCOEF2_13_inst_addr                                      "0x0053"
#define VI_YSCCOEF2_13_inst                                           0x0053
#define VI_YSCCOEF2_14_inst_addr                                      "0x0054"
#define VI_YSCCOEF2_14_inst                                           0x0054
#define VI_YSCCOEF2_15_inst_addr                                      "0x0055"
#define VI_YSCCOEF2_15_inst                                           0x0055
#define VI_YSCCOEF2_16_inst_addr                                      "0x0056"
#define VI_YSCCOEF2_16_inst                                           0x0056
#define VI_YSCCOEF2_17_inst_addr                                      "0x0057"
#define VI_YSCCOEF2_17_inst                                           0x0057
#define VI_YSCCOEF2_18_inst_addr                                      "0x0058"
#define VI_YSCCOEF2_18_inst                                           0x0058
#define VI_YSCCOEF2_19_inst_addr                                      "0x0059"
#define VI_YSCCOEF2_19_inst                                           0x0059
#define VI_YSCCOEF2_20_inst_addr                                      "0x005A"
#define VI_YSCCOEF2_20_inst                                           0x005A
#define VI_YSCCOEF2_21_inst_addr                                      "0x005B"
#define VI_YSCCOEF2_21_inst                                           0x005B
#define VI_YSCCOEF2_22_inst_addr                                      "0x005C"
#define VI_YSCCOEF2_22_inst                                           0x005C
#define VI_YSCCOEF2_23_inst_addr                                      "0x005D"
#define VI_YSCCOEF2_23_inst                                           0x005D
#define VI_YSCCOEF2_24_inst_addr                                      "0x005E"
#define VI_YSCCOEF2_24_inst                                           0x005E
#define VI_YSCCOEF2_25_inst_addr                                      "0x005F"
#define VI_YSCCOEF2_25_inst                                           0x005F
#define VI_YSCCOEF2_26_inst_addr                                      "0x0060"
#define VI_YSCCOEF2_26_inst                                           0x0060
#define VI_YSCCOEF2_27_inst_addr                                      "0x0061"
#define VI_YSCCOEF2_27_inst                                           0x0061
#define VI_YSCCOEF2_28_inst_addr                                      "0x0062"
#define VI_YSCCOEF2_28_inst                                           0x0062
#define VI_YSCCOEF2_29_inst_addr                                      "0x0063"
#define VI_YSCCOEF2_29_inst                                           0x0063
#define VI_YSCCOEF2_30_inst_addr                                      "0x0064"
#define VI_YSCCOEF2_30_inst                                           0x0064
#define VI_YSCCOEF2_31_inst_addr                                      "0x0065"
#define VI_YSCCOEF2_31_inst                                           0x0065
#define VI_YSCCOEF2_ysccoef_shift                                     (0)
#define VI_YSCCOEF2_ysccoef_mask                                      (0x00003FFF)
#define VI_YSCCOEF2_ysccoef(data)                                     (0x00003FFF&(data))
#define VI_YSCCOEF2_get_ysccoef(data)                                 (0x00003FFF&(data))

#define VI_CSCCOEF1_0                                                 0x18004198
#define VI_CSCCOEF1_1                                                 0x1800419C
#define VI_CSCCOEF1_2                                                 0x180041A0
#define VI_CSCCOEF1_3                                                 0x180041A4
#define VI_CSCCOEF1_4                                                 0x180041A8
#define VI_CSCCOEF1_5                                                 0x180041AC
#define VI_CSCCOEF1_6                                                 0x180041B0
#define VI_CSCCOEF1_7                                                 0x180041B4
#define VI_CSCCOEF1_8                                                 0x180041B8
#define VI_CSCCOEF1_9                                                 0x180041BC
#define VI_CSCCOEF1_10                                                0x180041C0
#define VI_CSCCOEF1_11                                                0x180041C4
#define VI_CSCCOEF1_12                                                0x180041C8
#define VI_CSCCOEF1_13                                                0x180041CC
#define VI_CSCCOEF1_14                                                0x180041D0
#define VI_CSCCOEF1_15                                                0x180041D4
#define VI_CSCCOEF1_0_reg_addr                                        "0xB8004198"
#define VI_CSCCOEF1_1_reg_addr                                        "0xB800419C"
#define VI_CSCCOEF1_2_reg_addr                                        "0xB80041A0"
#define VI_CSCCOEF1_3_reg_addr                                        "0xB80041A4"
#define VI_CSCCOEF1_4_reg_addr                                        "0xB80041A8"
#define VI_CSCCOEF1_5_reg_addr                                        "0xB80041AC"
#define VI_CSCCOEF1_6_reg_addr                                        "0xB80041B0"
#define VI_CSCCOEF1_7_reg_addr                                        "0xB80041B4"
#define VI_CSCCOEF1_8_reg_addr                                        "0xB80041B8"
#define VI_CSCCOEF1_9_reg_addr                                        "0xB80041BC"
#define VI_CSCCOEF1_10_reg_addr                                       "0xB80041C0"
#define VI_CSCCOEF1_11_reg_addr                                       "0xB80041C4"
#define VI_CSCCOEF1_12_reg_addr                                       "0xB80041C8"
#define VI_CSCCOEF1_13_reg_addr                                       "0xB80041CC"
#define VI_CSCCOEF1_14_reg_addr                                       "0xB80041D0"
#define VI_CSCCOEF1_15_reg_addr                                       "0xB80041D4"
#define VI_CSCCOEF1_0_reg                                             0xB8004198
#define VI_CSCCOEF1_1_reg                                             0xB800419C
#define VI_CSCCOEF1_2_reg                                             0xB80041A0
#define VI_CSCCOEF1_3_reg                                             0xB80041A4
#define VI_CSCCOEF1_4_reg                                             0xB80041A8
#define VI_CSCCOEF1_5_reg                                             0xB80041AC
#define VI_CSCCOEF1_6_reg                                             0xB80041B0
#define VI_CSCCOEF1_7_reg                                             0xB80041B4
#define VI_CSCCOEF1_8_reg                                             0xB80041B8
#define VI_CSCCOEF1_9_reg                                             0xB80041BC
#define VI_CSCCOEF1_10_reg                                            0xB80041C0
#define VI_CSCCOEF1_11_reg                                            0xB80041C4
#define VI_CSCCOEF1_12_reg                                            0xB80041C8
#define VI_CSCCOEF1_13_reg                                            0xB80041CC
#define VI_CSCCOEF1_14_reg                                            0xB80041D0
#define VI_CSCCOEF1_15_reg                                            0xB80041D4
#define VI_CSCCOEF1_0_inst_addr                                       "0x0066"
#define VI_CSCCOEF1_0_inst                                            0x0066
#define VI_CSCCOEF1_1_inst_addr                                       "0x0067"
#define VI_CSCCOEF1_1_inst                                            0x0067
#define VI_CSCCOEF1_2_inst_addr                                       "0x0068"
#define VI_CSCCOEF1_2_inst                                            0x0068
#define VI_CSCCOEF1_3_inst_addr                                       "0x0069"
#define VI_CSCCOEF1_3_inst                                            0x0069
#define VI_CSCCOEF1_4_inst_addr                                       "0x006A"
#define VI_CSCCOEF1_4_inst                                            0x006A
#define VI_CSCCOEF1_5_inst_addr                                       "0x006B"
#define VI_CSCCOEF1_5_inst                                            0x006B
#define VI_CSCCOEF1_6_inst_addr                                       "0x006C"
#define VI_CSCCOEF1_6_inst                                            0x006C
#define VI_CSCCOEF1_7_inst_addr                                       "0x006D"
#define VI_CSCCOEF1_7_inst                                            0x006D
#define VI_CSCCOEF1_8_inst_addr                                       "0x006E"
#define VI_CSCCOEF1_8_inst                                            0x006E
#define VI_CSCCOEF1_9_inst_addr                                       "0x006F"
#define VI_CSCCOEF1_9_inst                                            0x006F
#define VI_CSCCOEF1_10_inst_addr                                      "0x0070"
#define VI_CSCCOEF1_10_inst                                           0x0070
#define VI_CSCCOEF1_11_inst_addr                                      "0x0071"
#define VI_CSCCOEF1_11_inst                                           0x0071
#define VI_CSCCOEF1_12_inst_addr                                      "0x0072"
#define VI_CSCCOEF1_12_inst                                           0x0072
#define VI_CSCCOEF1_13_inst_addr                                      "0x0073"
#define VI_CSCCOEF1_13_inst                                           0x0073
#define VI_CSCCOEF1_14_inst_addr                                      "0x0074"
#define VI_CSCCOEF1_14_inst                                           0x0074
#define VI_CSCCOEF1_15_inst_addr                                      "0x0075"
#define VI_CSCCOEF1_15_inst                                           0x0075
#define VI_CSCCOEF1_csccoef_shift                                     (0)
#define VI_CSCCOEF1_csccoef_mask                                      (0x00003FFF)
#define VI_CSCCOEF1_csccoef(data)                                     (0x00003FFF&(data))
#define VI_CSCCOEF1_get_csccoef(data)                                 (0x00003FFF&(data))

#define VI_CSCCOEF2_0                                                 0x180041D8
#define VI_CSCCOEF2_1                                                 0x180041DC
#define VI_CSCCOEF2_2                                                 0x180041E0
#define VI_CSCCOEF2_3                                                 0x180041E4
#define VI_CSCCOEF2_4                                                 0x180041E8
#define VI_CSCCOEF2_5                                                 0x180041EC
#define VI_CSCCOEF2_6                                                 0x180041F0
#define VI_CSCCOEF2_7                                                 0x180041F4
#define VI_CSCCOEF2_8                                                 0x180041F8
#define VI_CSCCOEF2_9                                                 0x180041FC
#define VI_CSCCOEF2_10                                                0x18004200
#define VI_CSCCOEF2_11                                                0x18004204
#define VI_CSCCOEF2_12                                                0x18004208
#define VI_CSCCOEF2_13                                                0x1800420C
#define VI_CSCCOEF2_14                                                0x18004210
#define VI_CSCCOEF2_15                                                0x18004214
#define VI_CSCCOEF2_0_reg_addr                                        "0xB80041D8"
#define VI_CSCCOEF2_1_reg_addr                                        "0xB80041DC"
#define VI_CSCCOEF2_2_reg_addr                                        "0xB80041E0"
#define VI_CSCCOEF2_3_reg_addr                                        "0xB80041E4"
#define VI_CSCCOEF2_4_reg_addr                                        "0xB80041E8"
#define VI_CSCCOEF2_5_reg_addr                                        "0xB80041EC"
#define VI_CSCCOEF2_6_reg_addr                                        "0xB80041F0"
#define VI_CSCCOEF2_7_reg_addr                                        "0xB80041F4"
#define VI_CSCCOEF2_8_reg_addr                                        "0xB80041F8"
#define VI_CSCCOEF2_9_reg_addr                                        "0xB80041FC"
#define VI_CSCCOEF2_10_reg_addr                                       "0xB8004200"
#define VI_CSCCOEF2_11_reg_addr                                       "0xB8004204"
#define VI_CSCCOEF2_12_reg_addr                                       "0xB8004208"
#define VI_CSCCOEF2_13_reg_addr                                       "0xB800420C"
#define VI_CSCCOEF2_14_reg_addr                                       "0xB8004210"
#define VI_CSCCOEF2_15_reg_addr                                       "0xB8004214"
#define VI_CSCCOEF2_0_reg                                             0xB80041D8
#define VI_CSCCOEF2_1_reg                                             0xB80041DC
#define VI_CSCCOEF2_2_reg                                             0xB80041E0
#define VI_CSCCOEF2_3_reg                                             0xB80041E4
#define VI_CSCCOEF2_4_reg                                             0xB80041E8
#define VI_CSCCOEF2_5_reg                                             0xB80041EC
#define VI_CSCCOEF2_6_reg                                             0xB80041F0
#define VI_CSCCOEF2_7_reg                                             0xB80041F4
#define VI_CSCCOEF2_8_reg                                             0xB80041F8
#define VI_CSCCOEF2_9_reg                                             0xB80041FC
#define VI_CSCCOEF2_10_reg                                            0xB8004200
#define VI_CSCCOEF2_11_reg                                            0xB8004204
#define VI_CSCCOEF2_12_reg                                            0xB8004208
#define VI_CSCCOEF2_13_reg                                            0xB800420C
#define VI_CSCCOEF2_14_reg                                            0xB8004210
#define VI_CSCCOEF2_15_reg                                            0xB8004214
#define VI_CSCCOEF2_0_inst_addr                                       "0x0076"
#define VI_CSCCOEF2_0_inst                                            0x0076
#define VI_CSCCOEF2_1_inst_addr                                       "0x0077"
#define VI_CSCCOEF2_1_inst                                            0x0077
#define VI_CSCCOEF2_2_inst_addr                                       "0x0078"
#define VI_CSCCOEF2_2_inst                                            0x0078
#define VI_CSCCOEF2_3_inst_addr                                       "0x0079"
#define VI_CSCCOEF2_3_inst                                            0x0079
#define VI_CSCCOEF2_4_inst_addr                                       "0x007A"
#define VI_CSCCOEF2_4_inst                                            0x007A
#define VI_CSCCOEF2_5_inst_addr                                       "0x007B"
#define VI_CSCCOEF2_5_inst                                            0x007B
#define VI_CSCCOEF2_6_inst_addr                                       "0x007C"
#define VI_CSCCOEF2_6_inst                                            0x007C
#define VI_CSCCOEF2_7_inst_addr                                       "0x007D"
#define VI_CSCCOEF2_7_inst                                            0x007D
#define VI_CSCCOEF2_8_inst_addr                                       "0x007E"
#define VI_CSCCOEF2_8_inst                                            0x007E
#define VI_CSCCOEF2_9_inst_addr                                       "0x007F"
#define VI_CSCCOEF2_9_inst                                            0x007F
#define VI_CSCCOEF2_10_inst_addr                                      "0x0080"
#define VI_CSCCOEF2_10_inst                                           0x0080
#define VI_CSCCOEF2_11_inst_addr                                      "0x0081"
#define VI_CSCCOEF2_11_inst                                           0x0081
#define VI_CSCCOEF2_12_inst_addr                                      "0x0082"
#define VI_CSCCOEF2_12_inst                                           0x0082
#define VI_CSCCOEF2_13_inst_addr                                      "0x0083"
#define VI_CSCCOEF2_13_inst                                           0x0083
#define VI_CSCCOEF2_14_inst_addr                                      "0x0084"
#define VI_CSCCOEF2_14_inst                                           0x0084
#define VI_CSCCOEF2_15_inst_addr                                      "0x0085"
#define VI_CSCCOEF2_15_inst                                           0x0085
#define VI_CSCCOEF2_csccoef_shift                                     (0)
#define VI_CSCCOEF2_csccoef_mask                                      (0x00003FFF)
#define VI_CSCCOEF2_csccoef(data)                                     (0x00003FFF&(data))
#define VI_CSCCOEF2_get_csccoef(data)                                 (0x00003FFF&(data))

#define VI_OFFSETEN                                                   0x18004218
#define VI_OFFSETEN_reg_addr                                          "0xB8004218"
#define VI_OFFSETEN_reg                                               0xB8004218
#define VI_OFFSETEN_inst_addr                                         "0x0086"
#define VI_OFFSETEN_inst                                              0x0086
#define VI_OFFSETEN_y1_clamp_shift                                    (8)
#define VI_OFFSETEN_c1_clamp_shift                                    (7)
#define VI_OFFSETEN_y2_clamp_shift                                    (6)
#define VI_OFFSETEN_c2_clamp_shift                                    (5)
#define VI_OFFSETEN_y1_shift                                          (4)
#define VI_OFFSETEN_c1_shift                                          (3)
#define VI_OFFSETEN_y2_shift                                          (2)
#define VI_OFFSETEN_c2_shift                                          (1)
#define VI_OFFSETEN_write_data_shift                                  (0)
#define VI_OFFSETEN_y1_clamp_mask                                     (0x00000100)
#define VI_OFFSETEN_c1_clamp_mask                                     (0x00000080)
#define VI_OFFSETEN_y2_clamp_mask                                     (0x00000040)
#define VI_OFFSETEN_c2_clamp_mask                                     (0x00000020)
#define VI_OFFSETEN_y1_mask                                           (0x00000010)
#define VI_OFFSETEN_c1_mask                                           (0x00000008)
#define VI_OFFSETEN_y2_mask                                           (0x00000004)
#define VI_OFFSETEN_c2_mask                                           (0x00000002)
#define VI_OFFSETEN_write_data_mask                                   (0x00000001)
#define VI_OFFSETEN_y1_clamp(data)                                    (0x00000100&((data)<<8))
#define VI_OFFSETEN_c1_clamp(data)                                    (0x00000080&((data)<<7))
#define VI_OFFSETEN_y2_clamp(data)                                    (0x00000040&((data)<<6))
#define VI_OFFSETEN_c2_clamp(data)                                    (0x00000020&((data)<<5))
#define VI_OFFSETEN_y1(data)                                          (0x00000010&((data)<<4))
#define VI_OFFSETEN_c1(data)                                          (0x00000008&((data)<<3))
#define VI_OFFSETEN_y2(data)                                          (0x00000004&((data)<<2))
#define VI_OFFSETEN_c2(data)                                          (0x00000002&((data)<<1))
#define VI_OFFSETEN_write_data(data)                                  (0x00000001&(data))
#define VI_OFFSETEN_get_y1_clamp(data)                                ((0x00000100&(data))>>8)
#define VI_OFFSETEN_get_c1_clamp(data)                                ((0x00000080&(data))>>7)
#define VI_OFFSETEN_get_y2_clamp(data)                                ((0x00000040&(data))>>6)
#define VI_OFFSETEN_get_c2_clamp(data)                                ((0x00000020&(data))>>5)
#define VI_OFFSETEN_get_y1(data)                                      ((0x00000010&(data))>>4)
#define VI_OFFSETEN_get_c1(data)                                      ((0x00000008&(data))>>3)
#define VI_OFFSETEN_get_y2(data)                                      ((0x00000004&(data))>>2)
#define VI_OFFSETEN_get_c2(data)                                      ((0x00000002&(data))>>1)
#define VI_OFFSETEN_get_write_data(data)                              (0x00000001&(data))

#define VI_HPD1                                                       0x1800421C
#define VI_HPD1_reg_addr                                              "0xB800421C"
#define VI_HPD1_reg                                                   0xB800421C
#define VI_HPD1_inst_addr                                             "0x0087"
#define VI_HPD1_inst                                                  0x0087
#define VI_HPD1_hpd_enable_shift                                      (31)
#define VI_HPD1_hpd_acc_shift                                         (0)
#define VI_HPD1_hpd_enable_mask                                       (0x80000000)
#define VI_HPD1_hpd_acc_mask                                          (0x7FFFFFFF)
#define VI_HPD1_hpd_enable(data)                                      (0x80000000&((data)<<31))
#define VI_HPD1_hpd_acc(data)                                         (0x7FFFFFFF&(data))
#define VI_HPD1_get_hpd_enable(data)                                  ((0x80000000&(data))>>31)
#define VI_HPD1_get_hpd_acc(data)                                     (0x7FFFFFFF&(data))

#define VI_HPD2                                                       0x18004220
#define VI_HPD2_reg_addr                                              "0xB8004220"
#define VI_HPD2_reg                                                   0xB8004220
#define VI_HPD2_inst_addr                                             "0x0088"
#define VI_HPD2_inst                                                  0x0088
#define VI_HPD2_hpd_enable_shift                                      (31)
#define VI_HPD2_hpd_acc_shift                                         (0)
#define VI_HPD2_hpd_enable_mask                                       (0x80000000)
#define VI_HPD2_hpd_acc_mask                                          (0x7FFFFFFF)
#define VI_HPD2_hpd_enable(data)                                      (0x80000000&((data)<<31))
#define VI_HPD2_hpd_acc(data)                                         (0x7FFFFFFF&(data))
#define VI_HPD2_get_hpd_enable(data)                                  ((0x80000000&(data))>>31)
#define VI_HPD2_get_hpd_acc(data)                                     (0x7FFFFFFF&(data))

#define VI_CVDEN                                                      0x18004224
#define VI_CVDEN_reg_addr                                             "0xB8004224"
#define VI_CVDEN_reg                                                  0xB8004224
#define VI_CVDEN_inst_addr                                            "0x0089"
#define VI_CVDEN_inst                                                 0x0089
#define VI_CVDEN_write_enable1_shift                                  (9)
#define VI_CVDEN_cvden1_shift                                         (8)
#define VI_CVDEN_write_enable2_shift                                  (7)
#define VI_CVDEN_cvdtp1_shift                                         (5)
#define VI_CVDEN_write_enable3_shift                                  (4)
#define VI_CVDEN_cvden2_shift                                         (3)
#define VI_CVDEN_write_enable4_shift                                  (2)
#define VI_CVDEN_cvdtp2_shift                                         (0)
#define VI_CVDEN_write_enable1_mask                                   (0x00000200)
#define VI_CVDEN_cvden1_mask                                          (0x00000100)
#define VI_CVDEN_write_enable2_mask                                   (0x00000080)
#define VI_CVDEN_cvdtp1_mask                                          (0x00000060)
#define VI_CVDEN_write_enable3_mask                                   (0x00000010)
#define VI_CVDEN_cvden2_mask                                          (0x00000008)
#define VI_CVDEN_write_enable4_mask                                   (0x00000004)
#define VI_CVDEN_cvdtp2_mask                                          (0x00000003)
#define VI_CVDEN_write_enable1(data)                                  (0x00000200&((data)<<9))
#define VI_CVDEN_cvden1(data)                                         (0x00000100&((data)<<8))
#define VI_CVDEN_write_enable2(data)                                  (0x00000080&((data)<<7))
#define VI_CVDEN_cvdtp1(data)                                         (0x00000060&((data)<<5))
#define VI_CVDEN_write_enable3(data)                                  (0x00000010&((data)<<4))
#define VI_CVDEN_cvden2(data)                                         (0x00000008&((data)<<3))
#define VI_CVDEN_write_enable4(data)                                  (0x00000004&((data)<<2))
#define VI_CVDEN_cvdtp2(data)                                         (0x00000003&(data))
#define VI_CVDEN_get_write_enable1(data)                              ((0x00000200&(data))>>9)
#define VI_CVDEN_get_cvden1(data)                                     ((0x00000100&(data))>>8)
#define VI_CVDEN_get_write_enable2(data)                              ((0x00000080&(data))>>7)
#define VI_CVDEN_get_cvdtp1(data)                                     ((0x00000060&(data))>>5)
#define VI_CVDEN_get_write_enable3(data)                              ((0x00000010&(data))>>4)
#define VI_CVDEN_get_cvden2(data)                                     ((0x00000008&(data))>>3)
#define VI_CVDEN_get_write_enable4(data)                              ((0x00000004&(data))>>2)
#define VI_CVDEN_get_cvdtp2(data)                                     (0x00000003&(data))

#define VI_YDCTL                                                      0x18004228
#define VI_YDCTL_reg_addr                                             "0xB8004228"
#define VI_YDCTL_reg                                                  0xB8004228
#define VI_YDCTL_inst_addr                                            "0x008A"
#define VI_YDCTL_inst                                                 0x008A
#define VI_YDCTL_write_enable1_shift                                  (6)
#define VI_YDCTL_yden_shift                                           (5)
#define VI_YDCTL_write_enable2_shift                                  (4)
#define VI_YDCTL_ydsrc_shift                                          (3)
#define VI_YDCTL_write_enable3_shift                                  (2)
#define VI_YDCTL_ydrtio_shift                                         (0)
#define VI_YDCTL_write_enable1_mask                                   (0x00000040)
#define VI_YDCTL_yden_mask                                            (0x00000020)
#define VI_YDCTL_write_enable2_mask                                   (0x00000010)
#define VI_YDCTL_ydsrc_mask                                           (0x00000008)
#define VI_YDCTL_write_enable3_mask                                   (0x00000004)
#define VI_YDCTL_ydrtio_mask                                          (0x00000003)
#define VI_YDCTL_write_enable1(data)                                  (0x00000040&((data)<<6))
#define VI_YDCTL_yden(data)                                           (0x00000020&((data)<<5))
#define VI_YDCTL_write_enable2(data)                                  (0x00000010&((data)<<4))
#define VI_YDCTL_ydsrc(data)                                          (0x00000008&((data)<<3))
#define VI_YDCTL_write_enable3(data)                                  (0x00000004&((data)<<2))
#define VI_YDCTL_ydrtio(data)                                         (0x00000003&(data))
#define VI_YDCTL_get_write_enable1(data)                              ((0x00000040&(data))>>6)
#define VI_YDCTL_get_yden(data)                                       ((0x00000020&(data))>>5)
#define VI_YDCTL_get_write_enable2(data)                              ((0x00000010&(data))>>4)
#define VI_YDCTL_get_ydsrc(data)                                      ((0x00000008&(data))>>3)
#define VI_YDCTL_get_write_enable3(data)                              ((0x00000004&(data))>>2)
#define VI_YDCTL_get_ydrtio(data)                                     (0x00000003&(data))

#define VI_DMACTL                                                     0x1800422C
#define VI_DMACTL_reg_addr                                            "0xB800422C"
#define VI_DMACTL_reg                                                 0xB800422C
#define VI_DMACTL_inst_addr                                           "0x008B"
#define VI_DMACTL_inst                                                0x008B
#define VI_DMACTL_write_enable1_shift                                 (7)
#define VI_DMACTL_dmaen1_shift                                        (6)
#define VI_DMACTL_write_enable2_shift                                 (5)
#define VI_DMACTL_dmaen2_shift                                        (4)
#define VI_DMACTL_write_enable3_shift                                 (3)
#define VI_DMACTL_bstlen_shift                                        (0)
#define VI_DMACTL_write_enable1_mask                                  (0x00000080)
#define VI_DMACTL_dmaen1_mask                                         (0x00000040)
#define VI_DMACTL_write_enable2_mask                                  (0x00000020)
#define VI_DMACTL_dmaen2_mask                                         (0x00000010)
#define VI_DMACTL_write_enable3_mask                                  (0x00000008)
#define VI_DMACTL_bstlen_mask                                         (0x00000007)
#define VI_DMACTL_write_enable1(data)                                 (0x00000080&((data)<<7))
#define VI_DMACTL_dmaen1(data)                                        (0x00000040&((data)<<6))
#define VI_DMACTL_write_enable2(data)                                 (0x00000020&((data)<<5))
#define VI_DMACTL_dmaen2(data)                                        (0x00000010&((data)<<4))
#define VI_DMACTL_write_enable3(data)                                 (0x00000008&((data)<<3))
#define VI_DMACTL_bstlen(data)                                        (0x00000007&(data))
#define VI_DMACTL_get_write_enable1(data)                             ((0x00000080&(data))>>7)
#define VI_DMACTL_get_dmaen1(data)                                    ((0x00000040&(data))>>6)
#define VI_DMACTL_get_write_enable2(data)                             ((0x00000020&(data))>>5)
#define VI_DMACTL_get_dmaen2(data)                                    ((0x00000010&(data))>>4)
#define VI_DMACTL_get_write_enable3(data)                             ((0x00000008&(data))>>3)
#define VI_DMACTL_get_bstlen(data)                                    (0x00000007&(data))

#define VI_Y1BUF                                                      0x18004230
#define VI_Y1BUF_reg_addr                                             "0xB8004230"
#define VI_Y1BUF_reg                                                  0xB8004230
#define VI_Y1BUF_inst_addr                                            "0x008C"
#define VI_Y1BUF_inst                                                 0x008C
#define VI_Y1BUF_write_enable1_shift                                  (16)
#define VI_Y1BUF_thd_shift                                            (10)
#define VI_Y1BUF_write_enable2_shift                                  (9)
#define VI_Y1BUF_end_shift                                            (0)
#define VI_Y1BUF_write_enable1_mask                                   (0x00010000)
#define VI_Y1BUF_thd_mask                                             (0x0000FC00)
#define VI_Y1BUF_write_enable2_mask                                   (0x00000200)
#define VI_Y1BUF_end_mask                                             (0x000001FF)
#define VI_Y1BUF_write_enable1(data)                                  (0x00010000&((data)<<16))
#define VI_Y1BUF_thd(data)                                            (0x0000FC00&((data)<<10))
#define VI_Y1BUF_write_enable2(data)                                  (0x00000200&((data)<<9))
#define VI_Y1BUF_end(data)                                            (0x000001FF&(data))
#define VI_Y1BUF_get_write_enable1(data)                              ((0x00010000&(data))>>16)
#define VI_Y1BUF_get_thd(data)                                        ((0x0000FC00&(data))>>10)
#define VI_Y1BUF_get_write_enable2(data)                              ((0x00000200&(data))>>9)
#define VI_Y1BUF_get_end(data)                                        (0x000001FF&(data))

#define VI_Y2BUF                                                      0x18004234
#define VI_Y2BUF_reg_addr                                             "0xB8004234"
#define VI_Y2BUF_reg                                                  0xB8004234
#define VI_Y2BUF_inst_addr                                            "0x008D"
#define VI_Y2BUF_inst                                                 0x008D
#define VI_Y2BUF_write_enable1_shift                                  (26)
#define VI_Y2BUF_thd_shift                                            (20)
#define VI_Y2BUF_write_enable2_shift                                  (19)
#define VI_Y2BUF_start_shift                                          (10)
#define VI_Y2BUF_write_enable3_shift                                  (9)
#define VI_Y2BUF_end_shift                                            (0)
#define VI_Y2BUF_write_enable1_mask                                   (0x04000000)
#define VI_Y2BUF_thd_mask                                             (0x03F00000)
#define VI_Y2BUF_write_enable2_mask                                   (0x00080000)
#define VI_Y2BUF_start_mask                                           (0x0007FC00)
#define VI_Y2BUF_write_enable3_mask                                   (0x00000200)
#define VI_Y2BUF_end_mask                                             (0x000001FF)
#define VI_Y2BUF_write_enable1(data)                                  (0x04000000&((data)<<26))
#define VI_Y2BUF_thd(data)                                            (0x03F00000&((data)<<20))
#define VI_Y2BUF_write_enable2(data)                                  (0x00080000&((data)<<19))
#define VI_Y2BUF_start(data)                                          (0x0007FC00&((data)<<10))
#define VI_Y2BUF_write_enable3(data)                                  (0x00000200&((data)<<9))
#define VI_Y2BUF_end(data)                                            (0x000001FF&(data))
#define VI_Y2BUF_get_write_enable1(data)                              ((0x04000000&(data))>>26)
#define VI_Y2BUF_get_thd(data)                                        ((0x03F00000&(data))>>20)
#define VI_Y2BUF_get_write_enable2(data)                              ((0x00080000&(data))>>19)
#define VI_Y2BUF_get_start(data)                                      ((0x0007FC00&(data))>>10)
#define VI_Y2BUF_get_write_enable3(data)                              ((0x00000200&(data))>>9)
#define VI_Y2BUF_get_end(data)                                        (0x000001FF&(data))

#define VI_C1BUF                                                      0x18004238
#define VI_C1BUF_reg_addr                                             "0xB8004238"
#define VI_C1BUF_reg                                                  0xB8004238
#define VI_C1BUF_inst_addr                                            "0x008E"
#define VI_C1BUF_inst                                                 0x008E
#define VI_C1BUF_write_enable1_shift                                  (26)
#define VI_C1BUF_thd_shift                                            (20)
#define VI_C1BUF_write_enable2_shift                                  (19)
#define VI_C1BUF_start_shift                                          (10)
#define VI_C1BUF_write_enable3_shift                                  (9)
#define VI_C1BUF_end_shift                                            (0)
#define VI_C1BUF_write_enable1_mask                                   (0x04000000)
#define VI_C1BUF_thd_mask                                             (0x03F00000)
#define VI_C1BUF_write_enable2_mask                                   (0x00080000)
#define VI_C1BUF_start_mask                                           (0x0007FC00)
#define VI_C1BUF_write_enable3_mask                                   (0x00000200)
#define VI_C1BUF_end_mask                                             (0x000001FF)
#define VI_C1BUF_write_enable1(data)                                  (0x04000000&((data)<<26))
#define VI_C1BUF_thd(data)                                            (0x03F00000&((data)<<20))
#define VI_C1BUF_write_enable2(data)                                  (0x00080000&((data)<<19))
#define VI_C1BUF_start(data)                                          (0x0007FC00&((data)<<10))
#define VI_C1BUF_write_enable3(data)                                  (0x00000200&((data)<<9))
#define VI_C1BUF_end(data)                                            (0x000001FF&(data))
#define VI_C1BUF_get_write_enable1(data)                              ((0x04000000&(data))>>26)
#define VI_C1BUF_get_thd(data)                                        ((0x03F00000&(data))>>20)
#define VI_C1BUF_get_write_enable2(data)                              ((0x00080000&(data))>>19)
#define VI_C1BUF_get_start(data)                                      ((0x0007FC00&(data))>>10)
#define VI_C1BUF_get_write_enable3(data)                              ((0x00000200&(data))>>9)
#define VI_C1BUF_get_end(data)                                        (0x000001FF&(data))

#define VI_C2BUF                                                      0x1800423C
#define VI_C2BUF_reg_addr                                             "0xB800423C"
#define VI_C2BUF_reg                                                  0xB800423C
#define VI_C2BUF_inst_addr                                            "0x008F"
#define VI_C2BUF_inst                                                 0x008F
#define VI_C2BUF_write_enable1_shift                                  (26)
#define VI_C2BUF_thd_shift                                            (20)
#define VI_C2BUF_write_enable2_shift                                  (19)
#define VI_C2BUF_start_shift                                          (10)
#define VI_C2BUF_write_enable3_shift                                  (9)
#define VI_C2BUF_end_shift                                            (0)
#define VI_C2BUF_write_enable1_mask                                   (0x04000000)
#define VI_C2BUF_thd_mask                                             (0x03F00000)
#define VI_C2BUF_write_enable2_mask                                   (0x00080000)
#define VI_C2BUF_start_mask                                           (0x0007FC00)
#define VI_C2BUF_write_enable3_mask                                   (0x00000200)
#define VI_C2BUF_end_mask                                             (0x000001FF)
#define VI_C2BUF_write_enable1(data)                                  (0x04000000&((data)<<26))
#define VI_C2BUF_thd(data)                                            (0x03F00000&((data)<<20))
#define VI_C2BUF_write_enable2(data)                                  (0x00080000&((data)<<19))
#define VI_C2BUF_start(data)                                          (0x0007FC00&((data)<<10))
#define VI_C2BUF_write_enable3(data)                                  (0x00000200&((data)<<9))
#define VI_C2BUF_end(data)                                            (0x000001FF&(data))
#define VI_C2BUF_get_write_enable1(data)                              ((0x04000000&(data))>>26)
#define VI_C2BUF_get_thd(data)                                        ((0x03F00000&(data))>>20)
#define VI_C2BUF_get_write_enable2(data)                              ((0x00080000&(data))>>19)
#define VI_C2BUF_get_start(data)                                      ((0x0007FC00&(data))>>10)
#define VI_C2BUF_get_write_enable3(data)                              ((0x00000200&(data))>>9)
#define VI_C2BUF_get_end(data)                                        (0x000001FF&(data))

#define VI_YDBUF                                                      0x18004240
#define VI_YDBUF_reg_addr                                             "0xB8004240"
#define VI_YDBUF_reg                                                  0xB8004240
#define VI_YDBUF_inst_addr                                            "0x0090"
#define VI_YDBUF_inst                                                 0x0090
#define VI_YDBUF_write_enable1_shift                                  (26)
#define VI_YDBUF_thd_shift                                            (20)
#define VI_YDBUF_write_enable2_shift                                  (19)
#define VI_YDBUF_start_shift                                          (10)
#define VI_YDBUF_write_enable3_shift                                  (9)
#define VI_YDBUF_end_shift                                            (0)
#define VI_YDBUF_write_enable1_mask                                   (0x04000000)
#define VI_YDBUF_thd_mask                                             (0x03F00000)
#define VI_YDBUF_write_enable2_mask                                   (0x00080000)
#define VI_YDBUF_start_mask                                           (0x0007FC00)
#define VI_YDBUF_write_enable3_mask                                   (0x00000200)
#define VI_YDBUF_end_mask                                             (0x000001FF)
#define VI_YDBUF_write_enable1(data)                                  (0x04000000&((data)<<26))
#define VI_YDBUF_thd(data)                                            (0x03F00000&((data)<<20))
#define VI_YDBUF_write_enable2(data)                                  (0x00080000&((data)<<19))
#define VI_YDBUF_start(data)                                          (0x0007FC00&((data)<<10))
#define VI_YDBUF_write_enable3(data)                                  (0x00000200&((data)<<9))
#define VI_YDBUF_end(data)                                            (0x000001FF&(data))
#define VI_YDBUF_get_write_enable1(data)                              ((0x04000000&(data))>>26)
#define VI_YDBUF_get_thd(data)                                        ((0x03F00000&(data))>>20)
#define VI_YDBUF_get_write_enable2(data)                              ((0x00080000&(data))>>19)
#define VI_YDBUF_get_start(data)                                      ((0x0007FC00&(data))>>10)
#define VI_YDBUF_get_write_enable3(data)                              ((0x00000200&(data))>>9)
#define VI_YDBUF_get_end(data)                                        (0x000001FF&(data))

#define VI_YDINBUF                                                    0x18004244
#define VI_YDINBUF_reg_addr                                           "0xB8004244"
#define VI_YDINBUF_reg                                                0xB8004244
#define VI_YDINBUF_inst_addr                                          "0x0091"
#define VI_YDINBUF_inst                                               0x0091
#define VI_YDINBUF_write_enable1_shift                                (14)
#define VI_YDINBUF_thd_shift                                          (8)
#define VI_YDINBUF_write_enable2_shift                                (7)
#define VI_YDINBUF_end_shift                                          (0)
#define VI_YDINBUF_write_enable1_mask                                 (0x00004000)
#define VI_YDINBUF_thd_mask                                           (0x00003F00)
#define VI_YDINBUF_write_enable2_mask                                 (0x00000080)
#define VI_YDINBUF_end_mask                                           (0x0000007F)
#define VI_YDINBUF_write_enable1(data)                                (0x00004000&((data)<<14))
#define VI_YDINBUF_thd(data)                                          (0x00003F00&((data)<<8))
#define VI_YDINBUF_write_enable2(data)                                (0x00000080&((data)<<7))
#define VI_YDINBUF_end(data)                                          (0x0000007F&(data))
#define VI_YDINBUF_get_write_enable1(data)                            ((0x00004000&(data))>>14)
#define VI_YDINBUF_get_thd(data)                                      ((0x00003F00&(data))>>8)
#define VI_YDINBUF_get_write_enable2(data)                            ((0x00000080&(data))>>7)
#define VI_YDINBUF_get_end(data)                                      (0x0000007F&(data))

#define VI_CDINBUF                                                    0x18004248
#define VI_CDINBUF_reg_addr                                           "0xB8004248"
#define VI_CDINBUF_reg                                                0xB8004248
#define VI_CDINBUF_inst_addr                                          "0x0092"
#define VI_CDINBUF_inst                                               0x0092
#define VI_CDINBUF_write_enable1_shift                                (22)
#define VI_CDINBUF_thd_shift                                          (16)
#define VI_CDINBUF_write_enable2_shift                                (15)
#define VI_CDINBUF_start_shift                                        (8)
#define VI_CDINBUF_write_enable3_shift                                (7)
#define VI_CDINBUF_end_shift                                          (0)
#define VI_CDINBUF_write_enable1_mask                                 (0x00400000)
#define VI_CDINBUF_thd_mask                                           (0x003F0000)
#define VI_CDINBUF_write_enable2_mask                                 (0x00008000)
#define VI_CDINBUF_start_mask                                         (0x00007F00)
#define VI_CDINBUF_write_enable3_mask                                 (0x00000080)
#define VI_CDINBUF_end_mask                                           (0x0000007F)
#define VI_CDINBUF_write_enable1(data)                                (0x00400000&((data)<<22))
#define VI_CDINBUF_thd(data)                                          (0x003F0000&((data)<<16))
#define VI_CDINBUF_write_enable2(data)                                (0x00008000&((data)<<15))
#define VI_CDINBUF_start(data)                                        (0x00007F00&((data)<<8))
#define VI_CDINBUF_write_enable3(data)                                (0x00000080&((data)<<7))
#define VI_CDINBUF_end(data)                                          (0x0000007F&(data))
#define VI_CDINBUF_get_write_enable1(data)                            ((0x00400000&(data))>>22)
#define VI_CDINBUF_get_thd(data)                                      ((0x003F0000&(data))>>16)
#define VI_CDINBUF_get_write_enable2(data)                            ((0x00008000&(data))>>15)
#define VI_CDINBUF_get_start(data)                                    ((0x00007F00&(data))>>8)
#define VI_CDINBUF_get_write_enable3(data)                            ((0x00000080&(data))>>7)
#define VI_CDINBUF_get_end(data)                                      (0x0000007F&(data))

#define VI_DMACTL1                                                    0x1800424C
#define VI_DMACTL1_reg_addr                                           "0xB800424C"
#define VI_DMACTL1_reg                                                0xB800424C
#define VI_DMACTL1_inst_addr                                          "0x0093"
#define VI_DMACTL1_inst                                               0x0093
#define VI_DMACTL1_write_enable1_shift                                (20)
#define VI_DMACTL1_vbiads_shift                                       (14)
#define VI_DMACTL1_write_enable2_shift                                (13)
#define VI_DMACTL1_yads_shift                                         (7)
#define VI_DMACTL1_write_enable3_shift                                (6)
#define VI_DMACTL1_cads_shift                                         (0)
#define VI_DMACTL1_write_enable1_mask                                 (0x00100000)
#define VI_DMACTL1_vbiads_mask                                        (0x000FC000)
#define VI_DMACTL1_write_enable2_mask                                 (0x00002000)
#define VI_DMACTL1_yads_mask                                          (0x00001F80)
#define VI_DMACTL1_write_enable3_mask                                 (0x00000040)
#define VI_DMACTL1_cads_mask                                          (0x0000003F)
#define VI_DMACTL1_write_enable1(data)                                (0x00100000&((data)<<20))
#define VI_DMACTL1_vbiads(data)                                       (0x000FC000&((data)<<14))
#define VI_DMACTL1_write_enable2(data)                                (0x00002000&((data)<<13))
#define VI_DMACTL1_yads(data)                                         (0x00001F80&((data)<<7))
#define VI_DMACTL1_write_enable3(data)                                (0x00000040&((data)<<6))
#define VI_DMACTL1_cads(data)                                         (0x0000003F&(data))
#define VI_DMACTL1_get_write_enable1(data)                            ((0x00100000&(data))>>20)
#define VI_DMACTL1_get_vbiads(data)                                   ((0x000FC000&(data))>>14)
#define VI_DMACTL1_get_write_enable2(data)                            ((0x00002000&(data))>>13)
#define VI_DMACTL1_get_yads(data)                                     ((0x00001F80&(data))>>7)
#define VI_DMACTL1_get_write_enable3(data)                            ((0x00000040&(data))>>6)
#define VI_DMACTL1_get_cads(data)                                     (0x0000003F&(data))

#define VI_DMACTL2                                                    0x18004250
#define VI_DMACTL2_reg_addr                                           "0xB8004250"
#define VI_DMACTL2_reg                                                0xB8004250
#define VI_DMACTL2_inst_addr                                          "0x0094"
#define VI_DMACTL2_inst                                               0x0094
#define VI_DMACTL2_write_enable1_shift                                (20)
#define VI_DMACTL2_vbiads_shift                                       (14)
#define VI_DMACTL2_write_enable2_shift                                (13)
#define VI_DMACTL2_yads_shift                                         (7)
#define VI_DMACTL2_write_enable3_shift                                (6)
#define VI_DMACTL2_cads_shift                                         (0)
#define VI_DMACTL2_write_enable1_mask                                 (0x00100000)
#define VI_DMACTL2_vbiads_mask                                        (0x000FC000)
#define VI_DMACTL2_write_enable2_mask                                 (0x00002000)
#define VI_DMACTL2_yads_mask                                          (0x00001F80)
#define VI_DMACTL2_write_enable3_mask                                 (0x00000040)
#define VI_DMACTL2_cads_mask                                          (0x0000003F)
#define VI_DMACTL2_write_enable1(data)                                (0x00100000&((data)<<20))
#define VI_DMACTL2_vbiads(data)                                       (0x000FC000&((data)<<14))
#define VI_DMACTL2_write_enable2(data)                                (0x00002000&((data)<<13))
#define VI_DMACTL2_yads(data)                                         (0x00001F80&((data)<<7))
#define VI_DMACTL2_write_enable3(data)                                (0x00000040&((data)<<6))
#define VI_DMACTL2_cads(data)                                         (0x0000003F&(data))
#define VI_DMACTL2_get_write_enable1(data)                            ((0x00100000&(data))>>20)
#define VI_DMACTL2_get_vbiads(data)                                   ((0x000FC000&(data))>>14)
#define VI_DMACTL2_get_write_enable2(data)                            ((0x00002000&(data))>>13)
#define VI_DMACTL2_get_yads(data)                                     ((0x00001F80&(data))>>7)
#define VI_DMACTL2_get_write_enable3(data)                            ((0x00000040&(data))>>6)
#define VI_DMACTL2_get_cads(data)                                     (0x0000003F&(data))

#define VI_DYDMACTL                                                   0x18004254
#define VI_DYDMACTL_reg_addr                                          "0xB8004254"
#define VI_DYDMACTL_reg                                               0xB8004254
#define VI_DYDMACTL_inst_addr                                         "0x0095"
#define VI_DYDMACTL_inst                                              0x0095
#define VI_DYDMACTL_dyads_shift                                       (0)
#define VI_DYDMACTL_dyads_mask                                        (0x0000003F)
#define VI_DYDMACTL_dyads(data)                                       (0x0000003F&(data))
#define VI_DYDMACTL_get_dyads(data)                                   (0x0000003F&(data))

#define VI_DINDMACTL                                                  0x18004258
#define VI_DINDMACTL_reg_addr                                         "0xB8004258"
#define VI_DINDMACTL_reg                                              0xB8004258
#define VI_DINDMACTL_inst_addr                                        "0x0096"
#define VI_DINDMACTL_inst                                             0x0096
#define VI_DINDMACTL_write_enable1_shift                              (13)
#define VI_DINDMACTL_yads_shift                                       (7)
#define VI_DINDMACTL_write_enable2_shift                              (6)
#define VI_DINDMACTL_cads_shift                                       (0)
#define VI_DINDMACTL_write_enable1_mask                               (0x00002000)
#define VI_DINDMACTL_yads_mask                                        (0x00001F80)
#define VI_DINDMACTL_write_enable2_mask                               (0x00000040)
#define VI_DINDMACTL_cads_mask                                        (0x0000003F)
#define VI_DINDMACTL_write_enable1(data)                              (0x00002000&((data)<<13))
#define VI_DINDMACTL_yads(data)                                       (0x00001F80&((data)<<7))
#define VI_DINDMACTL_write_enable2(data)                              (0x00000040&((data)<<6))
#define VI_DINDMACTL_cads(data)                                       (0x0000003F&(data))
#define VI_DINDMACTL_get_write_enable1(data)                          ((0x00002000&(data))>>13)
#define VI_DINDMACTL_get_yads(data)                                   ((0x00001F80&(data))>>7)
#define VI_DINDMACTL_get_write_enable2(data)                          ((0x00000040&(data))>>6)
#define VI_DINDMACTL_get_cads(data)                                   (0x0000003F&(data))

#define VI_IMMODE                                                     0x1800425C
#define VI_IMMODE_reg_addr                                            "0xB800425C"
#define VI_IMMODE_reg                                                 0xB800425C
#define VI_IMMODE_inst_addr                                           "0x0097"
#define VI_IMMODE_inst                                                0x0097
#define VI_IMMODE_v1_odd_shift                                        (8)
#define VI_IMMODE_v1_interleave_shift                                 (7)
#define VI_IMMODE_v2_odd_shift                                        (6)
#define VI_IMMODE_v2_interleave_shift                                 (5)
#define VI_IMMODE_dy_odd_shift                                        (4)
#define VI_IMMODE_dy_interleave_shift                                 (3)
#define VI_IMMODE_din_odd_shift                                       (2)
#define VI_IMMODE_din_interleave_shift                                (1)
#define VI_IMMODE_write_data_shift                                    (0)
#define VI_IMMODE_v1_odd_mask                                         (0x00000100)
#define VI_IMMODE_v1_interleave_mask                                  (0x00000080)
#define VI_IMMODE_v2_odd_mask                                         (0x00000040)
#define VI_IMMODE_v2_interleave_mask                                  (0x00000020)
#define VI_IMMODE_dy_odd_mask                                         (0x00000010)
#define VI_IMMODE_dy_interleave_mask                                  (0x00000008)
#define VI_IMMODE_din_odd_mask                                        (0x00000004)
#define VI_IMMODE_din_interleave_mask                                 (0x00000002)
#define VI_IMMODE_write_data_mask                                     (0x00000001)
#define VI_IMMODE_v1_odd(data)                                        (0x00000100&((data)<<8))
#define VI_IMMODE_v1_interleave(data)                                 (0x00000080&((data)<<7))
#define VI_IMMODE_v2_odd(data)                                        (0x00000040&((data)<<6))
#define VI_IMMODE_v2_interleave(data)                                 (0x00000020&((data)<<5))
#define VI_IMMODE_dy_odd(data)                                        (0x00000010&((data)<<4))
#define VI_IMMODE_dy_interleave(data)                                 (0x00000008&((data)<<3))
#define VI_IMMODE_din_odd(data)                                       (0x00000004&((data)<<2))
#define VI_IMMODE_din_interleave(data)                                (0x00000002&((data)<<1))
#define VI_IMMODE_write_data(data)                                    (0x00000001&(data))
#define VI_IMMODE_get_v1_odd(data)                                    ((0x00000100&(data))>>8)
#define VI_IMMODE_get_v1_interleave(data)                             ((0x00000080&(data))>>7)
#define VI_IMMODE_get_v2_odd(data)                                    ((0x00000040&(data))>>6)
#define VI_IMMODE_get_v2_interleave(data)                             ((0x00000020&(data))>>5)
#define VI_IMMODE_get_dy_odd(data)                                    ((0x00000010&(data))>>4)
#define VI_IMMODE_get_dy_interleave(data)                             ((0x00000008&(data))>>3)
#define VI_IMMODE_get_din_odd(data)                                   ((0x00000004&(data))>>2)
#define VI_IMMODE_get_din_interleave(data)                            ((0x00000002&(data))>>1)
#define VI_IMMODE_get_write_data(data)                                (0x00000001&(data))

#define VI_DMA_MIN_TIME                                               0x18004260
#define VI_DMA_MIN_TIME_reg_addr                                      "0xB8004260"
#define VI_DMA_MIN_TIME_reg                                           0xB8004260
#define VI_DMA_MIN_TIME_inst_addr                                     "0x0098"
#define VI_DMA_MIN_TIME_inst                                          0x0098
#define VI_DMA_MIN_TIME_write_enable1_shift                           (29)
#define VI_DMA_MIN_TIME_y1c1_shift                                    (25)
#define VI_DMA_MIN_TIME_write_enable2_shift                           (24)
#define VI_DMA_MIN_TIME_y2c2_shift                                    (20)
#define VI_DMA_MIN_TIME_write_enable3_shift                           (19)
#define VI_DMA_MIN_TIME_vbi1_shift                                    (15)
#define VI_DMA_MIN_TIME_write_enable4_shift                           (14)
#define VI_DMA_MIN_TIME_vbi2_shift                                    (10)
#define VI_DMA_MIN_TIME_write_enable5_shift                           (9)
#define VI_DMA_MIN_TIME_dy_shift                                      (5)
#define VI_DMA_MIN_TIME_write_enable6_shift                           (4)
#define VI_DMA_MIN_TIME_din_shift                                     (0)
#define VI_DMA_MIN_TIME_write_enable1_mask                            (0x20000000)
#define VI_DMA_MIN_TIME_y1c1_mask                                     (0x1E000000)
#define VI_DMA_MIN_TIME_write_enable2_mask                            (0x01000000)
#define VI_DMA_MIN_TIME_y2c2_mask                                     (0x00F00000)
#define VI_DMA_MIN_TIME_write_enable3_mask                            (0x00080000)
#define VI_DMA_MIN_TIME_vbi1_mask                                     (0x00078000)
#define VI_DMA_MIN_TIME_write_enable4_mask                            (0x00004000)
#define VI_DMA_MIN_TIME_vbi2_mask                                     (0x00003C00)
#define VI_DMA_MIN_TIME_write_enable5_mask                            (0x00000200)
#define VI_DMA_MIN_TIME_dy_mask                                       (0x000001E0)
#define VI_DMA_MIN_TIME_write_enable6_mask                            (0x00000010)
#define VI_DMA_MIN_TIME_din_mask                                      (0x0000000F)
#define VI_DMA_MIN_TIME_write_enable1(data)                           (0x20000000&((data)<<29))
#define VI_DMA_MIN_TIME_y1c1(data)                                    (0x1E000000&((data)<<25))
#define VI_DMA_MIN_TIME_write_enable2(data)                           (0x01000000&((data)<<24))
#define VI_DMA_MIN_TIME_y2c2(data)                                    (0x00F00000&((data)<<20))
#define VI_DMA_MIN_TIME_write_enable3(data)                           (0x00080000&((data)<<19))
#define VI_DMA_MIN_TIME_vbi1(data)                                    (0x00078000&((data)<<15))
#define VI_DMA_MIN_TIME_write_enable4(data)                           (0x00004000&((data)<<14))
#define VI_DMA_MIN_TIME_vbi2(data)                                    (0x00003C00&((data)<<10))
#define VI_DMA_MIN_TIME_write_enable5(data)                           (0x00000200&((data)<<9))
#define VI_DMA_MIN_TIME_dy(data)                                      (0x000001E0&((data)<<5))
#define VI_DMA_MIN_TIME_write_enable6(data)                           (0x00000010&((data)<<4))
#define VI_DMA_MIN_TIME_din(data)                                     (0x0000000F&(data))
#define VI_DMA_MIN_TIME_get_write_enable1(data)                       ((0x20000000&(data))>>29)
#define VI_DMA_MIN_TIME_get_y1c1(data)                                ((0x1E000000&(data))>>25)
#define VI_DMA_MIN_TIME_get_write_enable2(data)                       ((0x01000000&(data))>>24)
#define VI_DMA_MIN_TIME_get_y2c2(data)                                ((0x00F00000&(data))>>20)
#define VI_DMA_MIN_TIME_get_write_enable3(data)                       ((0x00080000&(data))>>19)
#define VI_DMA_MIN_TIME_get_vbi1(data)                                ((0x00078000&(data))>>15)
#define VI_DMA_MIN_TIME_get_write_enable4(data)                       ((0x00004000&(data))>>14)
#define VI_DMA_MIN_TIME_get_vbi2(data)                                ((0x00003C00&(data))>>10)
#define VI_DMA_MIN_TIME_get_write_enable5(data)                       ((0x00000200&(data))>>9)
#define VI_DMA_MIN_TIME_get_dy(data)                                  ((0x000001E0&(data))>>5)
#define VI_DMA_MIN_TIME_get_write_enable6(data)                       ((0x00000010&(data))>>4)
#define VI_DMA_MIN_TIME_get_din(data)                                 (0x0000000F&(data))

#define VI_DMAERR                                                     0x18004264
#define VI_DMAERR_reg_addr                                            "0xB8004264"
#define VI_DMAERR_reg                                                 0xB8004264
#define VI_DMAERR_inst_addr                                           "0x0099"
#define VI_DMAERR_inst                                                0x0099
#define VI_DMAERR_ext_err_shift                                       (1)
#define VI_DMAERR_int_err_shift                                       (0)
#define VI_DMAERR_ext_err_mask                                        (0x00000002)
#define VI_DMAERR_int_err_mask                                        (0x00000001)
#define VI_DMAERR_ext_err(data)                                       (0x00000002&((data)<<1))
#define VI_DMAERR_int_err(data)                                       (0x00000001&(data))
#define VI_DMAERR_get_ext_err(data)                                   ((0x00000002&(data))>>1)
#define VI_DMAERR_get_int_err(data)                                   (0x00000001&(data))

#define VI_INTEN                                                      0x18004268
#define VI_INTEN_reg_addr                                             "0xB8004268"
#define VI_INTEN_reg                                                  0xB8004268
#define VI_INTEN_inst_addr                                            "0x009A"
#define VI_INTEN_inst                                                 0x009A
#define VI_INTEN_dmaerrinte_shift                                     (10)
#define VI_INTEN_dinendinte_shift                                     (9)
#define VI_INTEN_sfinte1_shift                                        (8)
#define VI_INTEN_sfinte2_shift                                        (7)
#define VI_INTEN_vsinte1_shift                                        (6)
#define VI_INTEN_vsinte2_shift                                        (5)
#define VI_INTEN_tointe1_shift                                        (4)
#define VI_INTEN_tointe2_shift                                        (3)
#define VI_INTEN_olinte1_shift                                        (2)
#define VI_INTEN_olinte2_shift                                        (1)
#define VI_INTEN_write_data_shift                                     (0)
#define VI_INTEN_dmaerrinte_mask                                      (0x00000400)
#define VI_INTEN_dinendinte_mask                                      (0x00000200)
#define VI_INTEN_sfinte1_mask                                         (0x00000100)
#define VI_INTEN_sfinte2_mask                                         (0x00000080)
#define VI_INTEN_vsinte1_mask                                         (0x00000040)
#define VI_INTEN_vsinte2_mask                                         (0x00000020)
#define VI_INTEN_tointe1_mask                                         (0x00000010)
#define VI_INTEN_tointe2_mask                                         (0x00000008)
#define VI_INTEN_olinte1_mask                                         (0x00000004)
#define VI_INTEN_olinte2_mask                                         (0x00000002)
#define VI_INTEN_write_data_mask                                      (0x00000001)
#define VI_INTEN_dmaerrinte(data)                                     (0x00000400&((data)<<10))
#define VI_INTEN_dinendinte(data)                                     (0x00000200&((data)<<9))
#define VI_INTEN_sfinte1(data)                                        (0x00000100&((data)<<8))
#define VI_INTEN_sfinte2(data)                                        (0x00000080&((data)<<7))
#define VI_INTEN_vsinte1(data)                                        (0x00000040&((data)<<6))
#define VI_INTEN_vsinte2(data)                                        (0x00000020&((data)<<5))
#define VI_INTEN_tointe1(data)                                        (0x00000010&((data)<<4))
#define VI_INTEN_tointe2(data)                                        (0x00000008&((data)<<3))
#define VI_INTEN_olinte1(data)                                        (0x00000004&((data)<<2))
#define VI_INTEN_olinte2(data)                                        (0x00000002&((data)<<1))
#define VI_INTEN_write_data(data)                                     (0x00000001&(data))
#define VI_INTEN_get_dmaerrinte(data)                                 ((0x00000400&(data))>>10)
#define VI_INTEN_get_dinendinte(data)                                 ((0x00000200&(data))>>9)
#define VI_INTEN_get_sfinte1(data)                                    ((0x00000100&(data))>>8)
#define VI_INTEN_get_sfinte2(data)                                    ((0x00000080&(data))>>7)
#define VI_INTEN_get_vsinte1(data)                                    ((0x00000040&(data))>>6)
#define VI_INTEN_get_vsinte2(data)                                    ((0x00000020&(data))>>5)
#define VI_INTEN_get_tointe1(data)                                    ((0x00000010&(data))>>4)
#define VI_INTEN_get_tointe2(data)                                    ((0x00000008&(data))>>3)
#define VI_INTEN_get_olinte1(data)                                    ((0x00000004&(data))>>2)
#define VI_INTEN_get_olinte2(data)                                    ((0x00000002&(data))>>1)
#define VI_INTEN_get_write_data(data)                                 (0x00000001&(data))

#define VI_INTST                                                      0x1800426C
#define VI_INTST_reg_addr                                             "0xB800426C"
#define VI_INTST_reg                                                  0xB800426C
#define VI_INTST_inst_addr                                            "0x009B"
#define VI_INTST_inst                                                 0x009B
#define VI_INTST_dmaerrints_shift                                     (10)
#define VI_INTST_dinendints_shift                                     (9)
#define VI_INTST_sfints1_shift                                        (8)
#define VI_INTST_sfints2_shift                                        (7)
#define VI_INTST_vsints1_shift                                        (6)
#define VI_INTST_vsints2_shift                                        (5)
#define VI_INTST_toints1_shift                                        (4)
#define VI_INTST_toints2_shift                                        (3)
#define VI_INTST_olints1_shift                                        (2)
#define VI_INTST_olints2_shift                                        (1)
#define VI_INTST_write_data_shift                                     (0)
#define VI_INTST_dmaerrints_mask                                      (0x00000400)
#define VI_INTST_dinendints_mask                                      (0x00000200)
#define VI_INTST_sfints1_mask                                         (0x00000100)
#define VI_INTST_sfints2_mask                                         (0x00000080)
#define VI_INTST_vsints1_mask                                         (0x00000040)
#define VI_INTST_vsints2_mask                                         (0x00000020)
#define VI_INTST_toints1_mask                                         (0x00000010)
#define VI_INTST_toints2_mask                                         (0x00000008)
#define VI_INTST_olints1_mask                                         (0x00000004)
#define VI_INTST_olints2_mask                                         (0x00000002)
#define VI_INTST_write_data_mask                                      (0x00000001)
#define VI_INTST_dmaerrints(data)                                     (0x00000400&((data)<<10))
#define VI_INTST_dinendints(data)                                     (0x00000200&((data)<<9))
#define VI_INTST_sfints1(data)                                        (0x00000100&((data)<<8))
#define VI_INTST_sfints2(data)                                        (0x00000080&((data)<<7))
#define VI_INTST_vsints1(data)                                        (0x00000040&((data)<<6))
#define VI_INTST_vsints2(data)                                        (0x00000020&((data)<<5))
#define VI_INTST_toints1(data)                                        (0x00000010&((data)<<4))
#define VI_INTST_toints2(data)                                        (0x00000008&((data)<<3))
#define VI_INTST_olints1(data)                                        (0x00000004&((data)<<2))
#define VI_INTST_olints2(data)                                        (0x00000002&((data)<<1))
#define VI_INTST_write_data(data)                                     (0x00000001&(data))
#define VI_INTST_get_dmaerrints(data)                                 ((0x00000400&(data))>>10)
#define VI_INTST_get_dinendints(data)                                 ((0x00000200&(data))>>9)
#define VI_INTST_get_sfints1(data)                                    ((0x00000100&(data))>>8)
#define VI_INTST_get_sfints2(data)                                    ((0x00000080&(data))>>7)
#define VI_INTST_get_vsints1(data)                                    ((0x00000040&(data))>>6)
#define VI_INTST_get_vsints2(data)                                    ((0x00000020&(data))>>5)
#define VI_INTST_get_toints1(data)                                    ((0x00000010&(data))>>4)
#define VI_INTST_get_toints2(data)                                    ((0x00000008&(data))>>3)
#define VI_INTST_get_olints1(data)                                    ((0x00000004&(data))>>2)
#define VI_INTST_get_olints2(data)                                    ((0x00000002&(data))>>1)
#define VI_INTST_get_write_data(data)                                 (0x00000001&(data))

#define VI_OLN1                                                       0x18004270
#define VI_OLN1_reg_addr                                              "0xB8004270"
#define VI_OLN1_reg                                                   0xB8004270
#define VI_OLN1_inst_addr                                             "0x009C"
#define VI_OLN1_inst                                                  0x009C
#define VI_OLN1_write_enable1_shift                                   (21)
#define VI_OLN1_y_shift                                               (11)
#define VI_OLN1_write_enable2_shift                                   (10)
#define VI_OLN1_c_shift                                               (0)
#define VI_OLN1_write_enable1_mask                                    (0x00200000)
#define VI_OLN1_y_mask                                                (0x001FF800)
#define VI_OLN1_write_enable2_mask                                    (0x00000400)
#define VI_OLN1_c_mask                                                (0x000003FF)
#define VI_OLN1_write_enable1(data)                                   (0x00200000&((data)<<21))
#define VI_OLN1_y(data)                                               (0x001FF800&((data)<<11))
#define VI_OLN1_write_enable2(data)                                   (0x00000400&((data)<<10))
#define VI_OLN1_c(data)                                               (0x000003FF&(data))
#define VI_OLN1_get_write_enable1(data)                               ((0x00200000&(data))>>21)
#define VI_OLN1_get_y(data)                                           ((0x001FF800&(data))>>11)
#define VI_OLN1_get_write_enable2(data)                               ((0x00000400&(data))>>10)
#define VI_OLN1_get_c(data)                                           (0x000003FF&(data))

#define VI_OLN2                                                       0x18004274
#define VI_OLN2_reg_addr                                              "0xB8004274"
#define VI_OLN2_reg                                                   0xB8004274
#define VI_OLN2_inst_addr                                             "0x009D"
#define VI_OLN2_inst                                                  0x009D
#define VI_OLN2_write_enable1_shift                                   (21)
#define VI_OLN2_y_shift                                               (11)
#define VI_OLN2_write_enable2_shift                                   (10)
#define VI_OLN2_c_shift                                               (0)
#define VI_OLN2_write_enable1_mask                                    (0x00200000)
#define VI_OLN2_y_mask                                                (0x001FF800)
#define VI_OLN2_write_enable2_mask                                    (0x00000400)
#define VI_OLN2_c_mask                                                (0x000003FF)
#define VI_OLN2_write_enable1(data)                                   (0x00200000&((data)<<21))
#define VI_OLN2_y(data)                                               (0x001FF800&((data)<<11))
#define VI_OLN2_write_enable2(data)                                   (0x00000400&((data)<<10))
#define VI_OLN2_c(data)                                               (0x000003FF&(data))
#define VI_OLN2_get_write_enable1(data)                               ((0x00200000&(data))>>21)
#define VI_OLN2_get_y(data)                                           ((0x001FF800&(data))>>11)
#define VI_OLN2_get_write_enable2(data)                               ((0x00000400&(data))>>10)
#define VI_OLN2_get_c(data)                                           (0x000003FF&(data))

#define VI_OLNCNT1                                                    0x18004278
#define VI_OLNCNT1_reg_addr                                           "0xB8004278"
#define VI_OLNCNT1_reg                                                0xB8004278
#define VI_OLNCNT1_inst_addr                                          "0x009E"
#define VI_OLNCNT1_inst                                               0x009E
#define VI_OLNCNT1_y_shift                                            (10)
#define VI_OLNCNT1_c_shift                                            (0)
#define VI_OLNCNT1_y_mask                                             (0x000FFC00)
#define VI_OLNCNT1_c_mask                                             (0x000003FF)
#define VI_OLNCNT1_y(data)                                            (0x000FFC00&((data)<<10))
#define VI_OLNCNT1_c(data)                                            (0x000003FF&(data))
#define VI_OLNCNT1_get_y(data)                                        ((0x000FFC00&(data))>>10)
#define VI_OLNCNT1_get_c(data)                                        (0x000003FF&(data))

#define VI_OLNCNT2                                                    0x1800427C
#define VI_OLNCNT2_reg_addr                                           "0xB800427C"
#define VI_OLNCNT2_reg                                                0xB800427C
#define VI_OLNCNT2_inst_addr                                          "0x009F"
#define VI_OLNCNT2_inst                                               0x009F
#define VI_OLNCNT2_y_shift                                            (10)
#define VI_OLNCNT2_c_shift                                            (0)
#define VI_OLNCNT2_y_mask                                             (0x000FFC00)
#define VI_OLNCNT2_c_mask                                             (0x000003FF)
#define VI_OLNCNT2_y(data)                                            (0x000FFC00&((data)<<10))
#define VI_OLNCNT2_c(data)                                            (0x000003FF&(data))
#define VI_OLNCNT2_get_y(data)                                        ((0x000FFC00&(data))>>10)
#define VI_OLNCNT2_get_c(data)                                        (0x000003FF&(data))

#define VI_GCTL                                                       0x18004280
#define VI_GCTL_reg_addr                                              "0xB8004280"
#define VI_GCTL_reg                                                   0xB8004280
#define VI_GCTL_inst_addr                                             "0x00A0"
#define VI_GCTL_inst                                                  0x00A0
#define VI_GCTL_write_enable1_shift                                   (8)
#define VI_GCTL_sel_shift                                             (6)
#define VI_GCTL_write_enable2_shift                                   (5)
#define VI_GCTL_dintrig_shift                                         (4)
#define VI_GCTL_write_enable3_shift                                   (3)
#define VI_GCTL_vsce1_shift                                           (2)
#define VI_GCTL_write_enable4_shift                                   (1)
#define VI_GCTL_vsce2_shift                                           (0)
#define VI_GCTL_write_enable1_mask                                    (0x00000100)
#define VI_GCTL_sel_mask                                              (0x000000C0)
#define VI_GCTL_write_enable2_mask                                    (0x00000020)
#define VI_GCTL_dintrig_mask                                          (0x00000010)
#define VI_GCTL_write_enable3_mask                                    (0x00000008)
#define VI_GCTL_vsce1_mask                                            (0x00000004)
#define VI_GCTL_write_enable4_mask                                    (0x00000002)
#define VI_GCTL_vsce2_mask                                            (0x00000001)
#define VI_GCTL_write_enable1(data)                                   (0x00000100&((data)<<8))
#define VI_GCTL_sel(data)                                             (0x000000C0&((data)<<6))
#define VI_GCTL_write_enable2(data)                                   (0x00000020&((data)<<5))
#define VI_GCTL_dintrig(data)                                         (0x00000010&((data)<<4))
#define VI_GCTL_write_enable3(data)                                   (0x00000008&((data)<<3))
#define VI_GCTL_vsce1(data)                                           (0x00000004&((data)<<2))
#define VI_GCTL_write_enable4(data)                                   (0x00000002&((data)<<1))
#define VI_GCTL_vsce2(data)                                           (0x00000001&(data))
#define VI_GCTL_get_write_enable1(data)                               ((0x00000100&(data))>>8)
#define VI_GCTL_get_sel(data)                                         ((0x000000C0&(data))>>6)
#define VI_GCTL_get_write_enable2(data)                               ((0x00000020&(data))>>5)
#define VI_GCTL_get_dintrig(data)                                     ((0x00000010&(data))>>4)
#define VI_GCTL_get_write_enable3(data)                               ((0x00000008&(data))>>3)
#define VI_GCTL_get_vsce1(data)                                       ((0x00000004&(data))>>2)
#define VI_GCTL_get_write_enable4(data)                               ((0x00000002&(data))>>1)
#define VI_GCTL_get_vsce2(data)                                       (0x00000001&(data))
#endif
