/*

  Laminator-Temperatur-Regelung V2.0
  Copyright 2006 Thomas Pfeifer
  http://thomaspfeifer.net/laminator_temperatur_regelung.htm


  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


  Target: AVR-ATMega8
  Compiler: AVRGcc

  changes:
  16.01.06 TP - detect Sensor break/short

*/

#include <avr/io.h>
#include <stdio.h>
#include <stdlib.h>

#define F_CPU 8000000UL  // 8 MHz
#define SOLLWERT 150 //<= gibt die Solltemperatur (ADC-Wert) an, TODO: Autom. Umrechnung von C
#define BAUD_RATE 9600

#include <avr/delay.h>

void adcinit();
int getadc(uint8_t channel);
void waitms(int ms);



int uart_putchar (char c)
//############################################################################
{
  if (c == '\n')
    uart_putchar('\r');
  //Warten solange bis Zeichen gesendet wurde
  loop_until_bit_is_set(UCSRA, UDRE);
  //Ausgabe des Zeichens
  UDR = c;
  return (0);
}

void UART_Init (void) {
  //Enable TXEN im Register UCR TX-Data Enable
  UCSRB=(1 << TXEN);
  //Teiler wird gesetzt
  UBRRL=(F_CPU / (BAUD_RATE * 16L) - 1);

  //ffnet einen Kanal fr printf (STDOUT)
  fdevopen (uart_putchar, NULL, 0);
}

int convert2degree(int value) {
  static const float c1=19.5;
  static const float v1=275;  //ADC-Wert=264 @ 20C

  static const float c2=202;
  static const float v2=154;  //ADC-Wert=165 @ 202C


  float m=((c1-c2)/(v1-v2));
  return((int)((m*(float)value)+(-m*v1)+c1));
  //return((int)((-m*v1)+c1));
}




int main (void) {
  int val;
  int pwm;
  int pwm_ctr=0;

  adcinit();
  UART_Init();

  DDRC  = 0b00000000;

  DDRB  = 0b00000000;
  PORTB = 0b00000000;

  DDRD  = 0b11100000;  // 1=Output, 0=Input


  PORTD = 0b11100000;  //on


  printf("ok\n");

  while (1==1) {
    waitms(100);

    val=getadc(0);
    printf("%d %d %d %d\n",pwm,pwm_ctr,val,convert2degree(val)); //debug
    //printf("%d \n",convert2degree(val));

    pwm_ctr++;
    if (pwm_ctr>=10) pwm_ctr=0;

    pwm=val-SOLLWERT;
    if (pwm<0) pwm=0;

    if (pwm<pwm_ctr || val<100 || val>1000) { //pwm, detect Sensor contakt break/short
      PORTD = 0b01000000;  //off
    } else {
      PORTD = 0b11100000;  //on
    }

  }

}

void adcinit() {
  // Activate ADC with Prescaler 16 --> 1Mhz/16 = 62.5kHz
  //ADCSRA = _BV(ADEN) | _BV(ADPS2);
  ADCSRA = _BV(ADEN) | _BV(ADPS2) | _BV(ADPS1);
  ADMUX=  0;
}

int getadc(uint8_t channel) {
  // Select pin ADC0 using MUX
  ADMUX = channel | _BV(REFS0) | _BV(REFS1);

  //Start conversion
  ADCSRA |= _BV(ADSC);

  // wait until converstion completed
  while (ADCSRA & _BV(ADSC) ) {}

    // get converted value
  return(ADCW);
}

void waitms(int ms) {
  int i;
  for (i=0;i<ms;i++) _delay_ms(1);
}

