// 006.cpp : Definiert den Einsprungpunkt fr die Konsolenanwendung.
//

#include "stdafx.h"
#include <string.h>
#include <conio.h>

// klasse(n) fr verkettete listen
class Node
{
public:
	Node()
	{
		m_pszLine = 0;
		m_pPrev = m_pNext = 0;
	}

	void SetPrev( Node* p)
	{
		m_pPrev = p;
	}

	void SetNext( Node* p)
	{
		m_pNext = p;
	}

	void SetText( char* pszLine)
	{
		if( m_pszLine) delete[] m_pszLine;

		m_pszLine = new char[ strlen( pszLine) + 1 ];
		strcpy( m_pszLine, pszLine);
	}

	Node( Node* pPrev, Node* pNext, char* pszLine)
	{
		m_pszLine = new char[ strlen( pszLine) + 1 ];
		strcpy( m_pszLine, pszLine);

		m_pPrev = pPrev;
		m_pNext = pNext;
	}

	char* GetLine()
	{
		return m_pszLine;
	}

	Node* GetNext()
	{
		return m_pNext;
	}

	Node* GetPrev()
	{
		return m_pPrev;
	}

	~Node()
	{
		delete[] m_pszLine;
	}

private:
	char* m_pszLine;
	Node* m_pPrev;
	Node* m_pNext;
};

class List
{
public:
	List()
	{
		m_pRoot = 0;
		m_pCurrent = 0;
	}

	~List()
	{
		Node* n = m_pRoot;

		while( n->GetNext())
		{
			Node* nDelete = n;
			n = n->GetNext();
			delete nDelete;
		}
	}

	void Add( Node* p)
	{
		if( ! m_pCurrent)
		{
			m_pRoot = p;
			m_pCurrent = p;
			m_pCurrent->SetPrev( 0);
			m_pCurrent->SetNext( 0);
		}
		else
		{
			m_pCurrent->SetNext( p);
			p->SetPrev( m_pCurrent);
			p->SetNext( 0);
			m_pCurrent = p;
		}
	}

	Node* GetNext()
	{
		// immer nurbis zum letzten
		if( m_pCurrent->GetNext())
		{
			m_pCurrent = m_pCurrent->GetNext();
			return m_pCurrent;
		}

		return 0;
	}

	Node* GetPrev()
	{
		if( m_pCurrent->GetPrev())
		{
			m_pCurrent = m_pCurrent->GetPrev();
			return m_pCurrent;
		}

		return 0;
	}

	Node* GetCurrent()
	{
		return m_pCurrent;
	}

	Node* GetRoot()
	{
		return m_pRoot;
	}

	void SetRootAsCurrent()
	{
		m_pCurrent = m_pRoot;
	}

private:
	Node* m_pCurrent;
	Node* m_pRoot;
};


// klasse fuer das menu
class Command
{
public:
	Command( char c)
	{
		m_cKey = c;
	}

	virtual void Exec( Node** pFirst)
	{
		// default tut nichts
	}

	char Key()
	{
		return m_cKey;
	}

private:
	char m_cKey;

};

class ForwardCommand : public Command
{
public:
	ForwardCommand( char c) : Command( c)
	{
	}
	void Exec( Node** pFirst)
	{
		// scroll vorward
		if( (*pFirst)->GetNext())
			(*pFirst) = (*pFirst)->GetNext();
	}
};

class BackCommand : public Command
{
public:
	BackCommand( char c) : Command( c)
	{
	}
	void Exec( Node** pFirst)
	{
		// scroll vorward
		if( (*pFirst)->GetPrev())
			(*pFirst) = (*pFirst)->GetPrev();
	}
};

// array aus kommandos
Command* arrCommands[] = 
{
	new ForwardCommand( 'v'),
	new BackCommand( 'r')
};

// normale funktionen...
void ReadFile( char* pszSource, List* pList)
{
	FILE* pSource = fopen( pszSource, "r");
	while( ! feof( pSource))
	{
		char sz[ 1024];
		fgets( sz, 1024, pSource);
		Node* n = new Node();
		n->SetText( sz);
		pList->Add( n);
	}
}

void DisplayFile( List* pList)
{
	Node* pFirst = pList->GetRoot();

	char c = 'x';
	while( c != 'e')
	{
		// bis zur ersten zeile
		pList->SetRootAsCurrent();
		while( pFirst != pList->GetCurrent())
		{ 
			pList->GetNext();
		}

		// 23 zeilen anzeigen
		for( int i=0; i<25; i++)
		{
			if( Node* p = pList->GetNext())
				printf( p->GetLine());
		}
		
		printf("[v]or zu[r]ueck [e]nde");
		c = getch();
		int cntCommands = sizeof(arrCommands)/sizeof(Command*);
		for( i=0; i<cntCommands; i++)
		{
			if( arrCommands[i]->Key() == c)
				arrCommands[i]->Exec( &pFirst);
		}
	}
}

int main(int argc, char* argv[])
{
	List l;

	ReadFile( argv[1], &l);

	DisplayFile( &l);

	return 0;
}

