// 008View.cpp : Implementierung der Klasse CMy008View
//

#include "stdafx.h"
#include "008.h"

#include "008Doc.h"
#include "008View.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMy008View

IMPLEMENT_DYNCREATE(CMy008View, CView)

BEGIN_MESSAGE_MAP(CMy008View, CView)
	//{{AFX_MSG_MAP(CMy008View)
	ON_COMMAND(ID_GRAPHIKEN_NEUELINIE, OnGraphikenNeuelinie)
	ON_WM_LBUTTONDOWN()
	ON_WM_CANCELMODE()
	ON_WM_MOUSEMOVE()
	ON_WM_CAPTURECHANGED()
	ON_COMMAND(ID_GRAPHIKEN_NEUERKREIS, OnGraphikenNeuerkreis)
	//}}AFX_MSG_MAP
	// Standard-Druckbefehle
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy008View Konstruktion/Destruktion

CMy008View::CMy008View()
{
	// ZU ERLEDIGEN: Hier Code zur Konstruktion einfgen,
	m_pGraphic = 0;

}

CMy008View::~CMy008View()
{
	if( m_pGraphic)
		delete m_pGraphic;
}

BOOL CMy008View::PreCreateWindow(CREATESTRUCT& cs)
{
	// ZU ERLEDIGEN: ndern Sie hier die Fensterklasse oder das Erscheinungsbild, indem Sie
	//  CREATESTRUCT cs modifizieren.

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMy008View Zeichnen

void CMy008View::OnDraw(CDC* pDC)
{
	CMy008Doc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// ZU ERLEDIGEN: Hier Code zum Zeichnen der ursprnglichen Daten hinzufgen

	// objekte zeichnen
	for( POSITION pos = pDoc->GetHeadPosition(); pos!=NULL;)
	{
		Graphic* g = pDoc->GetNext( pos);
		g->Draw( pDC);
	}

	// instant zeichnungen
	if( m_pGraphic) m_pGraphic->Draw( pDC);
}

/////////////////////////////////////////////////////////////////////////////
// CMy008View Drucken

BOOL CMy008View::OnPreparePrinting(CPrintInfo* pInfo)
{
	// Standardvorbereitung
	return DoPreparePrinting(pInfo);
}

void CMy008View::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// ZU ERLEDIGEN: Zustzliche Initialisierung vor dem Drucken hier einfgen
}

void CMy008View::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// ZU ERLEDIGEN: Hier Bereinigungsarbeiten nach dem Drucken einfgen
}

/////////////////////////////////////////////////////////////////////////////
// CMy008View Diagnose

#ifdef _DEBUG
void CMy008View::AssertValid() const
{
	CView::AssertValid();
}

void CMy008View::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMy008Doc* CMy008View::GetDocument() // Die endgltige (nicht zur Fehlersuche kompilierte) Version ist Inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMy008Doc)));
	return (CMy008Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMy008View Nachrichten-Handler

void CMy008View::OnGraphikenNeuelinie() 
{
    if( m_pGraphic) 
	{
		delete m_pGraphic;
		m_pGraphic = 0;
	}

	m_pGraphic = new Line();
	m_pGraphic->SetState( Graphic::S_NONE);

	// cursor setzen
	SetCapture();
	HCURSOR hc = AfxGetApp()->LoadCursor( IDC_CURSOR_LINE);
	::SetCursor( hc);
}

void CMy008View::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if( m_pGraphic)
	{
		if( m_pGraphic->GetState() == Graphic::S_NONE)
		{
			m_pGraphic->SetPoint1( point);
			m_pGraphic->SetState( Graphic::S_INIT);
			int idCursor = m_pGraphic->OnSetCursor();
			if( idCursor != 0)
			{
				::SetCursor( AfxGetApp()->LoadCursor( idCursor));
			}
		}
		else
		{
			// ende festlegen
			m_pGraphic->SetPoint2( point);
			
			// neue linie ins dokument speichern...
			CMy008Doc* pDoc = GetDocument();
			pDoc->AddObject( m_pGraphic);

			// und zuruecksetzen...
			m_pGraphic = 0;

			// cursor zurueck
			SetCursor( NULL);
			ReleaseCapture();

			// views update
			pDoc->UpdateAllViews( this);

		}
	}
	
	CView::OnLButtonDown(nFlags, point);
}

void CMy008View::OnCancelMode() 
{
	CView::OnCancelMode();
	
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen
	
}

void CMy008View::OnMouseMove(UINT nFlags, CPoint point) 
{
	if( m_pGraphic)
	{
		if( m_pGraphic->GetState() != Graphic::S_NONE)
		{
			m_pGraphic->SetPoint2( point);
			Invalidate();
		}

	}
	
	CView::OnMouseMove(nFlags, point);
}

void CMy008View::OnCaptureChanged(CWnd *pWnd) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen
	
	CView::OnCaptureChanged(pWnd);
}

void CMy008View::OnGraphikenNeuerkreis() 
{
    if( m_pGraphic) 
	{
		delete m_pGraphic;
		m_pGraphic = 0;
	}

	m_pGraphic = new Circle();
	m_pGraphic->SetState( Graphic::S_NONE);

	// cursor setzen
	SetCapture();
	HCURSOR hc = AfxGetApp()->LoadCursor( IDC_CURSOR_CIRCLE);
	::SetCursor( hc);
	
}
