#ifndef _GRAPHIC_H
#define _GRAPHIC_H



class Graphic : public CObject
{
public:
	Graphic()
	{
		m_state = State::S_NONE;
	}

	virtual void Draw( CDC* pDC) = 0;
	virtual int OnSetCursor()
	{
		// default tut nix
		return 0;
	}

	enum State
	{
		S_NONE,
		S_INIT,
		S_DRAWING,
		S_FINISH
	};

	void SetState( State s)
	{
		m_state = s;
	}

	State GetState() const
	{
		return m_state;
	}

	void SetPoint1( CPoint p)
	{
		m_ptBegin = p;
	}

	void SetPoint2( CPoint p)
	{
		m_ptEnd = p;
	}


private:
	State m_state; 

protected:
	CPoint m_ptBegin;
	CPoint m_ptEnd;

};

class Line : public Graphic
{
public:
	Line()
	{
	}

	void Draw( CDC* pDC)
	{
		pDC->MoveTo( m_ptBegin);
		pDC->LineTo( m_ptEnd);
	}

private:
};

class Circle : public Graphic
{
public:
	Circle()
	{
	}

	void Draw( CDC* pDC)
	{
		CSize s = m_ptEnd - m_ptBegin;
		CRect r( m_ptBegin.x - s.cx, m_ptBegin.y - s.cy, m_ptBegin.x + s.cx, m_ptBegin.y + s.cy);

		CPoint p1 = r.BottomRight();
		pDC->Arc( r, p1, p1 );
		// pDC->Arc( r, CPoint(r.BottomRight), CPoint(r.BottomRight));
	}

	int OnSetCursor()
	{
		if( GetState() == State::S_INIT)
		{
			return IDC_CURSOR_CIRCLE_1;
		}

		return 0;
	}
};

typedef CTypedPtrList<CPtrList, Graphic*> GPtrList;
#endif