/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#ifdef __X11
#include <mikmod.h>
#include <pthread.h>
#endif

#include <av3d.hpp>
#include <string.h>

#define MAX_CHANNELS 32      // entire S3M capability

typedef struct{
  MODULE *mod;
}AV_ModulePointerThreadData;

#ifdef __X11
pthread_t  ___pthread_sound;
#endif

////////////////////////////////////////////////////////////
#ifdef __X11
void *sound_thread(void*)
{
  for(;;)
    MikMod_Update();
}
#endif
////////////////////////////////////////////////////////////
void ___internal_sound_setup()
{
#ifdef __WINDOWS
  MikMod_RegisterDriver(&drv_ds); // thread created internally
#endif
  
#ifdef __X11
  // MikMod_RegisterAllDrivers();
  MikMod_RegisterDriver(&drv_esd);
  MikMod_RegisterDriver(&drv_oss);
#endif
  
  //md_mixfreq = 22050;
  //md_mode = DMODE_STEREO | DMODE_SURROUND | DMODE_16BITS | DMODE_SOFT_MUSIC | DMODE_SOFT_SNDFX | DMODE_INTERP; 
  md_mixfreq = 44100;
  if(MikMod_Init("") != 0){
    fprintf(stderr, "Can't initalize MikMod! ??? Are you using the supplied Makefile?\n");
    exit(0);
  }  

#ifdef __X11
  ___pthread_sound = pthread_create(&___pthread_sound,NULL,sound_thread,NULL);
#endif
}
////////////////////////////////////////////////////////////
void ___internal_sound_unsetup()
{
  MikMod_Exit();  // this will kill all threads that might still be running in AV_ModuleMixer
}
////////////////////////////////////////////////////////////
AV_ModuleMixer :: AV_ModuleMixer(char *fn, AV_ModuleType a)
{
  CheckVersion();
  if(!RegisterLoader(a))
    throw AV_Exception(AV_Exception::BAD_MODULE_TYPE);
  AV_ModulePointerThreadData *D = new AV_ModulePointerThreadData;
  memset(D, 0, sizeof(AV_ModulePointerThreadData));
  
  Data=D;
  D->mod = Player_Load(fn, MAX_CHANNELS, 2);
  if(D->mod == NULL){
    delete D;
    D=NULL;
    throw AV_Exception(AV_Exception::CANT_LOAD_MODULE);
  }
  Player_Start(D->mod);
}
////////////////////////////////////////////////////////////
AV_ModuleMixer :: AV_ModuleMixer(FILE *f, AV_ModuleType a)
{
  if(!RegisterLoader(a))
    throw AV_Exception(AV_Exception::BAD_MODULE_TYPE);
  AV_ModulePointerThreadData *D = new AV_ModulePointerThreadData;
  memset(D, 0, sizeof(AV_ModulePointerThreadData));
  
  D->mod = Player_LoadFP(f, MAX_CHANNELS, 2);
  Data=D;
  if(D->mod == NULL){
    delete D;
    D = NULL;
    throw AV_Exception(AV_Exception::CANT_LOAD_MODULE);
  }
  Player_Start(D->mod);
}
////////////////////////////////////////////////////////////
AV_ModuleMixer :: ~AV_ModuleMixer()
{
  AV_ModulePointerThreadData *p = static_cast<AV_ModulePointerThreadData*>(Data);
  if(p)
    Player_Free(p->mod);
  delete p;
}
////////////////////////////////////////////////////////////
void AV_ModuleMixer :: CheckVersion()
{
  if(MikMod_GetVersion() < LIBMIKMOD_VERSION)
    throw AV_Exception(AV_Exception::BAD_MIKMOD_VERSION);
}
////////////////////////////////////////////////////////////
bool AV_ModuleMixer :: fStop()
{
  return Player_Active()==0;
}
////////////////////////////////////////////////////////////
bool AV_ModuleMixer :: RegisterLoader(AV_ModuleType)
{
  static bool fSet;
  if(fSet) return true;
  fSet = true;
  MikMod_RegisterAllLoaders();
  return true;
}
