/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <av3d.hpp>
#include <string.h>

////////////////////////////////////////////////////////////
AV_Sound :: AV_Sound(AV_Video &v, AV_Camera &cam, int ch_no): Camera(cam)
{
  Music = NULL;
}
////////////////////////////////////////////////////////////
AV_Sound :: ~AV_Sound()
{
  if(Music!=NULL)
    delete Music;
}
////////////////////////////////////////////////////////////
void AV_Sound :: PlayMusic(const char *Filename)
{
  char *File = new char[strlen(Filename)+1];
  strcpy(File, Filename);

  if(Music) delete Music;
  Music = new AV_ModuleMixer(File, AV_ModuleMixer::AV_S3M);
}
////////////////////////////////////////////////////////////
int AV_Sound :: SFX(SAMPLE *Data, int x, int y, int z)
{
  // adds a new sound file to be played... Distance of 100 means 0 volume..
  int dist = x*x + y*y + z*z;
  if(dist > 4096) return 0;
  int Vol = 64 - (int)sqrt(dist);
  
  // allocates the SAMPLE data
  Data->volume = Vol;
  
  // adds the sample to the list and clears same sample
  return Sample_Play(Data, 0, 0);
}
////////////////////////////////////////////////////////////
void AV_Sound :: Stop(int ch)
{
}
////////////////////////////////////////////////////////////
void AV_Sound :: StopAll()
{
}
