/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <av3d.hpp>
#include <stdlib.h>
#include <math.h>

#include <GL/glu.h>

AV_Video *V;

AV_Joystick *Joystick;
AV_Mouse *Mouse;
AV_Keyboard *Keys;
AV_Sound *Sound;
AV_Camera *Cam;

AV_Timer *Time;

ControllerData ContData;

int Frames = 0;

/* SOUND EFFECTS */
int nEffects;
SAMPLE **SoundEffects;

const int nPoints = 50000;
GLfloat VertexArray[nPoints * 3];
GLfloat ColorArray[nPoints * 3];

#ifdef __WINDOWS
#pragma argsused
#endif
/////////////////////////////////////////////////////////////
bool EnumJoyProc(ControllerData d, int Type, const char *Name, const char *Product)
{
  //  if(Type != JOYSTICK)
  //return true;
  memcpy(&ContData, &d, sizeof(ControllerData));
  return false;
}
////////////////////////////////////////////////////////////
bool AV3D_EndProc()
{
  delete Mouse;
  //  delete Joystick;
  
  delete Keys;
  delete Sound;
  delete Cam;
  delete Time;
  
  //  delete[]ContData;
  V->RestoreVideoMode();
  fprintf(stderr, "End");
  delete V;

  return false;
}
////////////////////////////////////////////////////////////
bool AV3D_InitProc()
{
  V = new AV_Video("Test", 640,480, 16, 1);
  //  ContData = new int[sizeof(_GUID)/sizeof(int)+1]; // to enumerate joysticks
  //  AV_Joystick :: EnumDevices(EnumJoyProc);
  
  //Joystick = new AV_Joystick(V, ContData);
  Keys = new AV_Keyboard(*V);
  Mouse = new AV_Mouse(*V);
  
  Cam = new AV_Camera();
  fprintf(stderr, "Two\n");
  Sound = new AV_Sound(*V, *Cam);
  
  Time = new AV_Timer;
  
  // starts playing a S3M file
  //Sound->PlayMusic("beyond.mod");
  
  /* Initializes the height map for current level - a one big map */
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
  glShadeModel(GL_SMOOTH);
  
  /* change to the projection matrix and set our viewing volume. */
  glMatrixMode( GL_PROJECTION );   
  glLoadIdentity( );
  
  /* Set our perspective */
  glFrustum( -10.0, 10.0,  -10.0, 10.0,  15, 1000.0);

  /* Make sure we're chaning the model view and not the projection */
  glMatrixMode( GL_MODELVIEW );
  glLoadIdentity();

  /* Creates the partcile array here */
  glEnableClientState(GL_COLOR_ARRAY);
  glEnableClientState(GL_VERTEX_ARRAY);
  glEnable(GL_BLEND);
  
  glVertexPointer(3, GL_FLOAT, 0, VertexArray);
  glColorPointer(3, GL_FLOAT, 0, ColorArray);
  
  for(int i=0;i<nPoints;i++){
    VertexArray[i] = rand()%100 - 50;
    ColorArray[i] = rand()/(float)RAND_MAX;
  }
  
  // resets timer
  Time->ResetFrame();

  return false;
}
////////////////////////////////////////////////////////////
bool AV3D_MainLoop()
{
  static int Times[10];
  for(int i=0;i<9;i++) Times[i] = Times[i+1];
  Times[9] = Time->GetTime();
  Time->ResetFrame();
  
  V->ClearScreen();
  
  char Buffer[64];
  Frames+=1000;
  double fps=1;
  for(int i=0;i<10;i++) fps+=Times[i];
  fps = 10000/fps;

  /*
    sprintf(Buffer, "X: %d  Y: %d", Joystick->GetX(), Joystick->GetY());
    V->Write(0,-10,Buffer,strlen(Buffer));
  */
  sprintf(Buffer, "X: %d  Y: %d", Mouse->GetX(), Mouse->GetY());
  glTranslatef(0,0,-50);
  V->Write(0,5,Buffer,strlen(Buffer));
    
  /* Process input events here */
  if(Keys->GetButtons().KeyStatus[SCAN_ESC]) return true;  // QUIT?
  ButtonStatus &k = Keys->GetButtons();
  
  if(k.KeyStatus[SCAN_P]) Cam->TranslateR(0,0,30/fps);         // MOVES CAMERA
  else if(k.KeyStatus[SCAN_O]) Cam->TranslateR(0,0,-30/fps);
  
  if(k.KeyStatus[SCAN_A]) Cam->TranslateR(-30/fps,0,0);
  else if(k.KeyStatus[SCAN_D]) Cam->TranslateR(30/fps,0,0);
  
  if(k.KeyStatus[SCAN_W]) Cam->TranslateR(0,30/fps,0);
  else if(k.KeyStatus[SCAN_S]) Cam->TranslateR(0,-30/fps,0);
  
  if(k.KeyStatus[SCAN_RIGHT]) Cam->RotateAngle1(AV_Camera::HORIZONTAL, 30/fps);  // ROTATES CAMERA
  else if(k.KeyStatus[SCAN_LEFT]) Cam->RotateAngle1(AV_Camera::HORIZONTAL, -30/fps);
  
  if(k.KeyStatus[SCAN_UP]) Cam->RotateAngle1(AV_Camera::VERTICAL, 30/fps);
  else if(k.KeyStatus[SCAN_DOWN]) Cam->RotateAngle1(AV_Camera::VERTICAL, -30/fps);
  
  if(k.KeyStatus[SCAN_Q]) Cam->RotateAngle1(AV_Camera::ROLL, 30/fps);
  else if(k.KeyStatus[SCAN_E]) Cam->RotateAngle1(AV_Camera::ROLL, -30/fps);
  
  //if(k.KeyStatus[SCAN_SPACEBAR]) Sound->SFX(SoundEffects[rand()%nEffects]);
  
  /* Move Camera */
  Cam->Go();               /* Move Camera to proper position */

  /* DRAW THE WORLD! */
  glColor3ub(255,255,0);
  glDrawArrays(GL_POINTS, 0, nPoints);
  
  /* Now let's draw our text and other crap at the front pannel */  
  glDisable(GL_DEPTH_TEST);
  glLoadIdentity();        /* Makes origin the view again */
  glTranslatef(0,0,-50);    /* move back 50 points */
  glColor3ub(0,255,0);     /* text color */
  sprintf(Buffer, "%.1f fps", fps);
  V->Write(0, 0, Buffer, strlen(Buffer));  /* prints FPS */
  
  /* Makes workspace visible */
  glEnable(GL_DEPTH_TEST);
  V->FlipPages();
  return false;       /* Continue with next frame */
}
