/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#ifndef __KEY_H
#define __KEY_H

#define SCAN_ESC 		0x01
#define SCAN_1			0x02
#define SCAN_2			0x03
#define SCAN_3			0x04
#define SCAN_4			0x05
#define SCAN_5			0x06
#define SCAN_6			0x07
#define SCAN_7			0x08
#define SCAN_8			0x09
#define SCAN_9			0x0A
#define SCAN_0			0x0B
#define SCAN_MINUS		0x0C
#define SCAN_EQUAL		0x0D
#define SCAN_BACKSPACE	0x0E
#define SCAN_TAB		0x0F
#define SCAN_Q			0x10
#define SCAN_W			0x11
#define SCAN_E			0x12
#define SCAN_R			0x13
#define SCAN_T			0x14
#define SCAN_Y			0x15
#define SCAN_U			0x16
#define SCAN_I			0x17
#define SCAN_O			0x18
#define SCAN_P			0x19
#define SCAN_OPENSQUARE	0x1A		// [
#define SCAN_CLOSESQUARE 0x1B		// ]
#define SCAN_ENTER		0x1C
#define SCAN_CTRL		0x1D
#define SCAN_A			0x1E
#define SCAN_S			0x1F
#define SCAN_D			0x20
#define SCAN_F			0x21
#define SCAN_G			0x22
#define SCAN_H			0x23
#define SCAN_J			0x24
#define SCAN_K			0x25
#define SCAN_L			0x26
#define SCAN_SEMICOLON	0x27
#define SCAN_APOSTROPH	0x28		// next to enter
#define SCAN_TINDLE		0x29		// ~
#define SCAN_LSHIFT		0x2A
#define SCAN_BACKSLASH	0x2B		// back slash
#define SCAN_Z			0x2C
#define SCAN_X			0x2D
#define SCAN_C			0x2E
#define SCAN_V			0x2F
#define SCAN_B			0x30
#define SCAN_N			0x31
#define SCAN_M			0x32
#define SCAN_COMMA		0x33		// ,
#define SCAN_PERIOD		0x34
#define SCAN_SLASH		0x35		//  /
#define SCAN_RSHIFT		0x36
#define SCAN_KEY_STAR	0x37		// keypad *
#define SCAN_ALT		0x38
#define SCAN_SPACEBAR	0x39
#define SCAN_CAPS		0x3A
#define SCAN_F1			0x3B
#define SCAN_F2			0x3C
#define SCAN_F3			0x3D
#define SCAN_F4			0x3E
#define SCAN_F5			0x3F
#define SCAN_F6			0x40
#define SCAN_F7			0x41
#define SCAN_F8			0x42
#define SCAN_F9			0x43
#define SCAN_F10		0x44
#define SCAN_NUM_LOCK	0x45
#define SCAN_SCROLL_LOCK 0x46
#define SCAN_HOME		0x47
#define SCAN_UP			0x48
#define SCAN_PAGE_UP	0x49
#define SCAN_KEY_MINUS	0x4A	// keypad -
#define SCAN_LEFT		0x4B
#define SCAN_KEY_5		0x4C	// keypad 5
#define SCAN_RIGHT		0x4D
#define SCAN_KEY_PLUS	0x4E	// keypad +
#define SCAN_END		0x4F
#define SCAN_DOWN		0x50
#define SCAN_PAGE_DOWN	0x51
#define SCAN_INSERT		0x52
#define SCAN_DELETE		0x53
#define SCAN_SYSREQ		0x54
#define SCAN_F11		0x57
#define SCAN_F12		0x58
#define SCAN_F13		0x5B
#define SCAN_LWIN		0x5B	// left window button
#define SCAN_F14		0x5C
#define SCAN_RWIN		0x5C	// right window button
#define SCAN_F15		0x5D
#define SCAN_MENU		0x5D	// menu key

#endif
