/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <windows.h>
#include <gl/gl.h>
#pragma hdrstop
#include <av3d.hpp>

struct Font2Struct{
  int ListBase;
  HFONT hFont;

  int Size, Width;
  bool fBold, fItalic;
  const char *Name;
};

#ifdef __WINDOWS
struct OpenGLData{
  HDC    hDC;
  HGLRC  hRC;
  HWND   hWnd;
};
#endif
const char *DefCharFace = "System";

////////////////////////////////////////////////////////////
AV_Font :: AV_Font(AV_Font &f):V(f.V)
{
  Font2Struct *q;

  Data = q = new Font2Struct;
  memcpy(Data, f.Data, sizeof(Font2Struct));
  q->ListBase = glGenLists(256);
  q->hFont = CreateFont(q->Size, q->Width, 0, 0, 
			((q->fBold)?(FW_BOLD):(FW_NORMAL)),
			q->fItalic, FALSE, FALSE,   // italic, underline, strikeout
			ANSI_CHARSET,
			OUT_TT_PRECIS,
			CLIP_DEFAULT_PRECIS,
			ANTIALIASED_QUALITY,
			FF_DONTCARE|DEFAULT_PITCH,
			q->Name);
  
  SelectObject(V.GetPrivateData()->hDC, q->hFont);
  wglUseFontBitmaps(V.GetPrivateData()->hDC, 0, 256, q->ListBase);;
}
////////////////////////////////////////////////////////////
AV_Font :: AV_Font(AV_Video &v):V(v)
{
  AV_FontStruct s;
  s.FontFace = DefCharFace;
  s.Size = 12; s.fBold = false; s.Width=0;

  Font2Struct *q;
  Data = q = new Font2Struct;

  /* Builds a font */
  q->ListBase = glGenLists(256);

  q->Size = -s.Size;
  q->Width = s.Width;
  q->fBold = s.fBold;
  q->fItalic = s.fItalic;
  q->Name = s.FontFace;

  q->hFont = CreateFont(-s.Size, s.Width, 0, 0, 
			((s.fBold)?(FW_BOLD):(FW_NORMAL)),
			s.fItalic, FALSE, FALSE,   // italic, underline, strikeout
			ANSI_CHARSET,
			OUT_TT_PRECIS,
			CLIP_DEFAULT_PRECIS,
			ANTIALIASED_QUALITY,
			FF_DONTCARE|DEFAULT_PITCH,
			s.FontFace);
  
  if(V.GetPrivateData() == NULL)
    throw 1;        // BADLY INITIALIZED!! WILL FAIL!! MUST CALL AuxSetup() 
                    // from VIDEO!!!
  SelectObject(V.GetPrivateData()->hDC, q->hFont);
  wglUseFontBitmaps(V.GetPrivateData()->hDC, 0, 256, q->ListBase);
}
////////////////////////////////////////////////////////////
AV_Font :: AV_Font(AV_Video &v, AV_FontStruct &s):V(v)
{
  Font2Struct *q;
  Data = q = new Font2Struct;

  /* Builds a font */
  q->ListBase = glGenLists(256);

  q->Size = -s.Size;
  q->Width = s.Width;
  q->fBold = s.fBold;
  q->fItalic = s.fItalic;
  q->Name = s.FontFace;

  q->hFont = CreateFont(-s.Size, s.Width, 0, 0, 
			((s.fBold)?(FW_BOLD):(FW_NORMAL)),
			s.fItalic, FALSE, FALSE,   // italic, underline, strikeout
			ANSI_CHARSET,
			OUT_TT_PRECIS,
			CLIP_DEFAULT_PRECIS,
			ANTIALIASED_QUALITY,
			FF_DONTCARE|DEFAULT_PITCH,
			s.FontFace);
  
  if(V.GetPrivateData() == NULL)
    throw 1;        // BADLY INITIALIZED!! WILL FAIL!! MUST CALL AuxSetup() 
                    // from VIDEO!!!
  SelectObject(V.GetPrivateData()->hDC, q->hFont);
  wglUseFontBitmaps(V.GetPrivateData()->hDC, 0, 256, q->ListBase);
}
////////////////////////////////////////////////////////////
AV_Font :: ~AV_Font()
{
  Font2Struct *q = Data;
  if(V.GetPrivateData() != NULL){
    SelectObject(V.GetPrivateData()->hDC, GetStockObject(SYSTEM_FONT));
    glDeleteLists(q->ListBase, 256);
  }
  if(q->hFont != NULL)
    DeleteObject(q->hFont);

  delete Data;
}
////////////////////////////////////////////////////////////
void AV_Font :: Write(int x, int y, const char* str, int len)
{
  glRasterPos2i(x,y);
  SelectObject(V.GetPrivateData()->hDC, 
	       Data->hFont);
  
  glPushAttrib(GL_LIST_BIT);
  glListBase(Data->ListBase);
  glCallLists(len, GL_UNSIGNED_BYTE, str);
  glPopAttrib();
}
////////////////////////////////////////////////////////////
void AV_Font :: WriteFormatted(int x, int y, const char *str, int len)
{
  Write(x,y,str,len);
}
