/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <windows.h>
#include <gl/gl.h>
#pragma hdrstop
#include <av3d.hpp>


struct KeyboardStruct{
  LPDIRECTINPUTDEVICE7 Keyboard;

  bool ButtonStatus[256];
};

struct OpenGLData{
  HDC    hDC;
  HGLRC  hRC;
  HWND   hWnd;
};

////////////////////////////////////////////////////////////
AV_Keyboard :: AV_Keyboard(AV_Video &v):AV_Controller(v)
{
  // allocates keyboard status
  kb = new KeyboardStruct;

  // intializes the system keyboard
  _av3d_::DirectInput->CreateDeviceEx(GUID_SysKeyboard, 
				      IID_IDirectInputDevice7,
				      (void**)&kb->Keyboard, NULL);

  kb->Keyboard->SetDataFormat(&c_dfDIKeyboard);
  kb->Keyboard->SetCooperativeLevel(v.GetPrivateData()->hWnd, 
				    DISCL_FOREGROUND | DISCL_EXCLUSIVE);
  __GetState();
}
////////////////////////////////////////////////////////////
AV_Keyboard :: ~AV_Keyboard()
{
  kb->Keyboard->Unacquire();
  kb->Keyboard->Release();
  delete kb;
}
////////////////////////////////////////////////////////////
void AV_Keyboard :: __GetState()
{
  BYTE s[256];
  
  switch(kb->Keyboard->Poll())
    {
    case DIERR_NOTACQUIRED:
    case DIERR_INPUTLOST:
      kb->Keyboard->Acquire();
      break;
      //    default:
    case DI_NOEFFECT:
    case DI_OK:
      kb->Keyboard->GetDeviceState(sizeof(s), s);
      
      int i;
      for(i=0;i<256;++i)
	kb->ButtonStatus[i] = s[i]&0x80;
    }
}  
////////////////////////////////////////////////////////////
void AV_Keyboard :: Center()
{
}
////////////////////////////////////////////////////////////
ButtonStatus& AV_Keyboard :: GetButtons()
{
  __GetState();
  return *(ButtonStatus*)kb->ButtonStatus;
}
////////////////////////////////////////////////////////////
int AV_Keyboard :: GetX()
{
  __GetState();
  if(kb->ButtonStatus[DIK_RIGHT])
    return 1000;
  else if(kb->ButtonStatus[DIK_LEFT])
    return -1000;

  return 0;
}
////////////////////////////////////////////////////////////
int AV_Keyboard :: GetY()
{
  __GetState();
  if(kb->ButtonStatus[DIK_UP])
    return 1000;
  else if(kb->ButtonStatus[DIK_DOWN])
    return -1000;
  
  return 0;
}
////////////////////////////////////////////////////////////
void AV_Keyboard :: Reset()
{
}
