/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <windows.h>
#include <gl/gl.h>
#pragma hdrstop
#include <av3d.hpp>


struct MouseStruct{
  LPDIRECTINPUTDEVICE7 Mouse;
  //  MouseState State;
  JoystickState State;
  int cx,cy,cz;
};

struct OpenGLData{
  HDC    hDC;
  HGLRC  hRC;
  HWND   hWnd;
};

////////////////////////////////////////////////////////////
AV_Mouse :: AV_Mouse(AV_Video &v):AV_Controller(v)
{
  // allocates struct
  ms = new MouseStruct;

  // creates a mouse device
  if(FAILED(_av3d_::DirectInput->CreateDeviceEx(GUID_SysMouse, IID_IDirectInputDevice7, (void**)&ms->Mouse, NULL)))
    throw AV_Exception(AV_Exception::CANT_INITIALIZE_DEVICE);

  // sets proper struct and input of device
  ms->Mouse->SetDataFormat(&c_dfDIMouse);
  //  ms->Mouse->SetDataFormat(&c_dfDIJoystick );
  ms->Mouse->SetCooperativeLevel(v.GetPrivateData()->hWnd,
				 DISCL_EXCLUSIVE | DISCL_FOREGROUND);
				 
  ms->cx= ms->cz= ms->cy=0;

  int i;
  for(i=0;i<256;++i)
    ms->State.Buttons[i] = false;

  // centers mouse
  Center();
}
////////////////////////////////////////////////////////////
AV_Mouse :: ~AV_Mouse()
{
  // releases mouse
  ms->Mouse->Unacquire();
  ms->Mouse->Release();
  delete ms;
}
////////////////////////////////////////////////////////////
void AV_Mouse :: __GetState()
{
  DIMOUSESTATE s;

  switch(ms->Mouse->Poll())
    {
    case DIERR_NOTACQUIRED:
    case DIERR_INPUTLOST:
      ms->Mouse->Acquire();
      break;
    case DI_NOEFFECT:
    case DI_OK:
      ms->Mouse->GetDeviceState(sizeof(DIMOUSESTATE), &s);

      // stores in local struct
      ms->State.x += s.lX;
      ms->State.y += s.lY;
      ms->State.z += s.lZ;
      
      int i;
      for(i=0;i<4;++i)
	ms->State.Buttons[i] = s.rgbButtons[i]!=0;
      
    }
}
////////////////////////////////////////////////////////////
void AV_Mouse :: Center()
{
  // sets current position as center
  __GetState();
  
  ms->cz = ms->State.z;
  ms->cy = ms->State.y;
  ms->cx = ms->State.x;
}
////////////////////////////////////////////////////////////
ButtonStatus& AV_Mouse :: GetButtons()
{
  // retunrs mouse button status
  return *(ButtonStatus*)ms->State.Buttons;
}
////////////////////////////////////////////////////////////
int AV_Mouse :: GetX()
{
  __GetState();
  return ms->State.x - ms->cx;
}
////////////////////////////////////////////////////////////
int AV_Mouse :: GetY()
{
  __GetState();
  return ms->State.y - ms->cy;
}
////////////////////////////////////////////////////////////
void AV_Mouse :: Reset()
{
  Center();
}
