/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <windows.h>
#include <gl/gl.h>
#pragma hdrstop
#define __MAIN_INTERFACE
#include <av3d.hpp>
#include <gl/glu.h>

HINSTANCE	hInstance;   // Holds The Instance Of The Application

//bool fActive;
const char *ClassName = "AV3D";
LRESULT CALLBACK WndProc(HWND	hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);


void ___internal_controller_setup();
void ___internal_controller_unsetup();
void ___internal_sound_setup();
void ___internal_sound_unsetup();

/**********************************************************/
#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE, LPSTR CmdLine, int)
{
  bool done = FALSE;
  MSG  msg;

  /* Calls the main init function */
  ::hInstance = hInstance; // must be set BEFORE callsing init function for av3d
  ___internal_controller_setup();
  ___internal_sound_setup();

  /* Creates window class */
  WNDCLASS wc;

  wc.style   = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
  wc.lpfnWndProc	= WndProc;
  wc.cbClsExtra		= 0;
  wc.cbWndExtra		= 0;
  wc.hInstance		= hInstance;
  wc.hIcon		= LoadIcon(NULL, IDI_WINLOGO);
  wc.hCursor		= LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground	= NULL;
  wc.lpszMenuName	= NULL;
  wc.lpszClassName	= "OpenGL";

  if (!RegisterClass(&wc)){
    MessageBox(NULL,"Failed To Register The Window Class.",
	       "ERROR",MB_OK|MB_ICONEXCLAMATION);
    return FALSE;
  }
  if(AV3D_InitProc()) done=TRUE;

  // goes into the loop mode here
  while(!done){// Loop That Runs While done=FALSE
    if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)){
      if (msg.message==WM_QUIT){// Have We Received A Quit Message?
	done=TRUE;// If So done=TRUE
      }
      else// If Not, Deal With Window Messages
	DispatchMessage(&msg);// Dispatch The Meessage
    }
    
    // calls the game loop
    if(/*fActive &&*/ AV3D_MainLoop())
      done=TRUE;
  }
  
  AV3D_EndProc();
  UnregisterClass("OpenGL", hInstance);

  /* unregisters AV3d internal structures */
  ___internal_sound_unsetup();
  ___internal_controller_unsetup();
  return 0;
}

/***********************************************************/
LRESULT CALLBACK WndProc(HWND	hWnd,	    // Handle For This Window
			 UINT	uMsg,	    // Message For This Window
			 WPARAM	wParam,	    // Additional Message Information
			 LPARAM	lParam)	    // Additional Message Information
{
  switch (uMsg){// Check For Windows Messages
  case WM_SYSCOMMAND:// Intercept System Commands
    {
      switch (wParam)             // Check System Calls
	{
	case SC_SCREENSAVE:       // Screensaver Trying To Start?
	case SC_MONITORPOWER:     // Monitor Trying To Enter Powersave?
	  return 0;               // Prevent From Happening
	}
      break;	
    }
    
  case WM_CLOSE:                  // Did We Receive A Close Message?
    {
      PostQuitMessage(0);
      return 0;
    }
    /*    
  case WM_KILLFOCUS:
    fActive = false;
    break;
    */
  case WM_PAINT:
    AV3D_MainLoop();
    break;
    
  case WM_SETFOCUS:
    //    fActive = true;
    SetForegroundWindow(hWnd);
    break;
    
  case WM_SIZE:                   // Resize The OpenGL Window
    {
      if(HIWORD(lParam) == 0) // makes H at least 1
	lParam |= 0x10000;
      
      glViewport(0,0,LOWORD(lParam), HIWORD(lParam));
      glMatrixMode(GL_PROJECTION);
      glLoadIdentity();
      
      // Calculate aspect ratio of the window
      gluPerspective(35.0, (double)LOWORD(lParam)/(double)HIWORD(lParam), 
		     0.1, 2000.0);
      
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
      return 0;
    }
  }
  
  // Pass All Unhandled Messages To DefWindowProc
  return DefWindowProc(hWnd,uMsg,wParam,lParam);
}
