/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <windows.h>
#include <gl/gl.h>
#pragma hdrstop
#include <av3d.hpp>
#include <mmsystem.h>

int AV_Timer::Count=0;

namespace AV_Timer_Cpp{
  unsigned long Timer = 0;
  UINT TimerID;
};

//AV_Timer GlobalTimer;
////////////////////////////////////////////////////////////
void __stdcall ___TimerCallback(UINT, UINT, ULONG, ULONG, ULONG)
//void CALLBACK ___TimerCallback(HWND, UINT,UINT,DWORD)
{
  ++AV_Timer_Cpp::Timer;
}
////////////////////////////////////////////////////////////
AV_Timer :: AV_Timer()
{
  if(Count++ == 0){
    AV_Timer_Cpp::TimerID = (UINT)timeSetEvent(8, 8, ___TimerCallback, 
					       0, TIME_PERIODIC);
    if(AV_Timer_Cpp::TimerID == NULL){
      timeKillEvent(AV_Timer_Cpp::TimerID);
      AV_Timer_Cpp::TimerID = (UINT)timeSetEvent(8, 8, ___TimerCallback, 
						 0, TIME_PERIODIC);
      if(AV_Timer_Cpp::TimerID == NULL)
	throw AV_Exception(AV_Exception::CANNOT_INITIALIZE_TIMER);
    }
  }
  
  ResetFrame();
}
////////////////////////////////////////////////////////////
AV_Timer :: ~AV_Timer()
{
  if(--Count == 0){
    timeKillEvent(AV_Timer_Cpp::TimerID);
    AV_Timer_Cpp::Timer = 0;
  }
}
////////////////////////////////////////////////////////////
unsigned long AV_Timer::GetTime()
{
  return (AV_Timer_Cpp::Timer - Time) << 3;
}
////////////////////////////////////////////////////////////
void AV_Timer :: ResetFrame()
{
  Time = AV_Timer_Cpp::Timer;
}
