/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

/* NOTES: All of the video redefinitions used in the Windows OS       */
/*        under OpenGL are defined here. DirectX is not used because  */
/*        I don't like it! :)                                         */

#include <windows.h>
#include <gl/gl.h>
#pragma hdrstop
#include <gl/glu.h>
#include <gl/glaux.h>
#include <math.h>
#include <av3d.hpp>

extern HINSTANCE hInstance;
LRESULT CALLBACK WndProc(HWND	hWnd,	    // Handle For This Window
			 UINT	uMsg,	    // Message For This Window
			 WPARAM	wParam,	    // Additional Message Information
			 LPARAM	lParam);    // Additional Message Information

struct OpenGLData{
  HDC    hDC;
  HGLRC  hRC;
  HWND   hWnd;
};
//const char AV3DApp[] = "AV3D Application";
extern const char *ClassName;

////////////////////////////////////////////////////////////
AV_Video :: AV_Video(const char*title, int w , int h , int d, bool f)
{
  /* Initialize video mode to the current specifications
   */
  fSet = false;
  try{
    SetVideoMode(title,w,h,d,f);
  }
  catch(...){
    fprintf(stderr, "Cannot initialize video - Application will be terminated\n");
    throw 1;
  }
}
////////////////////////////////////////////////////////////
AV_Video :: ~AV_Video()
{
  /* Kills the AV video */
  RestoreVideoMode();
  if(Font != NULL) delete Font;
}  
////////////////////////////////////////////////////////////
void AV_Video :: ClearScreen()
{
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();
}
////////////////////////////////////////////////////////////
void AV_Video :: FlipPages()
{ 
  glFinish();
  SwapBuffers(Data->hDC);
}
////////////////////////////////////////////////////////////
OpenGLData const* AV_Video :: GetPrivateData()
{	
  // returns HWND data for windows
  return Data;
}
////////////////////////////////////////////////////////////
void AV_Video :: RestoreVideoMode()
{
  if(fSet==false) return;
  if(fFullScreen)
    ChangeDisplaySettings(NULL, 0);

  wglMakeCurrent(NULL, NULL);
  wglDeleteContext(Data->hRC);
  ReleaseDC(Data->hWnd, Data->hDC);
  DestroyWindow(Data->hWnd);
  delete Data;
  delete Font;
  Font = NULL;
  ShowCursor(TRUE);
}
////////////////////////////////////////////////////////////
void AV_Video :: SetFont(AV_Font &f)
{
  delete Font;
  Font = new AV_Font(f);
}
////////////////////////////////////////////////////////////
void AV_Video :: SetVideoMode(const char*n, int W, int H, int D, bool f)
{
  
  if(fSet==true) return;
  w=W; h=H; d=D; fFullScreen=f;
  
  Data = new OpenGLData;
  
  // Allocates the proper GL window in windows
  unsigned int PixelFormat;
  DWORD dwExStyle;
  DWORD dwStyle;
  RECT  WindowRect;
  
  WindowRect.left = WindowRect.top = 0;
  WindowRect.right = w;  WindowRect.bottom = h;
  
  if(fFullScreen){
    DEVMODE scr;
    
    memset(&scr, 0, sizeof(scr));
    scr.dmSize        = sizeof(scr);
    scr.dmPelsWidth   = w;
    scr.dmPelsHeight  = h;
    scr.dmBitsPerPel  = d;
    scr.dmFields      = DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
    
    //if(ChangeDisplaySettings(&scr,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL){
    if(ChangeDisplaySettings(&scr,0)!=DISP_CHANGE_SUCCESSFUL)
      fFullScreen = false;
  }
  
  // sets up proper style
  if(fFullScreen){
    dwExStyle=WS_EX_APPWINDOW | WS_EX_TOPMOST;
    dwStyle=WS_POPUP;
    ShowCursor(FALSE);
  }
  else{
    dwExStyle=WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;
    dwStyle=WS_OVERLAPPEDWINDOW;
  }
  
  AdjustWindowRectEx(&WindowRect, dwStyle, 0, dwExStyle);
  
  // Creates window
  Data->hWnd = CreateWindowEx(dwExStyle,
			      "OpenGL",
			      n,
			      dwStyle,
			      0, 0,
			      w, h,
			      HWND_DESKTOP, 
			      0,
			      hInstance,
			      NULL);
  if(!Data) throw 1;
  
  PIXELFORMATDESCRIPTOR pdf={
    sizeof(PIXELFORMATDESCRIPTOR),
    1,             // version
    PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER,
    PFD_TYPE_RGBA,
    (BYTE)d,
    0,0,0,0,0,0,   // colour bits ignored
    0,             // no alpha buffer
    0,             // no shift
    0,             // no accumulation buffer
    0,0,0,0,       // accumulation bits ignored
    16,            // 16 bit depth buffer
    0,             // no stncil buffer
    0,             // no aux buffer
    PFD_MAIN_PLANE,// drawing plane
    0,             // reserved
    0,0,0          // layer masks ignored
    };
  fprintf(stderr, "One\n");
  Data->hDC = GetDC(Data->hWnd);
  if(!Data->hDC) throw 1;
  PixelFormat = ChoosePixelFormat(Data->hDC, &pdf);
  if(!PixelFormat) throw 1;
  SetPixelFormat(Data->hDC, PixelFormat, &pdf);
  fprintf(stderr, "One\n");
  // create rendering context
  Data->hRC = wglCreateContext(Data->hDC);
  if(!Data->hRC) throw 1;
  wglMakeCurrent(Data->hDC, Data->hRC);
  
  ShowWindow(Data->hWnd, SW_SHOW);
  SetForegroundWindow(Data->hWnd);
  SetFocus(Data->hWnd);
  PostMessage(Data->hWnd, WM_SIZE, SIZE_MAXSHOW, w | (h << 16));
  
  fprintf(stderr, "One\n");

  // Initializes the GL Window
  glShadeModel(GL_SMOOTH);
  glClearColor(0,0,0,0);
  
  glClearDepth(1.0);          // Depth Buffer Setup
  glEnable(GL_DEPTH_TEST);    // depth testing
  glDepthFunc(GL_LEQUAL);     // type of depth test to do
  
  // sets up font properly
  Font = new AV_Font(*this);
  ShowCursor(FALSE);
  fSet = true;
}
////////////////////////////////////////////////////////////
void AV_Video :: Write(int x, int y, const char *s, int len)
{
  Font->Write(x,y,s,len);
}
////////////////////////////////////////////////////////////
void AV_Video :: WriteFormatted(int x, int y, const char *s, int len)
{
  Font->WriteFormatted(x,y,s,len);
}
