/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <av3d.hpp>
#include <X11/Xlib.h>
#include <GL/glx.h>

#include "internals.h"

const char DefCharFace[] = "fixed";

struct Font2Struct{
  int FontBase;
  char Name[256];
  Font font;
  int first, last;
};

////////////////////////////////////////////////////////////
AV_Font :: AV_Font(AV_Font &f):V(f.V)
{
  OpenGLData const*d = V.GetPrivateData();
  
  XFontStruct *fontInfo;
  Display *dpy = d->disp;
  
  Data = new Font2Struct;
  memcpy(Data, f.Data, sizeof(Font2Struct));
  
  fontInfo = XLoadQueryFont(dpy, Data->Name);
  if (!fontInfo) {
    fprintf(stderr, "Error: font %s not found\n", Data->Name);
    exit(0);
  }
  
  Data->font = fontInfo->fid;
  Data->first = fontInfo->min_char_or_byte2;
  Data->last = fontInfo->max_char_or_byte2;
  
  Data->FontBase = glGenLists((GLuint) Data->last + 1);
  if (!Data->FontBase) {
    fprintf(stderr, "Error: unable to allocate display lists\n");
    exit(0);
  }
  glXUseXFont(Data->font, Data->first, Data->last - Data->first + 1, Data->FontBase + Data->first);
}
////////////////////////////////////////////////////////////
AV_Font :: AV_Font(AV_Video &v):V(v)
{
  OpenGLData const*d = V.GetPrivateData();

  XFontStruct *fontInfo;
  Display *dpy = d->disp;
  
  Data = new Font2Struct;
  
  fontInfo = XLoadQueryFont(dpy, DefCharFace);
  if (!fontInfo) {
    fprintf(stderr, "Error: font %s not found\n", DefCharFace);
    exit(0);
  }
  
  Data->font = fontInfo->fid;
  Data->first = fontInfo->min_char_or_byte2;
  Data->last = fontInfo->max_char_or_byte2;
  
  Data->FontBase = glGenLists((GLuint) Data->last + 1);
  if (!Data->FontBase) {
    fprintf(stderr, "Error: unable to allocate display lists\n");
    exit(0);
  }
  glXUseXFont(Data->font, Data->first, Data->last - Data->first + 1, Data->FontBase + Data->first);  
}
////////////////////////////////////////////////////////////
AV_Font :: AV_Font(AV_Video &v, AV_FontStruct &s):V(v)
{
  //FIXME: allocate font here
  
  XFontStruct *fontInfo; 
  OpenGLData const*d = V.GetPrivateData();
  Display *dpy = d->disp;
  
  Data = new Font2Struct;
  
  fontInfo = XLoadQueryFont(dpy, DefCharFace);
  if (!fontInfo) {
    fprintf(stderr, "Error: font %s not found\n", DefCharFace);
    exit(0);
  }
  
  Data->font = fontInfo->fid;
  Data->first = fontInfo->min_char_or_byte2;
  Data->last = fontInfo->max_char_or_byte2;
  
  Data->FontBase = glGenLists((GLuint) Data->last + 1);
  if (!Data->FontBase) {
    fprintf(stderr, "Error: unable to allocate display lists\n");
    exit(0);
  }
  glXUseXFont(Data->font, Data->first, Data->last - Data->first + 1, Data->FontBase + Data->first);  
  
}
////////////////////////////////////////////////////////////
AV_Font :: ~AV_Font()
{
  if(Data != NULL)
    glDeleteLists(Data->FontBase, Data->last - Data->first + 1);
   
  delete Data; 
}
////////////////////////////////////////////////////////////
void AV_Font :: Write(int x, int y, const char* str, int len)
{
  glRasterPos2i(x,y);
  glPushAttrib(GL_LIST_BIT);
  glListBase(Data->FontBase);
  glCallLists(len, GL_UNSIGNED_BYTE, str);
  glPopAttrib();
}
////////////////////////////////////////////////////////////
void AV_Font :: WriteFormatted(int x, int y, const char *str, int len)
{
  Write(x,y,str,len);
}
