/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <av3d.hpp>
#include <X11/extensions/XInput.h>
#include "internals.h"

struct JoyStruct{
  JoystickState State;
  XDevice *dev;
};

namespace __AV_Joystick_namespace{
  XEventClass EventList[]={0};
  const int nEvents=0;

  int nDevices;
};


////////////////////////////////////////////////////////////
AV_Joystick :: AV_Joystick(AV_Video &v, ControllerData nJoy)
  : AV_Controller(v)
{
  js = new JoyStruct;

  // gets the device with the appropriate id
  js->dev = XOpenDevice(disp, static_cast<XID>(nJoy));

  // grabs the device now
  OpenGLData const*Data = v.GetPrivateData();
  XGrabDevice(disp, js->dev, Data->win, true, 
	      __AV_Joystick_namespace::nEvents, 
	      __AV_Joystick_namespace::EventList,
	      GrabModeAsync, GrabModeAsync, CurrentTime);
}
////////////////////////////////////////////////////////////
AV_Joystick :: ~AV_Joystick()
{
  XCloseDevice(disp, js->dev);
  delete js;
}
////////////////////////////////////////////////////////////
void AV_Joystick :: Center()
{
  // does nothin here - joysticks are not cented.... at least
  // not by software :)
}
////////////////////////////////////////////////////////////
int AV_Joystick :: EnumDevices(EnumControllerProc EnumProc)
{
  // lists all of the devices that are not XI_MOUSE or XI_KEYBOARD
  int nList = 128;
  XDeviceInfo *Devices = XListInputDevices(disp, &nList);

  for(int i=0;i<nList;i++)
    if(Devices[i].use!=IsXKeyboard &&
       Devices[i].use!=IsXPointer)
      if(!EnumProc(Devices[i].id, UNKNOWN, Devices[i].name, Devices[i].name))
	break;
  
  XFreeDeviceList(Devices);
  return 0;
}
////////////////////////////////////////////////////////////
ButtonStatus& AV_Joystick :: GetButtons()
{
  return *(ButtonStatus*)(js->State.Buttons);
}
////////////////////////////////////////////////////////////
void AV_Joystick :: ___GetState()
{
  /* Gets current position of the joystick device.. This is
   * updated max. 20 times per second to speed up things.
   */

}
////////////////////////////////////////////////////////////
const JoystickState& AV_Joystick :: GetState()
{
  return js->State;
}
////////////////////////////////////////////////////////////
int AV_Joystick :: GetX()
{
  return js->State.x;
}
////////////////////////////////////////////////////////////
int AV_Joystick :: GetY()
{
  return js->State.y;
}
////////////////////////////////////////////////////////////
void AV_Joystick :: Reset()
{
 
}
////////////////////////////////////////////////////////////
