/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <av3d.hpp>
#include <X11/Xlib.h>
#include "internals.h"
#include <string.h>

struct KeyboardStructure{};

extern bool ___kb_ButtonStatus[256];
int MinKeycode, MaxKeycode;
XKeyboardState state;
////////////////////////////////////////////////////////////
void ___Updatekb()
{
  /* Updates keyboard state */
  char Buffer[32];
  XQueryKeymap(disp, Buffer);
  
  for(int i=MinKeycode>>3;i<MaxKeycode>>3;i++)
    for(int j=0;j<8;j++){
      ___kb_ButtonStatus[(i<<3)+j - MinKeycode] = Buffer[i]&1;
      Buffer[i] >>= 1;
    }
}
////////////////////////////////////////////////////////////
AV_Keyboard :: AV_Keyboard(AV_Video &v):AV_Controller(v)
{
  // Grapbs the keyboard
  OpenGLData const*d = v.GetPrivateData();
  XGetKeyboardControl(V.GetPrivateData()->disp, &state);
  if(XGrabKeyboard(d->disp, d->win, GrabModeAsync, false, GrabModeAsync,
  		   CurrentTime))
    throw AV_Exception(AV_Exception::CANNOT_GRAB_KEYBOARD);
  
  memset(___kb_ButtonStatus, 0, sizeof(bool)*256);
  // turns auto repeat off
  XAutoRepeatOff(disp);
  XDisplayKeycodes(d->disp, &MinKeycode, &MaxKeycode);
}
////////////////////////////////////////////////////////////
AV_Keyboard :: ~AV_Keyboard()
{
  OpenGLData const*d = V.GetPrivateData();
  XUngrabKeyboard(d->disp, d->win);
  if(state.global_auto_repeat==AutoRepeatModeOn)
    XAutoRepeatOn(d->disp); // was on in normal circumstances :) so turn it back on
}
////////////////////////////////////////////////////////////
void AV_Keyboard :: __GetState()
{
}  
////////////////////////////////////////////////////////////
void AV_Keyboard :: Center()
{
}
////////////////////////////////////////////////////////////
ButtonStatus& AV_Keyboard :: GetButtons()
{
  return *(ButtonStatus*)___kb_ButtonStatus;
}
////////////////////////////////////////////////////////////
int AV_Keyboard :: GetX()
{
  if(___kb_ButtonStatus[SCAN_RIGHT])
    return 1000;
  else if(___kb_ButtonStatus[SCAN_LEFT])
    return -1000;

  return 0;
}
////////////////////////////////////////////////////////////
int AV_Keyboard :: GetY()
{
  if(___kb_ButtonStatus[SCAN_UP])
    return 1000;
  else if(___kb_ButtonStatus[SCAN_DOWN])
    return -1000;
  
  return 0;
}
////////////////////////////////////////////////////////////
void AV_Keyboard :: Reset()
{
}
