/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <av3d.hpp>
#include <X11/Xlib.h>
#include "internals.h"
#include <X11/cursorfont.h>
#include <string.h>

struct MouseStruct{
  //  MouseState State;
  JoystickState State;
  int cx,cy,cz;

  int mx,my; // ceter positions for mouse - theses are static
};

#ifndef ABS
#define ABS(a) ((a<0)?(-(a)):(a))
#endif

int MouseX, MouseY;
////////////////////////////////////////////////////////////
AV_Mouse :: AV_Mouse(AV_Video &v):AV_Controller(v)
{
  // allocates struct
  ms = new MouseStruct;
  ms->cx= ms->cz= ms->cy=0;
  
  ms->mx = V.GetWidth()/2;
  ms->my = V.GetWidth()/2;

  int i;
  for(i=0;i<256;++i)
    ms->State.Buttons[i] = false;
  
  // grabs pointer
  if(XGrabPointer(V.GetPrivateData()->disp, V.GetPrivateData()->win,
	          false, 0, GrabModeAsync, GrabModeAsync, 
	          None, None, CurrentTime) == GrabSuccess)
    fprintf(stderr, "XGrabPointer - success\n");
  else
    fprintf(stderr, "XGrabPointer - FAILED\n");
  
  // centers mouse
  __GetState(); __GetState(); // make sure all set
  Center();

  Pixmap pix;
  XColor fg;
  memset(&fg, 0, sizeof(XColor));
  pix = XCreatePixmap(V.GetPrivateData()->disp, V.GetPrivateData()->win, 1, 1, 1);
  XDefineCursor(V.GetPrivateData()->disp, V.GetPrivateData()->win,
                XCreatePixmapCursor(V.GetPrivateData()->disp, pix, pix, &fg, &fg, 0,0));
  XFreePixmap(V.GetPrivateData()->disp, pix);
}  
////////////////////////////////////////////////////////////
AV_Mouse :: ~AV_Mouse()
{
  // releases mouse
  XUngrabPointer(V.GetPrivateData()->disp, CurrentTime);
  delete ms;
}
////////////////////////////////////////////////////////////
void AV_Mouse :: __GetState()
{
  /* Retries the mouse information and warps the pointer
   * to the middle of the scren.
   */

  Window rt, wnd;
  int rt_x, rt_y, wnd_x, wnd_y;
  unsigned int mask;

  static int last_x, last_y;

  XQueryPointer(V.GetPrivateData()->disp, V.GetPrivateData()->win,
    		&rt, &wnd,
		&rt_x, &rt_y, &wnd_x, &wnd_y, &mask);
  
  ms->State.Buttons[0] = mask & Button1Mask;
  ms->State.Buttons[1] = mask & Button2Mask;
  ms->State.Buttons[2] = mask & Button3Mask;
  ms->State.Buttons[3] = mask & Button4Mask;
  ms->State.Buttons[4] = mask & Button5Mask;

  int posx = wnd_x - last_x;
  int posy = wnd_y - last_y;
  
  ms->State.x += posx;
  ms->State.y += posy;
  
  if(ABS(ms->mx - last_x)>(ms->mx>>1) || ABS(ms->my - last_y)>(ms->my>>1)){
    XWarpPointer(V.GetPrivateData()->disp, None, V.GetPrivateData()->win,
		 0,0,0,0,ms->mx, ms->my);
    last_x = ms->mx;
    last_y = ms->my;
  }
  else{
    last_x = wnd_x;
    last_y = wnd_y;
  }
}
////////////////////////////////////////////////////////////
void AV_Mouse :: Center()
{
  // sets current position as center
  __GetState();
  
  ms->cz = ms->State.z;
  ms->cy = ms->State.y;
  ms->cx = ms->State.x;
}
////////////////////////////////////////////////////////////
ButtonStatus& AV_Mouse :: GetButtons()
{
  // retunrs mouse button status
  __GetState();
  return *(ButtonStatus*)ms->State.Buttons;
}
////////////////////////////////////////////////////////////
int AV_Mouse :: GetX()
{
  __GetState();
  return ms->State.x - ms->cx;
}
////////////////////////////////////////////////////////////
int AV_Mouse :: GetY()
{
  __GetState();
  return ms->State.y - ms->cy;
}
////////////////////////////////////////////////////////////
void AV_Mouse :: Reset()
{
  Center();
}
