/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#define __MAIN_INTERFACE
#include <av3d.hpp>
#include <GL/glu.h>
#include <X11/Xlib.h>
#include <pthread.h>

//const char ClassName[] = "AV3D App";
Display *disp;

void ___internal_controller_setup();
void ___internal_controller_unsetup();
void ___internal_sound_setup();
void ___internal_sound_unsetup();

void ___Updatekb();

bool ___kb_ButtonStatus[256];
bool fFocus = true; // if false then program is "stopped" until window received focus back
Window CurWindow = 0;
// = static_cast<window>(0);

/**********************************************************/
int main(...)
{
  // attempts to connect to the server
  disp = XOpenDisplay(NULL);
  if(disp == NULL){
    fprintf(stderr, "Can't open display.");
    return 0;
  }

  // internal initializations
  ___internal_controller_setup();
  ___internal_sound_setup();
  
  // initializes the program
  XEvent E;
  if(!AV3D_InitProc()){

    // creates another thread just to handle events
    //pthread_t EventHandler;
    //  pthread_create(&EventHandler, NULL, ___av3d_EventHandler, NULL);

    while(!AV3D_MainLoop()){
      while(XCheckMaskEvent(disp, 0xFFFF, &E) == true){
      	fprintf(stderr, "Debug -- OS_Interface: Event Received.\n");
	
	switch(E.type)
	  {
	  case FocusIn:
	    if(E.xfocus.display == disp && 
	       E.xfocus.window  == CurWindow)
	      fFocus = true;
	    break;
	  case FocusOut:
	    if(E.xfocus.display == disp && 
	       E.xfocus.window  == CurWindow)
	      fFocus = false;
	    break;
	  case ConfigureNotify:
	    glViewport( 0, 0, E.xconfigure.width, E.xconfigure.height);
	    break;
	    /*  
		case MotionNotify:
		// motion event of the mouse
		break;
	    */
	  default:
	    break;
	  }
      }
      if(!fFocus) continue;

      // updates keyboard status now
      ___Updatekb();
    }
    AV3D_EndProc();
  }

  // internal closeups
  ___internal_sound_unsetup();
  ___internal_controller_unsetup();
  
  // disconnects from the server
  XCloseDisplay(disp);
  return 0;
}
