/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/*                                                                   */
/*    AV3D - OS-Independent wrapper with OpenGL support              */
/*    Copyright (c)2001 Galactica Software                           */
/*    ALL RIGHTS RESERVED.                                           */
/*                                                                   */
/*    Programmers: Adam Majer (adamm@galacticasoftware.com)          */
/*                                                                   */
/*    This source code and related compilations are distributed      */
/*    under the terms of LPGL. For license see "license.txt" enclosed*/
/*    or go to "http://www.gnu.org/copyleft/lesser.html"             */
/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*                                                                   */
/* -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- */

#include <av3d.hpp>
#include <pthread.h>
#include <sys/time.h>
//#include <sys/types.h>
#include <unistd.h>


int AV_Timer::Count=0;

namespace AV_Timer_Cpp{
  unsigned long Timer = 0;
  pthread_t TimerID;
  
  struct timeval tv;
  struct timezone tz;


#ifdef __RTL_SCHED__
  #include <rtl_sched.h>
#endif
};

AV_Timer GlobalTimer;
////////////////////////////////////////////////////////////
#ifdef __RTL_SCHED__
void *TimerProc(void*)
{
  for(;;){
    AV_Timer_Cpp::Timer += TIME_PERIODIC;
    pthread_wait_np();
  }
}
#endif
////////////////////////////////////////////////////////////
AV_Timer :: AV_Timer()
{
#ifdef __RTL_SCHED__
  if(Count++ == 0){
    pthread_create(AV_Timer_Cpp::TimerID, NULL, TimerProc, NULL);
    pthread_make_periodic_np(AV_Timer_Cpp::TimerID, 
			     gethrtime()+TIME_PERIODIC*1000000,
			     TIME_PERIODIC*1000000);
  }
#endif
  
  ResetFrame();
}
////////////////////////////////////////////////////////////
AV_Timer :: ~AV_Timer()
{
#ifdef __RTL_SCHED__
  if(--Count == 0){
    pthread_kill(AV_Timer_Cpp::TimerID, SIG_KILL);
    AV_Timer_Cpp::Timer = 0;
  }
#endif
}
////////////////////////////////////////////////////////////
unsigned long AV_Timer::GetTime()
{
#ifdef __RTL_SCHED__
  return (AV_Timer_Cpp::Timer - Time) << 3;
#else
  AV_Timer_Cpp::tz.tz_dsttime=0;
  AV_Timer_Cpp::tz.tz_minuteswest=0;
  gettimeofday(&AV_Timer_Cpp::tv, &AV_Timer_Cpp::tz);
  return ((AV_Timer_Cpp::tv.tv_sec<<10) + (AV_Timer_Cpp::tv.tv_usec>>10) - Time);
#endif
}
////////////////////////////////////////////////////////////
void AV_Timer :: ResetFrame()
{
  Time = 0;
#ifdef __RTL_SCHED__
  Time = AV_Timer_Cpp::Timer-1;
#else
  Time = GetTime()-1;
#endif
}
