// 004.cpp : Definiert den Einsprungpunkt fr die Konsolenanwendung.
//


#include "stdafx.h"

#include <conio.h>
#include <string.h>

// verkettet liste fuer die aufnahme der
// datei

struct Node
{
	Node* pPrev;
	Node* pNext;
	char* pLine;
};

Node*
ReadFile( const char* pszPath)
{

	// datei zum lesen oeffnen
	FILE* pSource = fopen( pszPath, "r");
	if(! pSource)
		return 0;

	Node* pRoot = 0;
	Node* pCurrent = 0;
	Node* pLast = 0;

    while(! feof( pSource))
	{
		// das ist eigentlich nicht sauber, soll aber
		// so mal reichen...

		char arrLine[ 1025];
		fgets( arrLine, 1024, pSource);

		// speicher fuer die echte laenger der zeile
		// sowie fuer einen neuen knoten besorgen
        // todo: eigentlich muesste man hier testen,
		// ob auch speicher vorhanden ist....
		Node* pNode = new Node;

		// laenge ausrechnen
		int cbLine = strlen( arrLine);

		// speicher anfordern und zeile kopieren
		pNode->pLine = new char[ cbLine + 1];
		strcpy( pNode->pLine, arrLine);
			
		pCurrent = pNode;

		// ist es die erste ?
		if( ! pRoot)
		{
			pRoot = pNode;
		}

		//gibt es einen vorgaenger ?
		pCurrent->pPrev = pLast; // pLast = 0 beim ersten
		if( pLast) pLast->pNext = pCurrent;

		// noch keine naechste
		pCurrent->pNext = 0;

        pLast = pCurrent;    
	}

	// alles ok
	return pRoot;
}

// anzeige des einfachen menus
char DisplayMenu()
{
	printf("[e]nde [v]or zu[r]ueck");
	return getch();
}

// typedef fuers einfachere hinschreiben
// der function pointer
typedef void(*pFunc)(Node**);

// funktion zum vorwaerts blaettern
void Forward( Node** pNode)
{
	if( (*pNode)->pNext)
		(*pNode) = (*pNode)->pNext;
}

// funktion zum rueckwaerts blaettern
void Back( Node** pNode)
{
	if( (*pNode)->pPrev)
		(*pNode) = (*pNode)->pPrev;
}

// struktur fuer die menu-auswahl,bestehend
// aus der taste und der zugehoerenden
// funktion
struct MenuEntry
{
	char   cKey; // taste
	pFunc  pF;   // funktion
};

// das menu
MenuEntry arrMenu[] = 
{
	'v', Forward,
	'r', Back
};

// funktion zum finden des passenden befehls
// aus dem menu anhand der taste
void FindAndExecCommand( char c, Node** pFirst)
{
	for( int i=0; i<sizeof(arrMenu)/sizeof(MenuEntry); i++)
	{
		if( arrMenu[ i].cKey == c)
		{
			(*arrMenu[ i].pF)( pFirst);
			return;
		}
	}
}

// zeigt eine einzelne zeile an
void DisplayLine( Node* pNode)
{
	int i = strlen( pNode->pLine);
	printf( "%s", pNode->pLine);
}

// angezeigt werden immer 24 zeilen
// dann kann mit 'v' und 'r' vorwaerts
// und rueckwaerts gescrollt werden, und
// zwar jeweils um eine zeile. 'e' beendet
// die anzeige
void DisplayFile( Node* pNode)
{
	char cSelect = 'x';

	// pfirstLine zeigt auf die erste 
	// am bilschirm angezeige zeile
	Node* pFirstLine = pNode;

	while( cSelect != 'e')
	{
		Node* pDisplay = pFirstLine;
		for( int i=0; i<24; i++)
		{
			// wenn es eine zeile zum anzeigen gibt: anzeigen
			if( pDisplay)
			{
				DisplayLine( pDisplay);

				// wenn es eine weitere zeile gibt: die
				// anzeigen, sonst auf 0 setzen
				pDisplay = pDisplay->pNext;
			}
		}
	
		cSelect = DisplayMenu();
		FindAndExecCommand( cSelect, &pFirstLine);        

		/*
		// jetzt auf tastendruck warten und entsprechend
		// reagieren:
		cSelect = getch();
		
		// vorwaerts ?
		if( cSelect == 'v')
		{
			// gehts noch weiter ?
			if( pFirstLine->pNext)
				pFirstLine = pFirstLine->pNext;
		}
		
		// rueckewaerts ?
		if( cSelect == 'r')
		{
			if( pFirstLine->pPrev)
				pFirstLine = pFirstLine->pPrev;
		}
		*/
	}


}

// freigegeben werden muss:
// 1. die 'pLines'
// 2. die nodes selbst
void FreeMemory( Node* pNode)
{
	while( pNode->pNext)
	{
		delete[] pNode->pLine;
		if( pNode->pPrev)
			delete pNode->pPrev;
		pNode = pNode->pNext;
	}
	delete pNode;

}

int main(int argc, char* argv[])
{
	// datei einlesen
	Node* pNode = ReadFile( argv[1]);
	if( ! pNode )
	{
		printf("Die Datei konnte nicht eingelesen werden.");
		return 1;
	}


	// datei anzeigen und scrollen
	DisplayFile( pNode);

	// speicher freigeben
	FreeMemory( pNode);

	return 0;
}

