/******************************************************************************
 *                                                                            *
 * File:   binary  .c         Version  1.01            Date: 05-MAR-1993      *
 *                                                                            *
 * Copyright (C) 1993 by Kosta Kostis - this is freeware!                     *
 * Written by kosta@blues.sub.de (Kosta Kostis)                               *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - copy binary                                                       *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    05-MAR-1993: KK V1.01                                                   *
 *        - added translation table support                                   *
 *    01-FEB-1993: KK V1.00                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>

#include "binary.h"

/******************************************************************************

	Function:
		copy input to output unchanged

	Parameters:
		FILE    *fin            file being read
		FILE    *fout           file being written
		int     *table          pointer to translation table

	Returns:
		BINARY_OK               if all goes well
		BINARY_WRITE            if there's a write error

	Note:
		To be sure the data copied isn't modified open the files
		in binary mode (especially under MS-DOS).

******************************************************************************/

int     CopyBinary
(
	FILE    *fin,
	FILE    *fout,
	int     *table
)
{
	int     ch ;

	while ((ch = fgetc (fin)) != EOF)
	{
		/**************************************************************

			use conversion table if supplied

		**************************************************************/

		if (table != (int *) NULL)
			ch = table [ch] ;

		if (fputc (ch, fout) != ch)
			return (BINARY_WRITE) ;
	}

	return (BINARY_OK) ;
}
