/******************************************************************************
 *                                                                            *
 * File:   binxb64 .c         Version  1.00            Date: 01-MAR-1993      *
 *                                                                            *
 * Copyright (C) 1993 by Kosta Kostis - this is freeware!                     *
 * Written by kosta@blues.sub.de (Kosta Kostis)                               *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - conversion from binary to base64                                  *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    01-MAR-1993: KK V1.00                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>

#include "base64.h"

#include "binxb64.h"

/******************************************************************************

	Function:
		display copyright message

	Parameters:
		none

	Returns:
		nothing

******************************************************************************/

static  void    Hello (void)
{
	fprintf (stderr, MSG_COPYRIGHT) ;
	fprintf (stderr, MSG_AUTHOR) ;
	fprintf (stderr, MSG_VERSION, PRGNAM) ;
}

int     main
(
	int     argc,
	char    *argv   []
)
{
	FILE    *inf ;

	/**********************************************************************

		check syntax first

	**********************************************************************/

	if (argc != 2)
	{
		Hello () ;
		fprintf (stderr, ERR_MSG_SYNTAX, PRGNAM) ;
		return (ERR_SYNTAX) ;
	}

	/**********************************************************************

		attempt to open input file

	**********************************************************************/

	inf = fopen (argv [1], "rb") ;
	if (inf == (FILE *) NULL)
	{
		Hello () ;
		fprintf (stderr, ERR_MSG_OPEN, PRGNAM, argv [1]) ;
		return (ERR_OPEN) ;
	}

	/**********************************************************************

		convert binary to base64

	**********************************************************************/

	Copy8BitToBase64 (inf, stdout, (int *) NULL) ;

	/**********************************************************************

		close input file and quit

	**********************************************************************/

	fclose (inf) ;
	
	return (ERR_NONE) ;
}
