/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.ui.FileExplorerTableModel;
import org.fife.ui.UIUtil;
import org.fife.ui.dockablewindows.DockableWindow;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;

public abstract class AbstractParserNoticeWindow
extends DockableWindow {
    private RText rtext;
    private JTable table;

    public AbstractParserNoticeWindow(RText rtext) {
        this.rtext = rtext;
    }

    protected JTable createTable(TableModel model) {
        this.table = new JTable(){

            public boolean getScrollableTracksViewportHeight() {
                Container parent = this.getParent();
                return parent instanceof JViewport ? parent.getHeight() > this.getPreferredSize().height : false;
            }
        };
        this.setPrimaryComponent(this.table);
        this.fixTableModel(model);
        this.table.addMouseListener(new TableMouseListener());
        Dimension size = this.table.getPreferredScrollableViewportSize();
        size.height = 200;
        this.table.setPreferredScrollableViewportSize(size);
        UIUtil.fixJTableRendererOrientations((JTable)this.table);
        UIUtil.possiblyFixGridColor((JTable)this.table);
        return this.table;
    }

    private void fixTableModel(TableModel model) {
        JTableHeader old = this.table.getTableHeader();
        this.table.setTableHeader(new JTableHeader(old.getColumnModel()));
        FileExplorerTableModel model2 = new FileExplorerTableModel(model, this.table.getTableHeader());
        model2.setColumnComparator(Integer.class, (Comparator)new Comparator<Integer>(){

            @Override
            public int compare(Integer int1, Integer int2) {
                return int1.compareTo(int2);
            }
        });
        IconTableCellRenderer itcr = new IconTableCellRenderer();
        ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
        itcr.applyComponentOrientation(o);
        this.table.setDefaultRenderer(Icon.class, itcr);
        this.table.setModel((TableModel)model2);
        TableColumnModel tcm = this.table.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(32);
        tcm.getColumn(0).setWidth(32);
        tcm.getColumn(1).setPreferredWidth(200);
        tcm.getColumn(1).setWidth(200);
        tcm.getColumn(2).setPreferredWidth(48);
        tcm.getColumn(2).setWidth(48);
        tcm.getColumn(3).setPreferredWidth(800);
        this.table.setAutoResizeMode(0);
    }

    protected RText getRText() {
        return this.rtext;
    }

    public void updateUI() {
        TableModel model = null;
        if (this.table != null) {
            model = ((FileExplorerTableModel)this.table.getModel()).getTableModel();
            TableCellRenderer r = this.table.getTableHeader().getDefaultRenderer();
            if (r instanceof FileExplorerTableModel.SortableHeaderRenderer) {
                FileExplorerTableModel.SortableHeaderRenderer shr = (FileExplorerTableModel.SortableHeaderRenderer)r;
                this.table.getTableHeader().setDefaultRenderer(shr.getDelegateRenderer());
            }
        }
        super.updateUI();
        if (this.table != null) {
            JScrollPane sp = (JScrollPane)this.table.getParent().getParent();
            this.fixTableModel(model);
            sp.setColumnHeaderView(this.table.getTableHeader());
            sp.revalidate();
            sp.repaint();
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int row;
            if (e.getButton() == 1 && e.getClickCount() == 2 && (row = AbstractParserNoticeWindow.this.table.rowAtPoint(e.getPoint())) > -1) {
                TableModel model = AbstractParserNoticeWindow.this.table.getModel();
                TextAreaWrapper wrapper = (TextAreaWrapper)model.getValueAt(row, 1);
                RTextEditorPane textArea = wrapper.textArea;
                AbstractMainView mainView = AbstractParserNoticeWindow.this.rtext.getMainView();
                if (mainView.setSelectedTextArea(textArea)) {
                    Integer i = (Integer)model.getValueAt(row, 2);
                    int line = i - 1;
                    try {
                        textArea.setCaretPosition(textArea.getLineStartOffset(line));
                    }
                    catch (BadLocationException ble) {
                        UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)textArea));
                    }
                    textArea.requestFocusInWindow();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextAreaWrapper
    implements Comparable<TextAreaWrapper> {
        private RTextEditorPane textArea;

        public TextAreaWrapper(RTextEditorPane textArea) {
            this.textArea = textArea;
        }

        @Override
        public int compareTo(TextAreaWrapper o) {
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.textArea.getFileName();
        }
    }

    private static class IconTableCellRenderer
    extends DefaultTableCellRenderer {
        static final Border b = BorderFactory.createEmptyBorder(0, 5, 0, 5);

        private IconTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int col) {
            super.getTableCellRendererComponent(table, value, selected, focus, row, col);
            this.setText(null);
            this.setIcon((Icon)value);
            this.setBorder(b);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ParserNoticeTableModel
    extends DefaultTableModel {
        public ParserNoticeTableModel(String lastColHeader) {
            Object[] colHeaders = new String[]{"", AbstractParserNoticeWindow.this.rtext.getString("ParserNoticeList.File", new Object[0]), AbstractParserNoticeWindow.this.rtext.getString("ParserNoticeList.Line", new Object[0]), lastColHeader};
            this.setColumnIdentifiers(colHeaders);
        }

        protected abstract void addNoticesImpl(RTextEditorPane var1, List<ParserNotice> var2);

        @Override
        public Class<?> getColumnClass(int col) {
            Class clazz = null;
            switch (col) {
                case 0: {
                    clazz = Icon.class;
                    break;
                }
                case 1: {
                    clazz = TextAreaWrapper.class;
                    break;
                }
                case 2: {
                    clazz = Integer.class;
                    break;
                }
                default: {
                    clazz = super.getColumnClass(col);
                }
            }
            return clazz;
        }

        @Override
        public void addRow(Object[] data) {
            if (data[1] instanceof RTextEditorPane) {
                data[1] = new TextAreaWrapper((RTextEditorPane)((Object)data[1]));
            }
            super.addRow(data);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void update(RTextEditorPane textArea, List<ParserNotice> notices) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                TextAreaWrapper wrapper = (TextAreaWrapper)this.getValueAt(i, 1);
                RTextEditorPane textArea2 = wrapper.textArea;
                if (textArea2 != textArea) continue;
                this.removeRow(i);
                --i;
            }
            if (notices != null) {
                this.addNoticesImpl(textArea, notices);
            }
        }
    }
}

