/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.OpenFileFromHistoryAction;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextMDIView;
import org.fife.rtext.RTextPrefs;
import org.fife.rtext.RTextUtilities;
import org.fife.rtext.SearchToolBarAction;
import org.fife.ui.OS;
import org.fife.ui.RecentFilesMenu;
import org.fife.ui.UIUtil;
import org.fife.ui.app.MenuBar;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTextMenuBar
extends MenuBar
implements PropertyChangeListener,
PopupMenuListener {
    public static final String MENU_FILE = "File";
    public static final String MENU_EDIT = "Edit";
    public static final String MENU_SEARCH = "Search";
    public static final String MENU_VIEW = "View";
    public static final String MENU_DOCKED_WINDOWS = "DockedWindows";
    public static final String MENU_MACROS = "Macros";
    public static final String MENU_HELP = "Help";
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenuItem openInNewWindowItem;
    private JMenuItem openRecentItem;
    private JMenuItem openRemoteItem;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JMenuItem saveAsRemoteItem;
    private JMenuItem saveAsWebPageItem;
    private JMenuItem saveAllItem;
    private JMenuItem closeItem;
    private JMenuItem closeAllItem;
    private JMenuItem printItem;
    private JMenuItem printPreviewItem;
    private JMenuItem exitItem;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    private JMenuItem cutItem;
    private JMenuItem copyItem;
    private JMenuItem copyAsRtfItem;
    private JMenuItem pasteItem;
    private JMenuItem deleteItem;
    private JMenuItem findItem;
    private JMenuItem findNextItem;
    private JMenuItem replaceItem;
    private JMenuItem replaceNextItem;
    private JMenuItem findInFilesItem;
    private JMenuItem replaceInFilesItem;
    private JMenuItem goToItem;
    private JMenuItem selectAllItem;
    private JMenuItem timeDateItem;
    private JMenuItem optionsItem;
    private JCheckBoxMenuItem toolbarItem;
    private JCheckBoxMenuItem searchToolbarMenuItem;
    private JCheckBoxMenuItem statusBarItem;
    private JCheckBoxMenuItem lineNumbersItem;
    private JMenuItem nextDocItem;
    private JMenuItem prevDocItem;
    private JMenuItem increaseFontSizesItem;
    private JMenuItem decreaseFontSizesItem;
    private JMenuItem helpItem;
    private JMenuItem homePageItem;
    private JMenuItem updatesItem;
    private JMenuItem aboutItem;
    private JMenuItem filePropItem;
    private JMenu fileMenu;
    private JMenu viewMenu;
    private JMenu windowMenu;
    private RecentFilesMenu recentFilesMenu;
    private JMenu savedMacroMenu;
    private RText rtext;
    private final int MAX_FILE_PATH_LENGTH = 250;

    public RTextMenuBar(final RText rtext, String lnfName, RTextPrefs properties) {
        this.rtext = rtext;
        ResourceBundle msg = rtext.getResourceBundle();
        ResourceBundle menuMsg = ResourceBundle.getBundle("org.fife.rtext.MenuBar");
        this.fileMenu = this.createMenu(menuMsg, "MenuFile");
        this.registerMenuByName(MENU_FILE, this.fileMenu);
        this.add(this.fileMenu);
        this.newItem = this.createMenuItem(rtext.getAction("newAction"));
        this.fileMenu.add(this.newItem);
        this.openItem = this.createMenuItem(rtext.getAction("openAction"));
        this.fileMenu.add(this.openItem);
        this.openInNewWindowItem = this.createMenuItem(rtext.getAction("openNewWinAction"));
        this.fileMenu.add(this.openInNewWindowItem);
        this.openRecentItem = this.createMenuItem(rtext.getAction("openRecentAction"));
        this.fileMenu.add(this.openRecentItem);
        this.openRemoteItem = this.createMenuItem(rtext.getAction("openRemoteAction"));
        this.fileMenu.add(this.openRemoteItem);
        this.closeItem = this.createMenuItem(rtext.getAction("closeAction"));
        this.fileMenu.add(this.closeItem);
        this.closeAllItem = this.createMenuItem(rtext.getAction("closeAllAction"));
        this.fileMenu.add(this.closeAllItem);
        this.fileMenu.addSeparator();
        this.saveItem = this.createMenuItem(rtext.getAction("saveAction"));
        this.fileMenu.add(this.saveItem);
        this.saveAsItem = this.createMenuItem(rtext.getAction("saveAsAction"));
        this.fileMenu.add(this.saveAsItem);
        this.saveAsRemoteItem = this.createMenuItem(rtext.getAction("saveAsRemoteAction"));
        this.fileMenu.add(this.saveAsRemoteItem);
        this.saveAsWebPageItem = this.createMenuItem(rtext.getAction("saveWebPageAction"));
        this.fileMenu.add(this.saveAsWebPageItem);
        this.saveAllItem = this.createMenuItem(rtext.getAction("saveAllAction"));
        this.fileMenu.add(this.saveAllItem);
        this.fileMenu.addSeparator();
        this.printItem = this.createMenuItem(rtext.getAction("printAction"));
        this.fileMenu.add(this.printItem);
        this.printPreviewItem = this.createMenuItem(rtext.getAction("printPreviewAction"));
        this.fileMenu.add(this.printPreviewItem);
        this.fileMenu.addSeparator();
        String[] initialContents = null;
        if (properties.fileHistoryString != null && properties.fileHistoryString.length() > 0) {
            initialContents = properties.fileHistoryString.split("<");
        }
        this.recentFilesMenu = new RecentFilesMenu(menuMsg.getString("RecentFiles"), initialContents){

            protected Action createOpenAction(String fileFullPath) {
                OpenFileFromHistoryAction action = new OpenFileFromHistoryAction(rtext);
                action.setName(RTextMenuBar.this.getDisplayPath(fileFullPath));
                action.setFileFullPath(fileFullPath);
                return action;
            }
        };
        this.fileMenu.add((JMenuItem)this.recentFilesMenu);
        if (rtext.getOS() != OS.MAC_OS_X) {
            this.exitItem = this.createMenuItem(rtext.getAction("exitAction"));
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.exitItem);
        }
        JMenu menu = this.createMenu(menuMsg, "MenuEdit");
        this.registerMenuByName(MENU_EDIT, menu);
        this.add(menu);
        this.undoItem = this.createMenuItem((Action)RTextArea.getAction((int)6));
        menu.add(this.undoItem);
        this.redoItem = this.createMenuItem((Action)RTextArea.getAction((int)4));
        menu.add(this.redoItem);
        menu.addSeparator();
        this.cutItem = this.createMenuItem((Action)RTextArea.getAction((int)1));
        menu.add(this.cutItem);
        this.copyItem = this.createMenuItem((Action)RTextArea.getAction((int)0));
        menu.add(this.copyItem);
        this.copyAsRtfItem = this.createMenuItem(rtext.getAction("copyAsRtf"));
        menu.add(this.copyAsRtfItem);
        this.pasteItem = this.createMenuItem((Action)RTextArea.getAction((int)3));
        menu.add(this.pasteItem);
        this.deleteItem = this.createMenuItem((Action)RTextArea.getAction((int)2));
        menu.add(this.deleteItem);
        menu.addSeparator();
        this.selectAllItem = this.createMenuItem((Action)RTextArea.getAction((int)5));
        menu.add(this.selectAllItem);
        this.timeDateItem = this.createMenuItem(rtext.getAction("timeDateAction"));
        menu.add(this.timeDateItem);
        menu.addSeparator();
        JMenu textMenu = this.createMenu(menuMsg, "MenuText");
        int defaultModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuItem menuItem = this.createMenuItem((Action)new RSyntaxTextAreaEditorKit.ToggleCommentAction(), menuMsg, "ToggleComment", "ToggleCommentMnemonic", KeyStroke.getKeyStroke(47, defaultModifier));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescToggleComment");
        textMenu.add(menuItem);
        textMenu.addSeparator();
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.DeleteRestOfLineAction(), menuMsg, "DeleteLineRemainder", "DeleteLineRemainderMnemonic", KeyStroke.getKeyStroke(127, defaultModifier));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescDeleteLineRemainder");
        textMenu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.JoinLinesAction(), menuMsg, "JoinLines", "JoinLinesMnemonic", KeyStroke.getKeyStroke(74, defaultModifier));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescJoinLines");
        textMenu.add(menuItem);
        textMenu.addSeparator();
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.UpperSelectionCaseAction(), menuMsg, "UpperCase", "UpperCaseMnemonic");
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescUpperCase");
        textMenu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.LowerSelectionCaseAction(), menuMsg, "LowerCase", "LowerCaseMnemonic");
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescLowerCase");
        textMenu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.InvertSelectionCaseAction(), menuMsg, "InvertCase", "InvertCaseMnemonic");
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescInvertCase");
        textMenu.add(menuItem);
        menu.add(textMenu);
        JMenu indentMenu = this.createMenu(menuMsg, "MenuIndent");
        boolean shift = true;
        menuItem = this.createMenuItem((Action)new RSyntaxTextAreaEditorKit.InsertTabAction(), menuMsg, "IncreaseIndent", "IncreaseIndentMnemonic", KeyStroke.getKeyStroke(9, 0));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescIncreaseIndent");
        indentMenu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RSyntaxTextAreaEditorKit.DecreaseIndentAction(), menuMsg, "DecreaseIndent", "DecreaseIndentMnemonic", KeyStroke.getKeyStroke(9, 1));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescDecreaseIndent");
        indentMenu.add(menuItem);
        menu.add(indentMenu);
        if (rtext.getOS() != OS.MAC_OS_X) {
            menu.addSeparator();
            this.optionsItem = this.createMenuItem(rtext.getAction("optionsAction"));
            menu.add(this.optionsItem);
        }
        menu = this.createMenu(menuMsg, "MenuSearch");
        this.registerMenuByName(MENU_SEARCH, menu);
        this.add(menu);
        this.findItem = this.createMenuItem(rtext.getAction("findAction"));
        menu.add(this.findItem);
        this.findNextItem = this.createMenuItem(rtext.getAction("findNextAction"));
        menu.add(this.findNextItem);
        this.replaceItem = this.createMenuItem(rtext.getAction("replaceAction"));
        menu.add(this.replaceItem);
        this.replaceNextItem = this.createMenuItem(rtext.getAction("replaceNextAction"));
        menu.add(this.replaceNextItem);
        menu.addSeparator();
        this.findInFilesItem = this.createMenuItem(rtext.getAction("findInFilesAction"));
        menu.add(this.findInFilesItem);
        this.replaceInFilesItem = this.createMenuItem(rtext.getAction("replaceInFilesAction"));
        menu.add(this.replaceInFilesItem);
        menu.addSeparator();
        this.goToItem = this.createMenuItem(rtext.getAction("gotoAction"));
        menu.add(this.goToItem);
        menuItem = this.createMenuItem((Action)new RSyntaxTextAreaEditorKit.GoToMatchingBracketAction(), menuMsg, "GoToMatchingBracket", "GoToMatchingBracketMnemonic", KeyStroke.getKeyStroke(91, defaultModifier));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescGoToMatchingBracket");
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.NextBookmarkAction("RTA.NextBookmarkAction", true), menuMsg, "NextBookmark", "NextBookmarkMnemonic", KeyStroke.getKeyStroke(113, 0));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescNextBookmark");
        menu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.NextBookmarkAction("RTA.NextBookmarkAction", false), menuMsg, "PreviousBookmark", "PreviousBookmarkMnemonic", KeyStroke.getKeyStroke(113, 1));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescPreviousBookmark");
        menu.add(menuItem);
        menuItem = this.createMenuItem((Action)new RTextAreaEditorKit.ToggleBookmarkAction(), menuMsg, "ToggleBookmark", "ToggleBookmarkMnemonic", KeyStroke.getKeyStroke(113, defaultModifier));
        UIUtil.setDescription((JComponent)menuItem, (ResourceBundle)menuMsg, (String)"DescToggleBookmark");
        menu.add(menuItem);
        this.viewMenu = this.createMenu(menuMsg, "MenuView");
        this.registerMenuByName(MENU_VIEW, this.viewMenu);
        this.viewMenu.getPopupMenu().addPopupMenuListener(this);
        this.add(this.viewMenu);
        JMenu toolbarsMenu = new JMenu(menuMsg.getString("Toolbars"));
        Action a = rtext.getAction("toolBarAction");
        this.toolbarItem = new JCheckBoxMenuItem(a);
        this.toolbarItem.setToolTipText(null);
        this.toolbarItem.setSelected(properties.toolbarVisible);
        toolbarsMenu.add(this.toolbarItem);
        SearchToolBarAction stba = new SearchToolBarAction(rtext);
        stba.setName(menuMsg.getString("QuickSearchBar"));
        this.searchToolbarMenuItem = new JCheckBoxMenuItem((Action)((Object)stba));
        this.searchToolbarMenuItem.setSelected(properties.searchToolBarVisible);
        UIUtil.setDescription((JComponent)this.searchToolbarMenuItem, (ResourceBundle)menuMsg, (String)"DescQuickSearch");
        toolbarsMenu.add(this.searchToolbarMenuItem);
        this.viewMenu.add(toolbarsMenu);
        JMenu fontSizesMenu = this.createMenu(menuMsg, "MenuFontSizes");
        a = rtext.getAction("decFontSizesAction");
        this.decreaseFontSizesItem = this.createMenuItem(a);
        fontSizesMenu.add(this.decreaseFontSizesItem);
        a = rtext.getAction("incFontSizesAction");
        this.increaseFontSizesItem = this.createMenuItem(a);
        fontSizesMenu.add(this.increaseFontSizesItem);
        this.viewMenu.add(fontSizesMenu);
        JMenu dwMenu = this.createMenu(menuMsg, "MenuDockedWindows");
        this.registerMenuByName(MENU_DOCKED_WINDOWS, dwMenu);
        this.viewMenu.add(dwMenu);
        this.statusBarItem = new JCheckBoxMenuItem(rtext.getAction("statusBarAction"));
        this.statusBarItem.setToolTipText(null);
        this.statusBarItem.setSelected(properties.statusBarVisible);
        this.viewMenu.add(this.statusBarItem);
        this.lineNumbersItem = new JCheckBoxMenuItem(rtext.getAction("lineNumberAction"));
        this.lineNumbersItem.setSelected(properties.lineNumbersVisible);
        this.lineNumbersItem.setToolTipText(null);
        this.viewMenu.add(this.lineNumbersItem);
        this.viewMenu.addSeparator();
        JMenu focusDwMenu = this.createMenu(menuMsg, "MenuFocusDockableWindowGroup");
        focusDwMenu.add(this.createMenuItem(rtext.getAction("moveFocusLeftAction")));
        focusDwMenu.add(this.createMenuItem(rtext.getAction("moveFocusRightAction")));
        focusDwMenu.add(this.createMenuItem(rtext.getAction("moveFocusUpAction")));
        focusDwMenu.add(this.createMenuItem(rtext.getAction("moveFocusDownAction")));
        this.viewMenu.add(focusDwMenu);
        this.viewMenu.addSeparator();
        this.nextDocItem = this.createMenuItem(rtext.getAction("nextDocumentAction"));
        this.viewMenu.add(this.nextDocItem);
        this.prevDocItem = this.createMenuItem(rtext.getAction("prevDocumentAction"));
        this.viewMenu.add(this.prevDocItem);
        this.viewMenu.addSeparator();
        this.filePropItem = this.createMenuItem(rtext.getAction("filePropertiesAction"));
        this.viewMenu.add(this.filePropItem);
        this.windowMenu = this.createMenu(menuMsg, "MenuWindow");
        this.add(this.windowMenu);
        JMenuItem item = new JMenuItem(menuMsg.getString("TileVertically"));
        UIUtil.setDescription((JComponent)item, (ResourceBundle)msg, (String)"DescTileVertically");
        item.setActionCommand("TileVertically");
        item.addActionListener(rtext);
        this.windowMenu.add(item);
        item = new JMenuItem(menuMsg.getString("TileHorizontally"));
        UIUtil.setDescription((JComponent)item, (ResourceBundle)msg, (String)"DescTileHorizontally");
        item.setActionCommand("TileHorizontally");
        item.addActionListener(rtext);
        this.windowMenu.add(item);
        item = new JMenuItem(menuMsg.getString("Cascade"));
        UIUtil.setDescription((JComponent)item, (ResourceBundle)msg, (String)"DescCascade");
        item.setActionCommand("Cascade");
        item.addActionListener(rtext);
        this.windowMenu.add(item);
        this.windowMenu.addSeparator();
        this.windowMenu.getPopupMenu().addPopupMenuListener(this);
        menu = this.createMenu(menuMsg, "MenuHelp");
        this.registerMenuByName(MENU_HELP, menu);
        this.add(menu);
        this.helpItem = this.createMenuItem(rtext.getAction("helpAction"));
        menu.add(this.helpItem);
        this.homePageItem = this.createMenuItem(rtext.getAction("homePageAction"));
        menu.add(this.homePageItem);
        this.updatesItem = this.createMenuItem(rtext.getAction("checkForUpdatesAction"));
        menu.add(this.updatesItem);
        menu.addSeparator();
        this.aboutItem = this.createMenuItem(rtext.getAction("aboutAction"));
        menu.add(this.aboutItem);
    }

    private void addFileToFileHistory(String fileFullPath) {
        if (fileFullPath.endsWith(File.separatorChar + this.rtext.getNewFileName()) || fileFullPath.equals("-")) {
            return;
        }
        this.recentFilesMenu.addFileToFileHistory(fileFullPath);
    }

    private String getDisplayPath(String longPath) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int textWidth = RTextMenuBar.getTextWidth(longPath, fontMetrics);
        if (textWidth <= 250) {
            return longPath;
        }
        String displayString = longPath;
        String separator = System.getProperty("file.separator");
        int lastSeparatorPos = displayString.lastIndexOf(separator);
        if (lastSeparatorPos == -1) {
            return displayString;
        }
        String justFileName = displayString.substring(lastSeparatorPos + 1, displayString.length());
        int justFileNameLength = RTextMenuBar.getTextWidth(justFileName, fontMetrics);
        if (justFileNameLength > 250) {
            return "..." + separator + justFileName;
        }
        String endPiece = "..." + separator + justFileName;
        int endPieceLength = RTextMenuBar.getTextWidth(endPiece, fontMetrics);
        int separatorPos = displayString.indexOf(separator, 0);
        String firstPart = displayString.substring(0, separatorPos + 1);
        int firstPartLength = RTextMenuBar.getTextWidth(firstPart, fontMetrics);
        String tempFirstPart = firstPart;
        int tempFirstPartLength = firstPartLength;
        while (tempFirstPartLength + endPieceLength < 250) {
            firstPart = tempFirstPart;
            if ((separatorPos = displayString.indexOf(separator, separatorPos + 1)) == -1) {
                endPieceLength = 9999999;
                continue;
            }
            tempFirstPart = displayString.substring(0, separatorPos + 1);
            tempFirstPartLength = RTextMenuBar.getTextWidth(tempFirstPart, fontMetrics);
        }
        return firstPart + endPiece;
    }

    public List<String> getFileHistory() {
        return this.recentFilesMenu.getFileHistory();
    }

    public String getFileHistoryString() {
        String retVal = "";
        int historyCount = this.recentFilesMenu.getItemCount();
        for (int i = historyCount - 1; i >= 0; --i) {
            retVal = retVal + this.recentFilesMenu.getFileFullPath(i) + "<";
        }
        if (retVal.length() > 0) {
            retVal = retVal.substring(0, retVal.length() - 1);
        }
        return retVal;
    }

    public int getMaximumFileHistorySize() {
        return this.recentFilesMenu.getMaximumFileHistorySize();
    }

    private static final int getTextWidth(String s, FontMetrics metrics) {
        int textWidth = 0;
        char[] txt = s.toCharArray();
        int n = txt.length;
        for (int i = 0; i < n; ++i) {
            if (txt[i] == '\n') continue;
            textWidth += metrics.charWidth(txt[i]);
        }
        return textWidth;
    }

    protected void menuItemAcceleratorWorkaround() {
        this.updateAction(this.newItem, "newAction");
        this.updateAction(this.openItem, "openAction");
        this.updateAction(this.openInNewWindowItem, "openNewWinAction");
        this.updateAction(this.openRecentItem, "openRecentAction");
        this.updateAction(this.openRemoteItem, "openRemoteAction");
        this.updateAction(this.closeItem, "closeAction");
        this.updateAction(this.closeAllItem, "closeAllAction");
        if (this.rtext.getOS() != OS.MAC_OS_X) {
            this.updateAction(this.exitItem, "exitAction");
        }
        this.updateAction(this.saveItem, "saveAction");
        this.updateAction(this.saveAsItem, "saveAsAction");
        this.updateAction(this.saveAsRemoteItem, "saveAsRemoteAction");
        this.updateAction(this.saveAsWebPageItem, "saveWebPageAction");
        this.updateAction(this.saveAllItem, "saveAllAction");
        this.updateAction(this.printItem, "printAction");
        this.updateAction(this.printPreviewItem, "printPreviewAction");
        this.updateAction(this.findItem, "findAction");
        this.updateAction(this.findNextItem, "findNextAction");
        this.updateAction(this.replaceItem, "replaceAction");
        this.updateAction(this.replaceNextItem, "replaceNextAction");
        this.updateAction(this.findInFilesItem, "findInFilesAction");
        this.updateAction(this.replaceInFilesItem, "replaceInFilesAction");
        this.updateAction(this.goToItem, "gotoAction");
        this.updateAction(this.copyAsRtfItem, "copyAsRtf");
        this.updateAction(this.timeDateItem, "timeDateAction");
        if (this.rtext.getOS() != OS.MAC_OS_X) {
            this.updateAction(this.optionsItem, "optionsAction");
        }
        this.updateAction(this.toolbarItem, "toolBarAction");
        this.updateAction(this.statusBarItem, "statusBarAction");
        this.updateAction(this.lineNumbersItem, "lineNumberAction");
        this.updateAction(this.nextDocItem, "nextDocumentAction");
        this.updateAction(this.prevDocItem, "prevDocumentAction");
        this.updateAction(this.filePropItem, "filePropertiesAction");
        this.updateAction(this.helpItem, "helpAction");
        this.updateAction(this.homePageItem, "homePageAction");
        this.updateAction(this.updatesItem, "checkForUpdatesAction");
        this.updateAction(this.aboutItem, "aboutAction");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("MainView.textAreaAdded")) {
            RTextEditorPane textArea = (RTextEditorPane)((Object)e.getNewValue());
            this.addFileToFileHistory(textArea.getFileFullPath());
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        Object source = e.getSource();
        if (source == this.viewMenu.getPopupMenu()) {
            AbstractMainView mainView = this.rtext.getMainView();
            this.lineNumbersItem.setSelected(mainView.getLineNumbersEnabled());
        } else if (source == this.windowMenu.getPopupMenu()) {
            JPopupMenu popupMenu = this.windowMenu.getPopupMenu();
            int count = popupMenu.getComponentCount() - 4;
            for (int i = 0; i < count; ++i) {
                this.windowMenu.remove(4);
            }
            if (!(this.rtext.getMainView() instanceof RTextMDIView)) {
                return;
            }
            final RTextMDIView mdiView = (RTextMDIView)this.rtext.getMainView();
            JMenu currentMenu = this.windowMenu;
            count = mdiView.getNumDocuments();
            int selectedIndex = mdiView.getSelectedIndex();
            for (int i = 0; i < count; ++i) {
                if ((i + 1) % 15 == 0) {
                    currentMenu.add(new JMenu("More..."));
                    currentMenu = (JMenu)currentMenu.getItem(currentMenu.getItemCount() - 1);
                }
                String text = i + 1 + " " + this.getDisplayPath(mdiView.getRTextEditorPaneAt(i).getFileFullPath());
                final int index = i;
                JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        mdiView.setSelectedIndex(index);
                    }
                });
                menuItem.setText(text);
                menuItem.setSelected(i == selectedIndex);
                currentMenu.add(menuItem);
            }
            currentMenu = null;
        } else if (source == this.savedMacroMenu.getPopupMenu()) {
            this.savedMacroMenu.removeAll();
            File[] files = RTextUtilities.getSavedMacroFiles();
            int count = files.length;
            for (int i = 0; i < count; ++i) {
                String name = RTextUtilities.getMacroName(files[i]);
                final File f = files[i];
                AbstractAction a = new AbstractAction(name){

                    public void actionPerformed(ActionEvent e) {
                        RTextMenuBar.this.rtext.getMainView().loadMacro(f);
                    }
                };
                this.savedMacroMenu.add(new JMenuItem(a));
            }
            this.savedMacroMenu.applyComponentOrientation(this.getComponentOrientation());
        }
    }

    public void setSearchToolbarMenuItemSelected(boolean selected) {
        this.searchToolbarMenuItem.setSelected(selected);
    }

    public void setWindowMenuVisible(boolean visible) {
        if (visible) {
            this.add(this.windowMenu, 4);
        } else {
            this.remove(this.windowMenu);
        }
        this.validate();
    }

    private void updateAction(JMenuItem item, String key) {
        item.setAction(null);
        item.setAction(this.rtext.getAction(key));
        item.setToolTipText(null);
    }

    public void updateUI() {
        super.updateUI();
        if (this.rtext != null && this.rtext.getMainViewStyle() != 2 && this.windowMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.windowMenu);
        }
    }
}

