/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextMenuBar;
import org.fife.ui.rsyntaxtextarea.FileLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentFileManager
implements PropertyChangeListener {
    private RText rtext;
    private List<FileLocation> files;
    private static final int MAX_FILE_COUNT = 50;

    public RecentFileManager(RText rtext) {
        this.rtext = rtext;
        this.files = new ArrayList<FileLocation>();
        rtext.getMainView().addPropertyChangeListener("MainView.textAreaAdded", this);
        List<String> history = ((RTextMenuBar)((Object)rtext.getJMenuBar())).getFileHistory();
        for (int i = history.size() - 1; i >= 0; --i) {
            this.addFile(history.get(i));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        RTextEditorPane textArea;
        String prop = e.getPropertyName();
        if ("MainView.textAreaAdded".equals(prop) && (textArea = (RTextEditorPane)((Object)e.getNewValue())) != null) {
            String fullPath = textArea.getFileFullPath();
            if (fullPath.endsWith(File.separatorChar + this.rtext.getNewFileName()) || fullPath.equals("-")) {
                return;
            }
            this.addFile(fullPath);
        }
    }

    private void addFile(String file) {
        if (file == null) {
            return;
        }
        int index = this.indexOf(file);
        if (index > -1) {
            FileLocation loc = this.files.remove(index);
            this.files.add(0, loc);
            return;
        }
        FileLocation loc = null;
        if (file.startsWith("ftp://")) {
            try {
                loc = FileLocation.create((URL)new URL(file));
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        } else {
            loc = FileLocation.create((String)file);
            if (!loc.isLocalAndExists()) {
                return;
            }
        }
        this.files.add(0, loc);
        if (this.files.size() > 50) {
            this.files.remove(this.files.size() - 1);
        }
    }

    private int indexOf(String file) {
        for (int i = 0; i < this.files.size(); ++i) {
            FileLocation loc = this.files.get(i);
            if (!file.equals(loc.getFileFullPath())) continue;
            return i;
        }
        return -1;
    }

    public List<FileLocation> getRecentFiles() {
        return this.files;
    }
}

