/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.StandardAction;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;

abstract class AbstractFontSizeAction
extends StandardAction {
    protected static final float MINIMUM_SIZE = 2.0f;
    protected static final float MAXIMUM_SIZE = 40.0f;
    private RecordableTextAction delegate;

    protected AbstractFontSizeAction(RText app, RecordableTextAction delegate, ResourceBundle msg, String keyRoot) {
        super((GUIApplication)app, msg, keyRoot);
        this.delegate = delegate;
    }

    public void actionPerformed(ActionEvent e) {
        RText rtext = (RText)this.getApplication();
        AbstractMainView view = rtext.getMainView();
        RTextEditorPane textArea = view.getCurrentTextArea();
        Font oldFont = view.getTextAreaFont();
        Font font = this.updateFontSize(oldFont);
        if (font.getSize2D() == oldFont.getSize2D()) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)rtext));
            return;
        }
        view.setTextAreaFont(font, view.getTextAreaUnderline());
        this.delegate.actionPerformedImpl(e, (RTextArea)textArea);
    }

    protected abstract Font updateFontSize(Font var1);
}

