/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.search;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fife.io.UnicodeReader;
import org.fife.io.UnicodeWriter;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.search.FindInFilesDialog;
import org.fife.ui.search.FindInFilesThread;
import org.fife.ui.search.MatchData;
import org.fife.ui.search.ReplaceInFilesDialog;

class ReplaceInFilesThread
extends FindInFilesThread {
    public ReplaceInFilesThread(FindInFilesDialog dialog, File directory) {
        super(dialog, directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object construct() {
        String searchString = this.dialog.getSearchString();
        Pattern[] filterStrings = this.getFilterStrings();
        if (filterStrings == null) {
            this.dialog.searchCompleted("");
            return null;
        }
        this.dialog.clearSearchResults();
        File[] files = this.directory.listFiles();
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.addAll(Arrays.asList(files));
        boolean checkSubfolders = this.dialog.getCheckSubfolders();
        boolean matchCase = this.dialog.getMatchCase();
        boolean wholeWord = this.dialog.getMatchWholeWord();
        boolean useRegex = this.dialog.getUseRegEx();
        boolean doVerboseOutput = this.dialog.getDoVerboseOutput();
        String replaceString = ((ReplaceInFilesDialog)this.dialog).getReplaceString();
        String searchingFile = this.dialog.getString2("SearchingFile");
        if (!useRegex && !matchCase) {
            searchString = searchString.toLowerCase();
        }
        long startMillis = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[4096];
        StringBuilder replaceSB = new StringBuilder();
        int numFiles = fileList.size();
        for (int i = 0; i < numFiles; ++i) {
            int count;
            MatchData data;
            MatchData data2;
            if (Thread.currentThread().isInterrupted()) {
                this.dialog.searchCompleted(this.dialog.getString2("SearchTerminated"));
                return null;
            }
            File temp = (File)fileList.get(i);
            String fileFullPath = temp.getAbsolutePath();
            if (temp.isFile()) {
                if (ReplaceInFilesThread.isFilteredOut(temp.getName(), filterStrings)) {
                    if (!doVerboseOutput) continue;
                    data2 = this.createVerboseMatchData(fileFullPath, this.verboseNoFiltMatchString);
                    this.dialog.addMatchData(data2);
                    continue;
                }
                this.dialog.setStatusText(searchingFile + i + "/" + numFiles + ": " + fileFullPath);
                String encoding = null;
                try {
                    UnicodeReader ur = new UnicodeReader(temp);
                    encoding = ur.getEncoding();
                    BufferedReader r = new BufferedReader((Reader)ur);
                    try {
                        int count2 = 0;
                        sb.setLength(0);
                        while ((count2 = r.read(buf)) != -1) {
                            sb.append(buf, 0, count2);
                        }
                    }
                    finally {
                        ((Reader)r).close();
                    }
                }
                catch (IOException ioe) {
                    data = this.createErrorMatchData(fileFullPath, "IOException reading file: " + ioe);
                    this.dialog.addMatchData(data);
                    continue;
                }
                catch (OutOfMemoryError oome) {
                    data = this.createErrorMatchData(fileFullPath, "OutOfMemoryError");
                    this.dialog.addMatchData(data);
                    this.dialog.searchCompleted(System.currentTimeMillis() - startMillis);
                    return null;
                }
                if (sb.length() <= 0) continue;
                try {
                    int repCount = 0;
                    replaceSB.setLength(0);
                    repCount = useRegex ? ReplaceInFilesThread.doSearchRegex(sb, searchString, replaceString, matchCase, wholeWord, fileFullPath, replaceSB) : ReplaceInFilesThread.doSearchNoRegex(sb, searchString, replaceString, matchCase, wholeWord, fileFullPath, replaceSB);
                    if (repCount > 0) {
                        PrintWriter w = new PrintWriter(new BufferedWriter((Writer)new UnicodeWriter(fileFullPath, encoding)));
                        w.print(replaceSB.toString());
                        w.close();
                        String text = MessageFormat.format(this.occurrencesString, new Integer(repCount));
                        MatchData data3 = new MatchData(fileFullPath, "--", text);
                        this.dialog.addMatchData(data3);
                        continue;
                    }
                    if (!doVerboseOutput) continue;
                    String text = MessageFormat.format(this.occurrencesString, new Integer(repCount));
                    MatchData data4 = this.createVerboseMatchData(fileFullPath, text);
                    this.dialog.addMatchData(data4);
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                    String desc = ioe.getMessage();
                    MatchData data5 = this.createErrorMatchData(fileFullPath, desc);
                    this.dialog.addMatchData(data5);
                }
                continue;
            }
            if (!temp.isDirectory()) continue;
            if (!checkSubfolders) {
                if (!doVerboseOutput) continue;
                data2 = this.createVerboseMatchData(fileFullPath, this.dontSearchSubfoldersString);
                this.dialog.addMatchData(data2);
                continue;
            }
            List<File> moreFilesList = ReplaceInFilesThread.getFilesFromDirectory(temp);
            int n = count = moreFilesList == null ? 0 : moreFilesList.size();
            if (count > 0) {
                fileList.addAll(moreFilesList);
                numFiles += count;
            }
            if (!doVerboseOutput) continue;
            data = this.createVerboseMatchData(fileFullPath, this.newFilesToExamineString + ": " + count);
            this.dialog.addMatchData(data);
        }
        this.dialog.searchCompleted(System.currentTimeMillis() - startMillis);
        return null;
    }

    private static final int doSearchNoRegex(CharSequence sb, String searchString, String replaceString, boolean matchCase, boolean wholeWord, String fileFullPath, StringBuilder replaceSB) {
        String origBuffer;
        String buffer = origBuffer = ((Object)sb).toString();
        if (!matchCase) {
            buffer = buffer.toLowerCase();
        }
        int i = 0;
        int start = 0;
        int len = searchString.length();
        int numMatches = 0;
        while ((i = buffer.indexOf(searchString, i)) != -1) {
            if (!wholeWord || FindDialog.isWholeWord((CharSequence)buffer, (int)i, (int)len)) {
                replaceSB.append(origBuffer.substring(start, i));
                replaceSB.append(replaceString);
                ++numMatches;
                start = i += len;
                continue;
            }
            ++i;
        }
        if (start != buffer.length()) {
            replaceSB.append(origBuffer.substring(start, buffer.length()));
        }
        return numMatches;
    }

    private static final int doSearchRegex(StringBuilder sb, String searchString, String replaceString, boolean matchCase, boolean wholeWord, String fileFullPath, StringBuilder replaceSB) {
        int numMatches = 0;
        int flags = matchCase ? 0 : 66;
        Pattern pattern = Pattern.compile(searchString, flags);
        Matcher m = pattern.matcher(sb);
        int lastEnd = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            if (wholeWord && !FindDialog.isWholeWord((CharSequence)sb, (int)start, (int)(end - start))) continue;
            replaceSB.append(sb.substring(lastEnd, m.start()));
            replaceSB.append(SearchEngine.getReplacementText((Matcher)m, (CharSequence)replaceString));
            lastEnd = m.end();
            ++numMatches;
        }
        replaceSB.append(sb.substring(lastEnd));
        return numMatches;
    }
}

