/*
 * Decompiled with CFR 0.152.
 */
package net.steppschuh.markdowngenerator.progress;

import net.steppschuh.markdowngenerator.MarkdownElement;
import net.steppschuh.markdowngenerator.MarkdownSerializationException;
import net.steppschuh.markdowngenerator.util.StringUtil;

public class ProgressBar
extends MarkdownElement {
    public static final int LENGTH_SMALL = 15;
    public static final int LENGTH_NORMAL = 20;
    public static final int LENGTH_LARGE = 50;
    public static final char OPENING_CHAR_DEFAULT = '[';
    public static final char CLOSING_CHAR_DEFAULT = ']';
    public static final char FILL_CHAR_DEFAULT = '=';
    public static final char EMPTY_CHAR_DEFAULT = '-';
    private char openingChar = (char)91;
    private char closingChar = (char)93;
    private char fillChar = (char)61;
    private char emptyChar = (char)45;
    private int length = 20;
    private boolean appendValue = false;
    private boolean appendPercentage = false;
    private double value;
    private double minimumValue = 0.0;
    private double maximumValue = 1.0;

    public ProgressBar(double value) {
        this.value = value;
    }

    public ProgressBar(double value, int length) {
        this.value = value;
        this.length = length;
    }

    private void trimValue() {
        this.value = Math.max(this.minimumValue, Math.min(this.maximumValue, this.value));
    }

    @Override
    public String serialize() throws MarkdownSerializationException {
        this.trimValue();
        StringBuilder sb = new StringBuilder().append(this.openingChar);
        int filledCharsCount = ProgressBar.calculateFilledCharsCount(this.value, this.minimumValue, this.maximumValue, this.length);
        for (int charIndex = 0; charIndex < this.length; ++charIndex) {
            sb.append(charIndex < filledCharsCount ? this.fillChar : this.emptyChar);
        }
        sb.append(this.closingChar);
        if (this.appendValue) {
            String readableValue = ProgressBar.getReadableValue(this.value);
            readableValue = StringUtil.fillUpRightAligned(readableValue, " ", 7);
            sb.append(" ").append(readableValue);
        }
        if (this.appendPercentage) {
            String readablePercentage = ProgressBar.getReadablePercentage(this.value, this.minimumValue, this.maximumValue);
            readablePercentage = StringUtil.fillUpRightAligned(readablePercentage, " ", 4);
            sb.append(" (").append(readablePercentage).append(")");
        }
        return sb.toString();
    }

    public static int calculateFilledCharsCount(double value, double minimumValue, double maximumValue, int length) {
        try {
            return (int)Math.round((double)length * value / (maximumValue - minimumValue));
        }
        catch (ArithmeticException e) {
            return 0;
        }
    }

    public static String getReadableValue(double value) {
        if (value >= 1.0 || value == 0.0) {
            return String.valueOf(value);
        }
        return String.format("%.4f", value);
    }

    public static String getReadablePercentage(double value, double minimumValue, double maximumValue) {
        int percentage = ProgressBar.calculateFilledCharsCount(value, minimumValue, maximumValue, 100);
        return percentage + "%";
    }

    public char getOpeningChar() {
        return this.openingChar;
    }

    public void setOpeningChar(char openingChar) {
        this.openingChar = openingChar;
        this.invalidateSerialized();
    }

    public char getClosingChar() {
        return this.closingChar;
    }

    public void setClosingChar(char closingChar) {
        this.closingChar = closingChar;
        this.invalidateSerialized();
    }

    public char getFillChar() {
        return this.fillChar;
    }

    public void setFillChar(char fillChar) {
        this.fillChar = fillChar;
        this.invalidateSerialized();
    }

    public char getEmptyChar() {
        return this.emptyChar;
    }

    public void setEmptyChar(char emptyChar) {
        this.emptyChar = emptyChar;
        this.invalidateSerialized();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
        this.invalidateSerialized();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.invalidateSerialized();
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(double minimumValue) {
        this.minimumValue = minimumValue;
        this.invalidateSerialized();
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(double maximumValue) {
        this.maximumValue = maximumValue;
        this.invalidateSerialized();
    }

    public boolean isAppendingValue() {
        return this.appendValue;
    }

    public void setAppendValue(boolean appendValue) {
        this.appendValue = appendValue;
    }

    public boolean isAppendingPercentage() {
        return this.appendPercentage;
    }

    public void setAppendPercentage(boolean appendPercentage) {
        this.appendPercentage = appendPercentage;
        this.invalidateSerialized();
    }
}

