/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class BaseRadioButtonUI
extends BasicRadioButtonUI {
    private static BaseRadioButtonUI radioButtonUI = null;
    protected static Dimension size = new Dimension();
    protected static Rectangle viewRect = new Rectangle();
    protected static Rectangle iconRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        if (radioButtonUI == null) {
            radioButtonUI = new BaseRadioButtonUI();
        }
        return radioButtonUI;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
        this.icon = UIManager.getIcon("RadioButton.icon");
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        size = b.getSize(size);
        BaseRadioButtonUI.viewRect.x = i.left;
        BaseRadioButtonUI.viewRect.y = i.top;
        BaseRadioButtonUI.viewRect.width = BaseRadioButtonUI.size.width - (i.right + BaseRadioButtonUI.viewRect.x);
        BaseRadioButtonUI.viewRect.height = BaseRadioButtonUI.size.height - (i.bottom + BaseRadioButtonUI.viewRect.y);
        BaseRadioButtonUI.iconRect.height = 0;
        BaseRadioButtonUI.iconRect.width = 0;
        BaseRadioButtonUI.iconRect.y = 0;
        BaseRadioButtonUI.iconRect.x = 0;
        BaseRadioButtonUI.textRect.height = 0;
        BaseRadioButtonUI.textRect.width = 0;
        BaseRadioButtonUI.textRect.y = 0;
        BaseRadioButtonUI.textRect.x = 0;
        Icon altIcon = b.getIcon();
        int iconTextGap = this.getDefaultTextIconGap(b);
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            iconTextGap = b.getIconTextGap();
        }
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, iconTextGap);
        if (c.isOpaque()) {
            this.paintBackground(g, c);
        }
        this.paintIcon(g, c, iconRect);
        if (text != null) {
            this.paintText(g, c, text, textRect);
        }
        if (b.hasFocus() && b.isFocusPainted() && BaseRadioButtonUI.textRect.width > 0 && BaseRadioButtonUI.textRect.height > 0) {
            this.paintFocus(g, textRect, size);
        }
    }

    protected void paintBackground(Graphics g, JComponent c) {
        g.setColor(c.getBackground());
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Icon ico = null;
        ico = !model.isEnabled() ? (b.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon()) : (model.isPressed() ? b.getPressedIcon() : (model.isRollover() ? (b.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon()) : (b.isSelected() ? b.getSelectedIcon() : b.getIcon())));
        if (ico != null) {
            ico.paintIcon(c, g, iconRect.x, iconRect.y - 1);
        } else if (b.getIcon() != null) {
            b.getIcon().paintIcon(c, g, iconRect.x, iconRect.y - 1);
        } else {
            this.getDefaultIcon().paintIcon(c, g, iconRect.x, iconRect.y - 1);
        }
    }

    protected void paintText(Graphics g, JComponent c, String text, Rectangle textRect) {
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            Graphics2D g2D = (Graphics2D)g;
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            v.paint(g, textRect);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        } else {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            Font f = c.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            int mnemIndex = -1;
            mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b.getText(), model.getMnemonic());
            if (model.isEnabled()) {
                g.setColor(b.getForeground());
                JTattooUtilities.drawStringUnderlineCharAt(c, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g.setColor(Color.white);
                JTattooUtilities.drawStringUnderlineCharAt(c, g, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
                g.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                JTattooUtilities.drawStringUnderlineCharAt(c, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
        g.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, t.x, t.y - 1, t.width + 1, t.height + 1);
    }
}

