/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.plaf.basic.BasicArrowButton;

public class BaseScrollButton
extends BasicArrowButton {
    protected int buttonWidth = 24;

    public BaseScrollButton(int direction, int width) {
        super(direction);
        this.buttonWidth = width;
    }

    public void paint(Graphics g) {
        boolean isPressed = this.getModel().isPressed();
        boolean isRollover = this.getModel().isRollover();
        int width = this.getWidth();
        int height = this.getHeight();
        Color[] colors = null;
        colors = isPressed ? AbstractLookAndFeel.getTheme().getPressedColors() : (isRollover ? AbstractLookAndFeel.getTheme().getRolloverColors() : AbstractLookAndFeel.getTheme().getButtonColors());
        boolean inverse = ColorHelper.getGrayValue(colors) < 128;
        Color frameColorHi = ColorHelper.brighter(colors[0], 20.0);
        Color frameColorLo = ColorHelper.darker(colors[colors.length - 1], 20.0);
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        if (this.getDirection() == 1 || this.getDirection() == 5) {
            JTattooUtilities.fillVerGradient(g2D, colors, 0, 0, width, height);
        } else {
            JTattooUtilities.fillHorGradient(g2D, colors, 0, 0, width, height);
        }
        g2D.setComposite(AlphaComposite.getInstance(3, 0.8f));
        if (this.getDirection() == 1) {
            Icon upArrow = inverse ? BaseIcons.getUpArrowInverseIcon() : BaseIcons.getUpArrowIcon();
            int x = width / 2 - upArrow.getIconWidth() / 2;
            int y = height / 2 - upArrow.getIconHeight() / 2 - 1;
            upArrow.paintIcon(this, g2D, x, y);
        } else if (this.getDirection() == 5) {
            Icon downArrow = inverse ? BaseIcons.getDownArrowInverseIcon() : BaseIcons.getDownArrowIcon();
            int x = width / 2 - downArrow.getIconWidth() / 2;
            int y = height / 2 - downArrow.getIconHeight() / 2;
            downArrow.paintIcon(this, g2D, x, y);
        } else if (this.getDirection() == 7) {
            Icon leftArrow = inverse ? BaseIcons.getLeftArrowInverseIcon() : BaseIcons.getLeftArrowIcon();
            int x = width / 2 - leftArrow.getIconWidth() / 2 - 1;
            int y = height / 2 - leftArrow.getIconHeight() / 2;
            leftArrow.paintIcon(this, g2D, x, y);
        } else {
            Icon rightArrow = inverse ? BaseIcons.getRightArrowInverseIcon() : BaseIcons.getRightArrowIcon();
            int x = width / 2 - rightArrow.getIconWidth() / 2;
            int y = height / 2 - rightArrow.getIconHeight() / 2;
            rightArrow.paintIcon(this, g2D, x, y);
        }
        JTattooUtilities.draw3DBorder(g2D, frameColorLo, ColorHelper.darker(frameColorLo, 10.0), 0, 0, width, height);
        g2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g2D.setColor(frameColorHi);
        g2D.drawLine(1, 1, width - 2, 1);
        g2D.drawLine(1, 1, 1, height - 2);
        g2D.setComposite(savedComposite);
    }

    public Dimension getPreferredSize() {
        if (this.getDirection() == 1) {
            return new Dimension(this.buttonWidth, this.buttonWidth + 1);
        }
        if (this.getDirection() == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth + 1);
        }
        if (this.getDirection() == 3) {
            return new Dimension(this.buttonWidth + 1, this.buttonWidth);
        }
        if (this.getDirection() == 7) {
            return new Dimension(this.buttonWidth + 1, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }
}

