/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditorInputFactory;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class DiagramEditorInput
implements IEditorInput,
IPersistableElement,
IDiagramEditorInput {
    public static final String KEY_URI = "org.eclipse.graphiti.uri";
    public static String KEY_PROVIDER_ID = "org.eclipse.graphiti.providerId";
    private URI uri;
    private String providerId;
    private String name;
    private String tooltip;

    public DiagramEditorInput(URI diagramUri, String providerId) {
        Assert.isNotNull((Object)diagramUri, (String)"diagram must not be null");
        this.uri = this.normalizeUriString(diagramUri);
        this.setProviderId(providerId);
    }

    private URI normalizeUriString(URI diagramUri) {
        URI normalizedURI = new ResourceSetImpl().getURIConverter().normalize(diagramUri);
        if (!normalizedURI.hasFragment() || "/".equals(normalizedURI.fragment())) {
            URI trimFragment = normalizedURI.trimFragment();
            normalizedURI = GraphitiUiInternal.getEmfService().mapDiagramFileUriToDiagramUri(trimFragment);
        }
        return normalizedURI;
    }

    public static DiagramEditorInput createEditorInput(Diagram diagram, String providerId) {
        Resource resource = diagram.eResource();
        if (resource == null) {
            throw new IllegalArgumentException("Diagram must be contained within a resource");
        }
        URI diagramUri = EcoreUtil.getURI((EObject)diagram);
        DiagramEditorInput diagramEditorInput = new DiagramEditorInput(diagramUri, providerId);
        return diagramEditorInput;
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getFactoryId() {
        return DiagramEditorInputFactory.class.getName();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.uri.toString();
    }

    protected boolean hasName() {
        return this.name != null;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getToolTipText() {
        if (this.tooltip != null) {
            return this.tooltip;
        }
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class.isAssignableFrom(adapter) || IResource.class.equals((Object)adapter)) {
            return GraphitiUiInternal.getEmfService().getFile(this.getUri());
        }
        return null;
    }

    public void saveState(IMemento memento) {
        boolean exists = this.exists();
        if (!exists) {
            return;
        }
        memento.putString(KEY_URI, this.uri.toString());
        memento.putString(KEY_PROVIDER_ID, this.providerId);
    }

    @Override
    public final String getUriString() {
        return this.uri.toString();
    }

    public boolean exists() {
        return this.uri != null;
    }

    public IPersistableElement getPersistable() {
        if (this.uri != null && this.providerId != null) {
            return this;
        }
        return null;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagramEditorInput other = (DiagramEditorInput)obj;
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        return !(this.providerId == null ? other.providerId != null : !this.providerId.equals(other.providerId));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.providerId == null ? 0 : this.providerId.hashCode());
        return result;
    }

    public String toString() {
        String s = String.valueOf(super.toString()) + " uri: " + this.uri;
        return s;
    }

    @Override
    public void updateUri(URI diagramFileUri) {
        URI normalizedUri;
        URI uri = GraphitiUiInternal.getEmfService().mapDiagramFileUriToDiagramUri(diagramFileUri);
        this.uri = normalizedUri = this.normalizeUriString(uri);
    }
}

