/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.preferences;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.preferences.Messages;
import org.fusesource.ide.preferences.initializer.StagingRepositoriesPreferenceInitializer;

public class StagingRepositoryDialog
extends TitleAreaDialog {
    private Text txtRepositoryName;
    private String strRepositoryName = "";
    private Text txtRepositoryURL;
    private String strRepositoryURL = "";
    private String strUniquenessList = "";
    private Label lblNameErrors;
    private Label lblURLErrors;

    public StagingRepositoryDialog(Shell parentShell) {
        super(parentShell);
        StagingRepositoriesPreferenceInitializer initializer = new StagingRepositoriesPreferenceInitializer();
        this.strUniquenessList = initializer.getStagingRepositoriesString();
    }

    public void create() {
        super.create();
        this.getShell().setText("New Staging Repository");
        this.setTitle(Messages.newStagingRepositoryDialogTitle);
        this.resetMessage();
    }

    private void resetMessage() {
        this.isValid();
        this.setErrorMessage(null);
        this.setMessage(Messages.newRepoDialogMessage, 0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, true);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Label lblName = new Label(container, 0);
        GridData gdlblNewLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblName.setLayoutData((Object)gdlblNewLabel);
        lblName.setText(Messages.repositoryNameField);
        lblName.setToolTipText(Messages.repositoryNameTooltip);
        this.txtRepositoryName = new Text(container, 2048);
        this.txtRepositoryName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtRepositoryName.setText(this.strRepositoryName);
        this.txtRepositoryName.addModifyListener(e -> {
            String nameText;
            Text textWidget = (Text)e.getSource();
            this.strRepositoryName = nameText = textWidget.getText();
            this.isValid();
        });
        this.lblNameErrors = new Label(container, 64);
        GridData gdLblNameErrors = new GridData(4, 4, true, true, 2, 2);
        gdLblNameErrors.minimumHeight = 30;
        this.lblNameErrors.setLayoutData((Object)gdLblNameErrors);
        this.lblNameErrors.setForeground(this.getShell().getDisplay().getSystemColor(3));
        Label lblURL = new Label(container, 0);
        gdlblNewLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblURL.setLayoutData((Object)gdlblNewLabel);
        lblURL.setText(Messages.repositoryURLField);
        lblURL.setToolTipText(Messages.repositoryURLTooltip);
        this.txtRepositoryURL = new Text(container, 2048);
        this.txtRepositoryURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtRepositoryURL.setText(this.strRepositoryURL);
        this.txtRepositoryURL.addModifyListener(e -> {
            String urlText;
            Text textWidget = (Text)e.getSource();
            this.strRepositoryURL = urlText = textWidget.getText();
            this.isValid();
        });
        this.lblURLErrors = new Label(container, 64);
        this.lblURLErrors.setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
        this.lblURLErrors.setForeground(this.getShell().getDisplay().getSystemColor(3));
        return container;
    }

    protected void okPressed() {
        this.strRepositoryURL = this.txtRepositoryURL.getText();
        this.strRepositoryName = this.txtRepositoryName.getText();
        super.okPressed();
    }

    public String getURL() {
        return this.strRepositoryURL;
    }

    public void setURL(String oldURL) {
        this.strRepositoryURL = oldURL;
        if (this.txtRepositoryURL != null && !this.txtRepositoryURL.isDisposed()) {
            this.txtRepositoryURL.setText(this.strRepositoryURL);
        }
    }

    public String getName() {
        return this.strRepositoryName;
    }

    public void setName(String oldName) {
        this.strRepositoryName = oldName;
        if (this.txtRepositoryName != null && !this.txtRepositoryName.isDisposed()) {
            this.txtRepositoryName.setText(this.strRepositoryName);
        }
    }

    private boolean isValidURL(String url) {
        if (Strings.isBlank((String)url)) {
            return false;
        }
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        try {
            u.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        return true;
    }

    private boolean isValidName(String name) {
        return !Strings.isBlank((String)name) && !name.contains(" ") && !name.contains(";") && !name.contains(",");
    }

    public void pressOK() {
        this.okPressed();
    }

    private boolean isValid() {
        boolean isURLValid = this.isValidURL(this.strRepositoryURL);
        boolean isNameValid = this.isValidName(this.strRepositoryName);
        boolean isNameUnique = this.isNameUnique(this.strRepositoryName);
        boolean isValid = isURLValid && isNameValid && isNameUnique;
        this.getButton(0).setEnabled(isValid);
        this.lblNameErrors.setText("");
        this.lblURLErrors.setText("");
        if (!isNameValid) {
            this.setErrorMessage(Messages.newRepoDialogNameInvalid);
            this.lblNameErrors.setText(Messages.newRepoDialogNameInvalid);
            return isNameValid;
        }
        if (!isNameUnique) {
            this.setErrorMessage(Messages.newRepoDialogNameNotUnique);
            this.lblNameErrors.setText(Messages.newRepoDialogNameNotUnique);
            return isNameUnique;
        }
        if (!isURLValid) {
            this.setErrorMessage(Messages.newRepoDialogUrlInvalid);
            this.lblURLErrors.setText(Messages.newRepoDialogUrlInvalid);
            return isURLValid;
        }
        this.setErrorMessage(null);
        return isValid;
    }

    private boolean isNameUnique(String name) {
        StagingRepositoriesPreferenceInitializer initializer = new StagingRepositoriesPreferenceInitializer();
        List<List<String>> repoList = initializer.getStagingRepositoriesAsList(this.strUniquenessList);
        for (List<String> list : repoList) {
            String test = list.get(0);
            if (!test.contentEquals(name)) continue;
            return false;
        }
        return true;
    }

    public String getUniquenessList() {
        return this.strUniquenessList;
    }

    public void setUniquenessList(String list) {
        this.strUniquenessList = list;
    }
}

